<?php
/*
 * Copyright 2021 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/*
 * GENERATED CODE WARNING
 * Generated by gapic-generator-php from the file
 * https://github.com/google/googleapis/blob/master/google/ads/googleads/v9/services/keyword_plan_idea_service.proto
 * Updates to the above are reflected here through a refresh process.
 */

namespace Google\Ads\GoogleAds\V9\Services\Gapic;

use Google\Ads\GoogleAds\V9\Common\HistoricalMetricsOptions;
use Google\Ads\GoogleAds\V9\Common\KeywordPlanAggregateMetrics;

use Google\Ads\GoogleAds\V9\Services\GenerateKeywordIdeaResponse;

use Google\Ads\GoogleAds\V9\Services\GenerateKeywordIdeasRequest;
use Google\Ads\GoogleAds\V9\Services\KeywordAndUrlSeed;
use Google\Ads\GoogleAds\V9\Services\KeywordSeed;
use Google\Ads\GoogleAds\V9\Services\SiteSeed;
use Google\Ads\GoogleAds\V9\Services\UrlSeed;
use Google\ApiCore\ApiException;

use Google\ApiCore\CredentialsWrapper;
use Google\ApiCore\GapicClientTrait;
use Google\ApiCore\RequestParamsHeaderDescriptor;
use Google\ApiCore\RetrySettings;
use Google\ApiCore\Transport\TransportInterface;
use Google\ApiCore\ValidationException;
use Google\Auth\FetchAuthTokenInterface;

/**
 * Service Description: Service to generate keyword ideas.
 *
 * This class provides the ability to make remote calls to the backing service through method
 * calls that map to API methods. Sample code to get started:
 *
 * ```
 * $keywordPlanIdeaServiceClient = new KeywordPlanIdeaServiceClient();
 * try {
 *     // Iterate over pages of elements
 *     $pagedResponse = $keywordPlanIdeaServiceClient->generateKeywordIdeas();
 *     foreach ($pagedResponse->iteratePages() as $page) {
 *         foreach ($page as $element) {
 *             // doSomethingWith($element);
 *         }
 *     }
 *     // Alternatively:
 *     // Iterate through all elements
 *     $pagedResponse = $keywordPlanIdeaServiceClient->generateKeywordIdeas();
 *     foreach ($pagedResponse->iterateAllElements() as $element) {
 *         // doSomethingWith($element);
 *     }
 * } finally {
 *     $keywordPlanIdeaServiceClient->close();
 * }
 * ```
 */
class KeywordPlanIdeaServiceGapicClient
{
    use GapicClientTrait;

    /**
     * The name of the service.
     */
    const SERVICE_NAME = 'google.ads.googleads.v9.services.KeywordPlanIdeaService';

    /**
     * The default address of the service.
     */
    const SERVICE_ADDRESS = 'googleads.googleapis.com';

    /**
     * The default port of the service.
     */
    const DEFAULT_SERVICE_PORT = 443;

    /**
     * The name of the code generator, to be included in the agent header.
     */
    const CODEGEN_NAME = 'gapic';

    /**
     * The default scopes required by the service.
     */
    public static $serviceScopes = [
        'https://www.googleapis.com/auth/adwords',
    ];

    private static function getClientDefaults()
    {
        return [
            'serviceName' => self::SERVICE_NAME,
            'serviceAddress' => self::SERVICE_ADDRESS . ':' . self::DEFAULT_SERVICE_PORT,
            'clientConfig' => __DIR__ . '/../resources/keyword_plan_idea_service_client_config.json',
            'descriptorsConfigPath' => __DIR__ . '/../resources/keyword_plan_idea_service_descriptor_config.php',
            'gcpApiConfigPath' => __DIR__ . '/../resources/keyword_plan_idea_service_grpc_config.json',
            'credentialsConfig' => [
                'defaultScopes' => self::$serviceScopes,
            ],
            'transportConfig' => [
                'rest' => [
                    'restClientConfigPath' => __DIR__ . '/../resources/keyword_plan_idea_service_rest_client_config.php',
                ],
            ],
        ];
    }

    /**
     * Constructor.
     *
     * @param array $options {
     *     Optional. Options for configuring the service API wrapper.
     *
     *     @type string $serviceAddress
     *           The address of the API remote host. May optionally include the port, formatted
     *           as "<uri>:<port>". Default 'googleads.googleapis.com:443'.
     *     @type string|array|FetchAuthTokenInterface|CredentialsWrapper $credentials
     *           The credentials to be used by the client to authorize API calls. This option
     *           accepts either a path to a credentials file, or a decoded credentials file as a
     *           PHP array.
     *           *Advanced usage*: In addition, this option can also accept a pre-constructed
     *           {@see \Google\Auth\FetchAuthTokenInterface} object or
     *           {@see \Google\ApiCore\CredentialsWrapper} object. Note that when one of these
     *           objects are provided, any settings in $credentialsConfig will be ignored.
     *     @type array $credentialsConfig
     *           Options used to configure credentials, including auth token caching, for the
     *           client. For a full list of supporting configuration options, see
     *           {@see \Google\ApiCore\CredentialsWrapper::build()} .
     *     @type bool $disableRetries
     *           Determines whether or not retries defined by the client configuration should be
     *           disabled. Defaults to `false`.
     *     @type string|array $clientConfig
     *           Client method configuration, including retry settings. This option can be either
     *           a path to a JSON file, or a PHP array containing the decoded JSON data. By
     *           default this settings points to the default client config file, which is
     *           provided in the resources folder.
     *     @type string|TransportInterface $transport
     *           The transport used for executing network requests. May be either the string
     *           `rest` or `grpc`. Defaults to `grpc` if gRPC support is detected on the system.
     *           *Advanced usage*: Additionally, it is possible to pass in an already
     *           instantiated {@see \Google\ApiCore\Transport\TransportInterface} object. Note
     *           that when this object is provided, any settings in $transportConfig, and any
     *           $serviceAddress setting, will be ignored.
     *     @type array $transportConfig
     *           Configuration options that will be used to construct the transport. Options for
     *           each supported transport type should be passed in a key for that transport. For
     *           example:
     *           $transportConfig = [
     *               'grpc' => [...],
     *               'rest' => [...],
     *           ];
     *           See the {@see \Google\ApiCore\Transport\GrpcTransport::build()} and
     *           {@see \Google\ApiCore\Transport\RestTransport::build()} methods for the
     *           supported options.
     *     @type callable $clientCertSource
     *           A callable which returns the client cert as a string. This can be used to
     *           provide a certificate and private key to the transport layer for mTLS.
     * }
     *
     * @throws ValidationException
     */
    public function __construct(array $options = [])
    {
        $clientOptions = $this->buildClientOptions($options);
        $this->setClientOptions($clientOptions);
    }

    /**
     * Returns a list of keyword ideas.
     *
     * List of thrown errors:
     * [AuthenticationError]()
     * [AuthorizationError]()
     * [CollectionSizeError]()
     * [HeaderError]()
     * [InternalError]()
     * [KeywordPlanIdeaError]()
     * [QuotaError]()
     * [RequestError]()
     *
     * Sample code:
     * ```
     * $keywordPlanIdeaServiceClient = new KeywordPlanIdeaServiceClient();
     * try {
     *     // Iterate over pages of elements
     *     $pagedResponse = $keywordPlanIdeaServiceClient->generateKeywordIdeas();
     *     foreach ($pagedResponse->iteratePages() as $page) {
     *         foreach ($page as $element) {
     *             // doSomethingWith($element);
     *         }
     *     }
     *     // Alternatively:
     *     // Iterate through all elements
     *     $pagedResponse = $keywordPlanIdeaServiceClient->generateKeywordIdeas();
     *     foreach ($pagedResponse->iterateAllElements() as $element) {
     *         // doSomethingWith($element);
     *     }
     * } finally {
     *     $keywordPlanIdeaServiceClient->close();
     * }
     * ```
     *
     * @param array $optionalArgs {
     *     Optional.
     *
     *     @type string $customerId
     *           The ID of the customer with the recommendation.
     *     @type string $language
     *           The resource name of the language to target.
     *           Required
     *     @type string[] $geoTargetConstants
     *           The resource names of the location to target.
     *           Max 10
     *     @type bool $includeAdultKeywords
     *           If true, adult keywords will be included in response.
     *           The default value is false.
     *     @type string $pageToken
     *           A page token is used to specify a page of values to be returned.
     *           If no page token is specified (the default), the first page
     *           of values will be returned. Any page token used here must have
     *           been generated by a previous call to the API.
     *     @type int $pageSize
     *           The maximum number of resources contained in the underlying API
     *           response. The API may return fewer values in a page, even if
     *           there are additional values to be retrieved.
     *     @type int $keywordPlanNetwork
     *           Targeting network.
     *           For allowed values, use constants defined on {@see \Google\Ads\GoogleAds\V9\Enums\KeywordPlanNetworkEnum\KeywordPlanNetwork}
     *     @type int[] $keywordAnnotation
     *           The keyword annotations to include in response.
     *           For allowed values, use constants defined on {@see \Google\Ads\GoogleAds\V9\Enums\KeywordPlanKeywordAnnotationEnum\KeywordPlanKeywordAnnotation}
     *     @type KeywordPlanAggregateMetrics $aggregateMetrics
     *           The aggregate fields to include in response.
     *     @type HistoricalMetricsOptions $historicalMetricsOptions
     *           The options for historical metrics data.
     *     @type KeywordAndUrlSeed $keywordAndUrlSeed
     *           A Keyword and a specific Url to generate ideas from
     *           e.g. cars, www.example.com/cars.
     *     @type KeywordSeed $keywordSeed
     *           A Keyword or phrase to generate ideas from, e.g. cars.
     *     @type UrlSeed $urlSeed
     *           A specific url to generate ideas from, e.g. www.example.com/cars.
     *     @type SiteSeed $siteSeed
     *           The site to generate ideas from, e.g. www.example.com.
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a
     *           {@see Google\ApiCore\RetrySettings} object, or an associative array of retry
     *           settings parameters. See the documentation on
     *           {@see Google\ApiCore\RetrySettings} for example usage.
     * }
     *
     * @return \Google\ApiCore\PagedListResponse
     *
     * @throws ApiException if the remote call fails
     */
    public function generateKeywordIdeas(array $optionalArgs = [])
    {
        $request = new GenerateKeywordIdeasRequest();
        $requestParamHeaders = [];
        if (isset($optionalArgs['customerId'])) {
            $request->setCustomerId($optionalArgs['customerId']);
            $requestParamHeaders['customer_id'] = $optionalArgs['customerId'];
        }

        if (isset($optionalArgs['language'])) {
            $request->setLanguage($optionalArgs['language']);
        }

        if (isset($optionalArgs['geoTargetConstants'])) {
            $request->setGeoTargetConstants($optionalArgs['geoTargetConstants']);
        }

        if (isset($optionalArgs['includeAdultKeywords'])) {
            $request->setIncludeAdultKeywords($optionalArgs['includeAdultKeywords']);
        }

        if (isset($optionalArgs['pageToken'])) {
            $request->setPageToken($optionalArgs['pageToken']);
        }

        if (isset($optionalArgs['pageSize'])) {
            $request->setPageSize($optionalArgs['pageSize']);
        }

        if (isset($optionalArgs['keywordPlanNetwork'])) {
            $request->setKeywordPlanNetwork($optionalArgs['keywordPlanNetwork']);
        }

        if (isset($optionalArgs['keywordAnnotation'])) {
            $request->setKeywordAnnotation($optionalArgs['keywordAnnotation']);
        }

        if (isset($optionalArgs['aggregateMetrics'])) {
            $request->setAggregateMetrics($optionalArgs['aggregateMetrics']);
        }

        if (isset($optionalArgs['historicalMetricsOptions'])) {
            $request->setHistoricalMetricsOptions($optionalArgs['historicalMetricsOptions']);
        }

        if (isset($optionalArgs['keywordAndUrlSeed'])) {
            $request->setKeywordAndUrlSeed($optionalArgs['keywordAndUrlSeed']);
        }

        if (isset($optionalArgs['keywordSeed'])) {
            $request->setKeywordSeed($optionalArgs['keywordSeed']);
        }

        if (isset($optionalArgs['urlSeed'])) {
            $request->setUrlSeed($optionalArgs['urlSeed']);
        }

        if (isset($optionalArgs['siteSeed'])) {
            $request->setSiteSeed($optionalArgs['siteSeed']);
        }

        $requestParams = new RequestParamsHeaderDescriptor($requestParamHeaders);
        $optionalArgs['headers'] = isset($optionalArgs['headers']) ? array_merge($requestParams->getHeader(), $optionalArgs['headers']) : $requestParams->getHeader();
        return $this->getPagedListResponse('GenerateKeywordIdeas', $optionalArgs, GenerateKeywordIdeaResponse::class, $request);
    }
}
