<?php
namespace MailPoetVendor\Symfony\Component\Validator\Constraints;
if (!defined('ABSPATH')) exit;
use MailPoetVendor\Symfony\Component\Validator\Constraint;
use MailPoetVendor\Symfony\Component\Validator\Exception\ConstraintDefinitionException;
use MailPoetVendor\Symfony\Component\Validator\Exception\InvalidArgumentException;
class Ip extends Constraint
{
 public const V4 = '4';
 public const V6 = '6';
 public const ALL = 'all';
 // adds FILTER_FLAG_NO_PRIV_RANGE flag (skip private ranges)
 public const V4_NO_PRIV = '4_no_priv';
 public const V6_NO_PRIV = '6_no_priv';
 public const ALL_NO_PRIV = 'all_no_priv';
 // adds FILTER_FLAG_NO_RES_RANGE flag (skip reserved ranges)
 public const V4_NO_RES = '4_no_res';
 public const V6_NO_RES = '6_no_res';
 public const ALL_NO_RES = 'all_no_res';
 // adds FILTER_FLAG_NO_PRIV_RANGE and FILTER_FLAG_NO_RES_RANGE flags (skip both)
 public const V4_ONLY_PUBLIC = '4_public';
 public const V6_ONLY_PUBLIC = '6_public';
 public const ALL_ONLY_PUBLIC = 'all_public';
 public const INVALID_IP_ERROR = 'b1b427ae-9f6f-41b0-aa9b-84511fbb3c5b';
 protected static $versions = [self::V4, self::V6, self::ALL, self::V4_NO_PRIV, self::V6_NO_PRIV, self::ALL_NO_PRIV, self::V4_NO_RES, self::V6_NO_RES, self::ALL_NO_RES, self::V4_ONLY_PUBLIC, self::V6_ONLY_PUBLIC, self::ALL_ONLY_PUBLIC];
 protected static $errorNames = [self::INVALID_IP_ERROR => 'INVALID_IP_ERROR'];
 public $version = self::V4;
 public $message = 'This is not a valid IP address.';
 public $normalizer;
 public function __construct($options = null)
 {
 parent::__construct($options);
 if (!\in_array($this->version, self::$versions)) {
 throw new ConstraintDefinitionException(\sprintf('The option "version" must be one of "%s".', \implode('", "', self::$versions)));
 }
 if (null !== $this->normalizer && !\is_callable($this->normalizer)) {
 throw new InvalidArgumentException(\sprintf('The "normalizer" option must be a valid callable ("%s" given).', \is_object($this->normalizer) ? \get_class($this->normalizer) : \gettype($this->normalizer)));
 }
 }
}
