<?php
/**
 * Custom meta fields | Fields
 *
 * @package Betheme
 * @author Muffin group
 * @link https://muffingroup.com
 */

if( ! defined( 'ABSPATH' ) ){
	exit; // Exit if accessed directly
}

if( ! class_exists('Mfn_Builder_Fields') )
{
  class Mfn_Builder_Fields {

		private $options;

    private $sliders;
    private $animations;

    private $section;
    private $wrap;
    private $items;

		private $tabs;
    private $itemtabs;
    private $advanced;

    /**
      * Constructor
      */

    public function __construct() {

      $this->sliders = array(
        'layer' => Mfn_Builder_Helper::get_sliders('layer'),
        'rev' => Mfn_Builder_Helper::get_sliders('rev'),
      );

      $this->options = Mfn_Builder_Helper::get_options();

			// TODO remove

      // wraps&sections tabs
      // $this->tabs = '<ul class="mfn-vb-formrow mfn-vb-mfnuidhere sidebar-panel-content-tabs spct-mfnuidhere"><li data-tab="content-mfnuidhere" class="spct-li-content">Settings</li><li data-tab="advanced-mfnuidhere" class="spct-li-advanced">Advanced</li></ul>';
      // items tabs
      // $this->itemtabs = '<ul class="mfn-vb-formrow mfn-vb-mfnuidhere sidebar-panel-content-tabs spct-mfnuidhere"><li data-tab="content-mfnuidhere" class="spct-li-content">Content</li><li data-tab="style-mfnuidhere" class="spct-li-style">Style</li><li data-tab="advanced-mfnuidhere" class="spct-li-advanced">Advanced</li></ul>';

      $this->set_animations();

      $this->set_advanced();

      $this->set_section();
      $this->set_wrap();
      $this->set_items();

			$this->append_advanced();

    }

    /**
     * SET advanced fields
     */

    public function append_advanced(){

    	// items
    	$items_exclude = array('placeholder');

    	foreach ($this->items as $i=>$it) {
    		foreach($this->advanced as $adv){
    			if( !in_array($i, $items_exclude) ){
    				$this->items[$i]['fields'][] = $adv;
    			}
    		}
    	}
    }

    /**
     * GET section fields
     */

    public function get_section(){

      return $this->section;

    }

    /**
     * GET wrap fields
     */

    public function get_wrap(){

      return $this->wrap;

    }

    /**
     * GET items
     */

    public function get_items(){

      return $this->items;

    }

    /**
     * GET item fields
     */

    public function get_item_fields( $item_type ){

      return $this->items[$item_type];

    }

		/**
		 * GET entrance animations
		 */

		public function get_animations(){

			return $this->animations;

		}

		/**
		 * GET placeholder image
		 */

		public function get_placeholder(){

			return get_theme_file_uri( '/muffin-options/svg/placeholders/image.svg' );

		}

		/**
		 * GET column editor
		 */

		public function get_column_editor(){

			$column_editor = 'textarea'; // codemirror

			if( $this->options['column-visual'] ){
				$column_editor = 'visual';
			}

			return $column_editor;

		}

    /**
     * SET section fields
   	 */

    private function set_section(){

  		$this->section = array(

  			/**
  			 * HEADER additional fields
  			 */

				array(
					'type' => 'html',
					'html' => '<div class="modalbox-card modalbox-re_render modalbox-card-content-mfnuidhere active">',
				),

				/*

				array(
					'class' => 'visible-header-builder',
					'title' => __('Scroll', 'mfn-opts'),
				),

				array(
  				'id' => 'scroll-visibility',
  				'type' => 'select',
  				'class' => 'visible-header-builder',
  				'title' => __('After scroll', 'mfn-opts'),
  				'options' => array(
  					'show' => __('Show', 'mfn-opts'),
  					'hide' => __('Hide', 'mfn-opts'),
  				),
  				'std' => 'show'
  			),

  			array(
					'id' => 'style:.mfn-scrolled .mfn-header-tmpl .mcb-section-mfnuidelement:background-color',
					'type' => 'color',
					'class' => 'visible-header-builder',
					'title' => __('Background color', 'mfn-opts'),
				),

				array(
					'class' => 'visible-header-builder',
					'title' => __('Options', 'mfn-opts'),
				),

				array(
  				'id' => 'closeable',
  				'attr_id' => 'closable-field',
  				'type' => 'select',
  				'class' => 'visible-header-builder',
  				'title' => __('Closeable', 'mfn-opts'),
  				'options' => array(
  					'0' => __('Disabled', 'mfn-opts'),
  					'1' => __('Enabled', 'mfn-opts'),
  				),
  				'std' => '0'
  			),

  			array(
  				'id' => 'closeable-time',
  				'condition' => array( 'id' => 'closable-field', 'opt' => 'is', 'val' => '1' ),
  				'type' => 'text',
  				'class' => 'visible-header-builder narrow',
  				'title' => __('Show again after', 'mfn-opts'),
  				'desc' => __('How many days should it stay hidden after closing?', 'mfn-opts'),
  				'std' => '0',
  				'after' => 'days',
					'param' => 'number',
					'preview' => 'number',
  			),

  			array(
  				'id' => 'closeable-x',
  				'condition' => array( 'id' => 'closable-field', 'opt' => 'is', 'val' => '1' ),
  				'type' => 'switch',
  				'title' => __('Close button position', 'mfn-opts'),
  				'std' => 'right',
  				'options' => array(
  					'left' => __('Left', 'mfn-opts'),
  					'right' => __('Right', 'mfn-opts'),
  				),
  			),

				*/

  			array(
  				'id' => 'title',
  				'class' => 'hidden-header-builder',
  				'type' => 'text',
  				'title' => __('Title', 'mfn-opts'),
  				'desc' => __('Label in admin panel only', 'mfn-opts'),
  			),

  			array(
  				'class' => 'hidden-header-builder',
					'title' => __('Style', 'mfn-opts'),
				),

				array(
  				'class' => 'hidden-header-builder',
  				'id' => 'style',
  				'type' => 'checkbox_pseudo',
  				'title' => __('Style', 'mfn-opts'),
  				'desc' => __('<strong>Notice!</strong> Options grayed out and marked with OLD tag are deprecated and will be removed in the future. Please use <a href="https://support.muffingroup.com/documentation/muffin-live-builder/positioning/" target="_blank">Positioning</a> instead.', 'mfn-opts'),
  				'options' => mfna_section_style(),
  			),

  			// decoration

  			array(
  				'class' => 'hidden-header-builder',
  				'title' => __('Background decoration', 'mfn-opts'),
  			),

  			array(
  				'class' => 'hidden-header-builder',
  				'id' => 'divider',
  				'type' => 'select',
  				'title' => __('Pattern', 'mfn-opts'),
  				'desc' => __('Please select background color in Advanced tab<br />Does <b>not</b> work with parallax and some section styles', 'mfn-opts'),
  				'options' => array(
  					'' => __('None', 'mfn-opts'),
  					'circle up' => __('Circle up', 'mfn-opts'),
  					'square up' => __('Square up', 'mfn-opts'),
  					'triangle up' => __('Triangle up', 'mfn-opts'),
  					'triple-triangle up' => __('Triple triangle up', 'mfn-opts'),
  					'circle down' => __('Circle down', 'mfn-opts'),
  					'square down' => __('Square down', 'mfn-opts'),
  					'triangle down' => __('Triangle down', 'mfn-opts'),
  					'triple-triangle down' => __('Triple triangle down', 'mfn-opts'),
  				),
  			),

  			array(
  				'class' => 'hidden-header-builder',
  				'id' => 'decor_top',
  				'type' => 'upload',
  				'title' => __('Image top', 'mfn-opts'),
  				'desc' => __('for images from <b> Media library</b><br/>Recommended width: 1920px', 'mfn-opts'),
  			),

  			array(
  				'class' => 'hidden-header-builder',
  				'id' => 'decor_bottom',
  				'type' => 'upload',
  				'title' => __('Image bottom', 'mfn-opts'),
					'desc' => __('for images from <b> Media library</b><br/>Recommended width: 1920px', 'mfn-opts'),
  			),

  			// options

  			array(
  				'class' => 'hidden-header-builder',
  				'title' => __('Options', 'mfn-opts'),
  			),

				array(
					'class' => 'hidden-header-builder',
  				'id' => 'navigation',
  				'type' => 'select',
  				'title' => __('Navigation', 'mfn-opts'),
  				'options' => array(
  					'' => __('None', 'mfn-opts'),
  					'arrows' => __('Arrows', 'mfn-opts'),
  				),
  			),

				// hidden attributes

  			array(
  				'id' => 'hide',
  				'type' => 'text',
  				'title' => __('Hide', 'mfn-opts'),
  				'row_class' => 'hidden',
  			),

  			array(
  				'id' => 'collapse',
  				'type' => 'text',
  				'title' => __('Collapse', 'mfn-opts'),
  				'row_class' => 'hidden',
  			),

				// deprecated

  			array(
  				'class' => 'mfn-deprecated',
  				'title' => __('Deprecated', 'mfn-opts'),
  			),

  			array(
  				'id' => 'bg_color',
  				'type' => 'color',
  				'class' => 'mfn-deprecated',
  				'title' => __('Background color', 'mfn-opts'),
  				'alpha' => true,
  			),

  			array(
  				'id' => 'bg_image',
  				'class' => 'mfn-deprecated',
  				'type' => 'upload',
  				'title' => __('Background image', 'mfn-opts'),
  				'desc' => __('Recommended image size <b>1920px x 1080px</b>', 'mfn-opts'),
  			),

  			array(
  				'id' => 'bg_position',
  				'class' => 'mfn-deprecated',
  				'type' => 'select',
  				'title' => __('Background position', 'mfn-opts'),
  				'desc' => __('iOS does <b>not</b> support background-position: fixed<br/>For parallax required background image size is at least 1920px x 1080px', 'mfn-opts'),
  				'options' => mfna_bg_position(),
  				'std' => 'no-repeat;left top;;',
  			),

  			array(
  				'id' => 'bg_size',
  				'class' => 'mfn-deprecated',
  				'type' => 'select',
  				'title' => __('Background size', 'mfn-opts'),
  				'desc' => __('Does <b>not</b> work with position fixed or parallax', 'mfn-opts'),
  				'options' => mfna_bg_size(),
  				'std' => 'auto',
  			),

  			array(
  				'id' => 'padding_top',
  				'class' => 'mfn-deprecated',
  				'type' => 'text',
  				'title' => __('Padding top', 'mfn-opts'),
  				'after' => 'px',
  				'std' => '',
  			),

  			array(
  				'id' => 'padding_bottom',
  				'class' => 'mfn-deprecated',
  				'type' => 'text',
  				'title' => __('Padding bottom', 'mfn-opts'),
  				'after' => 'px',
  				'std' => '',
  			),

  			array(
  				'id' => 'padding_horizontal',
  				'class' => 'mfn-deprecated',
  				'type' => 'text',
  				'title' => __('Padding left & right', 'mfn-opts'),
  				'desc' => __('Use <b>px</b> or <b>%</b>', 'mfn-opts'),
  				'std' => '',
  			),

  			array(
  				'id' => 'visibility',
  				'class' => 'mfn-deprecated',
  				'type' => 'select',
  				'title' => __('Responsive visibility', 'mfn-opts'),
  				'options' => array(
  					'' => __('- Default -', 'mfn-opts'),
  					'hide-desktop' => __('Hide on Desktop | 960px +', 'mfn-opts'),			// 960 +
  					'hide-tablet' => __('Hide on Tablet | 768px - 959px', 'mfn-opts'),		// 768 - 959
  					'hide-mobile' => __('Hide on Mobile | - 768px', 'mfn-opts'),			// - 768
  					'hide-desktop hide-tablet' => __('Hide on Desktop & Tablet', 'mfn-opts'),
  					'hide-desktop hide-mobile' => __('Hide on Desktop & Mobile', 'mfn-opts'),
  					'hide-tablet hide-mobile' => __('Hide on Tablet & Mobile', 'mfn-opts'),
  				),
  				'std' => ''
  			),

  			array(
  				'id' => 'class',
  				'class' => 'mfn-deprecated',
  				'type' => 'pills',
  				'title' => __('Section classes', 'mfn-opts'),
  			),

  			array(
  				'id' => 'section_id',
  				'class' => 'mfn-deprecated',
  				'type' => 'text',
  				'title' => __('Section ID', 'mfn-opts'),
  				'desc' => __('Use this option to create One Page sites<br />Example: Your <b>Section ID</b> is <b>offer</b> and you want to open this section, please use link: <b>your-url/#offer</b>', 'mfn-opts'),
					'param' => 'id',
  			),

  			array(
					'type' => 'html',
					'html' => '</div>', // end: modalbox-card
				),

				array(
					'type' => 'html',
					'html' => '<div class="modalbox-card modalbox-card-advanced modalbox-card-advanced-mfnuidhere">',
				),

				array(
					'class' => 'toggled_header',
					'title' => __('Dimensions', 'mfn-opts'),
				),

				array(
					'id' => 'width_switcher',
					'attr_id' => 'sect_width_switcher',
					'type' => 'select',
					'class' => 'mfn-toggled',
					'title' => __('Width', 'mfn-opts'),
					'options' => array(
  					'default' => __('Default', 'mfn-opts'),
  					'full' 		=> __('Full width', 'mfn-opts'),
  					'custom' 	=> __('Custom', 'mfn-opts'),
  				),
  				'std' => 'default',
				),

				array(
					'id' => 'style:.mcb-section-mfnuidelement.custom-width .section_wrapper:max-width',
					'condition' => array( 'id' => 'sect_width_switcher', 'opt' => 'is', 'val' => 'custom' ),
					'type' => 'text',
					'default_unit' => 'px',
					'class' => 'mfn-toggled narrow',
					'title' => __('Custom width', 'mfn-opts')
				),

				array(
					'id' => 'height_switcher',
					'attr_id' => 'sect_height_switcher',
					'type' => 'select',
					'class' => 'mfn-toggled',
					'title' => __('Height', 'mfn-opts'),
					'options' => array(
  					'default' => __('Default', 'mfn-opts'),
  					'full-screen' => __('Full screen', 'mfn-opts'),
  					'custom' 	=> __('Custom', 'mfn-opts'),
  				),
  				'std' => 'default',
				),

				array(
					'id' => 'style:.mcb-section-mfnuidelement:height',
					'type' => 'text',
					'default_unit' => 'px',
					'condition' => array( 'id' => 'sect_height_switcher', 'opt' => 'is', 'val' => 'custom' ),
					'responsive' => 'desktop',
					'class' => 'mfn_field_desktop mfn-toggled narrow',
					'title' => __('Custom height', 'mfn-opts')
				),

				array(
					'id' => 'style:.mcb-section-mfnuidelement:height_tablet',
					'type' => 'text',
					'default_unit' => 'px',
					'condition' => array( 'id' => 'sect_height_switcher', 'opt' => 'is', 'val' => 'custom' ),
					'responsive' => 'tablet',
					'class' => 'mfn_field_tablet mfn-toggled narrow',
					'title' => __('Custom height', 'mfn-opts')
				),

				array(
					'id' => 'style:.mcb-section-mfnuidelement:height_mobile',
					'type' => 'text',
					'default_unit' => 'px',
					'condition' => array( 'id' => 'sect_height_switcher', 'opt' => 'is', 'val' => 'custom' ),
					'responsive' => 'mobile',
					'class' => 'mfn_field_mobile mfn-toggled narrow',
					'title' => __('Custom height', 'mfn-opts')
				),

  			array(
  				'class' => 'toggled_header',
					'title' => __('Spacing', 'mfn-opts'),
				),

				array(
  				'id' => 'style:.mcb-section-mfnuidelement:padding',
  				'type' => 'dimensions',
  				'version' => 'separated-fields',
  				'title' => __('Padding', 'mfn-opts'),
					'responsive' => 'desktop',
					'class' => 'mfn_field_desktop mfn-toggled',
					'css_attr' => 'padding',
  			),

  			array(
  				'id' => 'style:.mcb-section-mfnuidelement:padding_tablet',
  				'type' => 'dimensions',
  				'version' => 'separated-fields',
  				'title' => __('Padding', 'mfn-opts'),
					'responsive' => 'tablet',
					'class' => 'mfn_field_tablet mfn-toggled',
					'css_attr' => 'padding',
  			),

  			array(
  				'id' => 'style:.mcb-section-mfnuidelement:padding_mobile',
  				'type' => 'dimensions',
  				'version' => 'separated-fields',
  				'title' => __('Padding', 'mfn-opts'),
					'responsive' => 'mobile',
					'class' => 'mfn_field_mobile mfn-toggled',
					'css_attr' => 'padding',
  			),

				array(
  				'id' => 'style:.mcb-section-mfnuidelement:margin',
  				'type' => 'dimensions',
  				'version' => 'separated-fields',
  				'title' => __('Margin', 'mfn-opts'),
					'responsive' => 'desktop',
					'class' => 'mfn_field_desktop mfn-toggled',
					'css_attr' => 'margin',
  			),

  			array(
  				'id' => 'style:.mcb-section-mfnuidelement:margin_tablet',
  				'type' => 'dimensions',
  				'version' => 'separated-fields',
  				'title' => __('Margin', 'mfn-opts'),
					'responsive' => 'tablet',
					'class' => 'mfn_field_tablet mfn-toggled',
					'css_attr' => 'margin',
  			),

  			array(
  				'id' => 'style:.mcb-section-mfnuidelement:margin_mobile',
  				'type' => 'dimensions',
  				'version' => 'separated-fields',
  				'title' => __('Margin', 'mfn-opts'),
					'responsive' => 'mobile',
					'class' => 'mfn_field_mobile mfn-toggled',
					'css_attr' => 'margin',
  			),

  			array(
  				'class' => 'toggled_header',
					'title' => __('Positioning', 'mfn-opts'),
				),

				array(
					'id' => 'style:.mcb-section-mfnuidelement .section_wrapper:align-content',
					'type' => 'radio_img',
					'alias' => 'section-flex-align-content',
					'responsive' => 'desktop',
					'class' => 'form-content-full-width small mfn-toggled mfn_field_desktop',
					'title' => __('Section content position', 'mfn-opts'),
					'options' => array(
						'' => 'Default',
						'flex-start' => 'Top',
						'flex-end' => 'Bottom',
						'center' => 'Center',
					),
					'std' => '',
				),

				array(
					'id' => 'style:.mcb-section-mfnuidelement .section_wrapper:align-content_tablet',
					'type' => 'radio_img',
					'alias' => 'section-flex-align-content',
					'responsive' => 'tablet',
					'class' => 'form-content-full-width small mfn-toggled mfn_field_tablet',
					'title' => __('Section content position', 'mfn-opts'),
					'options' => array(
						'' => 'Default',
						'flex-start' => 'Top',
						'flex-end' => 'Bottom',
						'center' => 'Center',
					),
					'std' => '',
				),

				array(
					'id' => 'style:.mcb-section-mfnuidelement .section_wrapper:align-content_mobile',
					'type' => 'radio_img',
					'alias' => 'section-flex-align-content',
					'responsive' => 'mobile',
					'class' => 'form-content-full-width small mfn-toggled mfn_field_mobile',
					'title' => __('Section content position', 'mfn-opts'),
					'options' => array(
						'' => 'Default',
						'flex-start' => 'Top',
						'flex-end' => 'Bottom',
						'center' => 'Center',
					),
					'std' => '',
				),

				array(
					'id' => 'style:.mcb-section-mfnuidelement .section_wrapper:align-items',
					'type' => 'radio_img',
					'alias' => 'section-flex-align',
					'responsive' => 'desktop',
					'class' => 'form-content-full-width small mfn-toggled mfn_field_desktop adv_align-items_section',
					'title' => __('Wraps vertical spacing', 'mfn-opts'),
					'options' => array(
						'flex-start' => 'Top',
						'flex-end' => 'Bottom',
						'center' => 'Center',
						'stretch' => 'Stretch',
					),
					'std' => '',
				),

				array(
					'id' => 'style:.mcb-section-mfnuidelement .section_wrapper:align-items_tablet',
					'type' => 'radio_img',
					'alias' => 'section-flex-align',
					'responsive' => 'tablet',
					'class' => 'form-content-full-width small mfn-toggled mfn_field_tablet adv_align-items_section',
					'title' => __('Wraps vertical spacing', 'mfn-opts'),
					'options' => array(
						'flex-start' => 'Top',
						'flex-end' => 'Bottom',
						'center' => 'Center',
						'stretch' => 'Stretch',
					),
					'std' => '',
				),

				array(
					'id' => 'style:.mcb-section-mfnuidelement .section_wrapper:align-items_mobile',
					'type' => 'radio_img',
					'alias' => 'section-flex-align',
					'responsive' => 'mobile',
					'class' => 'form-content-full-width small mfn-toggled mfn_field_mobile adv_align-items_section',
					'title' => __('Wraps vertical spacing', 'mfn-opts'),
					'options' => array(
						'flex-start' => 'Top',
						'flex-end' => 'Bottom',
						'center' => 'Center',
						'stretch' => 'Stretch',
					),
					'std' => '',
				),

				array(
					'id' => 'style:.mcb-section-mfnuidelement .section_wrapper:justify-content',
					'type' => 'radio_img',
					'alias' => 'section-flex-justify',
					'responsive' => 'desktop',
					'class' => 'form-content-full-width small mfn-toggled mfn_field_desktop',
					'title' => __('Horizontal align', 'mfn-opts'),
					'options' => [
						'flex-start' => __('Left', 'mfn-opts'),
						'center' => __('Center', 'mfn-opts'),
						'flex-end' => __('Right', 'mfn-opts'),
						'space-between' => __('Space between', 'mfn-opts'),
						'space-around' => __('Space around', 'mfn-opts'),
					],
					'std' => '',
				),

				array(
					'id' => 'style:.mcb-section-mfnuidelement .section_wrapper:justify-content_tablet',
					'type' => 'radio_img',
					'alias' => 'section-flex-justify',
					'responsive' => 'tablet',
					'class' => 'form-content-full-width small mfn-toggled mfn_field_tablet',
					'title' => __('Horizontal align', 'mfn-opts'),
					'options' => [
						'flex-start' => __('Left', 'mfn-opts'),
						'center' => __('Center', 'mfn-opts'),
						'flex-end' => __('Right', 'mfn-opts'),
						'space-between' => __('Space between', 'mfn-opts'),
						'space-around' => __('Space around', 'mfn-opts'),
					],
					'std' => '',
				),

				array(
					'id' => 'style:.mcb-section-mfnuidelement .section_wrapper:justify-content_mobile',
					'type' => 'radio_img',
					'alias' => 'section-flex-justify',
					'responsive' => 'mobile',
					'class' => 'form-content-full-width small mfn-toggled mfn_field_mobile',
					'title' => __('Horizontal align', 'mfn-opts'),
					'options' => [
						'flex-start' => __('Left', 'mfn-opts'),
						'center' => __('Center', 'mfn-opts'),
						'flex-end' => __('Right', 'mfn-opts'),
						'space-between' => __('Space between', 'mfn-opts'),
						'space-around' => __('Space around', 'mfn-opts'),
					],
					'std' => '',
				),

				array(
					'type' => 'helper',
					'class' => 'mfn-toggled',
					'title' => __('Need help', 'mfn-opts'),
					'link' => 'https://support.muffingroup.com/documentation/bebuilder/positioning/#section',
				),

				array(
					'id' => 'style:.mcb-section-mfnuidelement:z-index',
					'type' => 'text',
					'title' => __('Z-index', 'mfn-opts'),
					'param' => 'number',
					'class' => 'narrow mfn-toggled',
					'preview' => 'number',
				),

  			array(
  				'class' => 'toggled_header',
					'title' => __('Background', 'mfn-opts'),
				),

				array(
					'type' => 'html',
					'html' => '<div class="mfn-form-row mfn-sidebar-fields-tabs mfn-toggled mfn-vb-formrow mfn-vb-mfnuidhere"><ul class="mfn-sft-nav"><li class="active"><a href="#normal" data-tab="normal">Normal</a></li><li><a href="#hover" data-tab="hover">Hover</a></li></ul><div class="mfn-sft mfn-sft-normal">',
				),

				array(
					'id' => 'background_switcher',
					'attr_id' => 'background_switcher',
					'type' => 'switch',
					'class' => 'mfn-fields-switcher',
					'title' => __('Background type', 'mfn-opts'),
					'options' => array(
  					'default' => __('Default', 'mfn-opts'),
  					'video' => __('Video', 'mfn-opts'),
  					'gradient' 	=> __('Gradient', 'mfn-opts'),
  				),
					'visual_options' => array(
  					'default' => '',
  					'video' 	=> '',
  					'gradient' 	=> '',
  				),
  				'std' => 'default',
				),

				array(
  				'id' => 'style:.mcb-section-mfnuidelement:gradient',
  				'condition' => array( 'id' => 'background_switcher', 'opt' => 'is', 'val' => 'gradient' ),
  				'type' => 'gradient',
  				'title' => __('Gradient', 'mfn-opts'),
  				'class' => 'mfn-toggled',
					'css_attr' => 'gradient',
  			),

				array(
					'id' => 'style:.mcb-section-mfnuidelement:background-color',
					'condition' => array( 'id' => 'background_switcher', 'opt' => 'is', 'val' => 'default' ),
					'type' => 'color',
					'title' => __('Color', 'mfn-opts'),
				),

				array(
  				'id' => 'style:.mcb-section-mfnuidelement:background-image',
  				'condition' => array( 'id' => 'background_switcher', 'opt' => 'is', 'val' => 'default' ),
  				'oldid' => 'bg_color',
  				'type' => 'upload',
  				'title' => __('Image', 'mfn-opts'),
  				'responsive' => 'desktop',
					'class' => 'mfn_field_desktop',
					'css_attr' => 'background-image',
  			),

				array(
  				'id' => 'bg_video_mp4',
  				'condition' => array( 'id' => 'background_switcher', 'opt' => 'is', 'val' => 'video' ),
  				'class' => 'hidden-header-builder',
  				'type' => 'upload',
  				'title' => __('Video MP4', 'mfn-opts'),
  				'desc' => __('Image will be used as placeholder before video loads and on mobile devices', 'mfn-opts'),
  				'data' => 'video',
  			),

  			array(
  				'id' => 'style:.mcb-section-mfnuidelement:background-image_tablet',
  				'condition' => array( 'id' => 'background_switcher', 'opt' => 'is', 'val' => 'default' ),
  				'oldid' => 'bg_image',
  				'type' => 'upload',
  				'title' => __('Image', 'mfn-opts'),
  				'responsive' => 'tablet',
					'class' => 'mfn_field_tablet',
					'css_attr' => 'background-image',
  			),

  			array(
  				'id' => 'style:.mcb-section-mfnuidelement:background-image_mobile',
  				'condition' => array( 'id' => 'background_switcher', 'opt' => 'is', 'val' => 'default' ),
  				'type' => 'upload',
  				'title' => __('Image', 'mfn-opts'),
  				'responsive' => 'mobile',
					'class' => 'mfn_field_mobile',
					'css_attr' => 'background-image',
  			),

  			array(
					'id' => 'style:.mcb-section-mfnuidelement:background-repeat',
					'condition' => array( 'id' => 'background_switcher', 'opt' => 'is', 'val' => 'default' ),
					'type' => 'select',
					'responsive' => 'desktop',
					'class' => 'mfn_field_desktop',
					'css_attr' => 'background-repeat',
					'title' => __('Repeat', 'mfn-opts'),
					'options' => [
						'' => __('Default', 'mfn-opts'),
						'repeat' => __('Repeat', 'mfn-opts'),
						'no-repeat' => __('No repeat', 'mfn-opts'),
						'repeat-x' => __('Repeat X', 'mfn-opts'),
						'repeat-y' => __('Repeat Y', 'mfn-opts'),
					],
				),

				array(
					'id' => 'style:.mcb-section-mfnuidelement:background-repeat_tablet',
					'condition' => array( 'id' => 'background_switcher', 'opt' => 'is', 'val' => 'default' ),
					'type' => 'select',
					'responsive' => 'tablet',
					'class' => 'mfn_field_tablet',
					'css_attr' => 'background-repeat',
					'title' => __('Repeat', 'mfn-opts'),
					'options' => [
						'' => __('Default', 'mfn-opts'),
						'repeat' => __('Repeat', 'mfn-opts'),
						'no-repeat' => __('No repeat', 'mfn-opts'),
						'repeat-x' => __('Repeat X', 'mfn-opts'),
						'repeat-y' => __('Repeat Y', 'mfn-opts'),
					],
				),

				array(
					'id' => 'style:.mcb-section-mfnuidelement:background-repeat_mobile',
					'condition' => array( 'id' => 'background_switcher', 'opt' => 'is', 'val' => 'default' ),
					'type' => 'select',
					'responsive' => 'mobile',
					'class' => 'mfn_field_mobile',
					'css_attr' => 'background-repeat',
					'title' => __('Repeat', 'mfn-opts'),
					'options' => [
						'' => __('Default', 'mfn-opts'),
						'repeat' => __('Repeat', 'mfn-opts'),
						'no-repeat' => __('No repeat', 'mfn-opts'),
						'repeat-x' => __('Repeat X', 'mfn-opts'),
						'repeat-y' => __('Repeat Y', 'mfn-opts'),
					],
				),

				array(
					'id' => 'style:.mcb-section-mfnuidelement:background-position',
					'condition' => array( 'id' => 'background_switcher', 'opt' => 'is', 'val' => 'default' ),
					'oldid' => 'bg_position',
					'type' => 'select',
					'responsive' => 'desktop',
					'class' => 'mfn_field_desktop',
					'css_attr' => 'background-position',
					'title' => __('Position', 'mfn-opts'),
					'options' => [
						'' => __('Default', 'mfn-opts'),
						'center' => __('Center Center', 'mfn-opts'),
						'center left' => __('Center Left', 'mfn-opts'),
						'center right' => __('Center Right', 'mfn-opts'),
						'top left' => __('Top Left', 'mfn-opts'),
						'top right' => __('Top Right', 'mfn-opts'),
						'top center' => __('Top Center', 'mfn-opts'),
						'bottom left' => __('Bottom Left', 'mfn-opts'),
						'bottom right' => __('Bottom Right', 'mfn-opts'),
						'bottom center' => __('Bottom Center', 'mfn-opts'),
					],
				),

				array(
					'id' => 'style:.mcb-section-mfnuidelement:background-position_tablet',
					'condition' => array( 'id' => 'background_switcher', 'opt' => 'is', 'val' => 'default' ),
					'oldid' => 'bg_position',
					'type' => 'select',
					'responsive' => 'tablet',
					'class' => 'mfn_field_tablet',
					'css_attr' => 'background-position',
					'title' => __('Position', 'mfn-opts'),
					'options' => [
						'' => __('Default', 'mfn-opts'),
						'center' => __('Center Center', 'mfn-opts'),
						'center left' => __('Center Left', 'mfn-opts'),
						'center right' => __('Center Right', 'mfn-opts'),
						'top left' => __('Top Left', 'mfn-opts'),
						'top right' => __('Top Right', 'mfn-opts'),
						'top center' => __('Top Center', 'mfn-opts'),
						'bottom left' => __('Bottom Left', 'mfn-opts'),
						'bottom right' => __('Bottom Right', 'mfn-opts'),
						'bottom center' => __('Bottom Center', 'mfn-opts'),
					],
				),

				array(
					'id' => 'style:.mcb-section-mfnuidelement:background-position_mobile',
					'condition' => array( 'id' => 'background_switcher', 'opt' => 'is', 'val' => 'default' ),
					'oldid' => 'bg_position',
					'type' => 'select',
					'responsive' => 'mobile',
					'class' => 'mfn_field_mobile',
					'css_attr' => 'background-position',
					'title' => __('Position', 'mfn-opts'),
					'options' => [
						'' => __('Default', 'mfn-opts'),
						'center' => __('Center Center', 'mfn-opts'),
						'center left' => __('Center Left', 'mfn-opts'),
						'center right' => __('Center Right', 'mfn-opts'),
						'top left' => __('Top Left', 'mfn-opts'),
						'top right' => __('Top Right', 'mfn-opts'),
						'top center' => __('Top Center', 'mfn-opts'),
						'bottom left' => __('Bottom Left', 'mfn-opts'),
						'bottom right' => __('Bottom Right', 'mfn-opts'),
						'bottom center' => __('Bottom Center', 'mfn-opts'),
					],
				),

				array(
					'id' => 'style:.mcb-section-mfnuidelement:background-attachment',
					'condition' => array( 'id' => 'background_switcher', 'opt' => 'is', 'val' => 'default' ),
					'type' => 'select',
					'responsive' => 'desktop',
					'class' => 'mfn_field_desktop',
					'css_attr' => 'background-attachment',
					'title' => __('Attachment', 'mfn-opts'),
					'options' => [
						'' => __('Default', 'mfn-opts'),
						'scroll' => __('Scroll', 'mfn-opts'),
						'fixed' => __('Fixed', 'mfn-opts'),
						'parallax' => __('Parallax', 'mfn-opts'),
					],
				),

				array(
					'id' => 'style:.mcb-section-mfnuidelement:background-attachment_tablet',
					'condition' => array( 'id' => 'background_switcher', 'opt' => 'is', 'val' => 'default' ),
					'type' => 'select',
					'responsive' => 'tablet',
					'class' => 'mfn_field_tablet',
					'css_attr' => 'background-attachment',
					'title' => __('Attachment', 'mfn-opts'),
					'desc' => __('iOS does <b>not</b> support background-attachment: fixed', 'mfn-opts'),
					'options' => [
						'' => __('Default', 'mfn-opts'),
						'scroll' => __('Scroll', 'mfn-opts'),
						'fixed' => __('Fixed', 'mfn-opts'),
						'parallax' => __('Parallax', 'mfn-opts'),
					],
				),

				array(
					'id' => 'style:.mcb-section-mfnuidelement:background-attachment_mobile',
					'condition' => array( 'id' => 'background_switcher', 'opt' => 'is', 'val' => 'default' ),
					'type' => 'select',
					'responsive' => 'mobile',
					'class' => 'mfn_field_mobile',
					'css_attr' => 'background-attachment',
					'title' => __('Attachment', 'mfn-opts'),
					'desc' => __('iOS does <b>not</b> support background-attachment: fixed', 'mfn-opts'),
					'options' => [
						'' => __('Default', 'mfn-opts'),
						'scroll' => __('Scroll', 'mfn-opts'),
						'fixed' => __('Fixed', 'mfn-opts'),
						'parallax' => __('Parallax', 'mfn-opts'),
					],
				),

				array(
					'id' => 'style:.mcb-section-mfnuidelement:background-size',
					'condition' => array( 'id' => 'background_switcher', 'opt' => 'is', 'val' => 'default' ),
					'oldid' => 'bg_size',
					'type' => 'select',
					'responsive' => 'desktop',
					'class' => 'mfn_field_desktop',
					'css_attr' => 'background-size',
					'title' => __('Size', 'mfn-opts'),
					'options' => mfna_bg_size()
				),

				array(
					'id' => 'style:.mcb-section-mfnuidelement:background-size_tablet',
					'condition' => array( 'id' => 'background_switcher', 'opt' => 'is', 'val' => 'default' ),
					'oldid' => 'bg_size',
					'type' => 'select',
					'responsive' => 'tablet',
					'class' => 'mfn_field_tablet',
					'css_attr' => 'background-size',
					'title' => __('Size', 'mfn-opts'),
					'options' => mfna_bg_size()
				),

				array(
					'id' => 'style:.mcb-section-mfnuidelement:background-size_mobile',
					'condition' => array( 'id' => 'background_switcher', 'opt' => 'is', 'val' => 'default' ),
					'oldid' => 'bg_size',
					'type' => 'select',
					'responsive' => 'mobile',
					'class' => 'mfn_field_mobile',
					'css_attr' => 'background-size',
					'title' => __('Size', 'mfn-opts'),
					'options' => mfna_bg_size()
				),

				array(
					'type' => 'html',
					'html' => '</div><div class="mfn-sft mfn-sft-hover">',
				),

				array(
					'id' => 'style:.mcb-section-mfnuidelement:transition',
					'type' => 'sliderbar',
					'title' => __('Transition duration', 'mfn-opts'),
					'param' => array(
						'min' => '0',
						'max' => '3',
						'step' => '0.1',
						'unit' => 's',
					)
				),

				array(
					'id' => 'background_switcher_hover',
					'attr_id' => 'background_switcher_hover',
					'type' => 'switch',
					'class' => 'mfn-fields-switcher',
					'title' => __('Background type', 'mfn-opts'),
					'options' => array(
  					'default' => __('Default', 'mfn-opts'),
  					'gradient' 	=> __('Gradient', 'mfn-opts'),
  				),
					'visual_options' => array(
  					'default' => '',
  					'gradient' 	=> '',
  				),
  				'std' => 'default',
				),

				array(
  				'id' => 'style:.mcb-section-mfnuidelement|hover:gradient',
  				'condition' => array( 'id' => 'background_switcher_hover', 'opt' => 'is', 'val' => 'gradient' ),
  				'type' => 'gradient',
  				'title' => __('Gradient', 'mfn-opts'),
  				'class' => 'mfn-toggled',
					'css_attr' => 'gradient',
  			),

				array(
					'id' => 'style:.mcb-section-mfnuidelement|hover:background-color',
					'condition' => array( 'id' => 'background_switcher_hover', 'opt' => 'is', 'val' => 'default' ),
					'type' => 'color',
					'title' => __('Color', 'mfn-opts'),
				),

				array(
  				'id' => 'style:.mcb-section-mfnuidelement|hover:background-image',
  				'condition' => array( 'id' => 'background_switcher_hover', 'opt' => 'is', 'val' => 'default' ),
  				'oldid' => 'bg_color',
  				'type' => 'upload',
  				'title' => __('Image', 'mfn-opts'),
  				'responsive' => 'desktop',
					'class' => 'mfn_field_desktop',
					'css_attr' => 'background-image',
  			),

				array(
					'type' => 'html',
					'html' => '</div></div>', // end: mfn-sidebar-fields-tabs
				),

				array(
					'class' => 'toggled_header',
					'title' => __('Border', 'mfn-opts'),
				),

				array(
					'id' => 'style:.mcb-section-mfnuidelement:border-style',
					'attr_id' => 'border_style',
					'type' => 'select',
					'class' => 'mfn-toggled',
					'title' => __('Border style', 'mfn-opts'),
					'options' => [
						'none' => __('None', 'mfn-opts'),
						'solid' => __('Solid', 'mfn-opts'),
						'dashed' => __('Dashed', 'mfn-opts'),
						'dotted' => __('Dotted', 'mfn-opts'),
						'double' => __('Double', 'mfn-opts'),
					],
				),

				array(
					'id' => 'style:.mcb-section-mfnuidelement:border-color',
					'condition' => array( 'id' => 'border_style', 'opt' => 'isnt', 'val' => 'none' ),
					'type' => 'color',
					'class' => 'mfn-toggled',
					'title' => __('Border color', 'mfn-opts'),
				),

				array(
  				'id' => 'style:.mcb-section-mfnuidelement:border-width',
  				'condition' => array( 'id' => 'border_style', 'opt' => 'isnt', 'val' => 'none' ),
  				'type' => 'dimensions',
  				'title' => __('Border width', 'mfn-opts'),
					'responsive' => 'desktop',
					'class' => 'mfn_field_desktop mfn-toggled',
					'css_attr' => 'border-width',
  			),

  			array(
  				'id' => 'style:.mcb-section-mfnuidelement:border-width_tablet',
  				'condition' => array( 'id' => 'border_style', 'opt' => 'isnt', 'val' => 'none' ),
  				'type' => 'dimensions',
  				'title' => __('Border width', 'mfn-opts'),
					'responsive' => 'tablet',
					'class' => 'mfn_field_tablet mfn-toggled',
					'css_attr' => 'border-width',
  			),

  			array(
  				'id' => 'style:.mcb-section-mfnuidelement:border-width_mobile',
  				'condition' => array( 'id' => 'border_style', 'opt' => 'isnt', 'val' => 'none' ),
  				'type' => 'dimensions',
  				'title' => __('Border width', 'mfn-opts'),
					'responsive' => 'mobile',
					'class' => 'mfn_field_mobile mfn-toggled',
					'css_attr' => 'border-width',
  			),

				array(
  				'id' => 'style:.mcb-section-mfnuidelement:border-radius',
  				'type' => 'dimensions',
  				'title' => __('Border radius', 'mfn-opts'),
					'responsive' => 'desktop',
					'class' => 'mfn_field_desktop mfn-toggled',
					'css_attr' => 'border-radius',
  			),

  			array(
  				'id' => 'style:.mcb-section-mfnuidelement:border-radius_tablet',
  				'type' => 'dimensions',
  				'title' => __('Border radius', 'mfn-opts'),
					'responsive' => 'tablet',
					'class' => 'mfn_field_tablet mfn-toggled',
					'css_attr' => 'border-radius',
  			),

  			array(
  				'id' => 'style:.mcb-section-mfnuidelement:border-radius_mobile',
  				'type' => 'dimensions',
  				'title' => __('Border radius', 'mfn-opts'),
					'responsive' => 'mobile',
					'class' => 'mfn_field_mobile mfn-toggled',
					'css_attr' => 'border-radius',
  			),


  			array(
					'class' => 'toggled_header',
					'title' => __('Responsive', 'mfn-opts'),
				),

				array(
  				'id' => 'visibility',
  				'iconinfo' => 'https://support.muffingroup.com/video-tutorials/section-responsive-visibility/',
  				'type' => 'switch',
  				'invert' => true,
  				'version' => 'multiple',
  				'class' => 'mfn-toggled',
  				'title' => __('Responsive visibility', 'mfn-opts'),
  				'active_tooltip' => array(
  					'hide-desktop' => __('Show on Desktop', 'mfn-opts'),
  					'hide-tablet' => __('Show on Tablet', 'mfn-opts'),
  					'hide-mobile' => __('Show on Mobile', 'mfn-opts'),
  				),
  				'options' => array(
  					'hide-desktop' => __('Hide on Desktop', 'mfn-opts'),			// 960 +
  					'hide-tablet' => __('Hide on Tablet', 'mfn-opts'),		// 768 - 959
  					'hide-mobile' => __('Hide on Mobile', 'mfn-opts'),			// - 768
  				),
  				'visual_options' => array(
  					'hide-desktop' => '<svg id="Layer_1" data-name="Layer 1" xmlns="http://www.w3.org/2000/svg" viewBox="0 0 22 22"><defs><style>.cls-1{fill:none;stroke:#304050;stroke-linecap:round;stroke-linejoin:round;stroke-width:1.5px;}.cls-2{fill:#304050;}</style></defs><path class="cls-1" d="M4.94,5H17.06a.93.93,0,0,1,.94.91v7.18a.93.93,0,0,1-.94.91H4.94A.93.93,0,0,1,4,13.09V5.91A.93.93,0,0,1,4.94,5Z"/><path class="cls-1" d="M7,17h8"/><path class="cls-2" d="M13,15.51a1.58,1.58,0,0,0,.7,1.26L14,17H8l.3-.23A1.58,1.58,0,0,0,9,15.51V14h4Z"/></svg>',			// 960 +
  					'hide-tablet' => '<svg id="Layer_1" data-name="Layer 1" xmlns="http://www.w3.org/2000/svg" viewBox="0 0 22 22"><defs><style>.cls-1{fill:none;stroke:#304050;stroke-linecap:round;stroke-linejoin:round;stroke-width:1.5px;}</style></defs><path class="cls-1" d="M7,15.83V7.17A1.21,1.21,0,0,1,8.25,6h5.5A1.21,1.21,0,0,1,15,7.17v8.66A1.21,1.21,0,0,1,13.75,17H8.25A1.21,1.21,0,0,1,7,15.83Z"/></svg>',		// 768 - 959
  					'hide-mobile' => '<svg id="Layer_1" data-name="Layer 1" xmlns="http://www.w3.org/2000/svg" viewBox="0 0 22 22"><defs><style>.cls-1{fill:none;stroke:#304050;stroke-linecap:round;stroke-linejoin:round;stroke-width:1.5px;}.cls-2{fill:#304050;}</style></defs><path class="cls-1" d="M8,15.82V8.18A1.08,1.08,0,0,1,8.94,7h4.12A1.08,1.08,0,0,1,14,8.18v7.64A1.08,1.08,0,0,1,13.06,17H8.94A1.08,1.08,0,0,1,8,15.82Z"/><circle class="cls-2" cx="11" cy="14" r="1"/></svg>',			// - 768
  				),
  			),

  			array(
  				'id' => 'reverse_order',
  				'class' => 'mfn-toggled',
  				'type' => 'switch',
  				'iconinfo' => 'https://support.muffingroup.com/how-to/how-to-reverse-the-order-of-elements-on-mobile/',
  				'title' => __('Order on mobile', 'mfn-opts'),
					'options' => [
						0 => __('Default', 'mfn-opts'),
						1 => __('Reverse rows', 'mfn-opts'),
						2 => __('Reverse columns', 'mfn-opts'),
					],
					'std' => 0,
  			),

				array(
					'class' => 'toggled_header',
					'title' => __('Custom', 'mfn-opts'),
				),

				array(
  				'id' => 'classes',
  				'oldid' => 'class',
  				'class' => 'mfn-toggled',
  				'type' => 'pills',
  				'title' => __('Classes', 'mfn-opts'),
  			),

  			array(
  				'id' => 'custom_id',
  				'oldid' => 'section_id',
  				'class' => 'mfn-toggled',
  				'type' => 'text',
  				'title' => __('ID', 'mfn-opts'),
  			),

  			array(
  				'id' => 'custom_css',
  				'oldid' => 'style',
  				'class' => 'mfn-toggled',
  				'type' => 'textarea',
  				'title' => __('Additional CSS', 'mfn-opts'),
  			),

  			array(
					'type' => 'html',
					'html' => '</div>', // end: modalbox-card
				)

  		);

  	}

    /**
     * SET wrap fields
   	 */

    private function set_wrap()
  	{
  		$this->wrap = array(

  			/**
  			 * HEADER additional fields
  			* */

  			array(
					'type' => 'html',
					'html' => $this->tabs,
				),

				array(
					'type' => 'html',
					'html' => '<div class="modalbox-card modalbox-re_render modalbox-card-content-mfnuidhere active">',
				),

				// options

				array(
					'class' => 'hidden-header-builder',
					'title' => __('Options', 'mfn-opts'),
				),

  			array(
  				'id' => 'sticky',
  				'attr_id' => 'wrap_sticky_desktop',
  				'class' => 'hidden-header-builder mfn_field_desktop',
  				'type' => 'switch',
  				'responsive' => 'desktop',
  				'title' => __('Sticky', 'mfn-opts'),
  				'desc' => __('Does <b>not</b> work with Move up and Parallax', 'mfn-opts'),
					'options' => [
						0 => __('Disable', 'mfn-opts'),
						1 => __('Enable', 'mfn-opts'),
					],
					'std' => 0,
  			),

  			array(
  				'id' => 'tablet_sticky',
  				'attr_id' => 'wrap_sticky_tablet',
  				'class' => 'hidden-header-builder mfn_field_tablet',
  				'type' => 'switch',
  				'responsive' => 'tablet',
  				'title' => __('Sticky', 'mfn-opts'),
  				'desc' => __('Does <b>not</b> work with Move up and Parallax', 'mfn-opts'),
					'options' => [
						0 => __('Disable', 'mfn-opts'),
						1 => __('Enable', 'mfn-opts'),
					],
					'std' => 0,
  			),

  			array(
  				'id' => 'mobile_sticky',
  				'attr_id' => 'wrap_sticky_mobile',
  				'class' => 'hidden-header-builder mfn_field_mobile',
  				'type' => 'switch',
  				'responsive' => 'mobile',
  				'title' => __('Sticky', 'mfn-opts'),
  				'desc' => __('Does <b>not</b> work with Move up and Parallax', 'mfn-opts'),
					'options' => [
						0 => __('Disable', 'mfn-opts'),
						1 => __('Enable', 'mfn-opts'),
					],
					'std' => 0,
  			),

				// deprecated

				array(
					'class' => 'hidden-header-builder mfn-deprecated',
					'title' => __('Deprecated', 'mfn-opts'),
				),

				array(
  				'id' => 'bg_color',
  				'class' => 'mfn-deprecated',
  				'type' => 'color',
  				'title' => __('Background color', 'mfn-opts'),
  				'alpha' => true,
  			),

  			array(
  				'id' => 'bg_image',
  				'class' => 'mfn-deprecated',
  				'type' => 'upload',
  				'title' => __('Background image', 'mfn-opts'),
  				'desc' => __('Recommended image width <b>320px - 1920px</b> depending on size of the wrap', 'mfn-opts'),
  			),

  			array(
  				'id' => 'bg_position',
  				'class' => 'mfn-deprecated',
  				'type' => 'select',
  				'title' => __('Background position', 'mfn-opts'),
					'desc' => __('iOS does <b>not</b> support background-position: fixed<br/>For parallax required background image size is at least 1920px x 1080px', 'mfn-opts'),
  				'options' => mfna_bg_position(),
  				'std' => 'no-repeat;left top;;',
  			),

  			array(
  				'id' => 'bg_size',
  				'class' => 'mfn-deprecated',
  				'type' => 'select',
  				'title' => __('Background size', 'mfn-opts'),
					'desc' => __('Does <b>not</b> work with position fixed or parallax', 'mfn-opts'),
  				'options' => mfna_bg_size(),
  				'std' => 'auto',
  			),

  			array(
  				'id' => 'move_up',
  				'class' => 'mfn-deprecated',
  				'type' => 'text',
  				'title' => __('Move up', 'mfn-opts'),
  				'desc' => __('Move this wrap to overflow on previous section. Does <b>not</b> work with parallax', 'mfn-opts'),
  				'after' => 'px',
  			),

  			array(
  				'id' => 'padding',
  				'class' => 'mfn-deprecated',
  				'type' => 'text',
  				'title' => __('Padding', 'mfn-opts'),
  				'desc' => __('Use value with <b>px</b> or <b>%</b><br />Example: 20px or 20px 10px 20px 10px or 20px 1%', 'mfn-opts'),
  			),

  			array(
  				'id' => 'column_margin',
  				'class' => 'mfn-deprecated',
  				'type' => 'select',
  				'title' => __('Elements margin bottom', 'mfn-opts'),
  				'options' => array(
  					'' => __('- Default -', 'mfn-opts'),
  					'0px' => '0px',
  					'10px' => '10px',
  					'20px' => '20px',
  					'30px' => '30px',
  					'40px' => '40px',
  					'50px' => '50px',
  				),
  			),

				array(
  				'id' => 'vertical_align',
  				'class' => 'mfn-deprecated',
  				'type' => 'select',
  				'title' => __('Elements vertical align', 'mfn-opts'),
  				'desc' => __('for Section style: <b>Equal height of wraps</b>', 'mfn-opts'),
  				'options' => array(
  					'top' => __('Top', 'mfn-opts'),
  					'middle' => __('Middle', 'mfn-opts'),
  					'bottom' => __('Bottom', 'mfn-opts'),
  				),
					'std' => 'top',
  			),

				array(
					'id' => 'class',
					'type' => 'pills',
					'title' => __('Wrap classes', 'mfn-opts'),
					'class' => 'mfn-deprecated',
				),

				array(
					'id' => 'style',
					'type' => 'textarea',
					'title' => __('Wrap inline CSS', 'mfn-opts'),
					'desc' => __('Example: <b>border: 1px solid #999;</b>', 'mfn-opts'),
					'class' => 'mfn-deprecated',
				),

				array(
					'type' => 'html',
					'html' => '</div>',
				),

				array(
					'type' => 'html',
					'html' => '<div class="modalbox-card modalbox-card-advanced modalbox-card-advanced-mfnuidhere">',
				),

				array(
					'class' => 'toggled_header',
					'title' => __('Dimensions', 'mfn-opts'),
				),

				array(
					'id' => 'width_switcher',
					'attr_id' => 'wrap_width_switcher',
					'type' => 'select',
					'class' => 'mfn-toggled',
					'title' => __('Width', 'mfn-opts'),
					'options' => array(
  					'default' => __('Default', 'mfn-opts'),
  					'custom' 	=> __('Custom', 'mfn-opts'),
  				),
  				'std' => 'default',
				),

				array(
					'id' => 'style:.mcb-section .mcb-wrap-mfnuidelement:flex',
					'type' => 'text',
					'condition' => array( 'id' => 'wrap_width_switcher', 'opt' => 'is', 'val' => 'custom' ),
					'responsive' => 'desktop',
					'default_unit' => 'px',
					'class' => 'mfn_field_desktop mfn-toggled advanced_flex',
					'title' => __('Width', 'mfn-opts'),
					'desc' => __('Use px, %, vw, vh or auto to set content width', 'mfn-opts'),
				),

				array(
					'id' => 'style:.mcb-section .mcb-wrap-mfnuidelement:flex_tablet',
					'type' => 'text',
					'condition' => array( 'id' => 'wrap_width_switcher', 'opt' => 'is', 'val' => 'custom' ),
					'responsive' => 'tablet',
					'default_unit' => 'px',
					'class' => 'mfn_field_tablet mfn-toggled advanced_flex',
					'title' => __('Width', 'mfn-opts'),
					'desc' => __('Use px, %, vw, vh or auto to set content width', 'mfn-opts'),
				),

				array(
					'id' => 'style:.mcb-section .mcb-wrap-mfnuidelement:flex_mobile',
					'type' => 'text',
					'condition' => array( 'id' => 'wrap_width_switcher', 'opt' => 'is', 'val' => 'custom' ),
					'responsive' => 'mobile',
					'default_unit' => 'px',
					'class' => 'mfn_field_mobile mfn-toggled advanced_flex',
					'title' => __('Width', 'mfn-opts'),
					'desc' => __('Use px, %, vw, vh or auto to set content width', 'mfn-opts'),
				),

				array(
					'id' => 'height_switcher',
					'attr_id' => 'wrap_height_switcher',
					'type' => 'select',
					'class' => 'mfn-toggled',
					'title' => __('Height', 'mfn-opts'),
					'options' => array(
  					'default' => __('Default', 'mfn-opts'),
  					'custom' 	=> __('Custom', 'mfn-opts'),
  				),
  				'std' => 'default',
				),

				array(
					'id' => 'style:.mcb-section .mcb-wrap-mfnuidelement .mcb-wrap-inner:height',
					'type' => 'text',
					'default_unit' => 'px',
					'condition' => array( 'id' => 'wrap_height_switcher', 'opt' => 'is', 'val' => 'custom' ),
					'responsive' => 'desktop',
					'class' => 'mfn_field_desktop mfn-toggled adv_height_wrap',
					'title' => __('Height', 'mfn-opts')
				),

				array(
					'id' => 'style:.mcb-section .mcb-wrap-mfnuidelement .mcb-wrap-inner:height_tablet',
					'type' => 'text',
					'default_unit' => 'px',
					'condition' => array( 'id' => 'wrap_height_switcher', 'opt' => 'is', 'val' => 'custom' ),
					'responsive' => 'tablet',
					'class' => 'mfn_field_tablet mfn-toggled adv_height_wrap',
					'title' => __('Height', 'mfn-opts')
				),

				array(
					'id' => 'style:.mcb-section .mcb-wrap-mfnuidelement .mcb-wrap-inner:height_mobile',
					'type' => 'text',
					'default_unit' => 'px',
					'condition' => array( 'id' => 'wrap_height_switcher', 'opt' => 'is', 'val' => 'custom' ),
					'responsive' => 'mobile',
					'class' => 'mfn_field_mobile mfn-toggled adv_height_wrap',
					'title' => __('Height', 'mfn-opts')
				),

  			array(
  				'class' => 'toggled_header',
						'title' => __('Spacing', 'mfn-opts'),
					),

					array(
  				'id' => 'style:.mcb-section .mcb-wrap-mfnuidelement .mcb-wrap-inner:padding',
  				'type' => 'dimensions',
  				'version' => 'separated-fields',
  				'title' => __('Padding', 'mfn-opts'),
					'responsive' => 'desktop',
					'class' => 'mfn_field_desktop mfn-toggled',
					'css_attr' => 'padding',
  			),

  			array(
  				'id' => 'style:.mcb-section .mcb-wrap-mfnuidelement .mcb-wrap-inner:padding_tablet',
  				'type' => 'dimensions',
  				'version' => 'separated-fields',
  				'title' => __('Padding', 'mfn-opts'),
					'responsive' => 'tablet',
					'class' => 'mfn_field_tablet mfn-toggled',
					'css_attr' => 'padding',
  			),

  			array(
  				'id' => 'style:.mcb-section .mcb-wrap-mfnuidelement .mcb-wrap-inner:padding_mobile',
  				'type' => 'dimensions',
  				'version' => 'separated-fields',
  				'title' => __('Padding', 'mfn-opts'),
					'responsive' => 'mobile',
					'class' => 'mfn_field_mobile mfn-toggled',
					'css_attr' => 'padding',
  			),

				array(
  				'id' => 'style:.mcb-section .mcb-wrap-mfnuidelement .mcb-wrap-inner:margin',
  				'oldid' => 'move_up',
  				'version' => 'separated-fields',
  				'type' => 'dimensions',
  				'title' => __('Margin', 'mfn-opts'),
					'responsive' => 'desktop',
					'class' => 'mfn_field_desktop mfn-toggled advanced_margin',
					'css_attr' => 'margin',
  			),

  			array(
  				'id' => 'style:.mcb-section .mcb-wrap-mfnuidelement .mcb-wrap-inner:margin_tablet',
  				'oldid' => 'move_up',
  				'version' => 'separated-fields',
  				'type' => 'dimensions',
  				'title' => __('Margin', 'mfn-opts'),
					'responsive' => 'tablet',
					'class' => 'mfn_field_tablet mfn-toggled advanced_margin',
					'css_attr' => 'margin',
  			),

  			array(
  				'id' => 'style:.mcb-section .mcb-wrap-mfnuidelement .mcb-wrap-inner:margin_mobile',
  				'oldid' => 'move_up',
  				'version' => 'separated-fields',
  				'type' => 'dimensions',
  				'title' => __('Margin', 'mfn-opts'),
					'responsive' => 'mobile',
					'class' => 'mfn_field_mobile mfn-toggled advanced_margin',
					'css_attr' => 'margin',
  			),

  			array(
  				'class' => 'toggled_header',
					'title' => __('Positioning', 'mfn-opts'),
				),

				array(
					'id' => 'style:.mcb-section .mcb-wrap-mfnuidelement:align-self',
					'condition' => array( 'id' => 'wrap_sticky_desktop', 'opt' => 'is', 'val' => '0' ),
					'type' => 'radio_img',
					'alias' => 'flex-align-self',
					'responsive' => 'desktop',
					'class' => 'form-content-full-width small mfn-toggled mfn_field_desktop adv_alignself_wrap',
					'title' => __('Wrap position', 'mfn-opts'),
					'options' => array(
						'' => __('Default', 'mfn-opts'),
						'flex-start' => 'Top',
						'flex-end' => 'Bottom',
						'center' => 'Center',
						'stretch' => 'Stretch',
					),
					'std' => '',
				),

				array(
					'id' => 'style:.mcb-section .mcb-wrap-mfnuidelement:align-self_tablet',
					'condition' => array( 'id' => 'wrap_sticky_tablet', 'opt' => 'is', 'val' => '0' ),
					'type' => 'radio_img',
					'alias' => 'flex-align-self',
					'responsive' => 'tablet',
					'class' => 'form-content-full-width small mfn-toggled mfn_field_tablet',
					'title' => __('Wrap position', 'mfn-opts'),
					'options' => array(
						'' => __('Default', 'mfn-opts'),
						'flex-start' => 'Top',
						'flex-end' => 'Bottom',
						'center' => 'Center',
						'stretch' => 'Stretch',
					),
					'std' => '',
				),

				array(
					'id' => 'style:.mcb-section .mcb-wrap-mfnuidelement:align-self_mobile',
					'condition' => array( 'id' => 'wrap_sticky_mobile', 'opt' => 'is', 'val' => '0' ),
					'type' => 'radio_img',
					'alias' => 'flex-align-self',
					'responsive' => 'mobile',
					'class' => 'form-content-full-width small mfn-toggled mfn_field_mobile',
					'title' => __('Wrap position', 'mfn-opts'),
					'options' => array(
						'' => __('Default', 'mfn-opts'),
						'flex-start' => 'Top',
						'flex-end' => 'Bottom',
						'center' => 'Center',
						'stretch' => 'Stretch',
					),
					'std' => '',
				),

				array(
					'id' => 'style:.mcb-section .mcb-wrap-mfnuidelement .mcb-wrap-inner:align-content',
					'oldid' => 'vertical_align',
					'type' => 'radio_img',
					'alias' => 'flex-align-content',
					'responsive' => 'desktop',
					'class' => 'form-content-full-width small mfn-toggled mfn_field_desktop',
					'title' => __('Wrap content position', 'mfn-opts'),
					'desc' => __('Works with <b>Stretch</b> only', 'mfn-opts'),
					'options' => array(
						'' => __('Default', 'mfn-opts'),
						'flex-start' => 'Top',
						'flex-end' => 'Bottom',
						'center' => 'Center',
						'stretch' => 'Stretch',
						'space-between' => 'Space between',
						'space-around' => 'Space around',
						'space-evenly' => 'Space evenly'
					),
					'std' => '',
				),

				array(
					'id' => 'style:.mcb-section .mcb-wrap-mfnuidelement .mcb-wrap-inner:align-content_tablet',
					'oldid' => 'vertical_align',
					'type' => 'radio_img',
					'alias' => 'flex-align-content',
					'responsive' => 'tablet',
					'class' => 'form-content-full-width small mfn-toggled mfn_field_tablet',
					'title' => __('Wrap content position', 'mfn-opts'),
					'desc' => __('Works with <b>Stretch</b> only', 'mfn-opts'),
					'options' => array(
						'' => __('Default', 'mfn-opts'),
						'flex-start' => 'Top',
						'flex-end' => 'Bottom',
						'center' => 'Center',
						'stretch' => 'Stretch',
						'space-between' => 'Space between',
						'space-around' => 'Space around',
						'space-evenly' => 'Space evenly'
					),
					'std' => '',
				),

				array(
					'id' => 'style:.mcb-section .mcb-wrap-mfnuidelement .mcb-wrap-inner:align-content_mobile',
					'oldid' => 'vertical_align',
					'type' => 'radio_img',
					'alias' => 'flex-align-content',
					'responsive' => 'mobile',
					'class' => 'form-content-full-width small mfn-toggled mfn_field_mobile',
					'title' => __('Wrap content position', 'mfn-opts'),
					'desc' => __('Works with <b>Stretch</b> only', 'mfn-opts'),
					'options' => array(
						'' => __('Default', 'mfn-opts'),
						'flex-start' => 'Top',
						'flex-end' => 'Bottom',
						'center' => 'Center',
						'stretch' => 'Stretch',
						'space-between' => 'Space between',
						'space-around' => 'Space around',
						'space-evenly' => 'Space evenly'
					),
					'std' => '',
				),

				array(
					'id' => 'style:.mcb-section .mcb-wrap-mfnuidelement .mcb-wrap-inner:align-items',
					'type' => 'radio_img',
					'alias' => 'flex-align-items',
					'class' => 'form-content-full-width small mfn-toggled mfn_field_desktop',
					'responsive' => 'desktop',
					'title' => __('Elements vertical align', 'mfn-opts'),
					'options' => [
						'' => __('Default', 'mfn-opts'),
						'flex-start' => 'Top',
						'flex-end' => 'Bottom',
						'center' => 'Center',
						'stretch' => 'Stretch columns',
					],
					'std' => '',
				),

				array(
					'id' => 'style:.mcb-section .mcb-wrap-mfnuidelement .mcb-wrap-inner:align-items_tablet',
					'type' => 'radio_img',
					'alias' => 'flex-align-items',
					'class' => 'form-content-full-width small mfn-toggled mfn_field_tablet',
					'responsive' => 'tablet',
					'title' => __('Elements vertical align', 'mfn-opts'),
					'options' => [
						'' => __('Default', 'mfn-opts'),
						'flex-start' => 'Top',
						'flex-end' => 'Bottom',
						'center' => 'Center',
						'stretch' => 'Stretch columns',
					],
					'std' => '',
				),

				array(
					'id' => 'style:.mcb-section .mcb-wrap-mfnuidelement .mcb-wrap-inner:align-items_mobile',
					'type' => 'radio_img',
					'alias' => 'flex-align-items',
					'class' => 'form-content-full-width small mfn-toggled mfn_field_mobile',
					'responsive' => 'mobile',
					'title' => __('Elements vertical align', 'mfn-opts'),
					'options' => [
						'' => __('Default', 'mfn-opts'),
						'flex-start' => 'Top',
						'flex-end' => 'Bottom',
						'center' => 'Center',
						'stretch' => 'Stretch columns',
					],
					'std' => '',
				),

				array(
					'id' => 'style:.mcb-section .mcb-wrap-mfnuidelement .mcb-wrap-inner:justify-content',
					'type' => 'radio_img',
					'alias' => 'flex-justify',
					'class' => 'form-content-full-width small mfn-toggled mfn_field_desktop',
					'responsive' => 'desktop',
					'title' => __('Elements horizontal align', 'mfn-opts'),
					'options' => [
						'' => __('Default', 'mfn-opts'),
						'flex-start' => __('Left', 'mfn-opts'),
						'center' => __('Center', 'mfn-opts'),
						'flex-end' => __('Right', 'mfn-opts'),
						'space-between' => __('Space between', 'mfn-opts'),
						'space-around' => __('Space around', 'mfn-opts'),
					],
					'std' => '',
				),

				array(
					'id' => 'style:.mcb-section .mcb-wrap-mfnuidelement .mcb-wrap-inner:justify-content_tablet',
					'type' => 'radio_img',
					'alias' => 'flex-justify',
					'class' => 'form-content-full-width small mfn-toggled mfn_field_tablet',
					'responsive' => 'tablet',
					'title' => __('Elements horizontal align', 'mfn-opts'),
					'options' => [
						'' => __('Default', 'mfn-opts'),
						'flex-start' => __('Left', 'mfn-opts'),
						'center' => __('Center', 'mfn-opts'),
						'flex-end' => __('Right', 'mfn-opts'),
						'space-between' => __('Space between', 'mfn-opts'),
						'space-around' => __('Space around', 'mfn-opts'),
					],
					'std' => '',
				),

				array(
					'id' => 'style:.mcb-section .mcb-wrap-mfnuidelement .mcb-wrap-inner:justify-content_mobile',
					'type' => 'radio_img',
					'alias' => 'flex-justify',
					'class' => 'form-content-full-width small mfn-toggled mfn_field_mobile',
					'responsive' => 'mobile',
					'title' => __('Elements horizontal align', 'mfn-opts'),
					'options' => [
						'' => __('Default', 'mfn-opts'),
						'flex-start' => __('Left', 'mfn-opts'),
						'center' => __('Center', 'mfn-opts'),
						'flex-end' => __('Right', 'mfn-opts'),
						'space-between' => __('Space between', 'mfn-opts'),
						'space-around' => __('Space around', 'mfn-opts'),
					],
					'std' => '',
				),

				array(
					'type' => 'helper',
					'class' => 'mfn-toggled',
					'title' => __('Need help', 'mfn-opts'),
					'link' => 'https://support.muffingroup.com/documentation/bebuilder/positioning/#wrap',
				),

				array(
					'id' => 'style:.mcb-section .mcb-wrap-mfnuidelement:z-index',
					'type' => 'text',
					'title' => __('Z-index', 'mfn-opts'),
					'param' => 'number',
					'class' => 'narrow mfn-toggled',
					'preview' => 'number',
				),

				array(
					'id' => 'style:.mcb-section .mcb-wrap-mfnuidelement:order',
					'type' => 'text',
					'title' => __('Order', 'mfn-opts'),
					'param' => 'number',
						'class' => 'mfn_field_desktop narrow mfn-toggled',
						'responsive' => 'desktop',
					'preview' => 'number',
				),

				array(
					'id' => 'style:.mcb-section .mcb-wrap-mfnuidelement:order_tablet',
					'type' => 'text',
					'title' => __('Order', 'mfn-opts'),
					'param' => 'number',
						'class' => 'mfn_field_tablet narrow mfn-toggled',
						'responsive' => 'tablet',
					'preview' => 'number',
				),

				array(
					'id' => 'style:.mcb-section .mcb-wrap-mfnuidelement:order_mobile',
					'type' => 'text',
					'title' => __('Order', 'mfn-opts'),
					'param' => 'number',
						'class' => 'mfn_field_mobile narrow mfn-toggled',
						'responsive' => 'mobile',
					'preview' => 'number',
				),

				array(
					'id' => 'style:.mcb-section .mcb-wrap-mfnuidelement .mcb-wrap-inner:position',
					'attr_id' => 'wrap_position',
					'type' => 'select',
					'class' => 'mfn-toggled',
					'title' => __('Position', 'mfn-opts'),
					'options' => [
						'' => __('Default', 'mfn-opts'),
						'relative' => __('Offset', 'mfn-opts'),
					],
				),

				array(
					'id' => 'style:.mcb-section .mcb-wrap-mfnuidelement .mcb-wrap-inner:top',
					'type' => 'text',
					'condition' => array( 'id' => 'wrap_position', 'opt' => 'is', 'val' => 'relative' ),
					'title' => __('Top', 'mfn-opts'),
					'class' => 'mfn-toggled',
				),

				array(
					'id' => 'style:.mcb-section .mcb-wrap-mfnuidelement .mcb-wrap-inner:bottom',
					'type' => 'text',
					'condition' => array( 'id' => 'wrap_position', 'opt' => 'is', 'val' => 'relative' ),
					'title' => __('Bottom', 'mfn-opts'),
					'class' => 'mfn-toggled',
				),

				array(
					'id' => 'style:.mcb-section .mcb-wrap-mfnuidelement .mcb-wrap-inner:left',
					'type' => 'text',
					'condition' => array( 'id' => 'wrap_position', 'opt' => 'is', 'val' => 'relative' ),
					'title' => __('Left', 'mfn-opts'),
						'class' => 'mfn-toggled',
				),

				array(
					'id' => 'style:.mcb-section .mcb-wrap-mfnuidelement .mcb-wrap-inner:right',
					'type' => 'text',
					'condition' => array( 'id' => 'wrap_position', 'opt' => 'is', 'val' => 'relative' ),
					'title' => __('Right', 'mfn-opts'),
					'class' => 'mfn-toggled',
				),

  			array(
  				'class' => 'toggled_header',
					'title' => __('Background', 'mfn-opts'),
				),

				array(
					'type' => 'html',
					'html' => '<div class="mfn-form-row mfn-sidebar-fields-tabs mfn-toggled mfn-vb-formrow mfn-vb-mfnuidhere"><ul class="mfn-sft-nav"><li class="active"><a href="#normal" data-tab="normal">Normal</a></li><li><a href="#hover" data-tab="hover">Hover</a></li></ul><div class="mfn-sft mfn-sft-normal">',
				),

				array(
					'id' => 'background_switcher',
					'attr_id' => 'background_switcher',
					'type' => 'switch',
					'class' => 'mfn-fields-switcher',
					'title' => __('Background type', 'mfn-opts'),
					'options' => array(
  					'default' => __('Default', 'mfn-opts'),
  					'gradient' 	=> __('Gradient', 'mfn-opts'),
  				),
					'visual_options' => array(
  					'default' => '',
  					'gradient' 	=> '',
  				),
  				'std' => 'default',
				),

				array(
					'id' => 'style:.mcb-section .mcb-wrap-mfnuidelement .mcb-wrap-inner:background-color',
					'condition' => array( 'id' => 'background_switcher', 'opt' => 'is', 'val' => 'default' ),
					'type' => 'color',
					'title' => __('Color', 'mfn-opts'),
				),

				array(
  				'id' => 'style:.mcb-section .mcb-wrap-mfnuidelement .mcb-wrap-inner:gradient',
  				'condition' => array( 'id' => 'background_switcher', 'opt' => 'is', 'val' => 'gradient' ),
  				'type' => 'gradient',
  				'title' => __('Gradient', 'mfn-opts'),
  				'class' => 'mfn-toggled',
					'css_attr' => 'gradient',
  			),

				array(
  				'id' => 'style:.mcb-section .mcb-wrap-mfnuidelement .mcb-wrap-inner:background-image',
  				'condition' => array( 'id' => 'background_switcher', 'opt' => 'is', 'val' => 'default' ),
  				'oldid' => 'bg_color',
  				'type' => 'upload',
  				'title' => __('Image', 'mfn-opts'),
  				'responsive' => 'desktop',
					'class' => 'mfn_field_desktop',
					'css_attr' => 'background-image',
  			),

  			array(
  				'id' => 'style:.mcb-section .mcb-wrap-mfnuidelement .mcb-wrap-inner:background-image_tablet',
  				'condition' => array( 'id' => 'background_switcher', 'opt' => 'is', 'val' => 'default' ),
  				'oldid' => 'bg_image',
  				'type' => 'upload',
  				'title' => __('Image', 'mfn-opts'),
  				'responsive' => 'tablet',
					'class' => 'mfn_field_tablet',
					'css_attr' => 'background-image',
  			),

  			array(
  				'id' => 'style:.mcb-section .mcb-wrap-mfnuidelement .mcb-wrap-inner:background-image_mobile',
  				'condition' => array( 'id' => 'background_switcher', 'opt' => 'is', 'val' => 'default' ),
  				'type' => 'upload',
  				'title' => __('Image', 'mfn-opts'),
  				'responsive' => 'mobile',
					'class' => 'mfn_field_mobile',
					'css_attr' => 'background-image',
  			),

  			array(
					'id' => 'style:.mcb-section .mcb-wrap-mfnuidelement .mcb-wrap-inner:background-repeat',
					'condition' => array( 'id' => 'background_switcher', 'opt' => 'is', 'val' => 'default' ),
					'type' => 'select',
					'responsive' => 'desktop',
					'class' => 'mfn_field_desktop',
					'css_attr' => 'background-repeat',
					'title' => __('Repeat', 'mfn-opts'),
					'options' => [
						'' => __('Default', 'mfn-opts'),
						'repeat' => __('Repeat', 'mfn-opts'),
						'no-repeat' => __('No repeat', 'mfn-opts'),
						'repeat-x' => __('Repeat X', 'mfn-opts'),
						'repeat-y' => __('Repeat Y', 'mfn-opts'),
					],
				),

				array(
					'id' => 'style:.mcb-section .mcb-wrap-mfnuidelement .mcb-wrap-inner:background-repeat_tablet',
					'condition' => array( 'id' => 'background_switcher', 'opt' => 'is', 'val' => 'default' ),
					'type' => 'select',
					'responsive' => 'tablet',
					'class' => 'mfn_field_tablet',
					'css_attr' => 'background-repeat',
					'title' => __('Repeat', 'mfn-opts'),
					'options' => [
						'' => __('Default', 'mfn-opts'),
						'repeat' => __('Repeat', 'mfn-opts'),
						'no-repeat' => __('No repeat', 'mfn-opts'),
						'repeat-x' => __('Repeat X', 'mfn-opts'),
						'repeat-y' => __('Repeat Y', 'mfn-opts'),
					],
				),

				array(
					'id' => 'style:.mcb-section .mcb-wrap-mfnuidelement .mcb-wrap-inner:background-repeat_mobile',
					'condition' => array( 'id' => 'background_switcher', 'opt' => 'is', 'val' => 'default' ),
					'type' => 'select',
					'responsive' => 'mobile',
					'class' => 'mfn_field_mobile',
					'css_attr' => 'background-repeat',
					'title' => __('Repeat', 'mfn-opts'),
					'options' => [
						'' => __('Default', 'mfn-opts'),
						'repeat' => __('Repeat', 'mfn-opts'),
						'no-repeat' => __('No repeat', 'mfn-opts'),
						'repeat-x' => __('Repeat X', 'mfn-opts'),
						'repeat-y' => __('Repeat Y', 'mfn-opts'),
					],
				),

				array(
					'id' => 'style:.mcb-section .mcb-wrap-mfnuidelement .mcb-wrap-inner:background-position',
					'condition' => array( 'id' => 'background_switcher', 'opt' => 'is', 'val' => 'default' ),
					'oldid' => 'bg_position',
					'type' => 'select',
					'responsive' => 'desktop',
					'class' => 'mfn_field_desktop',
					'css_attr' => 'background-position',
					'title' => __('Position', 'mfn-opts'),
					'options' => [
						'' => __('Default', 'mfn-opts'),
						'center' => __('Center Center', 'mfn-opts'),
						'center left' => __('Center Left', 'mfn-opts'),
						'center right' => __('Center Right', 'mfn-opts'),
						'top left' => __('Top Left', 'mfn-opts'),
						'top right' => __('Top Right', 'mfn-opts'),
						'top center' => __('Top Center', 'mfn-opts'),
						'bottom left' => __('Bottom Left', 'mfn-opts'),
						'bottom right' => __('Bottom Right', 'mfn-opts'),
						'bottom center' => __('Bottom Center', 'mfn-opts'),
					],
				),

				array(
					'id' => 'style:.mcb-section .mcb-wrap-mfnuidelement .mcb-wrap-inner:background-position_tablet',
					'condition' => array( 'id' => 'background_switcher', 'opt' => 'is', 'val' => 'default' ),
					'oldid' => 'bg_position',
					'type' => 'select',
					'responsive' => 'tablet',
					'class' => 'mfn_field_tablet',
					'css_attr' => 'background-position',
					'title' => __('Position', 'mfn-opts'),
					'options' => [
						'' => __('Default', 'mfn-opts'),
						'center' => __('Center Center', 'mfn-opts'),
						'center left' => __('Center Left', 'mfn-opts'),
						'center right' => __('Center Right', 'mfn-opts'),
						'top left' => __('Top Left', 'mfn-opts'),
						'top right' => __('Top Right', 'mfn-opts'),
						'top center' => __('Top Center', 'mfn-opts'),
						'bottom left' => __('Bottom Left', 'mfn-opts'),
						'bottom right' => __('Bottom Right', 'mfn-opts'),
						'bottom center' => __('Bottom Center', 'mfn-opts'),
					],
				),

				array(
					'id' => 'style:.mcb-section .mcb-wrap-mfnuidelement .mcb-wrap-inner:background-position_mobile',
					'condition' => array( 'id' => 'background_switcher', 'opt' => 'is', 'val' => 'default' ),
					'oldid' => 'bg_position',
					'type' => 'select',
					'responsive' => 'mobile',
					'class' => 'mfn_field_mobile',
					'css_attr' => 'background-position',
					'title' => __('Position', 'mfn-opts'),
					'options' => [
						'' => __('Default', 'mfn-opts'),
						'center' => __('Center Center', 'mfn-opts'),
						'center left' => __('Center Left', 'mfn-opts'),
						'center right' => __('Center Right', 'mfn-opts'),
						'top left' => __('Top Left', 'mfn-opts'),
						'top right' => __('Top Right', 'mfn-opts'),
						'top center' => __('Top Center', 'mfn-opts'),
						'bottom left' => __('Bottom Left', 'mfn-opts'),
						'bottom right' => __('Bottom Right', 'mfn-opts'),
						'bottom center' => __('Bottom Center', 'mfn-opts'),
					],
				),

				array(
					'id' => 'style:.mcb-section .mcb-wrap-mfnuidelement .mcb-wrap-inner:background-attachment',
					'condition' => array( 'id' => 'background_switcher', 'opt' => 'is', 'val' => 'default' ),
					'type' => 'select',
					'responsive' => 'desktop',
					'class' => 'mfn_field_desktop',
					'css_attr' => 'background-attachment',
					'title' => __('Attachment', 'mfn-opts'),
					'options' => [
						'' => __('Default', 'mfn-opts'),
						'scroll' => __('Scroll', 'mfn-opts'),
						'fixed' => __('Fixed', 'mfn-opts'),
						'parallax' => __('Parallax', 'mfn-opts'),
					],
				),

				array(
					'id' => 'style:.mcb-section .mcb-wrap-mfnuidelement .mcb-wrap-inner:background-attachment_tablet',
					'condition' => array( 'id' => 'background_switcher', 'opt' => 'is', 'val' => 'default' ),
					'type' => 'select',
					'responsive' => 'tablet',
					'class' => 'mfn_field_tablet',
					'css_attr' => 'background-attachment',
					'title' => __('Attachment', 'mfn-opts'),
					'desc' => __('iOS does <b>not</b> support background-attachment: fixed', 'mfn-opts'),
					'options' => [
						'' => __('Default', 'mfn-opts'),
						'scroll' => __('Scroll', 'mfn-opts'),
						'fixed' => __('Fixed', 'mfn-opts'),
						'parallax' => __('Parallax', 'mfn-opts'),
					],
				),

				array(
					'id' => 'style:.mcb-section .mcb-wrap-mfnuidelement .mcb-wrap-inner:background-attachment_mobile',
					'condition' => array( 'id' => 'background_switcher', 'opt' => 'is', 'val' => 'default' ),
					'type' => 'select',
					'responsive' => 'mobile',
					'class' => 'mfn_field_mobile',
					'css_attr' => 'background-attachment',
					'title' => __('Attachment', 'mfn-opts'),
					'desc' => __('iOS does <b>not</b> support background-attachment: fixed', 'mfn-opts'),
					'options' => [
						'' => __('Default', 'mfn-opts'),
						'scroll' => __('Scroll', 'mfn-opts'),
						'fixed' => __('Fixed', 'mfn-opts'),
						'parallax' => __('Parallax', 'mfn-opts'),
					],
				),

				array(
					'id' => 'style:.mcb-section .mcb-wrap-mfnuidelement .mcb-wrap-inner:background-size',
					'condition' => array( 'id' => 'background_switcher', 'opt' => 'is', 'val' => 'default' ),
					'oldid' => 'bg_size',
					'type' => 'select',
					'responsive' => 'desktop',
					'class' => 'mfn_field_desktop',
					'css_attr' => 'background-size',
					'title' => __('Size', 'mfn-opts'),
					'options' => mfna_bg_size()
				),

				array(
					'id' => 'style:.mcb-section .mcb-wrap-mfnuidelement .mcb-wrap-inner:background-size_tablet',
					'condition' => array( 'id' => 'background_switcher', 'opt' => 'is', 'val' => 'default' ),
					'oldid' => 'bg_size',
					'type' => 'select',
					'responsive' => 'tablet',
					'class' => 'mfn_field_tablet',
					'css_attr' => 'background-size',
					'title' => __('Size', 'mfn-opts'),
					'options' => mfna_bg_size()
				),

				array(
					'id' => 'style:.mcb-section .mcb-wrap-mfnuidelement .mcb-wrap-inner:background-size_mobile',
					'condition' => array( 'id' => 'background_switcher', 'opt' => 'is', 'val' => 'default' ),
					'oldid' => 'bg_size',
					'type' => 'select',
					'responsive' => 'mobile',
					'class' => 'mfn_field_mobile',
					'css_attr' => 'background-size',
					'title' => __('Size', 'mfn-opts'),
					'options' => mfna_bg_size()
				),

				array(
					'type' => 'html',
					'html' => '</div><div class="mfn-sft mfn-sft-hover">',
				),

				array(
					'id' => 'style:.mcb-section .mcb-wrap-mfnuidelement .mcb-wrap-inner:transition',
					'type' => 'sliderbar',
					'title' => __('Transition duration', 'mfn-opts'),
					'param' => array(
						'min' => '0',
						'max' => '3',
						'step' => '0.1',
						'unit' => 's',
					)
				),

				array(
					'id' => 'background_switcher_hover',
					'attr_id' => 'background_switcher_hover',
					'type' => 'switch',
					'class' => 'mfn-fields-switcher',
					'title' => __('Background type', 'mfn-opts'),
					'options' => array(
  					'default' => __('Default', 'mfn-opts'),
  					'gradient' 	=> __('Gradient', 'mfn-opts'),
  				),
					'visual_options' => array(
  					'default' => '',
  					'gradient' 	=> __('', 'mfn-opts'),
  				),
  				'std' => 'default',
				),

				array(
					'id' => 'style:.mcb-section .mcb-wrap-mfnuidelement .mcb-wrap-inner|hover:background-color',
					'condition' => array( 'id' => 'background_switcher_hover', 'opt' => 'is', 'val' => 'default' ),
					'type' => 'color',
					'title' => __('Color', 'mfn-opts'),
				),

				array(
  				'id' => 'style:.mcb-section .mcb-wrap-mfnuidelement .mcb-wrap-inner|hover:gradient',
  				'condition' => array( 'id' => 'background_switcher_hover', 'opt' => 'is', 'val' => 'gradient' ),
  				'type' => 'gradient',
  				'title' => __('Gradient', 'mfn-opts'),
  				'class' => 'mfn-toggled',
					'css_attr' => 'gradient',
  			),

				array(
  				'id' => 'style:.mcb-section .mcb-wrap-mfnuidelement .mcb-wrap-inner|hover:background-image',
  				'condition' => array( 'id' => 'background_switcher_hover', 'opt' => 'is', 'val' => 'default' ),
  				'oldid' => 'bg_color',
  				'type' => 'upload',
  				'title' => __('Image', 'mfn-opts'),
  				'responsive' => 'desktop',
					'class' => 'mfn_field_desktop',
					'css_attr' => 'background-image',
  			),

				array(
					'type' => 'html',
					'html' => '</div></div>',
				),

				array(
					'class' => 'toggled_header',
						'title' => __('Border', 'mfn-opts'),
					),

				array(
					'id' => 'style:.mcb-section .mcb-wrap-mfnuidelement .mcb-wrap-inner:border-style',
					'attr_id' => 'border_style',
					'type' => 'select',
					'class' => 'mfn-toggled',
					'title' => __('Border style', 'mfn-opts'),
					'options' => [
						'none' => __('None', 'mfn-opts'),
						'solid' => __('Solid', 'mfn-opts'),
						'dashed' => __('Dashed', 'mfn-opts'),
						'dotted' => __('Dotted', 'mfn-opts'),
						'double' => __('Double', 'mfn-opts'),
					],
				),

				array(
					'id' => 'style:.mcb-section .mcb-wrap-mfnuidelement .mcb-wrap-inner:border-color',
					'condition' => array( 'id' => 'border_style', 'opt' => 'isnt', 'val' => 'none' ),
					'type' => 'color',
					'class' => 'mfn-toggled',
					'title' => __('Border color', 'mfn-opts'),
				),

				array(
  				'id' => 'style:.mcb-section .mcb-wrap-mfnuidelement .mcb-wrap-inner:border-width',
  				'condition' => array( 'id' => 'border_style', 'opt' => 'isnt', 'val' => 'none' ),
  				'type' => 'dimensions',
  				'title' => __('Border width', 'mfn-opts'),
					'responsive' => 'desktop',
					'class' => 'mfn_field_desktop mfn-toggled',
					'css_attr' => 'border-width',
  			),

  			array(
  				'id' => 'style:.mcb-section .mcb-wrap-mfnuidelement .mcb-wrap-inner:border-width_tablet',
  				'condition' => array( 'id' => 'border_style', 'opt' => 'isnt', 'val' => 'none' ),
  				'type' => 'dimensions',
  				'title' => __('Border width', 'mfn-opts'),
					'responsive' => 'tablet',
					'class' => 'mfn_field_tablet mfn-toggled',
					'css_attr' => 'border-width',
  			),

  			array(
  				'id' => 'style:.mcb-section .mcb-wrap-mfnuidelement .mcb-wrap-inner:border-width_mobile',
  				'condition' => array( 'id' => 'border_style', 'opt' => 'isnt', 'val' => 'none' ),
  				'type' => 'dimensions',
  				'title' => __('Border width', 'mfn-opts'),
					'responsive' => 'mobile',
					'class' => 'mfn_field_mobile mfn-toggled',
					'css_attr' => 'border-width',
  			),

				array(
  				'id' => 'style:.mcb-section .mcb-wrap-mfnuidelement .mcb-wrap-inner:border-radius',
  				'type' => 'dimensions',
  				'title' => __('Border radius', 'mfn-opts'),
					'responsive' => 'desktop',
					'class' => 'mfn_field_desktop mfn-toggled',
					'css_attr' => 'border-radius',
  			),

  			array(
  				'id' => 'style:.mcb-section .mcb-wrap-mfnuidelement .mcb-wrap-inner:border-radius_tablet',
  				'type' => 'dimensions',
  				'title' => __('Border radius', 'mfn-opts'),
					'responsive' => 'tablet',
					'class' => 'mfn_field_tablet mfn-toggled',
					'css_attr' => 'border-radius',
  			),

  			array(
  				'id' => 'style:.mcb-section .mcb-wrap-mfnuidelement .mcb-wrap-inner:border-radius_mobile',
  				'type' => 'dimensions',
  				'title' => __('Border radius', 'mfn-opts'),
					'responsive' => 'mobile',
					'class' => 'mfn_field_mobile mfn-toggled',
					'css_attr' => 'border-radius',
  			),

  			array(
  				'id' => 'style:.mcb-section .mcb-wrap-mfnuidelement .mcb-wrap-inner:box-shadow',
  				'type' => 'box_shadow',
  				'title' => __('Box shadow', 'mfn-opts'),
					'responsive' => 'desktop',
					'class' => 'mfn_field_desktop mfn-toggled',
					'css_attr' => 'box-shadow',
  			),

  			array(
  				'id' => 'style:.mcb-section .mcb-wrap-mfnuidelement .mcb-wrap-inner:box-shadow_tablet',
  				'type' => 'box_shadow',
  				'title' => __('Box shadow', 'mfn-opts'),
					'responsive' => 'tablet',
					'class' => 'mfn_field_tablet mfn-toggled',
					'css_attr' => 'box-shadow',
  			),

  			array(
  				'id' => 'style:.mcb-section .mcb-wrap-mfnuidelement .mcb-wrap-inner:box-shadow_mobile',
  				'type' => 'box_shadow',
  				'title' => __('Box shadow', 'mfn-opts'),
					'responsive' => 'mobile',
					'class' => 'mfn_field_mobile mfn-toggled',
					'css_attr' => 'box-shadow',
  			),

				array(
					'class' => 'toggled_header',
					'title' => __('Responsive', 'mfn-opts'),
				),

				array(
  				'id' => 'visibility',
  				'iconinfo' => 'https://support.muffingroup.com/video-tutorials/section-responsive-visibility/',
  				'type' => 'switch',
  				'invert' => true,
  				'version' => 'multiple',
  				'class' => 'mfn-toggled',
  				'title' => __('Responsive visibility', 'mfn-opts'),
  				'options' => array(
  					'hide-desktop' => __('Hide on Desktop', 'mfn-opts'),			// 960 +
  					'hide-tablet' => __('Hide on Tablet', 'mfn-opts'),		// 768 - 959
  					'hide-mobile' => __('Hide on Mobile', 'mfn-opts'),			// - 768
  				),
  				'active_tooltip' => array(
  					'hide-desktop' => __('Show on Desktop', 'mfn-opts'),
  					'hide-tablet' => __('Show on Tablet', 'mfn-opts'),
  					'hide-mobile' => __('Show on Mobile', 'mfn-opts'),
  				),
  				'visual_options' => array(
  					'hide-desktop' => '<svg id="Layer_1" data-name="Layer 1" xmlns="http://www.w3.org/2000/svg" viewBox="0 0 22 22"><defs><style>.cls-1{fill:none;stroke:#304050;stroke-linecap:round;stroke-linejoin:round;stroke-width:1.5px;}.cls-2{fill:#304050;}</style></defs><path class="cls-1" d="M4.94,5H17.06a.93.93,0,0,1,.94.91v7.18a.93.93,0,0,1-.94.91H4.94A.93.93,0,0,1,4,13.09V5.91A.93.93,0,0,1,4.94,5Z"/><path class="cls-1" d="M7,17h8"/><path class="cls-2" d="M13,15.51a1.58,1.58,0,0,0,.7,1.26L14,17H8l.3-.23A1.58,1.58,0,0,0,9,15.51V14h4Z"/></svg>',			// 960 +
  					'hide-tablet' => '<svg id="Layer_1" data-name="Layer 1" xmlns="http://www.w3.org/2000/svg" viewBox="0 0 22 22"><defs><style>.cls-1{fill:none;stroke:#304050;stroke-linecap:round;stroke-linejoin:round;stroke-width:1.5px;}</style></defs><path class="cls-1" d="M7,15.83V7.17A1.21,1.21,0,0,1,8.25,6h5.5A1.21,1.21,0,0,1,15,7.17v8.66A1.21,1.21,0,0,1,13.75,17H8.25A1.21,1.21,0,0,1,7,15.83Z"/></svg>',		// 768 - 959
  					'hide-mobile' => '<svg id="Layer_1" data-name="Layer 1" xmlns="http://www.w3.org/2000/svg" viewBox="0 0 22 22"><defs><style>.cls-1{fill:none;stroke:#304050;stroke-linecap:round;stroke-linejoin:round;stroke-width:1.5px;}.cls-2{fill:#304050;}</style></defs><path class="cls-1" d="M8,15.82V8.18A1.08,1.08,0,0,1,8.94,7h4.12A1.08,1.08,0,0,1,14,8.18v7.64A1.08,1.08,0,0,1,13.06,17H8.94A1.08,1.08,0,0,1,8,15.82Z"/><circle class="cls-2" cx="11" cy="14" r="1"/></svg>',			// - 768
  				),
  			),

  			array(
  				'id' => 'reverse_order',
  				'class' => 'mfn-toggled',
  				'type' => 'switch',
  				'iconinfo' => 'https://support.muffingroup.com/how-to/how-to-reverse-the-order-of-elements-on-mobile/',
  				'title' => __('Order on mobile', 'mfn-opts'),
					'options' => [
						0 => __('Default', 'mfn-opts'),
						1 => __('Reverse rows', 'mfn-opts'),
						2 => __('Reverse columns', 'mfn-opts'),
					],
					'std' => 0,
  			),

				array(
					'class' => 'toggled_header',
					'title' => __('Custom', 'mfn-opts'),
				),

				array(
  				'id' => 'classes',
  				'oldid' => 'class',
  				'class' => 'mfn-toggled',
  				'type' => 'pills',
  				'title' => __('Classes', 'mfn-opts'),
  			),

  			array(
  				'id' => 'custom_id',
  				'class' => 'mfn-toggled',
  				'type' => 'text',
  				'title' => __('ID', 'mfn-opts'),
  			),

  			array(
  				'id' => 'custom_css',
  				'oldid' => 'style',
  				'class' => 'mfn-toggled',
  				'type' => 'textarea',
  				'title' => __('Additional CSS', 'mfn-opts'),
  			),

  			array(
					'type' => 'html',
					'html' => '</div>',
				)

  		);

  	}

    /**
     * SET items and their fields
   	 */

   	private function set_items(){

   		$this->items = array(

				/*

   			// Logo ----------------------------------------------------

   			'header_logo' => array(
   				'type' => 'header_logo',
   				'title' => __('Logo', 'mfn-opts'),
   				'size' => '1/1',
   				'cat' => 'header',
   				'fields' => array(

   					array(
							'type' => 'html',
							'html' => $this->itemtabs,
						),

   					array(
							'type' => 'html',
							'html' => '<div class="modalbox-card modalbox-re_render modalbox-card-content-mfnuidhere active">',
						),

						array(
   						'id' => 'image',
   						'type' => 'upload',
   						'title' => __('Logo', 'mfn-opts'),
   						'desc' => __('Recommended svg', 'mfn-opts'),
							'std' => mfn_opts_get('logo-img') ? mfn_opts_get('logo-img') : $this->get_placeholder(),
							'preview' => 'image',
   					),

   					array(
							'id' => 'link',
							'type' => 'text',
							'title' => __('Link', 'mfn-opts'),
							'std' => '/',
						),

   					array(
							'type' => 'html',
							'html' => '</div><div class="modalbox-card modalbox-card-style modalbox-re_render modalbox-card-style-mfnuidhere">',
						),

						array(
   						'title' => __('Image', 'mfn-opts'),
   					),

						array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .header_column_wrapper:flex',
							'type' => 'text',
							'responsive' => 'desktop',
							'class' => 'mfn_field_desktop',
							'title' => __('Width', 'mfn-opts'),
							'desc' => __('Use px, %, vw, vh or auto to set content width', 'mfn-opts'),
						),

						array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .header_column_wrapper:flex_tablet',
							'type' => 'text',
							'responsive' => 'tablet',
							'class' => 'mfn_field_tablet',
							'title' => __('Width', 'mfn-opts'),
							'desc' => __('Use px, %, vw, vh or auto to set content width', 'mfn-opts'),
						),

						array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .header_column_wrapper:flex_mobile',
							'type' => 'text',
							'responsive' => 'mobile',
							'class' => 'mfn_field_mobile',
							'title' => __('Width', 'mfn-opts'),
							'desc' => __('Use px, %, vw, vh or auto to set content width', 'mfn-opts'),
						),

						array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .header_column_wrapper:height',
							'type' => 'text',
							'responsive' => 'desktop',
							'class' => 'mfn_field_desktop',
							'title' => __('Height', 'mfn-opts')
						),

						array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .header_column_wrapper:height_tablet',
							'type' => 'text',
							'responsive' => 'tablet',
							'class' => 'mfn_field_tablet',
							'title' => __('Height', 'mfn-opts')
						),

						array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .header_column_wrapper:height_mobile',
							'type' => 'text',
							'responsive' => 'mobile',
							'class' => 'mfn_field_mobile',
							'title' => __('Height', 'mfn-opts')
						),

						array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .header_column_wrapper:align-items',
							'type' => 'select',
							'responsive' => 'desktop',
							'class' => 'mfn_field_desktop',
							'title' => __('Vertical spacing', 'mfn-opts'),
							'options' => array(
								'stretch' => 'Default',
								'flex-start' => 'Top',
								'flex-end' => 'Bottom',
								'center' => 'Center',
							),
							'std' => 'center',
						),

						array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .header_column_wrapper:align-items_tablet',
							'type' => 'select',
							'responsive' => 'tablet',
							'class' => 'mfn_field_tablet',
							'title' => __('Vertical spacing', 'mfn-opts'),
							'options' => array(
								'stretch' => 'Default',
								'flex-start' => 'Top',
								'flex-end' => 'Bottom',
								'center' => 'Center',
							),
							'std' => 'center',
						),

						array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .header_column_wrapper:align-items_mobile',
							'type' => 'select',
							'responsive' => 'mobile',
							'class' => 'mfn_field_mobile',
							'title' => __('Vertical spacing', 'mfn-opts'),
							'options' => array(
								'stretch' => 'Default',
								'flex-start' => 'Top',
								'flex-end' => 'Bottom',
								'center' => 'Center',
							),
							'std' => 'center',
						),

   					array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .header_column_wrapper:justify-content',
							'type' => 'select',
							'responsive' => 'desktop',
							'class' => 'mfn_field_desktop',
							'title' => __('Horizontal align', 'mfn-opts'),
							'options' => [
								'flex-start' => __('Left', 'mfn-opts'),
								'center' => __('Center', 'mfn-opts'),
								'flex-end' => __('Right', 'mfn-opts'),
								'space-between' => __('Space between', 'mfn-opts'),
								'space-around' => __('Space around', 'mfn-opts'),
							],
							'std' => 'flex-start',
						),

						array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .header_column_wrapper:justify-content_tablet',
							'type' => 'select',
							'responsive' => 'tablet',
							'class' => 'mfn_field_tablet',
							'title' => __('Horizontal align', 'mfn-opts'),
							'options' => [
								'flex-start' => __('Left', 'mfn-opts'),
								'center' => __('Center', 'mfn-opts'),
								'flex-end' => __('Right', 'mfn-opts'),
								'space-between' => __('Space between', 'mfn-opts'),
								'space-around' => __('Space around', 'mfn-opts'),
							],
							'std' => 'flex-start',
						),

						array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .header_column_wrapper:justify-content_mobile',
							'type' => 'select',
							'responsive' => 'mobile',
							'class' => 'mfn_field_mobile',
							'title' => __('Horizontal align', 'mfn-opts'),
							'options' => [
								'flex-start' => __('Left', 'mfn-opts'),
								'center' => __('Center', 'mfn-opts'),
								'flex-end' => __('Right', 'mfn-opts'),
								'space-between' => __('Space between', 'mfn-opts'),
								'space-around' => __('Space around', 'mfn-opts'),
							],
							'std' => 'flex-start',
						),

						array(
		  				'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .header_column_wrapper:padding',
		  				'type' => 'dimensions',
		  				'title' => __('Padding', 'mfn-opts'),
							'responsive' => 'desktop',
							'class' => 'mfn_field_desktop',
							'css_attr' => 'padding',
		  			),

		  			array(
		  				'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .header_column_wrapper:padding_tablet',
		  				'type' => 'dimensions',
		  				'title' => __('Padding', 'mfn-opts'),
							'responsive' => 'tablet',
							'class' => 'mfn_field_tablet',
							'css_attr' => 'padding',
		  			),

		  			array(
		  				'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .header_column_wrapper:padding_mobile',
		  				'type' => 'dimensions',
		  				'title' => __('Padding', 'mfn-opts'),
							'responsive' => 'mobile',
							'class' => 'mfn_field_mobile',
							'css_attr' => 'padding',
		  			),

						array(
		  				'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .header_column_wrapper:margin',
		  				'type' => 'dimensions',
		  				'title' => __('Margin', 'mfn-opts'),
		  				'version' => 'separated-fields',
							'responsive' => 'desktop',
							'class' => 'mfn_field_desktop',
							'css_attr' => 'margin',
		  			),

		  			array(
		  				'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .header_column_wrapper:margin_tablet',
		  				'type' => 'dimensions',
		  				'title' => __('Margin', 'mfn-opts'),
		  				'version' => 'separated-fields',
							'responsive' => 'tablet',
							'class' => 'mfn_field_tablet',
							'css_attr' => 'margin',
		  			),

		  			array(
		  				'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .header_column_wrapper:margin_mobile',
		  				'type' => 'dimensions',
		  				'title' => __('Margin', 'mfn-opts'),
		  				'version' => 'separated-fields',
							'responsive' => 'mobile',
							'class' => 'mfn_field_mobile',
							'css_attr' => 'margin',
		  			),

						array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .header_column_wrapper:background-color',
							'type' => 'color',
							'title' => __('Image background color', 'mfn-opts'),
						),

						array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .header_column_wrapper:border-style',
							'type' => 'select',
							'title' => __('Border style', 'mfn-opts'),
							'options' => [
								'none' => __('Choose', 'mfn-opts'),
								'solid' => __('Solid', 'mfn-opts'),
								'dashed' => __('Dashed', 'mfn-opts'),
								'dotted' => __('Dotted', 'mfn-opts'),
								'double' => __('Double', 'mfn-opts'),
							],
						),

						array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .header_column_wrapper:border-width',
							'type' => 'text',
							'title' => __('Border width', 'mfn-opts'),
							'desc' => __('Use px or %', 'mfn-opts'),
						),

						array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .header_column_wrapper:border-color',
							'type' => 'color',
							'title' => __('Border color', 'mfn-opts'),
						),

						array(
		  				'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .header_column_wrapper:border-radius',
		  				'type' => 'dimensions',
		  				'title' => __('Border radius', 'mfn-opts'),
							'responsive' => 'desktop',
							'class' => 'mfn_field_desktop',
							'css_attr' => 'border-radius',
		  			),

		  			array(
		  				'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .header_column_wrapper:border-radius_tablet',
		  				'type' => 'dimensions',
		  				'title' => __('Border radius', 'mfn-opts'),
							'responsive' => 'tablet',
							'class' => 'mfn_field_tablet',
							'css_attr' => 'border-radius',
		  			),

		  			array(
		  				'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .header_column_wrapper:border-radius_mobile',
		  				'type' => 'dimensions',
		  				'title' => __('Border radius', 'mfn-opts'),
							'responsive' => 'mobile',
							'class' => 'mfn_field_mobile',
							'css_attr' => 'border-radius',
		  			),

						array(
							'type' => 'html',
							'html' => '</div>',
						),

						// advanced here

   				),
   			),

   			// Menu ----------------------------------------------------

   			'header_menu' => array(
   				'type' => 'header_menu',
   				'title' => __('Menu', 'mfn-opts'),
   				'size' => '1/1',
   				'cat' => 'header',
   				'fields' => array(

						array(
							'type' => 'html',
							'html' => $this->itemtabs,
						),

   					array(
							'type' => 'html',
							'html' => '<div class="modalbox-card modalbox-re_render modalbox-card-content-mfnuidhere active">',
						),

						array(
   						'id' => 'menu_display',
   						'type' => 'select',
   						'title' => __('Menu to display', 'mfn-opts'),
							'options' => mfna_menu(),
   					),

   					array(
							'type' => 'html',
							'html' => '</div><div class="modalbox-card modalbox-card-style modalbox-re_render modalbox-card-style-mfnuidhere">',
						),

						array(
   						'title' => __('Menu items', 'mfn-opts'),
   					),

   					array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .header_column_wrapper ul:align-items',
							'attr_id' => 'menu_li_align',
							'responsive' => 'desktop',
							'class' => 'mfn_field_desktop',
							'type' => 'select',
							'title' => __('Vertical spacing', 'mfn-opts'),
							'options' => array(
								'' => 'Default',
								'flex-start' => 'Top',
								'flex-end' => 'Bottom',
								'center' => 'Center',
							),
							'std' => '',
						),

						array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .header_column_wrapper ul:align-items_tablet',
							'attr_id' => 'menu_li_align',
							'responsive' => 'tablet',
							'class' => 'mfn_field_tablet',
							'type' => 'select',
							'title' => __('Vertical spacing', 'mfn-opts'),
							'options' => array(
								'' => 'Default',
								'flex-start' => 'Top',
								'flex-end' => 'Bottom',
								'center' => 'Center',
							),
							'std' => '',
						),

						array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .header_column_wrapper ul:align-items_mobile',
							'attr_id' => 'menu_li_align',
							'responsive' => 'mobile',
							'class' => 'mfn_field_mobile',
							'type' => 'select',
							'title' => __('Vertical spacing', 'mfn-opts'),
							'options' => array(
								'' => 'Default',
								'flex-start' => 'Top',
								'flex-end' => 'Bottom',
								'center' => 'Center',
							),
							'std' => '',
						),

						array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .header_column_wrapper ul:justify-content',
							'type' => 'select',
							'responsive' => 'desktop',
							'class' => 'mfn_field_desktop',
							'title' => __('Horizontal align', 'mfn-opts'),
							'options' => [
								'' => __('Left', 'mfn-opts'),
								'center' => __('Center', 'mfn-opts'),
								'flex-end' => __('Right', 'mfn-opts'),
								'space-between' => __('Space between', 'mfn-opts'),
								'space-around' => __('Space around', 'mfn-opts'),
							],
							'std' => 'space-around',
						),

						array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .header_column_wrapper ul:justify-content_tablet',
							'type' => 'select',
							'responsive' => 'tablet',
							'class' => 'mfn_field_tablet',
							'title' => __('Horizontal align', 'mfn-opts'),
							'options' => [
								'' => __('Left', 'mfn-opts'),
								'center' => __('Center', 'mfn-opts'),
								'flex-end' => __('Right', 'mfn-opts'),
								'space-between' => __('Space between', 'mfn-opts'),
								'space-around' => __('Space around', 'mfn-opts'),
							],
							'std' => 'space-around',
						),

						array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .header_column_wrapper ul:justify-content_mobile',
							'type' => 'select',
							'responsive' => 'mobile',
							'class' => 'mfn_field_mobile',
							'title' => __('Horizontal align', 'mfn-opts'),
							'options' => [
								'' => __('Left', 'mfn-opts'),
								'center' => __('Center', 'mfn-opts'),
								'flex-end' => __('Right', 'mfn-opts'),
								'space-between' => __('Space between', 'mfn-opts'),
								'space-around' => __('Space around', 'mfn-opts'),
							],
							'std' => 'space-around',
						),

						array(
   						'title' => __('Links', 'mfn-opts'),
   					),

   					array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .header_column_wrapper ul li a:align-items',
							'condition' => array( 'id' => 'menu_li_align', 'opt' => 'is', 'val' => 'stretch' ),
							'type' => 'select',
							'responsive' => 'desktop',
							'class' => 'mfn_field_desktop',
							'title' => __('Vertical spacing', 'mfn-opts'),
							'options' => array(
								'' => 'Default',
								'flex-start' => 'Top',
								'flex-end' => 'Bottom',
								'center' => 'Center',
							),
							'std' => '',
						),

						array(
		  				'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .menu .menu-item a:padding',
		  				'type' => 'dimensions',
		  				'title' => __('Padding', 'mfn-opts'),
							'responsive' => 'desktop',
							'class' => 'mfn_field_desktop',
							'css_attr' => 'padding',
		  			),

		  			array(
		  				'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .menu .menu-item a:padding_tablet',
		  				'type' => 'dimensions',
		  				'title' => __('Padding', 'mfn-opts'),
							'responsive' => 'tablet',
							'class' => 'mfn_field_tablet',
							'css_attr' => 'padding',
		  			),

		  			array(
		  				'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .menu .menu-item a:padding_mobile',
		  				'type' => 'dimensions',
		  				'title' => __('Padding', 'mfn-opts'),
							'responsive' => 'mobile',
							'class' => 'mfn_field_mobile',
							'css_attr' => 'padding',
		  			),

						array(
		  				'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .menu .menu-item a:margin',
		  				'type' => 'dimensions',
		  				'title' => __('Margin', 'mfn-opts'),
							'responsive' => 'desktop',
							'class' => 'mfn_field_desktop',
							'css_attr' => 'margin',
		  			),

		  			array(
		  				'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .menu .menu-item a:margin_tablet',
		  				'type' => 'dimensions',
		  				'title' => __('Margin', 'mfn-opts'),
							'responsive' => 'tablet',
							'class' => 'mfn_field_tablet',
							'css_attr' => 'margin',
		  			),

		  			array(
		  				'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .menu .menu-item a:margin_mobile',
		  				'type' => 'dimensions',
		  				'title' => __('Margin', 'mfn-opts'),
							'responsive' => 'mobile',
							'class' => 'mfn_field_mobile',
							'css_attr' => 'margin',
		  			),

		  			array(
							'type' => 'html',
							'title' => __('Typography', 'mfn-opts'),
							'label_after' => '<a href="#" title="Edit" class="mfn-option-btn mfn-option-blank btn-medium mfn-vb-label-button"><span class="mfn-icon mfn-icon-edit"></span></a>',
							'html' => '<div class="mfn-form-row toggle_fields mfn-vb-formrow mfn-vb-mfnuidhere">',
						),

						array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement:font-family',
							'type' => 'font_select',
							'title' => __( 'Font family', 'mfn-opts' ),
							'std' => ''
						),

		  			array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement:font-size',
							'type' => 'text',
							'class' => 'mfn_field_desktop',
							'title' => __('Size', 'mfn-opts'),
							'desc' => __('Use px, %, vw, vh or auto to set content width', 'mfn-opts'),
						),

						array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement:line-height',
							'type' => 'text',
							'class' => 'mfn_field_desktop',
							'title' => __('Line height', 'mfn-opts'),
						),

						array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement:letter-spacing',
							'type' => 'text',
							'class' => 'mfn_field_desktop',
							'title' => __('Letter spacing', 'mfn-opts'),
						),

						array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement:font-weight',
							'type' => 'select',
							'class' => 'mfn_field_desktop',
							'title' => __('Weight', 'mfn-opts'),
							'options' => array(
								'' => 'Default',
								'normal' => 'Normal',
								'bold' => 'Bold',
								'100' => '100',
								'200' => '200',
								'300' => '300',
								'400' => '400',
								'500' => '500',
								'600' => '600',
								'700' => '700',
								'800' => '800',
								'900' => '900'
							),
						),

						array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement:text-transform',
							'type' => 'select',
							'class' => 'mfn_field_desktop',
							'title' => __('Transform', 'mfn-opts'),
							'options' => array(
								'' => 'Default',
								'uppercase' => 'Uppercase',
								'lowercase' => 'Lowercase',
								'capitalize' => 'Capitalize',
								'none' => 'Normal',
							),
						),

						array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement:font-style',
							'type' => 'select',
							'class' => 'mfn_field_desktop',
							'title' => __('Style', 'mfn-opts'),
							'options' => array(
								'' => 'Default',
								'italic' => 'Italic',
								'normal' => 'Normal',
								'oblique' => 'Oblique',
							),
						),

						array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement:text-decoration',
							'type' => 'select',
							'class' => 'mfn_field_desktop',
							'title' => __('Decoration', 'mfn-opts'),
							'options' => array(
								'' => 'Default',
								'underline' => 'Underline',
								'overline' => 'Overline',
								'line-through' => 'Line through',
								'none' => 'None',
							),
						),

						array(
							'type' => 'html',
							'html' => '</div>',
						),

						array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement:text-shadow',
							'type' => 'text_shadow',
							'title' => __('Text shadow', 'mfn-opts'),
						),

						array(
   						'title' => __('Normal', 'mfn-opts'),
   					),

						array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .menu li a:color',
							'type' => 'color',
							'class' => 'main-color',
							'title' => __('Color', 'mfn-opts'),
						),

						array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .menu li a:background-color',
							'type' => 'color',
							'class' => 'main-color',
							'title' => __('Background', 'mfn-opts'),
						),

						array(
							'type' => 'html',
							'title' => __('Pointer', 'mfn-opts'),
							'html' => '<div class="mfn-form-row toggle_fields mfn-vb-formrow mfn-vb-mfnuidhere">',
						),

						array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .menu li a|before:width',
							'type' => 'text',
							'title' => __('Width', 'mfn-opts'),
						),

						array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .menu li a|before:height',
							'type' => 'text',
							'title' => __('Height', 'mfn-opts'),
						),

						array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .menu li a|before:background-color',
							'type' => 'color',
							'title' => __('Background', 'mfn-opts'),
						),

						array(
							'id' => 'menu-pointer-position',
							'type' => 'select',
							'title' => __('Position', 'mfn-opts'),
							'options' => array(
								'' => 'Top',
								'mfn-pointer-bottom' => 'Bottom',
							),
						),

						array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .menu li a|before:border-radius',
							'type' => 'text',
							'title' => __('border-radius', 'mfn-opts'),
						),

						array(
							'type' => 'html',
							'html' => '</div>',
						),

						array(
   						'title' => __('Hover', 'mfn-opts'),
   					),

						array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .menu li a|hover:color',
							'type' => 'color',
							'class' => 'main-color',
							'title' => __('Color', 'mfn-opts'),
						),

						array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .menu li a|hover:background-color',
							'type' => 'color',
							'class' => 'main-color',
							'title' => __('Background color', 'mfn-opts'),
						),

						array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .menu li a|hover|before:background-color',
							'type' => 'color',
							'title' => __('Pointer Background', 'mfn-opts'),
						),

						array(
   						'title' => __('Active', 'mfn-opts'),
   					),

						array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .menu li.current-menu-item a:color',
							'type' => 'color',
							'class' => 'main-color',
							'title' => __('Color', 'mfn-opts'),
						),

						array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .menu li.current-menu-item a:background-color',
							'type' => 'color',
							'class' => 'main-color',
							'title' => __('Background color', 'mfn-opts'),
						),

						array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .menu li.current-menu-item a|before:background-color',
							'type' => 'color',
							'title' => __('Pointer Background', 'mfn-opts'),
						),

						array(
							'type' => 'html',
							'html' => '</div>',
						),

						// advanced here

   				),
   			),

				// Header icon ----------------------------------------------------

   			'header_icon' => array(
   				'type' => 'header_icon',
   				'title' => __('Icon', 'mfn-opts'),
   				'size' => '1/1',
   				'cat' => 'header',
   				'fields' => array(

						array(
							'type' => 'html',
							'html' => $this->itemtabs,
						),

   					array(
							'type' => 'html',
							'html' => '<div class="modalbox-card modalbox-re_render modalbox-card-content-mfnuidhere active">',
						),

						array(
							'id' => 'type',
							'attr_id' => 'header_icon_type',
							'type' => 'select',
							'title' => __('Icon type', 'mfn-opts'),
							'options' => array(
								'tel' => 'Phone',
								'mail' => 'E-mail',
								'search' => 'Search',
								'menu' => 'Menu burger',
								'default' => 'Custom',
								'cart' => 'Shop cart',
								'account' => 'My account',
								'wishlist' => 'Wishlist',
							),
							'desc' => __('For icons: Shop cart, My account and Wishlist, woocommerce plugin is required', 'mfn-opts'),
							'std' => 'tel',
						),

						array(
   						'id' => 'icon',
   						'attr_id' => 'header_icon_font',
   						'type' => 'icon',
   						'title' => __('Icon', 'mfn-opts'),
   						'std' => 'icon-phone',
   					),

						array(
   						'id' => 'image',
   						'type' => 'upload',
   						'title' => __('Image icon', 'mfn-opts'),
   						'desc' => __('Recommended svg', 'mfn-opts'),
							'preview' => 'image',
   					),

   					array(
   						'id' => 'desc',
   						'condition' => array( 'id' => 'header_icon_type', 'opt' => 'is', 'val' => array('default', 'tel', 'mail') ),
   						'type' => 'text',
   						'title' => __('Desc', 'mfn-opts'),
   					),

   					array(
							'id' => 'link',
							'condition' => array( 'id' => 'header_icon_type', 'opt' => 'is', 'val' => 'default' ),
							'type' => 'text',
							'title' => __('Link ', 'mfn-opts'),
							'std' => '/',
						),

						array(
							'id' => 'wishlist_count',
							'condition' => array( 'id' => 'header_icon_type', 'opt' => 'is', 'val' => 'wishlist' ),
							'type' => 'switch',
							'title' => __('Wishlist count', 'mfn-opts'),
							'options' => array(
								'0' => 'Hide',
								'1' => 'Show',
							),
							'std' => '1',
						),

   					array(
							'id' => 'cart_total',
							'condition' => array( 'id' => 'header_icon_type', 'opt' => 'is', 'val' => 'cart' ),
							'type' => 'switch',
							'title' => __('Cart total ', 'mfn-opts'),
							'options' => array(
								'0' => 'Hide',
								'1' => 'Show',
							),
							'std' => '1',
						),

						array(
							'id' => 'cart_count',
							'condition' => array( 'id' => 'header_icon_type', 'opt' => 'is', 'val' => 'cart' ),
							'type' => 'switch',
							'title' => __('Cart count ', 'mfn-opts'),
							'options' => array(
								'0' => 'Hide',
								'1' => 'Show',
							),
							'std' => '1',
						),

						array(
							'id' => 'link_target',
							'condition' => array( 'id' => 'header_icon_type', 'opt' => 'is', 'val' => 'default' ),
							'type' => 'switch',
							'title' => __('Open in new tab', 'mfn-opts'),
							'options' => array(
								'' => 'No',
								'1' => 'Yes',
							),
							'std' => '0',
						),

   					array(
							'type' => 'html',
							'html' => '</div><div class="modalbox-card modalbox-card-style modalbox-re_render modalbox-card-style-mfnuidhere">',
						),

						array(
   						'title' => __('Position', 'mfn-opts'),
   					),

						array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .header_column_wrapper:align-items',
							'type' => 'select',
							'responsive' => 'desktop',
							'class' => 'mfn_field_desktop',
							'title' => __('Vertical spacing', 'mfn-opts'),
							'options' => array(
								'stretch' => 'Default',
								'flex-start' => 'Top',
								'flex-end' => 'Bottom',
								'center' => 'Center',
							),
							'std' => 'center',
						),

						array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .header_column_wrapper:align-items_tablet',
							'type' => 'select',
							'responsive' => 'tablet',
							'class' => 'mfn_field_tablet',
							'title' => __('Vertical spacing', 'mfn-opts'),
							'options' => array(
								'stretch' => 'Default',
								'flex-start' => 'Top',
								'flex-end' => 'Bottom',
								'center' => 'Center',
							),
							'std' => 'center',
						),

						array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .header_column_wrapper:align-items_mobile',
							'type' => 'select',
							'responsive' => 'mobile',
							'class' => 'mfn_field_mobile',
							'title' => __('Vertical spacing', 'mfn-opts'),
							'options' => array(
								'stretch' => 'Default',
								'flex-start' => 'Top',
								'flex-end' => 'Bottom',
								'center' => 'Center',
							),
							'std' => 'center',
						),

   					array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .header_column_wrapper:justify-content',
							'type' => 'select',
							'responsive' => 'desktop',
							'class' => 'mfn_field_desktop',
							'title' => __('Horizontal align', 'mfn-opts'),
							'options' => [
								'flex-start' => __('Left', 'mfn-opts'),
								'center' => __('Center', 'mfn-opts'),
								'flex-end' => __('Right', 'mfn-opts'),
								'space-between' => __('Space between', 'mfn-opts'),
								'space-around' => __('Space around', 'mfn-opts'),
							],
							'std' => 'flex-start',
						),

						array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .header_column_wrapper:justify-content_tablet',
							'type' => 'select',
							'responsive' => 'tablet',
							'class' => 'mfn_field_tablet',
							'title' => __('Horizontal align', 'mfn-opts'),
							'options' => [
								'flex-start' => __('Left', 'mfn-opts'),
								'center' => __('Center', 'mfn-opts'),
								'flex-end' => __('Right', 'mfn-opts'),
								'space-between' => __('Space between', 'mfn-opts'),
								'space-around' => __('Space around', 'mfn-opts'),
							],
							'std' => 'flex-start',
						),

						array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .header_column_wrapper:justify-content_mobile',
							'type' => 'select',
							'responsive' => 'mobile',
							'class' => 'mfn_field_mobile',
							'title' => __('Horizontal align', 'mfn-opts'),
							'options' => [
								'flex-start' => __('Left', 'mfn-opts'),
								'center' => __('Center', 'mfn-opts'),
								'flex-end' => __('Right', 'mfn-opts'),
								'space-between' => __('Space between', 'mfn-opts'),
								'space-around' => __('Space around', 'mfn-opts'),
							],
							'std' => 'flex-start',
						),

						array(
   						'title' => __('Icon', 'mfn-opts'),
   					),

   					array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mfn-header-icon:background-color',
							'type' => 'color',
							'title' => __('Background color', 'mfn-opts'),
						),

						array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mfn-header-icon:color',
							'type' => 'color',
							'title' => __('Color', 'mfn-opts'),
						),

						array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mfn-header-icon i:font-size',
							'condition' => array( 'id' => 'header_icon_font', 'opt' => 'isnt', 'val' => '' ),
							'type' => 'text',
							'title' => __('Icon size', 'mfn-opts'),
						),

						array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mfn-header-icon img:width',
							'condition' => array( 'id' => 'header_icon_font', 'opt' => 'is', 'val' => '' ),
							'type' => 'text',
							'title' => __('Icon size', 'mfn-opts'),
						),

						array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mfn-header-icon:width',
							'type' => 'text',
							'title' => __('Width', 'mfn-opts'),
						),

						array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mfn-header-icon:height',
							'type' => 'text',
							'title' => __('Height', 'mfn-opts'),
						),

						array(
		  				'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mfn-header-icon:margin',
		  				'type' => 'dimensions',
		  				'title' => __('Margin', 'mfn-opts'),
							'responsive' => 'desktop',
							'class' => 'mfn_field_desktop',
							'css_attr' => 'margin',
		  			),

		  			array(
		  				'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mfn-header-icon:margin_tablet',
		  				'type' => 'dimensions',
		  				'title' => __('Margin', 'mfn-opts'),
							'responsive' => 'tablet',
							'class' => 'mfn_field_tablet',
							'css_attr' => 'margin',
		  			),

		  			array(
		  				'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mfn-header-icon:margin_mobile',
		  				'type' => 'dimensions',
		  				'title' => __('Margin', 'mfn-opts'),
							'responsive' => 'mobile',
							'class' => 'mfn_field_mobile',
							'css_attr' => 'margin',
		  			),

		  			array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mfn-header-icon:border-style',
							'type' => 'select',
							'title' => __('Border style', 'mfn-opts'),
							'options' => [
								'none' => __('None', 'mfn-opts'),
								'solid' => __('Solid', 'mfn-opts'),
								'dashed' => __('Dashed', 'mfn-opts'),
								'dotted' => __('Dotted', 'mfn-opts'),
								'double' => __('Double', 'mfn-opts'),
							],
						),

						array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mfn-header-icon:border-color',
							'type' => 'color',
							'title' => __('Border color', 'mfn-opts'),
						),

						array(
		  				'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mfn-header-icon:border-width',
		  				'type' => 'dimensions',
		  				'title' => __('Border width', 'mfn-opts'),
							'responsive' => 'desktop',
							'class' => 'mfn_field_desktop',
							'css_attr' => 'border-width',
		  			),

		  			array(
		  				'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mfn-header-icon:border-width_tablet',
		  				'type' => 'dimensions',
		  				'title' => __('Border width', 'mfn-opts'),
							'responsive' => 'tablet',
							'class' => 'mfn_field_tablet',
							'css_attr' => 'border-width',
		  			),

		  			array(
		  				'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mfn-header-icon:border-width_mobile',
		  				'type' => 'dimensions',
		  				'title' => __('Border width', 'mfn-opts'),
							'responsive' => 'mobile',
							'class' => 'mfn_field_mobile',
							'css_attr' => 'border-width',
		  			),

						array(
		  				'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mfn-header-icon:border-radius',
		  				'type' => 'dimensions',
		  				'title' => __('Border radius', 'mfn-opts'),
							'responsive' => 'desktop',
							'class' => 'mfn_field_desktop',
							'css_attr' => 'border-radius',
		  			),

		  			array(
		  				'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mfn-header-icon:border-radius_tablet',
		  				'type' => 'dimensions',
		  				'title' => __('Border radius', 'mfn-opts'),
							'responsive' => 'tablet',
							'class' => 'mfn_field_tablet',
							'css_attr' => 'border-radius',
		  			),

		  			array(
		  				'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mfn-header-icon:border-radius_mobile',
		  				'type' => 'dimensions',
		  				'title' => __('Border radius', 'mfn-opts'),
							'responsive' => 'mobile',
							'class' => 'mfn_field_mobile',
							'css_attr' => 'border-radius',
		  			),

						array(
   						'title' => __('Content', 'mfn-opts'),
   					),

		  			array(
							'type' => 'html',
							'title' => __('Typography', 'mfn-opts'),
							'label_after' => '<a href="#" title="Edit" class="mfn-option-btn mfn-option-blank btn-medium mfn-vb-label-button"><span class="mfn-icon mfn-icon-edit"></span></a>',
							'html' => '<div class="mfn-form-row toggle_fields mfn-vb-formrow mfn-vb-mfnuidhere">',
						),

						array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement:font-family',
							'type' => 'font_select',
							'title' => __( 'Font family', 'mfn-opts' ),
							'std' => ''
						),

		  			array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement:font-size',
							'type' => 'text',
							'class' => 'mfn_field_desktop',
							'title' => __('Size', 'mfn-opts'),
							'desc' => __('Use px, %, vw, vh or auto to set content width', 'mfn-opts'),
						),

						array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement:line-height',
							'type' => 'text',
							'class' => 'mfn_field_desktop',
							'title' => __('Line height', 'mfn-opts'),
						),

						array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement:letter-spacing',
							'type' => 'text',
							'class' => 'mfn_field_desktop',
							'title' => __('Letter spacing', 'mfn-opts'),
						),

						array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement:font-weight',
							'type' => 'select',
							'class' => 'mfn_field_desktop',
							'title' => __('Weight', 'mfn-opts'),
							'options' => array(
								'' => 'Default',
								'normal' => 'Normal',
								'bold' => 'Bold',
								'100' => '100',
								'200' => '200',
								'300' => '300',
								'400' => '400',
								'500' => '500',
								'600' => '600',
								'700' => '700',
								'800' => '800',
								'900' => '900'
							),
						),

						array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement:text-transform',
							'type' => 'select',
							'class' => 'mfn_field_desktop',
							'title' => __('Transform', 'mfn-opts'),
							'options' => array(
								'' => 'Default',
								'uppercase' => 'Uppercase',
								'lowercase' => 'Lowercase',
								'capitalize' => 'Capitalize',
								'none' => 'Normal',
							),
						),

						array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement:font-style',
							'type' => 'select',
							'class' => 'mfn_field_desktop',
							'title' => __('Style', 'mfn-opts'),
							'options' => array(
								'' => 'Default',
								'italic' => 'Italic',
								'normal' => 'Normal',
								'oblique' => 'Oblique',
							),
						),

						array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement:text-decoration',
							'type' => 'select',
							'class' => 'mfn_field_desktop',
							'title' => __('Decoration', 'mfn-opts'),
							'options' => array(
								'' => 'Default',
								'underline' => 'Underline',
								'overline' => 'Overline',
								'line-through' => 'Line through',
								'none' => 'None',
							),
						),

						array(
							'type' => 'html',
							'html' => '</div>',
						),

						array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement:text-shadow',
							'type' => 'text_shadow',
							'title' => __('Text shadow', 'mfn-opts'),
						),

						array(
   						'title' => __('Normal', 'mfn-opts'),
   					),

						array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .header_column_wrapper:color',
							'type' => 'color',
							'class' => 'main-color',
							'title' => __('Color', 'mfn-opts'),
						),

						array(
   						'title' => __('Hover', 'mfn-opts'),
   					),

						array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement a.header_column_wrapper|hover:color',
							'type' => 'color',
							'class' => 'main-color',
							'title' => __('Color', 'mfn-opts'),
						),

						array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .header_column_wrapper|hover:background-color',
							'type' => 'color',
							'class' => 'main-color',
							'title' => __('Background color', 'mfn-opts'),
						),

						array(
							'type' => 'html',
							'html' => '</div>',
						),

						// advanced here

   				),
   			),

				// Header Promo Bar ----------------------------------------------------

   			'header_promo_bar' => array(
   				'type' => 'header_promo_bar',
   				'title' => __('Promo bar', 'mfn-opts'),
   				'size' => '1/1',
   				'cat' => 'header',
   				'fields' => array(

						array(
							'type' => 'html',
							'html' => $this->itemtabs,
						),

   					array(
							'type' => 'html',
							'html' => '<div class="modalbox-card modalbox-re_render modalbox-card-content-mfnuidhere active">',
						),

						array(
   						'id' => 'tabs',
   						'type' => 'tabs',
   						'title' => __('Slides', 'mfn-opts'),
							'options' => [
								'title' => [
									'input',
									__('Title', 'mfn-opts'),
									__('Sample slide', 'mfn-opts'),
								],
								'content' => [
									'textarea',
									__('Content', 'mfn-opts'),
									'Lorem ipsum dolor sit amet, consectetur adipiscing elit. Mauris eu massa orci.',
								],
							],
							'std' => [
								0 => [
									'title' => __('This is the 1st item', 'mfn-opts'),
									'content' => 'Lorem ipsum dolor sit amet, consectetur adipiscing elit. Mauris eu massa orci.',
								],
							],
							'preview' => 'tabs',
							// 'primary' => 'title', // default
   					),

   					array(
							'type' => 'html',
							'html' => '</div><div class="modalbox-card modalbox-card-style modalbox-re_render modalbox-card-style-mfnuidhere">',
						),

						array(
   						'title' => __('Position', 'mfn-opts'),
   					),

						array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .header_column_wrapper:align-items',
							'type' => 'select',
							'responsive' => 'desktop',
							'class' => 'mfn_field_desktop',
							'title' => __('Vertical spacing', 'mfn-opts'),
							'options' => array(
								'stretch' => 'Default',
								'flex-start' => 'Top',
								'flex-end' => 'Bottom',
								'center' => 'Center',
							),
							'std' => 'center',
						),

						array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .header_column_wrapper:align-items_tablet',
							'type' => 'select',
							'responsive' => 'tablet',
							'class' => 'mfn_field_tablet',
							'title' => __('Vertical spacing', 'mfn-opts'),
							'options' => array(
								'stretch' => 'Default',
								'flex-start' => 'Top',
								'flex-end' => 'Bottom',
								'center' => 'Center',
							),
							'std' => 'center',
						),

						array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .header_column_wrapper:align-items_mobile',
							'type' => 'select',
							'responsive' => 'mobile',
							'class' => 'mfn_field_mobile',
							'title' => __('Vertical spacing', 'mfn-opts'),
							'options' => array(
								'stretch' => 'Default',
								'flex-start' => 'Top',
								'flex-end' => 'Bottom',
								'center' => 'Center',
							),
							'std' => 'center',
						),

   					array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .header_column_wrapper:justify-content',
							'type' => 'select',
							'responsive' => 'desktop',
							'class' => 'mfn_field_desktop',
							'title' => __('Horizontal align', 'mfn-opts'),
							'options' => [
								'flex-start' => __('Left', 'mfn-opts'),
								'center' => __('Center', 'mfn-opts'),
								'flex-end' => __('Right', 'mfn-opts'),
								'space-between' => __('Space between', 'mfn-opts'),
								'space-around' => __('Space around', 'mfn-opts'),
							],
							'std' => 'flex-start',
						),

						array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .header_column_wrapper:justify-content_tablet',
							'type' => 'select',
							'responsive' => 'tablet',
							'class' => 'mfn_field_tablet',
							'title' => __('Horizontal align', 'mfn-opts'),
							'options' => [
								'flex-start' => __('Left', 'mfn-opts'),
								'center' => __('Center', 'mfn-opts'),
								'flex-end' => __('Right', 'mfn-opts'),
								'space-between' => __('Space between', 'mfn-opts'),
								'space-around' => __('Space around', 'mfn-opts'),
							],
							'std' => 'flex-start',
						),

						array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .header_column_wrapper:justify-content_mobile',
							'type' => 'select',
							'responsive' => 'mobile',
							'class' => 'mfn_field_mobile',
							'title' => __('Horizontal align', 'mfn-opts'),
							'options' => [
								'flex-start' => __('Left', 'mfn-opts'),
								'center' => __('Center', 'mfn-opts'),
								'flex-end' => __('Right', 'mfn-opts'),
								'space-between' => __('Space between', 'mfn-opts'),
								'space-around' => __('Space around', 'mfn-opts'),
							],
							'std' => 'flex-start',
						),

						array(
   						'title' => __('Content', 'mfn-opts'),
   					),

		  			array(
							'type' => 'html',
							'title' => __('Typography', 'mfn-opts'),
							'label_after' => '<a href="#" title="Edit" class="mfn-option-btn mfn-option-blank btn-medium mfn-vb-label-button"><span class="mfn-icon mfn-icon-edit"></span></a>',
							'html' => '<div class="mfn-form-row toggle_fields mfn-vb-formrow mfn-vb-mfnuidhere">',
						),

						array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement:font-family',
							'type' => 'font_select',
							'title' => __( 'Font family', 'mfn-opts' ),
							'std' => ''
						),

		  			array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement:font-size',
							'type' => 'text',
							'class' => 'mfn_field_desktop',
							'title' => __('Size', 'mfn-opts'),
							'desc' => __('Use px, %, vw, vh or auto to set content width', 'mfn-opts'),
						),

						array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement:line-height',
							'type' => 'text',
							'class' => 'mfn_field_desktop',
							'title' => __('Line height', 'mfn-opts'),
						),

						array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement:letter-spacing',
							'type' => 'text',
							'class' => 'mfn_field_desktop',
							'title' => __('Letter spacing', 'mfn-opts'),
						),

						array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement:font-weight',
							'type' => 'select',
							'class' => 'mfn_field_desktop',
							'title' => __('Weight', 'mfn-opts'),
							'options' => array(
								'' => 'Default',
								'normal' => 'Normal',
								'bold' => 'Bold',
								'100' => '100',
								'200' => '200',
								'300' => '300',
								'400' => '400',
								'500' => '500',
								'600' => '600',
								'700' => '700',
								'800' => '800',
								'900' => '900'
							),
						),

						array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement:text-transform',
							'type' => 'select',
							'class' => 'mfn_field_desktop',
							'title' => __('Transform', 'mfn-opts'),
							'options' => array(
								'' => 'Default',
								'uppercase' => 'Uppercase',
								'lowercase' => 'Lowercase',
								'capitalize' => 'Capitalize',
								'none' => 'Normal',
							),
						),

						array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement:font-style',
							'type' => 'select',
							'class' => 'mfn_field_desktop',
							'title' => __('Style', 'mfn-opts'),
							'options' => array(
								'' => 'Default',
								'italic' => 'Italic',
								'normal' => 'Normal',
								'oblique' => 'Oblique',
							),
						),

						array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement:text-decoration',
							'type' => 'select',
							'class' => 'mfn_field_desktop',
							'title' => __('Decoration', 'mfn-opts'),
							'options' => array(
								'' => 'Default',
								'underline' => 'Underline',
								'overline' => 'Overline',
								'line-through' => 'Line through',
								'none' => 'None',
							),
						),

						array(
							'type' => 'html',
							'html' => '</div>',
						),

						array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement:text-shadow',
							'type' => 'text_shadow',
							'title' => __('Text shadow', 'mfn-opts'),
						),

						array(
   						'title' => __('Normal', 'mfn-opts'),
   					),

						array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .header_column_wrapper:color',
							'type' => 'color',
							'class' => 'main-color',
							'title' => __('Color', 'mfn-opts'),
						),

						array(
							'type' => 'html',
							'html' => '</div>',
						),

						// advanced here

   				),
   			),

				*/

				// Shop Products ----------------------------------------------------

   			'shop_products' => array(
   				'type' => 'shop_products',
   				'title' => __('Shop products', 'mfn-opts'),
   				'desc' => __('List of products from woocommerce', 'mfn-opts'),
   				'size' => '1/1',
   				'tablet_size' => '1/1',
   				'mobile_size' => '1/1',
   				'tablet_resized' => '0',
   				'cat' => 'shop-archive',
   				'fields' => array(

   					array(
							'type' => 'html',
							'html' => '<div class="modalbox-card modalbox-re_render modalbox-card-content-mfnuidhere active">',
						),

						array(
   						'id' => 'products',
   						'type' => 'text',
   						're_render' => 'standard',
   						'title' => __('Products per page', 'mfn-opts'),
   						'std' => '12',
   						'after' => 'products',
   						'param' => 'number',
   						'class' => 'narrow',
							'preview' => 'number',
   					),

   					array(
   						'id' => 'layout',
   						'type' => 'select',
   						're_render' => 'standard',
   						'title' => __('Columns', 'mfn-opts'),
							'options' => array(
								'grid' => __('Grid, 3 columns', 'mfn-opts'),
								'grid col-4' => __('Grid, 4 columns', 'mfn-opts'),
								'masonry' => __('Masonry, 3 columns', 'mfn-opts'),
								'list' => __('List', 'mfn-opts'),
							),
   						'std' => 'grid',
   					),

						// options

   					array(
   						'title' => __('Options', 'mfn-opts'),
   					),

						array(
							'id' => 'description',
							're_render' => 'standard',
							'type' => 'switch',
							'title' => __('Description', 'mfn-opts'),
							'options' => array(
								'0' => __('Hide', 'mfn-opts'),
								'1' => __('Show', 'mfn-opts'),
                'list' => __('List layout only', 'mfn-opts'),
							),
							'std' => '0'
						),

						array(
							'id' => 'button',
							're_render' => 'standard',
							'type' => 'switch',
							'title' => __('Add to cart button', 'mfn-opts'),
							'desc' => __('Required for some plugins', 'mfn-opts'),
							'options' => array(
								'0' => __('Hide', 'mfn-opts'),
								'1' => __('Show', 'mfn-opts'),
                'list' => __('List layout only', 'mfn-opts'),
							),
							'std' => '0',
						),

						array(
							'id' => 'title_tag',
							'type' => 'switch',
							're_render' => 'standard',
							'title' => __('Title tag', 'mfn-opts'),
							'options' => [
								'h1' => 'H1',
								'h2' => 'H2',
								'h3' => 'H3',
								'h4' => 'H4',
								'h5' => 'H5',
								'h6' => 'H6',
								'p' => 'p',
								'span' => 'span',
							],
							'std' => 'h2',
						),

						// order

						array(
							'title' => __('Order', 'mfn-opts'),
						),

						array(
							'id' => 'order',
							'type' => 'order',
							're_render' => 'standard',
							'title' => __('Order', 'mfn-opts'),
							'std' => 'image,title,price,description,button',
						),

						// HTML style

						array(
							'type' => 'html',
							'html' => '</div><div class="modalbox-card modalbox-card-style modalbox-re_render modalbox-card-style-mfnuidhere">',
						),

						// image

						array(
							'title' => __('Image', 'mfn-opts'),
						),

						array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement ul.products li.product .image_frame, .mcb-section .mcb-wrap .mcb-item-mfnuidelement ul.products li.product .hover_box_wrapper:border-radius',
							'oldid' => 'style:.image_frame, .hover_box_wrapper:border-radius',
							'type' => 'text',
							'desc' => __('Use px or %', 'mfn-opts'),
							'title' => __('Border radius', 'mfn-opts'),
						),

						// title

						array(
							'title' => __('Title', 'mfn-opts'),
						),

						array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement ul.products li.product:text-align',
							'oldid' => 'style:li.product:text-align',
							'type' => 'switch',
							'title' => __('Text align', 'mfn-opts'),
							'options' => [
								'' => __('Default', 'mfn-opts'),
								'left' => __('Left', 'mfn-opts'),
								'center' => __('Center', 'mfn-opts'),
								'right' => __('Right', 'mfn-opts'),
							],
							'std' => '',
						),

						array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement ul.products li.product .title:font-size',
							'oldid' => 'style:ul.products li.product .title:font-size',
							'type' => 'text',
							'title' => __('Title font size', 'mfn-opts'),
						),

						array(
							'title' => __('Price', 'mfn-opts'),
						),

						array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement ul.products li.product .price:font-size',
							'oldid' => 'style:ul.products li.product .price:font-size',
							'type' => 'text',
							'title' => __('Price font size', 'mfn-opts'),
						),

   					// HTML end: style

						array(
   						'type' => 'html',
   						'html' => '</div>',
   					),

   				),
   			),

   			// Shop Title ----------------------------------------------------

   			'shop_title' => array(
   				'type' => 'shop_title',
   				'title' => __('Shop title', 'mfn-opts'),
   				'size' => '1/1',
   				'tablet_size' => '1/1',
   				'mobile_size' => '1/1',
   				'tablet_resized' => '0',
   				'cat' => 'shop-archive',
   				'fields' => array(

						array(
							'type' => 'html',
							'html' => '<div class="modalbox-card modalbox-re_render modalbox-card-content-mfnuidhere active">',
						),

						/*array(
							'id' => 'info',
   						'type' => 'info',
   						'title' => __('This element has no attributes. Please check <b>style</b> tab for more customisation options.', 'mfn-opts'),
   					),*/

   					array(
							'id' => 'title_tag',
							'type' => 'switch',
							're_render' => 'standard',
							'title' => __('Title tag', 'mfn-opts'),
							'options' => [
								'h1' => 'H1',
								'h2' => 'H2',
								'h3' => 'H3',
								'h4' => 'H4',
								'h5' => 'H5',
								'h6' => 'H6',
								'p' => 'p',
								'span' => 'span',
							],
							'std' => 'h1',
						),

						array(
							'type' => 'html',
							'html' => '</div><div class="modalbox-card modalbox-card-style modalbox-re_render modalbox-card-style-mfnuidhere">',
						),

						// title

						array(
							'title' => __('Title', 'mfn-opts'),
						),

						array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .page-title:text-align',
							'oldid' => 'style:.page-title:text-align',
							'type' => 'switch',
							'title' => __('Text align', 'mfn-opts'),
							'options' => [
								'' => __('Default', 'mfn-opts'),
								'left' => __('Left', 'mfn-opts'),
								'center' => __('Center', 'mfn-opts'),
								'right' => __('Right', 'mfn-opts'),
							],
							'std' => '',
						),

						array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .page-title:font-size',
							'oldid' => 'style:.page-title:font-size',
							'type' => 'text',
							'title' => __('Font size', 'mfn-opts'),
							'param' => 'number',
							'class' => 'narrow',
							'after' => 'px',
						),

   					// HTML end: style

						array(
   						'type' => 'html',
   						'html' => '</div>',
   					),

   				),
   			),

   			// Product Title ----------------------------------------------------

   			'product_title' => array(
   				'type' => 'product_title',
   				'title' => __('Product title', 'mfn-opts'),
   				'size' => '1/1',
   				'tablet_size' => '1/1',
   				'mobile_size' => '1/1',
   				'tablet_resized' => '0',
   				'cat' => 'single-product',
   				'fields' => array(

						array(
							'type' => 'html',
							'html' => '<div class="modalbox-card modalbox-re_render modalbox-card-content-mfnuidhere active">',
						),

						/*array(
							'id' => 'info',
   						'type' => 'info',
   						'title' => __('This element has no attributes. Please check <b>style</b> tab for more customisation options.', 'mfn-opts'),
   					),*/

   					array(
							'id' => 'title_tag',
							'type' => 'switch',
							're_render' => 'standard',
							'title' => __('Title tag', 'mfn-opts'),
							'options' => [
								'h1' => 'H1',
								'h2' => 'H2',
								'h3' => 'H3',
								'h4' => 'H4',
								'h5' => 'H5',
								'h6' => 'H6',
								'p' => 'p',
								'span' => 'span',
							],
							'std' => 'h1',
						),

						array(
							'type' => 'html',
							'html' => '</div><div class="modalbox-card modalbox-card-style modalbox-re_render modalbox-card-style-mfnuidhere">',
						),

						// title

						array(
							'title' => __('Title', 'mfn-opts'),
						),

						array(
							'id' => 'style:.title:text-align',
							'oldid' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .title:text-align',
							'type' => 'switch',
							'title' => __('Text align', 'mfn-opts'),
							'options' => [
								'' => __('Default', 'mfn-opts'),
								'left' => __('Left', 'mfn-opts'),
								'center' => __('Center', 'mfn-opts'),
								'right' => __('Right', 'mfn-opts'),
							],
							'std' => '',
						),

						array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .title:font-size',
							'oldid' => 'style:.title:font-size',
							'type' => 'text',
							'title' => __('Font size', 'mfn-opts'),
						),

   					// HTML end: style

						array(
   						'type' => 'html',
   						'html' => '</div>',
   					),

   				),
   			),

   			// Product images ----------------------------------------------------

   			'product_images' => array(
   				'type' => 'product_images',
   				'title' => __('Product images', 'mfn-opts'),
   				'size' => '1/1',
   				'tablet_size' => '1/1',
   				'mobile_size' => '1/1',
   				'tablet_resized' => '0',
   				'cat' => 'single-product',
   				'fields' => array(

						array(
							'type' => 'html',
							'html' => '<div class="modalbox-card modalbox-re_render modalbox-card-content-mfnuidhere active">',
						),

						// options

   					array(
   						'title' => __('Options', 'mfn-opts'),
   					),

   					array(
   						'id' => 'zoom',
   						'type' => 'switch',
   						'title' => __('Zoom effect', 'mfn-opts'),
							'options' => array(
								'0' => __('Disable', 'mfn-opts'),
								'1' => __('Enable', 'mfn-opts'),
							),
   						'std' => '1',
   					),

						array(
							'type' => 'html',
							'html' => '</div><div class="modalbox-card modalbox-card-style modalbox-re_render modalbox-card-style-mfnuidhere">',
						),

						// image

						array(
							'title' => __('Image', 'mfn-opts'),
						),

						array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .woocommerce-product-gallery__wrapper .woocommerce-product-gallery__image:border-radius',
							'oldid' => 'style:.woocommerce-product-gallery__wrapper img:border-radius',
							'type' => 'text',
							'class' => 'product-main-image',
							'title' => __('Border radius', 'mfn-opts'),
						),

						// thumbnails

						array(
							'title' => __('Thumbnails', 'mfn-opts'),
						),

						array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .flex-control-thumbs img:border-radius',
							'oldid' => 'style:.flex-control-thumbs img:border-radius',
							'type' => 'text',
							'class' => 'product-thumbs',
							'title' => __('Border radius', 'mfn-opts'),
						),

   					// HTML end: style

						array(
   						'type' => 'html',
   						'html' => '</div>',
   					),

   				),
   			),

   			// Product price ----------------------------------------------------

   			'product_price' => array(
   				'type' => 'product_price',
   				'title' => __('Product price', 'mfn-opts'),
   				'size' => '1/1',
   				'tablet_size' => '1/1',
   				'mobile_size' => '1/1',
   				'tablet_resized' => '0',
   				'cat' => 'single-product',
   				'fields' => array(

						array(
							'type' => 'html',
							'html' => '<div class="modalbox-card modalbox-re_render modalbox-card-content-mfnuidhere active">',
						),

						array(
							'id' => 'info',
   						'type' => 'info',
   						'title' => __('This element has no attributes. Please check <b>style</b> tab for more customisation options.', 'mfn-opts'),
   					),

						array(
							'type' => 'html',
							'html' => '</div><div class="modalbox-card modalbox-card-style modalbox-re_render modalbox-card-style-mfnuidhere">',
						),

						// price

						array(
							'title' => __('Price', 'mfn-opts'),
						),

						array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .price:text-align',
							'oldid' => 'style:.price:text-align',
							'type' => 'switch',
							'title' => __('Text align', 'mfn-opts'),
							'options' => [
								'' => __('Default', 'mfn-opts'),
								'left' => __('Left', 'mfn-opts'),
								'center' => __('Center', 'mfn-opts'),
								'right' => __('Right', 'mfn-opts'),
							],
							'std' => '',
						),

						array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .price:font-size',
							'oldid' => 'style:.price:font-size',
							'type' => 'text',
							'title' => __('Font size', 'mfn-opts'),
						),

						array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .price:color',
							'oldid' => 'style:.price:color',
							'type' => 'color',
							'class' => 'main-color',
							'title' => __('Color', 'mfn-opts'),
						),

						// sale

						array(
							'title' => __('Sale price', 'mfn-opts'),
						),

						array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .price > del:color',
							'oldid' => 'style:.price > del:color',
							'type' => 'color',
							'class' => 'sales-color',
							'title' => __('Color', 'mfn-opts'),
						),

   					// HTML end: style

						array(
   						'type' => 'html',
   						'html' => '</div>',
   					),

   				),
   			),

   			// Product add to cart ----------------------------------------------------

   			'product_cart_button' => array(
   				'type' => 'product_cart_button',
   				'title' => __('Add to cart', 'mfn-opts'),
   				'size' => '1/1',
   				'tablet_size' => '1/1',
   				'mobile_size' => '1/1',
   				'tablet_resized' => '0',
   				'cat' => 'single-product',
   				'fields' => array(

						array(
							'type' => 'html',
							'html' => '<div class="modalbox-card modalbox-re_render modalbox-card-content-mfnuidhere active">',
						),

						array(
							'id' => 'cart_button_text',
							'type' => 'text',
							'title' => __('Button text', 'mfn-opts'),
							'std' => __('Add to cart', 'woocommerce'),
						),

						array(
							'type' => 'html',
							'html' => '</div><div class="modalbox-card modalbox-card-style modalbox-re_render modalbox-card-style-mfnuidhere">',
						),

						array(
							'id' => 'info',
   						'type' => 'info',
   						'title' => __('This element has no styles. Please check <b>Advanced</b> tab for more customisation options.', 'mfn-opts'),
   					),

						array(
							'type' => 'html',
							'html' => '</div>',
						),

   				),
   			),

   			// Product breadcrumbs ----------------------------------------------------

   			'product_breadcrumbs' => array(
   				'type' => 'product_breadcrumbs',
   				'title' => __('Breadcrumbs', 'mfn-opts'),
   				'size' => '1/1',
   				'tablet_size' => '1/1',
   				'mobile_size' => '1/1',
   				'tablet_resized' => '0',
   				'cat' => 'single-product',
   				'fields' => array(

						array(
							'type' => 'html',
							'html' => '<div class="modalbox-card modalbox-re_render modalbox-card-content-mfnuidhere active">',
						),

						array(
							'title' => __('Custom', 'mfn-opts'),
						),

						array(
							'id' => 'breadcrumb_delimiter',
							'type' => 'text',
							'title' => __('Delimiter', 'mfn-opts'),
							'std' => '/',
						),

						array(
							'id' => 'breadcrumb_home',
							'type' => 'switch',
							'title' => __('Home page', 'mfn-opts'),
							'options' => [
								'0' => 'No',
								'1' => 'Include',
							],
							'std' => '1',
						),

						array(
							'type' => 'html',
							'html' => '</div><div class="modalbox-card modalbox-card-style modalbox-re_render modalbox-card-style-mfnuidhere">',
						),


						array(
							'id' => 'info',
   						'type' => 'info',
   						'title' => __('This element has no styles. Please check <b>Advanced</b> tab for more customisation options.', 'mfn-opts'),
   					),

						array(
							'type' => 'html',
							'html' => '</div>',
						),

   				),
   			),

   			// Product reviews ----------------------------------------------------

   			'product_reviews' => array(
   				'type' => 'product_reviews',
   				'title' => __('Product reviews', 'mfn-opts'),
   				'size' => '1/1',
   				'tablet_size' => '1/1',
   				'mobile_size' => '1/1',
   				'tablet_resized' => '0',
   				'cat' => 'single-product',
   				'fields' => array(

						array(
							'type' => 'html',
							'html' => '<div class="modalbox-card modalbox-re_render modalbox-card-content-mfnuidhere active">',
						),

						array(
							'id' => 'info',
   						'type' => 'info',
   						'title' => __('This element has no attributes. Please check <b>style</b> tab for more customisation options.', 'mfn-opts'),
   					),

						array(
							'type' => 'html',
							'html' => '</div><div class="modalbox-card modalbox-card-style modalbox-re_render modalbox-card-style-mfnuidhere">',
						),

						array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .rating:text-align',
							'oldid' => 'style:.rating:text-align',
							'type' => 'switch',
							'title' => __('Text align', 'mfn-opts'),
							'options' => [
								'' => __('Default', 'mfn-opts'),
								'left' => __('Left', 'mfn-opts'),
								'center' => __('Center', 'mfn-opts'),
								'right' => __('Right', 'mfn-opts'),
							],
							'std' => '',
						),

   					// HTML end: style

						array(
   						'type' => 'html',
   						'html' => '</div>',
   					),

   				),
   			),

   			// Product rating ----------------------------------------------------

   			'product_rating' => array(
   				'type' => 'product_rating',
   				'title' => __('Product rating', 'mfn-opts'),
   				'size' => '1/1',
   				'tablet_size' => '1/1',
   				'mobile_size' => '1/1',
   				'tablet_resized' => '0',
   				'cat' => 'single-product',
   				'fields' => array(

						array(
							'type' => 'html',
							'html' => '<div class="modalbox-card modalbox-re_render modalbox-card-content-mfnuidhere active">',
						),

						array(
							'id' => 'info',
   						'type' => 'info',
   						'title' => __('This element has no attributes. Please check <b>style</b> tab for more customisation options.', 'mfn-opts'),
   					),

   					array(
							'type' => 'html',
							'html' => '</div><div class="modalbox-card modalbox-card-style modalbox-re_render modalbox-card-style-mfnuidhere">',
						),

						// custom

						array(
							'title' => __('Custom', 'mfn-opts'),
						),

						array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .woocommerce-product-rating:text-align',
							'oldid' => 'style:.woocommerce-product-rating:text-align',
							'type' => 'switch',
							'title' => __('Text align', 'mfn-opts'),
							'options' => [
								'' => __('Default', 'mfn-opts'),
								'left' => __('Left', 'mfn-opts'),
								'center' => __('Center', 'mfn-opts'),
								'right' => __('Right', 'mfn-opts'),
							],
							'std' => '',
						),

						array(
   						'type' => 'html',
   						'html' => '</div>',
   					),

   				),
   			),


   			// Product stock ----------------------------------------------------

   			'product_stock' => array(
   				'type' => 'product_stock',
   				'title' => __('Product stock', 'mfn-opts'),
   				'size' => '1/1',
   				'tablet_size' => '1/1',
   				'mobile_size' => '1/1',
   				'tablet_resized' => '0',
   				'cat' => 'single-product',
   				'fields' => array(

						array(
							'type' => 'html',
							'html' => '<div class="modalbox-card modalbox-re_render modalbox-card-content-mfnuidhere active">',
						),

						array(
							'id' => 'info',
   						'type' => 'info',
   						'title' => __('To display stock, please enable stock management at product level and set its quantity. This element has no attributes. Please check <b>style</b> tab for more customisation options.', 'mfn-opts'),
   					),

						array(
							'type' => 'html',
							'html' => '</div><div class="modalbox-card modalbox-card-style modalbox-re_render modalbox-card-style-mfnuidhere">',
						),

						array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .stock:text-align',
							'oldid' => 'style:.stock:text-align',
							'type' => 'switch',
							'title' => __('Text align', 'mfn-opts'),
							'options' => [
								'' => __('Default', 'mfn-opts'),
								'left' => __('Left', 'mfn-opts'),
								'center' => __('Center', 'mfn-opts'),
								'right' => __('Right', 'mfn-opts'),
							],
							'std' => '',
						),

   					// HTML end: style

						array(
   						'type' => 'html',
   						'html' => '</div>',
   					),

   				),
   			),

   			// Product meta ----------------------------------------------------

   			'product_meta' => array(
   				'type' => 'product_meta',
   				'title' => __('Product meta', 'mfn-opts'),
   				'size' => '1/1',
   				'tablet_size' => '1/1',
   				'mobile_size' => '1/1',
   				'tablet_resized' => '0',
   				'cat' => 'single-product',
   				'fields' => array(

						array(
							'type' => 'html',
							'html' => '<div class="modalbox-card modalbox-re_render modalbox-card-content-mfnuidhere active">',
						),

						array(
							'title' => __('Options', 'mfn-opts'),
						),

						array(
							'id' => 'layout',
							'type' => 'switch',
							're_render' => 'standard',
							'title' => __('Layout', 'mfn-opts'),
							'options' => [
								'inline' => __('Inline', 'mfn-opts'),
								'stacked' => __('Stacked', 'mfn-opts'),
								'table' => __('Table', 'mfn-opts'),
							],
							'std' => 'inline',
						),

						array(
							'type' => 'html',
							'html' => '</div><div class="modalbox-card modalbox-card-style modalbox-re_render modalbox-card-style-mfnuidhere">',
						),

						array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .product_meta, .mcb-section .mcb-wrap .mcb-item-mfnuidelement .product_meta th, .mcb-section .mcb-wrap .mcb-item-mfnuidelement .product_meta td:text-align',
							'oldid' => 'style:.product_meta, .product_meta th, .product_meta td:text-align',
							'type' => 'switch',
							'title' => __('Text align', 'mfn-opts'),
							'options' => [
								'' => __('Default', 'mfn-opts'),
								'left' => __('Left', 'mfn-opts'),
								'center' => __('Center', 'mfn-opts'),
								'right' => __('Right', 'mfn-opts'),
							],
							'std' => '',
						),

   					// HTML end: style

						array(
   						'type' => 'html',
   						'html' => '</div>',
   					),

   				),
   			),

   			// Product short_description ----------------------------------------------------

   			'product_short_description' => array(
   				'type' => 'product_short_description',
   				'title' => __('Short description', 'mfn-opts'),
   				'size' => '1/1',
   				'tablet_size' => '1/1',
   				'mobile_size' => '1/1',
   				'tablet_resized' => '0',
   				'cat' => 'single-product',
   				'fields' => array(

   					array(
							'type' => 'html',
							'html' => '<div class="modalbox-card modalbox-re_render modalbox-card-content-mfnuidhere active">',
						),

						array(
							'id' => 'info',
   						'type' => 'info',
   						'title' => __('This element has no attributes. Please check <b>style</b> tab for more customisation options.', 'mfn-opts'),
   					),

						array(
							'type' => 'html',
							'html' => '</div><div class="modalbox-card modalbox-card-style modalbox-re_render modalbox-card-style-mfnuidhere">',
						),

						array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .woocommerce-product-details__short-description:text-align',
							'oldid' => 'style:.woocommerce-product-details__short-description:text-align',
							'type' => 'switch',
							'title' => __('Text align', 'mfn-opts'),
							'options' => [
								'' => __('Default', 'mfn-opts'),
								'left' => __('Left', 'mfn-opts'),
								'center' => __('Center', 'mfn-opts'),
								'right' => __('Right', 'mfn-opts'),
							],
							'std' => '',
						),

   					// HTML end: style

						array(
   						'type' => 'html',
   						'html' => '</div>',
   					),

   				),
   			),

   			// Product content ----------------------------------------------------

   			'product_content' => array(
   				'type' => 'product_content',
   				'title' => __('Product content', 'mfn-opts'),
   				'size' => '1/1',
   				'tablet_size' => '1/1',
   				'mobile_size' => '1/1',
   				'tablet_resized' => '0',
   				'cat' => 'single-product',
   				'fields' => array(

						array(
							'type' => 'html',
							'html' => '<div class="modalbox-card modalbox-re_render modalbox-card-content-mfnuidhere active">',
						),

						array(
							'id' => 'info',
							'type' => 'info',
							'title' => __('This element has no attributes. Please check <b>style</b> tab for more customisation options.', 'mfn-opts'),
						),

						array(
							'type' => 'html',
							'html' => '</div><div class="modalbox-card modalbox-card-style modalbox-re_render modalbox-card-style-mfnuidhere">',
						),

						array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .woocommerce-product-details__description:text-align',
							'oldid' => 'style:.woocommerce-product-details__description:text-align',
							'type' => 'switch',
							'title' => __('Text align', 'mfn-opts'),
							'options' => [
								'' => __('Default', 'mfn-opts'),
								'left' => __('Left', 'mfn-opts'),
								'center' => __('Center', 'mfn-opts'),
								'right' => __('Right', 'mfn-opts'),
							],
							'std' => '',
						),

						array(
							'type' => 'html',
							'html' => '</div>',
						),

   				),
   			),

   			// Product additional information ----------------------------------------------------

   			'product_additional_information' => array(
   				'type' => 'product_additional_information',
   				'title' => __('Additional information', 'mfn-opts'),
   				'size' => '1/1',
   				'tablet_size' => '1/1',
   				'mobile_size' => '1/1',
   				'tablet_resized' => '0',
   				'cat' => 'single-product',
   				'fields' => array(

						array(
							'type' => 'html',
							'html' => '<div class="modalbox-card modalbox-re_render modalbox-card-content-mfnuidhere active">',
						),

						array(
							'title' => __('Options', 'mfn-opts'),
						),

						array(
							'id' => 'title',
							'type' => 'switch',
							're_render' => 'standard',
							'title' => __('Title', 'mfn-opts'),
							'options' => [
								'0' => __('Hide', 'mfn-opts'),
								'1' => __('Show', 'mfn-opts'),
							],
							'std' => '1',
						),

						array(
							'type' => 'html',
							'html' => '</div><div class="modalbox-card modalbox-card-style modalbox-re_render modalbox-card-style-mfnuidhere">',
						),

						array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .woocommerce-product-attributes th, .mcb-section .mcb-wrap .mcb-item-mfnuidelement .woocommerce-product-attributes td:text-align',
							'oldid' => 'style:.woocommerce-product-attributes th, .woocommerce-product-attributes td:text-align',
							'type' => 'switch',
							'title' => __('Text align', 'mfn-opts'),
							'options' => [
								'' => __('Default', 'mfn-opts'),
								'left' => __('Left', 'mfn-opts'),
								'center' => __('Center', 'mfn-opts'),
								'right' => __('Right', 'mfn-opts'),
							],
							'std' => '',
						),

						// HTML end: style

						array(
							'type' => 'html',
							'html' => '</div>',
						),

   				),
   			),

   			// Product related ----------------------------------------------------

   			'product_related' => array(
   				'type' => 'product_related',
   				'title' => __('Product related', 'mfn-opts'),
   				'size' => '1/1',
   				'tablet_size' => '1/1',
   				'mobile_size' => '1/1',
   				'tablet_resized' => '0',
   				'cat' => 'single-product',
   				'fields' => array(

						array(
							'type' => 'html',
							'html' => '<div class="modalbox-card modalbox-re_render modalbox-card-content-mfnuidhere active">',
						),

						array(
   						'id' => 'products',
   						'type' => 'text',
   						're_render' => 'standard',
   						'title' => __('Products per page', 'mfn-opts'),
   						'std' => '4',
   						'after' => 'products',
   						'param' => 'number',
   						'class' => 'narrow',
   					),

						array(
   						'id' => 'columns',
   						'type' => 'text',
   						're_render' => 'standard',
   						'title' => __('Columns', 'mfn-opts'),
   						'std' => '4',
   						'after' => 'columns',
   						'param' => 'number',
   						'class' => 'narrow',
   					),

						// options

   					array(
   						'title' => __('Options', 'mfn-opts'),
   					),

						array(
							'id' => 'button',
							'type' => 'switch',
							're_render' => 'standard',
							'title' => __('Add to cart button', 'mfn-opts'),
							'desc' => __('Required for some plugins', 'mfn-opts'),
							'options' => array(
								'0' => __('Hide', 'mfn-opts'),
								'1' => __('Show', 'mfn-opts'),
							),
							'std' => '0',
						),

						array(
							'id' => 'description',
							'type' => 'switch',
							're_render' => 'standard',
							'title' => __('Description', 'mfn-opts'),
							'options' => array(
								'0' => __('Hide', 'mfn-opts'),
								'1' => __('Show', 'mfn-opts'),
							),
							'std' => '0'
						),

						array(
							'title' => __('Order', 'mfn-opts'),
						),

						array(
							'id' => 'order',
							'type' => 'order',
							're_render' => 'standard',
							'title' => __('Order', 'mfn-opts'),
							'std' => 'image,title,price,description,button',
						),

						array(
							'id' => 'title_tag',
							'type' => 'switch',
							're_render' => 'standard',
							'title' => __('Title tag', 'mfn-opts'),
							'options' => [
								'h1' => 'H1',
								'h2' => 'H2',
								'h3' => 'H3',
								'h4' => 'H4',
								'h5' => 'H5',
								'h6' => 'H6',
								'p' => 'p',
								'span' => 'span',
							],
							'std' => 'h2',
						),

						array(
							'type' => 'html',
							'html' => '</div><div class="modalbox-card modalbox-card-style modalbox-re_render modalbox-card-style-mfnuidhere">',
						),

						// image

						array(
							'title' => __('Image', 'mfn-opts'),
						),

						array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement li img:border-radius',
							'oldid' => 'style:img:border-radius',
							'type' => 'text',
							'title' => __('Border radius', 'mfn-opts'),
						),

						// title

						array(
							'title' => __('Title', 'mfn-opts'),
						),

						array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement li.product:text-align',
							'oldid' => 'style:li.product:text-align',
							'type' => 'switch',
							'title' => __('Text align', 'mfn-opts'),
							'options' => [
								'' => __('Default', 'mfn-opts'),
								'left' => __('Left', 'mfn-opts'),
								'center' => __('Center', 'mfn-opts'),
								'right' => __('Right', 'mfn-opts'),
							],
							'std' => '',
						),

						array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement ul li.product .title:font-size',
							'oldid' => 'style:ul li.product .title:font-size',
							'type' => 'text',
							'title' => __('Font size', 'mfn-opts'),
						),

   					// HTML end: style

						array(
   						'type' => 'html',
   						'html' => '</div>',
   					),

   				),
   			),

   			// Product upsells ----------------------------------------------------

   			'product_upsells' => array(
   				'type' => 'product_upsells',
   				'title' => __('Product upsells', 'mfn-opts'),
   				'size' => '1/1',
   				'tablet_size' => '1/1',
   				'mobile_size' => '1/1',
   				'tablet_resized' => '0',
   				'cat' => 'single-product',
   				'fields' => array(

						array(
							'type' => 'html',
							'html' => '<div class="modalbox-card modalbox-re_render modalbox-card-content-mfnuidhere active">',
						),

						array(
   						'id' => 'products',
   						're_render' => 'standard',
   						'type' => 'text',
   						'title' => __('Products per page', 'mfn-opts'),
   						'std' => '4',
   						'after' => 'products',
   						'param' => 'number',
   						'class' => 'narrow',
   					),

						array(
   						'id' => 'columns',
   						're_render' => 'standard',
   						'type' => 'text',
   						'title' => __('Columns', 'mfn-opts'),
   						'std' => '4',
   						'after' => 'columns',
   						'param' => 'number',
   						'class' => 'narrow',
   					),

						// options

   					array(
   						'title' => __('Options', 'mfn-opts'),
   					),

						array(
							'id' => 'button',
							'type' => 'switch',
							're_render' => 'standard',
							'title' => __('Add to cart button', 'mfn-opts'),
							'desc' => __('Required for some plugins', 'mfn-opts'),
							'options' => array(
								'0' => __('Hide', 'mfn-opts'),
								'1' => __('Show', 'mfn-opts'),
							),
							'std' => '0',
						),

						array(
							'id' => 'description',
							'type' => 'switch',
							're_render' => 'standard',
							'title' => __('Description', 'mfn-opts'),
							'options' => array(
								'0' => __('Hide', 'mfn-opts'),
								'1' => __('Show', 'mfn-opts'),
							),
							'std' => '0'
						),

						array(
							'title' => __('Order', 'mfn-opts'),
						),

						array(
							'id' => 'order',
							'type' => 'order',
							're_render' => 'standard',
							'title' => __('Order', 'mfn-opts'),
							'std' => 'image,title,price,description,button',
						),

						array(
							'id' => 'title_tag',
							'type' => 'switch',
							're_render' => 'standard',
							'title' => __('Title tag', 'mfn-opts'),
							'options' => [
								'h1' => 'H1',
								'h2' => 'H2',
								'h3' => 'H3',
								'h4' => 'H4',
								'h5' => 'H5',
								'h6' => 'H6',
								'p' => 'p',
								'span' => 'span',
							],
							'std' => 'h2',
						),

						array(
							'type' => 'html',
							'html' => '</div><div class="modalbox-card modalbox-card-style modalbox-re_render modalbox-card-style-mfnuidhere">',
						),

						// image

						array(
							'title' => __('Image', 'mfn-opts'),
						),

						array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement li img:border-radius',
							'oldid' => 'style:img:border-radius',
							'type' => 'text',
							'title' => __('Border radius', 'mfn-opts'),
						),

						// title

						array(
							'title' => __('Title', 'mfn-opts'),
						),

						array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement li.product:text-align',
							'oldid' => 'style:li.product:text-align',
							'type' => 'switch',
							'title' => __('Text align', 'mfn-opts'),
							'options' => [
								'' => __('Default', 'mfn-opts'),
								'left' => __('Left', 'mfn-opts'),
								'center' => __('Center', 'mfn-opts'),
								'right' => __('Right', 'mfn-opts'),
							],
							'std' => '',
						),

						array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement ul li.product .title:font-size',
							'oldid' => 'style:ul li.product .title:font-size',
							'type' => 'text',
							'title' => __('Font size', 'mfn-opts'),
						),

   					// HTML end: style

						array(
   						'type' => 'html',
   						'html' => '</div>',
   					),

   				),
   			),


   			/* END WOO */


				// Divider  -------------------------------------------------------

   			'divider' => array(
   				'type' => 'divider',
   				'title' => '&bull; '. __('Divider', 'mfn-opts'),
   				'size' => '1/1',
   				'tablet_size' => '1/1',
   				'mobile_size' => '1/1',
   				'tablet_resized' => '0',
   				'cat' => 'other',
   				'fields' => array(

   					array(
							'type' => 'html',
							'html' => '<div class="modalbox-card modalbox-re_render modalbox-card-content-mfnuidhere active">',
						),

   					array(
   						'id' => 'height',
   						'type' => 'text',
   						're_render' => 'standard',
   						'title' => __('Height', 'mfn-opts'),
							'param' => 'number',
							'class' => 'narrow',
							'after' => 'px',
   					),

   					array(
   						'id' => 'style',
   						'type' => 'switch',
   						're_render' => 'standard',
   						'title' => __('Style', 'mfn-opts'),
   						'options' => array(
   							'default' => __('Default', 'mfn-opts'),
   							'dots' => __('Dots', 'mfn-opts'),
   							'zigzag' => __('ZigZag', 'mfn-opts'),
   						),
							'std' => 'default',
   					),

   					array(
   						'id' => 'line',
   						'type' => 'switch',
   						're_render' => 'standard',
   						'title' => __('Line', 'mfn-opts'),
   						'desc' => __('for style: default', 'mfn-opts'),
   						'options' => array(
								'' => __('No line', 'mfn-opts'),
   							'default' => __('Default', 'mfn-opts'),
   							'narrow' => __('Narrow', 'mfn-opts'),
   							'wide' => __('Wide', 'mfn-opts'),
   						),
							'std' => '',
   					),

   					array(
   						'id' => 'color',
   						'type' => 'color',
   						're_render' => 'standard',
   						'title' => __('Color', 'mfn-opts'),
							'alpha' => true,
   					),

   					array(
   						'id' => 'themecolor',
   						'type' => 'switch',
   						're_render' => 'standard',
   						'title' => __('Theme color', 'mfn-opts'),
   						'desc' => __('Overwrites color selected above', 'mfn-opts'),
   						'options' => array(
   							0 => __('No', 'mfn-opts'),
   							1 => __('Yes', 'mfn-opts'),
   						),
							'std' => 0,
   					),

						// deprecated

						array(
							'class' => 'mfn-deprecated',
							'title' => __('Deprecated', 'mfn-opts'),
						),

						array(
							'id' => 'class',
							'type' => 'pills',
							'title' => __('Element classes', 'mfn-opts'),
							'class' => 'mfn-deprecated',
						),

						array(
							'type' => 'html',
							'html' => '</div>',
						),

   				),
   			),

   			// Placeholder ----------------------------------------------------

   			'placeholder' => array(
   				'type' => 'placeholder',
   				'title' => '&bull; '. __('Placeholder', 'mfn-opts'),
   				'size' => '1/4',
   				'tablet_size' => '1/4',
   				'mobile_size' => '1/1',
   				'tablet_resized' => '0',
   				'cat' => 'other',
   				'fields' => array(

   					array(
   						'id' => 'info',
   						'type' => 'info',
   						'title' => __('This item has no attributes.', 'mfn-opts'),
   					),

   				),
   			),

   			// Accordion  -----------------------------------------------------

   			'accordion' => array(
   				'type' => 'accordion',
   				'title' => __('Accordion', 'mfn-opts'),
   				'size' => '1/4',
   				'tablet_size' => '1/4',
   				'mobile_size' => '1/1',
   				'tablet_resized' => '0',
   				'cat' => 'blocks',
   				'fields' => array(

   					array(
							'type' => 'html',
							'html' => $this->itemtabs,
						),

   					array(
							'type' => 'html',
							'html' => '<div class="modalbox-card modalbox-re_render modalbox-card-content-mfnuidhere active">',
						),

   					array(
   						'id' => 'title',
   						'type' => 'text',
   						'edit_tag' => '.accordion | h4',
   						'edit_position' => 'prepend',
   						'title' => __('Title', 'mfn-opts'),
							'std' => __('This is the title', 'mfn-opts'),
							'preview' => 'title',
   					),

						// tabs

						array(
   						'title' => __('Tabs', 'mfn-opts'),
   					),

   					array(
   						'id' => 'tabs',
   						'type' => 'tabs',
   						'title' => __('Accordion', 'mfn-opts'),
   						'desc' => __('<b>JavaScript</b> content like Google Maps and some plugins shortcodes do <b>not work</b> in tabs', 'mfn-opts'),
							'options' => [
								'title' => [
									'input',
									__('Title', 'mfn-opts'),
									__('Sample tab', 'mfn-opts'),
								],
								'content' => [
									'textarea',
									__('Content', 'mfn-opts'),
									'Lorem ipsum dolor sit amet, consectetur adipiscing elit. Mauris eu massa orci.',
								],
							],
							'std' => [
								0 => [
									'title' => __('This is the 1st item', 'mfn-opts'),
									'content' => 'Lorem ipsum dolor sit amet, consectetur adipiscing elit. Mauris eu massa orci.',
								],
								1 => [
									'title' => __('This is the 2nd item', 'mfn-opts'),
									'content' => 'Lorem ipsum dolor sit amet, consectetur adipiscing elit. Mauris eu massa orci.',
								],
							],
							'preview' => 'tabs',
							// 'primary' => 'title', // default
   					),

						// options

						array(
   						'title' => __('Options', 'mfn-opts'),
   					),

   					array(
   						'id' => 'open1st',
   						're_render' => 'tabs',
   						'type' => 'switch',
   						'title' => __('Open first', 'mfn-opts'),
   						'options' => array(
   							0 => __('Default', 'mfn-opts'),
   							1 => __('Open first', 'mfn-opts'),
   						),
							'std' => 0,
   					),

   					array(
   						'id' => 'openAll',
   						're_render' => 'tabs',
   						'type' => 'switch',
							'title' => __('Open all', 'mfn-opts'),
   						'options' => array(
								0 => __('Default', 'mfn-opts'),
   							1 => __('Open all', 'mfn-opts'),
							),
							'std' => 0,
   					),

   					array(
   						'id' => 'style',
   						'type' => 'switch',
   						'title' => __('Style', 'mfn-opts'),
   						'options' => array(
   							'accordion' => __('Accordion', 'mfn-opts'),
   							'toggle' => __('Toggle', 'mfn-opts'),
   						),
							'std' => 'accordion',
   					),

						// deprecated

						array(
							'class' => 'mfn-deprecated',
							'title' => __('Deprecated', 'mfn-opts'),
						),

						array(
							'id' => 'class',
							'type' => 'pills',
							'title' => __('Element classes', 'mfn-opts'),
							'class' => 'mfn-deprecated',
						),

						array(
							'type' => 'html',
							'html' => '</div><div class="modalbox-card modalbox-card-style modalbox-re_render modalbox-card-style-mfnuidhere">',
						),

						array(
							'class' => 'toggled_header',
   						'title' => __('Title', 'mfn-opts'),
   					),

   					array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .accordion h4.title:color',
							'type' => 'color',
							'class' => 'main-color mfn-toggled',
							'title' => __('Color', 'mfn-opts'),
						),

						array(
		  				'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .accordion h4.title:margin',
		  				'type' => 'dimensions',
		  				'version' => 'separated-fields',
		  				'title' => __('Margin', 'mfn-opts'),
							'responsive' => 'desktop',
							'class' => 'mfn_field_desktop mfn-toggled',
							'css_attr' => 'margin',
		  			),

		  			array(
		  				'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .accordion h4.title:margin_tablet',
		  				'type' => 'dimensions',
		  				'version' => 'separated-fields',
		  				'title' => __('Margin', 'mfn-opts'),
							'responsive' => 'tablet',
							'class' => 'mfn_field_tablet mfn-toggled',
							'css_attr' => 'margin',
		  			),

		  			array(
		  				'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .accordion h4.title:margin_mobile',
		  				'type' => 'dimensions',
		  				'version' => 'separated-fields',
		  				'title' => __('Margin', 'mfn-opts'),
							'responsive' => 'mobile',
							'class' => 'mfn_field_mobile mfn-toggled',
							'css_attr' => 'margin',
		  			),

		  			array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .accordion h4.title:typography',
							'type' => 'typography_vb',
							'label_after' => '<a href="#" title="Edit" class="mfn-option-btn mfn-option-blank btn-medium mfn-vb-label-button"><span class="mfn-icon mfn-icon-edit"></span></a>',
							'class' => 'mfn-toggled toggle_fields',
							'title' => __('Typography', 'mfn-opts'),
						),

						array(
							'class' => 'toggled_header',
   						'title' => __('Title bar', 'mfn-opts'),
   					),

   					array(
							'type' => 'html',
							'html' => '<div class="mfn-form-row mfn-sidebar-fields-tabs mfn-toggled mfn-vb-formrow mfn-vb-mfnuidhere"><ul class="mfn-sft-nav"><li class="active"><a href="#normal" data-tab="normal">Normal</a></li><li><a href="#hover" data-tab="hover">Active</a></li></ul><div class="mfn-sft mfn-sft-normal">',
						),

   					array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .accordion .question .title:color',
							'type' => 'color',
							'class' => 'main-color mfn-toggled',
							'title' => __('Color', 'mfn-opts'),
						),

						array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .accordion .question .title:background',
							'type' => 'color',
							'class' => 'main-color mfn-toggled',
							'title' => __('Background', 'mfn-opts'),
						),

						array(
							'type' => 'html',
							'html' => '</div><div class="mfn-sft mfn-sft-hover">',
						),

						array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .accordion .question.active .title:color',
							'type' => 'color',
							'class' => 'main-color mfn-toggled',
							'title' => __('Color', 'mfn-opts'),
						),

						array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .accordion .question.active .title:background',
							'type' => 'color',
							'class' => 'main-color mfn-toggled',
							'title' => __('Background', 'mfn-opts'),
						),

						array(
							'type' => 'html',
							'html' => '</div></div>',
						),

						array(
		  				'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .accordion .question:margin',
		  				'type' => 'dimensions',
		  				'version' => 'separated-fields',
		  				'title' => __('Margin', 'mfn-opts'),
							'responsive' => 'desktop',
							'class' => 'mfn_field_desktop mfn-toggled',
							'css_attr' => 'margin',
		  			),

		  			array(
		  				'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .accordion .question:margin_tablet',
		  				'type' => 'dimensions',
		  				'version' => 'separated-fields',
		  				'title' => __('Margin', 'mfn-opts'),
							'responsive' => 'tablet',
							'class' => 'mfn_field_tablet mfn-toggled',
							'css_attr' => 'margin',
		  			),

		  			array(
		  				'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .accordion .question:margin_mobile',
		  				'type' => 'dimensions',
		  				'version' => 'separated-fields',
		  				'title' => __('Margin', 'mfn-opts'),
							'responsive' => 'mobile',
							'class' => 'mfn_field_mobile mfn-toggled',
							'css_attr' => 'margin',
		  			),

		  			array(
		  				'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .accordion .question .title:padding',
		  				'type' => 'dimensions',
		  				'version' => 'separated-fields',
		  				'title' => __('Padding', 'mfn-opts'),
							'responsive' => 'desktop',
							'class' => 'mfn_field_desktop mfn-toggled',
							'css_attr' => 'padding',
		  			),

		  			array(
		  				'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .accordion .question .title:padding_tablet',
		  				'type' => 'dimensions',
		  				'version' => 'separated-fields',
		  				'title' => __('Padding', 'mfn-opts'),
							'responsive' => 'tablet',
							'class' => 'mfn_field_tablet mfn-toggled',
							'css_attr' => 'padding',
		  			),

		  			array(
		  				'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .accordion .question .title:padding_mobile',
		  				'type' => 'dimensions',
		  				'version' => 'separated-fields',
		  				'title' => __('Padding', 'mfn-opts'),
							'responsive' => 'mobile',
							'class' => 'mfn_field_mobile mfn-toggled',
							'css_attr' => 'padding',
		  			),

		  			array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .accordion .question,.mcb-section .mcb-wrap .mcb-item-mfnuidelement .accordion .question .title|before:border-style',
							'attr_id' => 'border_style',
							'type' => 'select',
							'class' => 'mfn-toggled',
							'title' => __('Border style', 'mfn-opts'),
							'options' => [
								'none' => __('None', 'mfn-opts'),
								'solid' => __('Solid', 'mfn-opts'),
								'dashed' => __('Dashed', 'mfn-opts'),
								'dotted' => __('Dotted', 'mfn-opts'),
								'double' => __('Double', 'mfn-opts'),
							],
						),

						array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .accordion .question,.mcb-section .mcb-wrap .mcb-item-mfnuidelement .accordion .question .title|before:border-color',
							'condition' => array( 'id' => 'border_style', 'opt' => 'isnt', 'val' => 'none' ),
							'type' => 'color',
							'class' => 'mfn-toggled',
							'title' => __('Border color', 'mfn-opts'),
						),

						array(
		  				'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .accordion .question:border-width',
		  				'condition' => array( 'id' => 'border_style', 'opt' => 'isnt', 'val' => 'none' ),
		  				'type' => 'dimensions',
		  				'title' => __('Border width', 'mfn-opts'),
							'responsive' => 'desktop',
							'class' => 'mfn_field_desktop mfn-toggled',
							'css_attr' => 'border-width',
		  			),

		  			array(
		  				'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .accordion .question:border-width_tablet',
		  				'condition' => array( 'id' => 'border_style', 'opt' => 'isnt', 'val' => 'none' ),
		  				'type' => 'dimensions',
		  				'title' => __('Border width', 'mfn-opts'),
							'responsive' => 'tablet',
							'class' => 'mfn_field_tablet mfn-toggled',
							'css_attr' => 'border-width',
		  			),

		  			array(
		  				'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .accordion .question:border-width_mobile',
		  				'condition' => array( 'id' => 'border_style', 'opt' => 'isnt', 'val' => 'none' ),
		  				'type' => 'dimensions',
		  				'title' => __('Border width', 'mfn-opts'),
							'responsive' => 'mobile',
							'class' => 'mfn_field_mobile mfn-toggled',
							'css_attr' => 'border-width',
		  			),

						array(
		  				'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .accordion .question:border-radius',
		  				'type' => 'dimensions',
		  				'title' => __('Border radius', 'mfn-opts'),
							'responsive' => 'desktop',
							'class' => 'mfn_field_desktop mfn-toggled',
							'css_attr' => 'border-radius',
		  			),

		  			array(
		  				'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .accordion .question:border-radius_tablet',
		  				'type' => 'dimensions',
		  				'title' => __('Border radius', 'mfn-opts'),
							'responsive' => 'tablet',
							'class' => 'mfn_field_tablet mfn-toggled',
							'css_attr' => 'border-radius',
		  			),

		  			array(
		  				'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .accordion .question:border-radius_mobile',
		  				'type' => 'dimensions',
		  				'title' => __('Border radius', 'mfn-opts'),
							'responsive' => 'mobile',
							'class' => 'mfn_field_mobile mfn-toggled',
							'css_attr' => 'border-radius',
		  			),

		  			array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .accordion .question .title:typography',
							'type' => 'typography_vb',
							'label_after' => '<a href="#" title="Edit" class="mfn-option-btn mfn-option-blank btn-medium mfn-vb-label-button"><span class="mfn-icon mfn-icon-edit"></span></a>',
							'class' => 'mfn-toggled toggle_fields',
							'title' => __('Typography', 'mfn-opts'),
						),

						array(
		  				'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .accordion .question .title:box-shadow',
		  				'type' => 'box_shadow',
		  				'title' => __('Box shadow', 'mfn-opts'),
							'responsive' => 'desktop',
							'class' => 'mfn_field_desktop mfn-toggled',
							'css_attr' => 'box-shadow'
		  			),

		  			array(
		  				'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .accordion .question .title:box-shadow_tablet',
		  				'type' => 'box_shadow',
		  				'title' => __('Box shadow', 'mfn-opts'),
							'responsive' => 'tablet',
							'class' => 'mfn_field_tablet mfn-toggled',
							'css_attr' => 'box-shadow',
		  			),

		  			array(
		  				'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .accordion .question .title:box-shadow_mobile',
		  				'type' => 'box_shadow',
		  				'title' => __('Box shadow', 'mfn-opts'),
							'responsive' => 'mobile',
							'class' => 'mfn_field_mobile mfn-toggled',
							'css_attr' => 'box-shadow',
		  			),

		  			array(
							'class' => 'toggled_header',
   						'title' => __('Title bar icon', 'mfn-opts'),
   					),

   					array(
							'type' => 'html',
							'html' => '<div class="mfn-form-row mfn-sidebar-fields-tabs mfn-toggled mfn-vb-formrow mfn-vb-mfnuidhere"><ul class="mfn-sft-nav"><li class="active"><a href="#normal" data-tab="normal">Normal</a></li><li><a href="#hover" data-tab="hover">Active</a></li></ul><div class="mfn-sft mfn-sft-normal">',
						),

						array(
   						'id' => 'icon',
   						'type' => 'icon',
   						'title' => __('Icon', 'mfn-opts'),
   					),

   					array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .accordion .question .title i:color',
							'type' => 'color',
							'class' => 'main-color mfn-toggled',
							'title' => __('Color', 'mfn-opts'),
						),

						array(
							'type' => 'html',
							'html' => '</div><div class="mfn-sft mfn-sft-hover">',
						),

						array(
   						'id' => 'icon_active',
   						'type' => 'icon',
   						'title' => __('Icon', 'mfn-opts'),
   					),

						array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .accordion .question.active .title i:color',
							'type' => 'color',
							'class' => 'main-color mfn-toggled',
							'title' => __('Color', 'mfn-opts'),
						),

						array(
							'type' => 'html',
							'html' => '</div></div>',
						),

   					array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .accordion .question .title i:font-size',
							'type' => 'sliderbar',
							'responsive' => 'desktop',
							'class' => 'mfn_field_desktop mfn-toggled',
							'title' => __('Size', 'mfn-opts'),
							'units' => array(
								'px' 	=> array('min' => 1, 		'max' => 100, 'step' => 1),
								'em' 	=> array('min' => 0.1, 	'max' => 10, 	'step' => 0.1),
								'rem' => array('min' => 0.1, 	'max' => 10, 	'step' => 0.1),
								'vw' 	=> array('min' => 1, 		'max' => 100, 'step' => 1),
							)
						),

						array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .accordion .question .title i:font-size_tablet',
							'type' => 'sliderbar',
							'responsive' => 'tablet',
							'class' => 'mfn_field_tablet mfn-toggled',
							'title' => __('Size', 'mfn-opts'),
							'units' => array(
								'px' 	=> array('min' => 1, 		'max' => 100, 'step' => 1),
								'em' 	=> array('min' => 0.1, 	'max' => 10, 	'step' => 0.1),
								'rem' => array('min' => 0.1, 	'max' => 10, 	'step' => 0.1),
								'vw' 	=> array('min' => 1, 		'max' => 100, 'step' => 1),
							)
						),

						array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .accordion .question .title i:font-size_mobile',
							'type' => 'sliderbar',
							'responsive' => 'mobile',
							'class' => 'mfn_field_mobile mfn-toggled',
							'title' => __('Size', 'mfn-opts'),
							'units' => array(
								'px' 	=> array('min' => 1, 		'max' => 100, 'step' => 1),
								'em' 	=> array('min' => 0.1, 	'max' => 10, 	'step' => 0.1),
								'rem' => array('min' => 0.1, 	'max' => 10, 	'step' => 0.1),
								'vw' 	=> array('min' => 1, 		'max' => 100, 'step' => 1),
							)
						),

		  			array(
							'class' => 'toggled_header',
   						'title' => __('Content', 'mfn-opts'),
   					),

   					array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .accordion .question .answer:color',
							'type' => 'color',
							'class' => 'main-color mfn-toggled',
							'title' => __('Color', 'mfn-opts'),
						),

						array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .accordion .question .answer:background',
							'type' => 'color',
							'class' => 'main-color mfn-toggled',
							'title' => __('Background', 'mfn-opts'),
						),

		  			array(
		  				'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .accordion .question .answer:padding',
		  				'type' => 'dimensions',
		  				'version' => 'separated-fields',
		  				'title' => __('Padding', 'mfn-opts'),
							'responsive' => 'desktop',
							'class' => 'mfn_field_desktop mfn-toggled',
							'css_attr' => 'padding',
		  			),

		  			array(
		  				'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .accordion .question .answer:padding_tablet',
		  				'type' => 'dimensions',
		  				'version' => 'separated-fields',
		  				'title' => __('Padding', 'mfn-opts'),
							'responsive' => 'tablet',
							'class' => 'mfn_field_tablet mfn-toggled',
							'css_attr' => 'padding',
		  			),

		  			array(
		  				'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .accordion .question .answer:padding_mobile',
		  				'type' => 'dimensions',
		  				'version' => 'separated-fields',
		  				'title' => __('Padding', 'mfn-opts'),
							'responsive' => 'mobile',
							'class' => 'mfn_field_mobile mfn-toggled',
							'css_attr' => 'padding',
		  			),

		  			array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .accordion .question .answer:typography',
							'type' => 'typography_vb',
							'label_after' => '<a href="#" title="Edit" class="mfn-option-btn mfn-option-blank btn-medium mfn-vb-label-button"><span class="mfn-icon mfn-icon-edit"></span></a>',
							'class' => 'mfn-toggled toggle_fields',
							'title' => __('Typography', 'mfn-opts'),
						),

						array(
							'class' => 'toggled_header',
							'themeoptions' => 'style:simple',
   						'title' => __('Question line', 'mfn-opts'),
   					),

   					array(
							'type' => 'html',
							'themeoptions' => 'style:simple',
							'html' => '<div class="mfn-form-row mfn-sidebar-fields-tabs mfn-toggled mfn-vb-formrow mfn-vb-mfnuidhere"><ul class="mfn-sft-nav"><li class="active"><a href="#normal" data-tab="normal">Normal</a></li><li><a href="#hover" data-tab="hover">Active</a></li></ul><div class="mfn-sft mfn-sft-normal">',
						),

   					array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .accordion .question:border-color',
							'type' => 'color',
							'themeoptions' => 'style:simple',
							'title' => __('Color', 'mfn-opts'),
						),

						array(
							'type' => 'html',
							'themeoptions' => 'style:simple',
							'html' => '</div><div class="mfn-sft mfn-sft-hover">',
						),

						array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .accordion .question.active|after:background-color',
							'type' => 'color',
							'themeoptions' => 'style:simple',
							'title' => __('Color', 'mfn-opts'),
						),

						array(
							'type' => 'html',
							'themeoptions' => 'style:simple',
							'html' => '</div></div>',
						),


						array(
							'type' => 'html',
							'html' => '</div>',
						),

   				),
   			),

   			// Article box  ---------------------------------------------------

   			'article_box' => array(
   				'type' => 'article_box',
   				'title' => __('Article box', 'mfn-opts'),
   				'size' => '1/3',
   				'tablet_size' => '1/3',
   				'mobile_size' => '1/1',
   				'tablet_resized' => '0',
   				'cat' => 'boxes',
   				'fields' => array(

   					array(
							'type' => 'html',
							'html' => $this->itemtabs,
						),

   					array(
							'type' => 'html',
							'html' => '<div class="modalbox-card modalbox-re_render modalbox-card-content-mfnuidhere active">',
						),

						array(
   						'id' => 'image',
   						'type' => 'upload',
   						'title' => __('Image', 'mfn-opts'),
   						'desc' => __('Recommended image width <b>384px - 960px</b> depending on size of the item', 'mfn-opts'),
							'std' => $this->get_placeholder(),
							'preview' => 'image',
   					),

   					array(
   						'id' => 'slogan',
   						'type' => 'text',
   						'edit_tag' => '.desc_wrapper | p',
   						'edit_tagchild' => 'span',
   						'edit_position' => 'prepend',
   						'title' => __('Slogan', 'mfn-opts'),
   						'desc' => __('Allowed HTML tags: span, strong, b, em, i, u', 'mfn-opts'),
							'std' => __('This is the slogan', 'mfn-opts'),
							'preview' => 'subtitle',
   					),

   					array(
   						'id' => 'title',
   						'type' => 'text',
   						'edit_tag' => '.desc_wrapper | h4',
   						'edit_position' => 'append',
   						'title' => __('Title', 'mfn-opts'),
   						'desc' => __('Allowed HTML tags: span, strong, b, em, i, u', 'mfn-opts'),
							'std' => __('This is the title', 'mfn-opts'),
							'preview' => 'title',
   					),

   					// link

   					array(
   						'title' => __('Link', 'mfn-opts'),
   					),

   					array(
   						'id' => 'link',
   						'type' => 'text',
   						'title' => __('Link', 'mfn-opts'),
   					),

   					array(
   						'id' => 'target',
   						'type' => 'select',
   						'title' => __('Target', 'mfn-opts'),
   						'options' => array(
   							0 => __('Default | _self', 'mfn-opts'),
   							1 => __('New tab or window | _blank', 'mfn-opts'),
   							'lightbox' => __('Lightbox (image or embed video)', 'mfn-opts'),
   						),
   					),

						// deprecated

						array(
							'class' => 'mfn-deprecated',
							'title' => __('Deprecated', 'mfn-opts'),
						),

						array(
							'id' => 'class',
							'type' => 'pills',
							'title' => __('Element classes', 'mfn-opts'),
							'class' => 'mfn-deprecated',
						),

   					array(
							'type' => 'html',
							'html' => '</div><div class="modalbox-card modalbox-card-style modalbox-re_render modalbox-card-style-mfnuidhere">',
						),

						array(
							'class' => 'toggled_header',
   						'title' => __('Image', 'mfn-opts'),
   					),

		  			array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .article_box .photo_wrapper img:border-style',
							'attr_id' => 'border_style',
							'type' => 'select',
							'class' => 'mfn-toggled',
							'title' => __('Border style', 'mfn-opts'),
							'options' => [
								'none' => __('None', 'mfn-opts'),
								'solid' => __('Solid', 'mfn-opts'),
								'dashed' => __('Dashed', 'mfn-opts'),
								'dotted' => __('Dotted', 'mfn-opts'),
								'double' => __('Double', 'mfn-opts'),
							],
						),

						array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .article_box .photo_wrapper img:border-color',
							'condition' => array( 'id' => 'border_style', 'opt' => 'isnt', 'val' => 'none' ),
							'type' => 'color',
							'class' => 'mfn-toggled',
							'title' => __('Border color', 'mfn-opts'),
						),

						array(
		  				'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .article_box .photo_wrapper img:border-width',
		  				'condition' => array( 'id' => 'border_style', 'opt' => 'isnt', 'val' => 'none' ),
		  				'type' => 'dimensions',
		  				'title' => __('Border width', 'mfn-opts'),
							'responsive' => 'desktop',
							'class' => 'mfn_field_desktop mfn-toggled',
							'css_attr' => 'border-width',
		  			),

		  			array(
		  				'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .article_box .photo_wrapper img:border-width_tablet',
		  				'condition' => array( 'id' => 'border_style', 'opt' => 'isnt', 'val' => 'none' ),
		  				'type' => 'dimensions',
		  				'title' => __('Border width', 'mfn-opts'),
							'responsive' => 'tablet',
							'class' => 'mfn_field_tablet mfn-toggled',
							'css_attr' => 'border-width',
		  			),

		  			array(
		  				'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .article_box .photo_wrapper img:border-width_mobile',
		  				'condition' => array( 'id' => 'border_style', 'opt' => 'isnt', 'val' => 'none' ),
		  				'type' => 'dimensions',
		  				'title' => __('Border width', 'mfn-opts'),
							'responsive' => 'mobile',
							'class' => 'mfn_field_mobile mfn-toggled',
							'css_attr' => 'border-width',
		  			),

						array(
		  				'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .article_box .photo_wrapper img:border-radius',
		  				'type' => 'dimensions',
		  				'title' => __('Border radius', 'mfn-opts'),
							'responsive' => 'desktop',
							'class' => 'mfn_field_desktop mfn-toggled',
							'css_attr' => 'border-radius',
		  			),

		  			array(
		  				'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .article_box .photo_wrapper img:border-radius_tablet',
		  				'type' => 'dimensions',
		  				'title' => __('Border radius', 'mfn-opts'),
							'responsive' => 'tablet',
							'class' => 'mfn_field_tablet mfn-toggled',
							'css_attr' => 'border-radius',
		  			),

		  			array(
		  				'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .article_box .photo_wrapper img:border-radius_mobile',
		  				'type' => 'dimensions',
		  				'title' => __('Border radius', 'mfn-opts'),
							'responsive' => 'mobile',
							'class' => 'mfn_field_mobile mfn-toggled',
							'css_attr' => 'border-radius',
		  			),

		  			array(
		  				'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .photo_wrapper:margin',
		  				'type' => 'dimensions',
		  				'title' => __('Margin', 'mfn-opts'),
		  				'version' => 'separated-fields',
							'responsive' => 'desktop',
							'class' => 'mfn_field_desktop mfn-toggled',
							'css_attr' => 'margin',
		  			),

		  			array(
		  				'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .photo_wrapper:margin_tablet',
		  				'type' => 'dimensions',
		  				'title' => __('Margin', 'mfn-opts'),
		  				'version' => 'separated-fields',
							'responsive' => 'tablet',
							'class' => 'mfn_field_tablet mfn-toggled',
							'css_attr' => 'margin',
		  			),

		  			array(
		  				'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .photo_wrapper:margin_mobile',
		  				'type' => 'dimensions',
		  				'title' => __('Margin', 'mfn-opts'),
		  				'version' => 'separated-fields',
							'responsive' => 'mobile',
							'class' => 'mfn_field_mobile mfn-toggled',
							'css_attr' => 'margin',
		  			),

		  			array(
		  				'class' => 'toggled_header',
   						'title' => __('Desc', 'mfn-opts'),
   					),

   					array(
   						'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .desc_wrapper:text-align',
							'responsive' => 'desktop',
   						'type' => 'switch',
   						'class' => 'mfn_field_desktop mfn-toggled',
   						'title' => __('Text align', 'mfn-opts'),
   						'options' => array(
   							'' => __('Default', 'mfn-opts'),
   							'left' => __('Left', 'mfn-opts'),
								'center' => __('Center', 'mfn-opts'),
   							'right' => __('Right', 'mfn-opts'),
   							'justify' => __('Justify', 'mfn-opts'),
   						),
							'preview' => 'align',
   					),
   					array(
   						'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .desc_wrapper:text-align_tablet',
							'responsive' => 'tablet',
   						'type' => 'switch',
   						'class' => 'mfn_field_tablet mfn-toggled',
   						'title' => __('Text align', 'mfn-opts'),
   						'options' => array(
   							'' => __('Default', 'mfn-opts'),
   							'left' => __('Left', 'mfn-opts'),
								'center' => __('Center', 'mfn-opts'),
   							'right' => __('Right', 'mfn-opts'),
   							'justify' => __('Justify', 'mfn-opts'),
   						),
							'preview' => 'align',
   					),
   					array(
   						'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .desc_wrapper:text-align_mobile',
							'responsive' => 'mobile',
   						'type' => 'switch',
   						'class' => 'mfn_field_mobile mfn-toggled',
   						'title' => __('Text align', 'mfn-opts'),
   						'options' => array(
   							'' => __('Default', 'mfn-opts'),
   							'left' => __('Left', 'mfn-opts'),
								'center' => __('Center', 'mfn-opts'),
   							'right' => __('Right', 'mfn-opts'),
   							'justify' => __('Justify', 'mfn-opts'),
   						),
							'preview' => 'align',
   					),

   					array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .desc_wrapper:background',
							'type' => 'color',
							'class' => 'main-color mfn-toggled',
							'title' => __('Background color', 'mfn-opts'),
						),

						array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .article_box .desc_wrapper:border-style',
							'attr_id' => 'border_style_desc',
							'class' => 'mfn-toggled',
							'type' => 'select',
							'title' => __('Border style', 'mfn-opts'),
							'options' => [
								'none' => __('None', 'mfn-opts'),
								'solid' => __('Solid', 'mfn-opts'),
								'dashed' => __('Dashed', 'mfn-opts'),
								'dotted' => __('Dotted', 'mfn-opts'),
								'double' => __('Double', 'mfn-opts'),
							],
						),

						array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .article_box .desc_wrapper:border-color',
							'condition' => array( 'id' => 'border_style_desc', 'opt' => 'isnt', 'val' => 'none' ),
							'type' => 'color',
							'class' => 'mfn-toggled',
							'title' => __('Border color', 'mfn-opts'),
						),

						array(
		  				'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .article_box .desc_wrapper:border-width',
		  				'condition' => array( 'id' => 'border_style_desc', 'opt' => 'isnt', 'val' => 'none' ),
		  				'type' => 'dimensions',
		  				'title' => __('Border width', 'mfn-opts'),
							'responsive' => 'desktop',
							'class' => 'mfn_field_desktop mfn-toggled',
							'css_attr' => 'border-width',
		  			),

		  			array(
		  				'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .article_box .desc_wrapper:border-width_tablet',
		  				'condition' => array( 'id' => 'border_style_desc', 'opt' => 'isnt', 'val' => 'none' ),
		  				'type' => 'dimensions',
		  				'title' => __('Border width', 'mfn-opts'),
							'responsive' => 'tablet',
							'class' => 'mfn_field_tablet mfn-toggled',
							'css_attr' => 'border-width',
		  			),

		  			array(
		  				'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .article_box .desc_wrapper:border-width_mobile',
		  				'condition' => array( 'id' => 'border_style_desc', 'opt' => 'isnt', 'val' => 'none' ),
		  				'type' => 'dimensions',
		  				'title' => __('Border width', 'mfn-opts'),
							'responsive' => 'mobile',
							'class' => 'mfn_field_mobile mfn-toggled',
							'css_attr' => 'border-width',
		  			),

						array(
		  				'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .article_box .desc_wrapper:border-radius',
		  				'type' => 'dimensions',
		  				'title' => __('Border radius', 'mfn-opts'),
							'responsive' => 'desktop',
							'class' => 'mfn_field_desktop mfn-toggled',
							'css_attr' => 'border-radius',
		  			),

		  			array(
		  				'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .article_box .desc_wrapper:border-radius_tablet',
		  				'type' => 'dimensions',
		  				'title' => __('Border radius', 'mfn-opts'),
							'responsive' => 'tablet',
							'class' => 'mfn_field_tablet mfn-toggled',
							'css_attr' => 'border-radius',
		  			),

		  			array(
		  				'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .article_box .desc_wrapper:border-radius_mobile',
		  				'type' => 'dimensions',
		  				'title' => __('Border radius', 'mfn-opts'),
							'responsive' => 'mobile',
							'class' => 'mfn_field_mobile mfn-toggled',
							'css_attr' => 'border-radius',
		  			),

		  			array(
		  				'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .desc_wrapper:padding',
		  				'type' => 'dimensions',
		  				'version' => 'separated-fields',
		  				'title' => __('Padding', 'mfn-opts'),
							'responsive' => 'desktop',
							'class' => 'mfn_field_desktop mfn-toggled',
							'css_attr' => 'padding',
		  			),

		  			array(
		  				'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .desc_wrapper:padding_tablet',
		  				'type' => 'dimensions',
		  				'version' => 'separated-fields',
		  				'title' => __('Padding', 'mfn-opts'),
							'responsive' => 'tablet',
							'class' => 'mfn_field_tablet mfn-toggled',
							'css_attr' => 'padding',
		  			),

		  			array(
		  				'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .desc_wrapper:padding_mobile',
		  				'type' => 'dimensions',
		  				'version' => 'separated-fields',
		  				'title' => __('Padding', 'mfn-opts'),
							'responsive' => 'mobile',
							'class' => 'mfn_field_mobile mfn-toggled',
							'css_attr' => 'padding',
		  			),

		  			array(
		  				'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .desc_wrapper:margin',
		  				'type' => 'dimensions',
		  				'version' => 'separated-fields',
		  				'title' => __('Margin', 'mfn-opts'),
							'responsive' => 'desktop',
							'class' => 'mfn_field_desktop mfn-toggled',
							'css_attr' => 'margin',
		  			),

		  			array(
		  				'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .desc_wrapper:margin_tablet',
		  				'type' => 'dimensions',
		  				'version' => 'separated-fields',
		  				'title' => __('Margin', 'mfn-opts'),
							'responsive' => 'tablet',
							'class' => 'mfn_field_tablet mfn-toggled',
							'css_attr' => 'margin',
		  			),

		  			array(
		  				'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .desc_wrapper:margin_mobile',
		  				'type' => 'dimensions',
		  				'version' => 'separated-fields',
		  				'title' => __('Margin', 'mfn-opts'),
							'responsive' => 'mobile',
							'class' => 'mfn_field_mobile mfn-toggled',
							'css_attr' => 'margin',
		  			),

		  			array(
							'class' => 'toggled_header',
   						'title' => __('Title', 'mfn-opts'),
   					),

   					array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .desc_wrapper h4:color',
							'type' => 'color',
							'class' => 'main-color mfn-toggled',
							'title' => __('Color', 'mfn-opts'),
						),

						array(
		  				'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .desc_wrapper h4:margin',
		  				'type' => 'dimensions',
		  				'version' => 'separated-fields',
		  				'title' => __('Margin', 'mfn-opts'),
							'responsive' => 'desktop',
							'class' => 'mfn_field_desktop mfn-toggled',
							'css_attr' => 'margin',
		  			),

		  			array(
		  				'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .desc_wrapper h4:margin_tablet',
		  				'type' => 'dimensions',
		  				'version' => 'separated-fields',
		  				'title' => __('Margin', 'mfn-opts'),
							'responsive' => 'tablet',
							'class' => 'mfn_field_tablet mfn-toggled',
							'css_attr' => 'margin',
		  			),

		  			array(
		  				'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .desc_wrapper h4:margin_mobile',
		  				'type' => 'dimensions',
		  				'version' => 'separated-fields',
		  				'title' => __('Margin', 'mfn-opts'),
							'responsive' => 'mobile',
							'class' => 'mfn_field_mobile mfn-toggled',
							'css_attr' => 'margin',
		  			),

		  			array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .desc_wrapper h4:typography',
							'type' => 'typography_vb',
							'label_after' => '<a href="#" title="Edit" class="mfn-option-btn mfn-option-blank btn-medium mfn-vb-label-button"><span class="mfn-icon mfn-icon-edit"></span></a>',
							'class' => 'mfn-toggled toggle_fields',
							'title' => __('Typography', 'mfn-opts'),
						),

						array(
							'class' => 'toggled_header',
   						'title' => __('Slogan', 'mfn-opts'),
   					),

   					array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .desc_wrapper p:color',
							'type' => 'color',
							'class' => 'main-color mfn-toggled',
							'title' => __('Color', 'mfn-opts'),
						),

						array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .desc_wrapper p:border-color',
							'type' => 'color',
							'class' => 'main-color mfn-toggled',
							'desc' => __('Works only with <b>classic style</b>', 'mfn-opts'),
							'title' => __('Border color', 'mfn-opts'),
						),

						array(
		  				'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .desc_wrapper p:margin',
		  				'type' => 'dimensions',
		  				'version' => 'separated-fields',
		  				'title' => __('Margin', 'mfn-opts'),
							'responsive' => 'desktop',
							'class' => 'mfn_field_desktop mfn-toggled',
							'css_attr' => 'margin',
		  			),

		  			array(
		  				'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .desc_wrapper p:margin_tablet',
		  				'type' => 'dimensions',
		  				'version' => 'separated-fields',
		  				'title' => __('Margin', 'mfn-opts'),
							'responsive' => 'tablet',
							'class' => 'mfn_field_tablet mfn-toggled',
							'css_attr' => 'margin',
		  			),

		  			array(
		  				'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .desc_wrapper p:margin_mobile',
		  				'type' => 'dimensions',
		  				'version' => 'separated-fields',
		  				'title' => __('Margin', 'mfn-opts'),
							'responsive' => 'mobile',
							'class' => 'mfn_field_mobile mfn-toggled',
							'css_attr' => 'margin',
		  			),

		  			array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .desc_wrapper p:typography',
							'type' => 'typography_vb',
							'label_after' => '<a href="#" title="Edit" class="mfn-option-btn mfn-option-blank btn-medium mfn-vb-label-button"><span class="mfn-icon mfn-icon-edit"></span></a>',
							'class' => 'mfn-toggled toggle_fields',
							'title' => __('Typography', 'mfn-opts'),
						),


						array(
							'class' => 'toggled_header',
   						'title' => __('Decoration', 'mfn-opts'),
   					),

   					array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .desc_wrapper:--mfn-article-box-decoration',
							'type' => 'color',
							'class' => 'main-color mfn-toggled',
							'title' => __('Color', 'mfn-opts'),
						),

   					array(
							'type' => 'html',
							'html' => '</div>',
						),

						// advanced here

   				),
   			),

   			// Before After  ---------------------------------------------------

   			'before_after' => array(
   				'type' => 'before_after',
   				'title' => __('Before After', 'mfn-opts'),
   				'size' => '1/3',
   				'tablet_size' => '1/3',
   				'mobile_size' => '1/1',
   				'tablet_resized' => '0',
   				'cat' => 'boxes',
   				'fields' => array(

   					array(
							'type' => 'html',
							'html' => $this->itemtabs,
						),

   					array(
							'type' => 'html',
							'html' => '<div class="modalbox-card modalbox-re_render modalbox-card-content-mfnuidhere active">',
						),

						// image

						array(
   						'title' => __('Image', 'mfn-opts'),
   					),

   					array(
   						'id' => 'image_before',
   						'type' => 'upload',
   						'title' => __('Before', 'mfn-opts'),
   						'desc' => __('Recommended image width <b>768px - 1920px</b> depending on size of the item', 'mfn-opts'),
							'std' => $this->get_placeholder(),
							'preview' => 'image',
   					),

   					array(
   						'id' => 'image_after',
   						'type' => 'upload',
   						'title' => __('After', 'mfn-opts'),
   						'desc' => __('Both images <b>must have the same size</b>', 'mfn-opts'),
							'std' => $this->get_placeholder(),
   					),

					// label

						array(
   						'title' => __('Label', 'mfn-opts'),
   					),

						array(
		  				'id' => 'label_before',
		  				'type' => 'text',
		  				'title' => __('Before', 'mfn-opts'),
		  			),

						array(
		  				'id' => 'label_after',
		  				'type' => 'text',
		  				'title' => __('After', 'mfn-opts'),
		  			),

						// deprecated

						array(
							'class' => 'mfn-deprecated',
							'title' => __('Deprecated', 'mfn-opts'),
						),

						array(
							'id' => 'class',
							'type' => 'pills',
							'title' => __('Element classes', 'mfn-opts'),
							'class' => 'mfn-deprecated',
						),

						array(
							'type' => 'html',
							'html' => '</div><div class="modalbox-card modalbox-card-style modalbox-re_render modalbox-card-style-mfnuidhere">',
						),

						array(
							'class' => 'toggled_header',
   						'title' => __('Slider', 'mfn-opts'),
   					),

   					array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .twentytwenty-wrapper:--mfn-before-after-slider',
							'type' => 'color',
							'class' => 'main-color mfn-toggled',
							'title' => __('Color', 'mfn-opts'),
						),

						array(
							'class' => 'toggled_header',
   						'title' => __('Label', 'mfn-opts'),
   					),

   					array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .twentytwenty-wrapper:--mfn-before-after-label',
							'type' => 'color',
							'class' => 'main-color mfn-toggled',
							'title' => __('Background', 'mfn-opts'),
						),

						array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .twentytwenty-wrapper:--mfn-before-after-label-color',
							'type' => 'color',
							'class' => 'main-color mfn-toggled',
							'title' => __('Color', 'mfn-opts'),
						),

						array(
							'type' => 'html',
							'html' => '</div>',
						),

   				),
   			),

   			// Blockquote -----------------------------------------------------

   			'blockquote' => array(
   				'type' => 'blockquote',
   				'title' => __('Blockquote', 'mfn-opts'),
   				'size' => '1/4',
   				'tablet_size' => '1/4',
   				'mobile_size' => '1/1',
   				'tablet_resized' => '0',
   				'used_fonts' => '',
   				'cat' => 'typography',
   				'fields' => array(

   					array(
							'type' => 'html',
							'html' => $this->itemtabs,
						),

   					array(
							'type' => 'html',
							'html' => '<div class="modalbox-card modalbox-re_render modalbox-card-content-mfnuidhere active">',
						),

   					array(
   						'id' => 'content',
   						'type' => 'textarea',
   						'title' => __('Content', 'mfn-opts'),
   						'std' => 'Lorem ipsum dolor sit amet, consectetur adipiscing elit. Ut elit tellus, luctus nec ullamcorper mattis, pulvinar dapibus leo.',
							'class' => 'form-content-full-width',
							'editor' => 'basic',
							'preview' => 'content',
   					),

   					array(
   						'id' => 'icon',
   						'type' => 'icon',
   						'themeoptions' => 'style:',
   						'title' => __('Icon', 'mfn-opts'),
   					),

   					array(
   						'id' => 'author',
   						'type' => 'text',
   						'edit_tag' => '.blockquote .author | span',
   						'edit_position' => 'append',
   						'title' => __('Author', 'mfn-opts'),
   						'std' => __('This is the author', 'mfn-opts'),
   					),

   					array(
   						'id' => 'icon_author',
   						'type' => 'icon',
   						'title' => __('Icon author', 'mfn-opts'),
   					),

						// link

						array(
   						'title' => __('Link', 'mfn-opts'),
   					),

   					array(
   						'id' => 'link',
   						'type' => 'text',
   						'title' => __('Link', 'mfn-opts'),
   					),

   					array(
   						'id' => 'target',
   						'type' => 'select',
   						'title' => __('Target', 'mfn-opts'),
   						'options' => array(
   							0 => __('Default | _self', 'mfn-opts'),
   							1 => __('New tab or window | _blank', 'mfn-opts'),
   							'lightbox' => __('Lightbox (image or embed video)', 'mfn-opts'),
   						),
   					),

						// deprecated

						array(
							'class' => 'mfn-deprecated',
							'title' => __('Deprecated', 'mfn-opts'),
						),

						array(
							'id' => 'class',
							'type' => 'pills',
							'title' => __('Element classes', 'mfn-opts'),
							'class' => 'mfn-deprecated',
						),

						array(
							'type' => 'html',
							'html' => '</div><div class="modalbox-card modalbox-card-style modalbox-re_render modalbox-card-style-mfnuidhere">',
						),

						array(
							'class' => 'toggled_header',
   						'title' => __('Content', 'mfn-opts'),
   					),

						array(
   						'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .blockquote blockquote:text-align',
							'responsive' => 'desktop',
   						'type' => 'switch',
   						'class' => 'mfn_field_desktop mfn-toggled',
   						'title' => __('Text align', 'mfn-opts'),
   						'options' => array(
   							'' => __('Default', 'mfn-opts'),
   							'left' => __('Left', 'mfn-opts'),
								'center' => __('Center', 'mfn-opts'),
   							'right' => __('Right', 'mfn-opts'),
   							'justify' => __('Justify', 'mfn-opts'),
   						),
							'preview' => 'align',
   					),
   					array(
   						'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .blockquote blockquote:text-align_tablet',
							'responsive' => 'tablet',
   						'type' => 'switch',
   						'class' => 'mfn_field_tablet mfn-toggled',
   						'title' => __('Text align', 'mfn-opts'),
   						'options' => array(
   							'' => __('Default', 'mfn-opts'),
   							'left' => __('Left', 'mfn-opts'),
								'center' => __('Center', 'mfn-opts'),
   							'right' => __('Right', 'mfn-opts'),
   							'justify' => __('Justify', 'mfn-opts'),
   						),
							'preview' => 'align',
   					),
   					array(
   						'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .blockquote blockquote:text-align_mobile',
							'responsive' => 'mobile',
   						'type' => 'switch',
   						'class' => 'mfn_field_mobile mfn-toggled',
   						'title' => __('Text align', 'mfn-opts'),
   						'options' => array(
   							'' => __('Default', 'mfn-opts'),
   							'left' => __('Left', 'mfn-opts'),
								'center' => __('Center', 'mfn-opts'),
   							'right' => __('Right', 'mfn-opts'),
   							'justify' => __('Justify', 'mfn-opts'),
   						),
							'preview' => 'align',
   					),

   					array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .blockquote blockquote:color',
							'type' => 'color',
							'class' => 'mfn-toggled',
							'title' => __('Color', 'mfn-opts'),
						),

						array(
		  				'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .blockquote blockquote:margin',
		  				'type' => 'dimensions',
		  				'title' => __('Margin', 'mfn-opts'),
		  				'version' => 'separated-fields',
							'responsive' => 'desktop',
							'class' => 'mfn_field_desktop mfn-toggled',
							'css_attr' => 'margin',
		  			),

		  			array(
		  				'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .blockquote blockquote:margin_tablet',
		  				'type' => 'dimensions',
		  				'title' => __('Margin', 'mfn-opts'),
		  				'version' => 'separated-fields',
							'responsive' => 'tablet',
							'class' => 'mfn_field_tablet mfn-toggled',
							'css_attr' => 'margin',
		  			),

		  			array(
		  				'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .blockquote blockquote:margin_mobile',
		  				'type' => 'dimensions',
		  				'title' => __('Margin', 'mfn-opts'),
		  				'version' => 'separated-fields',
							'responsive' => 'mobile',
							'class' => 'mfn_field_mobile mfn-toggled',
							'css_attr' => 'margin',
		  			),

						array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .blockquote blockquote:text-shadow',
							'type' => 'text_shadow',
							'class' => 'mfn-toggled',
							'title' => __('Text shadow', 'mfn-opts'),
						),

   					array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .blockquote blockquote:typography',
							'type' => 'typography_vb',
							'label_after' => '<a href="#" title="Edit" class="mfn-option-btn mfn-option-blank btn-medium mfn-vb-label-button"><span class="mfn-icon mfn-icon-edit"></span></a>',
							'class' => 'toggle_fields mfn-toggled',
							'title' => __('Typography', 'mfn-opts'),
						),

						array(
							'class' => 'toggled_header',
							'themeoptions' => 'style:',
   						'title' => __('Content icon', 'mfn-opts'),
   					),

						array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .blockquote .mfn-blockquote-icon:color',
							'type' => 'color',
							'themeoptions' => 'style:',
							'class' => 'mfn-toggled',
							'title' => __('Color', 'mfn-opts'),
						),

						array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .blockquote .mfn-blockquote-icon:font-size',
							'type' => 'sliderbar',
							'themeoptions' => 'style:',
							'responsive' => 'desktop',
							'class' => 'mfn_field_desktop mfn-toggled',
							'title' => __('Size', 'mfn-opts'),
							'units' => array(
								'px' 	=> array('min' => 1, 		'max' => 100, 'step' => 1),
								'em' 	=> array('min' => 0.1, 	'max' => 10, 	'step' => 0.1),
								'rem' => array('min' => 0.1, 	'max' => 10, 	'step' => 0.1),
								'vw' 	=> array('min' => 1, 		'max' => 100, 'step' => 1),
							)
						),

						array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .blockquote .mfn-blockquote-icon:font-size_tablet',
							'type' => 'sliderbar',
							'themeoptions' => 'style:',
							'responsive' => 'tablet',
							'class' => 'mfn_field_tablet mfn-toggled',
							'title' => __('Size', 'mfn-opts'),
							'units' => array(
								'px' 	=> array('min' => 1, 		'max' => 100, 'step' => 1),
								'em' 	=> array('min' => 0.1, 	'max' => 10, 	'step' => 0.1),
								'rem' => array('min' => 0.1, 	'max' => 10, 	'step' => 0.1),
								'vw' 	=> array('min' => 1, 		'max' => 100, 'step' => 1),
							)
						),

						array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .blockquote .mfn-blockquote-icon:font-size_mobile',
							'type' => 'sliderbar',
							'themeoptions' => 'style:',
							'responsive' => 'mobile',
							'class' => 'mfn_field_mobile mfn-toggled',
							'title' => __('Size', 'mfn-opts'),
							'units' => array(
								'px' 	=> array('min' => 1, 		'max' => 100, 'step' => 1),
								'em' 	=> array('min' => 0.1, 	'max' => 10, 	'step' => 0.1),
								'rem' => array('min' => 0.1, 	'max' => 10, 	'step' => 0.1),
								'vw' 	=> array('min' => 1, 		'max' => 100, 'step' => 1),
							)
						),

						array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .blockquote .mfn-blockquote-icon:top',
							'type' => 'text',
							'themeoptions' => 'style:',
							'responsive' => 'desktop',
							'default_unit' => 'px',
							'class' => 'mfn_field_desktop mfn-toggled',
							'title' => __('Top', 'mfn-opts')
						),

						array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .blockquote .mfn-blockquote-icon:top_tablet',
							'type' => 'text',
							'themeoptions' => 'style:',
							'responsive' => 'tablet',
							'default_unit' => 'px',
							'class' => 'mfn_field_tablet mfn-toggled',
							'title' => __('Top', 'mfn-opts')
						),

						array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .blockquote .mfn-blockquote-icon:top_mobile',
							'type' => 'text',
							'themeoptions' => 'style:',
							'responsive' => 'mobile',
							'default_unit' => 'px',
							'class' => 'mfn_field_mobile mfn-toggled',
							'title' => __('Top', 'mfn-opts')
						),

						array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .blockquote .mfn-blockquote-icon:left',
							'type' => 'text',
							'themeoptions' => 'style:',
							'responsive' => 'desktop',
							'default_unit' => 'px',
							'class' => 'mfn_field_desktop mfn-toggled',
							'title' => __('Left', 'mfn-opts')
						),

						array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .blockquote .mfn-blockquote-icon:left_tablet',
							'type' => 'text',
							'themeoptions' => 'style:',
							'responsive' => 'tablet',
							'default_unit' => 'px',
							'class' => 'mfn_field_tablet mfn-toggled',
							'title' => __('Left', 'mfn-opts')
						),

						array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .blockquote .mfn-blockquote-icon:left_mobile',
							'type' => 'text',
							'themeoptions' => 'style:',
							'responsive' => 'mobile',
							'default_unit' => 'px',
							'class' => 'mfn_field_mobile mfn-toggled',
							'title' => __('Left', 'mfn-opts')
						),

						array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .blockquote .mfn-blockquote-icon:bottom',
							'type' => 'text',
							'themeoptions' => 'style:',
							'responsive' => 'desktop',
							'default_unit' => 'px',
							'class' => 'mfn_field_desktop mfn-toggled',
							'title' => __('Bottom', 'mfn-opts')
						),

						array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .blockquote .mfn-blockquote-icon:bottom_tablet',
							'type' => 'text',
							'themeoptions' => 'style:',
							'responsive' => 'tablet',
							'default_unit' => 'px',
							'class' => 'mfn_field_tablet mfn-toggled',
							'title' => __('Bottom', 'mfn-opts')
						),

						array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .blockquote .mfn-blockquote-icon:bottom_mobile',
							'type' => 'text',
							'themeoptions' => 'style:',
							'responsive' => 'mobile',
							'default_unit' => 'px',
							'class' => 'mfn_field_mobile mfn-toggled',
							'title' => __('Bottom', 'mfn-opts')
						),

						array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .blockquote .mfn-blockquote-icon:right',
							'type' => 'text',
							'themeoptions' => 'style:',
							'responsive' => 'desktop',
							'default_unit' => 'px',
							'class' => 'mfn_field_desktop mfn-toggled',
							'title' => __('Right', 'mfn-opts')
						),

						array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .blockquote .mfn-blockquote-icon:right_tablet',
							'type' => 'text',
							'themeoptions' => 'style:',
							'responsive' => 'tablet',
							'default_unit' => 'px',
							'class' => 'mfn_field_tablet mfn-toggled',
							'title' => __('Right', 'mfn-opts')
						),

						array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .blockquote .mfn-blockquote-icon:right_mobile',
							'type' => 'text',
							'themeoptions' => 'style:',
							'responsive' => 'mobile',
							'default_unit' => 'px',
							'class' => 'mfn_field_mobile mfn-toggled',
							'title' => __('Right', 'mfn-opts')
						),


						array(
							'class' => 'toggled_header',
   						'title' => __('Author', 'mfn-opts'),
   					),

   					array(
   						'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .blockquote .author:text-align',
							'responsive' => 'desktop',
   						'type' => 'switch',
   						'class' => 'mfn_field_desktop mfn-toggled',
   						'title' => __('Text align', 'mfn-opts'),
   						'options' => array(
   							'' => __('Default', 'mfn-opts'),
   							'left' => __('Left', 'mfn-opts'),
								'center' => __('Center', 'mfn-opts'),
   							'right' => __('Right', 'mfn-opts'),
   							'justify' => __('Justify', 'mfn-opts'),
   						),
							'preview' => 'align',
   					),
   					array(
   						'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .blockquote .author:text-align_tablet',
							'responsive' => 'tablet',
   						'type' => 'switch',
   						'class' => 'mfn_field_tablet mfn-toggled',
   						'title' => __('Text align', 'mfn-opts'),
   						'options' => array(
   							'' => __('Default', 'mfn-opts'),
   							'left' => __('Left', 'mfn-opts'),
								'center' => __('Center', 'mfn-opts'),
   							'right' => __('Right', 'mfn-opts'),
   							'justify' => __('Justify', 'mfn-opts'),
   						),
							'preview' => 'align',
   					),
   					array(
   						'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .blockquote .author:text-align_mobile',
							'responsive' => 'mobile',
   						'type' => 'switch',
   						'class' => 'mfn_field_mobile mfn-toggled',
   						'title' => __('Text align', 'mfn-opts'),
   						'options' => array(
   							'' => __('Default', 'mfn-opts'),
   							'left' => __('Left', 'mfn-opts'),
								'center' => __('Center', 'mfn-opts'),
   							'right' => __('Right', 'mfn-opts'),
   							'justify' => __('Justify', 'mfn-opts'),
   						),
							'preview' => 'align',
   					),

   					array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .blockquote .author span,.mcb-section .mcb-wrap .mcb-item-mfnuidelement .blockquote .author a:color',
							'type' => 'color',
							'class' => 'mfn-toggled',
							'title' => __('Color', 'mfn-opts'),
						),

						array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .blockquote .author:typography',
							'type' => 'typography_vb',
							'label_after' => '<a href="#" title="Edit" class="mfn-option-btn mfn-option-blank btn-medium mfn-vb-label-button"><span class="mfn-icon mfn-icon-edit"></span></a>',
							'class' => 'toggle_fields mfn-toggled',
							'title' => __('Typography', 'mfn-opts'),
						),

						array(
		  				'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .blockquote .author:margin',
		  				'type' => 'dimensions',
		  				'title' => __('Margin', 'mfn-opts'),
		  				'version' => 'separated-fields',
							'responsive' => 'desktop',
							'class' => 'mfn_field_desktop mfn-toggled',
							'css_attr' => 'margin',
		  			),

		  			array(
		  				'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .blockquote .author:margin_tablet',
		  				'type' => 'dimensions',
		  				'title' => __('Margin', 'mfn-opts'),
		  				'version' => 'separated-fields',
							'responsive' => 'tablet',
							'class' => 'mfn_field_tablet mfn-toggled',
							'css_attr' => 'margin',
		  			),

		  			array(
		  				'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .blockquote .author:margin_mobile',
		  				'type' => 'dimensions',
		  				'title' => __('Margin', 'mfn-opts'),
		  				'version' => 'separated-fields',
							'responsive' => 'mobile',
							'class' => 'mfn_field_mobile mfn-toggled',
							'css_attr' => 'margin',
		  			),

		  			array(
							'class' => 'toggled_header',
   						'title' => __('Author icon', 'mfn-opts'),
   					),

   					array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .blockquote .author i:color',
							'type' => 'color',
							'class' => 'mfn-toggled',
							'title' => __('Icon color', 'mfn-opts'),
						),

						array(
		  				'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .blockquote .author i:margin',
		  				'type' => 'dimensions',
		  				'title' => __('Margin', 'mfn-opts'),
		  				'version' => 'separated-fields',
							'responsive' => 'desktop',
							'class' => 'mfn_field_desktop mfn-toggled',
							'css_attr' => 'margin',
		  			),

		  			array(
		  				'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .blockquote .author i:margin_tablet',
		  				'type' => 'dimensions',
		  				'title' => __('Margin', 'mfn-opts'),
		  				'version' => 'separated-fields',
							'responsive' => 'tablet',
							'class' => 'mfn_field_tablet mfn-toggled',
							'css_attr' => 'margin',
		  			),

		  			array(
		  				'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .blockquote .author i:margin_mobile',
		  				'type' => 'dimensions',
		  				'title' => __('Margin', 'mfn-opts'),
		  				'version' => 'separated-fields',
							'responsive' => 'mobile',
							'class' => 'mfn_field_mobile mfn-toggled',
							'css_attr' => 'margin',
		  			),

		  			array(
							'class' => 'toggled_header',
							'themeoptions' => 'style:',
   						'title' => __('Lines', 'mfn-opts'),
   					),

   					array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .blockquote blockquote:text-decoration-color',
							'type' => 'color',
							'themeoptions' => 'style:',
							'class' => 'mfn-toggled',
							'title' => __('Color', 'mfn-opts'),
						),

						array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .blockquote blockquote:text-underline-offset',
							'type' => 'text',
							'themeoptions' => 'style:',
							'class' => 'mfn-toggled',
							'default_unit' => 'px',
							'title' => __('Offset', 'mfn-opts'),
						),

						array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .blockquote blockquote:text-decoration-thickness',
							'type' => 'text',
							'themeoptions' => 'style:',
							'class' => 'mfn-toggled',
							'default_unit' => 'px',
							'title' => __('Thickness', 'mfn-opts'),
						),

						array(
							'type' => 'html',
							'html' => '</div>',
						),

   				),
   			),

   			// Blog -----------------------------------------------------------

   			'blog' => array(
   				'type' => 'blog',
   				'title' => __('Blog', 'mfn-opts'),
   				'size' => '1/1',
   				'tablet_size' => '1/1',
   				'mobile_size' => '1/1',
   				'tablet_resized' => '0',
   				'cat' => 'loops',
   				'fields' => array(

   					array(
							'type' => 'html',
							'html' => $this->itemtabs,
						),

   					array(
							'type' => 'html',
							'html' => '<div class="modalbox-card modalbox-re_render modalbox-card-content-mfnuidhere active">',
						),

   					array(
   						'id' => 'count',
   						're_render' => 'standard',
   						'type' => 'text',
   						'title' => __('Posts number', 'mfn-opts'),
   						'std' => '3',
							'after' => 'posts',
							'param' => 'number',
							'class' => 'narrow',
							'preview' => 'number',
   					),

   					array(
   						'id' => 'style',
   						're_render' => 'standard',
   						'type' => 'select',
   						'title' => __('Style', 'mfn-opts'),
   						'options' => array(
   							'classic' => __('Classic - 1 column', 'mfn-opts'),
   							'grid' => __('Grid - 2-4 columns', 'mfn-opts'),
   							'masonry' => __('Masonry blog style - 2-4 columns', 'mfn-opts'),
   							'masonry tiles' => __('Masonry tiles - 2-4 columns', 'mfn-opts'),
   							'photo' => __('Photo - 1 column', 'mfn-opts'),
   							'photo2' => __('Photo 2 - 1-3 columns', 'mfn-opts'),
   							'timeline' => __('Timeline - 1 column', 'mfn-opts'),
   						),
   						'std' => 'grid',
   						'preview' => 'style',
   					),

   					array(
   						'id' => 'columns',
   						're_render' => 'standard',
   						'type' => 'switch',
   						'title' => __('Columns', 'mfn-opts'),
   						'desc' => __('for style: Grid, Masonry, Photo 2', 'mfn-opts'),
   						'options' => array(
   							2	=> 2,
   							3	=> 3,
   							4	=> 4,
   							5	=> 5,
   							6	=> 6,
   						),
   						'std' => 3,
   					),

						array(
   						'id' => 'title_tag',
   						're_render' => 'standard',
   						'type' => 'switch',
   						'title' => __('Title tag', 'mfn-opts'),
   						'options' => array(
   							'h2' => 'H2',
   							'h3' => 'H3',
   							'h4' => 'H4',
   							'h5' => 'H5',
   							'h6' => 'H6',
   						),
   						'std' => 'h2'
   					),

   					array(
   						'id' => 'images',
   						're_render' => 'standard',
   						'type' => 'switch',
   						'title' => __('Post image', 'mfn-opts'),
   						'desc' => __('for all styles except Masonry tiles', 'mfn-opts'),
   						'options' => array(
   							'' => 'Default',
   							'images-only' => 'Featured images only',
   						),
   					),

   					// options

   					array(
   						'title' => __('Options', 'mfn-opts'),
   					),

   					array(
   						'id' => 'category',
   						're_render' => 'standard',
   						'type' => 'select',
   						'title' => __('Category', 'mfn-opts'),
   						'options' => mfn_get_categories('category'),
   						'preview' => 'category',
   					),

   					array(
   						'id' => 'category_multi',
   						're_render' => 'standard',
   						'type' => 'text',
   						'title' => __('Multiple categories', 'mfn-opts'),
   						'desc' => __('Slugs should be separated with <b>coma</b> ( , )', 'mfn-opts'),
							'preview' => 'category-all',
   					),

   					array(
   						'id' => 'orderby',
   						're_render' => 'standard',
   						'type' => 'switch',
   						'title' => __('Order by', 'mfn-opts'),
   						'desc' => __('Do <b>not</b> use random order with pagination or load more', 'mfn-opts'),
   						'options' => array(
   							'date' => __('Date', 'mfn-opts'),
   							'title' => __('Title', 'mfn-opts'),
   							'rand' => __('Random', 'mfn-opts'),
   						),
   						'std' => 'date'
   					),

   					array(
   						'id' => 'order',
   						're_render' => 'standard',
   						'type' => 'switch',
   						'title' => __('Order', 'mfn-opts'),
   						'options' => array(
								'DESC' => __('Descending', 'mfn-opts'),
   							'ASC' => __('Ascending', 'mfn-opts'),
   						),
   						'std' => 'DESC'
   					),

						// advanced

   					array(
   						'title' => __('Advanced', 'mfn-opts'),
   					),

   					array(
   						'id' => 'exclude_id',
   						're_render' => 'standard',
   						'type' => 'text',
   						'title' => __('Exclude posts', 'mfn-opts'),
   						'desc' => __('IDs should be separated with <b>coma</b> ( , )', 'mfn-opts'),
   					),

   					array(
   						'id' => 'filters',
   						're_render' => 'standard',
   						'type' => 'select',
   						'title' => __('Filters', 'mfn-opts'),
   						'desc' => __('for style: Masonry and category: All<br />Does <b>not</b> work with pagination or load more', 'mfn-opts'),
   						'options' => array(
   							'0' => __('Hide', 'mfn-opts'),
   							'1' => __('Show', 'mfn-opts'),
   							'only-categories' => __('Show only categories', 'mfn-opts'),
   							'only-tags' => __('Show only tags', 'mfn-opts'),
   							'only-authors' => __('Show only authors', 'mfn-opts'),
   						),
   						'std' => '0'
   					),

						array(
   						'id' => 'excerpt',
   						're_render' => 'standard',
   						'type' => 'switch',
							'title' => __('Excerpt', 'mfn-opts'),
   						'options' => array(
								0 => __('Hide', 'mfn-opts'),
   							1 => __('Show', 'mfn-opts'),
							),
   						'std' => 1,
   					),

   					array(
   						'id' => 'more',
   						're_render' => 'standard',
   						'type' => 'switch',
							'title' => __('Read more', 'mfn-opts'),
   						'options' => array(
								0 => __('Hide', 'mfn-opts'),
   							1 => __('Show', 'mfn-opts'),
							),
   						'std' => 1,
   					),

						// pagination

   					array(
   						'title' => __('Pagination', 'mfn-opts'),
   					),

   					array(
   						'id' => 'pagination',
   						're_render' => 'standard',
   						'type' => 'switch',
   						'title' => __('Pagination', 'mfn-opts'),
   						'desc' => __('Does <b>not</b> work on WMPL homepage', 'mfn-opts'),
							'options' => array(
								0 => __('Hide', 'mfn-opts'),
   							1 => __('Show', 'mfn-opts'),
							),
							'std' => 0,
   					),

   					array(
   						'id' => 'load_more',
   						're_render' => 'standard',
   						'type' => 'switch',
   						'title' => __('Load more', 'mfn-opts'),
   						'desc' => __('Sliders will be replaced with featured images', 'mfn-opts'),
   						'options' => array(
								0 => __('Hide', 'mfn-opts'),
   							1 => __('Show', 'mfn-opts'),
   						),
							'std' => 0,
   					),

						// style

   					array(
   						'title' => __('Style', 'mfn-opts'),
   					),

   					array(
   						'id' => 'greyscale',
   						'type' => 'switch',
   						'title' => __('Grayscale', 'mfn-opts'),
							'options' => array(
   							0 => __('Disable', 'mfn-opts'),
   							1 => __('Enable', 'mfn-opts'),
   						),
							'std' => 0,
   					),

						// plugins

						array(
							'title' => __('Plugins', 'mfn-opts'),
						),

   					array(
   						'id' => 'events',
   						'type' => 'switch',
   						'title' => __('Events', 'mfn-opts'),
   						'desc' => __('for category: All<br />requires free The Events Calendar plugin', 'mfn-opts'),
   						'options' => array(
								0 => __('Exclude', 'mfn-opts'),
   							1 => __('Include', 'mfn-opts'),
   						),
							'std' => 0,
   					),

						// deprecated

						array(
							'class' => 'mfn-deprecated',
							'title' => __('Deprecated', 'mfn-opts'),
						),

   					array(
   						'id' => 'margin',
   						'type' => 'switch',
   						'class' => 'mfn-deprecated',
   						'title' => __('Margin', 'mfn-opts'),
   						'desc' => __('for style: Masonry tiles', 'mfn-opts'),
							'options' => array(
								0 => __('Hide', 'mfn-opts'),
   							1 => __('Show', 'mfn-opts'),
   						),
							'std' => 0,
   					),

						array(
							'id' => 'class',
							'type' => 'pills',
							'title' => __('Element classes', 'mfn-opts'),
							'class' => 'mfn-deprecated',
						),

						array(
							'type' => 'html',
							'html' => '</div><div class="modalbox-card modalbox-card-style modalbox-re_render modalbox-card-style-mfnuidhere">',
						),

						array(
							'class' => 'toggled_header',
   						'title' => __('Container', 'mfn-opts'),
   					),

   					array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .blog_wrapper .post-item:background-color',
							'type' => 'color',
							'class' => 'mfn-toggled',
							'title' => __('Background', 'mfn-opts'),
						),

						array(
		  				'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .blog_wrapper .post-item:padding',
		  				'type' => 'dimensions',
		  				'version' => 'separated-fields',
		  				'title' => __('Padding', 'mfn-opts'),
							'responsive' => 'desktop',
							'class' => 'mfn_field_desktop mfn-toggled',
							'css_attr' => 'padding',
		  			),

		  			array(
		  				'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .blog_wrapper .post-item:padding_tablet',
		  				'type' => 'dimensions',
		  				'version' => 'separated-fields',
		  				'title' => __('Padding', 'mfn-opts'),
							'responsive' => 'tablet',
							'class' => 'mfn_field_tablet mfn-toggled',
							'css_attr' => 'padding',
		  			),

		  			array(
		  				'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .blog_wrapper .post-item:padding_mobile',
		  				'type' => 'dimensions',
		  				'version' => 'separated-fields',
		  				'title' => __('Padding', 'mfn-opts'),
							'responsive' => 'mobile',
							'class' => 'mfn_field_mobile mfn-toggled',
							'css_attr' => 'padding',
		  			),

		  			array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .blog_wrapper .post-item:border-style',
							'attr_id' => 'border_style_blog_item',
							'type' => 'select',
							'class' => 'mfn-toggled',
							'title' => __('Border style', 'mfn-opts'),
							'options' => [
								'none' => __('None', 'mfn-opts'),
								'solid' => __('Solid', 'mfn-opts'),
								'dashed' => __('Dashed', 'mfn-opts'),
								'dotted' => __('Dotted', 'mfn-opts'),
								'double' => __('Double', 'mfn-opts'),
							],
						),

						array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .blog_wrapper .post-item:border-color',
							'condition' => array( 'id' => 'border_style_blog_item', 'opt' => 'isnt', 'val' => 'none' ),
							'type' => 'color',
							'class' => 'mfn-toggled',
							'title' => __('Border color', 'mfn-opts'),
						),

						array(
		  				'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .blog_wrapper .post-item:border-width',
		  				'condition' => array( 'id' => 'border_style_blog_item', 'opt' => 'isnt', 'val' => 'none' ),
		  				'type' => 'dimensions',
		  				'title' => __('Border width', 'mfn-opts'),
							'responsive' => 'desktop',
							'class' => 'mfn_field_desktop mfn-toggled',
							'css_attr' => 'border-width',
		  			),

		  			array(
		  				'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .blog_wrapper .post-item:border-width_tablet',
		  				'condition' => array( 'id' => 'border_style_blog_item', 'opt' => 'isnt', 'val' => 'none' ),
		  				'type' => 'dimensions',
		  				'title' => __('Border width', 'mfn-opts'),
							'responsive' => 'tablet',
							'class' => 'mfn_field_tablet mfn-toggled',
							'css_attr' => 'border-width',
		  			),

		  			array(
		  				'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .blog_wrapper .post-item:border-width_mobile',
		  				'condition' => array( 'id' => 'border_style_blog_item', 'opt' => 'isnt', 'val' => 'none' ),
		  				'type' => 'dimensions',
		  				'title' => __('Border width', 'mfn-opts'),
							'responsive' => 'mobile',
							'class' => 'mfn_field_mobile mfn-toggled',
							'css_attr' => 'border-width',
		  			),

		  			array(
		  				'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .blog_wrapper .post-item:border-radius',
		  				'type' => 'dimensions',
		  				'title' => __('Border radius', 'mfn-opts'),
							'responsive' => 'desktop',
							'class' => 'mfn_field_desktop mfn-toggled',
							'css_attr' => 'border-radius',
		  			),

		  			array(
		  				'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .blog_wrapper .post-item:border-radius_tablet',
		  				'type' => 'dimensions',
		  				'title' => __('Border radius', 'mfn-opts'),
							'responsive' => 'tablet',
							'class' => 'mfn_field_tablet mfn-toggled',
							'css_attr' => 'border-radius',
		  			),

		  			array(
		  				'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .blog_wrapper .post-item:border-radius_mobile',
		  				'type' => 'dimensions',
		  				'title' => __('Border radius', 'mfn-opts'),
							'responsive' => 'mobile',
							'class' => 'mfn_field_mobile mfn-toggled',
							'css_attr' => 'border-radius',
		  			),

		  			array(
							'class' => 'toggled_header',
   						'title' => __('Image', 'mfn-opts'),
   					),

		  			array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .blog_wrapper .post-item .image_frame:border-style',
							'attr_id' => 'border_style',
							'type' => 'select',
							'class' => 'mfn-toggled',
							'title' => __('Border style', 'mfn-opts'),
							'options' => [
								'none' => __('None', 'mfn-opts'),
								'solid' => __('Solid', 'mfn-opts'),
								'dashed' => __('Dashed', 'mfn-opts'),
								'dotted' => __('Dotted', 'mfn-opts'),
								'double' => __('Double', 'mfn-opts'),
							],
						),

						array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .blog_wrapper .post-item .image_frame:border-color',
							'condition' => array( 'id' => 'border_style', 'opt' => 'isnt', 'val' => 'none' ),
							'type' => 'color',
							'class' => 'mfn-toggled',
							'title' => __('Border color', 'mfn-opts'),
						),

						array(
		  				'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .blog_wrapper .post-item .image_frame:border-width',
		  				'condition' => array( 'id' => 'border_style', 'opt' => 'isnt', 'val' => 'none' ),
		  				'type' => 'dimensions',
		  				'title' => __('Border width', 'mfn-opts'),
							'responsive' => 'desktop',
							'class' => 'mfn_field_desktop mfn-toggled',
							'css_attr' => 'border-width',
		  			),

		  			array(
		  				'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .blog_wrapper .post-item .image_frame:border-width_tablet',
		  				'condition' => array( 'id' => 'border_style', 'opt' => 'isnt', 'val' => 'none' ),
		  				'type' => 'dimensions',
		  				'title' => __('Border width', 'mfn-opts'),
							'responsive' => 'tablet',
							'class' => 'mfn_field_tablet mfn-toggled',
							'css_attr' => 'border-width',
		  			),

		  			array(
		  				'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .blog_wrapper .post-item .image_frame:border-width_mobile',
		  				'condition' => array( 'id' => 'border_style', 'opt' => 'isnt', 'val' => 'none' ),
		  				'type' => 'dimensions',
		  				'title' => __('Border width', 'mfn-opts'),
							'responsive' => 'mobile',
							'class' => 'mfn_field_mobile mfn-toggled',
							'css_attr' => 'border-width',
		  			),

						array(
		  				'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .blog_wrapper .post-item .image_frame:border-radius',
		  				'type' => 'dimensions',
		  				'title' => __('Border radius', 'mfn-opts'),
							'responsive' => 'desktop',
							'class' => 'mfn_field_desktop mfn-toggled',
							'css_attr' => 'border-radius',
		  			),

		  			array(
		  				'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .blog_wrapper .post-item .image_frame:border-radius_tablet',
		  				'type' => 'dimensions',
		  				'title' => __('Border radius', 'mfn-opts'),
							'responsive' => 'tablet',
							'class' => 'mfn_field_tablet mfn-toggled',
							'css_attr' => 'border-radius',
		  			),

		  			array(
		  				'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .blog_wrapper .post-item .image_frame:border-radius_mobile',
		  				'type' => 'dimensions',
		  				'title' => __('Border radius', 'mfn-opts'),
							'responsive' => 'mobile',
							'class' => 'mfn_field_mobile mfn-toggled',
							'css_attr' => 'border-radius',
		  			),

		  			array(
							'class' => 'toggled_header',
   						'title' => __('Content', 'mfn-opts'),
   					),

   					array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .blog_wrapper .post-item .post-desc:background-color',
							'type' => 'color',
							'class' => 'mfn-toggled',
							'title' => __('Background', 'mfn-opts'),
						),

						array(
		  				'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .blog_wrapper .post-item .post-desc-wrapper:margin',
		  				'type' => 'dimensions',
		  				'version' => 'separated-fields',
		  				'title' => __('Margin', 'mfn-opts'),
							'responsive' => 'desktop',
							'class' => 'mfn_field_desktop mfn-toggled',
							'css_attr' => 'margin',
		  			),

		  			array(
		  				'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .blog_wrapper .post-item .post-desc-wrapper:margin_tablet',
		  				'type' => 'dimensions',
		  				'version' => 'separated-fields',
		  				'title' => __('Margin', 'mfn-opts'),
							'responsive' => 'tablet',
							'class' => 'mfn_field_tablet mfn-toggled',
							'css_attr' => 'margin',
		  			),

		  			array(
		  				'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .blog_wrapper .post-item .post-desc-wrapper:margin_mobile',
		  				'type' => 'dimensions',
		  				'version' => 'separated-fields',
		  				'title' => __('Margin', 'mfn-opts'),
							'responsive' => 'mobile',
							'class' => 'mfn_field_mobile mfn-toggled',
							'css_attr' => 'margin',
		  			),

						array(
		  				'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .blog_wrapper .post-item .post-desc:padding',
		  				'type' => 'dimensions',
		  				'version' => 'separated-fields',
		  				'title' => __('Padding', 'mfn-opts'),
							'responsive' => 'desktop',
							'class' => 'mfn_field_desktop mfn-toggled',
							'css_attr' => 'padding',
		  			),

		  			array(
		  				'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .blog_wrapper .post-item .post-desc:padding_tablet',
		  				'type' => 'dimensions',
		  				'version' => 'separated-fields',
		  				'title' => __('Padding', 'mfn-opts'),
							'responsive' => 'tablet',
							'class' => 'mfn_field_tablet mfn-toggled',
							'css_attr' => 'padding',
		  			),

		  			array(
		  				'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .blog_wrapper .post-item .post-desc:padding_mobile',
		  				'type' => 'dimensions',
		  				'version' => 'separated-fields',
		  				'title' => __('Padding', 'mfn-opts'),
							'responsive' => 'mobile',
							'class' => 'mfn_field_mobile mfn-toggled',
							'css_attr' => 'padding',
		  			),

		  			array(
							'class' => 'toggled_header',
   						'title' => __('Post header', 'mfn-opts'),
   					),

   					array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .blog_wrapper .post-item .post-desc .post-head:background-color',
							'type' => 'color',
							'class' => 'mfn-toggled',
							'title' => __('Background', 'mfn-opts'),
						),

						array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .blog_wrapper .post-item .post-desc .post-head .post-meta:color',
							'type' => 'color',
							'class' => 'mfn-toggled',
							'title' => __('Color', 'mfn-opts'),
						),

						array(
		  				'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .blog_wrapper .post-item .post-desc .post-head:margin',
		  				'type' => 'dimensions',
		  				'version' => 'separated-fields',
		  				'title' => __('Margin', 'mfn-opts'),
							'responsive' => 'desktop',
							'class' => 'mfn_field_desktop mfn-toggled',
							'css_attr' => 'margin',
		  			),

		  			array(
		  				'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .blog_wrapper .post-item .post-desc .post-head:margin_tablet',
		  				'type' => 'dimensions',
		  				'version' => 'separated-fields',
		  				'title' => __('Margin', 'mfn-opts'),
							'responsive' => 'tablet',
							'class' => 'mfn_field_tablet mfn-toggled',
							'css_attr' => 'margin',
		  			),

		  			array(
		  				'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .blog_wrapper .post-item .post-desc .post-head:margin_mobile',
		  				'type' => 'dimensions',
		  				'version' => 'separated-fields',
		  				'title' => __('Margin', 'mfn-opts'),
							'responsive' => 'mobile',
							'class' => 'mfn_field_mobile mfn-toggled',
							'css_attr' => 'margin',
		  			),

						array(
		  				'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .blog_wrapper .post-item .post-desc .post-head:padding',
		  				'type' => 'dimensions',
		  				'version' => 'separated-fields',
		  				'title' => __('Padding', 'mfn-opts'),
							'responsive' => 'desktop',
							'class' => 'mfn_field_desktop mfn-toggled',
							'css_attr' => 'padding',
		  			),

		  			array(
		  				'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .blog_wrapper .post-item .post-desc .post-head:padding_tablet',
		  				'type' => 'dimensions',
		  				'version' => 'separated-fields',
		  				'title' => __('Padding', 'mfn-opts'),
							'responsive' => 'tablet',
							'class' => 'mfn_field_tablet mfn-toggled',
							'css_attr' => 'padding',
		  			),

		  			array(
		  				'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .blog_wrapper .post-item .post-desc .post-head:padding_mobile',
		  				'type' => 'dimensions',
		  				'version' => 'separated-fields',
		  				'title' => __('Padding', 'mfn-opts'),
							'responsive' => 'mobile',
							'class' => 'mfn_field_mobile mfn-toggled',
							'css_attr' => 'padding',
		  			),

		  			array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .blog_wrapper .post-item .post-desc .post-head:border-style',
							'attr_id' => 'border_style',
							'type' => 'select',
							'class' => 'mfn-toggled',
							'title' => __('Border style', 'mfn-opts'),
							'options' => [
								'none' => __('None', 'mfn-opts'),
								'solid' => __('Solid', 'mfn-opts'),
								'dashed' => __('Dashed', 'mfn-opts'),
								'dotted' => __('Dotted', 'mfn-opts'),
								'double' => __('Double', 'mfn-opts'),
							],
						),

						array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .blog_wrapper .post-item .post-desc .post-head:border-color',
							'condition' => array( 'id' => 'border_style', 'opt' => 'isnt', 'val' => 'none' ),
							'type' => 'color',
							'class' => 'mfn-toggled',
							'title' => __('Border color', 'mfn-opts'),
						),

						array(
		  				'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .blog_wrapper .post-item .post-desc .post-head:border-width',
		  				'condition' => array( 'id' => 'border_style', 'opt' => 'isnt', 'val' => 'none' ),
		  				'type' => 'dimensions',
		  				'title' => __('Border width', 'mfn-opts'),
							'responsive' => 'desktop',
							'class' => 'mfn_field_desktop mfn-toggled',
							'css_attr' => 'border-width',
		  			),

		  			array(
		  				'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .blog_wrapper .post-item .post-desc .post-head:border-width_tablet',
		  				'condition' => array( 'id' => 'border_style', 'opt' => 'isnt', 'val' => 'none' ),
		  				'type' => 'dimensions',
		  				'title' => __('Border width', 'mfn-opts'),
							'responsive' => 'tablet',
							'class' => 'mfn_field_tablet mfn-toggled',
							'css_attr' => 'border-width',
		  			),

		  			array(
		  				'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .blog_wrapper .post-item .post-desc .post-head:border-width_mobile',
		  				'condition' => array( 'id' => 'border_style', 'opt' => 'isnt', 'val' => 'none' ),
		  				'type' => 'dimensions',
		  				'title' => __('Border width', 'mfn-opts'),
							'responsive' => 'mobile',
							'class' => 'mfn_field_mobile mfn-toggled',
							'css_attr' => 'border-width',
		  			),

						array(
		  				'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .blog_wrapper .post-item .post-desc .post-head:border-radius',
		  				'type' => 'dimensions',
		  				'title' => __('Border radius', 'mfn-opts'),
							'responsive' => 'desktop',
							'class' => 'mfn_field_desktop mfn-toggled',
							'css_attr' => 'border-radius',
		  			),

		  			array(
		  				'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .blog_wrapper .post-item .post-desc .post-head:border-radius_tablet',
		  				'type' => 'dimensions',
		  				'title' => __('Border radius', 'mfn-opts'),
							'responsive' => 'tablet',
							'class' => 'mfn_field_tablet mfn-toggled',
							'css_attr' => 'border-radius',
		  			),

		  			array(
		  				'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .blog_wrapper .post-item .post-desc .post-head:border-radius_mobile',
		  				'type' => 'dimensions',
		  				'title' => __('Border radius', 'mfn-opts'),
							'responsive' => 'mobile',
							'class' => 'mfn_field_mobile mfn-toggled',
							'css_attr' => 'border-radius',
		  			),

		  			array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .blog_wrapper .post-item .post-desc .post-head:typography',
							'type' => 'typography_vb',
							'label_after' => '<a href="#" title="Edit" class="mfn-option-btn mfn-option-blank btn-medium mfn-vb-label-button"><span class="mfn-icon mfn-icon-edit"></span></a>',
							'class' => 'mfn-toggled toggle_fields',
							'title' => __('Typography', 'mfn-opts'),
						),

		  			array(
							'type' => 'html',
							'html' => '<div class="mfn-form-row mfn-sidebar-fields-tabs mfn-toggled mfn-vb-formrow mfn-vb-mfnuidhere"><ul class="mfn-sft-nav"><li class="active"><a href="#normal" data-tab="normal">Normal</a></li><li><a href="#hover" data-tab="hover">Hover</a></li></ul><div class="mfn-sft mfn-sft-normal">',
						),

						array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .blog_wrapper .post-item .post-desc .post-head .post-meta a:color',
							'type' => 'color',
							'title' => __('Link color', 'mfn-opts'),
						),

						array(
							'type' => 'html',
							'html' => '</div><div class="mfn-sft mfn-sft-hover">',
						),

						array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .blog_wrapper .post-item .post-desc .post-head .post-meta a|hover:color',
							'type' => 'color',
							'title' => __('Link color', 'mfn-opts'),
						),

						array(
							'type' => 'html',
							'html' => '</div></div>',
						),

						array(
							'class' => 'toggled_header',
   						'title' => __('Title', 'mfn-opts'),
   					),

   					array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .blog_wrapper .post-item .post-desc .post-title .entry-title a:color',
							'type' => 'color',
							'class' => 'mfn-toggled',
							'title' => __('Color', 'mfn-opts'),
						),

						array(
		  				'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .blog_wrapper .post-item .post-desc .post-title .entry-title:margin',
		  				'type' => 'dimensions',
		  				'version' => 'separated-fields',
		  				'title' => __('Margin', 'mfn-opts'),
							'responsive' => 'desktop',
							'class' => 'mfn_field_desktop mfn-toggled',
							'css_attr' => 'margin',
		  			),

		  			array(
		  				'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .blog_wrapper .post-item .post-desc .post-title .entry-title:margin_tablet',
		  				'type' => 'dimensions',
		  				'version' => 'separated-fields',
		  				'title' => __('Margin', 'mfn-opts'),
							'responsive' => 'tablet',
							'class' => 'mfn_field_tablet mfn-toggled',
							'css_attr' => 'margin',
		  			),

		  			array(
		  				'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .blog_wrapper .post-item .post-desc .post-title .entry-title:margin_mobile',
		  				'type' => 'dimensions',
		  				'version' => 'separated-fields',
		  				'title' => __('Margin', 'mfn-opts'),
							'responsive' => 'mobile',
							'class' => 'mfn_field_mobile mfn-toggled',
							'css_attr' => 'margin',
		  			),

		  			array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .blog_wrapper .post-item .post-desc .post-title .entry-title:typography',
							'type' => 'typography_vb',
							'label_after' => '<a href="#" title="Edit" class="mfn-option-btn mfn-option-blank btn-medium mfn-vb-label-button"><span class="mfn-icon mfn-icon-edit"></span></a>',
							'class' => 'mfn-toggled toggle_fields',
							'title' => __('Typography', 'mfn-opts'),
						),

						array(
							'class' => 'toggled_header',
   						'title' => __('Excerpt', 'mfn-opts'),
   					),

   					array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .blog_wrapper .post-item .post-desc .post-excerpt:color',
							'type' => 'color',
							'class' => 'mfn-toggled',
							'title' => __('Color', 'mfn-opts'),
						),

						array(
		  				'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .blog_wrapper .post-item .post-desc .post-excerpt:margin',
		  				'type' => 'dimensions',
		  				'version' => 'separated-fields',
		  				'title' => __('Margin', 'mfn-opts'),
							'responsive' => 'desktop',
							'class' => 'mfn_field_desktop mfn-toggled',
							'css_attr' => 'margin',
		  			),

		  			array(
		  				'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .blog_wrapper .post-item .post-desc .post-excerpt:margin_tablet',
		  				'type' => 'dimensions',
		  				'version' => 'separated-fields',
		  				'title' => __('Margin', 'mfn-opts'),
							'responsive' => 'tablet',
							'class' => 'mfn_field_tablet mfn-toggled',
							'css_attr' => 'margin',
		  			),

		  			array(
		  				'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .blog_wrapper .post-item .post-desc .post-excerpt:margin_mobile',
		  				'type' => 'dimensions',
		  				'version' => 'separated-fields',
		  				'title' => __('Margin', 'mfn-opts'),
							'responsive' => 'mobile',
							'class' => 'mfn_field_mobile mfn-toggled',
							'css_attr' => 'margin',
		  			),

		  			array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .blog_wrapper .post-item .post-desc .post-excerpt:typography',
							'type' => 'typography_vb',
							'label_after' => '<a href="#" title="Edit" class="mfn-option-btn mfn-option-blank btn-medium mfn-vb-label-button"><span class="mfn-icon mfn-icon-edit"></span></a>',
							'class' => 'mfn-toggled toggle_fields',
							'title' => __('Typography', 'mfn-opts'),
						),

						array(
							'class' => 'toggled_header',
   						'title' => __('Post footer', 'mfn-opts'),
   					),

   					array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .blog_wrapper .post-item .post-desc .post-footer:background-color',
							'type' => 'color',
							'class' => 'mfn-toggled',
							'title' => __('Background', 'mfn-opts'),
						),

						array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .blog_wrapper .post-item .post-desc .post-footer,.mcb-section .mcb-wrap .mcb-item-mfnuidelement .blog_wrapper .post-item .post-desc .post-footer .button-love a .label:color',
							'type' => 'color',
							'class' => 'mfn-toggled',
							'title' => __('Color', 'mfn-opts'),
						),

						array(
		  				'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .blog_wrapper .post-item .post-desc .post-footer:margin',
		  				'type' => 'dimensions',
		  				'version' => 'separated-fields',
		  				'title' => __('Margin', 'mfn-opts'),
							'responsive' => 'desktop',
							'class' => 'mfn_field_desktop mfn-toggled',
							'css_attr' => 'margin',
		  			),

		  			array(
		  				'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .blog_wrapper .post-item .post-desc .post-footer:margin_tablet',
		  				'type' => 'dimensions',
		  				'version' => 'separated-fields',
		  				'title' => __('Margin', 'mfn-opts'),
							'responsive' => 'tablet',
							'class' => 'mfn_field_tablet mfn-toggled',
							'css_attr' => 'margin',
		  			),

		  			array(
		  				'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .blog_wrapper .post-item .post-desc .post-footer:margin_mobile',
		  				'type' => 'dimensions',
		  				'version' => 'separated-fields',
		  				'title' => __('Margin', 'mfn-opts'),
							'responsive' => 'mobile',
							'class' => 'mfn_field_mobile mfn-toggled',
							'css_attr' => 'margin',
		  			),

						array(
		  				'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .blog_wrapper .post-item .post-desc .post-footer:padding',
		  				'type' => 'dimensions',
		  				'version' => 'separated-fields',
		  				'title' => __('Padding', 'mfn-opts'),
							'responsive' => 'desktop',
							'class' => 'mfn_field_desktop mfn-toggled',
							'css_attr' => 'padding',
		  			),

		  			array(
		  				'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .blog_wrapper .post-item .post-desc .post-footer:padding_tablet',
		  				'type' => 'dimensions',
		  				'version' => 'separated-fields',
		  				'title' => __('Padding', 'mfn-opts'),
							'responsive' => 'tablet',
							'class' => 'mfn_field_tablet mfn-toggled',
							'css_attr' => 'padding',
		  			),

		  			array(
		  				'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .blog_wrapper .post-item .post-desc .post-footer:padding_mobile',
		  				'type' => 'dimensions',
		  				'version' => 'separated-fields',
		  				'title' => __('Padding', 'mfn-opts'),
							'responsive' => 'mobile',
							'class' => 'mfn_field_mobile mfn-toggled',
							'css_attr' => 'padding',
		  			),

		  			array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .blog_wrapper .post-item .post-desc .post-footer:border-style',
							'attr_id' => 'border_style',
							'type' => 'select',
							'class' => 'mfn-toggled',
							'title' => __('Border style', 'mfn-opts'),
							'options' => [
								'none' => __('None', 'mfn-opts'),
								'solid' => __('Solid', 'mfn-opts'),
								'dashed' => __('Dashed', 'mfn-opts'),
								'dotted' => __('Dotted', 'mfn-opts'),
								'double' => __('Double', 'mfn-opts'),
							],
						),

						array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .blog_wrapper .post-item .post-desc .post-footer:border-color',
							'condition' => array( 'id' => 'border_style', 'opt' => 'isnt', 'val' => 'none' ),
							'type' => 'color',
							'class' => 'mfn-toggled',
							'title' => __('Border color', 'mfn-opts'),
						),

						array(
		  				'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .blog_wrapper .post-item .post-desc .post-footer:border-width',
		  				'condition' => array( 'id' => 'border_style', 'opt' => 'isnt', 'val' => 'none' ),
		  				'type' => 'dimensions',
		  				'title' => __('Border width', 'mfn-opts'),
							'responsive' => 'desktop',
							'class' => 'mfn_field_desktop mfn-toggled',
							'css_attr' => 'border-width',
		  			),

		  			array(
		  				'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .blog_wrapper .post-item .post-desc .post-footer:border-width_tablet',
		  				'condition' => array( 'id' => 'border_style', 'opt' => 'isnt', 'val' => 'none' ),
		  				'type' => 'dimensions',
		  				'title' => __('Border width', 'mfn-opts'),
							'responsive' => 'tablet',
							'class' => 'mfn_field_tablet mfn-toggled',
							'css_attr' => 'border-width',
		  			),

		  			array(
		  				'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .blog_wrapper .post-item .post-desc .post-footer:border-width_mobile',
		  				'condition' => array( 'id' => 'border_style', 'opt' => 'isnt', 'val' => 'none' ),
		  				'type' => 'dimensions',
		  				'title' => __('Border width', 'mfn-opts'),
							'responsive' => 'mobile',
							'class' => 'mfn_field_mobile mfn-toggled',
							'css_attr' => 'border-width',
		  			),

						array(
		  				'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .blog_wrapper .post-item .post-desc .post-footer:border-radius',
		  				'type' => 'dimensions',
		  				'title' => __('Border radius', 'mfn-opts'),
							'responsive' => 'desktop',
							'class' => 'mfn_field_desktop mfn-toggled',
							'css_attr' => 'border-radius',
		  			),

		  			array(
		  				'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .blog_wrapper .post-item .post-desc .post-footer:border-radius_tablet',
		  				'type' => 'dimensions',
		  				'title' => __('Border radius', 'mfn-opts'),
							'responsive' => 'tablet',
							'class' => 'mfn_field_tablet mfn-toggled',
							'css_attr' => 'border-radius',
		  			),

		  			array(
		  				'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .blog_wrapper .post-item .post-desc .post-footer:border-radius_mobile',
		  				'type' => 'dimensions',
		  				'title' => __('Border radius', 'mfn-opts'),
							'responsive' => 'mobile',
							'class' => 'mfn_field_mobile mfn-toggled',
							'css_attr' => 'border-radius',
		  			),

		  			array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .blog_wrapper .post-item .post-desc .post-footer:typography',
							'type' => 'typography_vb',
							'label_after' => '<a href="#" title="Edit" class="mfn-option-btn mfn-option-blank btn-medium mfn-vb-label-button"><span class="mfn-icon mfn-icon-edit"></span></a>',
							'class' => 'mfn-toggled toggle_fields',
							'title' => __('Typography', 'mfn-opts'),
						),

		  			array(
							'type' => 'html',
							'html' => '<div class="mfn-form-row mfn-sidebar-fields-tabs mfn-toggled mfn-vb-formrow mfn-vb-mfnuidhere"><ul class="mfn-sft-nav"><li class="active"><a href="#normal" data-tab="normal">Normal</a></li><li><a href="#hover" data-tab="hover">Hover</a></li></ul><div class="mfn-sft mfn-sft-normal">',
						),

						array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .blog_wrapper .post-item .post-desc .post-footer a:color',
							'type' => 'color',
							'title' => __('Link color', 'mfn-opts'),
						),

						array(
							'type' => 'html',
							'html' => '</div><div class="mfn-sft mfn-sft-hover">',
						),

						array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .blog_wrapper .post-item .post-desc .post-footer a|hover:color',
							'type' => 'color',
							'title' => __('Link color', 'mfn-opts'),
						),

						array(
							'type' => 'html',
							'html' => '</div></div>',
						),

						array(
							'class' => 'toggled_header',
   						'title' => __('Masonry tiles line', 'mfn-opts'),
   					),

						array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .blog_wrapper .post-item .post-title|after:background',
							'type' => 'color',
							'class' => 'mfn-toggled',
							'title' => __('Link color', 'mfn-opts'),
						),

						array(
							'class' => 'toggled_header',
   						'title' => __('Timeline', 'mfn-opts'),
   					),

   					array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .blog_wrapper .post-item .date_label:color',
							'type' => 'color',
							'class' => 'mfn-toggled',
							'title' => __('Date color', 'mfn-opts'),
						),

						array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .blog_wrapper .post-item .date_label:--mfn-blog-date-bg',
							'type' => 'color',
							'class' => 'mfn-toggled',
							'title' => __('Date background', 'mfn-opts'),
						),

						array(
		  				'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .blog_wrapper .post-item .date_label:padding',
		  				'type' => 'dimensions',
		  				'version' => 'separated-fields',
		  				'title' => __('Padding', 'mfn-opts'),
							'responsive' => 'desktop',
							'class' => 'mfn_field_desktop mfn-toggled',
							'css_attr' => 'padding',
		  			),

		  			array(
		  				'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .blog_wrapper .post-item .date_label:padding_tablet',
		  				'type' => 'dimensions',
		  				'version' => 'separated-fields',
		  				'title' => __('Padding', 'mfn-opts'),
							'responsive' => 'tablet',
							'class' => 'mfn_field_tablet mfn-toggled',
							'css_attr' => 'padding',
		  			),

		  			array(
		  				'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .blog_wrapper .post-item .date_label:padding_mobile',
		  				'type' => 'dimensions',
		  				'version' => 'separated-fields',
		  				'title' => __('Padding', 'mfn-opts'),
							'responsive' => 'mobile',
							'class' => 'mfn_field_mobile mfn-toggled',
							'css_attr' => 'padding',
		  			),

		  			array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .blog_wrapper .post-item|before:border-color',
							'type' => 'color',
							'class' => 'mfn-toggled',
							'title' => __('Dot color', 'mfn-opts'),
						),

						array(
							'type' => 'html',
							'html' => '</div>',
						),

   				),
   			),

   			// Blog News ------------------------------------------------------

   			'blog_news' => array(
   				'type' => 'blog_news',
   				'title' => __('Blog News', 'mfn-opts'),
   				'size' => '1/4',
   				'tablet_size' => '1/4',
   				'mobile_size' => '1/1',
   				'tablet_resized' => '0',
   				'cat' => 'loops',
   				'fields' => array(

   					array(
							'type' => 'html',
							'html' => $this->itemtabs,
						),

   					array(
							'type' => 'html',
							'html' => '<div class="modalbox-card modalbox-re_render modalbox-card-content-mfnuidhere active">',
						),

   					array(
   						'id' => 'title',
   						'type' => 'text',
   						'edit_tag' => '.Latest_news | .title',
   						'edit_position' => 'prepend',
   						'title' => __('Title', 'mfn-opts'),
							'std' => __('This is the title', 'mfn-opts'),
							'preview' => 'title',
   					),

						array(
   						'id' => 'count',
   						'type' => 'text',
   						're_render' => 'standard',
   						'title' => __('Posts number', 'mfn-opts'),
   						'std' => '5',
							'after' => 'posts',
							'param' => 'number',
							'class' => 'narrow',
							'preview' => 'number',
   					),

   					array(
   						'id' => 'style',
   						'type' => 'switch',
   						're_render' => 'standard',
   						'title' => __('Style', 'mfn-opts'),
   						'options' => array(
   							'' => __('Default', 'mfn-opts'),
   							'featured' => __('Featured 1st', 'mfn-opts'),
   						),
							'preview' => 'style',
   					),

   					// options

   					array(
   						'title' => __('Options', 'mfn-opts'),
   					),

   					array(
   						'id' => 'category',
   						're_render' => 'standard',
   						'type' => 'select',
   						'title' => __('Category', 'mfn-opts'),
   						'options' => mfn_get_categories('category'),
   						'preview' => 'category',
   					),

   					array(
   						'id' => 'category_multi',
   						're_render' => 'standard',
   						'type' => 'text',
   						'title' => __('Multiple categories', 'mfn-opts'),
   						'desc' => __('Slugs should be separated with <b>coma</b> ( , )', 'mfn-opts'),
							'preview' => 'category-all',
   					),

   					array(
   						'id' => 'orderby',
   						'type' => 'switch',
   						're_render' => 'standard',
   						'title' => __('Order by', 'mfn-opts'),
   						'desc' => __('Do <b>not</b> use random order with pagination or load more', 'mfn-opts'),
   						'options' => array(
   							'date' => __('Date', 'mfn-opts'),
   							'title' => __('Title', 'mfn-opts'),
   							'rand' => __('Random', 'mfn-opts'),
   						),
   						'std' => 'date',
   					),

   					array(
   						'id' => 'order',
   						'type' => 'switch',
   						're_render' => 'standard',
   						'title' => __('Order', 'mfn-opts'),
   						'options' => array(
								'DESC' => __('Descending', 'mfn-opts'),
   							'ASC' => __('Ascending', 'mfn-opts'),
   						),
   						'std' => 'DESC',
   					),

   					// advanced

   					array(
   						'title' => __('Advanced', 'mfn-opts'),
   					),

   					array(
   						'id' => 'excerpt',
   						'type' => 'switch',
   						're_render' => 'standard',
   						'title' => __('Excerpt', 'mfn-opts'),
   						'options' => array(
   							0 => __('Hide', 'mfn-opts'),
   							1 => __('Show', 'mfn-opts'),
   							'featured' => __('Show for featured only', 'mfn-opts'),
   						),
							'std' => 0,
   					),

   					array(
   						'id' => 'link',
   						'type' => 'text',
   						're_render' => 'standard',
   						'title' => __('Button link', 'mfn-opts'),
   					),

   					array(
   						'id' => 'link_title',
   						'type' => 'text',
   						're_render' => 'standard',
   						'title' => __('Button title', 'mfn-opts'),
   					),

						// deprecated

						array(
							'class' => 'mfn-deprecated',
							'title' => __('Deprecated', 'mfn-opts'),
						),

						array(
							'id' => 'class',
							'type' => 'pills',
							'title' => __('Element classes', 'mfn-opts'),
							'class' => 'mfn-deprecated',
						),

   					array(
							'type' => 'html',
							'html' => '</div><div class="modalbox-card modalbox-card-style modalbox-re_render modalbox-card-style-mfnuidhere">',
						),

						array(
							'class' => 'toggled_header',
   						'title' => __('Item title', 'mfn-opts'),
   					),

   					array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .Latest_news .title:color',
							'type' => 'color',
							'class' => 'main-color mfn-toggled',
							'title' => __('Color', 'mfn-opts'),
						),

						array(
		  				'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .Latest_news .title:margin',
		  				'type' => 'dimensions',
		  				'version' => 'separated-fields',
		  				'title' => __('Margin', 'mfn-opts'),
							'responsive' => 'desktop',
							'class' => 'mfn_field_desktop mfn-toggled',
							'css_attr' => 'margin',
		  			),

		  			array(
		  				'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .Latest_news .title:margin_tablet',
		  				'type' => 'dimensions',
		  				'version' => 'separated-fields',
		  				'title' => __('Margin', 'mfn-opts'),
							'responsive' => 'tablet',
							'class' => 'mfn_field_tablet mfn-toggled',
							'css_attr' => 'margin',
		  			),

		  			array(
		  				'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .Latest_news .title:margin_mobile',
		  				'type' => 'dimensions',
		  				'version' => 'separated-fields',
		  				'title' => __('Margin', 'mfn-opts'),
							'responsive' => 'mobile',
							'class' => 'mfn_field_mobile mfn-toggled',
							'css_attr' => 'margin',
		  			),

		  			array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .Latest_news .title:typography',
							'type' => 'typography_vb',
							'label_after' => '<a href="#" title="Edit" class="mfn-option-btn mfn-option-blank btn-medium mfn-vb-label-button"><span class="mfn-icon mfn-icon-edit"></span></a>',
							'class' => 'mfn-toggled toggle_fields',
							'title' => __('Typography', 'mfn-opts'),
						),

						array(
							'class' => 'toggled_header',
   						'title' => __('Image', 'mfn-opts'),
   					),

		  			array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .Latest_news li .photo:border-style',
							'attr_id' => 'border_style',
							'type' => 'select',
							'class' => 'mfn-toggled',
							'title' => __('Border style', 'mfn-opts'),
							'options' => [
								'none' => __('None', 'mfn-opts'),
								'solid' => __('Solid', 'mfn-opts'),
								'dashed' => __('Dashed', 'mfn-opts'),
								'dotted' => __('Dotted', 'mfn-opts'),
								'double' => __('Double', 'mfn-opts'),
							],
						),

						array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .Latest_news li .photo:border-color',
							'condition' => array( 'id' => 'border_style', 'opt' => 'isnt', 'val' => 'none' ),
							'type' => 'color',
							'class' => 'mfn-toggled',
							'title' => __('Border color', 'mfn-opts'),
						),

						array(
		  				'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .Latest_news li .photo:border-width',
		  				'condition' => array( 'id' => 'border_style', 'opt' => 'isnt', 'val' => 'none' ),
		  				'type' => 'dimensions',
		  				'title' => __('Border width', 'mfn-opts'),
							'responsive' => 'desktop',
							'class' => 'mfn_field_desktop mfn-toggled',
							'css_attr' => 'border-width',
		  			),

		  			array(
		  				'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .Latest_news li .photo:border-width_tablet',
		  				'condition' => array( 'id' => 'border_style', 'opt' => 'isnt', 'val' => 'none' ),
		  				'type' => 'dimensions',
		  				'title' => __('Border width', 'mfn-opts'),
							'responsive' => 'tablet',
							'class' => 'mfn_field_tablet mfn-toggled',
							'css_attr' => 'border-width',
		  			),

		  			array(
		  				'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .Latest_news li .photo:border-width_mobile',
		  				'condition' => array( 'id' => 'border_style', 'opt' => 'isnt', 'val' => 'none' ),
		  				'type' => 'dimensions',
		  				'title' => __('Border width', 'mfn-opts'),
							'responsive' => 'mobile',
							'class' => 'mfn_field_mobile mfn-toggled',
							'css_attr' => 'border-width',
		  			),

						array(
		  				'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .Latest_news li .photo:border-radius',
		  				'type' => 'dimensions',
		  				'title' => __('Border radius', 'mfn-opts'),
							'responsive' => 'desktop',
							'class' => 'mfn_field_desktop mfn-toggled',
							'css_attr' => 'border-radius',
		  			),

		  			array(
		  				'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .Latest_news li .photo:border-radius_tablet',
		  				'type' => 'dimensions',
		  				'title' => __('Border radius', 'mfn-opts'),
							'responsive' => 'tablet',
							'class' => 'mfn_field_tablet mfn-toggled',
							'css_attr' => 'border-radius',
		  			),

		  			array(
		  				'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .Latest_news li .photo:border-radius_mobile',
		  				'type' => 'dimensions',
		  				'title' => __('Border radius', 'mfn-opts'),
							'responsive' => 'mobile',
							'class' => 'mfn_field_mobile mfn-toggled',
							'css_attr' => 'border-radius',
		  			),

		  			array(
							'class' => 'toggled_header',
   						'title' => __('Featured title', 'mfn-opts'),
   					),

   					array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .Latest_news.featured .desc h4 a:color',
							'type' => 'color',
							'class' => 'main-color mfn-toggled',
							'title' => __('Color', 'mfn-opts'),
						),

						array(
		  				'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .Latest_news.featured .desc h4:margin',
		  				'type' => 'dimensions',
		  				'version' => 'separated-fields',
		  				'title' => __('Margin', 'mfn-opts'),
							'responsive' => 'desktop',
							'class' => 'mfn_field_desktop mfn-toggled',
							'css_attr' => 'margin',
		  			),

		  			array(
		  				'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .Latest_news.featured .desc h4:margin_tablet',
		  				'type' => 'dimensions',
		  				'version' => 'separated-fields',
		  				'title' => __('Margin', 'mfn-opts'),
							'responsive' => 'tablet',
							'class' => 'mfn_field_tablet mfn-toggled',
							'css_attr' => 'margin',
		  			),

		  			array(
		  				'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .Latest_news.featured .desc h4:margin_mobile',
		  				'type' => 'dimensions',
		  				'version' => 'separated-fields',
		  				'title' => __('Margin', 'mfn-opts'),
							'responsive' => 'mobile',
							'class' => 'mfn_field_mobile mfn-toggled',
							'css_attr' => 'margin',
		  			),

		  			array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .Latest_news.featured .desc h4 a:typography',
							'type' => 'typography_vb',
							'label_after' => '<a href="#" title="Edit" class="mfn-option-btn mfn-option-blank btn-medium mfn-vb-label-button"><span class="mfn-icon mfn-icon-edit"></span></a>',
							'class' => 'mfn-toggled toggle_fields',
							'title' => __('Typography', 'mfn-opts'),
						),

						array(
							'class' => 'toggled_header',
   						'title' => __('Title', 'mfn-opts'),
   					),

   					array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .Latest_news .desc h5 a:color',
							'type' => 'color',
							'class' => 'main-color mfn-toggled',
							'title' => __('Color', 'mfn-opts'),
						),

						array(
		  				'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .Latest_news .desc h5:margin',
		  				'type' => 'dimensions',
		  				'version' => 'separated-fields',
		  				'title' => __('Margin', 'mfn-opts'),
							'responsive' => 'desktop',
							'class' => 'mfn_field_desktop mfn-toggled',
							'css_attr' => 'margin',
		  			),

		  			array(
		  				'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .Latest_news .desc h5:margin_tablet',
		  				'type' => 'dimensions',
		  				'version' => 'separated-fields',
		  				'title' => __('Margin', 'mfn-opts'),
							'responsive' => 'tablet',
							'class' => 'mfn_field_tablet mfn-toggled',
							'css_attr' => 'margin',
		  			),

		  			array(
		  				'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .Latest_news .desc h5:margin_mobile',
		  				'type' => 'dimensions',
		  				'version' => 'separated-fields',
		  				'title' => __('Margin', 'mfn-opts'),
							'responsive' => 'mobile',
							'class' => 'mfn_field_mobile mfn-toggled',
							'css_attr' => 'margin',
		  			),

		  			array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .Latest_news .desc h5 a:typography',
							'type' => 'typography_vb',
							'label_after' => '<a href="#" title="Edit" class="mfn-option-btn mfn-option-blank btn-medium mfn-vb-label-button"><span class="mfn-icon mfn-icon-edit"></span></a>',
							'class' => 'mfn-toggled toggle_fields',
							'title' => __('Typography', 'mfn-opts'),
						),

		  			array(
							'class' => 'toggled_header',
   						'title' => __('Excerpt', 'mfn-opts'),
   					),

   					array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .Latest_news .desc .post-excerpt:color',
							'type' => 'color',
							'class' => 'main-color mfn-toggled',
							'title' => __('Color', 'mfn-opts'),
						),

						array(
		  				'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .Latest_news .desc .post-excerpt:margin',
		  				'type' => 'dimensions',
		  				'version' => 'separated-fields',
		  				'title' => __('Margin', 'mfn-opts'),
							'responsive' => 'desktop',
							'class' => 'mfn_field_desktop mfn-toggled',
							'css_attr' => 'margin',
		  			),

		  			array(
		  				'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .Latest_news .desc .post-excerpt:margin_tablet',
		  				'type' => 'dimensions',
		  				'version' => 'separated-fields',
		  				'title' => __('Margin', 'mfn-opts'),
							'responsive' => 'tablet',
							'class' => 'mfn_field_tablet mfn-toggled',
							'css_attr' => 'margin',
		  			),

		  			array(
		  				'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .Latest_news .desc .post-excerpt:margin_mobile',
		  				'type' => 'dimensions',
		  				'version' => 'separated-fields',
		  				'title' => __('Margin', 'mfn-opts'),
							'responsive' => 'mobile',
							'class' => 'mfn_field_mobile mfn-toggled',
							'css_attr' => 'margin',
		  			),

		  			array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .Latest_news .desc .post-excerpt:typography',
							'type' => 'typography_vb',
							'label_after' => '<a href="#" title="Edit" class="mfn-option-btn mfn-option-blank btn-medium mfn-vb-label-button"><span class="mfn-icon mfn-icon-edit"></span></a>',
							'class' => 'mfn-toggled toggle_fields',
							'title' => __('Typography', 'mfn-opts'),
						),


		  			array(
							'class' => 'toggled_header',
   						'title' => __('Post footer', 'mfn-opts'),
   					),

   					array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .Latest_news ul li .desc_footer:background-color',
							'type' => 'color',
							'class' => 'mfn-toggled',
							'title' => __('Background', 'mfn-opts'),
						),

						array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .Latest_news ul li .desc_footer,.mcb-section .mcb-wrap .mcb-item-mfnuidelement .Latest_news ul li .desc_footer .button-love a .label:color',
							'type' => 'color',
							'class' => 'mfn-toggled',
							'title' => __('Color', 'mfn-opts'),
						),

						array(
		  				'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .Latest_news ul li .desc_footer:margin',
		  				'type' => 'dimensions',
		  				'version' => 'separated-fields',
		  				'title' => __('Margin', 'mfn-opts'),
							'responsive' => 'desktop',
							'class' => 'mfn_field_desktop mfn-toggled',
							'css_attr' => 'margin',
		  			),

		  			array(
		  				'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .Latest_news ul li .desc_footer:margin_tablet',
		  				'type' => 'dimensions',
		  				'version' => 'separated-fields',
		  				'title' => __('Margin', 'mfn-opts'),
							'responsive' => 'tablet',
							'class' => 'mfn_field_tablet mfn-toggled',
							'css_attr' => 'margin',
		  			),

		  			array(
		  				'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .Latest_news ul li .desc_footer:margin_mobile',
		  				'type' => 'dimensions',
		  				'version' => 'separated-fields',
		  				'title' => __('Margin', 'mfn-opts'),
							'responsive' => 'mobile',
							'class' => 'mfn_field_mobile mfn-toggled',
							'css_attr' => 'margin',
		  			),

						array(
		  				'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .Latest_news ul li .desc_footer:padding',
		  				'type' => 'dimensions',
		  				'version' => 'separated-fields',
		  				'title' => __('Padding', 'mfn-opts'),
							'responsive' => 'desktop',
							'class' => 'mfn_field_desktop mfn-toggled',
							'css_attr' => 'padding',
		  			),

		  			array(
		  				'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .Latest_news ul li .desc_footer:padding_tablet',
		  				'type' => 'dimensions',
		  				'version' => 'separated-fields',
		  				'title' => __('Padding', 'mfn-opts'),
							'responsive' => 'tablet',
							'class' => 'mfn_field_tablet mfn-toggled',
							'css_attr' => 'padding',
		  			),

		  			array(
		  				'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .Latest_news ul li .desc_footer:padding_mobile',
		  				'type' => 'dimensions',
		  				'version' => 'separated-fields',
		  				'title' => __('Padding', 'mfn-opts'),
							'responsive' => 'mobile',
							'class' => 'mfn_field_mobile mfn-toggled',
							'css_attr' => 'padding',
		  			),

		  			array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .Latest_news ul li .desc_footer:border-style',
							'attr_id' => 'border_style',
							'type' => 'select',
							'class' => 'mfn-toggled',
							'title' => __('Border style', 'mfn-opts'),
							'options' => [
								'none' => __('None', 'mfn-opts'),
								'solid' => __('Solid', 'mfn-opts'),
								'dashed' => __('Dashed', 'mfn-opts'),
								'dotted' => __('Dotted', 'mfn-opts'),
								'double' => __('Double', 'mfn-opts'),
							],
						),

						array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .Latest_news ul li .desc_footer:border-color',
							'condition' => array( 'id' => 'border_style', 'opt' => 'isnt', 'val' => 'none' ),
							'type' => 'color',
							'class' => 'mfn-toggled',
							'title' => __('Border color', 'mfn-opts'),
						),

						array(
		  				'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .Latest_news ul li .desc_footer:border-width',
		  				'condition' => array( 'id' => 'border_style', 'opt' => 'isnt', 'val' => 'none' ),
		  				'type' => 'dimensions',
		  				'title' => __('Border width', 'mfn-opts'),
							'responsive' => 'desktop',
							'class' => 'mfn_field_desktop mfn-toggled',
							'css_attr' => 'border-width',
		  			),

		  			array(
		  				'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .Latest_news ul li .desc_footer:border-width_tablet',
		  				'condition' => array( 'id' => 'border_style', 'opt' => 'isnt', 'val' => 'none' ),
		  				'type' => 'dimensions',
		  				'title' => __('Border width', 'mfn-opts'),
							'responsive' => 'tablet',
							'class' => 'mfn_field_tablet mfn-toggled',
							'css_attr' => 'border-width',
		  			),

		  			array(
		  				'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .Latest_news ul li .desc_footer:border-width_mobile',
		  				'condition' => array( 'id' => 'border_style', 'opt' => 'isnt', 'val' => 'none' ),
		  				'type' => 'dimensions',
		  				'title' => __('Border width', 'mfn-opts'),
							'responsive' => 'mobile',
							'class' => 'mfn_field_mobile mfn-toggled',
							'css_attr' => 'border-width',
		  			),

						array(
		  				'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .Latest_news ul li .desc_footer:border-radius',
		  				'type' => 'dimensions',
		  				'title' => __('Border radius', 'mfn-opts'),
							'responsive' => 'desktop',
							'class' => 'mfn_field_desktop mfn-toggled',
							'css_attr' => 'border-radius',
		  			),

		  			array(
		  				'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .Latest_news ul li .desc_footer:border-radius_tablet',
		  				'type' => 'dimensions',
		  				'title' => __('Border radius', 'mfn-opts'),
							'responsive' => 'tablet',
							'class' => 'mfn_field_tablet mfn-toggled',
							'css_attr' => 'border-radius',
		  			),

		  			array(
		  				'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .Latest_news ul li .desc_footer:border-radius_mobile',
		  				'type' => 'dimensions',
		  				'title' => __('Border radius', 'mfn-opts'),
							'responsive' => 'mobile',
							'class' => 'mfn_field_mobile mfn-toggled',
							'css_attr' => 'border-radius',
		  			),

		  			array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .Latest_news ul li .desc_footer:typography',
							'type' => 'typography_vb',
							'label_after' => '<a href="#" title="Edit" class="mfn-option-btn mfn-option-blank btn-medium mfn-vb-label-button"><span class="mfn-icon mfn-icon-edit"></span></a>',
							'class' => 'mfn-toggled toggle_fields',
							'title' => __('Typography', 'mfn-opts'),
						),

		  			array(
							'type' => 'html',
							'html' => '<div class="mfn-form-row mfn-sidebar-fields-tabs mfn-toggled mfn-vb-formrow mfn-vb-mfnuidhere"><ul class="mfn-sft-nav"><li class="active"><a href="#normal" data-tab="normal">Normal</a></li><li><a href="#hover" data-tab="hover">Hover</a></li></ul><div class="mfn-sft mfn-sft-normal">',
						),

						array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .Latest_news ul li .desc_footer a:color',
							'type' => 'color',
							'title' => __('Link color', 'mfn-opts'),
						),

						array(
							'type' => 'html',
							'html' => '</div><div class="mfn-sft mfn-sft-hover">',
						),

						array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .Latest_news ul li .desc_footer a|hover:color',
							'type' => 'color',
							'title' => __('Link color', 'mfn-opts'),
						),

						array(
							'type' => 'html',
							'html' => '</div></div>',
						),

						array(
							'type' => 'html',
							'html' => '</div>',
						),

   				),
   			),

   			// Blog Slider ----------------------------------------------------

   			'blog_slider' => array(
   				'type' => 'blog_slider',
   				'title' => __('Blog Slider', 'mfn-opts'),
   				'size' => '1/1',
   				'tablet_size' => '1/1',
   				'mobile_size' => '1/1',
   				'tablet_resized' => '0',
   				'cat' => 'loops',
   				'fields' => array(

   					array(
							'type' => 'html',
							'html' => $this->itemtabs,
						),

   					array(
							'type' => 'html',
							'html' => '<div class="modalbox-card modalbox-re_render modalbox-card-content-mfnuidhere active">',
						),

						array(
   						'id' => 'style',
   						'attr_id' => 'blog_slider_style',
   						'type' => 'switch',
   						're_render' => 'standard',
   						'title' => __('Style', 'mfn-opts'),
   						'options' => array(
   							'' => __('Default', 'mfn-opts'),
   							'flat' => __('Flat', 'mfn-opts'),
   						),
							'std' => '',
   					),

   					array(
   						'id' => 'title',
   						'condition' => array( 'id' => 'blog_slider_style', 'opt' => 'is', 'val' => '' ),
   						'type' => 'text',
   						'title' => __('Title', 'mfn-opts'),
   						'edit_tag' => '.blog_slider_header | h4.title',
   						'edit_class' => 'title',
   						'edit_position' => 'prepend',
							'std' => __('This is the title', 'mfn-opts'),
							'preview' => 'title',
   					),

						array(
   						'id' => 'count',
   						'type' => 'text',
   						're_render' => 'standard',
   						'title' => __('Posts number', 'mfn-opts'),
   						'std' => '5',
							'after' => 'posts',
							'param' => 'number',
							'class' => 'narrow',
							'preview' => 'number',
   					),

						// options

   					array(
   						'title' => __('Options', 'mfn-opts'),
   					),

   					array(
   						'id' => 'category',
   						'type' => 'select',
   						're_render' => 'standard',
   						'title' => __('Category', 'mfn-opts'),
   						'options' => mfn_get_categories('category'),
							'preview' => 'category',
   					),

   					array(
   						'id' => 'category_multi',
   						'type' => 'text',
   						're_render' => 'standard',
   						'title' => __('Multiple categories', 'mfn-opts'),
   						'desc' => __('Slugs should be separated with <b>coma</b> ( , )', 'mfn-opts'),
							'preview' => 'category-all',
   					),

   					array(
   						'id' => 'orderby',
   						'type' => 'switch',
   						're_render' => 'standard',
   						'title' => __('Order by', 'mfn-opts'),
   						'desc' => __('Do <b>not</b> use random order with pagination or load more', 'mfn-opts'),
   						'options' => array(
   							'date' => __('Date', 'mfn-opts'),
   							'title' => __('Title', 'mfn-opts'),
   							'rand' => __('Random', 'mfn-opts'),
   						),
   						'std' => 'date',
   					),

   					array(
   						'id' => 'order',
   						'type' => 'switch',
   						're_render' => 'standard',
   						'title' => __('Order', 'mfn-opts'),
   						'options' => array(
								'DESC' => __('Descending', 'mfn-opts'),
   							'ASC' => __('Ascending', 'mfn-opts'),

   						),
   						'std' => 'DESC'
   					),

						// advanced

   					array(
   						'title' => __('Advanced', 'mfn-opts'),
   					),

   					array(
   						'id' => 'more',
   						'condition' => array( 'id' => 'blog_slider_style', 'opt' => 'is', 'val' => '' ),
   						'type' => 'switch',
   						're_render' => 'standard',
   						'title' => __('Read more', 'mfn-opts'),
   						'options' => array(
   							0 => __('Hide', 'mfn-opts'),
   							1 => __('Show', 'mfn-opts'),
   						),
   						'std' => 1,
   					),

   					array(
   						'id' => 'navigation',
   						'condition' => array( 'id' => 'blog_slider_style', 'opt' => 'is', 'val' => '' ),
   						'type' => 'switch',
   						're_render' => 'standard',
   						'title' => __('Navigation', 'mfn-opts'),
   						'options' => array(
   							'' => __('Default', 'mfn-opts'),
   							'hide-arrows' => __('Hide arrows', 'mfn-opts'),
   							'hide-dots' => __('Hide dots', 'mfn-opts'),
   							'hide-nav' => __('Hide nav', 'mfn-opts'),
   						),
							'std' => '',
   					),

						// deprecated

						array(
							'class' => 'mfn-deprecated',
							'title' => __('Deprecated', 'mfn-opts'),
						),

						array(
							'id' => 'class',
							'type' => 'pills',
							'title' => __('Element classes', 'mfn-opts'),
							'class' => 'mfn-deprecated',
						),

   					array(
							'type' => 'html',
							'html' => '</div><div class="modalbox-card modalbox-card-style modalbox-re_render modalbox-card-style-mfnuidhere">',
						),

						array(
							'class' => 'toggled_header',
   						'title' => __('Item title', 'mfn-opts'),
   					),

   					array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .blog_slider_header h4.title:color',
							'type' => 'color',
							'class' => 'main-color mfn-toggled',
							'title' => __('Color', 'mfn-opts'),
						),

						array(
		  				'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .blog_slider_header h4.title:margin',
		  				'type' => 'dimensions',
		  				'version' => 'separated-fields',
		  				'title' => __('Margin', 'mfn-opts'),
							'responsive' => 'desktop',
							'class' => 'mfn_field_desktop mfn-toggled',
							'css_attr' => 'margin',
		  			),

		  			array(
		  				'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .blog_slider_header h4.title:margin_tablet',
		  				'type' => 'dimensions',
		  				'version' => 'separated-fields',
		  				'title' => __('Margin', 'mfn-opts'),
							'responsive' => 'tablet',
							'class' => 'mfn_field_tablet mfn-toggled',
							'css_attr' => 'margin',
		  			),

		  			array(
		  				'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .blog_slider_header h4.title:margin_mobile',
		  				'type' => 'dimensions',
		  				'version' => 'separated-fields',
		  				'title' => __('Margin', 'mfn-opts'),
							'responsive' => 'mobile',
							'class' => 'mfn_field_mobile mfn-toggled',
							'css_attr' => 'margin',
		  			),

		  			array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .blog_slider_header h4.title:typography',
							'type' => 'typography_vb',
							'label_after' => '<a href="#" title="Edit" class="mfn-option-btn mfn-option-blank btn-medium mfn-vb-label-button"><span class="mfn-icon mfn-icon-edit"></span></a>',
							'class' => 'mfn-toggled toggle_fields',
							'title' => __('Typography', 'mfn-opts'),
						),

						array(
							'class' => 'toggled_header',
   						'title' => __('Image', 'mfn-opts'),
   					),

		  			array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .blog_slider_ul li .item_wrapper .image_frame:border-style',
							'attr_id' => 'border_style',
							'type' => 'select',
							'class' => 'mfn-toggled',
							'title' => __('Border style', 'mfn-opts'),
							'options' => [
								'none' => __('None', 'mfn-opts'),
								'solid' => __('Solid', 'mfn-opts'),
								'dashed' => __('Dashed', 'mfn-opts'),
								'dotted' => __('Dotted', 'mfn-opts'),
								'double' => __('Double', 'mfn-opts'),
							],
						),

						array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .blog_slider_ul li .item_wrapper .image_frame:border-color',
							'condition' => array( 'id' => 'border_style', 'opt' => 'isnt', 'val' => 'none' ),
							'type' => 'color',
							'class' => 'mfn-toggled',
							'title' => __('Border color', 'mfn-opts'),
						),

						array(
		  				'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .blog_slider_ul li .item_wrapper .image_frame:border-width',
		  				'condition' => array( 'id' => 'border_style', 'opt' => 'isnt', 'val' => 'none' ),
		  				'type' => 'dimensions',
		  				'title' => __('Border width', 'mfn-opts'),
							'responsive' => 'desktop',
							'class' => 'mfn_field_desktop mfn-toggled',
							'css_attr' => 'border-width',
		  			),

		  			array(
		  				'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .blog_slider_ul li .item_wrapper .image_frame:border-width_tablet',
		  				'condition' => array( 'id' => 'border_style', 'opt' => 'isnt', 'val' => 'none' ),
		  				'type' => 'dimensions',
		  				'title' => __('Border width', 'mfn-opts'),
							'responsive' => 'tablet',
							'class' => 'mfn_field_tablet mfn-toggled',
							'css_attr' => 'border-width',
		  			),

		  			array(
		  				'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .blog_slider_ul li .item_wrapper .image_frame:border-width_mobile',
		  				'condition' => array( 'id' => 'border_style', 'opt' => 'isnt', 'val' => 'none' ),
		  				'type' => 'dimensions',
		  				'title' => __('Border width', 'mfn-opts'),
							'responsive' => 'mobile',
							'class' => 'mfn_field_mobile mfn-toggled',
							'css_attr' => 'border-width',
		  			),

						array(
		  				'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .blog_slider_ul li .item_wrapper .image_frame:border-radius',
		  				'type' => 'dimensions',
		  				'title' => __('Border radius', 'mfn-opts'),
							'responsive' => 'desktop',
							'class' => 'mfn_field_desktop mfn-toggled',
							'css_attr' => 'border-radius',
		  			),

		  			array(
		  				'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .blog_slider_ul li .item_wrapper .image_frame:border-radius_tablet',
		  				'type' => 'dimensions',
		  				'title' => __('Border radius', 'mfn-opts'),
							'responsive' => 'tablet',
							'class' => 'mfn_field_tablet mfn-toggled',
							'css_attr' => 'border-radius',
		  			),

		  			array(
		  				'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .blog_slider_ul li .item_wrapper .image_frame:border-radius_mobile',
		  				'type' => 'dimensions',
		  				'title' => __('Border radius', 'mfn-opts'),
							'responsive' => 'mobile',
							'class' => 'mfn_field_mobile mfn-toggled',
							'css_attr' => 'border-radius',
		  			),

		  			array(
		  				'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .blog_slider_ul li .item_wrapper .image_frame:margin',
		  				'type' => 'dimensions',
		  				'title' => __('Margin', 'mfn-opts'),
		  				'version' => 'separated-fields',
							'responsive' => 'desktop',
							'class' => 'mfn_field_desktop mfn-toggled',
							'css_attr' => 'margin',
		  			),

		  			array(
		  				'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .blog_slider_ul li .item_wrapper .image_frame:margin_tablet',
		  				'type' => 'dimensions',
		  				'title' => __('Margin', 'mfn-opts'),
		  				'version' => 'separated-fields',
							'responsive' => 'tablet',
							'class' => 'mfn_field_tablet mfn-toggled',
							'css_attr' => 'margin',
		  			),

		  			array(
		  				'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .blog_slider_ul li .item_wrapper .image_frame:margin_mobile',
		  				'type' => 'dimensions',
		  				'title' => __('Margin', 'mfn-opts'),
		  				'version' => 'separated-fields',
							'responsive' => 'mobile',
							'class' => 'mfn_field_mobile mfn-toggled',
							'css_attr' => 'margin',
		  			),

		  			array(
							'class' => 'toggled_header',
   						'title' => __('Title', 'mfn-opts'),
   					),

		  			array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .blog_slider_ul li .desc h4 a:color',
							'type' => 'color',
							'class' => 'main-color mfn-toggled',
							'title' => __('Color', 'mfn-opts'),
						),

						array(
		  				'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .blog_slider_ul li .desc h4:margin',
		  				'type' => 'dimensions',
		  				'version' => 'separated-fields',
		  				'title' => __('Margin', 'mfn-opts'),
							'responsive' => 'desktop',
							'class' => 'mfn_field_desktop mfn-toggled',
							'css_attr' => 'margin',
		  			),

		  			array(
		  				'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .blog_slider_ul li .desc h4:margin_tablet',
		  				'type' => 'dimensions',
		  				'version' => 'separated-fields',
		  				'title' => __('Margin', 'mfn-opts'),
							'responsive' => 'tablet',
							'class' => 'mfn_field_tablet mfn-toggled',
							'css_attr' => 'margin',
		  			),

		  			array(
		  				'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .blog_slider_ul li .desc h4:margin_mobile',
		  				'type' => 'dimensions',
		  				'version' => 'separated-fields',
		  				'title' => __('Margin', 'mfn-opts'),
							'responsive' => 'mobile',
							'class' => 'mfn_field_mobile mfn-toggled',
							'css_attr' => 'margin',
		  			),

		  			array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .blog_slider_ul li .desc h4:typography',
							'type' => 'typography_vb',
							'label_after' => '<a href="#" title="Edit" class="mfn-option-btn mfn-option-blank btn-medium mfn-vb-label-button"><span class="mfn-icon mfn-icon-edit"></span></a>',
							'class' => 'mfn-toggled toggle_fields',
							'title' => __('Typography', 'mfn-opts'),
						),

						array(
							'class' => 'toggled_header',
   						'title' => __('Button', 'mfn-opts'),
   					),

		  			array(
		  				'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .blog_slider .button:padding',
		  				'type' => 'dimensions',
		  				'version' => 'separated-fields',
		  				'title' => __('Padding', 'mfn-opts'),
							'responsive' => 'desktop',
							'class' => 'mfn_field_desktop mfn-toggled',
							'css_attr' => 'padding',
		  			),

		  			array(
		  				'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .blog_slider .button:padding_tablet',
		  				'type' => 'dimensions',
		  				'version' => 'separated-fields',
		  				'title' => __('Padding', 'mfn-opts'),
							'responsive' => 'tablet',
							'class' => 'mfn_field_tablet mfn-toggled',
							'css_attr' => 'padding',
		  			),

		  			array(
		  				'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .blog_slider .button:padding_mobile',
		  				'type' => 'dimensions',
		  				'version' => 'separated-fields',
		  				'title' => __('Padding', 'mfn-opts'),
							'responsive' => 'mobile',
							'class' => 'mfn_field_mobile mfn-toggled',
							'css_attr' => 'padding',
		  			),

		  			array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .blog_slider .button:typography',
							'type' => 'typography_vb',
							'label_after' => '<a href="#" title="Edit" class="mfn-option-btn mfn-option-blank btn-medium mfn-vb-label-button"><span class="mfn-icon mfn-icon-edit"></span></a>',
							'class' => 'mfn-toggled toggle_fields',
							'title' => __('Typography', 'mfn-opts'),
						),

						array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .blog_slider .button:border-style',
							'attr_id' => 'border_style',
							'type' => 'select',
							'class' => 'mfn-toggled',
							'title' => __('Border style', 'mfn-opts'),
							'options' => [
								'none' => __('None', 'mfn-opts'),
								'solid' => __('Solid', 'mfn-opts'),
								'dashed' => __('Dashed', 'mfn-opts'),
								'dotted' => __('Dotted', 'mfn-opts'),
								'double' => __('Double', 'mfn-opts'),
							],
						),

						array(
		  				'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .blog_slider .button:border-width',
		  				'condition' => array( 'id' => 'border_style', 'opt' => 'isnt', 'val' => 'none' ),
		  				'type' => 'dimensions',
		  				'title' => __('Border width', 'mfn-opts'),
							'responsive' => 'desktop',
							'class' => 'mfn_field_desktop mfn-toggled',
							'css_attr' => 'border-width',
		  			),

		  			array(
		  				'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .blog_slider .button:border-width_tablet',
		  				'condition' => array( 'id' => 'border_style', 'opt' => 'isnt', 'val' => 'none' ),
		  				'type' => 'dimensions',
		  				'title' => __('Border width', 'mfn-opts'),
							'responsive' => 'tablet',
							'class' => 'mfn_field_tablet mfn-toggled',
							'css_attr' => 'border-width',
		  			),

		  			array(
		  				'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .blog_slider .button:border-width_mobile',
		  				'condition' => array( 'id' => 'border_style', 'opt' => 'isnt', 'val' => 'none' ),
		  				'type' => 'dimensions',
		  				'title' => __('Border width', 'mfn-opts'),
							'responsive' => 'mobile',
							'class' => 'mfn_field_mobile mfn-toggled',
							'css_attr' => 'border-width',
		  			),

						array(
		  				'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .blog_slider .button:border-radius',
		  				'type' => 'dimensions',
		  				'title' => __('Border radius', 'mfn-opts'),
							'responsive' => 'desktop',
							'class' => 'mfn_field_desktop mfn-toggled',
							'css_attr' => 'border-radius',
		  			),

		  			array(
		  				'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .blog_slider .button:border-radius_tablet',
		  				'type' => 'dimensions',
		  				'title' => __('Border radius', 'mfn-opts'),
							'responsive' => 'tablet',
							'class' => 'mfn_field_tablet mfn-toggled',
							'css_attr' => 'border-radius',
		  			),

		  			array(
		  				'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .blog_slider .button:border-radius_mobile',
		  				'type' => 'dimensions',
		  				'title' => __('Border radius', 'mfn-opts'),
							'responsive' => 'mobile',
							'class' => 'mfn_field_mobile mfn-toggled',
							'css_attr' => 'border-radius',
		  			),

   					array(
							'type' => 'html',
							'html' => '<div class="mfn-form-row mfn-sidebar-fields-tabs mfn-toggled mfn-vb-formrow mfn-vb-mfnuidhere"><ul class="mfn-sft-nav"><li class="active"><a href="#normal" data-tab="normal">Normal</a></li><li><a href="#hover" data-tab="hover">Hover</a></li></ul><div class="mfn-sft mfn-sft-normal">',
						),

						array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .blog_slider .button:color',
							'type' => 'color',
							'class' => 'main-color mfn-toggled',
							'title' => __('Color', 'mfn-opts'),
						),

						array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .blog_slider .button:border-color',
							'condition' => array( 'id' => 'border_style', 'opt' => 'isnt', 'val' => 'none' ),
							'type' => 'color',
							'class' => 'mfn-toggled',
							'title' => __('Border color', 'mfn-opts'),
						),

						array(
							'id' => 'background_switcher',
							'attr_id' => 'background_switcher',
							'type' => 'switch',
							'class' => 'mfn-fields-switcher',
							'title' => __('Background type', 'mfn-opts'),
							'options' => array(
		  					'default' => __('Default', 'mfn-opts'),
		  					'gradient' 	=> __('Gradient', 'mfn-opts'),
		  				),
							'visual_options' => array(
		  					'default' => '',
		  					'gradient' 	=> '',
		  				),
		  				'std' => 'default',
						),

						array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .blog_slider .button:background-color',
							'condition' => array( 'id' => 'background_switcher', 'opt' => 'is', 'val' => 'default' ),
							'type' => 'color',
							'title' => __('Background color', 'mfn-opts'),
						),

						array(
		  				'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .blog_slider .button:gradient',
		  				'condition' => array( 'id' => 'background_switcher', 'opt' => 'is', 'val' => 'gradient' ),
		  				'type' => 'gradient',
		  				'title' => __('Gradient', 'mfn-opts'),
		  				'class' => 'mfn-toggled',
							'css_attr' => 'gradient',
		  			),

						array(
							'type' => 'html',
							'html' => '</div><div class="mfn-sft mfn-sft-hover">',
						),

						array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .blog_slider .button|hover:color',
							'type' => 'color',
							'class' => 'main-color mfn-toggled',
							'title' => __('Color', 'mfn-opts'),
						),

						array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .blog_slider .button|hover:border-color',
							'condition' => array( 'id' => 'border_style', 'opt' => 'isnt', 'val' => 'none' ),
							'type' => 'color',
							'class' => 'mfn-toggled',
							'title' => __('Border color', 'mfn-opts'),
						),

						array(
							'id' => 'background_switcher_hover',
							'attr_id' => 'background_switcher_hover',
							'type' => 'switch',
							'class' => 'mfn-fields-switcher',
							'title' => __('Background type', 'mfn-opts'),
							'options' => array(
		  					'default' => __('Default', 'mfn-opts'),
		  					'gradient' 	=> __('Gradient', 'mfn-opts'),
		  				),
							'visual_options' => array(
		  					'default' => '',
		  					'gradient' 	=> '',
		  				),
		  				'std' => 'default',
						),

						array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .blog_slider .button|hover:background',
							'condition' => array( 'id' => 'background_switcher_hover', 'opt' => 'is', 'val' => 'default' ),
							'type' => 'color',
							'class' => 'main-color mfn-toggled',
							'title' => __('Background color', 'mfn-opts'),
						),

						array(
		  				'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .blog_slider .button|hover:gradient',
		  				'condition' => array( 'id' => 'background_switcher_hover', 'opt' => 'is', 'val' => 'gradient' ),
		  				'type' => 'gradient',
		  				'title' => __('Gradient', 'mfn-opts'),
		  				'class' => 'mfn-toggled',
							'css_attr' => 'gradient',
		  			),

						array(
							'type' => 'html',
							'html' => '</div></div>',
						),

						array(
							'class' => 'toggled_header',
   						'title' => __('Date', 'mfn-opts'),
   					),

   					array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .blog_slider_ul li .item_wrapper:--mfn-blog-slider-date-bg',
							'type' => 'color',
							'class' => 'main-color mfn-toggled',
							'title' => __('Background', 'mfn-opts'),
						),

						array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .blog_slider_ul li .date_label:color',
							'type' => 'color',
							'class' => 'main-color mfn-toggled',
							'title' => __('Color', 'mfn-opts'),
						),

						array(
		  				'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .blog_slider_ul li .date_label:margin',
		  				'type' => 'dimensions',
		  				'version' => 'separated-fields',
		  				'title' => __('Margin', 'mfn-opts'),
							'responsive' => 'desktop',
							'class' => 'mfn_field_desktop mfn-toggled',
							'css_attr' => 'margin',
		  			),

		  			array(
		  				'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .blog_slider_ul li .date_label:margin_tablet',
		  				'type' => 'dimensions',
		  				'version' => 'separated-fields',
		  				'title' => __('Margin', 'mfn-opts'),
							'responsive' => 'tablet',
							'class' => 'mfn_field_tablet mfn-toggled',
							'css_attr' => 'margin',
		  			),

		  			array(
		  				'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .blog_slider_ul li .date_label:margin_mobile',
		  				'type' => 'dimensions',
		  				'version' => 'separated-fields',
		  				'title' => __('Margin', 'mfn-opts'),
							'responsive' => 'mobile',
							'class' => 'mfn_field_mobile mfn-toggled',
							'css_attr' => 'margin',
		  			),

		  			array(
		  				'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .blog_slider_ul li .date_label:padding',
		  				'type' => 'dimensions',
		  				'version' => 'separated-fields',
		  				'title' => __('Padding', 'mfn-opts'),
							'responsive' => 'desktop',
							'class' => 'mfn_field_desktop mfn-toggled',
							'css_attr' => 'padding',
		  			),

		  			array(
		  				'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .blog_slider_ul li .date_label:padding_tablet',
		  				'type' => 'dimensions',
		  				'version' => 'separated-fields',
		  				'title' => __('Padding', 'mfn-opts'),
							'responsive' => 'tablet',
							'class' => 'mfn_field_tablet mfn-toggled',
							'css_attr' => 'padding',
		  			),

		  			array(
		  				'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .blog_slider_ul li .date_label:padding_mobile',
		  				'type' => 'dimensions',
		  				'version' => 'separated-fields',
		  				'title' => __('Padding', 'mfn-opts'),
							'responsive' => 'mobile',
							'class' => 'mfn_field_mobile mfn-toggled',
							'css_attr' => 'padding',
		  			),

		  			array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .blog_slider_ul li .date_label:typography',
							'type' => 'typography_vb',
							'label_after' => '<a href="#" title="Edit" class="mfn-option-btn mfn-option-blank btn-medium mfn-vb-label-button"><span class="mfn-icon mfn-icon-edit"></span></a>',
							'class' => 'mfn-toggled toggle_fields',
							'title' => __('Typography', 'mfn-opts'),
						),

						array(
							'class' => 'toggled_header',
   						'title' => __('Line', 'mfn-opts'),
   					),

   					array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .blog_slider_ul li .desc hr:background',
							'type' => 'color',
							'class' => 'main-color mfn-toggled',
							'title' => __('Color', 'mfn-opts'),
						),

   					array(
							'type' => 'html',
							'html' => '</div>',
						),

						// advanced here

   				),
   			),

   			// Blog Teaser ------------------------------------------------------

   			'blog_teaser' => array(
   				'type' => 'blog_teaser',
   				'title' => __('Blog Teaser', 'mfn-opts'),
   				'size' => '1/1',
   				'tablet_size' => '1/1',
   				'mobile_size' => '1/1',
   				'tablet_resized' => '0',
   				'cat' => 'loops',
   				'fields' => array(

   					array(
							'type' => 'html',
							'html' => $this->itemtabs,
						),

   					array(
							'type' => 'html',
							'html' => '<div class="modalbox-card modalbox-re_render modalbox-card-content-mfnuidhere active">',
						),

   					array(
   						'id' => 'title',
   						'type' => 'text',
   						'edit_tag' => '.blog-teaser | .title',
   						'edit_position' => 'prepend',
   						'title' => __('Title', 'mfn-opts'),
							'std' => __('This is the title', 'mfn-opts'),
							'preview' => 'title',
   					),

   					array(
   						'id' => 'title_tag',
   						'type' => 'switch',
   						're_render' => 'standard',
   						'title' => __('Title tag', 'mfn-opts'),
   						'desc' => __('Title tag for 1st item, others use a smaller one', 'mfn-opts'),
   						'options' => array(
   							'h1' => 'H1',
   							'h2' => 'H2',
   							'h3' => 'H3',
   							'h4' => 'H4',
   							'h5' => 'H5',
   							'h6' => 'H6',
   						),
   						'std' => 'h3'
   					),

   					// options

   					array(
   						'title' => __('Options', 'mfn-opts'),
   					),

   					array(
   						'id' => 'category',
   						'type' => 'select',
   						're_render' => 'standard',
   						'title' => __('Category', 'mfn-opts'),
   						'options' => mfn_get_categories('category'),
							'preview' => 'category',
   					),

   					array(
   						'id' => 'category_multi',
   						'type' => 'text',
   						're_render' => 'standard',
   						'title' => __('Multiple categories', 'mfn-opts'),
   						'desc' => __('Slugs should be separated with <b>coma</b> ( , )', 'mfn-opts'),
							'preview' => 'category-all',
   					),

   					array(
   						'id' => 'orderby',
   						're_render' => 'standard',
   						'type' => 'switch',
   						'title' => __('Order by', 'mfn-opts'),
   						'desc' => __('Do <b>not</b> use random order with pagination or load more', 'mfn-opts'),
   						'options' => array(
   							'date' => __('Date', 'mfn-opts'),
   							'title' => __('Title', 'mfn-opts'),
   							'rand' => __('Random', 'mfn-opts'),
   						),
   						'std' => 'date'
   					),

   					array(
   						'id' => 'order',
   						're_render' => 'standard',
   						'type' => 'switch',
   						'title' => __('Order', 'mfn-opts'),
   						'options' => array(
								'DESC' => __('Descending', 'mfn-opts'),
   							'ASC' => __('Ascending', 'mfn-opts'),

   						),
   						'std' => 'DESC'
   					),

   					// advanced

   					array(
   						'title' => __('Advanced', 'mfn-opts'),
   					),

   					array(
   						'id' => 'margin',
   						'type' => 'switch',
   						're_render' => 'standard',
   						'title' => __('Margin', 'mfn-opts'),
   						'options' => array(
								'0' => __('Disable', 'mfn-opts'),
   							'1' => __('Enable', 'mfn-opts'),
   						),
							'std' => '0'
   					),

						// deprecated

						array(
							'class' => 'mfn-deprecated',
							'title' => __('Deprecated', 'mfn-opts'),
						),

						array(
							'id' => 'class',
							'type' => 'pills',
							'title' => __('Element classes', 'mfn-opts'),
							'class' => 'mfn-deprecated',
						),

   					array(
							'type' => 'html',
							'html' => '</div><div class="modalbox-card modalbox-card-style modalbox-re_render modalbox-card-style-mfnuidhere">',
						),

						array(
							'class' => 'toggled_header',
   						'title' => __('Item title', 'mfn-opts'),
   					),

		  			array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .blog-teaser .title:color',
							'type' => 'color',
							'class' => 'main-color mfn-toggled',
							'title' => __('Color', 'mfn-opts'),
						),

						array(
		  				'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .blog-teaser .title:margin',
		  				'type' => 'dimensions',
		  				'version' => 'separated-fields',
		  				'title' => __('Margin', 'mfn-opts'),
							'responsive' => 'desktop',
							'class' => 'mfn_field_desktop mfn-toggled',
							'css_attr' => 'margin',
		  			),

		  			array(
		  				'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .blog-teaser .title:margin_tablet',
		  				'type' => 'dimensions',
		  				'version' => 'separated-fields',
		  				'title' => __('Margin', 'mfn-opts'),
							'responsive' => 'tablet',
							'class' => 'mfn_field_tablet mfn-toggled',
							'css_attr' => 'margin',
		  			),

		  			array(
		  				'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .blog-teaser .title:margin_mobile',
		  				'type' => 'dimensions',
		  				'version' => 'separated-fields',
		  				'title' => __('Margin', 'mfn-opts'),
							'responsive' => 'mobile',
							'class' => 'mfn_field_mobile mfn-toggled',
							'css_attr' => 'margin',
		  			),

		  			array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .blog-teaser .title:typography',
							'type' => 'typography_vb',
							'label_after' => '<a href="#" title="Edit" class="mfn-option-btn mfn-option-blank btn-medium mfn-vb-label-button"><span class="mfn-icon mfn-icon-edit"></span></a>',
							'class' => 'mfn-toggled toggle_fields',
							'title' => __('Typography', 'mfn-opts'),
						),

						array(
							'class' => 'toggled_header',
   						'title' => __('Image', 'mfn-opts'),
   					),

		  			array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .teaser-wrapper li:border-style',
							'attr_id' => 'border_style',
							'type' => 'select',
							'class' => 'mfn-toggled',
							'title' => __('Border style', 'mfn-opts'),
							'options' => [
								'none' => __('None', 'mfn-opts'),
								'solid' => __('Solid', 'mfn-opts'),
								'dashed' => __('Dashed', 'mfn-opts'),
								'dotted' => __('Dotted', 'mfn-opts'),
								'double' => __('Double', 'mfn-opts'),
							],
						),

						array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .teaser-wrapper li:border-color',
							'condition' => array( 'id' => 'border_style', 'opt' => 'isnt', 'val' => 'none' ),
							'type' => 'color',
							'class' => 'mfn-toggled',
							'title' => __('Border color', 'mfn-opts'),
						),

						array(
		  				'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .teaser-wrapper li:border-width',
		  				'condition' => array( 'id' => 'border_style', 'opt' => 'isnt', 'val' => 'none' ),
		  				'type' => 'dimensions',
		  				'title' => __('Border width', 'mfn-opts'),
							'responsive' => 'desktop',
							'class' => 'mfn_field_desktop mfn-toggled',
							'css_attr' => 'border-width',
		  			),

		  			array(
		  				'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .teaser-wrapper li:border-width_tablet',
		  				'condition' => array( 'id' => 'border_style', 'opt' => 'isnt', 'val' => 'none' ),
		  				'type' => 'dimensions',
		  				'title' => __('Border width', 'mfn-opts'),
							'responsive' => 'tablet',
							'class' => 'mfn_field_tablet mfn-toggled',
							'css_attr' => 'border-width',
		  			),

		  			array(
		  				'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .teaser-wrapper li:border-width_mobile',
		  				'condition' => array( 'id' => 'border_style', 'opt' => 'isnt', 'val' => 'none' ),
		  				'type' => 'dimensions',
		  				'title' => __('Border width', 'mfn-opts'),
							'responsive' => 'mobile',
							'class' => 'mfn_field_mobile mfn-toggled',
							'css_attr' => 'border-width',
		  			),

						array(
		  				'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .teaser-wrapper li:border-radius',
		  				'type' => 'dimensions',
		  				'title' => __('Border radius', 'mfn-opts'),
							'responsive' => 'desktop',
							'class' => 'mfn_field_desktop mfn-toggled',
							'css_attr' => 'border-radius',
		  			),

		  			array(
		  				'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .teaser-wrapper li:border-radius_tablet',
		  				'type' => 'dimensions',
		  				'title' => __('Border radius', 'mfn-opts'),
							'responsive' => 'tablet',
							'class' => 'mfn_field_tablet mfn-toggled',
							'css_attr' => 'border-radius',
		  			),

		  			array(
		  				'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .teaser-wrapper li:border-radius_mobile',
		  				'type' => 'dimensions',
		  				'title' => __('Border radius', 'mfn-opts'),
							'responsive' => 'mobile',
							'class' => 'mfn_field_mobile mfn-toggled',
							'css_attr' => 'border-radius',
		  			),

		  			array(
							'class' => 'toggled_header',
   						'title' => __('Title', 'mfn-opts'),
   					),

		  			array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .blog-teaser .teaser-wrapper li .desc .post-title a:color',
							'type' => 'color',
							'class' => 'main-color mfn-toggled',
							'title' => __('Color', 'mfn-opts'),
						),

		  			array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .blog-teaser .teaser-wrapper li .desc .post-title a:typography',
							'type' => 'typography_vb',
							'label_after' => '<a href="#" title="Edit" class="mfn-option-btn mfn-option-blank btn-medium mfn-vb-label-button"><span class="mfn-icon mfn-icon-edit"></span></a>',
							'class' => 'mfn-toggled toggle_fields',
							'title' => __('Typography', 'mfn-opts'),
						),

						array(
							'class' => 'toggled_header',
   						'title' => __('Post header', 'mfn-opts'),
   					),

   					array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .blog-teaser .teaser-wrapper li .desc .post-meta:background-color',
							'type' => 'color',
							'class' => 'mfn-toggled',
							'title' => __('Background', 'mfn-opts'),
						),

						array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .blog-teaser .teaser-wrapper li .desc .post-meta:color',
							'type' => 'color',
							'class' => 'mfn-toggled',
							'title' => __('Color', 'mfn-opts'),
						),

						array(
		  				'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .blog-teaser .teaser-wrapper li .desc .post-meta:margin',
		  				'type' => 'dimensions',
		  				'version' => 'separated-fields',
		  				'title' => __('Margin', 'mfn-opts'),
							'responsive' => 'desktop',
							'class' => 'mfn_field_desktop mfn-toggled',
							'css_attr' => 'margin',
		  			),

		  			array(
		  				'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .blog-teaser .teaser-wrapper li .desc .post-meta:margin_tablet',
		  				'type' => 'dimensions',
		  				'version' => 'separated-fields',
		  				'title' => __('Margin', 'mfn-opts'),
							'responsive' => 'tablet',
							'class' => 'mfn_field_tablet mfn-toggled',
							'css_attr' => 'margin',
		  			),

		  			array(
		  				'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .blog-teaser .teaser-wrapper li .desc .post-meta:margin_mobile',
		  				'type' => 'dimensions',
		  				'version' => 'separated-fields',
		  				'title' => __('Margin', 'mfn-opts'),
							'responsive' => 'mobile',
							'class' => 'mfn_field_mobile mfn-toggled',
							'css_attr' => 'margin',
		  			),

						array(
		  				'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .blog-teaser .teaser-wrapper li .desc .post-meta:padding',
		  				'type' => 'dimensions',
		  				'version' => 'separated-fields',
		  				'title' => __('Padding', 'mfn-opts'),
							'responsive' => 'desktop',
							'class' => 'mfn_field_desktop mfn-toggled',
							'css_attr' => 'padding',
		  			),

		  			array(
		  				'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .blog-teaser .teaser-wrapper li .desc .post-meta:padding_tablet',
		  				'type' => 'dimensions',
		  				'version' => 'separated-fields',
		  				'title' => __('Padding', 'mfn-opts'),
							'responsive' => 'tablet',
							'class' => 'mfn_field_tablet mfn-toggled',
							'css_attr' => 'padding',
		  			),

		  			array(
		  				'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .blog-teaser .teaser-wrapper li .desc .post-meta:padding_mobile',
		  				'type' => 'dimensions',
		  				'version' => 'separated-fields',
		  				'title' => __('Padding', 'mfn-opts'),
							'responsive' => 'mobile',
							'class' => 'mfn_field_mobile mfn-toggled',
							'css_attr' => 'padding',
		  			),

		  			array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .blog-teaser .teaser-wrapper li .desc .post-meta:border-style',
							'attr_id' => 'border_style',
							'type' => 'select',
							'class' => 'mfn-toggled',
							'title' => __('Border style', 'mfn-opts'),
							'options' => [
								'none' => __('None', 'mfn-opts'),
								'solid' => __('Solid', 'mfn-opts'),
								'dashed' => __('Dashed', 'mfn-opts'),
								'dotted' => __('Dotted', 'mfn-opts'),
								'double' => __('Double', 'mfn-opts'),
							],
						),

						array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .blog-teaser .teaser-wrapper li .desc .post-meta:border-color',
							'condition' => array( 'id' => 'border_style', 'opt' => 'isnt', 'val' => 'none' ),
							'type' => 'color',
							'class' => 'mfn-toggled',
							'title' => __('Border color', 'mfn-opts'),
						),

						array(
		  				'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .blog-teaser .teaser-wrapper li .desc .post-meta:border-width',
		  				'condition' => array( 'id' => 'border_style', 'opt' => 'isnt', 'val' => 'none' ),
		  				'type' => 'dimensions',
		  				'title' => __('Border width', 'mfn-opts'),
							'responsive' => 'desktop',
							'class' => 'mfn_field_desktop mfn-toggled',
							'css_attr' => 'border-width',
		  			),

		  			array(
		  				'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .blog-teaser .teaser-wrapper li .desc .post-meta:border-width_tablet',
		  				'condition' => array( 'id' => 'border_style', 'opt' => 'isnt', 'val' => 'none' ),
		  				'type' => 'dimensions',
		  				'title' => __('Border width', 'mfn-opts'),
							'responsive' => 'tablet',
							'class' => 'mfn_field_tablet mfn-toggled',
							'css_attr' => 'border-width',
		  			),

		  			array(
		  				'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .blog-teaser .teaser-wrapper li .desc .post-meta:border-width_mobile',
		  				'condition' => array( 'id' => 'border_style', 'opt' => 'isnt', 'val' => 'none' ),
		  				'type' => 'dimensions',
		  				'title' => __('Border width', 'mfn-opts'),
							'responsive' => 'mobile',
							'class' => 'mfn_field_mobile mfn-toggled',
							'css_attr' => 'border-width',
		  			),

						array(
		  				'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .blog-teaser .teaser-wrapper li .desc .post-meta:border-radius',
		  				'type' => 'dimensions',
		  				'title' => __('Border radius', 'mfn-opts'),
							'responsive' => 'desktop',
							'class' => 'mfn_field_desktop mfn-toggled',
							'css_attr' => 'border-radius',
		  			),

		  			array(
		  				'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .blog-teaser .teaser-wrapper li .desc .post-meta:border-radius_tablet',
		  				'type' => 'dimensions',
		  				'title' => __('Border radius', 'mfn-opts'),
							'responsive' => 'tablet',
							'class' => 'mfn_field_tablet mfn-toggled',
							'css_attr' => 'border-radius',
		  			),

		  			array(
		  				'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .blog-teaser .teaser-wrapper li .desc .post-meta:border-radius_mobile',
		  				'type' => 'dimensions',
		  				'title' => __('Border radius', 'mfn-opts'),
							'responsive' => 'mobile',
							'class' => 'mfn_field_mobile mfn-toggled',
							'css_attr' => 'border-radius',
		  			),

		  			array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .blog-teaser .teaser-wrapper li .desc .post-meta:typography',
							'type' => 'typography_vb',
							'label_after' => '<a href="#" title="Edit" class="mfn-option-btn mfn-option-blank btn-medium mfn-vb-label-button"><span class="mfn-icon mfn-icon-edit"></span></a>',
							'class' => 'mfn-toggled toggle_fields',
							'title' => __('Typography', 'mfn-opts'),
						),

		  			array(
							'type' => 'html',
							'html' => '<div class="mfn-form-row mfn-sidebar-fields-tabs mfn-toggled mfn-vb-formrow mfn-vb-mfnuidhere"><ul class="mfn-sft-nav"><li class="active"><a href="#normal" data-tab="normal">Normal</a></li><li><a href="#hover" data-tab="hover">Hover</a></li></ul><div class="mfn-sft mfn-sft-normal">',
						),

						array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .blog-teaser .teaser-wrapper li .desc .post-meta a:color',
							'type' => 'color',
							'title' => __('Link color', 'mfn-opts'),
						),

						array(
							'type' => 'html',
							'html' => '</div><div class="mfn-sft mfn-sft-hover">',
						),

						array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .blog-teaser .teaser-wrapper li .desc .post-meta a|hover:color',
							'type' => 'color',
							'title' => __('Link color', 'mfn-opts'),
						),

						array(
							'type' => 'html',
							'html' => '</div></div>',
						),

						array(
							'class' => 'toggled_header',
   						'title' => __('Line', 'mfn-opts'),
   					),

   					array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .blog-teaser li .desc-wrapper .desc .post-title|after:background-color',
							'type' => 'color',
							'class' => 'mfn-toggled',
							'title' => __('Background', 'mfn-opts'),
						),

						array(
							'type' => 'html',
							'html' => '</div>',
						),

   				),
   			),

   			// Button ----------------------------------------------------

   			'button' => array(
   				'type' => 'button',
   				'title' => __('Button', 'mfn-opts'),
   				'size' => '1/4',
   				'tablet_size' => '1/4',
   				'mobile_size' => '1/1',
   				'tablet_resized' => '0',
   				'cat' => 'typography',
   				'fields' => array(

   					array(
							'type' => 'html',
							'html' => $this->itemtabs,
						),

   					array(
							'type' => 'html',
							'html' => '<div class="modalbox-card modalbox-re_render modalbox-card-content-mfnuidhere active">',
						),

   					array(
   						'id' => 'title',
   						'type' => 'text',
   						'edit_tag' => '.button | span.button_label',
   						'edit_position' => 'append',
   						'title' => __('Title', 'mfn-opts'),
							'std' => __('Click here', 'mfn-opts'),
							'preview' => 'title',
   					),

   					array(
   						'id' => 'link',
   						'type' => 'text',
   						'title' => __('Link', 'mfn-opts'),
   					),

   					array(
   						'id' => 'target',
   						'type' => 'select',
   						'title' => __('Link target', 'mfn-opts'),
   						'options' => array(
   							0 => __('Default | _self', 'mfn-opts'),
   							1 => __('New tab or window | _blank', 'mfn-opts'),
   							'lightbox' => __('Lightbox (image or embed video)', 'mfn-opts'),
   						),
   					),

   					// icon

   					array(
   						'title' => __('Icon', 'mfn-opts'),
   					),

   					array(
   						'id' => 'icon',
   						'type' => 'icon',
   						'title' => __('Icon', 'mfn-opts'),
   					),

   					array(
   						'id' => 'icon_position',
   						'type' => 'switch',
   						'title' => __('Position', 'mfn-opts'),
   						'options' => array(
   							'left' => __('Left', 'mfn-opts'),
   							'right' => __('Right', 'mfn-opts'),
   						),
							'std' => 'left',
   					),

   					// style

   					array(
   						'title' => __('Style', 'mfn-opts'),
   					),

   					array(
   						'id' => 'size',
   						'type' => 'switch',
   						'title' => __('Size', 'mfn-opts'),
   						'options' => array(
   							1 => __('Small', 'mfn-opts'),
   							2 => __('Default', 'mfn-opts'),
   							3 => __('Large', 'mfn-opts'),
   							4 => __('XL', 'mfn-opts'),
   						),
   						'std' => 2,
   					),

   					array(
   						'id' => 'full_width',
   						'type' => 'switch',
   						'title' => __('Width', 'mfn-opts'),
   						'options' => array(
   							0 => __('Default', 'mfn-opts'),
   							1 => __('Full width', 'mfn-opts'),
   						),
							'std' => 0,
   					),

   					array(
   						'id' => 'button_style',
   						're_render' => 'standard',
   						'type' => 'switch',
   						'title' => __('Style', 'mfn-opts'),
   						'options' => array(
   							'' => __('Default', 'mfn-opts'),
   							'button_theme' => __('Highlighted', 'mfn-opts'),
   						),
   						'std' => '',
   					),

   					// advanced

   					array(
   						'title' => __('Advanced', 'mfn-opts'),
   					),

						array(
   						'id' => 'download',
   						'type' => 'text',
   						'title' => __('Download', 'mfn-opts'),
   						'desc' => __('Enter the new filename for the downloaded file', 'mfn-opts'),
   					),

   					array(
   						'id' => 'rel',
   						'type' => 'text',
   						'title' => __('Rel', 'mfn-opts'),
   						'before' => 'rel=',
   					),

   					array(
   						'id' => 'onclick',
   						'type' => 'text',
   						'title' => __('Onclick', 'mfn-opts'),
							'before' => 'onclick=',
   					),

						// deprecated

   					array(
   						'class' => 'mfn-deprecated',
   						'title' => __('Deprecated', 'mfn-opts'),
   					),

   					array(
   						'id' => 'align',
   						'class' => 'mfn-deprecated',
   						'type' => 'switch',
   						'title' => __('Alignment', 'mfn-opts'),
   						'options' => array(
   							'' => __('Left', 'mfn-opts'),
   							'center' => __('Center', 'mfn-opts'),
   							'right' => __('Right', 'mfn-opts'),
   						),
							'std' => '',
							'preview' => 'align',
   					),

   					array(
   						'id' => 'color',
   						'class' => 'mfn-deprecated',
   						'type' => 'color',
   						'title' => __('Background color', 'mfn-opts'),
   						'desc' => __('For theme color button please enter <b>theme</b> in color filed', 'mfn-opts'),
   					),

   					array(
   						'id' => 'font_color',
   						'class' => 'mfn-deprecated',
   						'type' => 'color',
   						'title' => __('Text color', 'mfn-opts'),
   					),

   					array(
   						'id' => 'class',
   						'type' => 'text',
   						'class' => 'mfn-deprecated',
   						'title' => __('Element class', 'mfn-opts'),
   						'desc' => __('This option is useful when you want to use <b>scroll</b>', 'mfn-opts'),
   					),

   					array(
							'type' => 'html',
							'html' => '</div><div class="modalbox-card modalbox-card-style modalbox-re_render modalbox-card-style-mfnuidhere">',
						),

   					array(
							'class' => 'toggled_header',
   						'title' => __('Container', 'mfn-opts'),
   					),

   					array(
   						'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement:text-align',
							'responsive' => 'desktop',
   						'type' => 'switch',
   						'class' => 'mfn_field_desktop mfn-toggled',
   						'title' => __('Text align', 'mfn-opts'),
   						'options' => array(
   							'' => __('Default', 'mfn-opts'),
   							'left' => __('Left', 'mfn-opts'),
								'center' => __('Center', 'mfn-opts'),
   							'right' => __('Right', 'mfn-opts'),
   						),
							'preview' => 'align',
   					),

   					array(
   						'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement:text-align_tablet',
							'responsive' => 'tablet',
   						'type' => 'switch',
   						'class' => 'mfn_field_tablet mfn-toggled',
   						'title' => __('Text align', 'mfn-opts'),
   						'options' => array(
   							'' => __('Default', 'mfn-opts'),
   							'left' => __('Left', 'mfn-opts'),
								'center' => __('Center', 'mfn-opts'),
   							'right' => __('Right', 'mfn-opts'),
   						),
							'preview' => 'align',
   					),

   					array(
   						'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement:text-align_mobile',
							'responsive' => 'mobile',
   						'type' => 'switch',
   						'class' => 'mfn_field_mobile mfn-toggled',
   						'title' => __('Text align', 'mfn-opts'),
   						'options' => array(
   							'' => __('Default', 'mfn-opts'),
   							'left' => __('Left', 'mfn-opts'),
								'center' => __('Center', 'mfn-opts'),
   							'right' => __('Right', 'mfn-opts'),
   						),
							'preview' => 'align',
   					),

   					array(
							'class' => 'toggled_header',
   						'title' => __('Button', 'mfn-opts'),
   					),

		  			array(
		  				'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .button:padding',
		  				'type' => 'dimensions',
		  				'version' => 'separated-fields',
		  				'title' => __('Padding', 'mfn-opts'),
							'responsive' => 'desktop',
							'class' => 'mfn_field_desktop mfn-toggled',
							'css_attr' => 'padding',
		  			),

		  			array(
		  				'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .button:padding_tablet',
		  				'type' => 'dimensions',
		  				'version' => 'separated-fields',
		  				'title' => __('Padding', 'mfn-opts'),
							'responsive' => 'tablet',
							'class' => 'mfn_field_tablet mfn-toggled',
							'css_attr' => 'padding',
		  			),

		  			array(
		  				'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .button:padding_mobile',
		  				'type' => 'dimensions',
		  				'version' => 'separated-fields',
		  				'title' => __('Padding', 'mfn-opts'),
							'responsive' => 'mobile',
							'class' => 'mfn_field_mobile mfn-toggled',
							'css_attr' => 'padding',
		  			),

		  			array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .button:typography',
							'type' => 'typography_vb',
							'label_after' => '<a href="#" title="Edit" class="mfn-option-btn mfn-option-blank btn-medium mfn-vb-label-button"><span class="mfn-icon mfn-icon-edit"></span></a>',
							'class' => 'mfn-toggled toggle_fields',
							'title' => __('Typography', 'mfn-opts'),
						),

						array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .button:border-style',
							'attr_id' => 'border_style_button',
							'type' => 'select',
							'class' => 'mfn-toggled',
							'title' => __('Border style', 'mfn-opts'),
							'options' => [
								'none' => __('None', 'mfn-opts'),
								'solid' => __('Solid', 'mfn-opts'),
								'dashed' => __('Dashed', 'mfn-opts'),
								'dotted' => __('Dotted', 'mfn-opts'),
								'double' => __('Double', 'mfn-opts'),
							],
						),

						array(
		  				'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .button:border-width',
		  				'condition' => array( 'id' => 'border_style_button', 'opt' => 'isnt', 'val' => 'none' ),
		  				'type' => 'dimensions',
		  				'title' => __('Border width', 'mfn-opts'),
							'responsive' => 'desktop',
							'class' => 'mfn_field_desktop mfn-toggled',
							'css_attr' => 'border-width',
		  			),

		  			array(
		  				'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .button:border-width_tablet',
		  				'condition' => array( 'id' => 'border_style_button', 'opt' => 'isnt', 'val' => 'none' ),
		  				'type' => 'dimensions',
		  				'title' => __('Border width', 'mfn-opts'),
							'responsive' => 'tablet',
							'class' => 'mfn_field_tablet mfn-toggled',
							'css_attr' => 'border-width',
		  			),

		  			array(
		  				'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .button:border-width_mobile',
		  				'condition' => array( 'id' => 'border_style_button', 'opt' => 'isnt', 'val' => 'none' ),
		  				'type' => 'dimensions',
		  				'title' => __('Border width', 'mfn-opts'),
							'responsive' => 'mobile',
							'class' => 'mfn_field_mobile mfn-toggled',
							'css_attr' => 'border-width',
		  			),

						array(
		  				'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .button:border-radius',
		  				'type' => 'dimensions',
		  				'title' => __('Border radius', 'mfn-opts'),
							'responsive' => 'desktop',
							'class' => 'mfn_field_desktop mfn-toggled',
							'css_attr' => 'border-radius',
		  			),

		  			array(
		  				'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .button:border-radius_tablet',
		  				'type' => 'dimensions',
		  				'title' => __('Border radius', 'mfn-opts'),
							'responsive' => 'tablet',
							'class' => 'mfn_field_tablet mfn-toggled',
							'css_attr' => 'border-radius',
		  			),

		  			array(
		  				'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .button:border-radius_mobile',
		  				'type' => 'dimensions',
		  				'title' => __('Border radius', 'mfn-opts'),
							'responsive' => 'mobile',
							'class' => 'mfn_field_mobile mfn-toggled',
							'css_attr' => 'border-radius',
		  			),

   					array(
							'type' => 'html',
							'html' => '<div class="mfn-form-row mfn-sidebar-fields-tabs mfn-toggled mfn-vb-formrow mfn-vb-mfnuidhere"><ul class="mfn-sft-nav"><li class="active"><a href="#normal" data-tab="normal">Normal</a></li><li><a href="#hover" data-tab="hover">Hover</a></li></ul><div class="mfn-sft mfn-sft-normal">',
						),

						array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .button:color',
							'type' => 'color',
							'class' => 'main-color mfn-toggled',
							'title' => __('Color', 'mfn-opts'),
						),

						array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .button:border-color',
							'condition' => array( 'id' => 'border_style_button', 'opt' => 'isnt', 'val' => 'none' ),
							'type' => 'color',
							'class' => 'mfn-toggled',
							'title' => __('Border color', 'mfn-opts'),
						),

						array(
							'id' => 'background_switcher',
							'attr_id' => 'background_switcher_button',
							'type' => 'switch',
							'class' => 'mfn-fields-switcher',
							'title' => __('Background type', 'mfn-opts'),
							'options' => array(
		  					'default' => __('Default', 'mfn-opts'),
		  					'gradient' 	=> __('Gradient', 'mfn-opts'),
		  				),
							'visual_options' => array(
		  					'default' => '',
		  					'gradient' 	=> '',
		  				),
		  				'std' => 'default',
						),

						array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .button:background-color',
							'condition' => array( 'id' => 'background_switcher_button', 'opt' => 'is', 'val' => 'default' ),
							'type' => 'color',
							'title' => __('Background color', 'mfn-opts'),
						),

						array(
		  				'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .button:gradient',
		  				'condition' => array( 'id' => 'background_switcher_button', 'opt' => 'is', 'val' => 'gradient' ),
		  				'type' => 'gradient',
		  				'title' => __('Gradient', 'mfn-opts'),
		  				'class' => 'mfn-toggled',
							'css_attr' => 'gradient',
		  			),

						array(
							'type' => 'html',
							'html' => '</div><div class="mfn-sft mfn-sft-hover">',
						),

						array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .button|hover:color',
							'type' => 'color',
							'class' => 'main-color mfn-toggled',
							'title' => __('Color', 'mfn-opts'),
						),

						array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .button|hover:border-color',
							'condition' => array( 'id' => 'border_style_button', 'opt' => 'isnt', 'val' => 'none' ),
							'type' => 'color',
							'class' => 'mfn-toggled',
							'title' => __('Border color', 'mfn-opts'),
						),

						array(
							'id' => 'background_switcher_hover',
							'attr_id' => 'background_switcher_hover_button',
							'type' => 'switch',
							'class' => 'mfn-fields-switcher',
							'title' => __('Background type', 'mfn-opts'),
							'options' => array(
		  					'default' => __('Default', 'mfn-opts'),
		  					'gradient' 	=> __('Gradient', 'mfn-opts'),
		  				),
							'visual_options' => array(
		  					'default' => '',
		  					'gradient' 	=> '',
		  				),
		  				'std' => 'default',
						),

						array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .button|hover:background',
							'condition' => array( 'id' => 'background_switcher_hover_button', 'opt' => 'is', 'val' => 'default' ),
							'type' => 'color',
							'class' => 'main-color mfn-toggled',
							'title' => __('Background color', 'mfn-opts'),
						),

						array(
		  				'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .button|hover:gradient',
		  				'condition' => array( 'id' => 'background_switcher_hover_button', 'opt' => 'is', 'val' => 'gradient' ),
		  				'type' => 'gradient',
		  				'title' => __('Gradient', 'mfn-opts'),
		  				'class' => 'mfn-toggled',
							'css_attr' => 'gradient',
		  			),

						array(
							'type' => 'html',
							'html' => '</div></div>',
						),












						array(
							'type' => 'html',
							'html' => '</div>',
						),

   				),
   			),

   			// Call to Action -------------------------------------------------

   			'call_to_action' => array(
   				'type' => 'call_to_action',
   				'title' => __('Call to Action', 'mfn-opts'),
   				'size' => '1/1',
   				'tablet_size' => '1/1',
   				'mobile_size' => '1/1',
   				'tablet_resized' => '0',
   				'cat' => 'elements',
   				'fields' => array(

   					array(
							'type' => 'html',
							'html' => $this->itemtabs,
						),

   					array(
							'type' => 'html',
							'html' => '<div class="modalbox-card modalbox-re_render modalbox-card-content-mfnuidhere active">',
						),

   					array(
   						'id' => 'title',
   						'edit_tag' => '.call_left | h3',
   						'edit_position' => 'prepend',
   						'type' => 'text',
   						'title' => __('Title', 'mfn-opts'),
							'std' => __('This is the title', 'mfn-opts'),
							'preview' => 'title',
   					),

   					array(
   						'id' => 'icon',
   						'type' => 'icon',
   						'title' => __('Icon', 'mfn-opts'),
   						'std' => 'icon-check',
   						'preview' => 'icon',
   					),

   					array(
   						'id' => 'content',
   						'type' => 'textarea',
   						'edit_tag' => '.call_right | div.desc',
   						'edit_position' => 'prepend',
   						'title' => __('Content', 'mfn-opts'),
							'std' => 'Lorem ipsum dolor sit amet, consectetur adipiscing elit. Ut elit tellus, luctus nec ullamcorper mattis, pulvinar dapibus leo.',
   						'preview' => 'content',
							'class' => 'form-content-full-width',
   					),

   					// link

   					array(
   						'title' => __('Link', 'mfn-opts'),
   					),

						array(
   						'id' => 'button_title',
   						'type' => 'text',
   						'title' => __('Button title', 'mfn-opts'),
   						'desc' => __('Leave this field blank if you want Call to action with big icon', 'mfn-opts'),
   					),

   					array(
   						'id' => 'link',
   						'type' => 'text',
   						'title' => __('Link', 'mfn-opts'),
   					),

   					array(
   						'id' => 'target',
   						'type' => 'select',
   						'title' => __('Target', 'mfn-opts'),
   						'options' => array(
   							0 => __('Default | _self', 'mfn-opts'),
   							1 => __('New tab or window | _blank', 'mfn-opts'),
   							'lightbox' => __('Lightbox (image or embed video)', 'mfn-opts'),
   						),
   					),

						// deprecated

						array(
							'class' => 'mfn-deprecated',
							'title' => __('Deprecated', 'mfn-opts'),
						),

						array(
							'id' => 'class',
							'type' => 'pills',
							'title' => __('Element classes', 'mfn-opts'),
							'class' => 'mfn-deprecated',
						),

		  			array(
							'type' => 'html',
							'html' => '</div><div class="modalbox-card modalbox-card-style modalbox-re_render modalbox-card-style-mfnuidhere">',
						),

						array(
							'class' => 'toggled_header',
   						'title' => __('Title', 'mfn-opts'),
   					),

		  			array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .call_to_action .call_left h3:color',
							'type' => 'color',
							'class' => 'main-color mfn-toggled',
							'title' => __('Color', 'mfn-opts'),
						),

						array(
   						'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .call_to_action .call_left h3:text-align',
							'responsive' => 'desktop',
   						'type' => 'switch',
   						'class' => 'mfn_field_desktop mfn-toggled',
   						'title' => __('Text align', 'mfn-opts'),
   						'options' => array(
   							'' => __('Default', 'mfn-opts'),
   							'left' => __('Left', 'mfn-opts'),
								'center' => __('Center', 'mfn-opts'),
   							'right' => __('Right', 'mfn-opts'),
   							'justify' => __('Justify', 'mfn-opts'),
   						),
							'preview' => 'align',
   					),

   					array(
   						'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .call_to_action .call_left h3:text-align_tablet',
							'responsive' => 'tablet',
   						'type' => 'switch',
   						'class' => 'mfn_field_tablet mfn-toggled',
   						'title' => __('Text align', 'mfn-opts'),
   						'options' => array(
   							'' => __('Default', 'mfn-opts'),
   							'left' => __('Left', 'mfn-opts'),
								'center' => __('Center', 'mfn-opts'),
   							'right' => __('Right', 'mfn-opts'),
   							'justify' => __('Justify', 'mfn-opts'),
   						),
							'preview' => 'align',
   					),

   					array(
   						'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .call_to_action .call_left h3:text-align_mobile',
							'responsive' => 'mobile',
   						'type' => 'switch',
   						'class' => 'mfn_field_mobile mfn-toggled',
   						'title' => __('Text align', 'mfn-opts'),
   						'options' => array(
   							'' => __('Default', 'mfn-opts'),
   							'left' => __('Left', 'mfn-opts'),
								'center' => __('Center', 'mfn-opts'),
   							'right' => __('Right', 'mfn-opts'),
   							'justify' => __('Justify', 'mfn-opts'),
   						),
							'preview' => 'align',
   					),

		  			array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .call_to_action .call_left h3:typography',
							'type' => 'typography_vb',
							'label_after' => '<a href="#" title="Edit" class="mfn-option-btn mfn-option-blank btn-medium mfn-vb-label-button"><span class="mfn-icon mfn-icon-edit"></span></a>',
							'class' => 'mfn-toggled toggle_fields',
							'title' => __('Typography', 'mfn-opts'),
						),

						array(
							'class' => 'toggled_header',
   						'title' => __('Desc', 'mfn-opts'),
   					),

		  			array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .call_to_action .call_right .desc:color',
							'type' => 'color',
							'class' => 'main-color mfn-toggled',
							'title' => __('Color', 'mfn-opts'),
						),

						array(
   						'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .call_to_action .call_right .desc:text-align',
							'responsive' => 'desktop',
   						'type' => 'switch',
   						'class' => 'mfn_field_desktop mfn-toggled',
   						'title' => __('Text align', 'mfn-opts'),
   						'options' => array(
   							'' => __('Default', 'mfn-opts'),
   							'left' => __('Left', 'mfn-opts'),
								'center' => __('Center', 'mfn-opts'),
   							'right' => __('Right', 'mfn-opts'),
   							'justify' => __('Justify', 'mfn-opts'),
   						),
							'preview' => 'align',
   					),
   					array(
   						'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .call_to_action .call_right .desc:text-align_tablet',
							'responsive' => 'tablet',
   						'type' => 'switch',
   						'class' => 'mfn_field_tablet mfn-toggled',
   						'title' => __('Text align', 'mfn-opts'),
   						'options' => array(
   							'' => __('Default', 'mfn-opts'),
   							'left' => __('Left', 'mfn-opts'),
								'center' => __('Center', 'mfn-opts'),
   							'right' => __('Right', 'mfn-opts'),
   							'justify' => __('Justify', 'mfn-opts'),
   						),
							'preview' => 'align',
   					),
   					array(
   						'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .call_to_action .call_right .desc:text-align_mobile',
							'responsive' => 'mobile',
   						'type' => 'switch',
   						'class' => 'mfn_field_mobile mfn-toggled',
   						'title' => __('Text align', 'mfn-opts'),
   						'options' => array(
   							'' => __('Default', 'mfn-opts'),
   							'left' => __('Left', 'mfn-opts'),
								'center' => __('Center', 'mfn-opts'),
   							'right' => __('Right', 'mfn-opts'),
   							'justify' => __('Justify', 'mfn-opts'),
   						),
							'preview' => 'align',
   					),

		  			array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .call_to_action .call_right .desc:typography',
							'type' => 'typography_vb',
							'label_after' => '<a href="#" title="Edit" class="mfn-option-btn mfn-option-blank btn-medium mfn-vb-label-button"><span class="mfn-icon mfn-icon-edit"></span></a>',
							'class' => 'mfn-toggled toggle_fields',
							'title' => __('Typography', 'mfn-opts'),
						),

						array(
							'class' => 'toggled_header',
   						'title' => __('Icon', 'mfn-opts'),
   					),

   					array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .call_to_action .call_center .icon_wrapper i:color',
							'type' => 'color',
							'class' => 'mfn-toggled',
							'title' => __('Color', 'mfn-opts'),
						),

						array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .call_to_action .call_center .icon_wrapper:background-color',
							'type' => 'color',
							'class' => 'mfn-toggled',
							'title' => __('Background', 'mfn-opts'),
						),

   					array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .call_to_action .call_center .icon_wrapper i:font-size',
							'type' => 'sliderbar',
							'responsive' => 'desktop',
							'class' => 'mfn_field_desktop mfn-toggled',
							'title' => __('Size', 'mfn-opts'),
							'units' => array(
								'px' 	=> array('min' => 1, 		'max' => 100, 'step' => 1),
								'em' 	=> array('min' => 0.1, 	'max' => 10, 	'step' => 0.1),
								'rem' => array('min' => 0.1, 	'max' => 10, 	'step' => 0.1),
								'vw' 	=> array('min' => 1, 		'max' => 100, 'step' => 1),
							)
						),

						array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .call_to_action .call_center .icon_wrapper i:font-size_tablet',
							'type' => 'sliderbar',
							'responsive' => 'tablet',
							'class' => 'mfn_field_tablet mfn-toggled',
							'title' => __('Size', 'mfn-opts'),
							'units' => array(
								'px' 	=> array('min' => 1, 		'max' => 100, 'step' => 1),
								'em' 	=> array('min' => 0.1, 	'max' => 10, 	'step' => 0.1),
								'rem' => array('min' => 0.1, 	'max' => 10, 	'step' => 0.1),
								'vw' 	=> array('min' => 1, 		'max' => 100, 'step' => 1),
							)
						),

						array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .call_to_action .call_center .icon_wrapper i:font-size_mobile',
							'type' => 'sliderbar',
							'responsive' => 'mobile',
							'class' => 'mfn_field_mobile mfn-toggled',
							'title' => __('Size', 'mfn-opts'),
							'units' => array(
								'px' 	=> array('min' => 1, 		'max' => 100, 'step' => 1),
								'em' 	=> array('min' => 0.1, 	'max' => 10, 	'step' => 0.1),
								'rem' => array('min' => 0.1, 	'max' => 10, 	'step' => 0.1),
								'vw' 	=> array('min' => 1, 		'max' => 100, 'step' => 1),
							)
						),

   					array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .call_to_action .call_center .icon_wrapper:border-style',
							'attr_id' => 'border_style',
							'type' => 'select',
							'class' => 'mfn-toggled',
							'title' => __('Border style', 'mfn-opts'),
							'options' => [
								'none' => __('None', 'mfn-opts'),
								'solid' => __('Solid', 'mfn-opts'),
								'dashed' => __('Dashed', 'mfn-opts'),
								'dotted' => __('Dotted', 'mfn-opts'),
								'double' => __('Double', 'mfn-opts'),
							],
						),

						array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .call_to_action .call_center .icon_wrapper:border-color',
							'condition' => array( 'id' => 'border_style', 'opt' => 'isnt', 'val' => 'none' ),
							'type' => 'color',
							'class' => 'mfn-toggled',
							'title' => __('Border color', 'mfn-opts'),
						),

						array(
		  				'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .call_to_action .call_center .icon_wrapper:border-width',
		  				'condition' => array( 'id' => 'border_style', 'opt' => 'isnt', 'val' => 'none' ),
		  				'type' => 'dimensions',
		  				'title' => __('Border width', 'mfn-opts'),
							'responsive' => 'desktop',
							'class' => 'mfn_field_desktop mfn-toggled',
							'css_attr' => 'border-width',
		  			),

		  			array(
		  				'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .call_to_action .call_center .icon_wrapper:border-width_tablet',
		  				'condition' => array( 'id' => 'border_style', 'opt' => 'isnt', 'val' => 'none' ),
		  				'type' => 'dimensions',
		  				'title' => __('Border width', 'mfn-opts'),
							'responsive' => 'tablet',
							'class' => 'mfn_field_tablet mfn-toggled',
							'css_attr' => 'border-width',
		  			),

		  			array(
		  				'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .call_to_action .call_center .icon_wrapper:border-width_mobile',
		  				'condition' => array( 'id' => 'border_style', 'opt' => 'isnt', 'val' => 'none' ),
		  				'type' => 'dimensions',
		  				'title' => __('Border width', 'mfn-opts'),
							'responsive' => 'mobile',
							'class' => 'mfn_field_mobile mfn-toggled',
							'css_attr' => 'border-width',
		  			),

						array(
		  				'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .call_to_action .call_center .icon_wrapper:border-radius',
		  				'type' => 'dimensions',
		  				'title' => __('Border radius', 'mfn-opts'),
							'responsive' => 'desktop',
							'class' => 'mfn_field_desktop mfn-toggled',
							'css_attr' => 'border-radius',
		  			),

		  			array(
		  				'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .call_to_action .call_center .icon_wrapper:border-radius_tablet',
		  				'type' => 'dimensions',
		  				'title' => __('Border radius', 'mfn-opts'),
							'responsive' => 'tablet',
							'class' => 'mfn_field_tablet mfn-toggled',
							'css_attr' => 'border-radius',
		  			),

		  			array(
		  				'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .call_to_action .call_center .icon_wrapper:border-radius_mobile',
		  				'type' => 'dimensions',
		  				'title' => __('Border radius', 'mfn-opts'),
							'responsive' => 'mobile',
							'class' => 'mfn_field_mobile mfn-toggled',
							'css_attr' => 'border-radius',
		  			),

		  			array(
							'class' => 'toggled_header',
   						'title' => __('Button', 'mfn-opts'),
   					),

						array(
		  				'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .call_to_action .call_center .button:padding',
		  				'type' => 'dimensions',
		  				'version' => 'separated-fields',
		  				'title' => __('Padding', 'mfn-opts'),
							'responsive' => 'desktop',
							'class' => 'mfn_field_desktop mfn-toggled',
							'css_attr' => 'padding',
		  			),

		  			array(
		  				'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .call_to_action .call_center .button:padding_tablet',
		  				'type' => 'dimensions',
		  				'version' => 'separated-fields',
		  				'title' => __('Padding', 'mfn-opts'),
							'responsive' => 'tablet',
							'class' => 'mfn_field_tablet mfn-toggled',
							'css_attr' => 'padding',
		  			),

		  			array(
		  				'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .call_to_action .call_center .button:padding_mobile',
		  				'type' => 'dimensions',
		  				'version' => 'separated-fields',
		  				'title' => __('Padding', 'mfn-opts'),
							'responsive' => 'mobile',
							'class' => 'mfn_field_mobile mfn-toggled',
							'css_attr' => 'padding',
		  			),

		  			array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .call_to_action .call_center .button:typography',
							'type' => 'typography_vb',
							'label_after' => '<a href="#" title="Edit" class="mfn-option-btn mfn-option-blank btn-medium mfn-vb-label-button"><span class="mfn-icon mfn-icon-edit"></span></a>',
							'class' => 'mfn-toggled toggle_fields',
							'title' => __('Typography', 'mfn-opts'),
						),

						array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .call_to_action .call_center .button:border-style',
							'attr_id' => 'border_style',
							'type' => 'select',
							'class' => 'mfn-toggled',
							'title' => __('Border style', 'mfn-opts'),
							'options' => [
								'none' => __('None', 'mfn-opts'),
								'solid' => __('Solid', 'mfn-opts'),
								'dashed' => __('Dashed', 'mfn-opts'),
								'dotted' => __('Dotted', 'mfn-opts'),
								'double' => __('Double', 'mfn-opts'),
							],
						),

						array(
		  				'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .call_to_action .call_center .button:border-width',
		  				'condition' => array( 'id' => 'border_style', 'opt' => 'isnt', 'val' => 'none' ),
		  				'type' => 'dimensions',
		  				'title' => __('Border width', 'mfn-opts'),
							'responsive' => 'desktop',
							'class' => 'mfn_field_desktop mfn-toggled',
							'css_attr' => 'border-width',
		  			),

		  			array(
		  				'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .call_to_action .call_center .button:border-width_tablet',
		  				'condition' => array( 'id' => 'border_style', 'opt' => 'isnt', 'val' => 'none' ),
		  				'type' => 'dimensions',
		  				'title' => __('Border width', 'mfn-opts'),
							'responsive' => 'tablet',
							'class' => 'mfn_field_tablet mfn-toggled',
							'css_attr' => 'border-width',
		  			),

		  			array(
		  				'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .call_to_action .call_center .button:border-width_mobile',
		  				'condition' => array( 'id' => 'border_style', 'opt' => 'isnt', 'val' => 'none' ),
		  				'type' => 'dimensions',
		  				'title' => __('Border width', 'mfn-opts'),
							'responsive' => 'mobile',
							'class' => 'mfn_field_mobile mfn-toggled',
							'css_attr' => 'border-width',
		  			),

						array(
		  				'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .call_to_action .call_center .button:border-radius',
		  				'type' => 'dimensions',
		  				'title' => __('Border radius', 'mfn-opts'),
							'responsive' => 'desktop',
							'class' => 'mfn_field_desktop mfn-toggled',
							'css_attr' => 'border-radius',
		  			),

		  			array(
		  				'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .call_to_action .call_center .button:border-radius_tablet',
		  				'type' => 'dimensions',
		  				'title' => __('Border radius', 'mfn-opts'),
							'responsive' => 'tablet',
							'class' => 'mfn_field_tablet mfn-toggled',
							'css_attr' => 'border-radius',
		  			),

		  			array(
		  				'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .call_to_action .call_center .button:border-radius_mobile',
		  				'type' => 'dimensions',
		  				'title' => __('Border radius', 'mfn-opts'),
							'responsive' => 'mobile',
							'class' => 'mfn_field_mobile mfn-toggled',
							'css_attr' => 'border-radius',
		  			),

   					array(
							'type' => 'html',
							'html' => '<div class="mfn-form-row mfn-sidebar-fields-tabs mfn-toggled mfn-vb-formrow mfn-vb-mfnuidhere"><ul class="mfn-sft-nav"><li class="active"><a href="#normal" data-tab="normal">Normal</a></li><li><a href="#hover" data-tab="hover">Hover</a></li></ul><div class="mfn-sft mfn-sft-normal">',
						),

						array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .call_to_action .call_center .button:color',
							'type' => 'color',
							'class' => 'main-color mfn-toggled',
							'title' => __('Color', 'mfn-opts'),
						),

						array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .call_to_action .call_center .button:border-color',
							'condition' => array( 'id' => 'border_style', 'opt' => 'isnt', 'val' => 'none' ),
							'type' => 'color',
							'class' => 'mfn-toggled',
							'title' => __('Border color', 'mfn-opts'),
						),

						array(
							'id' => 'background_switcher',
							'attr_id' => 'background_switcher',
							'type' => 'switch',
							'class' => 'mfn-fields-switcher',
							'title' => __('Background type', 'mfn-opts'),
							'options' => array(
		  					'default' => __('Default', 'mfn-opts'),
		  					'gradient' 	=> __('Gradient', 'mfn-opts'),
		  				),
							'visual_options' => array(
		  					'default' => '',
		  					'gradient' 	=> '',
		  				),
		  				'std' => 'default',
						),

						array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .call_to_action .call_center .button:background-color',
							'condition' => array( 'id' => 'background_switcher', 'opt' => 'is', 'val' => 'default' ),
							'type' => 'color',
							'title' => __('Background color', 'mfn-opts'),
						),

						array(
		  				'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .call_to_action .call_center .button:gradient',
		  				'condition' => array( 'id' => 'background_switcher', 'opt' => 'is', 'val' => 'gradient' ),
		  				'type' => 'gradient',
		  				'title' => __('Gradient', 'mfn-opts'),
		  				'class' => 'mfn-toggled',
							'css_attr' => 'gradient',
		  			),

						array(
							'type' => 'html',
							'html' => '</div><div class="mfn-sft mfn-sft-hover">',
						),

						array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .call_to_action .call_center .button|hover:color',
							'type' => 'color',
							'class' => 'main-color mfn-toggled',
							'title' => __('Color', 'mfn-opts'),
						),

						array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .call_to_action .call_center .button|hover:border-color',
							'condition' => array( 'id' => 'border_style', 'opt' => 'isnt', 'val' => 'none' ),
							'type' => 'color',
							'class' => 'mfn-toggled',
							'title' => __('Border color', 'mfn-opts'),
						),

						array(
							'id' => 'background_switcher_hover',
							'attr_id' => 'background_switcher_hover',
							'type' => 'switch',
							'class' => 'mfn-fields-switcher',
							'title' => __('Background type', 'mfn-opts'),
							'options' => array(
		  					'default' => __('Default', 'mfn-opts'),
		  					'gradient' 	=> __('Gradient', 'mfn-opts'),
		  				),
							'visual_options' => array(
		  					'default' => '',
		  					'gradient' 	=> '',
		  				),
		  				'std' => 'default',
						),

						array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .call_to_action .call_center .button|hover:background',
							'condition' => array( 'id' => 'background_switcher_hover', 'opt' => 'is', 'val' => 'default' ),
							'type' => 'color',
							'class' => 'main-color mfn-toggled',
							'title' => __('Background color', 'mfn-opts'),
						),

						array(
		  				'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .call_to_action .call_center .button|hover:gradient',
		  				'condition' => array( 'id' => 'background_switcher_hover', 'opt' => 'is', 'val' => 'gradient' ),
		  				'type' => 'gradient',
		  				'title' => __('Gradient', 'mfn-opts'),
		  				'class' => 'mfn-toggled',
							'css_attr' => 'gradient',
		  			),

						array(
							'type' => 'html',
							'html' => '</div></div>',
						),

						array(
							'type' => 'html',
							'html' => '</div>',
						),

   				),
   			),

   			// Chart  ---------------------------------------------------------

   			'chart' => array(
   				'type' => 'chart',
   				'title' => __('Chart', 'mfn-opts'),
   				'size' => '1/4',
   				'tablet_size' => '1/4',
   				'mobile_size' => '1/1',
   				'tablet_resized' => '0',
   				'cat' => 'boxes',
   				'fields' => array(

   					array(
							'type' => 'html',
							'html' => $this->itemtabs,
						),

   					array(
							'type' => 'html',
							'html' => '<div class="modalbox-card modalbox-re_render modalbox-card-content-mfnuidhere active">',
						),

   					array(
   						'id' => 'title',
   						'type' => 'text',
   						'title' => __('Title', 'mfn-opts'),
   						'edit_tag' => '.chart_box | big',
   						'edit_position' => 'append',
							'std' => __('This is the title', 'mfn-opts'),
							'preview' => 'title',
   					),

   					// chart

   					array(
   						'title' => __('Chart', 'mfn-opts'),
   					),

   					array(
   						'id' => 'percent',
   						'type' => 'text',
   						're_render' => 'standard',
   						'title' => __('Percent', 'mfn-opts'),
   						'desc' => __('0-100', 'mfn-opts'),
							'param' => 'number',
							'after' => '%',
							'class' => 'narrow',
							'preview' => 'number',
							'std' => 50,
   					),

   					array(
   						'id' => 'label',
   						'type' => 'text',
   						'title' => __('Label', 'mfn-opts'),
							'preview' => 'subtitle',
   					),

   					array(
   						'id' => 'icon',
   						'type' => 'icon',
   						'title' => __('Icon', 'mfn-opts'),
							'std' => 'icon-check',
   					),

   					array(
   						'id' => 'image',
   						'type' => 'upload',
   						'title' => __('Image', 'mfn-opts'),
   						'desc' => __('Recommended image size <b>70px x 70px</b>', 'mfn-opts'),
   					),

						// deprecated

						array(
							'class' => 'mfn-deprecated',
							'title' => __('Deprecated', 'mfn-opts'),
						),

						array(
							'id' => 'class',
							'type' => 'pills',
							'title' => __('Element classes', 'mfn-opts'),
							'class' => 'mfn-deprecated',
						),

   					array(
							'type' => 'html',
							'html' => '</div><div class="modalbox-card modalbox-card-style modalbox-re_render modalbox-card-style-mfnuidhere">',
						),

   					array(
							'class' => 'toggled_header',
   						'title' => __('Title', 'mfn-opts'),
   					),

						array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .chart_box .chart-desc:color',
							'type' => 'color',
							'class' => 'mfn-toggled',
							'title' => __('Color', 'mfn-opts'),
						),

						array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .chart_box .chart-desc:typography',
							'type' => 'typography_vb',
							'label_after' => '<a href="#" title="Edit" class="mfn-option-btn mfn-option-blank btn-medium mfn-vb-label-button"><span class="mfn-icon mfn-icon-edit"></span></a>',
							'class' => 'mfn-toggled toggle_fields',
							'title' => __('Typography', 'mfn-opts'),
						),

						array(
							'class' => 'toggled_header',
   						'title' => __('Label', 'mfn-opts'),
   					),

						array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .chart_box .num:color',
							'type' => 'color',
							'class' => 'mfn-toggled',
							'title' => __('Color', 'mfn-opts'),
						),

						array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .chart_box .num:typography',
							'type' => 'typography_vb',
							'label_after' => '<a href="#" title="Edit" class="mfn-option-btn mfn-option-blank btn-medium mfn-vb-label-button"><span class="mfn-icon mfn-icon-edit"></span></a>',
							'class' => 'mfn-toggled toggle_fields',
							'title' => __('Typography', 'mfn-opts'),
						),

						array(
							'class' => 'toggled_header',
   						'title' => __('Style Icon', 'mfn-opts'),
   					),

   					array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .chart_box .icon i:color',
							'type' => 'color',
							'class' => 'mfn-toggled',
							'title' => __('Icon', 'mfn-opts'),
						),

						array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .chart_box .icon i:font-size',
							'type' => 'sliderbar',
							'responsive' => 'desktop',
							'class' => 'mfn_field_desktop mfn-toggled',
							'title' => __('Size', 'mfn-opts'),
							'units' => array(
								'px' 	=> array('min' => 1, 		'max' => 100, 'step' => 1),
								'em' 	=> array('min' => 0.1, 	'max' => 10, 	'step' => 0.1),
								'rem' => array('min' => 0.1, 	'max' => 10, 	'step' => 0.1),
								'vw' 	=> array('min' => 1, 		'max' => 100, 'step' => 1),
							)
						),

						array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .chart_box .icon i:font-size_tablet',
							'type' => 'sliderbar',
							'responsive' => 'tablet',
							'class' => 'mfn_field_tablet mfn-toggled',
							'title' => __('Size', 'mfn-opts'),
							'units' => array(
								'px' 	=> array('min' => 1, 		'max' => 100, 'step' => 1),
								'em' 	=> array('min' => 0.1, 	'max' => 10, 	'step' => 0.1),
								'rem' => array('min' => 0.1, 	'max' => 10, 	'step' => 0.1),
								'vw' 	=> array('min' => 1, 		'max' => 100, 'step' => 1),
							)
						),

						array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .chart_box .icon i:font-size_mobile',
							'type' => 'sliderbar',
							'responsive' => 'mobile',
							'class' => 'mfn_field_mobile mfn-toggled',
							'title' => __('Size', 'mfn-opts'),
							'units' => array(
								'px' 	=> array('min' => 1, 		'max' => 100, 'step' => 1),
								'em' 	=> array('min' => 0.1, 	'max' => 10, 	'step' => 0.1),
								'rem' => array('min' => 0.1, 	'max' => 10, 	'step' => 0.1),
								'vw' 	=> array('min' => 1, 		'max' => 100, 'step' => 1),
							)
						),

						array(
							'class' => 'toggled_header',
   						'title' => __('Chart', 'mfn-opts'),
   					),

   					array(
   						'id' => 'color',
   						'type' => 'color',
   						're_render' => 'standard',
   						'class' => 'mfn-toggled',
   						'title' => __('Color', 'mfn-opts'),
   						'desc' => __('Overrides color set in Theme Options', 'mfn-opts'),
   					),

   					array(
   						'id' => 'line_width',
   						'type' => 'text',
   						'title' => __('Line thickness', 'mfn-opts'),
							'param' => 'number',
							'after' => 'px',
							'class' => 'narrow mfn-toggled',
							'placeholder' => 4,
   					),

						array(
							'type' => 'html',
							'html' => '</div>',
						),

   				),
   			),

   			// Clients  -------------------------------------------------------

   			'clients' => array(
   				'type' => 'clients',
   				'title' => __('Clients', 'mfn-opts'),
   				'size' => '1/1',
   				'tablet_size' => '1/1',
   				'mobile_size' => '1/1',
   				'tablet_resized' => '0',
   				'cat' => 'loops',
   				'fields' => array(

   					array(
							'type' => 'html',
							'html' => $this->itemtabs,
						),

   					array(
							'type' => 'html',
							'html' => '<div class="modalbox-card modalbox-re_render modalbox-card-content-mfnuidhere active">',
						),

   					array(
   						'id' => 'in_row',
   						'type' => 'text',
   						're_render' => 'standard',
   						'title' => __('Items in row', 'mfn-opts'),
   						'desc' => __('Recommended: 3-6', 'mfn-opts'),
							'after' => 'items',
							'param' => 'number',
							'class' => 'narrow',
   						'std' => 6,
   						'preview' => 'number',
   					),

						array(
   						'id' => 'style',
   						'type' => 'switch',
   						'attr_id' => 'clients_style',
   						're_render' => 'standard',
   						'title' => __('Style', 'mfn-opts'),
   						'options' => array(
   							'' => __('Default', 'mfn-opts'),
   							'tiles' => __('Tiles', 'mfn-opts'),
   						),
							'std' => '',
							'preview' => 'style',
   					),

						// options

   					array(
   						'title' => __('Options', 'mfn-opts'),
   					),

   					array(
   						'id' => 'category',
   						're_render' => 'standard',
   						'type' => 'select',
   						'title' => __('Category', 'mfn-opts'),
   						'options' => mfn_get_categories('client-types'),
							'preview' => 'category',
   					),

   					array(
   						'id' => 'orderby',
   						're_render' => 'standard',
   						'type' => 'switch',
   						'title' => __('Order by', 'mfn-opts'),
   						'options' => array(
   							'date' => __('Date', 'mfn-opts'),
   							'menu_order' => __('Menu order', 'mfn-opts'),
   							'title' => __('Title', 'mfn-opts'),
   							'rand' => __('Random', 'mfn-opts'),
   						),
   						'std' => 'menu_order'
   					),

   					array(
   						'id' => 'order',
   						're_render' => 'standard',
   						'type' => 'switch',
   						'title' => __('Order', 'mfn-opts'),
   						'options' => array(
								'DESC' => __('Descending', 'mfn-opts'),
   							'ASC' => __('Ascending', 'mfn-opts'),
   						),
   						'std' => 'ASC',
   					),

						// advanced

   					array(
   						'title' => __('Advanced', 'mfn-opts'),
   					),

   					array(
   						'id' => 'greyscale',
   						'type' => 'switch',
   						'title' => 'Grayscale',
   						'options' => array(
   							0 => __('Disable', 'mfn-opts'),
   							1 => __('Enable', 'mfn-opts'),
   						),
							'std' => 0,
   					),

						// deprecated

						array(
							'class' => 'mfn-deprecated',
							'title' => __('Deprecated', 'mfn-opts'),
						),

						array(
							'id' => 'class',
							'type' => 'pills',
							'title' => __('Element classes', 'mfn-opts'),
							'class' => 'mfn-deprecated',
						),

						array(
							'type' => 'html',
							'html' => '</div><div class="modalbox-card modalbox-card-style modalbox-re_render modalbox-card-style-mfnuidhere">',
						),

						array(
							'class' => 'toggled_header',
   						'title' => __('Container', 'mfn-opts'),
   					),

						array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement ul.clients li .client_wrapper:height',
							'type' => 'text',
							'default_unit' => 'px',
							'class' => 'mfn-toggled',
							'title' => __('Height', 'mfn-opts'),
						),

						array(
		  				'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement ul.clients li .client_wrapper:padding',
		  				'type' => 'dimensions',
		  				'title' => __('Padding', 'mfn-opts'),
							'responsive' => 'desktop',
							'version' => 'separated-fields',
							'class' => 'mfn_field_desktop mfn-toggled',
							'css_attr' => 'padding',
		  			),

		  			array(
		  				'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement ul.clients li .client_wrapper:padding_tablet',
		  				'type' => 'dimensions',
		  				'title' => __('Padding', 'mfn-opts'),
							'responsive' => 'tablet',
							'version' => 'separated-fields',
							'class' => 'mfn_field_tablet mfn-toggled',
							'css_attr' => 'padding',
		  			),

		  			array(
		  				'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement ul.clients li .client_wrapper:padding_mobile',
		  				'type' => 'dimensions',
		  				'title' => __('Padding', 'mfn-opts'),
							'responsive' => 'mobile',
							'version' => 'separated-fields',
							'class' => 'mfn_field_mobile mfn-toggled',
							'css_attr' => 'padding',
		  			),

		  			array(
							'type' => 'html',
							'html' => '<div class="mfn-form-row mfn-sidebar-fields-tabs mfn-toggled mfn-vb-formrow mfn-vb-mfnuidhere"><ul class="mfn-sft-nav"><li class="active"><a href="#normal" data-tab="normal">Normal</a></li><li><a href="#hover" data-tab="hover">Hover</a></li></ul><div class="mfn-sft mfn-sft-normal">',
						),

		  			array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement ul.clients li .client_wrapper:background-color',
							'type' => 'color',
							'title' => __('Background', 'mfn-opts'),
						),

						array(
							'type' => 'html',
							'html' => '</div><div class="mfn-sft mfn-sft-hover">',
						),

						array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement ul.clients li .client_wrapper|hover:background-color',
							'type' => 'color',
							'title' => __('Background', 'mfn-opts'),
						),

						array(
							'type' => 'html',
							'html' => '</div></div>',
						),

						array(
							'class' => 'toggled_header',
   						'title' => __('Style tiles', 'mfn-opts'),
   					),

						array(
							'type' => 'html',
							'html' => '<div class="mfn-form-row mfn-sidebar-fields-tabs mfn-toggled mfn-vb-formrow mfn-vb-mfnuidhere"><ul class="mfn-sft-nav"><li class="active"><a href="#tilenormal" data-tab="tilenormal">Normal</a></li><li><a href="#tilehover" data-tab="tilehover">Hover</a></li></ul><div class="mfn-sft mfn-sft-tilenormal">',
						),

						array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement ul.clients.clients_tiles:--mfn-clients-tiles',
							'type' => 'color',
							'title' => __('Color', 'mfn-opts'),
						),

						array(
							'type' => 'html',
							'html' => '</div><div class="mfn-sft mfn-sft-tilehover">',
						),

						array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement ul.clients.clients_tiles:--mfn-clients-tiles-hover',
							'type' => 'color',
							'title' => __('Color', 'mfn-opts'),
						),

						array(
							'type' => 'html',
							'html' => '</div></div>',
						),

						array(
							'type' => 'html',
							'html' => '</div>',
						),

   				),
   			),

   			// Clients Slider -------------------------------------------------

   			'clients_slider' => array(
   				'type' => 'clients_slider',
   				'title' => __('Clients Slider', 'mfn-opts'),
   				'size' => '1/1',
   				'tablet_size' => '1/1',
   				'mobile_size' => '1/1',
   				'tablet_resized' => '0',
   				'cat' => 'loops',
   				'fields' => array(

   					array(
							'type' => 'html',
							'html' => $this->itemtabs,
						),

   					array(
							'type' => 'html',
							'html' => '<div class="modalbox-card modalbox-re_render modalbox-card-content-mfnuidhere active">',
						),

   					array(
   						'id' => 'title',
   						'type' => 'text',
   						'edit_tag' => '.blog_slider_header | .title',
   						'edit_position' => 'append',
   						'title' => __('Title', 'mfn-opts'),
							'std' => __('This is the title', 'mfn-opts'),
							'preview' => 'title',
   					),

						// options

   					array(
   						'title' => __('Options', 'mfn-opts'),
   					),

   					array(
   						'id' => 'category',
   						'type' => 'select',
   						're_render' => 'standard',
   						'title' => __('Category', 'mfn-opts'),
   						'options' => mfn_get_categories('client-types'),
							'preview' => 'category',
   					),

   					array(
   						'id' => 'orderby',
   						'type' => 'switch',
   						're_render' => 'standard',
   						'title' => __('Order by', 'mfn-opts'),
   						'options' => array(
   							'date' => __('Date', 'mfn-opts'),
   							'menu_order' => __('Menu order', 'mfn-opts'),
   							'title' => __('Title', 'mfn-opts'),
   							'rand' => __('Random', 'mfn-opts'),
   						),
   						'std' => 'menu_order'
   					),

   					array(
   						'id' => 'order',
   						'type' => 'switch',
   						're_render' => 'standard',
   						'title' => __('Order', 'mfn-opts'),
   						'options' => array(
								'DESC' => __('Descending', 'mfn-opts'),
   							'ASC' => __('Ascending', 'mfn-opts'),
   						),
   						'std' => 'ASC'
   					),

						// deprecated

						array(
							'class' => 'mfn-deprecated',
							'title' => __('Deprecated', 'mfn-opts'),
						),

						array(
							'id' => 'class',
							'type' => 'pills',
							'title' => __('Element classes', 'mfn-opts'),
							'class' => 'mfn-deprecated',
						),

						// custom

   					array(
							'type' => 'html',
							'html' => '</div><div class="modalbox-card modalbox-card-style modalbox-re_render modalbox-card-style-mfnuidhere">',
						),

						array(
							'class' => 'toggled_header',
   						'title' => __('Item title', 'mfn-opts'),
   					),

   					array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .blog_slider_header .title:color',
							'type' => 'color',
							'class' => 'main-color mfn-toggled',
							'title' => __('Color', 'mfn-opts'),
						),

						array(
		  				'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .blog_slider_header .title:margin',
		  				'type' => 'dimensions',
		  				'version' => 'separated-fields',
		  				'title' => __('Margin', 'mfn-opts'),
							'responsive' => 'desktop',
							'class' => 'mfn_field_desktop mfn-toggled',
							'css_attr' => 'margin',
		  			),

		  			array(
		  				'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .blog_slider_header .title:margin_tablet',
		  				'type' => 'dimensions',
		  				'version' => 'separated-fields',
		  				'title' => __('Margin', 'mfn-opts'),
							'responsive' => 'tablet',
							'class' => 'mfn_field_tablet mfn-toggled',
							'css_attr' => 'margin',
		  			),

		  			array(
		  				'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .blog_slider_header .title:margin_mobile',
		  				'type' => 'dimensions',
		  				'version' => 'separated-fields',
		  				'title' => __('Margin', 'mfn-opts'),
							'responsive' => 'mobile',
							'class' => 'mfn_field_mobile mfn-toggled',
							'css_attr' => 'margin',
		  			),

		  			array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .blog_slider_header .title:typography',
							'type' => 'typography_vb',
							'label_after' => '<a href="#" title="Edit" class="mfn-option-btn mfn-option-blank btn-medium mfn-vb-label-button"><span class="mfn-icon mfn-icon-edit"></span></a>',
							'class' => 'mfn-toggled toggle_fields',
							'title' => __('Typography', 'mfn-opts'),
						),

						array(
							'class' => 'toggled_header',
   						'title' => __('Container', 'mfn-opts'),
   					),

						array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .clients_slider_ul li .client_wrapper:height',
							'type' => 'text',
							'default_unit' => 'px',
							'class' => 'mfn-toggled',
							'title' => __('Height', 'mfn-opts'),
						),

						array(
		  				'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .clients_slider_ul li .client_wrapper:padding',
		  				'type' => 'dimensions',
		  				'title' => __('Padding', 'mfn-opts'),
							'responsive' => 'desktop',
							'version' => 'separated-fields',
							'class' => 'mfn_field_desktop mfn-toggled',
							'css_attr' => 'padding',
		  			),

		  			array(
		  				'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .clients_slider_ul li .client_wrapper:padding_tablet',
		  				'type' => 'dimensions',
		  				'title' => __('Padding', 'mfn-opts'),
							'responsive' => 'tablet',
							'version' => 'separated-fields',
							'class' => 'mfn_field_tablet mfn-toggled',
							'css_attr' => 'padding',
		  			),

		  			array(
		  				'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .clients_slider_ul li .client_wrapper:padding_mobile',
		  				'type' => 'dimensions',
		  				'title' => __('Padding', 'mfn-opts'),
							'responsive' => 'mobile',
							'version' => 'separated-fields',
							'class' => 'mfn_field_mobile mfn-toggled',
							'css_attr' => 'padding',
		  			),

		  			array(
							'type' => 'html',
							'html' => '<div class="mfn-form-row mfn-sidebar-fields-tabs mfn-toggled mfn-vb-formrow mfn-vb-mfnuidhere"><ul class="mfn-sft-nav"><li class="active"><a href="#normal" data-tab="normal">Normal</a></li><li><a href="#hover" data-tab="hover">Hover</a></li></ul><div class="mfn-sft mfn-sft-normal">',
						),

		  			array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .clients_slider_ul li .client_wrapper:background-color',
							'type' => 'color',
							'class' => 'mfn-toggled',
							'title' => __('Background', 'mfn-opts'),
						),

						array(
							'type' => 'html',
							'html' => '</div><div class="mfn-sft mfn-sft-hover">',
						),

						array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .clients_slider_ul li .client_wrapper|hover:background-color',
							'type' => 'color',
							'class' => 'mfn-toggled',
							'title' => __('Background', 'mfn-opts'),
						),

						array(
							'type' => 'html',
							'html' => '</div></div>',
						),

						array(
							'class' => 'toggled_header',
   						'title' => __('Button', 'mfn-opts'),
   					),

		  			array(
		  				'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .clients_slider .button:padding',
		  				'type' => 'dimensions',
		  				'version' => 'separated-fields',
		  				'title' => __('Padding', 'mfn-opts'),
							'responsive' => 'desktop',
							'class' => 'mfn_field_desktop mfn-toggled',
							'css_attr' => 'padding',
		  			),

		  			array(
		  				'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .clients_slider .button:padding_tablet',
		  				'type' => 'dimensions',
		  				'version' => 'separated-fields',
		  				'title' => __('Padding', 'mfn-opts'),
							'responsive' => 'tablet',
							'class' => 'mfn_field_tablet mfn-toggled',
							'css_attr' => 'padding',
		  			),

		  			array(
		  				'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .clients_slider .button:padding_mobile',
		  				'type' => 'dimensions',
		  				'version' => 'separated-fields',
		  				'title' => __('Padding', 'mfn-opts'),
							'responsive' => 'mobile',
							'class' => 'mfn_field_mobile mfn-toggled',
							'css_attr' => 'padding',
		  			),

		  			array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .clients_slider .button:typography',
							'type' => 'typography_vb',
							'label_after' => '<a href="#" title="Edit" class="mfn-option-btn mfn-option-blank btn-medium mfn-vb-label-button"><span class="mfn-icon mfn-icon-edit"></span></a>',
							'class' => 'mfn-toggled toggle_fields',
							'title' => __('Typography', 'mfn-opts'),
						),

						array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .clients_slider .button:border-style',
							'attr_id' => 'border_style',
							'type' => 'select',
							'class' => 'mfn-toggled',
							'title' => __('Border style', 'mfn-opts'),
							'options' => [
								'none' => __('None', 'mfn-opts'),
								'solid' => __('Solid', 'mfn-opts'),
								'dashed' => __('Dashed', 'mfn-opts'),
								'dotted' => __('Dotted', 'mfn-opts'),
								'double' => __('Double', 'mfn-opts'),
							],
						),

						array(
		  				'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .clients_slider .button:border-width',
		  				'condition' => array( 'id' => 'border_style', 'opt' => 'isnt', 'val' => 'none' ),
		  				'type' => 'dimensions',
		  				'title' => __('Border width', 'mfn-opts'),
							'responsive' => 'desktop',
							'class' => 'mfn_field_desktop mfn-toggled',
							'css_attr' => 'border-width',
		  			),

		  			array(
		  				'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .clients_slider .button:border-width_tablet',
		  				'condition' => array( 'id' => 'border_style', 'opt' => 'isnt', 'val' => 'none' ),
		  				'type' => 'dimensions',
		  				'title' => __('Border width', 'mfn-opts'),
							'responsive' => 'tablet',
							'class' => 'mfn_field_tablet mfn-toggled',
							'css_attr' => 'border-width',
		  			),

		  			array(
		  				'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .clients_slider .button:border-width_mobile',
		  				'condition' => array( 'id' => 'border_style', 'opt' => 'isnt', 'val' => 'none' ),
		  				'type' => 'dimensions',
		  				'title' => __('Border width', 'mfn-opts'),
							'responsive' => 'mobile',
							'class' => 'mfn_field_mobile mfn-toggled',
							'css_attr' => 'border-width',
		  			),

						array(
		  				'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .clients_slider .button:border-radius',
		  				'type' => 'dimensions',
		  				'title' => __('Border radius', 'mfn-opts'),
							'responsive' => 'desktop',
							'class' => 'mfn_field_desktop mfn-toggled',
							'css_attr' => 'border-radius',
		  			),

		  			array(
		  				'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .clients_slider .button:border-radius_tablet',
		  				'type' => 'dimensions',
		  				'title' => __('Border radius', 'mfn-opts'),
							'responsive' => 'tablet',
							'class' => 'mfn_field_tablet mfn-toggled',
							'css_attr' => 'border-radius',
		  			),

		  			array(
		  				'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .clients_slider .button:border-radius_mobile',
		  				'type' => 'dimensions',
		  				'title' => __('Border radius', 'mfn-opts'),
							'responsive' => 'mobile',
							'class' => 'mfn_field_mobile mfn-toggled',
							'css_attr' => 'border-radius',
		  			),

   					array(
							'type' => 'html',
							'html' => '<div class="mfn-form-row mfn-sidebar-fields-tabs mfn-toggled mfn-vb-formrow mfn-vb-mfnuidhere"><ul class="mfn-sft-nav"><li class="active"><a href="#normal" data-tab="normal">Normal</a></li><li><a href="#hover" data-tab="hover">Hover</a></li></ul><div class="mfn-sft mfn-sft-normal">',
						),

						array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .clients_slider .button .button_icon i:color',
							'type' => 'color',
							'class' => 'main-color mfn-toggled',
							'title' => __('Color', 'mfn-opts'),
						),

						array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .clients_slider .button:border-color',
							'condition' => array( 'id' => 'border_style', 'opt' => 'isnt', 'val' => 'none' ),
							'type' => 'color',
							'class' => 'mfn-toggled',
							'title' => __('Border color', 'mfn-opts'),
						),

						array(
							'id' => 'background_switcher',
							'attr_id' => 'background_switcher',
							'type' => 'switch',
							'class' => 'mfn-fields-switcher',
							'title' => __('Background type', 'mfn-opts'),
							'options' => array(
		  					'default' => __('Default', 'mfn-opts'),
		  					'gradient' 	=> __('Gradient', 'mfn-opts'),
		  				),
							'visual_options' => array(
		  					'default' => '',
		  					'gradient' 	=> '',
		  				),
		  				'std' => 'default',
						),

						array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .clients_slider .button:background-color',
							'condition' => array( 'id' => 'background_switcher', 'opt' => 'is', 'val' => 'default' ),
							'type' => 'color',
							'title' => __('Background color', 'mfn-opts'),
						),

						array(
		  				'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .clients_slider .button:gradient',
		  				'condition' => array( 'id' => 'background_switcher', 'opt' => 'is', 'val' => 'gradient' ),
		  				'type' => 'gradient',
		  				'title' => __('Gradient', 'mfn-opts'),
		  				'class' => 'mfn-toggled',
							'css_attr' => 'gradient',
		  			),

						array(
							'type' => 'html',
							'html' => '</div><div class="mfn-sft mfn-sft-hover">',
						),

						array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .clients_slider .button|hover:color',
							'type' => 'color',
							'class' => 'main-color mfn-toggled',
							'title' => __('Color', 'mfn-opts'),
						),

						array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .clients_slider .button|hover:border-color',
							'condition' => array( 'id' => 'border_style', 'opt' => 'isnt', 'val' => 'none' ),
							'type' => 'color',
							'class' => 'mfn-toggled',
							'title' => __('Border color', 'mfn-opts'),
						),

						array(
							'id' => 'background_switcher_hover',
							'attr_id' => 'background_switcher_hover',
							'type' => 'switch',
							'class' => 'mfn-fields-switcher',
							'title' => __('Background type', 'mfn-opts'),
							'options' => array(
		  					'default' => __('Default', 'mfn-opts'),
		  					'gradient' 	=> __('Gradient', 'mfn-opts'),
		  				),
							'visual_options' => array(
		  					'default' => '',
		  					'gradient' 	=> '',
		  				),
		  				'std' => 'default',
						),

						array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .clients_slider .button|hover:background',
							'condition' => array( 'id' => 'background_switcher_hover', 'opt' => 'is', 'val' => 'default' ),
							'type' => 'color',
							'class' => 'main-color mfn-toggled',
							'title' => __('Background color', 'mfn-opts'),
						),

						array(
		  				'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .clients_slider .button|hover:gradient',
		  				'condition' => array( 'id' => 'background_switcher_hover', 'opt' => 'is', 'val' => 'gradient' ),
		  				'type' => 'gradient',
		  				'title' => __('Gradient', 'mfn-opts'),
		  				'class' => 'mfn-toggled',
							'css_attr' => 'gradient',
		  			),

						array(
							'type' => 'html',
							'html' => '</div></div>',
						),

						array(
							'type' => 'html',
							'html' => '</div>',
						),

   				),
   			),

   			// Code  ----------------------------------------------------------

   			'code' => array(
   				'type' => 'code',
   				'title' => __('Code', 'mfn-opts'),
   				'size' => '1/4',
   				'tablet_size' => '1/4',
   				'mobile_size' => '1/1',
   				'tablet_resized' => '0',
   				'cat' => 'other',
   				'fields' => array(

   					array(
							'type' => 'html',
							'html' => '<div class="modalbox-card modalbox-re_render modalbox-card-content-mfnuidhere active">',
						),

   					array(
   						'id' => 'content',
   						'type' => 'textarea',
   						'edit_tag' => '.mcb-item-code-inner | pre.mfn-code',
   						'edit_position' => 'append',
   						'title' => __('Content', 'mfn-opts'),
   						'std' => 'Lorem ipsum dolor sit amet, consectetur adipiscing elit.',
							'class' => 'form-content-full-width',
   					),

						// deprecated

						array(
							'class' => 'mfn-deprecated',
							'title' => __('Deprecated', 'mfn-opts'),
						),

						array(
							'id' => 'class',
							'type' => 'pills',
							'title' => __('Element classes', 'mfn-opts'),
							'class' => 'mfn-deprecated',
						),

						array(
							'type' => 'html',
							'html' => '</div>',
						),

   				),
   			),

   			// Column  --------------------------------------------------------

   			'column' => array(
   				'type' => 'column',
   				'title' => __('Column Text', 'mfn-opts'),
   				'size' => '1/4',
   				'tablet_size' => '1/4',
   				'mobile_size' => '1/1',
   				'tablet_resized' => '0',
   				'used_fonts' => '',
   				'cat' => 'typography',
   				'fields' => array(

						// HTML content

						array(
							'type' => 'html',
							'html' => $this->itemtabs,
						),

   					array(
							'type' => 'html',
							'html' => '<div class="modalbox-card modalbox-re_render modalbox-card-content-mfnuidhere active">',
						),

   					array(
   						'id' => 'content',
   						'type' => $this->get_column_editor(), // textarea, visual
   						'title' => __('Content', 'mfn-opts'),
   						'class' => 'form-content-full-width',
							'editor' => 'full', // basic (bold, i, etc), full (media, shortcodes)
							'preview' => 'content',
							'vbstd' => '<p>Lorem ipsum dolor sit amet, consectetur adipiscing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation ullamco laboris nisi ut aliquip ex ea commodo consequat. Duis aute irure dolor in reprehenderit in voluptate velit esse cillum dolore eu fugiat nulla pariatur. Excepteur sint occaecat cupidatat non proident, sunt in culpa qui officia deserunt mollit anim id est laborum.</p>',
   					),

						array(
							'type' => 'html',
							'html' => '</div><div class="modalbox-card modalbox-card-style modalbox-re_render modalbox-card-style-mfnuidhere">',
						),

						array(
							'id' => 'title',
							'type' => 'text',
							'title' => __('Label', 'mfn-opts'),
							'desc' => __('This field is only used as label in the builder', 'mfn-opts'),
							'preview' => 'title',
							'class' => 'mfn-hidden-form-row',
						),

						array(
   						'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .column_attr:text-align',
							'responsive' => 'desktop',
   						'type' => 'switch',
   						'class' => 'mfn_field_desktop',
   						'title' => __('Text align', 'mfn-opts'),
   						'options' => array(
   							'' => __('Default', 'mfn-opts'),
   							'left' => __('Left', 'mfn-opts'),
								'center' => __('Center', 'mfn-opts'),
   							'right' => __('Right', 'mfn-opts'),
   							'justify' => __('Justify', 'mfn-opts'),
   						),
							'preview' => 'align',
   					),
   					array(
   						'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .column_attr:text-align_tablet',
							'responsive' => 'tablet',
   						'type' => 'switch',
   						'class' => 'mfn_field_tablet',
   						'title' => __('Text align', 'mfn-opts'),
   						'options' => array(
   							'' => __('Default', 'mfn-opts'),
   							'left' => __('Left', 'mfn-opts'),
								'center' => __('Center', 'mfn-opts'),
   							'right' => __('Right', 'mfn-opts'),
   							'justify' => __('Justify', 'mfn-opts'),
   						),
							'preview' => 'align',
   					),
   					array(
   						'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .column_attr:text-align_mobile',
							'responsive' => 'mobile',
   						'type' => 'switch',
   						'class' => 'mfn_field_mobile',
   						'title' => __('Text align', 'mfn-opts'),
   						'options' => array(
   							'' => __('Default', 'mfn-opts'),
   							'left' => __('Left', 'mfn-opts'),
								'center' => __('Center', 'mfn-opts'),
   							'right' => __('Right', 'mfn-opts'),
   							'justify' => __('Justify', 'mfn-opts'),
   						),
							'preview' => 'align',
   					),

   					array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .column_attr:color',
							'type' => 'color',
							'desc' => __('May be overwritten by individual tags or inline CSS', 'mfn-opts'),
							'title' => __('Color', 'mfn-opts'),
						),

						array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .column_attr:text-shadow',
							'type' => 'text_shadow',
							'title' => __('Text shadow', 'mfn-opts'),
						),

   					array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .column_attr:typography',
							'type' => 'typography_vb',
							'label_after' => '<a href="#" title="Edit" class="mfn-option-btn mfn-option-blank btn-medium mfn-vb-label-button"><span class="mfn-icon mfn-icon-edit"></span></a>',
							'class' => 'toggle_fields',
							'title' => __('Typography', 'mfn-opts'),
						),

						// deprecated

						array(
							'class' => 'mfn-deprecated',
   						'title' => __('Deprecated', 'mfn-opts'),
   					),

   					array(
   						'id' => 'align',
   						'class' => 'mfn-deprecated',
   						'type' => 'switch',
   						'title' => __('Text align', 'mfn-opts'),
   						'options' => array(
   							'' => __('Default', 'mfn-opts'),
   							'left' => __('Left', 'mfn-opts'),
								'center' => __('Center', 'mfn-opts'),
   							'right' => __('Right', 'mfn-opts'),
   							'justify' => __('Justify', 'mfn-opts'),
   						),
							'preview' => 'align',
   					),

   					array(
   						'id' => 'align-mobile',
   						'class' => 'mfn-deprecated',
   						'type' => 'switch',
   						'title' => __('Mobile text align', 'mfn-opts'),
   						'options' => array(
   							'' => __('As above', 'mfn-opts'),
   							'left' => __('Left', 'mfn-opts'),
								'center' => __('Center', 'mfn-opts'),
   							'right' => __('Right', 'mfn-opts'),
   							'justify' => __('Justify', 'mfn-opts'),
   						),
   					),

   					array(
   						'id' => 'column_bg',
   						'class' => 'mfn-deprecated',
   						'type' => 'color',
   						'title' => __('Background color', 'mfn-opts'),
   						'alpha' => true,
   					),

   					array(
   						'id' => 'bg_image',
   						'class' => 'mfn-deprecated',
   						'type' => 'upload',
   						'title' => __('Background image', 'mfn-opts'),
   					),

   					array(
   						'id' => 'bg_position',
   						'class' => 'mfn-deprecated',
   						'type' => 'select',
   						'title' => __('Background position', 'mfn-opts'),
   						'options' => mfna_bg_position('column'),
   						'std' => 'center top no-repeat',
   					),

   					array(
   						'id' => 'bg_size',
   						'class' => 'mfn-deprecated',
   						'type' => 'select',
   						'title' => __('Background size', 'mfn-opts'),
   						'options' => mfna_bg_size(),
   					),

   					array(
   						'id' => 'margin_bottom',
   						'class' => 'mfn-deprecated',
   						'type' => 'select',
   						'title' => __('Margin bottom', 'mfn-opts'),
   						'options' => array(
   							'' => __('- Default -', 'mfn-opts'),
   							'0px' => '0px',
   							'10px' => '10px',
   							'20px' => '20px',
   							'30px' => '30px',
   							'40px' => '40px',
   							'50px' => '50px',
   						),
   					),

   					array(
   						'id' => 'padding',
   						'class' => 'mfn-deprecated',
   						'type' => 'text',
   						'title' => __('Padding', 'mfn-opts'),
   						'desc' => __('Use value with <b>px</b> or <b>%</b>. Example: <b>20px</b> or <b>20px 10px 20px 10px</b> or <b>20px 1%</b>', 'mfn-opts'),
   					),

						array(
							'id' => 'class',
							'type' => 'pills',
							'title' => __('Element classes', 'mfn-opts'),
							'class' => 'mfn-deprecated',
						),

						array(
							'id' => 'style',
							'type' => 'textarea',
							'title' => __('Column inline CSS', 'mfn-opts'),
							'desc' => __('Example: <b>border: 1px solid #999;</b>', 'mfn-opts'),
							'class' => 'mfn-deprecated',
						),

						// HTML end: settings

						array(
   						'type' => 'html',
   						'html' => '</div>',
   					),

   				),
   			),

   			// Contact box ----------------------------------------------------

   			'contact_box' => array(
   				'type' => 'contact_box',
   				'title' => __('Contact Box', 'mfn-opts'),
   				'size' => '1/4',
   				'tablet_size' => '1/4',
   				'mobile_size' => '1/1',
   				'tablet_resized' => '0',
   				'cat' => 'elements',
   				'fields' => array(

   					array(
							'type' => 'html',
							'html' => $this->itemtabs,
						),

   					array(
							'type' => 'html',
							'html' => '<div class="modalbox-card modalbox-re_render modalbox-card-content-mfnuidhere active">',
						),

   					array(
   						'id' => 'title',
   						'type' => 'text',
   						'edit_tag' => '.get_in_touch | h3',
   						'edit_position' => 'prepend',
   						'title' => __('Title', 'mfn-opts'),
							'std' => __('This is the title', 'mfn-opts'),
							'preview' => 'title',
   					),

   					array(
   						'id' => 'address',
   						'type' => 'textarea',
   						'title' => __('Address', 'mfn-opts'),
   						'desc' => __('HTML tags allowed', 'mfn-opts'),
							'std' => 'This is the address',
							'preview' => 'content',
							'class' => 'form-content-full-width',
   					),

   					array(
   						'id' => 'telephone',
   						'type' => 'text',
   						'title' => __('Phone', 'mfn-opts'),
   					),

   					array(
   						'id' => 'telephone_2',
   						'type' => 'text',
   						'title' => __('Second phone', 'mfn-opts'),
   					),

   					array(
   						'id' => 'fax',
   						'type' => 'text',
   						'title' => __('Fax', 'mfn-opts'),
   					),

   					array(
   						'id' => 'email',
   						'type' => 'text',
   						'title' => __('Email', 'mfn-opts'),
   					),

   					array(
   						'id' => 'www',
   						'type' => 'text',
   						'title' => __('WWW', 'mfn-opts'),
   					),

						// advanced

   					array(
   						'class' => 'mfn-deprecated',
   						'title' => __('Deprecated', 'mfn-opts'),
   					),

						array(
   						'id' => 'image',
   						'class' => 'mfn-deprecated',
   						'type' => 'upload',
   						'title' => __('Background image', 'mfn-opts'),
   						'desc' => __('Recommended image width <b>768px - 1920px</b> depending on size of the item', 'mfn-opts'),
   					),

						array(
							'id' => 'class',
							'type' => 'pills',
							'title' => __('Element classes', 'mfn-opts'),
							'class' => 'mfn-deprecated',
						),

   					array(
							'type' => 'html',
							'html' => '</div><div class="modalbox-card modalbox-card-style modalbox-re_render modalbox-card-style-mfnuidhere">',
						),

						array(
							'class' => 'toggled_header',
   						'title' => __('Item title', 'mfn-opts'),
   					),

   					array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .get_in_touch h3:color',
							'type' => 'color',
							'class' => 'main-color mfn-toggled',
							'title' => __('Color', 'mfn-opts'),
						),

						array(
		  				'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .get_in_touch h3:margin',
		  				'type' => 'dimensions',
		  				'version' => 'separated-fields',
		  				'title' => __('Margin', 'mfn-opts'),
							'responsive' => 'desktop',
							'class' => 'mfn_field_desktop mfn-toggled',
							'css_attr' => 'margin',
		  			),

		  			array(
		  				'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .get_in_touch h3:margin_tablet',
		  				'type' => 'dimensions',
		  				'version' => 'separated-fields',
		  				'title' => __('Margin', 'mfn-opts'),
							'responsive' => 'tablet',
							'class' => 'mfn_field_tablet mfn-toggled',
							'css_attr' => 'margin',
		  			),

		  			array(
		  				'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .get_in_touch h3:margin_mobile',
		  				'type' => 'dimensions',
		  				'version' => 'separated-fields',
		  				'title' => __('Margin', 'mfn-opts'),
							'responsive' => 'mobile',
							'class' => 'mfn_field_mobile mfn-toggled',
							'css_attr' => 'margin',
		  			),

		  			array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .get_in_touch h3:typography',
							'type' => 'typography_vb',
							'label_after' => '<a href="#" title="Edit" class="mfn-option-btn mfn-option-blank btn-medium mfn-vb-label-button"><span class="mfn-icon mfn-icon-edit"></span></a>',
							'class' => 'mfn-toggled toggle_fields',
							'title' => __('Typography', 'mfn-opts'),
						),

						array(
							'class' => 'toggled_header',
   						'title' => __('Icon', 'mfn-opts'),
   					),

						array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .get_in_touch ul li .icon:color',
							'type' => 'color',
							'class' => 'mfn-toggled',
							'title' => __('Color', 'mfn-opts'),
						),

						array(
							'class' => 'toggled_header',
   						'title' => __('List', 'mfn-opts'),
   					),

						array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .get_in_touch .get_in_touch_wrapper ul li:color',
							'type' => 'color',
							'class' => 'mfn-toggled',
							'title' => __('Color', 'mfn-opts'),
						),

						array(
							'type' => 'html',
							'html' => '<div class="mfn-form-row mfn-sidebar-fields-tabs mfn-toggled mfn-vb-formrow mfn-vb-mfnuidhere"><ul class="mfn-sft-nav"><li class="active"><a href="#normal" data-tab="normal">Normal</a></li><li><a href="#hover" data-tab="hover">Hover</a></li></ul><div class="mfn-sft mfn-sft-normal">',
						),

						array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .get_in_touch ul li a:color',
							'type' => 'color',
							'title' => __('Links color', 'mfn-opts'),
						),

						array(
							'type' => 'html',
							'html' => '</div><div class="mfn-sft mfn-sft-hover">',
						),

						array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .get_in_touch ul li a|hover:color',
							'type' => 'color',
							'title' => __('Links color', 'mfn-opts'),
						),

						array(
							'type' => 'html',
							'html' => '</div></div>',
						),

						array(
							'class' => 'toggled_header',
   						'title' => __('Lines', 'mfn-opts'),
   					),

						array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .get_in_touch ul li:--mfn-contactbox-line',
							'type' => 'color',
							'class' => 'mfn-toggled',
							'title' => __('Line color', 'mfn-opts'),
						),

						array(
							'type' => 'html',
							'html' => '</div>',
						),

   				),
   			),

   			// Content  -------------------------------------------------------

   			'content' => array(
   				'type' => 'content',
   				'title' => __('Content WP', 'mfn-opts'),
   				'size' => '1/4',
   				'tablet_size' => '1/4',
   				'mobile_size' => '1/1',
   				'tablet_resized' => '0',
   				'cat' => 'typography',
   				'fields' => array(

   					array(
							'type' => 'html',
							'html' => '<div class="modalbox-card modalbox-re_render modalbox-card-content-mfnuidhere active">',
						),

   					array(
							'id' => 'info',
   						'type' => 'info',
   						'title' => __('Content from WordPress editor. Can be used once per page.', 'mfn-opts'),
   					),

						array(
							'type' => 'html',
							'html' => '</div>',
						),

   				),
   			),

   			// Countdown  -----------------------------------------------------

   			'countdown' => array(
   				'type' => 'countdown',
   				'title' => __('Countdown', 'mfn-opts'),
   				'size' => '1/1',
   				'tablet_size' => '1/1',
   				'mobile_size' => '1/1',
   				'tablet_resized' => '0',
   				'cat' => 'boxes',
   				'fields' => array(

   					array(
							'type' => 'html',
							'html' => $this->itemtabs,
						),

   					array(
							'type' => 'html',
							'html' => '<div class="modalbox-card modalbox-re_render modalbox-card-content-mfnuidhere active">',
						),

   					array(
   						'id' => 'date',
   						'type' => 'text',
   						're_render' => 'standard',
   						'title' => __('Launch date', 'mfn-opts'),
   						'desc' => __('month/day/year hour:minute:second', 'mfn-opts'),
   						'std' => '12/30/2022 12:00:00',
							'preview' => 'title',
   					),

   					array(
   						'id' => 'timezone',
   						'type' => 'select',
   						're_render' => 'standard',
   						'title' => __('Timezone', 'mfn-opts'),
   						'options' => mfna_utc(),
   						'std' => '0',
   					),

   					// options

   					array(
   						'title' => __('Options', 'mfn-opts'),
   					),

   					array(
   						'id' => 'show',
   						're_render' => 'standard',
   						'type' => 'select',
   						'title' => __('Show', 'mfn-opts'),
   						'options' => array(
   							'' => __('days hours minutes seconds', 'mfn-opts'),
   							'dhm' => __('days hours minutes', 'mfn-opts'),
   							'dh' => __('days hours', 'mfn-opts'),
   							'd' => __('days', 'mfn-opts'),
   						),
   					),

						// deprecated

						array(
							'class' => 'mfn-deprecated',
							'title' => __('Deprecated', 'mfn-opts'),
						),

						array(
							'id' => 'class',
							'type' => 'pills',
							'title' => __('Element classes', 'mfn-opts'),
							'class' => 'mfn-deprecated',
						),

   					array(
							'type' => 'html',
							'html' => '</div><div class="modalbox-card modalbox-card-style modalbox-re_render modalbox-card-style-mfnuidhere">',
						),

   					array(
							'class' => 'toggled_header',
   						'title' => __('Container', 'mfn-opts'),
   					),

   					array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .downcount .column .quick_fact:background-color',
							'type' => 'color',
							'class' => 'mfn-toggled',
							'title' => __('Background', 'mfn-opts'),
						),

						array(
		  				'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .downcount .column .quick_fact:margin',
		  				'type' => 'dimensions',
		  				'version' => 'separated-fields',
		  				'title' => __('Margin', 'mfn-opts'),
							'responsive' => 'desktop',
							'class' => 'mfn_field_desktop mfn-toggled',
							'css_attr' => 'margin',
		  			),

		  			array(
		  				'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .downcount .column .quick_fact:margin_tablet',
		  				'type' => 'dimensions',
		  				'version' => 'separated-fields',
		  				'title' => __('Margin', 'mfn-opts'),
							'responsive' => 'tablet',
							'class' => 'mfn_field_tablet mfn-toggled',
							'css_attr' => 'margin',
		  			),

		  			array(
		  				'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .downcount .column .quick_fact:margin_mobile',
		  				'type' => 'dimensions',
		  				'version' => 'separated-fields',
		  				'title' => __('Margin', 'mfn-opts'),
							'responsive' => 'mobile',
							'class' => 'mfn_field_mobile mfn-toggled',
							'css_attr' => 'margin',
		  			),

		  			array(
		  				'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .downcount .column .quick_fact:padding',
		  				'type' => 'dimensions',
		  				'version' => 'separated-fields',
		  				'title' => __('Padding', 'mfn-opts'),
							'responsive' => 'desktop',
							'class' => 'mfn_field_desktop mfn-toggled',
							'css_attr' => 'padding',
		  			),

		  			array(
		  				'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .downcount .column .quick_fact:padding_tablet',
		  				'type' => 'dimensions',
		  				'version' => 'separated-fields',
		  				'title' => __('Padding', 'mfn-opts'),
							'responsive' => 'tablet',
							'class' => 'mfn_field_tablet mfn-toggled',
							'css_attr' => 'padding',
		  			),

		  			array(
		  				'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .downcount .column .quick_fact:padding_mobile',
		  				'type' => 'dimensions',
		  				'version' => 'separated-fields',
		  				'title' => __('Padding', 'mfn-opts'),
							'responsive' => 'mobile',
							'class' => 'mfn_field_mobile mfn-toggled',
							'css_attr' => 'padding',
		  			),

		  			array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .downcount .column .quick_fact:border-style',
							'attr_id' => 'border_style',
							'type' => 'select',
							'class' => 'mfn-toggled',
							'title' => __('Border style', 'mfn-opts'),
							'options' => [
								'none' => __('None', 'mfn-opts'),
								'solid' => __('Solid', 'mfn-opts'),
								'dashed' => __('Dashed', 'mfn-opts'),
								'dotted' => __('Dotted', 'mfn-opts'),
								'double' => __('Double', 'mfn-opts'),
							],
						),

						array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .downcount .column .quick_fact:border-color',
							'condition' => array( 'id' => 'border_style', 'opt' => 'isnt', 'val' => 'none' ),
							'type' => 'color',
							'class' => 'mfn-toggled',
							'title' => __('Border color', 'mfn-opts'),
						),

						array(
		  				'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .downcount .column .quick_fact:border-width',
		  				'condition' => array( 'id' => 'border_style', 'opt' => 'isnt', 'val' => 'none' ),
		  				'type' => 'dimensions',
		  				'title' => __('Border width', 'mfn-opts'),
							'responsive' => 'desktop',
							'class' => 'mfn_field_desktop mfn-toggled',
							'css_attr' => 'border-width',
		  			),

		  			array(
		  				'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .downcount .column .quick_fact:border-width_tablet',
		  				'condition' => array( 'id' => 'border_style', 'opt' => 'isnt', 'val' => 'none' ),
		  				'type' => 'dimensions',
		  				'title' => __('Border width', 'mfn-opts'),
							'responsive' => 'tablet',
							'class' => 'mfn_field_tablet mfn-toggled',
							'css_attr' => 'border-width',
		  			),

		  			array(
		  				'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .downcount .column .quick_fact:border-width_mobile',
		  				'condition' => array( 'id' => 'border_style', 'opt' => 'isnt', 'val' => 'none' ),
		  				'type' => 'dimensions',
		  				'title' => __('Border width', 'mfn-opts'),
							'responsive' => 'mobile',
							'class' => 'mfn_field_mobile mfn-toggled',
							'css_attr' => 'border-width',
		  			),

						array(
		  				'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .downcount .column .quick_fact:border-radius',
		  				'type' => 'dimensions',
		  				'title' => __('Border radius', 'mfn-opts'),
							'responsive' => 'desktop',
							'class' => 'mfn_field_desktop mfn-toggled',
							'css_attr' => 'border-radius',
		  			),

		  			array(
		  				'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .downcount .column .quick_fact:border-radius_tablet',
		  				'type' => 'dimensions',
		  				'title' => __('Border radius', 'mfn-opts'),
							'responsive' => 'tablet',
							'class' => 'mfn_field_tablet mfn-toggled',
							'css_attr' => 'border-radius',
		  			),

		  			array(
		  				'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .downcount .column .quick_fact:border-radius_mobile',
		  				'type' => 'dimensions',
		  				'title' => __('Border radius', 'mfn-opts'),
							'responsive' => 'mobile',
							'class' => 'mfn_field_mobile mfn-toggled',
							'css_attr' => 'border-radius',
		  			),

		  			array(
							'class' => 'toggled_header',
   						'title' => __('Number', 'mfn-opts'),
   					),

   					array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .downcount .column .quick_fact .number-wrapper .number:color',
							'type' => 'color',
							'class' => 'mfn-toggled',
							'title' => __('Color', 'mfn-opts'),
						),

						array(
		  				'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .downcount .column .quick_fact .number-wrapper:margin',
		  				'type' => 'dimensions',
		  				'version' => 'separated-fields',
		  				'title' => __('Margin', 'mfn-opts'),
							'responsive' => 'desktop',
							'class' => 'mfn_field_desktop mfn-toggled',
							'css_attr' => 'margin',
		  			),

		  			array(
		  				'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .downcount .column .quick_fact .number-wrapper:margin_tablet',
		  				'type' => 'dimensions',
		  				'version' => 'separated-fields',
		  				'title' => __('Margin', 'mfn-opts'),
							'responsive' => 'tablet',
							'class' => 'mfn_field_tablet mfn-toggled',
							'css_attr' => 'margin',
		  			),

		  			array(
		  				'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .downcount .column .quick_fact .number-wrapper:margin_mobile',
		  				'type' => 'dimensions',
		  				'version' => 'separated-fields',
		  				'title' => __('Margin', 'mfn-opts'),
							'responsive' => 'mobile',
							'class' => 'mfn_field_mobile mfn-toggled',
							'css_attr' => 'margin',
		  			),

		  			array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .downcount .column .quick_fact .number-wrapper:typography',
							'type' => 'typography_vb',
							'typography' => 'simple',
							'label_after' => '<a href="#" title="Edit" class="mfn-option-btn mfn-option-blank btn-medium mfn-vb-label-button"><span class="mfn-icon mfn-icon-edit"></span></a>',
							'class' => 'mfn-toggled toggle_fields',
							'title' => __('Typography', 'mfn-opts'),
						),

   					array(
							'class' => 'toggled_header',
   						'title' => __('Label', 'mfn-opts'),
   					),

   					array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .downcount .column .quick_fact .title:color',
							'type' => 'color',
							'class' => 'mfn-toggled',
							'title' => __('Color', 'mfn-opts'),
						),

						array(
		  				'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .downcount .column .quick_fact .title:margin',
		  				'type' => 'dimensions',
		  				'version' => 'separated-fields',
		  				'title' => __('Margin', 'mfn-opts'),
							'responsive' => 'desktop',
							'class' => 'mfn_field_desktop mfn-toggled',
							'css_attr' => 'margin',
		  			),

		  			array(
		  				'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .downcount .column .quick_fact .title:margin_tablet',
		  				'type' => 'dimensions',
		  				'version' => 'separated-fields',
		  				'title' => __('Margin', 'mfn-opts'),
							'responsive' => 'tablet',
							'class' => 'mfn_field_tablet mfn-toggled',
							'css_attr' => 'margin',
		  			),

		  			array(
		  				'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .downcount .column .quick_fact .title:margin_mobile',
		  				'type' => 'dimensions',
		  				'version' => 'separated-fields',
		  				'title' => __('Margin', 'mfn-opts'),
							'responsive' => 'mobile',
							'class' => 'mfn_field_mobile mfn-toggled',
							'css_attr' => 'margin',
		  			),

		  			array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .downcount .column .quick_fact .title:typography',
							'type' => 'typography_vb',
							'typography' => 'simple',
							'label_after' => '<a href="#" title="Edit" class="mfn-option-btn mfn-option-blank btn-medium mfn-vb-label-button"><span class="mfn-icon mfn-icon-edit"></span></a>',
							'class' => 'mfn-toggled toggle_fields',
							'title' => __('Typography', 'mfn-opts'),
						),

   					array(
							'class' => 'toggled_header',
							'themeoptions' => 'style:',
   						'title' => __('Divider', 'mfn-opts'),
   					),

   					array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .downcount .column .quick_fact hr:width',
							'type' => 'text',
							'themeoptions' => 'style:',
							'default_unit' => '%',
							'class' => 'mfn-toggled',
							'title' => __('Width', 'mfn-opts'),
						),

						array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .downcount .column .quick_fact hr:background-color',
							'themeoptions' => 'style:',
							'type' => 'color',
							'class' => 'mfn-toggled',
							'title' => __('Color', 'mfn-opts'),
						),

						array(
							'type' => 'html',
							'html' => '</div>',
						),

   				),
   			),

   			// Counter  -------------------------------------------------------

   			'counter' => array(
   				'type' => 'counter',
   				'title' => __('Counter', 'mfn-opts'),
   				'size' => '1/4',
   				'tablet_size' => '1/4',
   				'mobile_size' => '1/1',
   				'tablet_resized' => '0',
   				'cat' => 'boxes',
   				'fields' => array(

   					array(
							'type' => 'html',
							'html' => $this->itemtabs,
						),

   					array(
							'type' => 'html',
							'html' => '<div class="modalbox-card modalbox-re_render modalbox-card-content-mfnuidhere active">',
						),

   					array(
   						'id' => 'title',
   						'type' => 'text',
   						'edit_tag' => '.desc_wrapper | .title',
   						'edit_position' => 'append',
   						'title' => __('Title', 'mfn-opts'),
							'std' => __('This is the title', 'mfn-opts'),
							'preview' => 'title',
   					),

   					// counter

   					array(
   						'title' => __('Counter', 'mfn-opts'),
   					),

   					array(
   						'id' => 'icon',
   						'type' => 'icon',
   						'title' => __('Icon', 'mfn-opts'),
   						'std' => 'icon-lamp',
   						'preview' => 'icon',
   					),

   					array(
   						'id' => 'image',
   						'type' => 'upload',
   						'title' => __('Image', 'mfn-opts'),
   						'desc' => __('Replaces icon if uploaded', 'mfn-opts'),
							'preview' => 'image',
   					),

   					array(
   						'id' => 'prefix',
   						'type' => 'text',
   						'title' => __('Prefix', 'mfn-opts'),
							'class' => 'narrow',
   					),

   					array(
   						'id' => 'number',
   						'type' => 'text',
   						'title' => __('Number', 'mfn-opts'),
							'param' => 'number',
							'class' => 'narrow',
							'std' => '50',
							'preview' => 'number',
   					),

   					array(
   						'id' => 'label',
   						'type' => 'text',
   						'title' => __('Postfix', 'mfn-opts'),
							'class' => 'narrow',
   					),

   					// options

   					array(
   						'title' => __('Options', 'mfn-opts'),
   					),

   					array(
   						'id' => 'type',
   						'type' => 'switch',
   						're_render' => 'standard',
   						'title' => __('Style', 'mfn-opts'),
   						'desc' => __('Vertical style works for column widths: 1/4, 1/3 & 1/2', 'mfn-opts'),
   						'options' => array(
   							'vertical' => __('Vertical', 'mfn-opts'),
								'horizontal' => __('Horizontal', 'mfn-opts'),
   						),
   						'std' => 'vertical',
   					),

						// deprecated

   					array(
   						'class' => 'mfn-deprecated',
   						'title' => __('Deprecated', 'mfn-opts'),
   					),

   					array(
   						'id' => 'color',
   						'class' => 'mfn-deprecated',
   						'type' => 'color',
   						'title' => __('Icon color', 'mfn-opts'),
   					),

						array(
							'id' => 'class',
							'type' => 'pills',
							'title' => __('Element classes', 'mfn-opts'),
							'class' => 'mfn-deprecated',
						),

		  			array(
							'type' => 'html',
							'html' => '</div><div class="modalbox-card modalbox-card-style modalbox-re_render modalbox-card-style-mfnuidhere">',
						),

						array(
							'class' => 'toggled_header',
   						'title' => __('Container', 'mfn-opts'),
   					),

						array(
   						'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .counter:text-align',
							'responsive' => 'desktop',
   						'type' => 'switch',
   						'class' => 'mfn-toggled mfn_field_desktop',
   						'title' => __('Align', 'mfn-opts'),
   						'options' => array(
   							'' => __('Default', 'mfn-opts'),
   							'left' => __('Left', 'mfn-opts'),
								'center' => __('Center', 'mfn-opts'),
   							'right' => __('Right', 'mfn-opts'),
   							'justify' => __('Justify', 'mfn-opts'),
   						),
							'preview' => 'align',
   					),

   					array(
   						'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .counter:text-align_tablet',
							'responsive' => 'tablet',
   						'type' => 'switch',
   						'class' => 'mfn-toggled mfn_field_tablet',
   						'title' => __('Align', 'mfn-opts'),
   						'options' => array(
   							'' => __('Default', 'mfn-opts'),
   							'left' => __('Left', 'mfn-opts'),
								'center' => __('Center', 'mfn-opts'),
   							'right' => __('Right', 'mfn-opts'),
   							'justify' => __('Justify', 'mfn-opts'),
   						),
							'preview' => 'align',
   					),

   					array(
   						'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .counter:text-align_mobile',
							'responsive' => 'mobile',
   						'type' => 'switch',
   						'class' => 'mfn-toggled mfn_field_mobile',
   						'title' => __('Align', 'mfn-opts'),
   						'options' => array(
   							'' => __('Default', 'mfn-opts'),
   							'left' => __('Left', 'mfn-opts'),
								'center' => __('Center', 'mfn-opts'),
   							'right' => __('Right', 'mfn-opts'),
   							'justify' => __('Justify', 'mfn-opts'),
   						),
							'preview' => 'align',
   					),

						array(
		  				'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .counter:padding',
		  				'type' => 'dimensions',
		  				'title' => __('Padding', 'mfn-opts'),
							'responsive' => 'desktop',
							'version' => 'separated-fields',
							'class' => 'mfn_field_desktop mfn-toggled',
							'css_attr' => 'padding',
		  			),

		  			array(
		  				'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .counter:padding_tablet',
		  				'type' => 'dimensions',
		  				'title' => __('Padding', 'mfn-opts'),
							'responsive' => 'tablet',
							'version' => 'separated-fields',
							'class' => 'mfn_field_tablet mfn-toggled',
							'css_attr' => 'padding',
		  			),

		  			array(
		  				'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .counter:padding_mobile',
		  				'type' => 'dimensions',
		  				'title' => __('Padding', 'mfn-opts'),
							'responsive' => 'mobile',
							'version' => 'separated-fields',
							'class' => 'mfn_field_mobile mfn-toggled',
							'css_attr' => 'padding',
		  			),

						array(
							'class' => 'toggled_header',
   						'title' => __('Icon', 'mfn-opts'),
   					),

   					array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .counter .icon_wrapper i:color',
							'type' => 'color',
							'class' => 'main-color mfn-toggled',
							'title' => __('Color', 'mfn-opts'),
						),

						array(
		  				'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .counter .icon_wrapper:margin',
		  				'type' => 'dimensions',
		  				'title' => __('Margin', 'mfn-opts'),
							'responsive' => 'desktop',
							'version' => 'separated-fields',
							'class' => 'mfn_field_desktop mfn-toggled',
							'css_attr' => 'margin',
		  			),

		  			array(
		  				'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .counter .icon_wrapper:margin_tablet',
		  				'type' => 'dimensions',
		  				'title' => __('Margin', 'mfn-opts'),
							'responsive' => 'tablet',
							'version' => 'separated-fields',
							'class' => 'mfn_field_tablet mfn-toggled',
							'css_attr' => 'margin',
		  			),

		  			array(
		  				'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .counter .icon_wrapper:margin_mobile',
		  				'type' => 'dimensions',
		  				'title' => __('Margin', 'mfn-opts'),
							'responsive' => 'mobile',
							'version' => 'separated-fields',
							'class' => 'mfn_field_mobile mfn-toggled',
							'css_attr' => 'margin',
		  			),

		  			array(
							'class' => 'toggled_header',
   						'title' => __('Image', 'mfn-opts'),
   					),

		  			array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .counter .icon_wrapper img:border-style',
							'attr_id' => 'border_style',
							'type' => 'select',
							'class' => 'mfn-toggled',
							'title' => __('Border style', 'mfn-opts'),
							'options' => [
								'none' => __('None', 'mfn-opts'),
								'solid' => __('Solid', 'mfn-opts'),
								'dashed' => __('Dashed', 'mfn-opts'),
								'dotted' => __('Dotted', 'mfn-opts'),
								'double' => __('Double', 'mfn-opts'),
							],
						),

						array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .counter .icon_wrapper img:border-color',
							'condition' => array( 'id' => 'border_style', 'opt' => 'isnt', 'val' => 'none' ),
							'type' => 'color',
							'class' => 'mfn-toggled',
							'title' => __('Border color', 'mfn-opts'),
						),

						array(
		  				'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .counter .icon_wrapper img:border-width',
		  				'condition' => array( 'id' => 'border_style', 'opt' => 'isnt', 'val' => 'none' ),
		  				'type' => 'dimensions',
		  				'title' => __('Border width', 'mfn-opts'),
							'responsive' => 'desktop',
							'class' => 'mfn_field_desktop mfn-toggled',
							'css_attr' => 'border-width',
		  			),

		  			array(
		  				'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .counter .icon_wrapper img:border-width_tablet',
		  				'condition' => array( 'id' => 'border_style', 'opt' => 'isnt', 'val' => 'none' ),
		  				'type' => 'dimensions',
		  				'title' => __('Border width', 'mfn-opts'),
							'responsive' => 'tablet',
							'class' => 'mfn_field_tablet mfn-toggled',
							'css_attr' => 'border-width',
		  			),

		  			array(
		  				'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .counter .icon_wrapper img:border-width_mobile',
		  				'condition' => array( 'id' => 'border_style', 'opt' => 'isnt', 'val' => 'none' ),
		  				'type' => 'dimensions',
		  				'title' => __('Border width', 'mfn-opts'),
							'responsive' => 'mobile',
							'class' => 'mfn_field_mobile mfn-toggled',
							'css_attr' => 'border-width',
		  			),

						array(
		  				'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .counter .icon_wrapper img:border-radius',
		  				'type' => 'dimensions',
		  				'title' => __('Border radius', 'mfn-opts'),
							'responsive' => 'desktop',
							'class' => 'mfn_field_desktop mfn-toggled',
							'css_attr' => 'border-radius',
		  			),

		  			array(
		  				'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .counter .icon_wrapper img:border-radius_tablet',
		  				'type' => 'dimensions',
		  				'title' => __('Border radius', 'mfn-opts'),
							'responsive' => 'tablet',
							'class' => 'mfn_field_tablet mfn-toggled',
							'css_attr' => 'border-radius',
		  			),

		  			array(
		  				'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .counter .icon_wrapper img:border-radius_mobile',
		  				'type' => 'dimensions',
		  				'title' => __('Border radius', 'mfn-opts'),
							'responsive' => 'mobile',
							'class' => 'mfn_field_mobile mfn-toggled',
							'css_attr' => 'border-radius',
		  			),

		  			array(
		  				'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .counter .icon_wrapper:margin',
		  				'type' => 'dimensions',
		  				'title' => __('Margin', 'mfn-opts'),
							'responsive' => 'desktop',
							'version' => 'separated-fields',
							'class' => 'mfn_field_desktop mfn-toggled',
							'css_attr' => 'margin',
		  			),

		  			array(
		  				'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .counter .icon_wrapper:margin_tablet',
		  				'type' => 'dimensions',
		  				'title' => __('Margin', 'mfn-opts'),
							'responsive' => 'tablet',
							'version' => 'separated-fields',
							'class' => 'mfn_field_tablet mfn-toggled',
							'css_attr' => 'margin',
		  			),

		  			array(
		  				'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .counter .icon_wrapper:margin_mobile',
		  				'type' => 'dimensions',
		  				'title' => __('Margin', 'mfn-opts'),
							'responsive' => 'mobile',
							'version' => 'separated-fields',
							'class' => 'mfn_field_mobile mfn-toggled',
							'css_attr' => 'margin',
		  			),

		  			array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .counter .icon_wrapper img:width',
							'type' => 'text',
							'default_unit' => 'px',
							'responsive' => 'desktop',
							'class' => 'mfn_field_desktop mfn-toggled',
							'title' => __('Width', 'mfn-opts'),
							'desc' => __('Use px, %, vw, vh or auto to set content width', 'mfn-opts'),
						),
						array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .counter .icon_wrapper img:width_tablet',
							'type' => 'text',
							'default_unit' => 'px',
							'responsive' => 'tablet',
							'class' => 'mfn_field_tablet mfn-toggled',
							'title' => __('Width', 'mfn-opts'),
							'desc' => __('Use px, %, vw, vh or auto to set content width', 'mfn-opts'),
						),
						array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .counter .icon_wrapper img:width_mobile',
							'type' => 'text',
							'default_unit' => 'px',
							'responsive' => 'mobile',
							'class' => 'mfn_field_mobile mfn-toggled',
							'title' => __('Width', 'mfn-opts'),
							'desc' => __('Use px, %, vw, vh or auto to set content width', 'mfn-opts'),
						),

						array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .counter .icon_wrapper img:height',
							'type' => 'text',
							'default_unit' => 'px',
							'responsive' => 'desktop',
							'class' => 'mfn_field_desktop mfn-toggled',
							'title' => __('Height', 'mfn-opts'),
							'desc' => __('Use px, %, vw, vh or auto to set content width', 'mfn-opts'),
						),
						array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .counter .icon_wrapper img:height_tablet',
							'type' => 'text',
							'default_unit' => 'px',
							'responsive' => 'tablet',
							'class' => 'mfn_field_tablet mfn-toggled',
							'title' => __('Height', 'mfn-opts'),
							'desc' => __('Use px, %, vw, vh or auto to set content width', 'mfn-opts'),
						),
						array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .counter .icon_wrapper img:height_mobile',
							'type' => 'text',
							'default_unit' => 'px',
							'responsive' => 'mobile',
							'class' => 'mfn_field_mobile mfn-toggled',
							'title' => __('Height', 'mfn-opts'),
							'desc' => __('Use px, %, vw, vh or auto to set content width', 'mfn-opts'),
						),

						array(
		  				'class' => 'toggled_header',
   						'title' => __('Pre', 'mfn-opts'),
   					),

   					array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .counter .number-wrapper .prefix:color',
							'type' => 'color',
							'class' => 'main-color mfn-toggled',
							'title' => __('Color', 'mfn-opts'),
						),

						array(
		  				'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .counter .number-wrapper .prefix:margin',
		  				'type' => 'dimensions',
		  				'version' => 'separated-fields',
		  				'title' => __('Margin', 'mfn-opts'),
							'responsive' => 'desktop',
							'class' => 'mfn_field_desktop mfn-toggled',
							'css_attr' => 'margin',
		  			),

		  			array(
		  				'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .counter .number-wrapper .prefix:margin_tablet',
		  				'type' => 'dimensions',
		  				'version' => 'separated-fields',
		  				'title' => __('Margin', 'mfn-opts'),
							'responsive' => 'tablet',
							'class' => 'mfn_field_tablet mfn-toggled',
							'css_attr' => 'margin',
		  			),

		  			array(
		  				'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .counter .number-wrapper .prefix:margin_mobile',
		  				'type' => 'dimensions',
		  				'version' => 'separated-fields',
		  				'title' => __('Margin', 'mfn-opts'),
							'responsive' => 'mobile',
							'class' => 'mfn_field_mobile mfn-toggled',
							'css_attr' => 'margin',
		  			),

		  			array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .counter .number-wrapper .prefix:typography',
							'type' => 'typography_vb',
							'typography' => 'simple',
							'label_after' => '<a href="#" title="Edit" class="mfn-option-btn mfn-option-blank btn-medium mfn-vb-label-button"><span class="mfn-icon mfn-icon-edit"></span></a>',
							'class' => 'mfn-toggled toggle_fields',
							'title' => __('Typography', 'mfn-opts'),
						),

						array(
		  				'class' => 'toggled_header',
   						'title' => __('Number', 'mfn-opts'),
   					),

   					array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .counter .number-wrapper .number:color',
							'type' => 'color',
							'class' => 'main-color mfn-toggled',
							'title' => __('Color', 'mfn-opts'),
						),

						array(
		  				'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .counter .number-wrapper:margin',
		  				'type' => 'dimensions',
		  				'version' => 'separated-fields',
		  				'title' => __('Margin', 'mfn-opts'),
							'responsive' => 'desktop',
							'class' => 'mfn_field_desktop mfn-toggled',
							'css_attr' => 'margin',
		  			),

		  			array(
		  				'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .counter .number-wrapper:margin_tablet',
		  				'type' => 'dimensions',
		  				'version' => 'separated-fields',
		  				'title' => __('Margin', 'mfn-opts'),
							'responsive' => 'tablet',
							'class' => 'mfn_field_tablet mfn-toggled',
							'css_attr' => 'margin',
		  			),

		  			array(
		  				'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .counter .number-wrapper:margin_mobile',
		  				'type' => 'dimensions',
		  				'version' => 'separated-fields',
		  				'title' => __('Margin', 'mfn-opts'),
							'responsive' => 'mobile',
							'class' => 'mfn_field_mobile mfn-toggled',
							'css_attr' => 'margin',
		  			),

		  			array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .counter .number-wrapper .number:typography',
							'type' => 'typography_vb',
							'label_after' => '<a href="#" title="Edit" class="mfn-option-btn mfn-option-blank btn-medium mfn-vb-label-button"><span class="mfn-icon mfn-icon-edit"></span></a>',
							'class' => 'mfn-toggled toggle_fields',
							'title' => __('Typography', 'mfn-opts'),
						),


						array(
		  				'class' => 'toggled_header',
   						'title' => __('Post', 'mfn-opts'),
   					),

   					array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .counter .number-wrapper .postfix:color',
							'type' => 'color',
							'class' => 'main-color mfn-toggled',
							'title' => __('Color', 'mfn-opts'),
						),

						array(
		  				'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .counter .number-wrapper .postfix:margin',
		  				'type' => 'dimensions',
		  				'version' => 'separated-fields',
		  				'title' => __('Margin', 'mfn-opts'),
							'responsive' => 'desktop',
							'class' => 'mfn_field_desktop mfn-toggled',
							'css_attr' => 'margin',
		  			),

		  			array(
		  				'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .counter .number-wrapper .postfix:margin_tablet',
		  				'type' => 'dimensions',
		  				'version' => 'separated-fields',
		  				'title' => __('Margin', 'mfn-opts'),
							'responsive' => 'tablet',
							'class' => 'mfn_field_tablet mfn-toggled',
							'css_attr' => 'margin',
		  			),

		  			array(
		  				'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .counter .number-wrapper .postfix:margin_mobile',
		  				'type' => 'dimensions',
		  				'version' => 'separated-fields',
		  				'title' => __('Margin', 'mfn-opts'),
							'responsive' => 'mobile',
							'class' => 'mfn_field_mobile mfn-toggled',
							'css_attr' => 'margin',
		  			),

		  			array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .counter .number-wrapper .postfix:typography',
							'type' => 'typography_vb',
							'typography' => 'simple',
							'label_after' => '<a href="#" title="Edit" class="mfn-option-btn mfn-option-blank btn-medium mfn-vb-label-button"><span class="mfn-icon mfn-icon-edit"></span></a>',
							'class' => 'mfn-toggled toggle_fields',
							'title' => __('Typography', 'mfn-opts'),
						),

						array(
		  				'class' => 'toggled_header',
   						'title' => __('Title', 'mfn-opts'),
   					),

   					array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .counter .title:color',
							'type' => 'color',
							'class' => 'main-color mfn-toggled',
							'title' => __('Color', 'mfn-opts'),
						),

						array(
		  				'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .counter .title:margin',
		  				'type' => 'dimensions',
		  				'version' => 'separated-fields',
		  				'title' => __('Margin', 'mfn-opts'),
							'responsive' => 'desktop',
							'class' => 'mfn_field_desktop mfn-toggled',
							'css_attr' => 'margin',
		  			),

		  			array(
		  				'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .counter .title:margin_tablet',
		  				'type' => 'dimensions',
		  				'version' => 'separated-fields',
		  				'title' => __('Margin', 'mfn-opts'),
							'responsive' => 'tablet',
							'class' => 'mfn_field_tablet mfn-toggled',
							'css_attr' => 'margin',
		  			),

		  			array(
		  				'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .counter .title:margin_mobile',
		  				'type' => 'dimensions',
		  				'version' => 'separated-fields',
		  				'title' => __('Margin', 'mfn-opts'),
							'responsive' => 'mobile',
							'class' => 'mfn_field_mobile mfn-toggled',
							'css_attr' => 'margin',
		  			),

		  			array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .counter .title:typography',
							'type' => 'typography_vb',
							'label_after' => '<a href="#" title="Edit" class="mfn-option-btn mfn-option-blank btn-medium mfn-vb-label-button"><span class="mfn-icon mfn-icon-edit"></span></a>',
							'class' => 'mfn-toggled toggle_fields',
							'title' => __('Typography', 'mfn-opts'),
						),

						array(
							'type' => 'html',
							'html' => '</div>',
						),

   				),
   			),

   			// Fancy Divider  -------------------------------------------------

   			'fancy_divider' => array(
   				'type' => 'fancy_divider',
   				'title' => __('Fancy Divider', 'mfn-opts'),
   				'size' => '1/1',
   				'tablet_size' => '1/1',
   				'mobile_size' => '1/1',
   				'tablet_resized' => '0',
   				'cat' => 'elements',
   				'fields' => array(

   					array(
							'type' => 'html',
							'html' => '<div class="modalbox-card modalbox-re_render modalbox-card-content-mfnuidhere active">',
						),

   					array(
							'id' => 'info',
							'type' => 'info',
   						'title' => __('Please use on pages without sidebar.', 'mfn-opts'),
   					),

   					array(
   						'id' => 'style',
   						'type' => 'select',
   						're_render' => 'standard',
   						'title' => __('Style', 'mfn-opts'),
   						'options' => array(
   							'circle up' => __('Circle up', 'mfn-opts'),
   							'circle down' => __('Circle down', 'mfn-opts'),
   							'curve up' => __('Curve up', 'mfn-opts'),
   							'curve down' => __('Curve down', 'mfn-opts'),
   							'stamp' => __('Stamp', 'mfn-opts'),
   							'triangle up' => __('Triangle up', 'mfn-opts'),
   							'triangle down' => __('Triangle down', 'mfn-opts'),
   						),
							'std' => 'circle up',
							'preview' => 'style',
   					),

   					array(
   						'id' => 'color_top',
   						'type' => 'color',
   						'title' => __('Color top', 'mfn-opts'),
   					),

   					array(
   						'id' => 'color_bottom',
   						'type' => 'color',
   						'title' => __('Color bottom', 'mfn-opts'),
   					),

						// deprecated

						array(
							'class' => 'mfn-deprecated',
							'title' => __('Deprecated', 'mfn-opts'),
						),

						array(
							'id' => 'class',
							'type' => 'pills',
							'title' => __('Element classes', 'mfn-opts'),
							'class' => 'mfn-deprecated',
						),

						array(
							'type' => 'html',
							'html' => '</div>',
						),

   				),
   			),

   			// Fancy Heading --------------------------------------------------

   			'fancy_heading' => array(
   				'type' => 'fancy_heading',
   				'title' => __('Fancy Heading', 'mfn-opts'),
   				'size' => '1/1',
   				'tablet_size' => '1/1',
   				'mobile_size' => '1/1',
   				'tablet_resized' => '0',
   				'cat' => 'elements',
   				'fields' => array(

   					array(
							'type' => 'html',
							'html' => $this->itemtabs,
						),

   					array(
							'type' => 'html',
							'html' => '<div class="modalbox-card modalbox-re_render modalbox-card-content-mfnuidhere active">',
						),

   					array(
   						'id' => 'title',
   						'type' => 'text',
   						'edit_tag' => '.fancy_heading | .title',
   						'edit_position' => 'append',
   						'title' => __('Title', 'mfn-opts'),
							'std' => __('This is the title', 'mfn-opts'),
							'preview' => 'title',
   					),

   					array(
   						'id' => 'h1',
   						're_render' => 'standard',
   						'type' => 'switch',
   						'title' => __('Tag', 'mfn-opts'),
   						'options' => array(
   							1 => 'H1',
								0 => 'H2',
   						),
							'std' => 0
   					),

   					array(
   						'id' => 'content',
   						'type' => 'textarea',
   						'edit_tag' => '.fancy_heading | div.inside',
   						'edit_position' => 'append',
   						'title' => __('Content', 'mfn-opts'),
							'std' => 'Lorem ipsum dolor sit amet, consectetur adipiscing elit. Ut elit tellus, luctus nec ullamcorper mattis, pulvinar dapibus leo.',
							'preview' => 'content',
							'class' => 'form-content-full-width',
   					),

   					// style

   					array(
   						'title' => __('Style', 'mfn-opts'),
   					),

   					array(
   						'id' => 'style',
   						'type' => 'switch',
   						'attr_id' => 'fancy_header_style',
   						're_render' => 'standard',
   						'title' => __('Style', 'mfn-opts'),
   						'options' => array(
   							'icon' => __('Icon', 'mfn-opts'),
   							'line' => __('Line', 'mfn-opts'),
   							'arrows' => __('Arrows', 'mfn-opts'),
   						),
							'std' => 'icon',
   					),

   					array(
   						'id' => 'icon',
   						'condition' => array( 'id' => 'fancy_header_style', 'opt' => 'is', 'val' => 'icon' ),
   						'type' => 'icon',
   						'title' => __('Icon', 'mfn-opts'),
   						'desc' => __('for style: icon', 'mfn-opts'),
   					),

   					array(
   						'id' => 'slogan',
   						'condition' => array( 'id' => 'fancy_header_style', 'opt' => 'is', 'val' => 'line' ),
   						'edit_tag' => '.fh-top | span.slogan',
   						'edit_position' => 'append',
   						'type' => 'text',
   						'title' => __('Slogan', 'mfn-opts'),
   						'desc' => __('for style: line', 'mfn-opts'),
   					),

						// deprecated

						array(
							'class' => 'mfn-deprecated',
							'title' => __('Deprecated', 'mfn-opts'),
						),

						array(
							'id' => 'class',
							'type' => 'pills',
							'title' => __('Element classes', 'mfn-opts'),
							'class' => 'mfn-deprecated',
						),

   					array(
							'type' => 'html',
							'html' => '</div><div class="modalbox-card modalbox-card-style modalbox-re_render modalbox-card-style-mfnuidhere">',
						),

						array(
							'class' => 'toggled_header',
   						'title' => __('Container', 'mfn-opts'),
   					),

   					array(
   						'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .fancy_heading:text-align',
							'responsive' => 'desktop',
   						'type' => 'switch',
   						'class' => 'mfn_field_desktop mfn-toggled',
   						'title' => __('Text align', 'mfn-opts'),
   						'options' => array(
   							'' => __('Default', 'mfn-opts'),
   							'left' => __('Left', 'mfn-opts'),
								'center' => __('Center', 'mfn-opts'),
   							'right' => __('Right', 'mfn-opts'),
   							'justify' => __('Justify', 'mfn-opts'),
   						),
							'preview' => 'align',
   					),

   					array(
   						'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .fancy_heading:text-align_tablet',
							'responsive' => 'tablet',
   						'type' => 'switch',
   						'class' => 'mfn_field_tablet mfn-toggled',
   						'title' => __('Text align', 'mfn-opts'),
   						'options' => array(
   							'' => __('Default', 'mfn-opts'),
   							'left' => __('Left', 'mfn-opts'),
								'center' => __('Center', 'mfn-opts'),
   							'right' => __('Right', 'mfn-opts'),
   							'justify' => __('Justify', 'mfn-opts'),
   						),
							'preview' => 'align',
   					),

   					array(
   						'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .fancy_heading:text-align_mobile',
							'responsive' => 'mobile',
   						'type' => 'switch',
   						'class' => 'mfn_field_mobile mfn-toggled',
   						'title' => __('Text align', 'mfn-opts'),
   						'options' => array(
   							'' => __('Default', 'mfn-opts'),
   							'left' => __('Left', 'mfn-opts'),
								'center' => __('Center', 'mfn-opts'),
   							'right' => __('Right', 'mfn-opts'),
   							'justify' => __('Justify', 'mfn-opts'),
   						),
							'preview' => 'align',
   					),

   					array(
							'class' => 'toggled_header',
   						'title' => __('Title', 'mfn-opts'),
   					),

						array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .fancy_heading .title:color',
							'type' => 'color',
							'class' => 'mfn-toggled',
							'title' => __('Color', 'mfn-opts'),
						),

						array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .fancy_heading .title:typography',
							'type' => 'typography_vb',
							'label_after' => '<a href="#" title="Edit" class="mfn-option-btn mfn-option-blank btn-medium mfn-vb-label-button"><span class="mfn-icon mfn-icon-edit"></span></a>',
							'class' => 'mfn-toggled toggle_fields',
							'title' => __('Typography', 'mfn-opts'),
						),

						array(
		  				'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .fancy_heading .title:margin',
		  				'type' => 'dimensions',
		  				'title' => __('Margin', 'mfn-opts'),
							'responsive' => 'desktop',
							'version' => 'separated-fields',
							'class' => 'mfn_field_desktop mfn-toggled',
							'css_attr' => 'margin',
		  			),

		  			array(
		  				'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .fancy_heading .title:margin_tablet',
		  				'type' => 'dimensions',
		  				'title' => __('Margin', 'mfn-opts'),
							'responsive' => 'tablet',
							'version' => 'separated-fields',
							'class' => 'mfn_field_tablet mfn-toggled',
							'css_attr' => 'margin',
		  			),

		  			array(
		  				'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .fancy_heading .title:margin_mobile',
		  				'type' => 'dimensions',
		  				'title' => __('Margin', 'mfn-opts'),
							'responsive' => 'mobile',
							'version' => 'separated-fields',
							'class' => 'mfn_field_mobile mfn-toggled',
							'css_attr' => 'margin',
		  			),

		  			array(
							'class' => 'toggled_header',
   						'title' => __('Content', 'mfn-opts'),
   					),

						array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .fancy_heading .inside:color',
							'type' => 'color',
							'class' => 'mfn-toggled',
							'title' => __('Color', 'mfn-opts'),
						),

						array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .fancy_heading .inside:typography',
							'type' => 'typography_vb',
							'label_after' => '<a href="#" title="Edit" class="mfn-option-btn mfn-option-blank btn-medium mfn-vb-label-button"><span class="mfn-icon mfn-icon-edit"></span></a>',
							'class' => 'mfn-toggled toggle_fields',
							'title' => __('Typography', 'mfn-opts'),
						),

						array(
		  				'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .fancy_heading .inside:margin',
		  				'type' => 'dimensions',
		  				'title' => __('Margin', 'mfn-opts'),
							'responsive' => 'desktop',
							'version' => 'separated-fields',
							'class' => 'mfn_field_desktop mfn-toggled',
							'css_attr' => 'margin',
		  			),

		  			array(
		  				'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .fancy_heading .inside:margin_tablet',
		  				'type' => 'dimensions',
		  				'title' => __('Margin', 'mfn-opts'),
							'responsive' => 'tablet',
							'version' => 'separated-fields',
							'class' => 'mfn_field_tablet mfn-toggled',
							'css_attr' => 'margin',
		  			),

		  			array(
		  				'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .fancy_heading .inside:margin_mobile',
		  				'type' => 'dimensions',
		  				'title' => __('Margin', 'mfn-opts'),
							'responsive' => 'mobile',
							'version' => 'separated-fields',
							'class' => 'mfn_field_mobile mfn-toggled',
							'css_attr' => 'margin',
		  			),

		  			array(
							'class' => 'toggled_header',
   						'title' => __('Style Icon', 'mfn-opts'),
   					),

   					array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .fancy_heading_icon .icon_top:color',
							'type' => 'color',
							'class' => 'mfn-toggled',
							'title' => __('Color', 'mfn-opts'),
						),

						array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .fancy_heading_icon .icon_top:font-size',
							'type' => 'sliderbar',
							'responsive' => 'desktop',
							'class' => 'mfn_field_desktop mfn-toggled',
							'title' => __('Size', 'mfn-opts'),
							'units' => array(
								'px' 	=> array('min' => 1, 		'max' => 100, 'step' => 1),
								'em' 	=> array('min' => 0.1, 	'max' => 10, 	'step' => 0.1),
								'rem' => array('min' => 0.1, 	'max' => 10, 	'step' => 0.1),
								'vw' 	=> array('min' => 1, 		'max' => 100, 'step' => 1),
							)
						),

						array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .fancy_heading_icon .icon_top:font-size_tablet',
							'type' => 'sliderbar',
							'responsive' => 'tablet',
							'class' => 'mfn_field_tablet mfn-toggled',
							'title' => __('Size', 'mfn-opts'),
							'units' => array(
								'px' 	=> array('min' => 1, 		'max' => 100, 'step' => 1),
								'em' 	=> array('min' => 0.1, 	'max' => 10, 	'step' => 0.1),
								'rem' => array('min' => 0.1, 	'max' => 10, 	'step' => 0.1),
								'vw' 	=> array('min' => 1, 		'max' => 100, 'step' => 1),
							)
						),

						array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .fancy_heading_icon .icon_top:font-size_mobile',
							'type' => 'sliderbar',
							'responsive' => 'mobile',
							'class' => 'mfn_field_mobile mfn-toggled',
							'title' => __('Size', 'mfn-opts'),
							'units' => array(
								'px' 	=> array('min' => 1, 		'max' => 100, 'step' => 1),
								'em' 	=> array('min' => 0.1, 	'max' => 10, 	'step' => 0.1),
								'rem' => array('min' => 0.1, 	'max' => 10, 	'step' => 0.1),
								'vw' 	=> array('min' => 1, 		'max' => 100, 'step' => 1),
							)
						),

						array(
		  				'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .fancy_heading_icon .icon_top:margin',
		  				'type' => 'dimensions',
		  				'title' => __('Margin', 'mfn-opts'),
							'responsive' => 'desktop',
							'version' => 'separated-fields',
							'class' => 'mfn_field_desktop mfn-toggled',
							'css_attr' => 'margin',
		  			),

		  			array(
		  				'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .fancy_heading_icon .icon_top:margin_tablet',
		  				'type' => 'dimensions',
		  				'title' => __('Margin', 'mfn-opts'),
							'responsive' => 'tablet',
							'version' => 'separated-fields',
							'class' => 'mfn_field_tablet mfn-toggled',
							'css_attr' => 'margin',
		  			),

		  			array(
		  				'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .fancy_heading_icon .icon_top:margin_mobile',
		  				'type' => 'dimensions',
		  				'title' => __('Margin', 'mfn-opts'),
							'responsive' => 'mobile',
							'version' => 'separated-fields',
							'class' => 'mfn_field_mobile mfn-toggled',
							'css_attr' => 'margin',
		  			),

   					array(
							'class' => 'toggled_header',
   						'title' => __('Style Line', 'mfn-opts'),
   					),

   					array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .fancy_heading.fancy_heading_line .slogan:color',
							'type' => 'color',
							'class' => 'mfn-toggled',
							'title' => __('Slogan Color', 'mfn-opts'),
						),

						array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .fancy_heading.fancy_heading_line .slogan:typography',
							'type' => 'typography_vb',
							'label_after' => '<a href="#" title="Edit" class="mfn-option-btn mfn-option-blank btn-medium mfn-vb-label-button"><span class="mfn-icon mfn-icon-edit"></span></a>',
							'class' => 'mfn-toggled toggle_fields',
							'title' => __('Slogan Typography', 'mfn-opts'),
						),

   					array(
							'class' => 'toggled_header',
   						'title' => __('Style Arrows', 'mfn-opts'),
   					),

   					array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .fancy_heading .title i:color',
							'type' => 'color',
							'class' => 'mfn-toggled',
							'title' => __('Arrows Color', 'mfn-opts'),
						),

						array(
							'type' => 'html',
							'html' => '</div>',
						),

   				),
   			),

   			// FAQ  -----------------------------------------------------------

   			'faq' => array(
   				'type' => 'faq',
   				'title' => __('FAQ', 'mfn-opts'),
   				'size' => '1/4',
   				'tablet_size' => '1/4',
   				'mobile_size' => '1/1',
   				'tablet_resized' => '0',
   				'cat' => 'blocks',
   				'fields' => array(

   					array(
							'type' => 'html',
							'html' => $this->itemtabs,
						),

   					array(
							'type' => 'html',
							'html' => '<div class="modalbox-card modalbox-re_render modalbox-card-content-mfnuidhere active">',
						),

   					array(
   						'id' => 'title',
   						'type' => 'text',
   						'edit_tag' => '.faq | h4.title',
   						'edit_position' => 'prepend',
   						'title' => __('Title', 'mfn-opts'),
							'std' => __('This is the title', 'mfn-opts'),
							'preview' => 'title',
   					),

   					array(
   						'id' => 'tabs',
   						'type' => 'tabs',
   						'title' => __('FAQ', 'mfn-opts'),
   						'desc' => __('<b>JavaScript</b> content like Google Maps and some plugins shortcodes do <b>not work</b> in tabs', 'mfn-opts'),
							'options' => [
								'title' => [
									'input',
									__('Question', 'mfn-opts'),
									__('Sample question', 'mfn-opts'),
								],
								'content' => [
									'textarea',
									__('Answer', 'mfn-opts'),
									'Lorem ipsum dolor sit amet, consectetur adipiscing elit. Mauris eu massa orci.',
								],
							],
							'std' => [
								0 => [
									'title' => __('This is the 1st question', 'mfn-opts'),
									'content' => 'Lorem ipsum dolor sit amet, consectetur adipiscing elit. Mauris eu massa orci.',
								],
								1 => [
									'title' => __('This is the 2nd question', 'mfn-opts'),
									'content' => 'Lorem ipsum dolor sit amet, consectetur adipiscing elit. Mauris eu massa orci.',
								],
							],
							'preview' => 'tabs',
   					),

						array(
   						'id' => 'open1st',
   						're_render' => 'tabs',
   						'type' => 'switch',
   						'title' => __('Open first', 'mfn-opts'),
   						'options' => array(
   							0 => __('Default', 'mfn-opts'),
   							1 => __('Open first', 'mfn-opts'),
   						),
							'std' => '0',
   					),

   					array(
   						'id' => 'openAll',
   						're_render' => 'tabs',
   						'type' => 'switch',
							'title' => __('Open all', 'mfn-opts'),
   						'options' => array(
								0 => __('Default', 'mfn-opts'),
   							1 => __('Open all', 'mfn-opts'),
							),
							'std' => '0',
   					),

						array(
   						'id' => 'style',
   						're_render' => 'tabs',
   						'type' => 'switch',
   						'title' => __('Style', 'mfn-opts'),
   						'options' => array(
   							'accordion' => __('Accordion', 'mfn-opts'),
   							'toggle' => __('Toggle', 'mfn-opts'),
   						),
							'std' => 'accordion',
   					),

						// deprecated

						array(
							'class' => 'mfn-deprecated',
							'title' => __('Deprecated', 'mfn-opts'),
						),

						array(
							'id' => 'class',
							'type' => 'pills',
							'title' => __('Element classes', 'mfn-opts'),
							'class' => 'mfn-deprecated',
						),

						array(
							'type' => 'html',
							'html' => '</div><div class="modalbox-card modalbox-card-style modalbox-re_render modalbox-card-style-mfnuidhere">',
						),

						array(
							'class' => 'toggled_header',
   						'title' => __('Title', 'mfn-opts'),
   					),

   					array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .faq h4.title:color',
							'type' => 'color',
							'class' => 'main-color mfn-toggled',
							'title' => __('Color', 'mfn-opts'),
						),

						array(
		  				'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .faq h4.title:margin',
		  				'type' => 'dimensions',
		  				'version' => 'separated-fields',
		  				'title' => __('Margin', 'mfn-opts'),
							'responsive' => 'desktop',
							'class' => 'mfn_field_desktop mfn-toggled',
							'css_attr' => 'margin',
		  			),

		  			array(
		  				'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .faq h4.title:margin_tablet',
		  				'type' => 'dimensions',
		  				'version' => 'separated-fields',
		  				'title' => __('Margin', 'mfn-opts'),
							'responsive' => 'tablet',
							'class' => 'mfn_field_tablet mfn-toggled',
							'css_attr' => 'margin',
		  			),

		  			array(
		  				'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .faq h4.title:margin_mobile',
		  				'type' => 'dimensions',
		  				'version' => 'separated-fields',
		  				'title' => __('Margin', 'mfn-opts'),
							'responsive' => 'mobile',
							'class' => 'mfn_field_mobile mfn-toggled',
							'css_attr' => 'margin',
		  			),

		  			array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .faq h4.title:typography',
							'type' => 'typography_vb',
							'label_after' => '<a href="#" title="Edit" class="mfn-option-btn mfn-option-blank btn-medium mfn-vb-label-button"><span class="mfn-icon mfn-icon-edit"></span></a>',
							'class' => 'mfn-toggled toggle_fields',
							'title' => __('Typography', 'mfn-opts'),
						),

						array(
							'class' => 'toggled_header',
   						'title' => __('Bar', 'mfn-opts'),
   					),

   					array(
							'type' => 'html',
							'html' => '<div class="mfn-form-row mfn-sidebar-fields-tabs mfn-toggled mfn-vb-formrow mfn-vb-mfnuidhere"><ul class="mfn-sft-nav"><li class="active"><a href="#normal" data-tab="normal">Normal</a></li><li><a href="#hover" data-tab="hover">Active</a></li></ul><div class="mfn-sft mfn-sft-normal">',
						),

						array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .faq .question:background',
							'type' => 'color',
							'class' => 'main-color mfn-toggled',
							'title' => __('Background', 'mfn-opts'),
						),

						array(
							'type' => 'html',
							'html' => '</div><div class="mfn-sft mfn-sft-hover">',
						),

						array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .faq .question.active:background',
							'type' => 'color',
							'class' => 'main-color mfn-toggled',
							'title' => __('Background', 'mfn-opts'),
						),

						array(
							'type' => 'html',
							'html' => '</div></div>',
						),

						array(
		  				'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .faq .question:margin',
		  				'type' => 'dimensions',
		  				'version' => 'separated-fields',
		  				'title' => __('Margin', 'mfn-opts'),
							'responsive' => 'desktop',
							'class' => 'mfn_field_desktop mfn-toggled',
							'css_attr' => 'margin',
		  			),

		  			array(
		  				'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .faq .question:margin_tablet',
		  				'type' => 'dimensions',
		  				'version' => 'separated-fields',
		  				'title' => __('Margin', 'mfn-opts'),
							'responsive' => 'tablet',
							'class' => 'mfn_field_tablet mfn-toggled',
							'css_attr' => 'margin',
		  			),

		  			array(
		  				'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .faq .question:margin_mobile',
		  				'type' => 'dimensions',
		  				'version' => 'separated-fields',
		  				'title' => __('Margin', 'mfn-opts'),
							'responsive' => 'mobile',
							'class' => 'mfn_field_mobile mfn-toggled',
							'css_attr' => 'margin',
		  			),

		  			array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .faq .question,.mcb-section .mcb-wrap .mcb-item-mfnuidelement .faq .question .title|before:border-style',
							'attr_id' => 'border_style',
							'type' => 'select',
							'class' => 'mfn-toggled',
							'title' => __('Border style', 'mfn-opts'),
							'options' => [
								'none' => __('None', 'mfn-opts'),
								'solid' => __('Solid', 'mfn-opts'),
								'dashed' => __('Dashed', 'mfn-opts'),
								'dotted' => __('Dotted', 'mfn-opts'),
								'double' => __('Double', 'mfn-opts'),
							],
						),

						array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .faq .question,.mcb-section .mcb-wrap .mcb-item-mfnuidelement .faq .question .title|before:border-color',
							'condition' => array( 'id' => 'border_style', 'opt' => 'isnt', 'val' => 'none' ),
							'type' => 'color',
							'class' => 'mfn-toggled',
							'title' => __('Border color', 'mfn-opts'),
						),

						array(
		  				'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .faq .question:border-width',
		  				'condition' => array( 'id' => 'border_style', 'opt' => 'isnt', 'val' => 'none' ),
		  				'type' => 'dimensions',
		  				'title' => __('Border width', 'mfn-opts'),
							'responsive' => 'desktop',
							'class' => 'mfn_field_desktop mfn-toggled',
							'css_attr' => 'border-width',
		  			),

		  			array(
		  				'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .faq .question:border-width_tablet',
		  				'condition' => array( 'id' => 'border_style', 'opt' => 'isnt', 'val' => 'none' ),
		  				'type' => 'dimensions',
		  				'title' => __('Border width', 'mfn-opts'),
							'responsive' => 'tablet',
							'class' => 'mfn_field_tablet mfn-toggled',
							'css_attr' => 'border-width',
		  			),

		  			array(
		  				'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .faq .question:border-width_mobile',
		  				'condition' => array( 'id' => 'border_style', 'opt' => 'isnt', 'val' => 'none' ),
		  				'type' => 'dimensions',
		  				'title' => __('Border width', 'mfn-opts'),
							'responsive' => 'mobile',
							'class' => 'mfn_field_mobile mfn-toggled',
							'css_attr' => 'border-width',
		  			),

						array(
		  				'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .faq .question:border-radius',
		  				'type' => 'dimensions',
		  				'title' => __('Border radius', 'mfn-opts'),
							'responsive' => 'desktop',
							'class' => 'mfn_field_desktop mfn-toggled',
							'css_attr' => 'border-radius',
		  			),

		  			array(
		  				'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .faq .question:border-radius_tablet',
		  				'type' => 'dimensions',
		  				'title' => __('Border radius', 'mfn-opts'),
							'responsive' => 'tablet',
							'class' => 'mfn_field_tablet mfn-toggled',
							'css_attr' => 'border-radius',
		  			),

		  			array(
		  				'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .faq .question:border-radius_mobile',
		  				'type' => 'dimensions',
		  				'title' => __('Border radius', 'mfn-opts'),
							'responsive' => 'mobile',
							'class' => 'mfn_field_mobile mfn-toggled',
							'css_attr' => 'border-radius',
		  			),

		  			array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .faq .question .title:typography',
							'type' => 'typography_vb',
							'label_after' => '<a href="#" title="Edit" class="mfn-option-btn mfn-option-blank btn-medium mfn-vb-label-button"><span class="mfn-icon mfn-icon-edit"></span></a>',
							'class' => 'mfn-toggled toggle_fields',
							'title' => __('Typography', 'mfn-opts'),
						),

						array(
		  				'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .faq .question .title:box-shadow',
		  				'type' => 'box_shadow',
		  				'title' => __('Box shadow', 'mfn-opts'),
							'responsive' => 'desktop',
							'class' => 'mfn_field_desktop mfn-toggled',
							'css_attr' => 'box-shadow'
		  			),

		  			array(
		  				'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .faq .question .title:box-shadow_tablet',
		  				'type' => 'box_shadow',
		  				'title' => __('Box shadow', 'mfn-opts'),
							'responsive' => 'tablet',
							'class' => 'mfn_field_tablet mfn-toggled',
							'css_attr' => 'box-shadow',
		  			),

		  			array(
		  				'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .faq .question .title:box-shadow_mobile',
		  				'type' => 'box_shadow',
		  				'title' => __('Box shadow', 'mfn-opts'),
							'responsive' => 'mobile',
							'class' => 'mfn_field_mobile mfn-toggled',
							'css_attr' => 'box-shadow',
		  			),

		  			array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .faq:--mfn-faq-line',
							'type' => 'color',
							'class' => 'main-color mfn-toggled',
							'title' => __('Line color', 'mfn-opts'),
						),

						array(
							'class' => 'toggled_header',
   						'title' => __('Title bar', 'mfn-opts'),
   					),

   					array(
							'type' => 'html',
							'html' => '<div class="mfn-form-row mfn-sidebar-fields-tabs mfn-toggled mfn-vb-formrow mfn-vb-mfnuidhere"><ul class="mfn-sft-nav"><li class="active"><a href="#titlenormal" data-tab="titlenormal">Normal</a></li><li><a href="#titlehover" data-tab="titlehover">Active</a></li></ul><div class="mfn-sft mfn-sft-titlenormal">',
						),

   					array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .faq .question .title:color',
							'type' => 'color',
							'class' => 'main-color mfn-toggled',
							'title' => __('Color', 'mfn-opts'),
						),

						array(
							'type' => 'html',
							'html' => '</div><div class="mfn-sft mfn-sft-titlehover">',
						),

						array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .faq .question.active .title:color',
							'type' => 'color',
							'class' => 'main-color mfn-toggled',
							'title' => __('Color', 'mfn-opts'),
						),

						array(
							'type' => 'html',
							'html' => '</div></div>',
						),

		  			array(
							'class' => 'toggled_header',
   						'title' => __('Content', 'mfn-opts'),
   					),

   					array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .faq .question .answer:color',
							'type' => 'color',
							'class' => 'main-color mfn-toggled',
							'title' => __('Color', 'mfn-opts'),
						),

		  			array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .faq .question .answer:typography',
							'type' => 'typography_vb',
							'label_after' => '<a href="#" title="Edit" class="mfn-option-btn mfn-option-blank btn-medium mfn-vb-label-button"><span class="mfn-icon mfn-icon-edit"></span></a>',
							'class' => 'mfn-toggled toggle_fields',
							'title' => __('Typography', 'mfn-opts'),
						),

						array(
							'class' => 'toggled_header',
							'themeoptions' => 'style:simple',
   						'title' => __('Bar line', 'mfn-opts'),
   					),

   					array(
							'type' => 'html',
							'themeoptions' => 'style:simple',
							'html' => '<div class="mfn-form-row mfn-sidebar-fields-tabs mfn-toggled mfn-vb-formrow mfn-vb-mfnuidhere"><ul class="mfn-sft-nav"><li class="active"><a href="#barlinenormal" data-tab="barlinenormal">Normal</a></li><li><a href="#barlinehover" data-tab="barlinehover">Active</a></li></ul><div class="mfn-sft mfn-sft-barlinenormal">',
						),

   					array(
							'id' => 'style:.style-simple .mcb-section .mcb-wrap .mcb-item-mfnuidelement .faq .question:border-color',
							'type' => 'color',
							'themeoptions' => 'style:simple',
							'title' => __('Color', 'mfn-opts'),
						),

						array(
							'type' => 'html',
							'themeoptions' => 'style:simple',
							'html' => '</div><div class="mfn-sft mfn-sft-barlinehover">',
						),

						array(
							'id' => 'style:.style-simple .mcb-section .mcb-wrap .mcb-item-mfnuidelement .faq .question.active|after:background-color',
							'type' => 'color',
							'themeoptions' => 'style:simple',
							'title' => __('Color', 'mfn-opts'),
						),

						array(
							'type' => 'html',
							'themeoptions' => 'style:simple',
							'html' => '</div></div>',
						),

						array(
							'type' => 'html',
							'html' => '</div>',
						),

   				),
   			),

   			// Feature Box -------------------------------------------------------

   			'feature_box' => array(
   				'type' => 'feature_box',
   				'title' => __('Feature Box', 'mfn-opts'),
   				'size' => '1/4',
   				'tablet_size' => '1/4',
   				'mobile_size' => '1/1',
   				'tablet_resized' => '0',
   				'cat' => 'boxes',
   				'fields' => array(

   					array(
							'type' => 'html',
							'html' => $this->itemtabs,
						),

   					array(
							'type' => 'html',
							'html' => '<div class="modalbox-card modalbox-re_render modalbox-card-content-mfnuidhere active">',
						),

   					array(
   						'id' => 'image',
   						'type' => 'upload',
   						'title' => __('Image', 'mfn-opts'),
   						'desc' => __('Recommended image width <b>384px - 960px</b> depending on size of the item', 'mfn-opts'),
							'std' => $this->get_placeholder(),
							'preview' => 'image',
   					),

   					array(
   						'id' => 'title',
   						'type' => 'text',
   						'edit_tag' => '.desc_wrapper | h4',
   						'edit_position' => 'prepend',
   						'title' => __('Title', 'mfn-opts'),
   						'desc' => __('Allowed HTML tags: span, strong, b, em, i, u', 'mfn-opts'),
							'std' => __('This is the title', 'mfn-opts'),
							'preview' => 'title',
   					),

   					array(
   						'id' => 'content',
   						'type' => 'textarea',
   						'edit_tag' => '.desc_wrapper | div.desc',
   						'edit_position' => 'append',
   						'title' => __('Content', 'mfn-opts'),
							'std' => 'Lorem ipsum dolor sit amet, consectetur adipiscing elit. Ut elit tellus, luctus nec ullamcorper mattis, pulvinar dapibus leo.',
							'preview' => 'content',
							'class' => 'form-content-full-width',
   					),

   					// link

   					array(
   						'title' => __('Link', 'mfn-opts'),
   					),

   					array(
   						'id' => 'link',
   						'type' => 'text',
   						'title' => __('Link', 'mfn-opts'),
   					),

   					array(
   						'id' => 'target',
   						'type' => 'select',
   						'title' => __('Target', 'mfn-opts'),
   						'options' => array(
   							0 => __('Default | _self', 'mfn-opts'),
   							1 => __('New tab or window | _blank', 'mfn-opts'),
   							'lightbox' => __('Lightbox (image or embed video)', 'mfn-opts'),
   						),
   					),

   					array(
   						'class' => 'mfn-deprecated',
   						'title' => __('Deprecated', 'mfn-opts'),
   					),

   					array(
   						'id' => 'background',
   						'class' => 'mfn-deprecated',
   						'type' => 'color',
   						'title' => __('Background color', 'mfn-opts'),
   					),

						array(
							'id' => 'class',
							'type' => 'pills',
							'title' => __('Element classes', 'mfn-opts'),
							'class' => 'mfn-deprecated',
						),

   					array(
							'type' => 'html',
							'html' => '</div><div class="modalbox-card modalbox-card-style modalbox-re_render modalbox-card-style-mfnuidhere">',
						),

						array(
							'class' => 'toggled_header',
   						'title' => __('Image', 'mfn-opts'),
   					),

		  			array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .feature_box .photo_wrapper img:border-style',
							'attr_id' => 'border_style',
							'type' => 'select',
							'class' => 'mfn-toggled',
							'title' => __('Border style', 'mfn-opts'),
							'options' => [
								'none' => __('None', 'mfn-opts'),
								'solid' => __('Solid', 'mfn-opts'),
								'dashed' => __('Dashed', 'mfn-opts'),
								'dotted' => __('Dotted', 'mfn-opts'),
								'double' => __('Double', 'mfn-opts'),
							],
						),

						array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .feature_box .photo_wrapper img:border-color',
							'condition' => array( 'id' => 'border_style', 'opt' => 'isnt', 'val' => 'none' ),
							'type' => 'color',
							'class' => 'mfn-toggled',
							'title' => __('Border color', 'mfn-opts'),
						),

						array(
		  				'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .feature_box .photo_wrapper img:border-width',
		  				'condition' => array( 'id' => 'border_style', 'opt' => 'isnt', 'val' => 'none' ),
		  				'type' => 'dimensions',
		  				'title' => __('Border width', 'mfn-opts'),
							'responsive' => 'desktop',
							'class' => 'mfn_field_desktop mfn-toggled',
							'css_attr' => 'border-width',
		  			),

		  			array(
		  				'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .feature_box .photo_wrapper img:border-width_tablet',
		  				'condition' => array( 'id' => 'border_style', 'opt' => 'isnt', 'val' => 'none' ),
		  				'type' => 'dimensions',
		  				'title' => __('Border width', 'mfn-opts'),
							'responsive' => 'tablet',
							'class' => 'mfn_field_tablet mfn-toggled',
							'css_attr' => 'border-width',
		  			),

		  			array(
		  				'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .feature_box .photo_wrapper img:border-width_mobile',
		  				'condition' => array( 'id' => 'border_style', 'opt' => 'isnt', 'val' => 'none' ),
		  				'type' => 'dimensions',
		  				'title' => __('Border width', 'mfn-opts'),
							'responsive' => 'mobile',
							'class' => 'mfn_field_mobile mfn-toggled',
							'css_attr' => 'border-width',
		  			),

						array(
		  				'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .feature_box .photo_wrapper img:border-radius',
		  				'type' => 'dimensions',
		  				'title' => __('Border radius', 'mfn-opts'),
							'responsive' => 'desktop',
							'class' => 'mfn_field_desktop mfn-toggled',
							'css_attr' => 'border-radius',
		  			),

		  			array(
		  				'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .feature_box .photo_wrapper img:border-radius_tablet',
		  				'type' => 'dimensions',
		  				'title' => __('Border radius', 'mfn-opts'),
							'responsive' => 'tablet',
							'class' => 'mfn_field_tablet mfn-toggled',
							'css_attr' => 'border-radius',
		  			),

		  			array(
		  				'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .feature_box .photo_wrapper img:border-radius_mobile',
		  				'type' => 'dimensions',
		  				'title' => __('Border radius', 'mfn-opts'),
							'responsive' => 'mobile',
							'class' => 'mfn_field_mobile mfn-toggled',
							'css_attr' => 'border-radius',
		  			),

						array(
							'class' => 'toggled_header',
   						'title' => __('Desc', 'mfn-opts'),
   					),

   					array(
   						'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .feature_box_wrapper .desc_wrapper:text-align',
							'responsive' => 'desktop',
   						'type' => 'switch',
   						'class' => 'mfn_field_desktop mfn-toggled',
   						'title' => __('Text align', 'mfn-opts'),
   						'options' => array(
   							'' => __('Default', 'mfn-opts'),
   							'left' => __('Left', 'mfn-opts'),
								'center' => __('Center', 'mfn-opts'),
   							'right' => __('Right', 'mfn-opts'),
   							'justify' => __('Justify', 'mfn-opts'),
   						),
							'preview' => 'align',
   					),

   					array(
   						'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .feature_box_wrapper .desc_wrapper:text-align_tablet',
							'responsive' => 'tablet',
   						'type' => 'switch',
   						'class' => 'mfn_field_tablet mfn-toggled',
   						'title' => __('Text align', 'mfn-opts'),
   						'options' => array(
   							'' => __('Default', 'mfn-opts'),
   							'left' => __('Left', 'mfn-opts'),
								'center' => __('Center', 'mfn-opts'),
   							'right' => __('Right', 'mfn-opts'),
   							'justify' => __('Justify', 'mfn-opts'),
   						),
							'preview' => 'align',
   					),

   					array(
   						'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .feature_box_wrapper .desc_wrapper:text-align_mobile',
							'responsive' => 'mobile',
   						'type' => 'switch',
   						'class' => 'mfn_field_mobile mfn-toggled',
   						'title' => __('Text align', 'mfn-opts'),
   						'options' => array(
   							'' => __('Default', 'mfn-opts'),
   							'left' => __('Left', 'mfn-opts'),
								'center' => __('Center', 'mfn-opts'),
   							'right' => __('Right', 'mfn-opts'),
   							'justify' => __('Justify', 'mfn-opts'),
   						),
							'preview' => 'align',
   					),

   					array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .desc_wrapper .desc:color',
							'type' => 'color',
							'class' => 'main-color mfn-toggled',
							'title' => __('Color', 'mfn-opts'),
						),

						array(
		  				'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .desc_wrapper:padding',
		  				'type' => 'dimensions',
		  				'version' => 'separated-fields',
		  				'title' => __('Padding', 'mfn-opts'),
							'responsive' => 'desktop',
							'class' => 'mfn_field_desktop mfn-toggled',
							'css_attr' => 'padding',
		  			),

		  			array(
		  				'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .desc_wrapper:padding_tablet',
		  				'type' => 'dimensions',
		  				'version' => 'separated-fields',
		  				'title' => __('Padding', 'mfn-opts'),
							'responsive' => 'tablet',
							'class' => 'mfn_field_tablet mfn-toggled',
							'css_attr' => 'padding',
		  			),

		  			array(
		  				'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .desc_wrapper:padding_mobile',
		  				'type' => 'dimensions',
		  				'version' => 'separated-fields',
		  				'title' => __('Padding', 'mfn-opts'),
							'responsive' => 'mobile',
							'class' => 'mfn_field_mobile mfn-toggled',
							'css_attr' => 'padding',
		  			),

		  			array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .desc_wrapper .desc:typography',
							'type' => 'typography_vb',
							'label_after' => '<a href="#" title="Edit" class="mfn-option-btn mfn-option-blank btn-medium mfn-vb-label-button"><span class="mfn-icon mfn-icon-edit"></span></a>',
							'class' => 'mfn-toggled toggle_fields',
							'title' => __('Typography', 'mfn-opts'),
						),

						array(
							'class' => 'toggled_header',
   						'title' => __('Title', 'mfn-opts'),
   					),

   					array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .desc_wrapper h4:color',
							'type' => 'color',
							'class' => 'main-color mfn-toggled',
							'title' => __('Color', 'mfn-opts'),
						),

						array(
		  				'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .desc_wrapper h4:margin',
		  				'type' => 'dimensions',
		  				'version' => 'separated-fields',
		  				'title' => __('Margin', 'mfn-opts'),
							'responsive' => 'desktop',
							'class' => 'mfn_field_desktop mfn-toggled',
							'css_attr' => 'margin',
		  			),

		  			array(
		  				'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .desc_wrapper h4:margin_tablet',
		  				'type' => 'dimensions',
		  				'version' => 'separated-fields',
		  				'title' => __('Margin', 'mfn-opts'),
							'responsive' => 'tablet',
							'class' => 'mfn_field_tablet mfn-toggled',
							'css_attr' => 'margin',
		  			),

		  			array(
		  				'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .desc_wrapper h4:margin_mobile',
		  				'type' => 'dimensions',
		  				'version' => 'separated-fields',
		  				'title' => __('Margin', 'mfn-opts'),
							'responsive' => 'mobile',
							'class' => 'mfn_field_mobile mfn-toggled',
							'css_attr' => 'margin',
		  			),

		  			array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .desc_wrapper h4:typography',
							'type' => 'typography_vb',
							'label_after' => '<a href="#" title="Edit" class="mfn-option-btn mfn-option-blank btn-medium mfn-vb-label-button"><span class="mfn-icon mfn-icon-edit"></span></a>',
							'class' => 'mfn-toggled toggle_fields',
							'title' => __('Typography', 'mfn-opts'),
						),

						array(
							'type' => 'html',
							'html' => '</div>',
						),

   				),
   			),

   			// Feature List ---------------------------------------------------

   			'feature_list' => array(
   				'type' => 'feature_list',
   				'title' => __('Feature List', 'mfn-opts'),
   				'size' => '1/1',
   				'tablet_size' => '1/1',
   				'mobile_size' => '1/1',
   				'tablet_resized' => '0',
   				'cat' => 'elements',
   				'fields' => array(

   					array(
							'type' => 'html',
							'html' => $this->itemtabs,
						),

   					array(
							'type' => 'html',
							'html' => '<div class="modalbox-card modalbox-re_render modalbox-card-content-mfnuidhere active">',
						),

						array(
   						'id' => 'tabs',
   						'type' => 'tabs',
   						'title' => __('Items', 'mfn-opts'),
							'options' => [
								'title' => [
									'input',
									__('Title', 'mfn-opts'),
									__('List item', 'mfn-opts'),
								],
								'icon' => [
									'input',
									__('Icon', 'mfn-opts'),
									'icon-lamp',
								],
								'link' => [
									'input',
									__('Link', 'mfn-opts'),
									'',
								],
								'target' => [
									'input',
									__('Target', 'mfn-opts'),
									'',
								],
								'animate' => [
									'input',
									__('Animate', 'mfn-opts'),
									'',
								],
							],
							'std' => [
								0 => [
									'title' => 'This is the 1st item',
									'icon' => 'icon-book',
									'link' => '',
									'target' => '',
									'animate' => '',
								],
								1 => [
									'title' => 'This is the 2nd item',
									'icon' => 'icon-bucket',
									'link' => '',
									'target' => '',
									'animate' => '',
								],
							],
							'preview' => 'tabs',
   					),

   					array(
   						'id' => 'content',
   						'type' => 'textarea',
   						'edit_tag' => '.feature_list | ul.fl-content',
   						'edit_position' => 'append',
   						'title' => __('Content', 'mfn-opts'),
   						'preview' => 'content',
							'class' => 'form-content-full-width',
   					),

   					array(
   						'id' => 'columns',
   						're_render' => 'tabs',
   						'type' => 'switch',
   						'title' => __('Columns', 'mfn-opts'),
   						'options' => array(
   							2	=> 2,
   							3	=> 3,
   							4	=> 4,
   							5	=> 5,
   							6	=> 6,
   						),
   						'std' => 4,
   					),

						// deprecated

						array(
							'class' => 'mfn-deprecated',
							'title' => __('Deprecated', 'mfn-opts'),
						),

						array(
							'id' => 'class',
							'type' => 'pills',
							'title' => __('Element classes', 'mfn-opts'),
							'class' => 'mfn-deprecated',
						),

						array(
							'type' => 'html',
							'html' => '</div><div class="modalbox-card modalbox-card-style modalbox-re_render modalbox-card-style-mfnuidhere">',
						),

						array(
							'class' => 'toggled_header',
   						'title' => __('Container', 'mfn-opts'),
   					),

   					array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .feature_list ul li p:typography',
							'type' => 'typography_vb',
							'label_after' => '<a href="#" title="Edit" class="mfn-option-btn mfn-option-blank btn-medium mfn-vb-label-button"><span class="mfn-icon mfn-icon-edit"></span></a>',
							'class' => 'mfn-toggled toggle_fields',
							'title' => __('Typography', 'mfn-opts'),
						),

		  			array(
							'type' => 'html',
							'html' => '<div class="mfn-form-row mfn-sidebar-fields-tabs mfn-toggled mfn-vb-formrow mfn-vb-mfnuidhere"><ul class="mfn-sft-nav"><li class="active"><a href="#normal" data-tab="normal">Normal</a></li><li><a href="#hover" data-tab="hover">Hover</a></li></ul><div class="mfn-sft mfn-sft-normal">',
						),

		  			array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .feature_list ul li,.mcb-section .mcb-wrap .mcb-item-mfnuidelement .feature_list ul li a:background-color',
							'type' => 'color',
							'title' => __('Background', 'mfn-opts'),
						),

						array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .feature_list ul li,.mcb-section .mcb-wrap .mcb-item-mfnuidelement .feature_list ul li a:color',
							'type' => 'color',
							'title' => __('Color', 'mfn-opts'),
						),

						array(
							'type' => 'html',
							'html' => '</div><div class="mfn-sft mfn-sft-hover">',
						),

						array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .feature_list ul li|hover,.mcb-section .mcb-wrap .mcb-item-mfnuidelement .feature_list ul li|hover a:background-color',
							'type' => 'color',
							'title' => __('Background', 'mfn-opts'),
						),

						array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .feature_list ul li|hover,.mcb-section .mcb-wrap .mcb-item-mfnuidelement .feature_list ul li|hover a:color',
							'type' => 'color',
							'title' => __('Color', 'mfn-opts'),
						),

						array(
							'type' => 'html',
							'html' => '</div></div>',
						),

						array(
							'class' => 'toggled_header',
   						'title' => __('Icon', 'mfn-opts'),
   					),

   					array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .feature_list ul li .icon i:font-size',
							'type' => 'sliderbar',
							'responsive' => 'desktop',
							'class' => 'mfn_field_desktop mfn-toggled',
							'title' => __('Size', 'mfn-opts'),
							'units' => array(
								'px' 	=> array('min' => 1, 		'max' => 100, 'step' => 1),
								'em' 	=> array('min' => 0.1, 	'max' => 10, 	'step' => 0.1),
								'rem' => array('min' => 0.1, 	'max' => 10, 	'step' => 0.1),
								'vw' 	=> array('min' => 1, 		'max' => 100, 'step' => 1),
							)
						),

						array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .feature_list ul li .icon i:font-size_tablet',
							'type' => 'sliderbar',
							'responsive' => 'tablet',
							'class' => 'mfn_field_tablet mfn-toggled',
							'title' => __('Size', 'mfn-opts'),
							'units' => array(
								'px' 	=> array('min' => 1, 		'max' => 100, 'step' => 1),
								'em' 	=> array('min' => 0.1, 	'max' => 10, 	'step' => 0.1),
								'rem' => array('min' => 0.1, 	'max' => 10, 	'step' => 0.1),
								'vw' 	=> array('min' => 1, 		'max' => 100, 'step' => 1),
							)
						),

						array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .feature_list ul li .icon i:font-size_mobile',
							'type' => 'sliderbar',
							'responsive' => 'mobile',
							'class' => 'mfn_field_mobile mfn-toggled',
							'title' => __('Size', 'mfn-opts'),
							'units' => array(
								'px' 	=> array('min' => 1, 		'max' => 100, 'step' => 1),
								'em' 	=> array('min' => 0.1, 	'max' => 10, 	'step' => 0.1),
								'rem' => array('min' => 0.1, 	'max' => 10, 	'step' => 0.1),
								'vw' 	=> array('min' => 1, 		'max' => 100, 'step' => 1),
							)
						),

		  			array(
							'type' => 'html',
							'html' => '<div class="mfn-form-row mfn-sidebar-fields-tabs mfn-toggled mfn-vb-formrow mfn-vb-mfnuidhere"><ul class="mfn-sft-nav"><li class="active"><a href="#iconnormal" data-tab="iconnormal">Normal</a></li><li><a href="#iconhover" data-tab="iconhover">Hover</a></li></ul><div class="mfn-sft mfn-sft-iconnormal">',
						),

						array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .feature_list ul li .icon i:color',
							'type' => 'color',
							'title' => __('Color', 'mfn-opts'),
						),

						array(
							'type' => 'html',
							'html' => '</div><div class="mfn-sft mfn-sft-iconhover">',
						),

						array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .feature_list ul li|hover .icon i:color',
							'type' => 'color',
							'title' => __('Color', 'mfn-opts'),
						),

						array(
							'type' => 'html',
							'html' => '</div></div>',
						),

						array(
							'class' => 'toggled_header',
							'themeoptions' => 'style:',
   						'title' => __('Line', 'mfn-opts'),
   					),

						array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .feature_list hr:background-color',
							'type' => 'color',
							'themeoptions' => 'style:',
							'title' => __('Color', 'mfn-opts'),
						),

						array(
							'type' => 'html',
							'html' => '</div>',
						),

   				),
   			),

   			// Flat Box -------------------------------------------------------

   			'flat_box' => array(
   				'type' => 'flat_box',
   				'title' => __('Flat Box', 'mfn-opts'),
   				'size' => '1/4',
   				'tablet_size' => '1/4',
   				'mobile_size' => '1/1',
   				'tablet_resized' => '0',
   				'cat' => 'boxes',
   				'fields' => array(

   					array(
							'type' => 'html',
							'html' => $this->itemtabs,
						),

   					array(
							'type' => 'html',
							'html' => '<div class="modalbox-card modalbox-re_render modalbox-card-content-mfnuidhere active">',
						),

   					array(
   						'id' => 'image',
   						'type' => 'upload',
   						'title' => __('Image', 'mfn-opts'),
   						'desc' => __('Recommended image width <b>768px - 1920px</b> depending on size of the item', 'mfn-opts'),
							'std' => $this->get_placeholder(),
							'preview' => 'image',
   					),

   					array(
   						'id' => 'title',
   						'type' => 'text',
   						'edit_tag' => '.desc_wrapper | h4',
   						'edit_position' => 'prepend',
   						'title' => __('Title', 'mfn-opts'),
   						'desc' => __('Allowed HTML tags: span, strong, b, em, i, u', 'mfn-opts'),
							'std' => __('This is the title', 'mfn-opts'),
							'preview' => 'title',
   					),

   					array(
   						'id' => 'content',
   						'type' => 'textarea',
   						'edit_tag' => '.desc_wrapper | div.desc',
   						'edit_position' => 'append',
   						'title' => __('Content', 'mfn-opts'),
							'std' => 'Lorem ipsum dolor sit amet, consectetur adipiscing elit. Ut elit tellus, luctus nec ullamcorper mattis, pulvinar dapibus leo.',
							'preview' => 'content',
							'class' => 'form-content-full-width',
   					),

   					// icon

   					array(
   						'title' => __('Icon', 'mfn-opts'),
   					),

   					array(
   						'id' => 'icon',
   						'type' => 'icon',
   						'title' => __('Icon', 'mfn-opts'),
   						'std' => 'icon-lamp',
   					),

   					array(
   						'id' => 'icon_image',
   						'type' => 'upload',
   						'title' => __('Image', 'mfn-opts'),
   						'desc' => __('Replaces icon if uploaded', 'mfn-opts'),
   					),

   					// link

   					array(
   						'title' => __('Link', 'mfn-opts'),
   					),

   					array(
   						'id' => 'link',
   						'type' => 'text',
   						'title' => __('Link', 'mfn-opts'),
   					),

   					array(
   						'id' => 'target',
   						'type' => 'select',
   						'title' => __('Target', 'mfn-opts'),
   						'options' => array(
   							0 => __('Default | _self', 'mfn-opts'),
   							1 => __('New tab or window | _blank', 'mfn-opts'),
   							'lightbox' => __('Lightbox (image or embed video)', 'mfn-opts'),
   						),
   					),

   					array(
   						'class' => 'mfn-deprecated',
   						'title' => __('Deprecated', 'mfn-opts'),
   					),

   					array(
   						'id' => 'background',
   						'class' => 'mfn-deprecated',
   						'type' => 'color',
   						'title' => __('Background color', 'mfn-opts'),
   					),

						array(
							'id' => 'class',
							'type' => 'pills',
							'title' => __('Element classes', 'mfn-opts'),
							'class' => 'mfn-deprecated',
						),

   					array(
							'type' => 'html',
							'html' => '</div><div class="modalbox-card modalbox-card-style modalbox-re_render modalbox-card-style-mfnuidhere">',
						),

						array(
							'class' => 'toggled_header',
   						'title' => __('Image', 'mfn-opts'),
   					),

		  			array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .flat_box .photo_wrapper:border-style',
							'attr_id' => 'border_style',
							'type' => 'select',
							'class' => 'mfn-toggled',
							'title' => __('Border style', 'mfn-opts'),
							'options' => [
								'none' => __('None', 'mfn-opts'),
								'solid' => __('Solid', 'mfn-opts'),
								'dashed' => __('Dashed', 'mfn-opts'),
								'dotted' => __('Dotted', 'mfn-opts'),
								'double' => __('Double', 'mfn-opts'),
							],
						),

						array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .flat_box .photo_wrapper:border-color',
							'condition' => array( 'id' => 'border_style', 'opt' => 'isnt', 'val' => 'none' ),
							'type' => 'color',
							'class' => 'mfn-toggled',
							'title' => __('Border color', 'mfn-opts'),
						),

						array(
		  				'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .flat_box .photo_wrapper:border-width',
		  				'condition' => array( 'id' => 'border_style', 'opt' => 'isnt', 'val' => 'none' ),
		  				'type' => 'dimensions',
		  				'title' => __('Border width', 'mfn-opts'),
							'responsive' => 'desktop',
							'class' => 'mfn_field_desktop mfn-toggled',
							'css_attr' => 'border-width',
		  			),

		  			array(
		  				'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .flat_box .photo_wrapper:border-width_tablet',
		  				'condition' => array( 'id' => 'border_style', 'opt' => 'isnt', 'val' => 'none' ),
		  				'type' => 'dimensions',
		  				'title' => __('Border width', 'mfn-opts'),
							'responsive' => 'tablet',
							'class' => 'mfn_field_tablet mfn-toggled',
							'css_attr' => 'border-width',
		  			),

		  			array(
		  				'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .flat_box .photo_wrapper:border-width_mobile',
		  				'condition' => array( 'id' => 'border_style', 'opt' => 'isnt', 'val' => 'none' ),
		  				'type' => 'dimensions',
		  				'title' => __('Border width', 'mfn-opts'),
							'responsive' => 'mobile',
							'class' => 'mfn_field_mobile mfn-toggled',
							'css_attr' => 'border-width',
		  			),

						array(
		  				'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .flat_box .photo_wrapper:border-radius',
		  				'type' => 'dimensions',
		  				'title' => __('Border radius', 'mfn-opts'),
							'responsive' => 'desktop',
							'class' => 'mfn_field_desktop mfn-toggled',
							'css_attr' => 'border-radius',
		  			),

		  			array(
		  				'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .flat_box .photo_wrapper:border-radius_tablet',
		  				'type' => 'dimensions',
		  				'title' => __('Border radius', 'mfn-opts'),
							'responsive' => 'tablet',
							'class' => 'mfn_field_tablet mfn-toggled',
							'css_attr' => 'border-radius',
		  			),

		  			array(
		  				'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .flat_box .photo_wrapper:border-radius_mobile',
		  				'type' => 'dimensions',
		  				'title' => __('Border radius', 'mfn-opts'),
							'responsive' => 'mobile',
							'class' => 'mfn_field_mobile mfn-toggled',
							'css_attr' => 'border-radius',
		  			),

		  			array(
		  				'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .flat_box .photo_wrapper:margin',
		  				'type' => 'dimensions',
		  				'title' => __('Margin', 'mfn-opts'),
		  				'version' => 'separated-fields',
							'responsive' => 'desktop',
							'class' => 'mfn_field_desktop mfn-toggled',
							'css_attr' => 'margin',
		  			),

		  			array(
		  				'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .flat_box .photo_wrapper:margin_tablet',
		  				'type' => 'dimensions',
		  				'title' => __('Margin', 'mfn-opts'),
		  				'version' => 'separated-fields',
							'responsive' => 'tablet',
							'class' => 'mfn_field_tablet mfn-toggled',
							'css_attr' => 'margin',
		  			),

		  			array(
		  				'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .flat_box .photo_wrapper:margin_mobile',
		  				'type' => 'dimensions',
		  				'title' => __('Margin', 'mfn-opts'),
		  				'version' => 'separated-fields',
							'responsive' => 'mobile',
							'class' => 'mfn_field_mobile mfn-toggled',
							'css_attr' => 'margin',
		  			),

		  			array(
							'class' => 'toggled_header',
   						'title' => __('Title', 'mfn-opts'),
   					),

   					array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .desc_wrapper h4:color',
							'type' => 'color',
							'class' => 'mfn-toggled',
							'title' => __('Color', 'mfn-opts'),
						),

   					array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .desc_wrapper h4:typography',
							'type' => 'typography_vb',
							'label_after' => '<a href="#" title="Edit" class="mfn-option-btn mfn-option-blank btn-medium mfn-vb-label-button"><span class="mfn-icon mfn-icon-edit"></span></a>',
							'class' => 'mfn-toggled toggle_fields',
							'title' => __('Typography', 'mfn-opts'),
						),

		  			array(
		  				'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .desc_wrapper h4:margin_tablet',
		  				'type' => 'dimensions',
		  				'version' => 'separated-fields',
		  				'title' => __('Margin', 'mfn-opts'),
							'responsive' => 'tablet',
							'class' => 'mfn_field_tablet mfn-toggled',
							'css_attr' => 'margin',
		  			),

		  			array(
		  				'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .desc_wrapper h4:margin_mobile',
		  				'type' => 'dimensions',
		  				'version' => 'separated-fields',
		  				'title' => __('Margin', 'mfn-opts'),
							'responsive' => 'mobile',
							'class' => 'mfn_field_mobile mfn-toggled',
							'css_attr' => 'margin',
		  			),

		  			array(
							'class' => 'toggled_header',
   						'title' => __('Icon', 'mfn-opts'),
   					),

   					array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .flat_box .photo_wrapper .icon:color',
							'type' => 'color',
							'class' => 'mfn-toggled',
							'title' => __('Color', 'mfn-opts'),
						),

						array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .flat_box .photo_wrapper .icon:background-color',
							'type' => 'color',
							'class' => 'mfn-toggled',
							'title' => __('Background', 'mfn-opts'),
						),

						array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .flat_box .photo_wrapper .icon i:font-size',
							'type' => 'sliderbar',
							'responsive' => 'desktop',
							'class' => 'mfn_field_desktop mfn-toggled',
							'title' => __('Size', 'mfn-opts'),
							'units' => array(
								'px' 	=> array('min' => 1, 		'max' => 100, 'step' => 1),
								'em' 	=> array('min' => 0.1, 	'max' => 10, 	'step' => 0.1),
								'rem' => array('min' => 0.1, 	'max' => 10, 	'step' => 0.1),
								'vw' 	=> array('min' => 1, 		'max' => 100, 'step' => 1),
							)
						),

						array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .flat_box .photo_wrapper .icon i:font-size_tablet',
							'type' => 'sliderbar',
							'responsive' => 'tablet',
							'class' => 'mfn_field_tablet mfn-toggled',
							'title' => __('Size', 'mfn-opts'),
							'units' => array(
								'px' 	=> array('min' => 1, 		'max' => 100, 'step' => 1),
								'em' 	=> array('min' => 0.1, 	'max' => 10, 	'step' => 0.1),
								'rem' => array('min' => 0.1, 	'max' => 10, 	'step' => 0.1),
								'vw' 	=> array('min' => 1, 		'max' => 100, 'step' => 1),
							)
						),

						array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .flat_box .photo_wrapper .icon i:font-size_mobile',
							'type' => 'sliderbar',
							'responsive' => 'mobile',
							'class' => 'mfn_field_mobile mfn-toggled',
							'title' => __('Size', 'mfn-opts'),
							'units' => array(
								'px' 	=> array('min' => 1, 		'max' => 100, 'step' => 1),
								'em' 	=> array('min' => 0.1, 	'max' => 10, 	'step' => 0.1),
								'rem' => array('min' => 0.1, 	'max' => 10, 	'step' => 0.1),
								'vw' 	=> array('min' => 1, 		'max' => 100, 'step' => 1),
							)
						),

		  			array(
							'class' => 'toggled_header',
   						'title' => __('Content', 'mfn-opts'),
   					),

   					array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .desc_wrapper .desc:color',
							'type' => 'color',
							'class' => 'mfn-toggled',
							'title' => __('Color', 'mfn-opts'),
						),

   					array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .desc_wrapper .desc:typography',
							'type' => 'typography_vb',
							'label_after' => '<a href="#" title="Edit" class="mfn-option-btn mfn-option-blank btn-medium mfn-vb-label-button"><span class="mfn-icon mfn-icon-edit"></span></a>',
							'class' => 'mfn-toggled toggle_fields',
							'title' => __('Typography', 'mfn-opts'),
						),

						array(
							'type' => 'html',
							'html' => '</div>',
						),

   				),
   			),

				// Heading  --------------------------------------------------------

   			'heading' => array(
   				'type' => 'heading',
   				'title' => __('Heading', 'mfn-opts'),
   				'size' => '1/1',
   				'tablet_size' => '1/1',
   				'mobile_size' => '1/1',
   				'tablet_resized' => '0',
   				'cat' => 'typography',
   				'fields' => array(

						// HTML content

						array(
							'type' => 'html',
							'html' => $this->itemtabs,
						),

   					array(
							'type' => 'html',
							'html' => '<div class="modalbox-card modalbox-re_render modalbox-card-content-mfnuidhere active">',
						),

   					array(
   						'id' => 'title',
   						'type' => 'text',
   						'edit_tag' => '.mcb-item-heading-inner | .title',
   						'edit_position' => 'append',
   						'edit_tag_var' => 'preview-header_taginput',
   						'title' => __('Title', 'mfn-opts'),
							'std' => __('This is the heading', 'mfn-opts'),
							'preview' => 'title',
   					),

   					array(
							'id' => 'header_tag',
							're_render' => 'standard',
							'type' 	=> 'switch',
							're_render' => 'standard',
							'title' => __('Title tag', 'mfn-opts'),
							'options' => array(
								'h1' => 'H1',
								'h2' => 'H2',
								'h3' => 'H3',
								'h4' => 'H4',
								'h5' => 'H5',
								'h6' => 'H6',
							),
							'std' => 'h2',
						),

						// link

   					array(
   						'title' => __('Link', 'mfn-opts'),
   					),

   					array(
   						'id' => 'link',
   						'type' => 'text',
   						'title' => __('Link', 'mfn-opts'),
   					),

   					array(
   						'id' => 'target',
   						'type' => 'select',
   						'title' => __('Target', 'mfn-opts'),
   						'options' => array(
   							0 => __('Default | _self', 'mfn-opts'),
   							1 => __('New tab or window | _blank', 'mfn-opts'),
   							'lightbox' => __('Lightbox (image or embed video)', 'mfn-opts'),
   						),
   					),

						array(
							'type' => 'html',
							'html' => '</div><div class="modalbox-card modalbox-card-style modalbox-re_render modalbox-card-style-mfnuidhere">',
						),

						array(
   						'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .title:text-align',
							'responsive' => 'desktop',
   						'type' => 'switch',
   						'class' => 'mfn_field_desktop',
   						'title' => __('Text align', 'mfn-opts'),
   						'options' => array(
   							'' => __('Default', 'mfn-opts'),
   							'left' => __('Left', 'mfn-opts'),
								'center' => __('Center', 'mfn-opts'),
   							'right' => __('Right', 'mfn-opts'),
   							'justify' => __('Justify', 'mfn-opts'),
   						),
							'preview' => 'align',
   					),
   					array(
   						'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .title:text-align_tablet',
							'responsive' => 'tablet',
   						'type' => 'switch',
   						'class' => 'mfn_field_tablet',
   						'title' => __('Text align', 'mfn-opts'),
   						'options' => array(
   							'' => __('Default', 'mfn-opts'),
   							'left' => __('Left', 'mfn-opts'),
								'center' => __('Center', 'mfn-opts'),
   							'right' => __('Right', 'mfn-opts'),
   							'justify' => __('Justify', 'mfn-opts'),
   						),
							'preview' => 'align',
   					),
   					array(
   						'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .title:text-align_mobile',
							'responsive' => 'mobile',
   						'type' => 'switch',
   						'class' => 'mfn_field_mobile',
   						'title' => __('Text align', 'mfn-opts'),
   						'options' => array(
   							'' => __('Default', 'mfn-opts'),
   							'left' => __('Left', 'mfn-opts'),
								'center' => __('Center', 'mfn-opts'),
   							'right' => __('Right', 'mfn-opts'),
   							'justify' => __('Justify', 'mfn-opts'),
   						),
							'preview' => 'align',
   					),

   					array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .title,.mcb-section .mcb-wrap .mcb-item-mfnuidelement .title a:color',
							'type' => 'color',
							'desc' => __('May be overwritten by individual tags or inline CSS', 'mfn-opts'),
							'title' => __('Color', 'mfn-opts'),
						),

						array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .title:text-shadow',
							'type' => 'text_shadow',
							'title' => __('Text shadow', 'mfn-opts'),
						),

   					array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .title:typography',
							'type' => 'typography_vb',
							'label_after' => '<a href="#" title="Edit" class="mfn-option-btn mfn-option-blank btn-medium mfn-vb-label-button"><span class="mfn-icon mfn-icon-edit"></span></a>',
							'class' => 'toggle_fields',
							'title' => __('Typography', 'mfn-opts'),
						),

						// HTML end: settings

						array(
   						'type' => 'html',
   						'html' => '</div>',
   					),

   				),
   			),

   			// Helper -------------------------------------------------------

   			'helper' => array(
   				'type' => 'helper',
   				'title' => __('Helper', 'mfn-opts'),
   				'size' => '1/4',
   				'tablet_size' => '1/4',
   				'mobile_size' => '1/1',
   				'tablet_resized' => '0',
   				'cat' => 'blocks',
   				'fields' => array(

   					array(
							'type' => 'html',
							'html' => $this->itemtabs,
						),

   					array(
							'type' => 'html',
							'html' => '<div class="modalbox-card modalbox-re_render modalbox-card-content-mfnuidhere active">',
						),

   					array(
   						'id' => 'title',
   						'type' => 'text',
   						'edit_tag' => '.helper_header | .title',
   						'edit_position' => 'prepend',
   						'title' => __('Title', 'mfn-opts'),
							'std' => __('This is the title', 'mfn-opts'),
							'preview' => 'title',
   					),

   					array(
   						'id' => 'title_tag',
   						'type' => 'switch',
   						're_render' => 'standard',
   						'title' => __('Tag', 'mfn-opts'),
   						'options' => array(
   							'h1' => 'H1',
   							'h2' => 'H2',
   							'h3' => 'H3',
   							'h4' => 'H4',
   							'h5' => 'H5',
   							'h6' => 'H6',
   						),
   						'std' => 'h4',
   					),

						// item 1

   					array(
   						'title' => __('Item 1', 'mfn-opts'),
   					),

   					array(
   						'id' => 'title1',
   						'type' => 'text',
   						'title' => __('Title', 'mfn-opts'),
							'std' => __('This is the 1st item title', 'mfn-opts'),
   					),

   					array(
   						'id' => 'content1',
   						'type' => 'textarea',
   						'title' => __('Content', 'mfn-opts'),
   						'desc' => __('Some shortcodes and HTML tags allowed', 'mfn-opts'),
							'std' => 'Lorem ipsum dolor sit amet, consectetur adipiscing elit. Ut elit tellus, luctus nec ullamcorper mattis, pulvinar dapibus leo.',
							'class' => 'form-content-full-width',
   					),

   					array(
   						'id' => 'link1',
   						'type' => 'text',
   						'title' => __('Link', 'mfn-opts'),
   						'desc' => __('Use if you want to link to another page instead of showing the content', 'mfn-opts'),
   					),

   					array(
   						'id' => 'target1',
   						'type' => 'switch',
							'title' => __('Link target', 'mfn-opts'),
   						'options' => array(
								0 => __('_self', 'mfn-opts'),
								1 => __('_blank', 'mfn-opts'),
							),
							'std' => 0,
   					),

   					array(
   						'id' => 'class1',
   						'type' => 'text',
   						'title' => __('Link class', 'mfn-opts'),
   						'desc' => __('e.g. <b>prettyphoto</b> or <b>scroll</b>', 'mfn-opts'),
   					),

						// item 2

   					array(
   						'title' => __('Item 2', 'mfn-opts'),
   					),

   					array(
   						'id' => 'title2',
   						'type' => 'text',
   						'title' => __('Title', 'mfn-opts'),
   					),

   					array(
   						'id' => 'content2',
   						'type' => 'textarea',
   						'title' => __('Content', 'mfn-opts'),
   						'desc' => __('Some shortcodes and HTML tags allowed', 'mfn-opts'),
							'class' => 'form-content-full-width',
   					),

   					array(
   						'id' => 'link2',
   						'type' => 'text',
   						'title' => __('Link', 'mfn-opts'),
   						'desc' => __('Use if you want to link to another page instead of showing the content', 'mfn-opts'),
   					),

   					array(
   						'id' => 'target2',
   						'type' => 'switch',
							'title' => __('Link target', 'mfn-opts'),
   						'options' => array(
								0 => __('_self', 'mfn-opts'),
								1 => __('_blank', 'mfn-opts'),
							),
							'std' => 0,
   					),

   					array(
   						'id' => 'class2',
   						'type' => 'text',
   						'title' => __('Link class', 'mfn-opts'),
   						'desc' => __('e.g. <b>prettyphoto</b> or <b>scroll</b>', 'mfn-opts'),
   					),

						// deprecated

						array(
							'class' => 'mfn-deprecated',
							'title' => __('Deprecated', 'mfn-opts'),
						),

						array(
							'id' => 'class',
							'type' => 'pills',
							'title' => __('Element classes', 'mfn-opts'),
							'class' => 'mfn-deprecated',
						),

						array(
							'type' => 'html',
							'html' => '</div><div class="modalbox-card modalbox-card-style modalbox-re_render modalbox-card-style-mfnuidhere">',
						),

						array(
							'class' => 'toggled_header',
   						'title' => __('Title', 'mfn-opts'),
   					),

   					array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .helper_header .title:color',
							'type' => 'color',
							'class' => 'main-color mfn-toggled',
							'title' => __('Color', 'mfn-opts'),
						),

		  			array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .helper_header .title:typography',
							'type' => 'typography_vb',
							'label_after' => '<a href="#" title="Edit" class="mfn-option-btn mfn-option-blank btn-medium mfn-vb-label-button"><span class="mfn-icon mfn-icon-edit"></span></a>',
							'class' => 'mfn-toggled toggle_fields',
							'title' => __('Typography', 'mfn-opts'),
						),

						array(
							'class' => 'toggled_header',
   						'title' => __('Button', 'mfn-opts'),
   					),

   					array(
							'type' => 'html',
							'html' => '<div class="mfn-form-row mfn-sidebar-fields-tabs mfn-toggled mfn-vb-formrow mfn-vb-mfnuidhere"><ul class="mfn-sft-nav"><li class="active"><a href="#normal" data-tab="normal">Normal</a></li><li><a href="#hover" data-tab="hover">Active</a></li></ul><div class="mfn-sft mfn-sft-normal">',
						),

   					array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .helper_header .links .link:color',
							'type' => 'color',
							'class' => 'main-color mfn-toggled',
							'title' => __('Color', 'mfn-opts'),
						),

						array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .helper_header .links .link:background',
							'type' => 'color',
							'class' => 'main-color mfn-toggled',
							'title' => __('Background', 'mfn-opts'),
						),

						array(
							'type' => 'html',
							'html' => '</div><div class="mfn-sft mfn-sft-hover">',
						),

						array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .helper_header .links .link|hover,.mcb-section .mcb-wrap .mcb-item-mfnuidelement .helper_header .links .link.active:color',
							'type' => 'color',
							'class' => 'main-color mfn-toggled',
							'title' => __('Color', 'mfn-opts'),
						),

						array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .helper_header .links .link|hover,.mcb-section .mcb-wrap .mcb-item-mfnuidelement .helper_header .links .link.active:background',
							'type' => 'color',
							'class' => 'main-color mfn-toggled',
							'title' => __('Background', 'mfn-opts'),
						),

						array(
							'type' => 'html',
							'html' => '</div></div>',
						),

						array(
							'class' => 'toggled_header',
   						'title' => __('Content', 'mfn-opts'),
   					),

   					array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .helper_content .item:color',
							'type' => 'color',
							'class' => 'main-color mfn-toggled',
							'title' => __('Color', 'mfn-opts'),
						),

		  			array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .helper_content .item:typography',
							'type' => 'typography_vb',
							'label_after' => '<a href="#" title="Edit" class="mfn-option-btn mfn-option-blank btn-medium mfn-vb-label-button"><span class="mfn-icon mfn-icon-edit"></span></a>',
							'class' => 'mfn-toggled toggle_fields',
							'title' => __('Typography', 'mfn-opts'),
						),

						array(
							'type' => 'html',
							'html' => '</div>',
						),

   				),
   			),

   			// Hover Box ------------------------------------------------------

   			'hover_box' => array(
   				'type' => 'hover_box',
   				'title' => __('Hover Box', 'mfn-opts'),
   				'size' => '1/4',
   				'tablet_size' => '1/4',
   				'mobile_size' => '1/1',
   				'tablet_resized' => '0',
   				'cat' => 'boxes',
   				'fields' => array(

   					array(
							'type' => 'html',
							'html' => '<div class="modalbox-card modalbox-re_render modalbox-card-content-mfnuidhere active">',
						),

   					array(
   						'id' => 'image',
   						'type' => 'upload',
   						'title' => __('Image', 'mfn-opts'),
   						'desc' => __('Recommended image width <b>768px - 1920px</b> depending on size of the item', 'mfn-opts'),
							'std' => $this->get_placeholder(),
							'preview' => 'image',
   					),

   					array(
   						'id' => 'image_hover',
   						'type' => 'upload',
   						'title' => __('Hover image', 'mfn-opts'),
   						'desc' => __('Images must have the same size', 'mfn-opts'),
							'std' => $this->get_placeholder(),
   					),

						// link

   					array(
   						'title' => __('Link', 'mfn-opts'),
   					),

   					array(
   						'id' => 'link',
   						'type' => 'text',
   						'title' => __('Link', 'mfn-opts'),
   					),

   					array(
   						'id' => 'target',
   						'type' => 'select',
   						'title' => __('Target', 'mfn-opts'),
   						'options' => array(
   							0 => __('Default | _self', 'mfn-opts'),
   							1 => __('New tab or window | _blank', 'mfn-opts'),
   							'lightbox' => __('Lightbox (image or embed video)', 'mfn-opts'),
   						),
   					),

						// deprecated

						array(
							'class' => 'mfn-deprecated',
							'title' => __('Deprecated', 'mfn-opts'),
						),

						array(
							'id' => 'class',
							'type' => 'pills',
							'title' => __('Element classes', 'mfn-opts'),
							'class' => 'mfn-deprecated',
						),

						array(
							'type' => 'html',
							'html' => '</div>',
						),

   				),
   			),

   			// Hover Color ----------------------------------------------------

   			'hover_color' => array(
   				'type' => 'hover_color',
   				'title' => __('Hover Color', 'mfn-opts'),
   				'size' => '1/4',
   				'tablet_size' => '1/4',
   				'mobile_size' => '1/1',
   				'tablet_resized' => '0',
   				'cat' => 'elements',
   				'fields' => array(

   					array(
							'type' => 'html',
							'html' => $this->itemtabs,
						),

   					array(
							'type' => 'html',
							'html' => '<div class="modalbox-card modalbox-re_render modalbox-card-content-mfnuidhere active">',
						),

   					array(
   						'id' => 'content',
   						'edit_tag' => '.hover_color_bg | div.hover_color_wrapper',
   						'edit_position' => 'prepend',
   						'type' => 'textarea',
   						'title' => __('Content', 'mfn-opts'),
							'std' => 'Lorem ipsum dolor sit amet, consectetur adipiscing elit. Ut elit tellus, luctus nec ullamcorper mattis, pulvinar dapibus leo.',
							'preview' => 'content',
							'class' => 'form-content-full-width',
   					),

   					// link

   					array(
   						'title' => __('Link', 'mfn-opts'),
   					),

   					array(
   						'id' => 'link',
   						'type' => 'text',
   						'title' => __('Link', 'mfn-opts'),
   					),

   					array(
   						'id' => 'target',
   						'type' => 'select',
   						'title' => __('Target', 'mfn-opts'),
   						'options' => array(
   							0 => __('Default | _self', 'mfn-opts'),
   							1 => __('New tab or window | _blank', 'mfn-opts'),
   							'lightbox' => __('Lightbox (image or embed video)', 'mfn-opts'),
   						),
   					),

   					array(
   						'id' => 'class',
   						'type' => 'text',
   						'title' => __('Class', 'mfn-opts'),
   						'desc' => __('e.g. <b>scroll</b>', 'mfn-opts'),
   					),

						// deprecated

   					array(
   						'class' => 'mfn-deprecated',
   						'title' => __('Deprecated', 'mfn-opts'),
   					),

						array(
   						'id' => 'align',
   						'class' => 'mfn-deprecated',
   						'type' => 'switch',
   						'title' => __('Text alignment', 'mfn-opts'),
   						'options' => array(
   							'left' => __('Left', 'mfn-opts'),
   							'' => __('Center', 'mfn-opts'),
								'right' => __('Right', 'mfn-opts'),
   							'justify' => __('Justify', 'mfn-opts'),
   						),
							'std' => 'left',
   					),

   					array(
   						'id' => 'padding',
   						'class' => 'mfn-deprecated',
   						'type' => 'text',
   						'title' => __('Padding', 'mfn-opts'),
   						'desc' => __('Use value with <b>px</b> or <b>%</b>. Example: <b>20px</b> or <b>20px 10px 20px 10px</b> or <b>20px 1%</b>', 'mfn-opts'),
   					),

   					array(
   						'id' => 'background',
   						'class' => 'mfn-deprecated',
   						'type' => 'color',
   						'title' => __('Background color', 'mfn-opts'),
   					),

   					array(
   						'id' => 'background_hover',
   						'class' => 'mfn-deprecated',
   						'type' => 'color',
   						'title' => __('Background color hover', 'mfn-opts'),
   					),

   					array(
   						'id' => 'border',
   						'class' => 'mfn-deprecated',
   						'type' => 'color',
   						'title' => __('Border color', 'mfn-opts'),
   					),

   					array(
   						'id' => 'border_hover',
   						'class' => 'mfn-deprecated',
   						'type' => 'color',
   						'title' => __('Border color hover', 'mfn-opts'),
   					),

   					array(
   						'id' => 'border_width',
   						'class' => 'mfn-deprecated',
   						'type' => 'text',
   						'title' => __('Border width', 'mfn-opts'),
   						'desc' => __('Use value with <b>px</b>. Example: <b>1px</b> or <b>2px 5px 2px 5px</b>', 'mfn-opts'),
   					),

						array(
							'id' => 'class',
							'type' => 'pills',
							'title' => __('Element classes', 'mfn-opts'),
							'class' => 'mfn-deprecated',
						),

						array(
							'id' => 'style',
							'type' => 'textarea',
							'title' => __('Element inline CSS', 'mfn-opts'),
							'desc' => __('Example: <b>opacity: 0.5;</b>', 'mfn-opts'),
							'class' => 'mfn-deprecated',
						),

   					array(
							'type' => 'html',
							'html' => '</div><div class="modalbox-card modalbox-card-style modalbox-re_render modalbox-card-style-mfnuidhere">',
						),

						array(
							'class' => 'toggled_header',
   						'title' => __('Content', 'mfn-opts'),
   					),

						array(
   						'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .hover_color_wrapper:text-align',
							'responsive' => 'desktop',
   						'type' => 'switch',
   						'class' => 'mfn-toggled mfn_field_desktop',
   						'title' => __('Align', 'mfn-opts'),
   						'options' => array(
   							'' => __('Default', 'mfn-opts'),
   							'left' => __('Left', 'mfn-opts'),
								'center' => __('Center', 'mfn-opts'),
   							'right' => __('Right', 'mfn-opts'),
   							'justify' => __('Justify', 'mfn-opts'),
   						),
							'preview' => 'align',
   					),

   					array(
   						'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .hover_color_wrapper:text-align_tablet',
							'responsive' => 'tablet',
   						'type' => 'switch',
   						'class' => 'mfn-toggled mfn_field_tablet',
   						'title' => __('Align', 'mfn-opts'),
   						'options' => array(
   							'' => __('Default', 'mfn-opts'),
   							'left' => __('Left', 'mfn-opts'),
								'center' => __('Center', 'mfn-opts'),
   							'right' => __('Right', 'mfn-opts'),
   							'justify' => __('Justify', 'mfn-opts'),
   						),
							'preview' => 'align',
   					),

   					array(
   						'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .hover_color_wrapper:text-align_mobile',
							'responsive' => 'mobile',
   						'type' => 'switch',
   						'class' => 'mfn-toggled mfn_field_mobile',
   						'title' => __('Align', 'mfn-opts'),
   						'options' => array(
   							'' => __('Default', 'mfn-opts'),
   							'left' => __('Left', 'mfn-opts'),
								'center' => __('Center', 'mfn-opts'),
   							'right' => __('Right', 'mfn-opts'),
   							'justify' => __('Justify', 'mfn-opts'),
   						),
							'preview' => 'align',
   					),

   					array(
		  				'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mcb-column-inner .hover_color_wrapper:padding',
		  				'type' => 'dimensions',
		  				'version' => 'separated-fields',
		  				'title' => __('Padding', 'mfn-opts'),
							'responsive' => 'desktop',
							'class' => 'mfn_field_desktop mfn-toggled',
							'css_attr' => 'padding',
		  			),

		  			array(
		  				'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mcb-column-inner .hover_color_wrapper:padding_tablet',
		  				'type' => 'dimensions',
		  				'version' => 'separated-fields',
		  				'title' => __('Padding', 'mfn-opts'),
							'responsive' => 'tablet',
							'class' => 'mfn_field_tablet mfn-toggled',
							'css_attr' => 'padding',
		  			),

		  			array(
		  				'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mcb-column-inner .hover_color_wrapper:padding_mobile',
		  				'type' => 'dimensions',
		  				'version' => 'separated-fields',
		  				'title' => __('Padding', 'mfn-opts'),
							'responsive' => 'mobile',
							'class' => 'mfn_field_mobile mfn-toggled',
							'css_attr' => 'padding',
		  			),

   					array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .hover_color_wrapper:typography',
							'type' => 'typography_vb',
							'label_after' => '<a href="#" title="Edit" class="mfn-option-btn mfn-option-blank btn-medium mfn-vb-label-button"><span class="mfn-icon mfn-icon-edit"></span></a>',
							'class' => 'mfn-toggled toggle_fields',
							'title' => __('Typography', 'mfn-opts'),
						),

						array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mcb-column-inner:border-style',
							'type' => 'select',
							'attr_id' => 'border_style_hc',
							'class' => 'mfn-toggled',
							'title' => __('Border style', 'mfn-opts'),
							'options' => [
								'none' => __('None', 'mfn-opts'),
								'solid' => __('Solid', 'mfn-opts'),
								'dashed' => __('Dashed', 'mfn-opts'),
								'dotted' => __('Dotted', 'mfn-opts'),
								'double' => __('Double', 'mfn-opts'),
							],
						),

						array(
		  				'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mcb-column-inner:border-width',
		  				'condition' => array( 'id' => 'border_style_hc', 'opt' => 'isnt', 'val' => 'none' ),
		  				'type' => 'dimensions',
		  				'title' => __('Border width', 'mfn-opts'),
							'responsive' => 'desktop',
							'class' => 'mfn_field_desktop mfn-toggled',
							'css_attr' => 'border-width',
		  			),

		  			array(
		  				'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mcb-column-inner:border-width_tablet',
		  				'condition' => array( 'id' => 'border_style_hc', 'opt' => 'isnt', 'val' => 'none' ),
		  				'type' => 'dimensions',
		  				'title' => __('Border width', 'mfn-opts'),
							'responsive' => 'tablet',
							'class' => 'mfn_field_tablet mfn-toggled',
							'css_attr' => 'border-width',
		  			),

		  			array(
		  				'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mcb-column-inner:border-width_mobile',
		  				'condition' => array( 'id' => 'border_style_hc', 'opt' => 'isnt', 'val' => 'none' ),
		  				'type' => 'dimensions',
		  				'title' => __('Border width', 'mfn-opts'),
							'responsive' => 'mobile',
							'class' => 'mfn_field_mobile mfn-toggled',
							'css_attr' => 'border-width',
		  			),

						array(
		  				'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mcb-column-inner:border-radius',
		  				'type' => 'dimensions',
		  				'title' => __('Border radius', 'mfn-opts'),
							'responsive' => 'desktop',
							'class' => 'mfn_field_desktop mfn-toggled',
							'css_attr' => 'border-radius',
		  			),

		  			array(
		  				'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mcb-column-inner:border-radius_tablet',
		  				'type' => 'dimensions',
		  				'title' => __('Border radius', 'mfn-opts'),
							'responsive' => 'tablet',
							'class' => 'mfn_field_tablet mfn-toggled',
							'css_attr' => 'border-radius',
		  			),

		  			array(
		  				'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mcb-column-inner:border-radius_mobile',
		  				'type' => 'dimensions',
		  				'title' => __('Border radius', 'mfn-opts'),
							'responsive' => 'mobile',
							'class' => 'mfn_field_mobile mfn-toggled',
							'css_attr' => 'border-radius',
		  			),

		  			array(
		  				'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mcb-column-inner:box-shadow',
		  				'type' => 'box_shadow',
		  				'title' => __('Box shadow', 'mfn-opts'),
							'responsive' => 'desktop',
							'class' => 'mfn_field_desktop mfn-toggled',
							'css_attr' => 'box-shadow'
		  			),

		  			array(
		  				'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mcb-column-inner:box-shadow_tablet',
		  				'type' => 'box_shadow',
		  				'title' => __('Box shadow', 'mfn-opts'),
							'responsive' => 'tablet',
							'class' => 'mfn_field_tablet mfn-toggled',
							'css_attr' => 'box-shadow',
		  			),

		  			array(
		  				'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mcb-column-inner:box-shadow_mobile',
		  				'type' => 'box_shadow',
		  				'title' => __('Box shadow', 'mfn-opts'),
							'responsive' => 'mobile',
							'class' => 'mfn_field_mobile mfn-toggled',
							'css_attr' => 'box-shadow',
		  			),

						array(
							'type' => 'html',
							'html' => '<div class="mfn-form-row mfn-sidebar-fields-tabs mfn-toggled mfn-vb-formrow mfn-vb-mfnuidhere"><ul class="mfn-sft-nav"><li class="active"><a href="#normal" data-tab="normal">Normal</a></li><li><a href="#hover" data-tab="hover">Hover</a></li></ul><div class="mfn-sft mfn-sft-normal">',
						),

   					array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .hover_color_wrapper:color',
							'type' => 'color',
							'class' => 'main-color mfn-toggled',
							'title' => __('Color', 'mfn-opts'),
						),

						array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mcb-column-inner:background-color',
							'type' => 'color',
							'class' => 'main-color mfn-toggled',
							'title' => __('Background', 'mfn-opts'),
						),

						array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mcb-column-inner:border-color',
							'condition' => array( 'id' => 'border_style_hc', 'opt' => 'isnt', 'val' => 'none' ),
							'type' => 'color',
							'class' => 'mfn-toggled',
							'title' => __('Border color', 'mfn-opts'),
						),

						array(
							'type' => 'html',
							'html' => '</div><div class="mfn-sft mfn-sft-hover">',
						),

						array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement|hover .hover_color_wrapper:color',
							'type' => 'color',
							'class' => 'main-color mfn-toggled',
							'title' => __('Color', 'mfn-opts'),
						),

						array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mcb-column-inner|hover:background-color',
							'type' => 'color',
							'class' => 'main-color mfn-toggled',
							'title' => __('Background', 'mfn-opts'),
						),

						array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mcb-column-inner|hover:border-color',
							'condition' => array( 'id' => 'border_style_hc', 'opt' => 'isnt', 'val' => 'none' ),
							'type' => 'color',
							'class' => 'mfn-toggled',
							'title' => __('Border color', 'mfn-opts'),
						),

						array(
							'type' => 'html',
							'html' => '</div></div>',
						),

						array(
							'type' => 'html',
							'html' => '</div>',
						),


   				),
   			),

   			// How It Works ---------------------------------------------------

   			'how_it_works' => array(
   				'type' => 'how_it_works',
   				'title' => __('How It Works', 'mfn-opts'),
   				'size' => '1/4',
   				'tablet_size' => '1/4',
   				'mobile_size' => '1/1',
   				'tablet_resized' => '0',
   				'cat' => 'elements',
   				'fields' => array(

   					array(
							'type' => 'html',
							'html' => $this->itemtabs,
						),

   					array(
							'type' => 'html',
							'html' => '<div class="modalbox-card modalbox-re_render modalbox-card-content-mfnuidhere active">',
						),

						array(
   						'id' => 'title',
   						'type' => 'text',
   						'edit_tag' => '.how_it_works | h4.title',
   						'edit_position' => 'append',
   						'title' => __('Title', 'mfn-opts'),
							'std' => __('This is the title', 'mfn-opts'),
							'preview' => 'title',
   					),

   					array(
   						'id' => 'image',
   						'type' => 'upload',
   						'title' => __('Background', 'mfn-opts'),
   						'desc' => __('Recommended: Square Image with transparent background.', 'mfn-opts'),
							'preview' => 'image',
   					),

   					array(
   						'id' => 'number',
   						'type' => 'text',
   						'title' => __('Number', 'mfn-opts'),
   						'param' => 'number',
   						'class' => 'narrow',
   						'std' => '1',
							'preview' => 'number',
   					),

   					array(
   						'id' => 'content',
   						'type' => 'textarea',
   						'edit_tag' => '.how_it_works | div.desc',
   						'edit_position' => 'append',
   						'title' => __('Content', 'mfn-opts'),
							'std' => 'Lorem ipsum dolor sit amet, consectetur adipiscing elit. Ut elit tellus, luctus nec ullamcorper mattis, pulvinar dapibus leo.',
							'preview' => 'content',
							'class' => 'form-content-full-width',
   					),

   					// style

   					array(
   						'title' => __('Style', 'mfn-opts'),
   					),

   					array(
   						'id' => 'border',
   						'type' => 'switch',
   						're_render' => 'standard',
   						'title' => __('Line', 'mfn-opts'),
   						'options' => array(
   							0 => __('Hide', 'mfn-opts'),
   							1 => __('Show', 'mfn-opts'),
   						),
							'std' => 0,
   					),

   					array(
   						'id' => 'style',
   						'type' => 'select',
   						're_render' => 'standard',
   						'title' => __('Style', 'mfn-opts'),
   						'options' => array(
   							'' => __('Small centered image (image size: max 116px)', 'mfn-opts'),
   							'fill' => __('Fill the circle (image size: 200px x 200px)', 'mfn-opts'),
   						),
   					),

   					// link

   					array(
   						'title' => __('Link', 'mfn-opts'),
   					),

   					array(
   						'id' => 'link',
   						'type' => 'text',
   						'title' => __('Link', 'mfn-opts'),
   					),

   					array(
   						'id' => 'target',
   						'type' => 'select',
   						'title' => __('Target', 'mfn-opts'),
   						'options' => array(
   							0 => __('Default | _self', 'mfn-opts'),
   							1 => __('New tab or window | _blank', 'mfn-opts'),
   							'lightbox' => __('Lightbox (image or embed video)', 'mfn-opts'),
   						),
   					),

						// deprecated

						array(
							'class' => 'mfn-deprecated',
							'title' => __('Deprecated', 'mfn-opts'),
						),

						array(
							'id' => 'class',
							'type' => 'pills',
							'title' => __('Element classes', 'mfn-opts'),
							'class' => 'mfn-deprecated',
						),

   					array(
							'type' => 'html',
							'html' => '</div><div class="modalbox-card modalbox-card-style modalbox-re_render modalbox-card-style-mfnuidhere">',
						),

   					array(
							'class' => 'toggled_header',
   						'title' => __('Title', 'mfn-opts'),
   					),

   					array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .how_it_works .title:color',
							'type' => 'color',
							'class' => 'main-color mfn-toggled',
							'title' => __('Color', 'mfn-opts'),
						),

		  			array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .how_it_works .title:typography',
							'type' => 'typography_vb',
							'label_after' => '<a href="#" title="Edit" class="mfn-option-btn mfn-option-blank btn-medium mfn-vb-label-button"><span class="mfn-icon mfn-icon-edit"></span></a>',
							'class' => 'mfn-toggled toggle_fields',
							'title' => __('Typography', 'mfn-opts'),
						),

						array(
							'class' => 'toggled_header',
   						'title' => __('Content', 'mfn-opts'),
   					),

   					array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .how_it_works .desc:color',
							'type' => 'color',
							'class' => 'main-color mfn-toggled',
							'title' => __('Color', 'mfn-opts'),
						),

		  			array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .how_it_works .desc:typography',
							'type' => 'typography_vb',
							'label_after' => '<a href="#" title="Edit" class="mfn-option-btn mfn-option-blank btn-medium mfn-vb-label-button"><span class="mfn-icon mfn-icon-edit"></span></a>',
							'class' => 'mfn-toggled toggle_fields',
							'title' => __('Typography', 'mfn-opts'),
						),

						array(
							'class' => 'toggled_header',
   						'title' => __('Number', 'mfn-opts'),
   					),

   					array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .how_it_works .number:color',
							'type' => 'color',
							'class' => 'main-color mfn-toggled',
							'title' => __('Color', 'mfn-opts'),
						),

						array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .how_it_works .number:background-color',
							'type' => 'color',
							'class' => 'main-color mfn-toggled',
							'title' => __('Background', 'mfn-opts'),
						),

						array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .how_it_works .number:border-style',
							'attr_id' => 'border_style_hiw_number',
							'type' => 'select',
							'class' => 'mfn-toggled',
							'title' => __('Border style', 'mfn-opts'),
							'options' => [
								'none' => __('None', 'mfn-opts'),
								'solid' => __('Solid', 'mfn-opts'),
								'dashed' => __('Dashed', 'mfn-opts'),
								'dotted' => __('Dotted', 'mfn-opts'),
								'double' => __('Double', 'mfn-opts'),
							],
						),

						array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .how_it_works .number:border-color',
							'condition' => array( 'id' => 'border_style_hiw_number', 'opt' => 'isnt', 'val' => 'none' ),
							'type' => 'color',
							'class' => 'mfn-toggled',
							'title' => __('Border color', 'mfn-opts'),
						),

						array(
		  				'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .how_it_works .number:border-width',
		  				'condition' => array( 'id' => 'border_style_hiw_number', 'opt' => 'isnt', 'val' => 'none' ),
		  				'type' => 'dimensions',
		  				'title' => __('Border width', 'mfn-opts'),
							'responsive' => 'desktop',
							'class' => 'mfn_field_desktop mfn-toggled',
							'css_attr' => 'border-width',
		  			),

		  			array(
		  				'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .how_it_works .number:border-width_tablet',
		  				'condition' => array( 'id' => 'border_style_hiw_number', 'opt' => 'isnt', 'val' => 'none' ),
		  				'type' => 'dimensions',
		  				'title' => __('Border width', 'mfn-opts'),
							'responsive' => 'tablet',
							'class' => 'mfn_field_tablet mfn-toggled',
							'css_attr' => 'border-width',
		  			),

		  			array(
		  				'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .how_it_works .number:border-width_mobile',
		  				'condition' => array( 'id' => 'border_style_hiw_number', 'opt' => 'isnt', 'val' => 'none' ),
		  				'type' => 'dimensions',
		  				'title' => __('Border width', 'mfn-opts'),
							'responsive' => 'mobile',
							'class' => 'mfn_field_mobile mfn-toggled',
							'css_attr' => 'border-width',
		  			),

						array(
		  				'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .how_it_works .number:border-radius',
		  				'type' => 'dimensions',
		  				'title' => __('Border radius', 'mfn-opts'),
							'responsive' => 'desktop',
							'class' => 'mfn_field_desktop mfn-toggled',
							'css_attr' => 'border-radius',
		  			),

		  			array(
		  				'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .how_it_works .number:border-radius_tablet',
		  				'type' => 'dimensions',
		  				'title' => __('Border radius', 'mfn-opts'),
							'responsive' => 'tablet',
							'class' => 'mfn_field_tablet mfn-toggled',
							'css_attr' => 'border-radius',
		  			),

		  			array(
		  				'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .how_it_works .number:border-radius_mobile',
		  				'type' => 'dimensions',
		  				'title' => __('Border radius', 'mfn-opts'),
							'responsive' => 'mobile',
							'class' => 'mfn_field_mobile mfn-toggled',
							'css_attr' => 'border-radius',
		  			),

		  			array(
		  				'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .how_it_works .number:box-shadow',
		  				'type' => 'box_shadow',
		  				'title' => __('Box shadow', 'mfn-opts'),
							'responsive' => 'desktop',
							'class' => 'mfn_field_desktop mfn-toggled',
							'css_attr' => 'box-shadow'
		  			),

		  			array(
		  				'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .how_it_works .number:box-shadow_tablet',
		  				'type' => 'box_shadow',
		  				'title' => __('Box shadow', 'mfn-opts'),
							'responsive' => 'tablet',
							'class' => 'mfn_field_tablet mfn-toggled',
							'css_attr' => 'box-shadow',
		  			),

		  			array(
		  				'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .how_it_works .number:box-shadow_mobile',
		  				'type' => 'box_shadow',
		  				'title' => __('Box shadow', 'mfn-opts'),
							'responsive' => 'mobile',
							'class' => 'mfn_field_mobile mfn-toggled',
							'css_attr' => 'box-shadow',
		  			),

		  			array(
							'class' => 'toggled_header',
   						'title' => __('Image', 'mfn-opts'),
   					),

   					array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .how_it_works .image:background-color',
							'type' => 'color',
							'class' => 'main-color mfn-toggled',
							'title' => __('Background', 'mfn-opts'),
						),

		  			array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .how_it_works .image:border-style',
							'attr_id' => 'border_style_hiw_img',
							'type' => 'select',
							'class' => 'mfn-toggled',
							'title' => __('Border style', 'mfn-opts'),
							'options' => [
								'none' => __('None', 'mfn-opts'),
								'solid' => __('Solid', 'mfn-opts'),
								'dashed' => __('Dashed', 'mfn-opts'),
								'dotted' => __('Dotted', 'mfn-opts'),
								'double' => __('Double', 'mfn-opts'),
							],
						),

						array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .how_it_works .image:border-color',
							'condition' => array( 'id' => 'border_style_hiw_img', 'opt' => 'isnt', 'val' => 'none' ),
							'type' => 'color',
							'class' => 'mfn-toggled',
							'title' => __('Border color', 'mfn-opts'),
						),

						array(
		  				'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .how_it_works .image:border-width',
		  				'condition' => array( 'id' => 'border_style_hiw_img', 'opt' => 'isnt', 'val' => 'none' ),
		  				'type' => 'dimensions',
		  				'title' => __('Border width', 'mfn-opts'),
							'responsive' => 'desktop',
							'class' => 'mfn_field_desktop mfn-toggled',
							'css_attr' => 'border-width',
		  			),

		  			array(
		  				'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .how_it_works .image:border-width_tablet',
		  				'condition' => array( 'id' => 'border_style_hiw_img', 'opt' => 'isnt', 'val' => 'none' ),
		  				'type' => 'dimensions',
		  				'title' => __('Border width', 'mfn-opts'),
							'responsive' => 'tablet',
							'class' => 'mfn_field_tablet mfn-toggled',
							'css_attr' => 'border-width',
		  			),

		  			array(
		  				'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .how_it_works .image:border-width_mobile',
		  				'condition' => array( 'id' => 'border_style_hiw_img', 'opt' => 'isnt', 'val' => 'none' ),
		  				'type' => 'dimensions',
		  				'title' => __('Border width', 'mfn-opts'),
							'responsive' => 'mobile',
							'class' => 'mfn_field_mobile mfn-toggled',
							'css_attr' => 'border-width',
		  			),

						array(
		  				'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .how_it_works .image:border-radius',
		  				'type' => 'dimensions',
		  				'title' => __('Border radius', 'mfn-opts'),
							'responsive' => 'desktop',
							'class' => 'mfn_field_desktop mfn-toggled',
							'css_attr' => 'border-radius',
		  			),

		  			array(
		  				'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .how_it_works .image:border-radius_tablet',
		  				'type' => 'dimensions',
		  				'title' => __('Border radius', 'mfn-opts'),
							'responsive' => 'tablet',
							'class' => 'mfn_field_tablet mfn-toggled',
							'css_attr' => 'border-radius',
		  			),

		  			array(
		  				'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .how_it_works .image:border-radius_mobile',
		  				'type' => 'dimensions',
		  				'title' => __('Border radius', 'mfn-opts'),
							'responsive' => 'mobile',
							'class' => 'mfn_field_mobile mfn-toggled',
							'css_attr' => 'border-radius',
		  			),

		  			array(
		  				'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .how_it_works .image_wrapper:margin',
		  				'type' => 'dimensions',
		  				'title' => __('Margin', 'mfn-opts'),
		  				'version' => 'separated-fields',
							'responsive' => 'desktop',
							'class' => 'mfn_field_desktop mfn-toggled',
							'css_attr' => 'margin',
		  			),

		  			array(
		  				'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .how_it_works .image_wrapper:margin_tablet',
		  				'type' => 'dimensions',
		  				'title' => __('Margin', 'mfn-opts'),
		  				'version' => 'separated-fields',
							'responsive' => 'tablet',
							'class' => 'mfn_field_tablet mfn-toggled',
							'css_attr' => 'margin',
		  			),

		  			array(
		  				'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .how_it_works .image_wrapper:margin_mobile',
		  				'type' => 'dimensions',
		  				'title' => __('Margin', 'mfn-opts'),
		  				'version' => 'separated-fields',
							'responsive' => 'mobile',
							'class' => 'mfn_field_mobile mfn-toggled',
							'css_attr' => 'margin',
		  			),

		  			array(
							'class' => 'toggled_header',
   						'title' => __('Line', 'mfn-opts'),
   					),

   					array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .how_it_works.has_border|after:background-color',
							'type' => 'color',
							'class' => 'main-color mfn-toggled',
							'title' => __('Color', 'mfn-opts'),
						),

						array(
							'class' => 'toggled_header',
							'themeoptions' => 'style:simple',
   						'title' => __('Divider', 'mfn-opts'),
   					),

   					array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .how_it_works .image:border-color',
							'type' => 'color',
							'themeoptions' => 'style:simple',
							'class' => 'main-color mfn-toggled',
							'title' => __('Color', 'mfn-opts'),
						),

						array(
							'type' => 'html',
							'html' => '</div>',
						),

   				),
   			),

   			// Icon Box  ------------------------------------------------------

   			'icon_box' => array(
   				'type' => 'icon_box',
   				'title' => __('Icon Box', 'mfn-opts'),
   				'size' => '1/4',
   				'tablet_size' => '1/4',
   				'mobile_size' => '1/1',
   				'tablet_resized' => '0',
   				'cat' => 'boxes',
   				'fields' => array(

   					array(
							'type' => 'html',
							'html' => $this->itemtabs,
						),

   					array(
							'type' => 'html',
							'html' => '<div class="modalbox-card modalbox-re_render modalbox-card-content-mfnuidhere active">',
						),

   					array(
   						'id' => 'title',
   						'type' => 'text',
   						'edit_tag' => '.icon_box .desc_wrapper | .title',
   						'edit_position' => 'prepend',
   						'title' => __('Title', 'mfn-opts'),
							'std' => __('This is the title', 'mfn-opts'),
							'preview' => 'title',
   					),

   					array(
   						'id' => 'title_tag',
   						'type' => 'switch',
   						're_render' => 'standard',
   						'title' => __('Tag', 'mfn-opts'),
   						'options' => array(
   							'h1' => 'H1',
   							'h2' => 'H2',
   							'h3' => 'H3',
   							'h4' => 'H4',
   							'h5' => 'H5',
   							'h6' => 'H6',
   						),
   						'std' => 'h4'
   					),

   					array(
   						'id' => 'content',
   						'type' => 'textarea',
   						'edit_tag' => '.icon_box .desc_wrapper | .desc',
   						'edit_position' => 'prepend',
   						'title' => __('Content', 'mfn-opts'),
							'std' => 'Lorem ipsum dolor sit amet, consectetur adipiscing elit. Ut elit tellus, luctus nec ullamcorper mattis, pulvinar dapibus leo.',
							'preview' => 'content',
							'class' => 'form-content-full-width',
   					),

   					// icon

   					array(
   						'title' => __('Icon', 'mfn-opts'),
   					),

   					array(
   						'id' => 'icon',
   						'type' => 'icon',
   						'title' => __('Icon', 'mfn-opts'),
   						'std' => 'icon-lamp',
   						'preview' => 'icon',
   					),

						array(
   						'id' => 'icon_position',
   						'type' => 'switch',
   						're_render' => 'standard',
   						'title' => __('Icon position', 'mfn-opts'),
   						'desc' => __('Left position works only for column widths: 1/4, 1/3 & 1/2', 'mfn-opts'),
   						'options' => array(
   							'left' => __('Left', 'mfn-opts'),
   							'top' => __('Top', 'mfn-opts'),
   						),
   						'std' => 'top',
   					),

   					array(
   						'id' => 'image',
   						'type' => 'upload',
   						'title' => __('Image', 'mfn-opts'),
							'preview' => 'image',
   					),

   					// link

   					array(
   						'title' => __('Link', 'mfn-opts'),
   					),

   					array(
   						'id' => 'link',
   						'type' => 'text',
   						'title' => __('Link', 'mfn-opts'),
   					),

   					array(
   						'id' => 'target',
   						'type' => 'select',
   						'title' => __('Target', 'mfn-opts'),
   						'options' => array(
   							0 => __('Default | _self', 'mfn-opts'),
   							1 => __('New tab or window | _blank', 'mfn-opts'),
   							'lightbox' => __('Lightbox (image or embed video)', 'mfn-opts'),
   						),
   					),

						// deprecated

						array(
							'class' => 'mfn-deprecated',
							'title' => __('Deprecated', 'mfn-opts'),
						),

		  			array(
   						'id' => 'border',
   						'class' => 'mfn-deprecated',
   						'type' => 'switch',
   						'title' => __('Border', 'mfn-opts'),
   						'options' => array(
   							0 => __('Hide', 'mfn-opts'),
   							1 => __('Show', 'mfn-opts'),
   						),
							'std' => 0,
   					),

						array(
							'id' => 'class',
							'type' => 'pills',
							'title' => __('Element classes', 'mfn-opts'),
							'class' => 'mfn-deprecated',
						),

		  			array(
							'type' => 'html',
							'html' => '</div><div class="modalbox-card modalbox-card-style modalbox-re_render modalbox-card-style-mfnuidhere">',
						),


						array(
							'class' => 'toggled_header',
   						'title' => __('Icon', 'mfn-opts'),
   					),

   					array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .icon_box .icon_wrapper i:font-size',
							'type' => 'sliderbar',
							'responsive' => 'desktop',
							'class' => 'mfn_field_desktop mfn-toggled',
							'title' => __('Size', 'mfn-opts'),
							'units' => array(
								'px' 	=> array('min' => 1, 		'max' => 100, 'step' => 1),
								'em' 	=> array('min' => 0.1, 	'max' => 10, 	'step' => 0.1),
								'rem' => array('min' => 0.1, 	'max' => 10, 	'step' => 0.1),
								'vw' 	=> array('min' => 1, 		'max' => 100, 'step' => 1),
							)
						),

						array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .icon_box .icon_wrapper i:font-size_tablet',
							'type' => 'sliderbar',
							'responsive' => 'tablet',
							'class' => 'mfn_field_tablet mfn-toggled',
							'title' => __('Size', 'mfn-opts'),
							'units' => array(
								'px' 	=> array('min' => 1, 		'max' => 100, 'step' => 1),
								'em' 	=> array('min' => 0.1, 	'max' => 10, 	'step' => 0.1),
								'rem' => array('min' => 0.1, 	'max' => 10, 	'step' => 0.1),
								'vw' 	=> array('min' => 1, 		'max' => 100, 'step' => 1),
							)
						),

						array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .icon_box .icon_wrapper i:font-size_mobile',
							'type' => 'sliderbar',
							'responsive' => 'mobile',
							'class' => 'mfn_field_mobile mfn-toggled',
							'title' => __('Size', 'mfn-opts'),
							'units' => array(
								'px' 	=> array('min' => 1, 		'max' => 100, 'step' => 1),
								'em' 	=> array('min' => 0.1, 	'max' => 10, 	'step' => 0.1),
								'rem' => array('min' => 0.1, 	'max' => 10, 	'step' => 0.1),
								'vw' 	=> array('min' => 1, 		'max' => 100, 'step' => 1),
							)
						),

   					array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .icon_box .icon_wrapper:border-style',
							'attr_id' => 'border_style_ib_icon',
							'type' => 'select',
							'class' => 'mfn-toggled',
							'title' => __('Border style', 'mfn-opts'),
							'options' => [
								'none' => __('None', 'mfn-opts'),
								'solid' => __('Solid', 'mfn-opts'),
								'dashed' => __('Dashed', 'mfn-opts'),
								'dotted' => __('Dotted', 'mfn-opts'),
								'double' => __('Double', 'mfn-opts'),
							],
						),

						array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .icon_box .icon_wrapper:border-color',
							'condition' => array( 'id' => 'border_style_ib_icon', 'opt' => 'isnt', 'val' => 'none' ),
							'type' => 'color',
							'class' => 'mfn-toggled',
							'title' => __('Border color', 'mfn-opts'),
						),

						array(
		  				'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .icon_box .icon_wrapper:border-width',
		  				'condition' => array( 'id' => 'border_style_ib_icon', 'opt' => 'isnt', 'val' => 'none' ),
		  				'type' => 'dimensions',
		  				'title' => __('Border width', 'mfn-opts'),
							'responsive' => 'desktop',
							'class' => 'mfn_field_desktop mfn-toggled',
							'css_attr' => 'border-width',
		  			),

		  			array(
		  				'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .icon_box .icon_wrapper:border-width_tablet',
		  				'condition' => array( 'id' => 'border_style_ib_icon', 'opt' => 'isnt', 'val' => 'none' ),
		  				'type' => 'dimensions',
		  				'title' => __('Border width', 'mfn-opts'),
							'responsive' => 'tablet',
							'class' => 'mfn_field_tablet mfn-toggled',
							'css_attr' => 'border-width',
		  			),

		  			array(
		  				'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .icon_box .icon_wrapper:border-width_mobile',
		  				'condition' => array( 'id' => 'border_style_ib_icon', 'opt' => 'isnt', 'val' => 'none' ),
		  				'type' => 'dimensions',
		  				'title' => __('Border width', 'mfn-opts'),
							'responsive' => 'mobile',
							'class' => 'mfn_field_mobile mfn-toggled',
							'css_attr' => 'border-width',
		  			),

						array(
		  				'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .icon_box .icon_wrapper:border-radius',
		  				'type' => 'dimensions',
		  				'title' => __('Border radius', 'mfn-opts'),
							'responsive' => 'desktop',
							'class' => 'mfn_field_desktop mfn-toggled',
							'css_attr' => 'border-radius',
		  			),

		  			array(
		  				'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .icon_box .icon_wrapper:border-radius_tablet',
		  				'type' => 'dimensions',
		  				'title' => __('Border radius', 'mfn-opts'),
							'responsive' => 'tablet',
							'class' => 'mfn_field_tablet mfn-toggled',
							'css_attr' => 'border-radius',
		  			),

		  			array(
		  				'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .icon_box .icon_wrapper:border-radius_mobile',
		  				'type' => 'dimensions',
		  				'title' => __('Border radius', 'mfn-opts'),
							'responsive' => 'mobile',
							'class' => 'mfn_field_mobile mfn-toggled',
							'css_attr' => 'border-radius',
		  			),

   					array(
							'type' => 'html',
							'html' => '<div class="mfn-form-row mfn-sidebar-fields-tabs mfn-toggled mfn-vb-formrow mfn-vb-mfnuidhere"><ul class="mfn-sft-nav"><li class="active"><a href="#normal" data-tab="normal">Normal</a></li><li><a href="#hover" data-tab="hover">Hover</a></li></ul><div class="mfn-sft mfn-sft-normal">',
						),

   					array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .icon_box .icon_wrapper .icon:color',
							'type' => 'color',
							'class' => 'main-color mfn-toggled',
							'title' => __('Color', 'mfn-opts'),
						),

						array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .icon_box .icon_wrapper:background',
							'type' => 'color',
							'class' => 'main-color mfn-toggled',
							'title' => __('Background color', 'mfn-opts'),
						),

		  			array(
							'type' => 'html',
							'html' => '</div><div class="mfn-sft mfn-sft-hover">',
						),

		  			array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .icon_box|hover .icon_wrapper .icon:color',
							'type' => 'color',
							'class' => 'main-color mfn-toggled',
							'title' => __('Color', 'mfn-opts'),
						),

						array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .icon_box|hover .icon_wrapper,.mcb-section .mcb-wrap .mcb-item-mfnuidelement .icon_box|hover .icon_wrapper|before:background',
							'type' => 'color',
							'class' => 'main-color mfn-toggled',
							'title' => __('Background color', 'mfn-opts'),
						),

						array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .icon_box|hover .icon_wrapper:border-color',
							'type' => 'color',
							'class' => 'mfn-toggled',
							'title' => __('Border color', 'mfn-opts'),
						),

						array(
							'type' => 'html',
							'html' => '</div></div>',
						),

		  			array(
							'class' => 'toggled_header',
   						'title' => __('Image', 'mfn-opts'),
   					),

		  			array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .icon_box .image_wrapper img:border-style',
							'attr_id' => 'border_style_ib_img',
							'type' => 'select',
							'class' => 'mfn-toggled',
							'title' => __('Border style', 'mfn-opts'),
							'options' => [
								'none' => __('None', 'mfn-opts'),
								'solid' => __('Solid', 'mfn-opts'),
								'dashed' => __('Dashed', 'mfn-opts'),
								'dotted' => __('Dotted', 'mfn-opts'),
								'double' => __('Double', 'mfn-opts'),
							],
						),

						array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .icon_box .image_wrapper img:border-color',
							'condition' => array( 'id' => 'border_style_ib_img', 'opt' => 'isnt', 'val' => 'none' ),
							'type' => 'color',
							'class' => 'mfn-toggled',
							'title' => __('Border color', 'mfn-opts'),
						),

						array(
		  				'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .icon_box .image_wrapper img:border-width',
		  				'condition' => array( 'id' => 'border_style_ib_img', 'opt' => 'isnt', 'val' => 'none' ),
		  				'type' => 'dimensions',
		  				'title' => __('Border width', 'mfn-opts'),
							'responsive' => 'desktop',
							'class' => 'mfn_field_desktop mfn-toggled',
							'css_attr' => 'border-width',
		  			),

		  			array(
		  				'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .icon_box .image_wrapper img:border-width_tablet',
		  				'condition' => array( 'id' => 'border_style_ib_img', 'opt' => 'isnt', 'val' => 'none' ),
		  				'type' => 'dimensions',
		  				'title' => __('Border width', 'mfn-opts'),
							'responsive' => 'tablet',
							'class' => 'mfn_field_tablet mfn-toggled',
							'css_attr' => 'border-width',
		  			),

		  			array(
		  				'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .icon_box .image_wrapper img:border-width_mobile',
		  				'condition' => array( 'id' => 'border_style_ib_img', 'opt' => 'isnt', 'val' => 'none' ),
		  				'type' => 'dimensions',
		  				'title' => __('Border width', 'mfn-opts'),
							'responsive' => 'mobile',
							'class' => 'mfn_field_mobile mfn-toggled',
							'css_attr' => 'border-width',
		  			),

						array(
		  				'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .icon_box .image_wrapper img:border-radius',
		  				'type' => 'dimensions',
		  				'title' => __('Border radius', 'mfn-opts'),
							'responsive' => 'desktop',
							'class' => 'mfn_field_desktop mfn-toggled',
							'css_attr' => 'border-radius',
		  			),

		  			array(
		  				'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .icon_box .image_wrapper img:border-radius_tablet',
		  				'type' => 'dimensions',
		  				'title' => __('Border radius', 'mfn-opts'),
							'responsive' => 'tablet',
							'class' => 'mfn_field_tablet mfn-toggled',
							'css_attr' => 'border-radius',
		  			),

		  			array(
		  				'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .icon_box .image_wrapper img:border-radius_mobile',
		  				'type' => 'dimensions',
		  				'title' => __('Border radius', 'mfn-opts'),
							'responsive' => 'mobile',
							'class' => 'mfn_field_mobile mfn-toggled',
							'css_attr' => 'border-radius',
		  			),

		  			array(
							'class' => 'toggled_header',
   						'title' => __('Title', 'mfn-opts'),
   					),

   					array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .icon_box .desc_wrapper .title:color',
							'type' => 'color',
							'class' => 'main-color mfn-toggled',
							'title' => __('Color', 'mfn-opts'),
						),

						array(
		  				'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .icon_box .desc_wrapper .title:margin',
		  				'type' => 'dimensions',
		  				'version' => 'separated-fields',
		  				'title' => __('Margin', 'mfn-opts'),
							'responsive' => 'desktop',
							'class' => 'mfn_field_desktop mfn-toggled',
							'css_attr' => 'margin',
		  			),

		  			array(
		  				'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .icon_box .desc_wrapper .title:margin_tablet',
		  				'type' => 'dimensions',
		  				'version' => 'separated-fields',
		  				'title' => __('Margin', 'mfn-opts'),
							'responsive' => 'tablet',
							'class' => 'mfn_field_tablet mfn-toggled',
							'css_attr' => 'margin',
		  			),

		  			array(
		  				'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .icon_box .desc_wrapper .title:margin_mobile',
		  				'type' => 'dimensions',
		  				'version' => 'separated-fields',
		  				'title' => __('Margin', 'mfn-opts'),
							'responsive' => 'mobile',
							'class' => 'mfn_field_mobile mfn-toggled',
							'css_attr' => 'margin',
		  			),

		  			array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .icon_box .desc_wrapper .title:typography',
							'type' => 'typography_vb',
							'label_after' => '<a href="#" title="Edit" class="mfn-option-btn mfn-option-blank btn-medium mfn-vb-label-button"><span class="mfn-icon mfn-icon-edit"></span></a>',
							'class' => 'mfn-toggled toggle_fields',
							'title' => __('Typography', 'mfn-opts'),
						),

						array(
							'class' => 'toggled_header',
   						'title' => __('Desc', 'mfn-opts'),
   					),

   					array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .icon_box .desc_wrapper .desc:color',
							'type' => 'color',
							'class' => 'main-color mfn-toggled',
							'title' => __('Color', 'mfn-opts'),
						),

						array(
		  				'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .icon_box .desc_wrapper .desc:margin',
		  				'type' => 'dimensions',
		  				'version' => 'separated-fields',
		  				'title' => __('Margin', 'mfn-opts'),
							'responsive' => 'desktop',
							'class' => 'mfn_field_desktop mfn-toggled',
							'css_attr' => 'margin',
		  			),

		  			array(
		  				'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .icon_box .desc_wrapper .desc:margin_tablet',
		  				'type' => 'dimensions',
		  				'version' => 'separated-fields',
		  				'title' => __('Margin', 'mfn-opts'),
							'responsive' => 'tablet',
							'class' => 'mfn_field_tablet mfn-toggled',
							'css_attr' => 'margin',
		  			),

		  			array(
		  				'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .icon_box .desc_wrapper .desc:margin_mobile',
		  				'type' => 'dimensions',
		  				'version' => 'separated-fields',
		  				'title' => __('Margin', 'mfn-opts'),
							'responsive' => 'mobile',
							'class' => 'mfn_field_mobile mfn-toggled',
							'css_attr' => 'margin',
		  			),

		  			array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .icon_box .desc_wrapper .desc:typography',
							'type' => 'typography_vb',
							'label_after' => '<a href="#" title="Edit" class="mfn-option-btn mfn-option-blank btn-medium mfn-vb-label-button"><span class="mfn-icon mfn-icon-edit"></span></a>',
							'class' => 'mfn-toggled toggle_fields',
							'title' => __('Typography', 'mfn-opts'),
						),

						array(
		  				'class' => 'toggled_header',
		  				'themeoptions' => 'style:simple',
   						'title' => __('Divider', 'mfn-opts'),
   					),

   					array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .icon_box|hover .desc_wrapper .title|before:background-color',
							'themeoptions' => 'style:simple',
							'type' => 'color',
							'class' => 'main-color mfn-toggled',
							'title' => __('Color', 'mfn-opts'),
						),

		  			array(
		  				'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .icon_box|hover .desc_wrapper .title|before:width',
		  				'themeoptions' => 'style:simple',
		  				'type' => 'text',
		  				'default_unit' => '%',
		  				'title' => __('Width', 'mfn-opts'),
							'class' => 'mfn-toggled',
							'css_attr' => 'width',
		  			),


						array(
							'type' => 'html',
							'html' => '</div>',
						),

   				),
   			),

   			// Image  ---------------------------------------------------------

   			'image' => array(
   				'type' => 'image',
   				'title' => __('Image', 'mfn-opts'),
   				'size' => '1/4',
   				'tablet_size' => '1/4',
   				'mobile_size' => '1/1',
   				'tablet_resized' => '0',
   				'cat' => 'typography',
   				'fields' => array(

   					array(
							'type' => 'html',
							'html' => $this->itemtabs,
						),

   					array(
							'type' => 'html',
							'html' => '<div class="modalbox-card modalbox-re_render modalbox-card-content-mfnuidhere active">',
						),

   					array(
   						'id' => 'src',
   						'type' => 'upload',
   						'title' => __('Image', 'mfn-opts'),
							'std' => $this->get_placeholder(),
   						'preview' => 'image',
   					),

   					array(
   						'id' => 'size',
   						'type' => 'select',
   						're_render' => 'standard',
   						'title' => __('Size', 'mfn-opts'),
   						'desc' => __('Select image size from <a target="_blank" href="options-media.php">Settings > Media > Image sizes</a> (Media Library images only)<br />or use below fields for HTML resize', 'mfn-opts'),
   						'options' => array(
   							'full' => __('Full size', 'mfn-opts'),
   							'large' => __('Large', 'mfn-opts') .' | '. mfn_get_image_sizes('large', 1),
   							'medium' => __('Medium', 'mfn-opts') .' | '. mfn_get_image_sizes('medium', 1),
   							'thumbnail' => __('Thumbnail', 'mfn-opts') .' | '. mfn_get_image_sizes('thumbnail', 1),
   						),
							'std' => 'full',
   					),

						array(
   						'id' => 'stretch',
   						'type' => 'select',
   						're_render' => 'standard',
   						'title' => __('Stretch', 'mfn-opts'),
   						'desc' => __('Stretch image to column width, height will be changed proportionally', 'mfn-opts'),
   						'options' => array(
   							'0' => __('No', 'mfn-opts'),
   							'1' => __('Yes', 'mfn-opts'),
   							'ultrawide' => __('Yes, on ultrawide screens only > 1920px', 'mfn-opts'),
   						),
   					),

   					// link

   					array(
   						'title' => __('Link', 'mfn-opts'),
   					),

   					array(
   						'id' => 'link_image',
   						'type' => 'upload',
   						'title' => __('Popup image', 'mfn-opts'),
   						'desc' => __('This <b>image or embed video</b> will be opened in lightbox', 'mfn-opts'),
   					),

   					array(
   						'id' => 'link',
   						'type' => 'text',
   						'title' => __('Link', 'mfn-opts'),
   					),

						array(
   						'id' => 'target',
   						'type' => 'switch',
							'title' => __('Target', 'mfn-opts'),
   						'options' => array(
								0 => __('_self', 'mfn-opts'),
								1 => __('_blank', 'mfn-opts'),
							),
							'std' => 0,
   					),

   					array(
   						'id' => 'hover',
   						'type' => 'switch',
   						'title' => __('Hover effect', 'mfn-opts'),
   						'desc' => __('Hover effect selected in Theme Options', 'mfn-opts'),
   						'options' => array(
   							'disable' => __('Disable', 'mfn-opts'),
								'' => __('Enable', 'mfn-opts'),
   						),
							'std' => '',
   					),

   					// description

   					array(
   						'title' => __('Description', 'mfn-opts'),
   					),

   					array(
   						'id' => 'alt',
   						'type' => 'text',
   						'title' => __('Alternate text', 'mfn-opts'),
   					),

   					array(
   						'id' => 'caption',
   						'type' => 'text',
   						'edit_tag' => '.image_frame | p.wp-caption-text',
   						'edit_position' => 'append',
   						'title' => __('Caption', 'mfn-opts'),
   					),

   					array(
   						'class' => 'mfn-deprecated',
   						'title' => __('Deprecated', 'mfn-opts'),
   					),

   					array(
   						'id' => 'border',
   						'class' => 'mfn-deprecated',
   						're_render' => 'standard',
   						'type' => 'switch',
   						'title' => __('Border', 'mfn-opts'),
   						'options' => array(
   							0 => __('Hide', 'mfn-opts'),
   							1 => __('Show', 'mfn-opts'),
   						),
							'std' => 0,
   					),

   					array(
   						'id' => 'align',
   						'class' => 'mfn-deprecated',
   						're_render' => 'standard',
   						'type' => 'switch',
   						'title' => __('Align', 'mfn-opts'),
   						'desc' => __('If you want image to be <b>resized</b> to column width use <b>align none</b>', 'mfn-opts'),
   						'options' => array(
   							'' => __('None', 'mfn-opts'),
   							'left' => __('Left', 'mfn-opts'),
   							'center' => __('Center', 'mfn-opts'),
								'right' => __('Right', 'mfn-opts'),
   						),
							'std' => '',
							'preview' => 'align',
   					),

   					array(
   						'id' => 'margin',
   						'type' => 'text',
   						'title' => __('Margin top', 'mfn-opts'),
   						'param' => 'number',
   						'after' => 'px',
   						'class' => 'narrow mfn-deprecated',
   					),

   					array(
   						'id' => 'margin_bottom',
   						'type' => 'text',
   						'title' => __('Margin bottom', 'mfn-opts'),
							'param' => 'number',
   						'after' => 'px',
   						'class' => 'narrow mfn-deprecated',
   					),

   					array(
   						'id' => 'width',
   						'type' => 'text',
   						'title' => __('Width', 'mfn-opts'),
   						'desc' => __('HTML resize, optional', 'mfn-opts'),
   						'param' => 'number',
   						'class' => 'narrow mfn-deprecated',
   						'after' => 'px',
   					),

   					array(
   						'id' => 'height',
   						'type' => 'text',
   						'title' => __('Height', 'mfn-opts'),
							'param' => 'number',
   						'class' => 'narrow mfn-deprecated',
   						'after' => 'px',
   					),

						array(
							'id' => 'class',
							'type' => 'pills',
							'title' => __('Element classes', 'mfn-opts'),
							'class' => 'mfn-deprecated',
						),

   					array(
							'type' => 'html',
							'html' => '</div><div class="modalbox-card modalbox-card-style modalbox-re_render modalbox-card-style-mfnuidhere">',
						),

						array(
							'class' => 'toggled_header',
   						'title' => __('Image', 'mfn-opts'),
   					),

   					array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .image_frame:width',
							'type' => 'text',
							'default_unit' => 'px',
							'responsive' => 'desktop',
							'class' => 'mfn_field_desktop mfn-toggled',
							'title' => __('Width', 'mfn-opts'),
							'desc' => __('Use px, %, vw, vh or auto to set content width', 'mfn-opts'),
						),
						array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .image_frame:width_tablet',
							'type' => 'text',
							'default_unit' => 'px',
							'responsive' => 'tablet',
							'class' => 'mfn_field_tablet mfn-toggled',
							'title' => __('Width', 'mfn-opts'),
							'desc' => __('Use px, %, vw, vh or auto to set content width', 'mfn-opts'),
						),
						array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .image_frame:width_mobile',
							'type' => 'text',
							'default_unit' => 'px',
							'responsive' => 'mobile',
							'class' => 'mfn_field_mobile mfn-toggled',
							'title' => __('Width', 'mfn-opts'),
							'desc' => __('Use px, %, vw, vh or auto to set content width', 'mfn-opts'),
						),

   					array(
   						'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mcb-column-inner:text-align',
							'responsive' => 'desktop',
   						'type' => 'switch',
   						'class' => 'mfn-toggled mfn_field_desktop',
   						'title' => __('Align', 'mfn-opts'),
   						'options' => array(
   							'' => __('Default', 'mfn-opts'),
   							'left' => __('Left', 'mfn-opts'),
								'center' => __('Center', 'mfn-opts'),
   							'right' => __('Right', 'mfn-opts'),
   						),
							'preview' => 'align',
   					),

   					array(
   						'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mcb-column-inner:text-align_tablet',
							'responsive' => 'tablet',
   						'type' => 'switch',
   						'class' => 'mfn-toggled mfn_field_tablet',
   						'title' => __('Align', 'mfn-opts'),
   						'options' => array(
   							'' => __('Default', 'mfn-opts'),
   							'left' => __('Left', 'mfn-opts'),
								'center' => __('Center', 'mfn-opts'),
   							'right' => __('Right', 'mfn-opts'),
   						),
							'preview' => 'align',
   					),

   					array(
   						'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mcb-column-inner:text-align_mobile',
							'responsive' => 'mobile',
   						'type' => 'switch',
   						'class' => 'mfn-toggled mfn_field_mobile',
   						'title' => __('Align', 'mfn-opts'),
   						'options' => array(
   							'' => __('Default', 'mfn-opts'),
   							'left' => __('Left', 'mfn-opts'),
								'center' => __('Center', 'mfn-opts'),
   							'right' => __('Right', 'mfn-opts'),
   						),
							'preview' => 'align',
   					),

		  			array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .image_frame:border-style',
							'attr_id' => 'border_style',
							'type' => 'select',
							'class' => 'mfn-toggled',
							'title' => __('Border style', 'mfn-opts'),
							'options' => [
								'none' => __('None', 'mfn-opts'),
								'solid' => __('Solid', 'mfn-opts'),
								'dashed' => __('Dashed', 'mfn-opts'),
								'dotted' => __('Dotted', 'mfn-opts'),
								'double' => __('Double', 'mfn-opts'),
							],
						),

						array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .image_frame:border-color',
							'condition' => array( 'id' => 'border_style', 'opt' => 'isnt', 'val' => 'none' ),
							'type' => 'color',
							'class' => 'mfn-toggled',
							'title' => __('Border color', 'mfn-opts'),
						),

						array(
		  				'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .image_frame:border-width',
		  				'condition' => array( 'id' => 'border_style', 'opt' => 'isnt', 'val' => 'none' ),
		  				'type' => 'dimensions',
		  				'title' => __('Border width', 'mfn-opts'),
							'responsive' => 'desktop',
							'class' => 'mfn_field_desktop mfn-toggled',
							'css_attr' => 'border-width',
		  			),

		  			array(
		  				'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .image_frame:border-width_tablet',
		  				'condition' => array( 'id' => 'border_style', 'opt' => 'isnt', 'val' => 'none' ),
		  				'type' => 'dimensions',
		  				'title' => __('Border width', 'mfn-opts'),
							'responsive' => 'tablet',
							'class' => 'mfn_field_tablet mfn-toggled',
							'css_attr' => 'border-width',
		  			),

		  			array(
		  				'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .image_frame:border-width_mobile',
		  				'condition' => array( 'id' => 'border_style', 'opt' => 'isnt', 'val' => 'none' ),
		  				'type' => 'dimensions',
		  				'title' => __('Border width', 'mfn-opts'),
							'responsive' => 'mobile',
							'class' => 'mfn_field_mobile mfn-toggled',
							'css_attr' => 'border-width',
		  			),

						array(
		  				'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .image_frame:border-radius',
		  				'type' => 'dimensions',
		  				'title' => __('Border radius', 'mfn-opts'),
							'responsive' => 'desktop',
							'class' => 'mfn_field_desktop mfn-toggled',
							'css_attr' => 'border-radius',
		  			),

		  			array(
		  				'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .image_frame:border-radius_tablet',
		  				'type' => 'dimensions',
		  				'title' => __('Border radius', 'mfn-opts'),
							'responsive' => 'tablet',
							'class' => 'mfn_field_tablet mfn-toggled',
							'css_attr' => 'border-radius',
		  			),

		  			array(
		  				'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .image_frame:border-radius_mobile',
		  				'type' => 'dimensions',
		  				'title' => __('Border radius', 'mfn-opts'),
							'responsive' => 'mobile',
							'class' => 'mfn_field_mobile mfn-toggled',
							'css_attr' => 'border-radius',
		  			),

		  			array(
   						'id' => 'greyscale',
   						'type' => 'switch',
   						'title' => 'Grayscale',
   						'class' => 'mfn-toggled',
   						'options' => array(
   							0 => __('Disable', 'mfn-opts'),
   							1 => __('Enable', 'mfn-opts'),
   						),
							'std' => 0,
   					),

   					array(
							'type' => 'html',
							'html' => '</div>',
						),

   				),
   			),

   			// Image Gallery  ---------------------------------------------------------

   			'image_gallery' => array(
   				'type' => 'image_gallery',
   				'title' => __('Image Gallery', 'mfn-opts'),
   				'size' => '1/1',
   				'tablet_size' => '1/1',
   				'mobile_size' => '1/1',
   				'tablet_resized' => '0',
   				'cat' => 'typography',
   				'fields' => array(

   					array(
							'type' => 'html',
							'html' => $this->itemtabs,
						),

   					array(
							'type' => 'html',
							'html' => '<div class="modalbox-card modalbox-re_render modalbox-card-content-mfnuidhere active">',
						),

   					array(
   						'id' => 'ids',
   						'type' => 'upload_multi',
   						'title' => __('Images', 'mfn-opts'),
   						'preview' => 'images',
   					),

   					// options

   					array(
   						'title' => __('Options', 'mfn-opts'),
   					),

   					array(
   						'id' => 'columns',
   						're_render' => 'standard',
   						'type' => 'text',
   						'title' => __('Columns', 'mfn-opts'),
   						'desc' => __('min: <b>1</b> | max: <b>9</b>', 'mfn-opts'),
   						'after' => 'columns',
   						'param' => 'number',
   						'class' => 'narrow',
   						'std' => '3',
   					),

   					array(
   						'id' => 'size',
   						're_render' => 'standard',
   						'type' => 'select',
   						'title' => __('Size', 'mfn-opts'),
   						'options' => array(
								'thumbnail' => __('Thumbnail', 'mfn-opts') .' | '. mfn_get_image_sizes('thumbnail', 1),
								'medium' => __('Medium', 'mfn-opts') .' | '. mfn_get_image_sizes('medium', 1),
								'large' => __('Large', 'mfn-opts') .' | '. mfn_get_image_sizes('large', 1),
								'full' => __('Full size', 'mfn-opts'),
   						),
							'std' => 'full',
   					),

   					array(
   						'id' => 'style',
   						're_render' => 'standard',
   						'type' => 'switch',
   						'title' => __('Style', 'mfn-opts'),
   						'options' => array(
   							'' => __('Default', 'mfn-opts'),
   							'flat' => __('Flat', 'mfn-opts'),
   							'fancy' => __('Fancy', 'mfn-opts'),
   							'masonry' => __('Masonry', 'mfn-opts'),
   						),
							'std' => '',
   					),

   					// advanced

   					array(
   						'title' => __('Advanced', 'mfn-opts'),
   					),

   					array(
   						'id' => 'greyscale',
   						'type' => 'switch',
   						'title' => __('Grayscale', 'mfn-opts'),
   						'options' => array(
   							0 => __('Disable', 'mfn-opts'),
   							1 => __('Enable', 'mfn-opts'),
   						),
							'std' => 0,
   					),

						// deprecated

						array(
							'class' => 'mfn-deprecated',
							'title' => __('Deprecated', 'mfn-opts'),
						),

						array(
							'id' => 'class',
							'type' => 'pills',
							'title' => __('Element classes', 'mfn-opts'),
							'class' => 'mfn-deprecated',
						),

   					array(
							'type' => 'html',
							'html' => '</div><div class="modalbox-card modalbox-card-style modalbox-re_render modalbox-card-style-mfnuidhere">',
						),

						array(
							'class' => 'toggled_header',
   						'title' => __('Image', 'mfn-opts'),
   					),

		  			array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .gallery .image_frame:border-style',
							'attr_id' => 'border_style_ig',
							'type' => 'select',
							'class' => 'mfn-toggled',
							'title' => __('Border style', 'mfn-opts'),
							'options' => [
								'none' => __('None', 'mfn-opts'),
								'solid' => __('Solid', 'mfn-opts'),
								'dashed' => __('Dashed', 'mfn-opts'),
								'dotted' => __('Dotted', 'mfn-opts'),
								'double' => __('Double', 'mfn-opts'),
							],
						),

						array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .gallery .image_frame:border-color',
							'condition' => array( 'id' => 'border_style_ig', 'opt' => 'isnt', 'val' => 'none' ),
							'type' => 'color',
							'class' => 'mfn-toggled',
							'title' => __('Border color', 'mfn-opts'),
						),

						array(
		  				'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .gallery .image_frame:border-width',
		  				'condition' => array( 'id' => 'border_style_ig', 'opt' => 'isnt', 'val' => 'none' ),
		  				'type' => 'dimensions',
		  				'title' => __('Border width', 'mfn-opts'),
							'responsive' => 'desktop',
							'class' => 'mfn_field_desktop mfn-toggled',
							'css_attr' => 'border-width',
		  			),

		  			array(
		  				'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .gallery .image_frame:border-width_tablet',
		  				'condition' => array( 'id' => 'border_style_ig', 'opt' => 'isnt', 'val' => 'none' ),
		  				'type' => 'dimensions',
		  				'title' => __('Border width', 'mfn-opts'),
							'responsive' => 'tablet',
							'class' => 'mfn_field_tablet mfn-toggled',
							'css_attr' => 'border-width',
		  			),

		  			array(
		  				'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .gallery .image_frame:border-width_mobile',
		  				'condition' => array( 'id' => 'border_style_ig', 'opt' => 'isnt', 'val' => 'none' ),
		  				'type' => 'dimensions',
		  				'title' => __('Border width', 'mfn-opts'),
							'responsive' => 'mobile',
							'class' => 'mfn_field_mobile mfn-toggled',
							'css_attr' => 'border-width',
		  			),

						array(
		  				'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .gallery .image_frame:border-radius',
		  				'type' => 'dimensions',
		  				'title' => __('Border radius', 'mfn-opts'),
							'responsive' => 'desktop',
							'class' => 'mfn_field_desktop mfn-toggled',
							'css_attr' => 'border-radius',
		  			),

		  			array(
		  				'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .gallery .image_frame:border-radius_tablet',
		  				'type' => 'dimensions',
		  				'title' => __('Border radius', 'mfn-opts'),
							'responsive' => 'tablet',
							'class' => 'mfn_field_tablet mfn-toggled',
							'css_attr' => 'border-radius',
		  			),

		  			array(
		  				'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .gallery .image_frame:border-radius_mobile',
		  				'type' => 'dimensions',
		  				'title' => __('Border radius', 'mfn-opts'),
							'responsive' => 'mobile',
							'class' => 'mfn_field_mobile mfn-toggled',
							'css_attr' => 'border-radius',
		  			),

		  			array(
		  				'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .gallery .image_frame:margin',
		  				'type' => 'dimensions',
		  				'title' => __('Margin', 'mfn-opts'),
		  				'version' => 'separated-fields',
							'responsive' => 'desktop',
							'class' => 'mfn_field_desktop mfn-toggled',
							'css_attr' => 'margin',
		  			),

		  			array(
		  				'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .gallery .image_frame:margin_tablet',
		  				'type' => 'dimensions',
		  				'title' => __('Margin', 'mfn-opts'),
		  				'version' => 'separated-fields',
							'responsive' => 'tablet',
							'class' => 'mfn_field_tablet mfn-toggled',
							'css_attr' => 'margin',
		  			),

		  			array(
		  				'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .gallery .image_frame:margin_mobile',
		  				'type' => 'dimensions',
		  				'title' => __('Margin', 'mfn-opts'),
		  				'version' => 'separated-fields',
							'responsive' => 'mobile',
							'class' => 'mfn_field_mobile mfn-toggled',
							'css_attr' => 'margin',
		  			),

						array(
							'type' => 'html',
							'html' => '</div>',
						),

   				),
   			),

   			// Info box -------------------------------------------------------

   			'info_box' => array(
   				'type' => 'info_box',
   				'title' => __('Info Box', 'mfn-opts'),
   				'size' => '1/4',
   				'tablet_size' => '1/4',
   				'mobile_size' => '1/1',
   				'tablet_resized' => '0',
   				'cat' => 'elements',
   				'fields' => array(

   					array(
							'type' => 'html',
							'html' => $this->itemtabs,
						),

   					array(
							'type' => 'html',
							'html' => '<div class="modalbox-card modalbox-re_render modalbox-card-content-mfnuidhere active">',
						),

   					array(
   						'id' => 'title',
   						'type' => 'text',
   						'edit_tag' => '.infobox | h3',
   						'edit_position' => 'prepend',
   						'title' => __('Title', 'mfn-opts'),
							'std' => __('This is the title', 'mfn-opts'),
							'preview' => 'title',
   					),

						array(
   						'id' => 'tabs',
   						'type' => 'tabs',
   						'title' => __('Items', 'mfn-opts'),
							'options' => [
								'content' => [
									'input',
									__('Title', 'mfn-opts'),
									__('List item', 'mfn-opts'),
								],
							],
							'std' => [
								0 => [
									'content' => 'This is the 1st item',
								],
								1 => [
									'content' => 'This is the 2nd item',
								],
							],
							'preview' => 'tabs',
							'primary' => 'content',
   					),

   					array(
   						'id' => 'content',
   						'type' => 'textarea',
   						'edit_tag' => '.infobox_wrapper | span.ib-desc',
   						'edit_position' => 'append',
   						'title' => __('Content', 'mfn-opts'),
							'class' => 'form-content-full-width',
   					),

   					array(
							'class' => 'mfn-deprecated',
   						'title' => __('Deprecated', 'mfn-opts'),
   					),

   					array(
   						'id' => 'image',
   						'class' => 'mfn-deprecated',
   						'type' => 'upload',
   						'title' => __('Background image', 'mfn-opts'),
   					),

						array(
							'id' => 'class',
							'type' => 'pills',
							'title' => __('Element classes', 'mfn-opts'),
							'class' => 'mfn-deprecated',
						),

						array(
							'type' => 'html',
							'html' => '</div><div class="modalbox-card modalbox-card-style modalbox-re_render modalbox-card-style-mfnuidhere">',
						),

						array(
							'class' => 'toggled_header',
   						'title' => __('Item title', 'mfn-opts'),
   					),

   					array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .infobox h3:color',
							'type' => 'color',
							'class' => 'main-color mfn-toggled',
							'title' => __('Color', 'mfn-opts'),
						),

						array(
		  				'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .infobox h3:margin',
		  				'type' => 'dimensions',
		  				'version' => 'separated-fields',
		  				'title' => __('Margin', 'mfn-opts'),
							'responsive' => 'desktop',
							'class' => 'mfn_field_desktop mfn-toggled',
							'css_attr' => 'margin',
		  			),

		  			array(
		  				'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .infobox h3:margin_tablet',
		  				'type' => 'dimensions',
		  				'version' => 'separated-fields',
		  				'title' => __('Margin', 'mfn-opts'),
							'responsive' => 'tablet',
							'class' => 'mfn_field_tablet mfn-toggled',
							'css_attr' => 'margin',
		  			),

		  			array(
		  				'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .infobox h3:margin_mobile',
		  				'type' => 'dimensions',
		  				'version' => 'separated-fields',
		  				'title' => __('Margin', 'mfn-opts'),
							'responsive' => 'mobile',
							'class' => 'mfn_field_mobile mfn-toggled',
							'css_attr' => 'margin',
		  			),

		  			array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .infobox h3:typography',
							'type' => 'typography_vb',
							'label_after' => '<a href="#" title="Edit" class="mfn-option-btn mfn-option-blank btn-medium mfn-vb-label-button"><span class="mfn-icon mfn-icon-edit"></span></a>',
							'class' => 'mfn-toggled toggle_fields',
							'title' => __('Typography', 'mfn-opts'),
						),

						array(
							'class' => 'toggled_header',
   						'title' => __('Icon', 'mfn-opts'),
   					),

						array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .infobox ul li|before:color',
							'type' => 'color',
							'class' => 'mfn-toggled',
							'title' => __('Color', 'mfn-opts'),
						),

						array(
							'class' => 'toggled_header',
   						'title' => __('List', 'mfn-opts'),
   					),

						array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .infobox ul:color',
							'type' => 'color',
							'class' => 'mfn-toggled',
							'title' => __('Color', 'mfn-opts'),
						),

						array(
							'class' => 'toggled_header',
   						'title' => __('Content', 'mfn-opts'),
   					),

   					array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .infobox .ib-desc:color',
							'type' => 'color',
							'class' => 'main-color mfn-toggled',
							'title' => __('Color', 'mfn-opts'),
						),

						array(
		  				'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .infobox .ib-desc:margin',
		  				'type' => 'dimensions',
		  				'version' => 'separated-fields',
		  				'title' => __('Margin', 'mfn-opts'),
							'responsive' => 'desktop',
							'class' => 'mfn_field_desktop mfn-toggled',
							'css_attr' => 'margin',
		  			),

		  			array(
		  				'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .infobox .ib-desc:margin_tablet',
		  				'type' => 'dimensions',
		  				'version' => 'separated-fields',
		  				'title' => __('Margin', 'mfn-opts'),
							'responsive' => 'tablet',
							'class' => 'mfn_field_tablet mfn-toggled',
							'css_attr' => 'margin',
		  			),

		  			array(
		  				'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .infobox .ib-desc:margin_mobile',
		  				'type' => 'dimensions',
		  				'version' => 'separated-fields',
		  				'title' => __('Margin', 'mfn-opts'),
							'responsive' => 'mobile',
							'class' => 'mfn_field_mobile mfn-toggled',
							'css_attr' => 'margin',
		  			),

						array(
							'class' => 'toggled_header',
   						'title' => __('Lines', 'mfn-opts'),
   					),

						array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .infobox:--mfn-infobox-line',
							'type' => 'color',
							'class' => 'mfn-toggled',
							'title' => __('Line color', 'mfn-opts'),
						),


						array(
							'type' => 'html',
							'html' => '</div>',
						),

   				),
   			),

   			// List -----------------------------------------------------------

   			'list' => array(
   				'type' => 'list',
   				'title' => __('List', 'mfn-opts'),
   				'size' => '1/4',
   				'tablet_size' => '1/4',
   				'mobile_size' => '1/1',
   				'tablet_resized' => '0',
   				'cat' => 'blocks',
   				'fields' => array(

   					array(
							'type' => 'html',
							'html' => $this->itemtabs,
						),

   					array(
							'type' => 'html',
							'html' => '<div class="modalbox-card modalbox-re_render modalbox-card-content-mfnuidhere active">',
						),

   					array(
   						'id' => 'icon',
   						'type' => 'icon',
   						'title' => __('Icon', 'mfn-opts'),
   						'std' => 'icon-lamp',
							'preview' => 'icon',
   					),

   					array(
   						'id' => 'image',
   						'type' => 'upload',
   						'title' => __('Image', 'mfn-opts'),
   						'desc' => __('Image replaces icon selected above', 'mfn-opts'),
							'preview' => 'image',
   					),

   					array(
   						'id' => 'title',
   						'type' => 'text',
   						'title' => __('Title', 'mfn-opts'),
							'std' => __('This is the title', 'mfn-opts'),
							'preview' => 'title',
   					),

   					array(
   						'id' => 'content',
   						'edit_tag' => '.list_right | div.desc',
   						'edit_position' => 'append',
   						'type' => 'textarea',
   						'title' => __('Content', 'mfn-opts'),
							'std' => 'Lorem ipsum dolor sit amet, consectetur adipiscing elit. Ut elit tellus, luctus nec ullamcorper mattis, pulvinar dapibus leo.',
							'preview' => 'content',
							'class' => 'form-content-full-width',
   					),

						array(
   						'id' => 'style',
   						'type' => 'switch',
   						're_render' => 'standard',
   						'title' => __('Style', 'mfn-opts'),
   						'options' => array(
   							1 => __('With bg', 'mfn-opts'),
   							2 => __('Transparent', 'mfn-opts'),
   							3 => __('Vertical', 'mfn-opts'),
   							4 => __('Ordered list', 'mfn-opts'),
   						),
							'std' => 1,
   					),

						// link

   					array(
   						'title' => __('Link', 'mfn-opts'),
   					),

   					array(
   						'id' => 'link',
   						'type' => 'text',
   						'title' => __('Link', 'mfn-opts'),
   					),

   					array(
   						'id' => 'target',
   						'type' => 'switch',
   						'title' => __('Target', 'mfn-opts'),
   						'options' => array(
   							0 => __('_self', 'mfn-opts'),
   							1 => __('_blank', 'mfn-opts'),
   						),
							'std' => 0,
   					),

						// deprecated

						array(
							'class' => 'mfn-deprecated',
							'title' => __('Deprecated', 'mfn-opts'),
						),

						array(
							'id' => 'class',
							'type' => 'pills',
							'title' => __('Element classes', 'mfn-opts'),
							'class' => 'mfn-deprecated',
						),

						array(
							'type' => 'html',
							'html' => '</div><div class="modalbox-card modalbox-card-style modalbox-re_render modalbox-card-style-mfnuidhere">',
						),

						array(
							'class' => 'toggled_header',
   						'title' => __('Title', 'mfn-opts'),
   					),

   					array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .list_right h4.title:color',
							'type' => 'color',
							'class' => 'main-color mfn-toggled',
							'title' => __('Color', 'mfn-opts'),
						),

		  			array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .list_right h4.title:typography',
							'type' => 'typography_vb',
							'label_after' => '<a href="#" title="Edit" class="mfn-option-btn mfn-option-blank btn-medium mfn-vb-label-button"><span class="mfn-icon mfn-icon-edit"></span></a>',
							'class' => 'mfn-toggled toggle_fields',
							'title' => __('Typography', 'mfn-opts'),
						),

						array(
							'class' => 'toggled_header',
   						'title' => __('Content', 'mfn-opts'),
   					),

   					array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .list_right .desc:color',
							'type' => 'color',
							'class' => 'main-color mfn-toggled',
							'title' => __('Color', 'mfn-opts'),
						),

		  			array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .list_right .desc:typography',
							'type' => 'typography_vb',
							'label_after' => '<a href="#" title="Edit" class="mfn-option-btn mfn-option-blank btn-medium mfn-vb-label-button"><span class="mfn-icon mfn-icon-edit"></span></a>',
							'class' => 'mfn-toggled toggle_fields',
							'title' => __('Typography', 'mfn-opts'),
						),

						array(
							'class' => 'toggled_header',
   						'title' => __('Icon', 'mfn-opts'),
   					),

   					array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .list_left i,.mcb-section .mcb-wrap .mcb-item-mfnuidelement .circle:color',
							'type' => 'color',
							'class' => 'mfn-toggled',
							'title' => __('Color', 'mfn-opts'),
						),

						array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .list_left,.mcb-section .mcb-wrap .mcb-item-mfnuidelement .circle:background',
							'type' => 'color',
							'class' => 'mfn-toggled',
							'title' => __('Background', 'mfn-opts'),
						),

   					array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .list_left i,.mcb-section .mcb-wrap .mcb-item-mfnuidelement .circle:font-size',
							'type' => 'sliderbar',
							'responsive' => 'desktop',
							'class' => 'mfn_field_desktop mfn-toggled',
							'title' => __('Size', 'mfn-opts'),
							'units' => array(
								'px' 	=> array('min' => 1, 		'max' => 100, 'step' => 1),
								'em' 	=> array('min' => 0.1, 	'max' => 10, 	'step' => 0.1),
								'rem' => array('min' => 0.1, 	'max' => 10, 	'step' => 0.1),
								'vw' 	=> array('min' => 1, 		'max' => 100, 'step' => 1),
							)
						),

						array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .list_left i,.mcb-section .mcb-wrap .mcb-item-mfnuidelement .circle:font-size_tablet',
							'type' => 'sliderbar',
							'responsive' => 'tablet',
							'class' => 'mfn_field_tablet mfn-toggled',
							'title' => __('Size', 'mfn-opts'),
							'units' => array(
								'px' 	=> array('min' => 1, 		'max' => 100, 'step' => 1),
								'em' 	=> array('min' => 0.1, 	'max' => 10, 	'step' => 0.1),
								'rem' => array('min' => 0.1, 	'max' => 10, 	'step' => 0.1),
								'vw' 	=> array('min' => 1, 		'max' => 100, 'step' => 1),
							)
						),

						array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .list_left i,.mcb-section .mcb-wrap .mcb-item-mfnuidelement .circle:font-size_mobile',
							'type' => 'sliderbar',
							'responsive' => 'mobile',
							'class' => 'mfn_field_mobile mfn-toggled',
							'title' => __('Size', 'mfn-opts'),
							'units' => array(
								'px' 	=> array('min' => 1, 		'max' => 100, 'step' => 1),
								'em' 	=> array('min' => 0.1, 	'max' => 10, 	'step' => 0.1),
								'rem' => array('min' => 0.1, 	'max' => 10, 	'step' => 0.1),
								'vw' 	=> array('min' => 1, 		'max' => 100, 'step' => 1),
							)
						),

   					array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .list_left,.mcb-section .mcb-wrap .mcb-item-mfnuidelement .circle:border-style',
							'attr_id' => 'border_style',
							'type' => 'select',
							'class' => 'mfn-toggled',
							'title' => __('Border style', 'mfn-opts'),
							'options' => [
								'none' => __('None', 'mfn-opts'),
								'solid' => __('Solid', 'mfn-opts'),
								'dashed' => __('Dashed', 'mfn-opts'),
								'dotted' => __('Dotted', 'mfn-opts'),
								'double' => __('Double', 'mfn-opts'),
							],
						),

						array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .list_left,.mcb-section .mcb-wrap .mcb-item-mfnuidelement .circle:border-color',
							'condition' => array( 'id' => 'border_style', 'opt' => 'isnt', 'val' => 'none' ),
							'type' => 'color',
							'class' => 'mfn-toggled',
							'title' => __('Border color', 'mfn-opts'),
						),

						array(
		  				'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .list_left,.mcb-section .mcb-wrap .mcb-item-mfnuidelement .circle:border-width',
		  				'condition' => array( 'id' => 'border_style', 'opt' => 'isnt', 'val' => 'none' ),
		  				'type' => 'dimensions',
		  				'title' => __('Border width', 'mfn-opts'),
							'responsive' => 'desktop',
							'class' => 'mfn_field_desktop mfn-toggled',
							'css_attr' => 'border-width',
		  			),

		  			array(
		  				'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .list_left,.mcb-section .mcb-wrap .mcb-item-mfnuidelement .circle:border-width_tablet',
		  				'condition' => array( 'id' => 'border_style', 'opt' => 'isnt', 'val' => 'none' ),
		  				'type' => 'dimensions',
		  				'title' => __('Border width', 'mfn-opts'),
							'responsive' => 'tablet',
							'class' => 'mfn_field_tablet mfn-toggled',
							'css_attr' => 'border-width',
		  			),

		  			array(
		  				'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .list_left,.mcb-section .mcb-wrap .mcb-item-mfnuidelement .circle:border-width_mobile',
		  				'condition' => array( 'id' => 'border_style', 'opt' => 'isnt', 'val' => 'none' ),
		  				'type' => 'dimensions',
		  				'title' => __('Border width', 'mfn-opts'),
							'responsive' => 'mobile',
							'class' => 'mfn_field_mobile mfn-toggled',
							'css_attr' => 'border-width',
		  			),

						array(
		  				'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .list_left,.mcb-section .mcb-wrap .mcb-item-mfnuidelement .circle:border-radius',
		  				'type' => 'dimensions',
		  				'title' => __('Border radius', 'mfn-opts'),
							'responsive' => 'desktop',
							'class' => 'mfn_field_desktop mfn-toggled',
							'css_attr' => 'border-radius',
		  			),

		  			array(
		  				'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .list_left,.mcb-section .mcb-wrap .mcb-item-mfnuidelement .circle:border-radius_tablet',
		  				'type' => 'dimensions',
		  				'title' => __('Border radius', 'mfn-opts'),
							'responsive' => 'tablet',
							'class' => 'mfn_field_tablet mfn-toggled',
							'css_attr' => 'border-radius',
		  			),

		  			array(
		  				'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .list_left,.mcb-section .mcb-wrap .mcb-item-mfnuidelement .circle:border-radius_mobile',
		  				'type' => 'dimensions',
		  				'title' => __('Border radius', 'mfn-opts'),
							'responsive' => 'mobile',
							'class' => 'mfn_field_mobile mfn-toggled',
							'css_attr' => 'border-radius',
		  			),

						array(
							'type' => 'html',
							'html' => '</div>',
						),

   				),
   			),

			// Live search -----------------------------------------------------------

				'livesearch' => array(

					'type' => 'livesearch',
					'title' => __('Live search', 'mfn-opts'),
					'desc' => __('Display search form and browse your item live', 'mfn-opts'),
					'size' => '1/3',
					'cat' => '',

					'fields' => array(

						array(
							'type' => 'html',
							'html' => '<div class="modalbox-card modalbox-re_render modalbox-card-content-mfnuidhere active">',
						),

						array(
							'id' => 'item_info',
							'type' => 'info',
							'title' => __('You can only use one <b>Live search</b> element per page', 'mfn-opts'),
						),

						array(
							'id' => 'min_characters',
							'type' => 'text',
							'title' => __('Minimal characters', 'mfn-opts'),
							'desc' => __('Minimal amount of characters in input to load posts', 'mfn-opts'),
							'std' => '3',
							'param' => 'number',
							'class' => 'narrow',
							'after' => __('characters', 'mfn-opts'),
						),

						array(
							'id' => 'container_height',
							'type' => 'text',
							'title' => __('Search results container height', 'mfn-opts'),
							'std' => '300',
							'param' => 'number',
							'class' => 'narrow',
							'after' => __('px', 'mfn-opts'),
						),

						array(
							'id' => 'featured_image',
							'type' => 'switch',
							'title' => __('Featured image', 'mfn-opts'),
							'options' => array(
								'0' => __('Hide', 'mfn-opts'),
								'1' => __('Show', 'mfn-opts'),
							),
							'std' => '1',
						),

						// deprecated

						array(
							'class' => 'mfn-deprecated',
							'title' => __('Deprecated', 'mfn-opts'),
						),

						array(
							'id' => 'class',
							'type' => 'pills',
							'title' => __('Element classes', 'mfn-opts'),
							'class' => 'mfn-deprecated',
						),

						array(
							'type' => 'html',
							'html' => '</div>',
						)
					),
				),

   			// Map Basic ------------------------------------------------------------

   			'map_basic' => array(
   				'type' => 'map_basic',
   				'title' => __('Map Basic', 'mfn-opts'),
   				'size' => '1/4',
   				'tablet_size' => '1/4',
   				'mobile_size' => '1/1',
   				'tablet_resized' => '0',
   				'cat' => 'elements',
   				'fields' => array(

   					array(
							'type' => 'html',
							'html' => '<div class="modalbox-card modalbox-re_render modalbox-card-content-mfnuidhere active">',
						),

						array(
							'id' => 'info-iframe',
							'type' => 'info',
							'title' => __('Number of <b>iframe map</b> loads is unlimited.', 'mfn-opts'),
						),

						array(
   						'title' => __('Iframe', 'mfn-opts'),
   					),

   					array(
   						'id' => 'iframe',
   						'type' => 'textarea',
   						're_render' => 'standard',
   						'title' => __('Iframe', 'mfn-opts'),
   						'desc' => __('Visit <a target="_blank" href="https://google.com/maps">Google Maps</a> and follow these instructions:<br />1. Find place. 2. Click the share button in the left panel. 3. Select "embed a map" 4. Choose size. 5. Click "copy HTML" and paste it above', 'mfn-opts'),
   					),

   					// embed

						array(
							'id' => 'info-embed',
							'type' => 'info',
							'title' => __('Number of <b>embed map</b> loads is unlimited. Google Maps API key is required.', 'mfn-opts'),
							'label' => __('Enter key', 'mfn-opts'),
							'link' => 'admin.php?page='. apply_filters('betheme_slug','be'). '-options#advanced&options',
						),

   					array(
   						'title' => __('Embed', 'mfn-opts'),
   					),

   					array(
   						'id' => 'address',
   						'type' => 'text',
   						're_render' => 'standard',
   						'title' => __('Address or place name', 'mfn-opts'),
   					),

   					array(
   						'id' => 'zoom',
   						'type' => 'text',
   						're_render' => 'standard',
   						'title' => __('Zoom', 'mfn-opts'),
   						'param' => 'number',
   						'class' => 'narrow',
   						'std' => 13,
   					),

   					array(
   						'id' => 'height',
   						'type' => 'text',
   						're_render' => 'standard',
   						'title' => __('Height', 'mfn-opts'),
							'param' => 'number',
   						'class' => 'narrow',
   						'after' => 'px',
   						'std' => 300,
   					),

   					array(
							'type' => 'html',
							'html' => '</div>',
						),

   				),
   			),

   			// Map Advanced ------------------------------------------------------------

   			'map' => array(
   				'type' => 'map',
   				'title' => __('Map Advanced', 'mfn-opts'),
   				'size' => '1/4',
   				'tablet_size' => '1/4',
   				'mobile_size' => '1/4',
   				'tablet_resized' => '0',
   				'cat' => 'elements',
   				'fields' => array(

   					array(
							'type' => 'html',
							'html' => $this->itemtabs,
						),

   					array(
							'type' => 'html',
							'html' => '<div class="modalbox-card modalbox-re_render modalbox-card-content-mfnuidhere active">',
						),

   					array(
   						'id' => 'info-key',
   						'type' => 'info',
   						'title' => __('Number of free dynamic map loads is limited. Google Maps API key is required.', 'mfn-opts'),
							'label' => __('Enter key', 'mfn-opts'),
							'link' => 'admin.php?page='. apply_filters('betheme_slug','be'). '-options#advanced&options',
   					),

   					array(
   						'id' => 'lat',
   						'type' => 'text',
   						're_render' => 'tabs',
   						'title' => __('Latitude', 'mfn-opts'),
   						'before' => 'LAT',
   						'placeholder' => '-33.87',
   						'std' => '-33.87',
   					),

   					array(
   						'id' => 'lng',
   						'type' => 'text',
   						're_render' => 'tabs',
   						'title' => __('Longitude', 'mfn-opts'),
							'before' => 'LNG',
							'placeholder' => '151.21',
							'std' => '151.21',
   					),

   					array(
   						'id' => 'zoom',
   						'type' => 'text',
   						're_render' => 'tabs',
   						'title' => __('Zoom', 'mfn-opts'),
   						'param' => 'number',
   						'class' => 'narrow',
   						'std' => 13,
   					),

   					// options

   					array(
   						'title' => __('Options', 'mfn-opts'),
   					),

   					array(
   						'id' => 'type',
   						'type' => 'switch',
   						're_render' => 'tabs',
   						'title' => __('Type', 'mfn-opts'),
   						'options' => array(
   							'ROADMAP' => __('Map', 'mfn-opts'),
   							'SATELLITE' => __('Satellite', 'mfn-opts'),
   							'HYBRID' => __('Satellite + Map', 'mfn-opts'),
   							'TERRAIN' => __('Terrain', 'mfn-opts'),
   						),
							'std' => 'ROADMAP',
   					),

   					array(
   						'id' => 'controls',
   						'type' => 'select',
   						're_render' => 'tabs',
   						'title' => __('Controls', 'mfn-opts'),
   						'options' => array(
   							'' => __('Zoom', 'mfn-opts'),
   							'mapType' => __('Map Type', 'mfn-opts'),
   							'streetView' => __('Street View', 'mfn-opts'),
   							'zoom mapType' => __('Zoom & Map Type', 'mfn-opts'),
   							'zoom streetView' => __('Zoom & Street View', 'mfn-opts'),
   							'mapType streetView' => __('Map Type & Street View', 'mfn-opts'),
   							'zoom mapType streetView' => __('Zoom, Map Type & Street View', 'mfn-opts'),
   							'hide' => __('Hide All', 'mfn-opts'),
   						),
   					),

   					array(
   						'id' => 'draggable',
   						'type' => 'switch',
   						're_render' => 'tabs',
   						'title' => __('Draggable', 'mfn-opts'),
   						'options' => array(
   							'disable' => __('Disable', 'mfn-opts'),
   							'disable-mobile'=> __('Disable on mobile', 'mfn-opts'),
								'' => __('Enable', 'mfn-opts'),
   						),
							'std' => '',
   					),

   					array(
   						'id' => 'border',
   						'type' => 'switch',
   						're_render' => 'tabs',
   						'title' => __('Border', 'mfn-opts'),
   						'options' => array(
   							0 => __('Hide', 'mfn-opts'),
   							1 => __('Show', 'mfn-opts'),
   						),
							'std' => 0,
   					),

   					// advanced

   					array(
   						'title' => __('Advanced', 'mfn-opts'),
   					),

   					array(
   						'id' => 'icon',
   						're_render' => 'tabs',
   						'type' => 'upload',
   						'title' => __('Marker icon', 'mfn-opts'),
   						'desc' => __('.png', 'mfn-opts'),
   					),

   					array(
   						'id' => 'color',
   						're_render' => 'tabs',
   						'type' => 'color',
   						'title' => __('Map color', 'mfn-opts'),
   					),

   					array(
   						'id' => 'styles',
   						're_render' => 'tabs',
   						'type' => 'textarea',
   						'title' => __('Styles', 'mfn-opts'),
   						'desc' => __('You can get predefined styles from <a target="_blank" href="https://snazzymaps.com/explore">snazzymaps.com/explore</a> or generate your own <a target="_blank" href="https://snazzymaps.com/editor">snazzymaps.com/editor</a>', 'mfn-opts'),
							'class' => 'form-content-full-width',
   					),

						// additional markers

   					array(
   						'title' => __('Additional markers', 'mfn-opts'),
   					),

						array(
   						'id' => 'tabs',
   						'type' => 'tabs',
   						'title' => __('Markers', 'mfn-opts'),
							'options' => [
								'lat' => [
									'input',
									__('Lat', 'mfn-opts'),
									'-33.88',
								],
								'lng' => [
									'input',
									__('Lng', 'mfn-opts'),
									'151.21',
								],
								'icon' => [
									'input',
									__('Icon URL (optional)', 'mfn-opts'),
									'',
								],
							],
							'std' => [],
							'primary' => 'lat',
   					),

   					// contact

   					array(
   						'title' => __('Contact box', 'mfn-opts'),
   					),

   					array(
   						'id' => 'title',
   						're_render' => 'tabs',
   						'type' => 'text',
   						'title' => __('Title', 'mfn-opts'),
   					),

   					array(
   						'id' => 'content',
   						're_render' => 'tabs',
   						'type' => 'textarea',
   						'title' => __('Address', 'mfn-opts'),
   						'desc' => __('HTML tags allowed', 'mfn-opts'),
   					),

   					array(
   						'id' => 'telephone',
   						're_render' => 'tabs',
   						'type' => 'text',
   						'title' => __('Telephone', 'mfn-opts'),
   					),

   					array(
   						'id' => 'email',
   						're_render' => 'tabs',
   						'type' => 'text',
   						'title' => __('Email', 'mfn-opts'),
   					),

   					array(
   						'id' => 'www',
   						're_render' => 'tabs',
   						'type' => 'text',
   						'title' => __('WWW', 'mfn-opts'),
   					),

   					array(
   						'id' => 'style',
   						're_render' => 'tabs',
   						'type' => 'select',
   						'title' => __('Style', 'mfn-opts'),
   						'options' => array(
   							'box' => __('Box on the map (for full width column/wrap)', 'mfn-opts'),
   							'bar' => __('Bar at the top', 'mfn-opts'),
   						),
   					),

						array(
   						'id' => 'info-pricing',
   						'type' => 'info',
   						'title' => __('If you need more than 28500 map loads per month please check current Google Maps Pricing or choose Map Basic instead.', 'mfn-opts'),
							'label' => __('Google Maps Pricing', 'mfn-opts'),
							'link' => 'https://cloud.google.com/maps-platform/pricing/',
   					),

						 // deprecated

						array(
							'class' => 'mfn-deprecated',
   						'title' => __('Deprecated', 'mfn-opts'),
   					),

   					array(
   						'id' => 'height',
   						'type' => 'text',
   						'title' => __('Height', 'mfn-opts'),
							'param' => 'number',
   						'class' => 'narrow mfn-deprecated',
   						'after' => 'px',
   					),

   					array(
   						'id' => 'latlng',
   						'type' => 'text',
   						'title' => __('Lat,Lng,IconURL', 'mfn-opts'),
   						'class' => 'mfn-deprecated',
   					),

						array(
							'id' => 'class',
							'type' => 'pills',
							'title' => __('Element classes', 'mfn-opts'),
							'class' => 'mfn-deprecated',
						),

   					array(
							'type' => 'html',
							'html' => '</div><div class="modalbox-card modalbox-card-style modalbox-re_render modalbox-card-style-mfnuidhere">',
						),

   					array(
							'class' => 'toggled_header',
   						'title' => __('Map', 'mfn-opts'),
   					),

   					array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mcb-column-inner .google-map:height',
							'type' => 'text',
							'default_unit' => 'px',
							'responsive' => 'desktop',
							'class' => 'mfn_field_desktop mfn-toggled',
							'title' => __('Height', 'mfn-opts')
						),

						array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mcb-column-inner .google-map:height_tablet',
							'type' => 'text',
							'default_unit' => 'px',
							'responsive' => 'tablet',
							'class' => 'mfn_field_tablet mfn-toggled',
							'title' => __('Height', 'mfn-opts')
						),

						array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .mcb-column-inner .google-map:height_mobile',
							'type' => 'text',
							'default_unit' => 'px',
							'responsive' => 'mobile',
							'class' => 'mfn_field_mobile mfn-toggled',
							'title' => __('Height', 'mfn-opts')
						),

						array(
							'class' => 'toggled_header',
   						'title' => __('Container', 'mfn-opts'),
   					),

   					array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .google-map-contact-wrapper .get_in_touch:background-color',
							'type' => 'color',
							'class' => 'mfn-toggled',
							'title' => __('Background', 'mfn-opts'),
						),

   					array(
							'class' => 'toggled_header',
   						'title' => __('Title', 'mfn-opts'),
   					),

   					array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .get_in_touch h3:color',
							'type' => 'color',
							'class' => 'main-color mfn-toggled',
							'title' => __('Color', 'mfn-opts'),
						),

						array(
		  				'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .get_in_touch h3:margin',
		  				'type' => 'dimensions',
		  				'version' => 'separated-fields',
		  				'title' => __('Margin', 'mfn-opts'),
							'responsive' => 'desktop',
							'class' => 'mfn_field_desktop mfn-toggled',
							'css_attr' => 'margin',
		  			),

		  			array(
		  				'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .get_in_touch h3:margin_tablet',
		  				'type' => 'dimensions',
		  				'version' => 'separated-fields',
		  				'title' => __('Margin', 'mfn-opts'),
							'responsive' => 'tablet',
							'class' => 'mfn_field_tablet mfn-toggled',
							'css_attr' => 'margin',
		  			),

		  			array(
		  				'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .get_in_touch h3:margin_mobile',
		  				'type' => 'dimensions',
		  				'version' => 'separated-fields',
		  				'title' => __('Margin', 'mfn-opts'),
							'responsive' => 'mobile',
							'class' => 'mfn_field_mobile mfn-toggled',
							'css_attr' => 'margin',
		  			),

		  			array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .get_in_touch h3:typography',
							'type' => 'typography_vb',
							'label_after' => '<a href="#" title="Edit" class="mfn-option-btn mfn-option-blank btn-medium mfn-vb-label-button"><span class="mfn-icon mfn-icon-edit"></span></a>',
							'class' => 'mfn-toggled toggle_fields',
							'title' => __('Typography', 'mfn-opts'),
						),

						array(
							'class' => 'toggled_header',
   						'title' => __('Icon', 'mfn-opts'),
   					),

						array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .get_in_touch ul li .icon:color',
							'type' => 'color',
							'class' => 'mfn-toggled',
							'title' => __('Color', 'mfn-opts'),
						),

						array(
							'class' => 'toggled_header',
   						'title' => __('List', 'mfn-opts'),
   					),

						array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .get_in_touch .get_in_touch_wrapper ul li:color',
							'type' => 'color',
							'class' => 'mfn-toggled',
							'title' => __('Color', 'mfn-opts'),
						),

						array(
							'type' => 'html',
							'html' => '<div class="mfn-form-row mfn-sidebar-fields-tabs mfn-toggled mfn-vb-formrow mfn-vb-mfnuidhere"><ul class="mfn-sft-nav"><li class="active"><a href="#normal" data-tab="normal">Normal</a></li><li><a href="#hover" data-tab="hover">Hover</a></li></ul><div class="mfn-sft mfn-sft-normal">',
						),

						array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .get_in_touch ul li a:color',
							'type' => 'color',
							'title' => __('Links color', 'mfn-opts'),
						),

						array(
							'type' => 'html',
							'html' => '</div><div class="mfn-sft mfn-sft-hover">',
						),

						array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .get_in_touch ul li a|hover:color',
							'type' => 'color',
							'title' => __('Links color', 'mfn-opts'),
						),

						array(
							'type' => 'html',
							'html' => '</div></div>',
						),

						array(
							'class' => 'toggled_header',
   						'title' => __('Lines', 'mfn-opts'),
   					),

						array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .get_in_touch ul li:--mfn-contactbox-line',
							'type' => 'color',
							'class' => 'mfn-toggled',
							'title' => __('Line color', 'mfn-opts'),
						),

						array(
							'type' => 'html',
							'html' => '</div>',
						),

   				),
   			),

   			// Offer Slider Full ----------------------------------------------

   			'offer' => array(
   				'type' => 'offer',
   				'title' => __('Offer Slider Full', 'mfn-opts'),
   				'size' => '1/1',
   				'tablet_size' => '1/1',
   				'mobile_size' => '1/1',
   				'tablet_resized' => '0',
   				'cat' => 'loops',
   				'fields' => array(

   					array(
							'type' => 'html',
							'html' => $this->itemtabs,
						),

   					array(
							'type' => 'html',
							'html' => '<div class="modalbox-card modalbox-re_render modalbox-card-content-mfnuidhere active">',
						),

   					array(
   						'id' => 'info',
   						'type' => 'info',
   						'title' => __('Please use on pages <strong>without sidebar</strong> and within <strong>full width sections</strong>. One item per section.', 'mfn-opts'),
   					),

   					array(
   						'id' => 'category',
   						'type' => 'select',
   						'title' => __('Category', 'mfn-opts'),
   						'options' => mfn_get_categories('offer-types'),
							'preview' => 'category',
   					),

						// deprecated

   					array(
   						'class' => 'mfn-deprecated',
   						'title' => __('Deprecated', 'mfn-opts'),
   					),

   					array(
   						'id' => 'align',
   						'type' => 'select',
   						'class' => 'mfn-deprecated',
   						'title' => __('Text align', 'mfn-opts'),
   						'desc' => __('Text align center does not affect title if button is active', 'mfn-opts'),
   						'options' => array(
   							'left' => __('Left', 'mfn-opts'),
								'center' => __('Center', 'mfn-opts'),
   							'right' => __('Right', 'mfn-opts'),
   							'justify' => __('Justify', 'mfn-opts'),
   						),
							'std' => 'left',
   					),

						array(
							'id' => 'class',
							'type' => 'pills',
							'title' => __('Element classes', 'mfn-opts'),
							'class' => 'mfn-deprecated',
						),

   					array(
							'type' => 'html',
							'html' => '</div><div class="modalbox-card modalbox-card-style modalbox-re_render modalbox-card-style-mfnuidhere">',
						),

						array(
							'class' => 'toggled_header',
   						'title' => __('Image', 'mfn-opts'),
   					),

		  			array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .offer .offer_li .image_wrapper:border-style',
							'attr_id' => 'border_style_os_img',
							'type' => 'select',
							'class' => 'mfn-toggled',
							'title' => __('Border style', 'mfn-opts'),
							'options' => [
								'none' => __('None', 'mfn-opts'),
								'solid' => __('Solid', 'mfn-opts'),
								'dashed' => __('Dashed', 'mfn-opts'),
								'dotted' => __('Dotted', 'mfn-opts'),
								'double' => __('Double', 'mfn-opts'),
							],
						),

						array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .offer .offer_li .image_wrapper:border-color',
							'condition' => array( 'id' => 'border_style_os_img', 'opt' => 'isnt', 'val' => 'none' ),
							'type' => 'color',
							'class' => 'mfn-toggled',
							'title' => __('Border color', 'mfn-opts'),
						),

						array(
		  				'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .offer .offer_li .image_wrapper:border-width',
		  				'condition' => array( 'id' => 'border_style_os_img', 'opt' => 'isnt', 'val' => 'none' ),
		  				'type' => 'dimensions',
		  				'title' => __('Border width', 'mfn-opts'),
							'responsive' => 'desktop',
							'class' => 'mfn_field_desktop mfn-toggled',
							'css_attr' => 'border-width',
		  			),

		  			array(
		  				'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .offer .offer_li .image_wrapper:border-width_tablet',
		  				'condition' => array( 'id' => 'border_style_os_img', 'opt' => 'isnt', 'val' => 'none' ),
		  				'type' => 'dimensions',
		  				'title' => __('Border width', 'mfn-opts'),
							'responsive' => 'tablet',
							'class' => 'mfn_field_tablet mfn-toggled',
							'css_attr' => 'border-width',
		  			),

		  			array(
		  				'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .offer .offer_li .image_wrapper:border-width_mobile',
		  				'condition' => array( 'id' => 'border_style_os_img', 'opt' => 'isnt', 'val' => 'none' ),
		  				'type' => 'dimensions',
		  				'title' => __('Border width', 'mfn-opts'),
							'responsive' => 'mobile',
							'class' => 'mfn_field_mobile mfn-toggled',
							'css_attr' => 'border-width',
		  			),

						array(
		  				'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .offer .offer_li .image_wrapper:border-radius',
		  				'type' => 'dimensions',
		  				'title' => __('Border radius', 'mfn-opts'),
							'responsive' => 'desktop',
							'class' => 'mfn_field_desktop mfn-toggled',
							'css_attr' => 'border-radius',
		  			),

		  			array(
		  				'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .offer .offer_li .image_wrapper:border-radius_tablet',
		  				'type' => 'dimensions',
		  				'title' => __('Border radius', 'mfn-opts'),
							'responsive' => 'tablet',
							'class' => 'mfn_field_tablet mfn-toggled',
							'css_attr' => 'border-radius',
		  			),

		  			array(
		  				'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .offer .offer_li .image_wrapper:border-radius_mobile',
		  				'type' => 'dimensions',
		  				'title' => __('Border radius', 'mfn-opts'),
							'responsive' => 'mobile',
							'class' => 'mfn_field_mobile mfn-toggled',
							'css_attr' => 'border-radius',
		  			),

						array(
							'class' => 'toggled_header',
   						'title' => __('Title', 'mfn-opts'),
   					),

						array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .offer .offer_li .desc_wrapper .title h3:color',
							'type' => 'color',
							'class' => 'main-color mfn-toggled',
							'title' => __('Color', 'mfn-opts'),
						),

						array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .offer .offer_li .desc_wrapper .title h3:typography',
							'type' => 'typography_vb',
							'label_after' => '<a href="#" title="Edit" class="mfn-option-btn mfn-option-blank btn-medium mfn-vb-label-button"><span class="mfn-icon mfn-icon-edit"></span></a>',
							'class' => 'mfn-toggled toggle_fields',
							'title' => __('Typography', 'mfn-opts'),
						),

						array(
							'class' => 'toggled_header',
   						'title' => __('Content', 'mfn-opts'),
   					),

						array(
   						'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .desc_wrapper:text-align',
							'responsive' => 'desktop',
   						'type' => 'switch',
   						'class' => 'mfn_field_desktop mfn-toggled',
   						'title' => __('Text align', 'mfn-opts'),
   						'options' => array(
   							'' => __('Default', 'mfn-opts'),
   							'left' => __('Left', 'mfn-opts'),
								'center' => __('Center', 'mfn-opts'),
   							'right' => __('Right', 'mfn-opts'),
   							'justify' => __('Justify', 'mfn-opts'),
   						),
							'std' => '',
   					),
   					array(
   						'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .desc_wrapper:text-align_tablet',
							'responsive' => 'tablet',
   						'type' => 'switch',
   						'class' => 'mfn_field_tablet mfn-toggled',
   						'title' => __('Text align', 'mfn-opts'),
   						'options' => array(
   							'' => __('Default', 'mfn-opts'),
   							'left' => __('Left', 'mfn-opts'),
								'center' => __('Center', 'mfn-opts'),
   							'right' => __('Right', 'mfn-opts'),
   							'justify' => __('Justify', 'mfn-opts'),
   						),
							'std' => '',
   					),
   					array(
   						'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .desc_wrapper:text-align_mobile',
							'responsive' => 'mobile',
   						'type' => 'switch',
   						'class' => 'mfn_field_mobile mfn-toggled',
   						'title' => __('Text align', 'mfn-opts'),
   						'options' => array(
   							'' => __('Default', 'mfn-opts'),
   							'left' => __('Left', 'mfn-opts'),
								'center' => __('Center', 'mfn-opts'),
   							'right' => __('Right', 'mfn-opts'),
   							'justify' => __('Justify', 'mfn-opts'),
   						),
							'std' => '',
   					),

						array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .offer .offer_li .desc_wrapper .desc:color',
							'type' => 'color',
							'class' => 'main-color mfn-toggled',
							'title' => __('Color', 'mfn-opts'),
						),

						array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .offer .offer_li .desc_wrapper .desc:typography',
							'type' => 'typography_vb',
							'label_after' => '<a href="#" title="Edit" class="mfn-option-btn mfn-option-blank btn-medium mfn-vb-label-button"><span class="mfn-icon mfn-icon-edit"></span></a>',
							'class' => 'mfn-toggled toggle_fields',
							'title' => __('Typography', 'mfn-opts'),
						),

						array(
							'class' => 'toggled_header',
   						'title' => __('Nav', 'mfn-opts'),
   					),

   					array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .offer .slider_pagination:background-color',
							'type' => 'color',
							'class' => 'mfn-toggled',
							'title' => __('Label background', 'mfn-opts'),
						),

   					array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .offer .slider_pagination, .mcb-section .mcb-wrap .mcb-item-mfnuidelement .offer .slider_pagination span:color',
							'type' => 'color',
							'class' => 'mfn-toggled',
							'title' => __('Label color', 'mfn-opts'),
						),

   					array(
							'type' => 'html',
							'html' => '<div class="mfn-form-row mfn-sidebar-fields-tabs mfn-toggled mfn-vb-formrow mfn-vb-mfnuidhere"><ul class="mfn-sft-nav"><li class="active"><a href="#normal" data-tab="normal">Normal</a></li><li><a href="#hover" data-tab="hover">Hover</a></li></ul><div class="mfn-sft mfn-sft-normal">',
						),

						array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .offer .slick-arrow:background-color',
							'type' => 'color',
							'title' => __('Arrows background', 'mfn-opts'),
						),

   					array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .offer .slick-arrow .button_icon i:color',
							'type' => 'color',
							'title' => __('Arrows color', 'mfn-opts'),
						),

						array(
							'type' => 'html',
							'html' => '</div><div class="mfn-sft mfn-sft-hover">',
						),

						array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .offer .slick-arrow|hover:background-color',
							'type' => 'color',
							'title' => __('Arrows background', 'mfn-opts'),
						),

						array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .offer .slick-arrow|hover .button_icon i:color',
							'type' => 'color',
							'title' => __('Arrows color', 'mfn-opts'),
						),

						array(
							'type' => 'html',
							'html' => '</div></div>',
						),

						array(
							'class' => 'toggled_header',
   						'title' => __('Button', 'mfn-opts'),
   					),

		  			array(
		  				'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .offer .offer_li .desc_wrapper .title a.button:padding',
		  				'type' => 'dimensions',
		  				'version' => 'separated-fields',
		  				'title' => __('Padding', 'mfn-opts'),
							'responsive' => 'desktop',
							'class' => 'mfn_field_desktop mfn-toggled',
							'css_attr' => 'padding',
		  			),

		  			array(
		  				'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .offer .offer_li .desc_wrapper .title a.button:padding_tablet',
		  				'type' => 'dimensions',
		  				'version' => 'separated-fields',
		  				'title' => __('Padding', 'mfn-opts'),
							'responsive' => 'tablet',
							'class' => 'mfn_field_tablet mfn-toggled',
							'css_attr' => 'padding',
		  			),

		  			array(
		  				'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .offer .offer_li .desc_wrapper .title a.button:padding_mobile',
		  				'type' => 'dimensions',
		  				'version' => 'separated-fields',
		  				'title' => __('Padding', 'mfn-opts'),
							'responsive' => 'mobile',
							'class' => 'mfn_field_mobile mfn-toggled',
							'css_attr' => 'padding',
		  			),

		  			array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .offer .offer_li .desc_wrapper .title a.button:typography',
							'type' => 'typography_vb',
							'label_after' => '<a href="#" title="Edit" class="mfn-option-btn mfn-option-blank btn-medium mfn-vb-label-button"><span class="mfn-icon mfn-icon-edit"></span></a>',
							'class' => 'mfn-toggled toggle_fields',
							'title' => __('Typography', 'mfn-opts'),
						),

						array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .offer .offer_li .desc_wrapper .title a.button:border-style',
							'attr_id' => 'border_style_osf_border',
							'type' => 'select',
							'class' => 'mfn-toggled',
							'title' => __('Border style', 'mfn-opts'),
							'options' => [
								'none' => __('None', 'mfn-opts'),
								'solid' => __('Solid', 'mfn-opts'),
								'dashed' => __('Dashed', 'mfn-opts'),
								'dotted' => __('Dotted', 'mfn-opts'),
								'double' => __('Double', 'mfn-opts'),
							],
						),

						array(
		  				'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .offer .offer_li .desc_wrapper .title a.button:border-width',
		  				'condition' => array( 'id' => 'border_style_osf_border', 'opt' => 'isnt', 'val' => 'none' ),
		  				'type' => 'dimensions',
		  				'title' => __('Border width', 'mfn-opts'),
							'responsive' => 'desktop',
							'class' => 'mfn_field_desktop mfn-toggled',
							'css_attr' => 'border-width',
		  			),

		  			array(
		  				'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .offer .offer_li .desc_wrapper .title a.button:border-width_tablet',
		  				'condition' => array( 'id' => 'border_style_osf_border', 'opt' => 'isnt', 'val' => 'none' ),
		  				'type' => 'dimensions',
		  				'title' => __('Border width', 'mfn-opts'),
							'responsive' => 'tablet',
							'class' => 'mfn_field_tablet mfn-toggled',
							'css_attr' => 'border-width',
		  			),

		  			array(
		  				'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .offer .offer_li .desc_wrapper .title a.button:border-width_mobile',
		  				'condition' => array( 'id' => 'border_style_osf_border', 'opt' => 'isnt', 'val' => 'none' ),
		  				'type' => 'dimensions',
		  				'title' => __('Border width', 'mfn-opts'),
							'responsive' => 'mobile',
							'class' => 'mfn_field_mobile mfn-toggled',
							'css_attr' => 'border-width',
		  			),

						array(
		  				'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .offer .offer_li .desc_wrapper .title a.button:border-radius',
		  				'type' => 'dimensions',
		  				'title' => __('Border radius', 'mfn-opts'),
							'responsive' => 'desktop',
							'class' => 'mfn_field_desktop mfn-toggled',
							'css_attr' => 'border-radius',
		  			),

		  			array(
		  				'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .offer .offer_li .desc_wrapper .title a.button:border-radius_tablet',
		  				'type' => 'dimensions',
		  				'title' => __('Border radius', 'mfn-opts'),
							'responsive' => 'tablet',
							'class' => 'mfn_field_tablet mfn-toggled',
							'css_attr' => 'border-radius',
		  			),

		  			array(
		  				'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .offer .offer_li .desc_wrapper .title a.button:border-radius_mobile',
		  				'type' => 'dimensions',
		  				'title' => __('Border radius', 'mfn-opts'),
							'responsive' => 'mobile',
							'class' => 'mfn_field_mobile mfn-toggled',
							'css_attr' => 'border-radius',
		  			),

   					array(
							'type' => 'html',
							'html' => '<div class="mfn-form-row mfn-sidebar-fields-tabs mfn-toggled mfn-vb-formrow mfn-vb-mfnuidhere"><ul class="mfn-sft-nav"><li class="active"><a href="#normal" data-tab="normal">Normal</a></li><li><a href="#hover" data-tab="hover">Hover</a></li></ul><div class="mfn-sft mfn-sft-normal">',
						),

						array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .offer .offer_li .desc_wrapper .title a.button:color',
							'type' => 'color',
							'class' => 'main-color mfn-toggled',
							'title' => __('Color', 'mfn-opts'),
						),

						array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .offer .offer_li .desc_wrapper .title a.button:border-color',
							'condition' => array( 'id' => 'border_style_osf_border', 'opt' => 'isnt', 'val' => 'none' ),
							'type' => 'color',
							'class' => 'mfn-toggled',
							'title' => __('Border color', 'mfn-opts'),
						),

						array(
							'id' => 'background_switcher',
							'attr_id' => 'background_switcher_osf',
							'type' => 'switch',
							'class' => 'mfn-fields-switcher',
							'title' => __('Background type', 'mfn-opts'),
							'options' => array(
		  					'default' => __('Default', 'mfn-opts'),
		  					'gradient' 	=> __('Gradient', 'mfn-opts'),
		  				),
							'visual_options' => array(
		  					'default' => '',
		  					'gradient' 	=> '',
		  				),
		  				'std' => 'default',
						),

						array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .offer .offer_li .desc_wrapper .title a.button:background-color',
							'condition' => array( 'id' => 'background_switcher_osf', 'opt' => 'is', 'val' => 'default' ),
							'type' => 'color',
							'title' => __('Background color', 'mfn-opts'),
						),

						array(
		  				'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .offer .offer_li .desc_wrapper .title a.button:gradient',
		  				'condition' => array( 'id' => 'background_switcher_osf', 'opt' => 'is', 'val' => 'gradient' ),
		  				'type' => 'gradient',
		  				'title' => __('Gradient', 'mfn-opts'),
		  				'class' => 'mfn-toggled',
							'css_attr' => 'gradient',
		  			),

						array(
							'type' => 'html',
							'html' => '</div><div class="mfn-sft mfn-sft-hover">',
						),

						array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .offer .offer_li .desc_wrapper .title a.button|hover:color',
							'type' => 'color',
							'class' => 'main-color mfn-toggled',
							'title' => __('Color', 'mfn-opts'),
						),

						array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .offer .offer_li .desc_wrapper .title a.button|hover:border-color',
							'condition' => array( 'id' => 'border_style_osf_border', 'opt' => 'isnt', 'val' => 'none' ),
							'type' => 'color',
							'class' => 'mfn-toggled',
							'title' => __('Border color', 'mfn-opts'),
						),

						array(
							'id' => 'background_switcher_hover',
							'attr_id' => 'background_switcher_hover_osf',
							'type' => 'switch',
							'class' => 'mfn-fields-switcher',
							'title' => __('Background type', 'mfn-opts'),
							'options' => array(
		  					'default' => __('Default', 'mfn-opts'),
		  					'gradient' 	=> __('Gradient', 'mfn-opts'),
		  				),
							'visual_options' => array(
		  					'default' => '',
		  					'gradient' 	=> '',
		  				),
		  				'std' => 'default',
						),

						array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .offer .offer_li .desc_wrapper .title a.button|hover:background',
							'condition' => array( 'id' => 'background_switcher_hover_osf', 'opt' => 'is', 'val' => 'default' ),
							'type' => 'color',
							'class' => 'main-color mfn-toggled',
							'title' => __('Background color', 'mfn-opts'),
						),

						array(
		  				'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .offer .offer_li .desc_wrapper .title a.button|hover:gradient',
		  				'condition' => array( 'id' => 'background_switcher_hover_osf', 'opt' => 'is', 'val' => 'gradient' ),
		  				'type' => 'gradient',
		  				'title' => __('Gradient', 'mfn-opts'),
		  				'class' => 'mfn-toggled',
							'css_attr' => 'gradient',
		  			),

						array(
							'type' => 'html',
							'html' => '</div></div>',
						),

						array(
							'type' => 'html',
							'html' => '</div>',
						),

   				),
   			),

   			// Offer Slider Thumb ---------------------------------------------

   			'offer_thumb' => array(
   				'type' => 'offer_thumb',
   				'title' => __('Offer Slider Thumb', 'mfn-opts'),
   				'size' => '1/1',
   				'tablet_size' => '1/1',
   				'mobile_size' => '1/1',
   				'tablet_resized' => '0',
   				'cat' => 'loops',
   				'fields' => array(

   					array(
							'type' => 'html',
							'html' => $this->itemtabs,
						),

   					array(
							'type' => 'html',
							'html' => '<div class="modalbox-card modalbox-re_render modalbox-card-content-mfnuidhere active">',
						),

   					array(
   						'id' => 'category',
   						're_render' => 'standard',
   						'type' => 'select',
   						'title' => __('Category', 'mfn-opts'),
   						'options' => mfn_get_categories('offer-types'),
							'preview' => 'category',
   					),

   					array(
   						'id' => 'style',
   						're_render' => 'standard',
   						'type' => 'switch',
   						'title' => __('Thumbnails position', 'mfn-opts'),
   						'options' => array(
   							'bottom' => __('Bottom', 'mfn-opts'),
   							'' => __('Left', 'mfn-opts'),
   						),
   						'std' => 'bottom',
   					),

						array(
   						'class' => 'mfn-deprecated',
   						'title' => __('Deprecated', 'mfn-opts'),
   					),

   					array(
   						'id' => 'align',
   						'type' => 'switch',
							'class' => 'mfn-deprecated',
   						'title' => __('Text align', 'mfn-opts'),
   						'desc' => __('Text align center does not affect title if button is active', 'mfn-opts'),
   						'options' => array(
   							'left' => __('Left', 'mfn-opts'),
								'center' => __('Center', 'mfn-opts'),
   							'right' => __('Right', 'mfn-opts'),
   							'justify' => __('Justify', 'mfn-opts'),
   						),
							'std' => 'left',
   					),

						array(
							'id' => 'class',
							'type' => 'pills',
							'title' => __('Element classes', 'mfn-opts'),
							'class' => 'mfn-deprecated',
						),

   					array(
							'type' => 'html',
							'html' => '</div><div class="modalbox-card modalbox-card-style modalbox-re_render modalbox-card-style-mfnuidhere">',
						),

						array(
							'class' => 'toggled_header',
   						'title' => __('Image', 'mfn-opts'),
   					),

		  			array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .offer_thumb .offer_thumb_li .image_wrapper:border-style',
							'attr_id' => 'border_style_os_img',
							'type' => 'select',
							'class' => 'mfn-toggled',
							'title' => __('Border style', 'mfn-opts'),
							'options' => [
								'none' => __('None', 'mfn-opts'),
								'solid' => __('Solid', 'mfn-opts'),
								'dashed' => __('Dashed', 'mfn-opts'),
								'dotted' => __('Dotted', 'mfn-opts'),
								'double' => __('Double', 'mfn-opts'),
							],
						),

						array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .offer_thumb .offer_thumb_li .image_wrapper:border-color',
							'condition' => array( 'id' => 'border_style_os_img', 'opt' => 'isnt', 'val' => 'none' ),
							'type' => 'color',
							'class' => 'mfn-toggled',
							'title' => __('Border color', 'mfn-opts'),
						),

						array(
		  				'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .offer_thumb .offer_thumb_li .image_wrapper:border-width',
		  				'condition' => array( 'id' => 'border_style_os_img', 'opt' => 'isnt', 'val' => 'none' ),
		  				'type' => 'dimensions',
		  				'title' => __('Border width', 'mfn-opts'),
							'responsive' => 'desktop',
							'class' => 'mfn_field_desktop mfn-toggled',
							'css_attr' => 'border-width',
		  			),

		  			array(
		  				'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .offer_thumb .offer_thumb_li .image_wrapper:border-width_tablet',
		  				'condition' => array( 'id' => 'border_style_os_img', 'opt' => 'isnt', 'val' => 'none' ),
		  				'type' => 'dimensions',
		  				'title' => __('Border width', 'mfn-opts'),
							'responsive' => 'tablet',
							'class' => 'mfn_field_tablet mfn-toggled',
							'css_attr' => 'border-width',
		  			),

		  			array(
		  				'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .offer_thumb .offer_thumb_li .image_wrapper:border-width_mobile',
		  				'condition' => array( 'id' => 'border_style_os_img', 'opt' => 'isnt', 'val' => 'none' ),
		  				'type' => 'dimensions',
		  				'title' => __('Border width', 'mfn-opts'),
							'responsive' => 'mobile',
							'class' => 'mfn_field_mobile mfn-toggled',
							'css_attr' => 'border-width',
		  			),

						array(
		  				'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .offer_thumb .offer_thumb_li .image_wrapper:border-radius',
		  				'type' => 'dimensions',
		  				'title' => __('Border radius', 'mfn-opts'),
							'responsive' => 'desktop',
							'class' => 'mfn_field_desktop mfn-toggled',
							'css_attr' => 'border-radius',
		  			),

		  			array(
		  				'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .offer_thumb .offer_thumb_li .image_wrapper:border-radius_tablet',
		  				'type' => 'dimensions',
		  				'title' => __('Border radius', 'mfn-opts'),
							'responsive' => 'tablet',
							'class' => 'mfn_field_tablet mfn-toggled',
							'css_attr' => 'border-radius',
		  			),

		  			array(
		  				'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .offer_thumb .offer_thumb_li .image_wrapper:border-radius_mobile',
		  				'type' => 'dimensions',
		  				'title' => __('Border radius', 'mfn-opts'),
							'responsive' => 'mobile',
							'class' => 'mfn_field_mobile mfn-toggled',
							'css_attr' => 'border-radius',
		  			),

						array(
							'class' => 'toggled_header',
   						'title' => __('Title', 'mfn-opts'),
   					),

						array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .offer_thumb .offer_thumb_li .desc_wrapper .title h3:color',
							'type' => 'color',
							'class' => 'main-color mfn-toggled',
							'title' => __('Color', 'mfn-opts'),
						),

						array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .offer_thumb .offer_thumb_li .desc_wrapper .title h3:typography',
							'type' => 'typography_vb',
							'label_after' => '<a href="#" title="Edit" class="mfn-option-btn mfn-option-blank btn-medium mfn-vb-label-button"><span class="mfn-icon mfn-icon-edit"></span></a>',
							'class' => 'mfn-toggled toggle_fields',
							'title' => __('Typography', 'mfn-opts'),
						),

						array(
							'class' => 'toggled_header',
   						'title' => __('Content', 'mfn-opts'),
   					),

						array(
   						'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .desc_wrapper:text-align',
							'responsive' => 'desktop',
   						'type' => 'switch',
   						'class' => 'mfn_field_desktop mfn-toggled',
   						'title' => __('Text align', 'mfn-opts'),
   						'options' => array(
   							'' => __('Default', 'mfn-opts'),
   							'left' => __('Left', 'mfn-opts'),
								'center' => __('Center', 'mfn-opts'),
   							'right' => __('Right', 'mfn-opts'),
   							'justify' => __('Justify', 'mfn-opts'),
   						),
							'std' => '',
   					),
   					array(
   						'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .desc_wrapper:text-align_tablet',
							'responsive' => 'tablet',
   						'type' => 'switch',
   						'class' => 'mfn_field_tablet mfn-toggled',
   						'title' => __('Text align', 'mfn-opts'),
   						'options' => array(
   							'' => __('Default', 'mfn-opts'),
   							'left' => __('Left', 'mfn-opts'),
								'center' => __('Center', 'mfn-opts'),
   							'right' => __('Right', 'mfn-opts'),
   							'justify' => __('Justify', 'mfn-opts'),
   						),
							'std' => '',
   					),
   					array(
   						'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .desc_wrapper:text-align_mobile',
							'responsive' => 'mobile',
   						'type' => 'switch',
   						'class' => 'mfn_field_mobile mfn-toggled',
   						'title' => __('Text align', 'mfn-opts'),
   						'options' => array(
   							'' => __('Default', 'mfn-opts'),
   							'left' => __('Left', 'mfn-opts'),
								'center' => __('Center', 'mfn-opts'),
   							'right' => __('Right', 'mfn-opts'),
   							'justify' => __('Justify', 'mfn-opts'),
   						),
							'std' => '',
   					),

						array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .offer_thumb .offer_thumb_li .desc_wrapper .desc:color',
							'type' => 'color',
							'class' => 'main-color mfn-toggled',
							'title' => __('Color', 'mfn-opts'),
						),

						array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .offer_thumb .offer_thumb_li .desc_wrapper .desc:typography',
							'type' => 'typography_vb',
							'label_after' => '<a href="#" title="Edit" class="mfn-option-btn mfn-option-blank btn-medium mfn-vb-label-button"><span class="mfn-icon mfn-icon-edit"></span></a>',
							'class' => 'mfn-toggled toggle_fields',
							'title' => __('Typography', 'mfn-opts'),
						),

						array(
							'class' => 'toggled_header',
   						'title' => __('Nav', 'mfn-opts'),
   					),

   					array(
							'type' => 'html',
							'html' => '<div class="mfn-form-row mfn-sidebar-fields-tabs mfn-toggled mfn-vb-formrow mfn-vb-mfnuidhere"><ul class="mfn-sft-nav"><li class="active"><a href="#normal" data-tab="normal">Normal</a></li><li><a href="#hover" data-tab="hover">Active</a></li></ul><div class="mfn-sft mfn-sft-normal">',
						),

						array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .offer_thumb .slider_pagination li a:background-color',
							'type' => 'color',
							'title' => __('Background', 'mfn-opts'),
						),

   					array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .offer_thumb .slider_pagination li a:border-color',
							'type' => 'color',
							'title' => __('Border color', 'mfn-opts'),
						),

						array(
							'type' => 'html',
							'html' => '</div><div class="mfn-sft mfn-sft-hover">',
						),

						array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .offer_thumb .slider_pagination li.slick-active a:background-color',
							'type' => 'color',
							'title' => __('Background', 'mfn-opts'),
						),

						array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .offer_thumb .slider_pagination li.slick-active a:border-color',
							'type' => 'color',
							'title' => __('Border color', 'mfn-opts'),
						),

						array(
							'type' => 'html',
							'html' => '</div></div>',
						),

						array(
							'class' => 'toggled_header',
   						'title' => __('Button', 'mfn-opts'),
   					),

		  			array(
		  				'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .offer_thumb .offer_thumb_li .desc_wrapper .title a.button:padding',
		  				'type' => 'dimensions',
		  				'version' => 'separated-fields',
		  				'title' => __('Padding', 'mfn-opts'),
							'responsive' => 'desktop',
							'class' => 'mfn_field_desktop mfn-toggled',
							'css_attr' => 'padding',
		  			),

		  			array(
		  				'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .offer_thumb .offer_thumb_li .desc_wrapper .title a.button:padding_tablet',
		  				'type' => 'dimensions',
		  				'version' => 'separated-fields',
		  				'title' => __('Padding', 'mfn-opts'),
							'responsive' => 'tablet',
							'class' => 'mfn_field_tablet mfn-toggled',
							'css_attr' => 'padding',
		  			),

		  			array(
		  				'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .offer_thumb .offer_thumb_li .desc_wrapper .title a.button:padding_mobile',
		  				'type' => 'dimensions',
		  				'version' => 'separated-fields',
		  				'title' => __('Padding', 'mfn-opts'),
							'responsive' => 'mobile',
							'class' => 'mfn_field_mobile mfn-toggled',
							'css_attr' => 'padding',
		  			),

		  			array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .offer_thumb .offer_thumb_li .desc_wrapper .title a.button:typography',
							'type' => 'typography_vb',
							'label_after' => '<a href="#" title="Edit" class="mfn-option-btn mfn-option-blank btn-medium mfn-vb-label-button"><span class="mfn-icon mfn-icon-edit"></span></a>',
							'class' => 'mfn-toggled toggle_fields',
							'title' => __('Typography', 'mfn-opts'),
						),

						array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .offer_thumb .offer_thumb_li .desc_wrapper .title a.button:border-style',
							'attr_id' => 'border_style_osf_border',
							'type' => 'select',
							'class' => 'mfn-toggled',
							'title' => __('Border style', 'mfn-opts'),
							'options' => [
								'none' => __('None', 'mfn-opts'),
								'solid' => __('Solid', 'mfn-opts'),
								'dashed' => __('Dashed', 'mfn-opts'),
								'dotted' => __('Dotted', 'mfn-opts'),
								'double' => __('Double', 'mfn-opts'),
							],
						),

						array(
		  				'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .offer_thumb .offer_thumb_li .desc_wrapper .title a.button:border-width',
		  				'condition' => array( 'id' => 'border_style_osf_border', 'opt' => 'isnt', 'val' => 'none' ),
		  				'type' => 'dimensions',
		  				'title' => __('Border width', 'mfn-opts'),
							'responsive' => 'desktop',
							'class' => 'mfn_field_desktop mfn-toggled',
							'css_attr' => 'border-width',
		  			),

		  			array(
		  				'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .offer_thumb .offer_thumb_li .desc_wrapper .title a.button:border-width_tablet',
		  				'condition' => array( 'id' => 'border_style_osf_border', 'opt' => 'isnt', 'val' => 'none' ),
		  				'type' => 'dimensions',
		  				'title' => __('Border width', 'mfn-opts'),
							'responsive' => 'tablet',
							'class' => 'mfn_field_tablet mfn-toggled',
							'css_attr' => 'border-width',
		  			),

		  			array(
		  				'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .offer_thumb .offer_thumb_li .desc_wrapper .title a.button:border-width_mobile',
		  				'condition' => array( 'id' => 'border_style_osf_border', 'opt' => 'isnt', 'val' => 'none' ),
		  				'type' => 'dimensions',
		  				'title' => __('Border width', 'mfn-opts'),
							'responsive' => 'mobile',
							'class' => 'mfn_field_mobile mfn-toggled',
							'css_attr' => 'border-width',
		  			),

						array(
		  				'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .offer_thumb .offer_thumb_li .desc_wrapper .title a.button:border-radius',
		  				'type' => 'dimensions',
		  				'title' => __('Border radius', 'mfn-opts'),
							'responsive' => 'desktop',
							'class' => 'mfn_field_desktop mfn-toggled',
							'css_attr' => 'border-radius',
		  			),

		  			array(
		  				'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .offer_thumb .offer_thumb_li .desc_wrapper .title a.button:border-radius_tablet',
		  				'type' => 'dimensions',
		  				'title' => __('Border radius', 'mfn-opts'),
							'responsive' => 'tablet',
							'class' => 'mfn_field_tablet mfn-toggled',
							'css_attr' => 'border-radius',
		  			),

		  			array(
		  				'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .offer_thumb .offer_thumb_li .desc_wrapper .title a.button:border-radius_mobile',
		  				'type' => 'dimensions',
		  				'title' => __('Border radius', 'mfn-opts'),
							'responsive' => 'mobile',
							'class' => 'mfn_field_mobile mfn-toggled',
							'css_attr' => 'border-radius',
		  			),

   					array(
							'type' => 'html',
							'html' => '<div class="mfn-form-row mfn-sidebar-fields-tabs mfn-toggled mfn-vb-formrow mfn-vb-mfnuidhere"><ul class="mfn-sft-nav"><li class="active"><a href="#normal" data-tab="normal">Normal</a></li><li><a href="#hover" data-tab="hover">Hover</a></li></ul><div class="mfn-sft mfn-sft-normal">',
						),

						array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .offer_thumb .offer_thumb_li .desc_wrapper .title a.button:color',
							'type' => 'color',
							'class' => 'main-color mfn-toggled',
							'title' => __('Color', 'mfn-opts'),
						),

						array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .offer_thumb .offer_thumb_li .desc_wrapper .title a.button:border-color',
							'condition' => array( 'id' => 'border_style_osf_border', 'opt' => 'isnt', 'val' => 'none' ),
							'type' => 'color',
							'class' => 'mfn-toggled',
							'title' => __('Border color', 'mfn-opts'),
						),

						array(
							'id' => 'background_switcher',
							'attr_id' => 'background_switcher_osf',
							'type' => 'switch',
							'class' => 'mfn-fields-switcher',
							'title' => __('Background type', 'mfn-opts'),
							'options' => array(
		  					'default' => __('Default', 'mfn-opts'),
		  					'gradient' 	=> __('Gradient', 'mfn-opts'),
		  				),
							'visual_options' => array(
		  					'default' => '',
		  					'gradient' 	=> '',
		  				),
		  				'std' => 'default',
						),

						array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .offer_thumb .offer_thumb_li .desc_wrapper .title a.button:background-color',
							'condition' => array( 'id' => 'background_switcher_osf', 'opt' => 'is', 'val' => 'default' ),
							'type' => 'color',
							'title' => __('Background color', 'mfn-opts'),
						),

						array(
		  				'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .offer_thumb .offer_thumb_li .desc_wrapper .title a.button:gradient',
		  				'condition' => array( 'id' => 'background_switcher_osf', 'opt' => 'is', 'val' => 'gradient' ),
		  				'type' => 'gradient',
		  				'title' => __('Gradient', 'mfn-opts'),
		  				'class' => 'mfn-toggled',
							'css_attr' => 'gradient',
		  			),

						array(
							'type' => 'html',
							'html' => '</div><div class="mfn-sft mfn-sft-hover">',
						),

						array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .offer_thumb .offer_thumb_li .desc_wrapper .title a.button|hover:color',
							'type' => 'color',
							'class' => 'main-color mfn-toggled',
							'title' => __('Color', 'mfn-opts'),
						),

						array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .offer_thumb .offer_thumb_li .desc_wrapper .title a.button|hover:border-color',
							'condition' => array( 'id' => 'border_style_osf_border', 'opt' => 'isnt', 'val' => 'none' ),
							'type' => 'color',
							'class' => 'mfn-toggled',
							'title' => __('Border color', 'mfn-opts'),
						),

						array(
							'id' => 'background_switcher_hover',
							'attr_id' => 'background_switcher_hover_osf',
							'type' => 'switch',
							'class' => 'mfn-fields-switcher',
							'title' => __('Background type', 'mfn-opts'),
							'options' => array(
		  					'default' => __('Default', 'mfn-opts'),
		  					'gradient' 	=> __('Gradient', 'mfn-opts'),
		  				),
							'visual_options' => array(
		  					'default' => '',
		  					'gradient' 	=> '',
		  				),
		  				'std' => 'default',
						),

						array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .offer_thumb .offer_thumb_li .desc_wrapper .title a.button|hover:background',
							'condition' => array( 'id' => 'background_switcher_hover_osf', 'opt' => 'is', 'val' => 'default' ),
							'type' => 'color',
							'class' => 'main-color mfn-toggled',
							'title' => __('Background color', 'mfn-opts'),
						),

						array(
		  				'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .offer_thumb .offer_thumb_li .desc_wrapper .title a.button|hover:gradient',
		  				'condition' => array( 'id' => 'background_switcher_hover_osf', 'opt' => 'is', 'val' => 'gradient' ),
		  				'type' => 'gradient',
		  				'title' => __('Gradient', 'mfn-opts'),
		  				'class' => 'mfn-toggled',
							'css_attr' => 'gradient',
		  			),

						array(
							'type' => 'html',
							'html' => '</div></div>',
						),

						array(
							'class' => 'toggled_header',
							'themeoptions' => 'style:',
   						'title' => __('Decoration', 'mfn-opts'),
   					),

   					array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .offer_thumb .slider_pagination li:--mfn-offer-thumbs-nav',
							'themeoptions' => 'style:',
							'type' => 'color',
							'class' => 'mfn-toggled',
							'title' => __('Active', 'mfn-opts'),
						),


						array(
							'type' => 'html',
							'html' => '</div>',
						),

   				),
   			),

   			// Opening Hours --------------------------------------------------

   			'opening_hours' => array(
   				'type' => 'opening_hours',
   				'title' => __('Opening Hours', 'mfn-opts'),
   				'size' => '1/4',
   				'tablet_size' => '1/4',
   				'mobile_size' => '1/1',
   				'tablet_resized' => '0',
   				'cat' => 'elements',
   				'fields' => array(

   					array(
							'type' => 'html',
							'html' => $this->itemtabs,
						),

   					array(
							'type' => 'html',
							'html' => '<div class="modalbox-card modalbox-re_render modalbox-card-content-mfnuidhere active">',
						),

   					array(
   						'id' => 'title',
   						'edit_tag' => '.opening_hours | h3',
   						'edit_position' => 'prepend',
   						'type' => 'text',
   						'title' => __('Title', 'mfn-opts'),
							'std' => __('This is the title', 'mfn-opts'),
							'preview' => 'title',
   					),

						array(
   						'id' => 'tabs',
   						'type' => 'tabs',
   						'title' => __('Days', 'mfn-opts'),
							'options' => [
								'days' => [
									'input',
									__('Days', 'mfn-opts'),
									'Monday - Friday',
								],
								'hours' => [
									'input',
									__('Hours', 'mfn-opts'),
									'8am - 4pm',
								],
							],
							'std' => [
								0 => [
									'days' => 'Monday - Friday',
									'hours' => '8am - 4pm',
								],
								1 => [
									'days' => 'Saturday',
									'hours' => '10am - 2pm',
								],
							],
							'primary' => 'days',
							'preview' => 'tabs',
   					),

   					array(
   						'id' => 'content',
   						'type' => 'textarea',
   						'edit_tag' => '.opening_hours_wrapper | span.ohw-desc',
   						'edit_position' => 'prepend',
   						'title' => __('Content', 'mfn-opts'),
							'preview' => 'content',
							'class' => 'form-content-full-width',
							'std' => __('Vitae adipiscing turpis. Aenean ligula nibh, molestie id viverra a, dapibus at dolor.', 'mfn-opts')
   					),

   					array(
							'class' => 'mfn-deprecated',
   						'title' => __('Deprecated', 'mfn-opts'),
   					),

   					array(
   						'id' => 'image',
   						'class' => 'mfn-deprecated',
   						'type' => 'upload',
   						'title' => __('Background image', 'mfn-opts'),
   						'desc' => __('Recommended image width <b>768px - 1920px</b> depending on size of the item', 'mfn-opts'),
   					),

						array(
							'id' => 'class',
							'type' => 'pills',
							'title' => __('Element classes', 'mfn-opts'),
							'class' => 'mfn-deprecated',
						),

						array(
							'type' => 'html',
							'html' => '</div><div class="modalbox-card modalbox-card-style modalbox-re_render modalbox-card-style-mfnuidhere">',
						),

						array(
		  				'class' => 'toggled_header',
   						'title' => __('Container', 'mfn-opts'),
   					),

						array(
   						'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .opening_hours:text-align',
							'responsive' => 'desktop',
   						'type' => 'switch',
   						'class' => 'mfn_field_desktop mfn-toggled',
   						'title' => __('Text align', 'mfn-opts'),
   						'options' => array(
   							'' => __('Default', 'mfn-opts'),
   							'left' => __('Left', 'mfn-opts'),
								'center' => __('Center', 'mfn-opts'),
   							'right' => __('Right', 'mfn-opts'),
   							'justify' => __('Justify', 'mfn-opts'),
   						),
							'preview' => 'align',
   					),
   					array(
   						'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .opening_hours:text-align_tablet',
							'responsive' => 'tablet',
   						'type' => 'switch',
   						'class' => 'mfn_field_tablet mfn-toggled',
   						'title' => __('Text align', 'mfn-opts'),
   						'options' => array(
   							'' => __('Default', 'mfn-opts'),
   							'left' => __('Left', 'mfn-opts'),
								'center' => __('Center', 'mfn-opts'),
   							'right' => __('Right', 'mfn-opts'),
   							'justify' => __('Justify', 'mfn-opts'),
   						),
							'preview' => 'align',
   					),
   					array(
   						'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .opening_hours:text-align_mobile',
							'responsive' => 'mobile',
   						'type' => 'switch',
   						'class' => 'mfn_field_mobile mfn-toggled',
   						'title' => __('Text align', 'mfn-opts'),
   						'options' => array(
   							'' => __('Default', 'mfn-opts'),
   							'left' => __('Left', 'mfn-opts'),
								'center' => __('Center', 'mfn-opts'),
   							'right' => __('Right', 'mfn-opts'),
   							'justify' => __('Justify', 'mfn-opts'),
   						),
							'preview' => 'align',
   					),

   					array(
		  				'class' => 'toggled_header',
   						'title' => __('Row', 'mfn-opts'),
   					),

   					array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .opening_hours .opening_hours_wrapper li:border-style',
							'attr_id' => 'border_style_oh_row',
							'type' => 'select',
							'class' => 'mfn-toggled',
							'title' => __('Border style', 'mfn-opts'),
							'options' => [
								'none' => __('None', 'mfn-opts'),
								'solid' => __('Solid', 'mfn-opts'),
								'dashed' => __('Dashed', 'mfn-opts'),
								'dotted' => __('Dotted', 'mfn-opts'),
								'double' => __('Double', 'mfn-opts'),
							],
						),

						array(
		  				'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .opening_hours .opening_hours_wrapper li:border-width',
		  				'condition' => array( 'id' => 'border_style_oh_row', 'opt' => 'isnt', 'val' => 'none' ),
		  				'type' => 'dimensions',
		  				'title' => __('Border width', 'mfn-opts'),
							'responsive' => 'desktop',
							'class' => 'mfn_field_desktop mfn-toggled',
							'css_attr' => 'border-width',
		  			),

		  			array(
		  				'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .opening_hours .opening_hours_wrapper li:border-width_tablet',
		  				'condition' => array( 'id' => 'border_style_oh_row', 'opt' => 'isnt', 'val' => 'none' ),
		  				'type' => 'dimensions',
		  				'title' => __('Border width', 'mfn-opts'),
							'responsive' => 'tablet',
							'class' => 'mfn_field_tablet mfn-toggled',
							'css_attr' => 'border-width',
		  			),

		  			array(
		  				'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .opening_hours .opening_hours_wrapper li:border-width_mobile',
		  				'condition' => array( 'id' => 'border_style_oh_row', 'opt' => 'isnt', 'val' => 'none' ),
		  				'type' => 'dimensions',
		  				'title' => __('Border width', 'mfn-opts'),
							'responsive' => 'mobile',
							'class' => 'mfn_field_mobile mfn-toggled',
							'css_attr' => 'border-width',
		  			),

		  			array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .opening_hours .opening_hours_wrapper li:border-color',
							'condition' => array( 'id' => 'border_style_oh_row', 'opt' => 'isnt', 'val' => 'none' ),
							'type' => 'color',
							'class' => 'main-color mfn-toggled',
							'title' => __('Border color', 'mfn-opts'),
						),

						array(
		  				'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .opening_hours .opening_hours_wrapper li:border-radius',
		  				'type' => 'dimensions',
		  				'title' => __('Border radius', 'mfn-opts'),
							'responsive' => 'desktop',
							'class' => 'mfn_field_desktop mfn-toggled',
							'css_attr' => 'border-radius',
		  			),

		  			array(
		  				'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .opening_hours .opening_hours_wrapper li:border-radius_tablet',
		  				'type' => 'dimensions',
		  				'title' => __('Border radius', 'mfn-opts'),
							'responsive' => 'tablet',
							'class' => 'mfn_field_tablet mfn-toggled',
							'css_attr' => 'border-radius',
		  			),

		  			array(
		  				'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .opening_hours .opening_hours_wrapper li:border-radius_mobile',
		  				'type' => 'dimensions',
		  				'title' => __('Border radius', 'mfn-opts'),
							'responsive' => 'mobile',
							'class' => 'mfn_field_mobile mfn-toggled',
							'css_attr' => 'border-radius',
		  			),

   					array(
		  				'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .opening_hours .opening_hours_wrapper li:margin',
		  				'type' => 'dimensions',
		  				'version' => 'separated-fields',
		  				'title' => __('Margin', 'mfn-opts'),
							'responsive' => 'desktop',
							'class' => 'mfn_field_desktop mfn-toggled',
							'css_attr' => 'margin',
		  			),

		  			array(
		  				'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .opening_hours .opening_hours_wrapper li:margin_tablet',
		  				'type' => 'dimensions',
		  				'version' => 'separated-fields',
		  				'title' => __('Margin', 'mfn-opts'),
							'responsive' => 'tablet',
							'class' => 'mfn_field_tablet mfn-toggled',
							'css_attr' => 'margin',
		  			),

		  			array(
		  				'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .opening_hours .opening_hours_wrapper li:margin_mobile',
		  				'type' => 'dimensions',
		  				'version' => 'separated-fields',
		  				'title' => __('Margin', 'mfn-opts'),
							'responsive' => 'mobile',
							'class' => 'mfn_field_mobile mfn-toggled',
							'css_attr' => 'margin',
		  			),

   					array(
		  				'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .opening_hours .opening_hours_wrapper li:padding',
		  				'type' => 'dimensions',
		  				'version' => 'separated-fields',
		  				'title' => __('Padding', 'mfn-opts'),
							'responsive' => 'desktop',
							'class' => 'mfn_field_desktop mfn-toggled',
							'css_attr' => 'padding',
		  			),

		  			array(
		  				'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .opening_hours .opening_hours_wrapper li:padding_tablet',
		  				'type' => 'dimensions',
		  				'version' => 'separated-fields',
		  				'title' => __('Padding', 'mfn-opts'),
							'responsive' => 'tablet',
							'class' => 'mfn_field_tablet mfn-toggled',
							'css_attr' => 'padding',
		  			),

		  			array(
		  				'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .opening_hours .opening_hours_wrapper li:padding_mobile',
		  				'type' => 'dimensions',
		  				'version' => 'separated-fields',
		  				'title' => __('Padding', 'mfn-opts'),
							'responsive' => 'mobile',
							'class' => 'mfn_field_mobile mfn-toggled',
							'css_attr' => 'padding',
		  			),

						array(
   						'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .opening_hours .opening_hours_wrapper li:text-align',
							'responsive' => 'desktop',
   						'type' => 'switch',
   						'class' => 'mfn_field_desktop mfn-toggled',
   						'title' => __('Text align', 'mfn-opts'),
   						'options' => array(
   							'' => __('Default', 'mfn-opts'),
   							'left' => __('Left', 'mfn-opts'),
								'center' => __('Center', 'mfn-opts'),
   							'right' => __('Right', 'mfn-opts'),
   							'justify' => __('Justify', 'mfn-opts'),
   						),
							'preview' => 'align',
   					),
   					array(
   						'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .opening_hours .opening_hours_wrapper li:text-align_tablet',
							'responsive' => 'tablet',
   						'type' => 'switch',
   						'class' => 'mfn_field_tablet mfn-toggled',
   						'title' => __('Text align', 'mfn-opts'),
   						'options' => array(
   							'' => __('Default', 'mfn-opts'),
   							'left' => __('Left', 'mfn-opts'),
								'center' => __('Center', 'mfn-opts'),
   							'right' => __('Right', 'mfn-opts'),
   							'justify' => __('Justify', 'mfn-opts'),
   						),
							'preview' => 'align',
   					),
   					array(
   						'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .opening_hours .opening_hours_wrapper li:text-align_mobile',
							'responsive' => 'mobile',
   						'type' => 'switch',
   						'class' => 'mfn_field_mobile mfn-toggled',
   						'title' => __('Text align', 'mfn-opts'),
   						'options' => array(
   							'' => __('Default', 'mfn-opts'),
   							'left' => __('Left', 'mfn-opts'),
								'center' => __('Center', 'mfn-opts'),
   							'right' => __('Right', 'mfn-opts'),
   							'justify' => __('Justify', 'mfn-opts'),
   						),
							'preview' => 'align',
   					),

						array(
							'class' => 'toggled_header',
   						'title' => __('Title', 'mfn-opts'),
   					),

						array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .opening_hours h3:color',
							'type' => 'color',
							'class' => 'main-color mfn-toggled',
							'title' => __('Color', 'mfn-opts'),
						),

						array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .opening_hours h3:typography',
							'type' => 'typography_vb',
							'label_after' => '<a href="#" title="Edit" class="mfn-option-btn mfn-option-blank btn-medium mfn-vb-label-button"><span class="mfn-icon mfn-icon-edit"></span></a>',
							'class' => 'mfn-toggled toggle_fields',
							'title' => __('Typography', 'mfn-opts'),
						),

						array(
		  				'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .opening_hours h3:margin',
		  				'type' => 'dimensions',
		  				'version' => 'separated-fields',
		  				'title' => __('Margin', 'mfn-opts'),
							'responsive' => 'desktop',
							'class' => 'mfn_field_desktop mfn-toggled',
							'css_attr' => 'margin',
		  			),

		  			array(
		  				'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .opening_hours h3:margin_tablet',
		  				'type' => 'dimensions',
		  				'version' => 'separated-fields',
		  				'title' => __('Margin', 'mfn-opts'),
							'responsive' => 'tablet',
							'class' => 'mfn_field_tablet mfn-toggled',
							'css_attr' => 'margin',
		  			),

		  			array(
		  				'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .opening_hours h3:margin_mobile',
		  				'type' => 'dimensions',
		  				'version' => 'separated-fields',
		  				'title' => __('Margin', 'mfn-opts'),
							'responsive' => 'mobile',
							'class' => 'mfn_field_mobile mfn-toggled',
							'css_attr' => 'margin',
		  			),

						array(
							'class' => 'toggled_header',
   						'title' => __('Content', 'mfn-opts'),
   					),

						array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .opening_hours_wrapper .ohw-desc:color',
							'type' => 'color',
							'class' => 'main-color mfn-toggled',
							'title' => __('Color', 'mfn-opts'),
						),

						array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .opening_hours_wrapper .ohw-desc:typography',
							'type' => 'typography_vb',
							'label_after' => '<a href="#" title="Edit" class="mfn-option-btn mfn-option-blank btn-medium mfn-vb-label-button"><span class="mfn-icon mfn-icon-edit"></span></a>',
							'class' => 'mfn-toggled toggle_fields',
							'title' => __('Typography', 'mfn-opts'),
						),

						array(
		  				'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .opening_hours_wrapper .ohw-desc:margin',
		  				'type' => 'dimensions',
		  				'version' => 'separated-fields',
		  				'title' => __('Margin', 'mfn-opts'),
							'responsive' => 'desktop',
							'class' => 'mfn_field_desktop mfn-toggled',
							'css_attr' => 'margin',
		  			),

		  			array(
		  				'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .opening_hours_wrapper .ohw-desc:margin_tablet',
		  				'type' => 'dimensions',
		  				'version' => 'separated-fields',
		  				'title' => __('Margin', 'mfn-opts'),
							'responsive' => 'tablet',
							'class' => 'mfn_field_tablet mfn-toggled',
							'css_attr' => 'margin',
		  			),

		  			array(
		  				'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .opening_hours_wrapper .ohw-desc:margin_mobile',
		  				'type' => 'dimensions',
		  				'version' => 'separated-fields',
		  				'title' => __('Margin', 'mfn-opts'),
							'responsive' => 'mobile',
							'class' => 'mfn_field_mobile mfn-toggled',
							'css_attr' => 'margin',
		  			),

						array(
							'class' => 'toggled_header',
   						'title' => __('Days', 'mfn-opts'),
   					),

						array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .opening_hours .opening_hours_wrapper li label:color',
							'type' => 'color',
							'class' => 'main-color mfn-toggled',
							'title' => __('Color', 'mfn-opts'),
						),

						array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .opening_hours .opening_hours_wrapper li label:background',
							'type' => 'color',
							'class' => 'main-color mfn-toggled',
							'title' => __('Background', 'mfn-opts'),
						),

						array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .opening_hours .opening_hours_wrapper li label:typography',
							'type' => 'typography_vb',
							'label_after' => '<a href="#" title="Edit" class="mfn-option-btn mfn-option-blank btn-medium mfn-vb-label-button"><span class="mfn-icon mfn-icon-edit"></span></a>',
							'class' => 'mfn-toggled toggle_fields',
							'title' => __('Typography', 'mfn-opts'),
						),

						array(
		  				'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .opening_hours .opening_hours_wrapper li label:padding',
		  				'type' => 'dimensions',
		  				'version' => 'separated-fields',
		  				'title' => __('Padding', 'mfn-opts'),
							'responsive' => 'desktop',
							'class' => 'mfn_field_desktop mfn-toggled',
							'css_attr' => 'padding',
		  			),

		  			array(
		  				'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .opening_hours .opening_hours_wrapper li label:padding_tablet',
		  				'type' => 'dimensions',
		  				'version' => 'separated-fields',
		  				'title' => __('Padding', 'mfn-opts'),
							'responsive' => 'tablet',
							'class' => 'mfn_field_tablet mfn-toggled',
							'css_attr' => 'padding',
		  			),

		  			array(
		  				'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .opening_hours .opening_hours_wrapper li label:padding_mobile',
		  				'type' => 'dimensions',
		  				'version' => 'separated-fields',
		  				'title' => __('Padding', 'mfn-opts'),
							'responsive' => 'mobile',
							'class' => 'mfn_field_mobile mfn-toggled',
							'css_attr' => 'padding',
		  			),

		  			array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .opening_hours .opening_hours_wrapper li label:border-style',
							'attr_id' => 'border_style_oh',
							'type' => 'select',
							'class' => 'mfn-toggled',
							'title' => __('Border style', 'mfn-opts'),
							'options' => [
								'none' => __('None', 'mfn-opts'),
								'solid' => __('Solid', 'mfn-opts'),
								'dashed' => __('Dashed', 'mfn-opts'),
								'dotted' => __('Dotted', 'mfn-opts'),
								'double' => __('Double', 'mfn-opts'),
							],
						),

						array(
		  				'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .opening_hours .opening_hours_wrapper li label:border-width',
		  				'condition' => array( 'id' => 'border_style_oh', 'opt' => 'isnt', 'val' => 'none' ),
		  				'type' => 'dimensions',
		  				'title' => __('Border width', 'mfn-opts'),
							'responsive' => 'desktop',
							'class' => 'mfn_field_desktop mfn-toggled',
							'css_attr' => 'border-width',
		  			),

		  			array(
		  				'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .opening_hours .opening_hours_wrapper li label:border-width_tablet',
		  				'condition' => array( 'id' => 'border_style_oh', 'opt' => 'isnt', 'val' => 'none' ),
		  				'type' => 'dimensions',
		  				'title' => __('Border width', 'mfn-opts'),
							'responsive' => 'tablet',
							'class' => 'mfn_field_tablet mfn-toggled',
							'css_attr' => 'border-width',
		  			),

		  			array(
		  				'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .opening_hours .opening_hours_wrapper li label:border-width_mobile',
		  				'condition' => array( 'id' => 'border_style_oh', 'opt' => 'isnt', 'val' => 'none' ),
		  				'type' => 'dimensions',
		  				'title' => __('Border width', 'mfn-opts'),
							'responsive' => 'mobile',
							'class' => 'mfn_field_mobile mfn-toggled',
							'css_attr' => 'border-width',
		  			),

		  			array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .opening_hours .opening_hours_wrapper li label:border-color',
							'condition' => array( 'id' => 'border_style_oh', 'opt' => 'isnt', 'val' => 'none' ),
							'type' => 'color',
							'class' => 'main-color mfn-toggled',
							'title' => __('Border color', 'mfn-opts'),
						),

						array(
		  				'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .opening_hours .opening_hours_wrapper li label:border-radius',
		  				'type' => 'dimensions',
		  				'title' => __('Border radius', 'mfn-opts'),
							'responsive' => 'desktop',
							'class' => 'mfn_field_desktop mfn-toggled',
							'css_attr' => 'border-radius',
		  			),

		  			array(
		  				'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .opening_hours .opening_hours_wrapper li label:border-radius_tablet',
		  				'type' => 'dimensions',
		  				'title' => __('Border radius', 'mfn-opts'),
							'responsive' => 'tablet',
							'class' => 'mfn_field_tablet mfn-toggled',
							'css_attr' => 'border-radius',
		  			),

		  			array(
		  				'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .opening_hours .opening_hours_wrapper li label:border-radius_mobile',
		  				'type' => 'dimensions',
		  				'title' => __('Border radius', 'mfn-opts'),
							'responsive' => 'mobile',
							'class' => 'mfn_field_mobile mfn-toggled',
							'css_attr' => 'border-radius',
		  			),

						array(
							'class' => 'toggled_header',
   						'title' => __('Hours', 'mfn-opts'),
   					),

						array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .opening_hours .opening_hours_wrapper li span:color',
							'type' => 'color',
							'class' => 'main-color mfn-toggled',
							'title' => __('Color', 'mfn-opts'),
						),

						array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .opening_hours .opening_hours_wrapper li span:typography',
							'type' => 'typography_vb',
							'label_after' => '<a href="#" title="Edit" class="mfn-option-btn mfn-option-blank btn-medium mfn-vb-label-button"><span class="mfn-icon mfn-icon-edit"></span></a>',
							'class' => 'mfn-toggled toggle_fields',
							'title' => __('Typography', 'mfn-opts'),
						),

						array(
							'type' => 'html',
							'html' => '</div>',
						),

   				),
   			),

   			// Our team -------------------------------------------------------

   			'our_team' => array(
   				'type' => 'our_team',
   				'title' => __('Our Team', 'mfn-opts'),
   				'size' => '1/4',
   				'tablet_size' => '1/4',
   				'mobile_size' => '1/1',
   				'tablet_resized' => '0',
   				'cat' => 'elements',
   				'fields' => array(

   					array(
							'type' => 'html',
							'html' => $this->itemtabs,
						),

   					array(
							'type' => 'html',
							'html' => '<div class="modalbox-card modalbox-re_render modalbox-card-content-mfnuidhere active">',
						),

   					array(
   						'id' => 'heading',
   						'type' => 'text',
   						'edit_tag' => '.team | h4.title',
   						'edit_position' => 'prepend',
   						'title' => __('Heading', 'mfn-opts'),
							'std' => __('This is the heading', 'mfn-opts'),
							'preview' => 'title',
   					),

   					array(
   						'id' => 'image',
   						'type' => 'upload',
   						'title' => __('Photo', 'mfn-opts'),
   						'desc' => __('Recommended image width <b>768px - 1920px</b> depending on size of the item', 'mfn-opts'),
							'std' => $this->get_placeholder(),
							'preview' => 'image',
   					),

   					array(
   						'id' => 'title',
   						'type' => 'text',
   						'edit_tag' => '.desc_wrapper | h4',
   						'edit_position' => 'prepend',
   						'title' => __('Title', 'mfn-opts'),
							'std' => __('This is the title', 'mfn-opts'),
							'preview' => 'subtitle',
   					),

   					array(
   						'id' => 'subtitle',
   						'type' => 'text',
   						'edit_tag' => '.desc_wrapper | p.subtitle',
   						'edit_position' => 'prepend',
   						'title' => __('Subtitle', 'mfn-opts'),
							'std' => __('This is the subtitle', 'mfn-opts'),
   					),

   					// description

   					array(
   						'title' => __('Description', 'mfn-opts'),
   					),

   					array(
   						'id' => 'phone',
   						'type' => 'text',
   						'title' => __('Phone', 'mfn-opts'),
   					),

   					array(
   						'id' => 'content',
   						'type' => 'textarea',
   						'edit_tag' => '.desc_wrapper | div.desc',
   						'edit_position' => 'append',
   						'title' => __('Content', 'mfn-opts'),
   						'desc' => __('Some shortcodes and HTML tags allowed', 'mfn-opts'),
							'class' => 'form-content-full-width',
   					),

   					array(
   						'id' => 'email',
   						'type' => 'text',
   						'title' => __('Email', 'mfn-opts'),
   					),

   					// social

   					array(
   						'title' => __('Social', 'mfn-opts'),
   					),

   					array(
   						'id' => 'facebook',
   						'type' => 'text',
   						'title' => __('Facebook', 'mfn-opts'),
   					),

   					array(
   						'id' => 'twitter',
   						'type' => 'text',
   						'title' => __('Twitter', 'mfn-opts'),
   					),

   					array(
   						'id' => 'linkedin',
   						'type' => 'text',
   						'title' => __('LinkedIn', 'mfn-opts'),
   					),

   					array(
   						'id' => 'vcard',
   						'type' => 'text',
   						'title' => __('vCard', 'mfn-opts'),
   					),

   					// other

   					array(
   						'title' => __('Other', 'mfn-opts'),
   					),

   					array(
   						'id' => 'blockquote',
   						'type' => 'textarea',
   						'title' => __('Blockquote', 'mfn-opts'),
							'class' => 'form-content-full-width',
   					),

   					array(
   						'id' => 'style',
   						'type' => 'switch',
   						're_render' => 'standard',
   						'title' => __('Style', 'mfn-opts'),
   						'options' => array(
   							'circle' => __('Circle', 'mfn-opts'),
   							'vertical' => __('Vertical', 'mfn-opts'),
   							'horizontal' => __('Horizontal', 'mfn-opts'),
   						),
   						'std' => 'vertical',
   					),

   					// link

   					array(
   						'title' => __('Link', 'mfn-opts'),
   					),

   					array(
   						'id' => 'link',
   						'type' => 'text',
   						'title' => __('Link', 'mfn-opts'),
   					),

   					array(
   						'id' => 'target',
   						'type' => 'select',
   						'title' => __('Target', 'mfn-opts'),
   						'options' => array(
   							0 => __('Default | _self', 'mfn-opts'),
   							1 => __('New tab or window | _blank', 'mfn-opts'),
   							'lightbox' => __('Lightbox (image or embed video)', 'mfn-opts'),
   						),
   					),

						// deprecated

						array(
							'class' => 'mfn-deprecated',
							'title' => __('Deprecated', 'mfn-opts'),
						),

						array(
							'id' => 'class',
							'type' => 'pills',
							'title' => __('Element classes', 'mfn-opts'),
							'class' => 'mfn-deprecated',
						),

   					array(
							'type' => 'html',
							'html' => '</div><div class="modalbox-card modalbox-card-style modalbox-re_render modalbox-card-style-mfnuidhere">',
						),

   					array(
							'class' => 'toggled_header',
   						'title' => __('Heading', 'mfn-opts'),
   					),

						array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .team h4.title:color',
							'type' => 'color',
							'class' => 'main-color mfn-toggled',
							'title' => __('Color', 'mfn-opts'),
						),

						array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .team h4.title:typography',
							'type' => 'typography_vb',
							'label_after' => '<a href="#" title="Edit" class="mfn-option-btn mfn-option-blank btn-medium mfn-vb-label-button"><span class="mfn-icon mfn-icon-edit"></span></a>',
							'class' => 'mfn-toggled toggle_fields',
							'title' => __('Typography', 'mfn-opts'),
						),

						array(
							'class' => 'toggled_header',
   						'title' => __('Image', 'mfn-opts'),
   					),

   					array(
		  				'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .team .image_frame:margin',
		  				'type' => 'dimensions',
		  				'version' => 'separated-fields',
		  				'title' => __('Margin', 'mfn-opts'),
							'responsive' => 'desktop',
							'class' => 'mfn_field_desktop mfn-toggled',
							'css_attr' => 'margin',
		  			),

		  			array(
		  				'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .team .image_frame:margin_tablet',
		  				'type' => 'dimensions',
		  				'version' => 'separated-fields',
		  				'title' => __('Margin', 'mfn-opts'),
							'responsive' => 'tablet',
							'class' => 'mfn_field_tablet mfn-toggled',
							'css_attr' => 'margin',
		  			),

		  			array(
		  				'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .team .image_frame:margin_mobile',
		  				'type' => 'dimensions',
		  				'version' => 'separated-fields',
		  				'title' => __('Margin', 'mfn-opts'),
							'responsive' => 'mobile',
							'class' => 'mfn_field_mobile mfn-toggled',
							'css_attr' => 'margin',
		  			),

		  			array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .team .image_frame:border-style',
							'attr_id' => 'border_style_os_img',
							'type' => 'select',
							'class' => 'mfn-toggled',
							'title' => __('Border style', 'mfn-opts'),
							'options' => [
								'none' => __('None', 'mfn-opts'),
								'solid' => __('Solid', 'mfn-opts'),
								'dashed' => __('Dashed', 'mfn-opts'),
								'dotted' => __('Dotted', 'mfn-opts'),
								'double' => __('Double', 'mfn-opts'),
							],
						),

						array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .team .image_frame:border-color',
							'condition' => array( 'id' => 'border_style_os_img', 'opt' => 'isnt', 'val' => 'none' ),
							'type' => 'color',
							'class' => 'mfn-toggled',
							'title' => __('Border color', 'mfn-opts'),
						),

						array(
		  				'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .team .image_frame:border-width',
		  				'condition' => array( 'id' => 'border_style_os_img', 'opt' => 'isnt', 'val' => 'none' ),
		  				'type' => 'dimensions',
		  				'title' => __('Border width', 'mfn-opts'),
							'responsive' => 'desktop',
							'class' => 'mfn_field_desktop mfn-toggled',
							'css_attr' => 'border-width',
		  			),

		  			array(
		  				'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .team .image_frame:border-width_tablet',
		  				'condition' => array( 'id' => 'border_style_os_img', 'opt' => 'isnt', 'val' => 'none' ),
		  				'type' => 'dimensions',
		  				'title' => __('Border width', 'mfn-opts'),
							'responsive' => 'tablet',
							'class' => 'mfn_field_tablet mfn-toggled',
							'css_attr' => 'border-width',
		  			),

		  			array(
		  				'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .team .image_frame:border-width_mobile',
		  				'condition' => array( 'id' => 'border_style_os_img', 'opt' => 'isnt', 'val' => 'none' ),
		  				'type' => 'dimensions',
		  				'title' => __('Border width', 'mfn-opts'),
							'responsive' => 'mobile',
							'class' => 'mfn_field_mobile mfn-toggled',
							'css_attr' => 'border-width',
		  			),

						array(
		  				'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .team .image_frame:border-radius',
		  				'type' => 'dimensions',
		  				'title' => __('Border radius', 'mfn-opts'),
							'responsive' => 'desktop',
							'class' => 'mfn_field_desktop mfn-toggled',
							'css_attr' => 'border-radius',
		  			),

		  			array(
		  				'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .team .image_frame:border-radius_tablet',
		  				'type' => 'dimensions',
		  				'title' => __('Border radius', 'mfn-opts'),
							'responsive' => 'tablet',
							'class' => 'mfn_field_tablet mfn-toggled',
							'css_attr' => 'border-radius',
		  			),

		  			array(
		  				'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .team .image_frame:border-radius_mobile',
		  				'type' => 'dimensions',
		  				'title' => __('Border radius', 'mfn-opts'),
							'responsive' => 'mobile',
							'class' => 'mfn_field_mobile mfn-toggled',
							'css_attr' => 'border-radius',
		  			),

		  			array(
							'class' => 'toggled_header',
   						'title' => __('Desc', 'mfn-opts'),
   					),

   					array(
   						'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .team .desc_wrapper:text-align',
							'responsive' => 'desktop',
   						'type' => 'switch',
   						'class' => 'mfn_field_desktop mfn-toggled',
   						'title' => __('Text align', 'mfn-opts'),
   						'options' => array(
   							'' => __('Default', 'mfn-opts'),
   							'left' => __('Left', 'mfn-opts'),
								'center' => __('Center', 'mfn-opts'),
   							'right' => __('Right', 'mfn-opts'),
   							'justify' => __('Justify', 'mfn-opts'),
   						),
							'preview' => 'align',
   					),
   					array(
   						'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .team .desc_wrapper:text-align_tablet',
							'responsive' => 'tablet',
   						'type' => 'switch',
   						'class' => 'mfn_field_tablet mfn-toggled',
   						'title' => __('Text align', 'mfn-opts'),
   						'options' => array(
   							'' => __('Default', 'mfn-opts'),
   							'left' => __('Left', 'mfn-opts'),
								'center' => __('Center', 'mfn-opts'),
   							'right' => __('Right', 'mfn-opts'),
   							'justify' => __('Justify', 'mfn-opts'),
   						),
							'preview' => 'align',
   					),
   					array(
   						'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .team .desc_wrapper:text-align_mobile',
							'responsive' => 'mobile',
   						'type' => 'switch',
   						'class' => 'mfn_field_mobile mfn-toggled',
   						'title' => __('Text align', 'mfn-opts'),
   						'options' => array(
   							'' => __('Default', 'mfn-opts'),
   							'left' => __('Left', 'mfn-opts'),
								'center' => __('Center', 'mfn-opts'),
   							'right' => __('Right', 'mfn-opts'),
   							'justify' => __('Justify', 'mfn-opts'),
   						),
							'preview' => 'align',
   					),

   					array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .team .desc_wrapper:background-color',
							'type' => 'color',
							'class' => 'main-color mfn-toggled',
							'title' => __('Background', 'mfn-opts'),
						),

						array(
		  				'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .team .desc_wrapper:padding',
		  				'type' => 'dimensions',
		  				'version' => 'separated-fields',
		  				'title' => __('Padding', 'mfn-opts'),
							'responsive' => 'desktop',
							'class' => 'mfn_field_desktop mfn-toggled',
							'css_attr' => 'padding',
		  			),

		  			array(
		  				'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .team .desc_wrapper:padding_tablet',
		  				'type' => 'dimensions',
		  				'version' => 'separated-fields',
		  				'title' => __('Padding', 'mfn-opts'),
							'responsive' => 'tablet',
							'class' => 'mfn_field_tablet mfn-toggled',
							'css_attr' => 'padding',
		  			),

		  			array(
		  				'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .team .desc_wrapper:padding_mobile',
		  				'type' => 'dimensions',
		  				'version' => 'separated-fields',
		  				'title' => __('Padding', 'mfn-opts'),
							'responsive' => 'mobile',
							'class' => 'mfn_field_mobile mfn-toggled',
							'css_attr' => 'padding',
		  			),

		  			array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .team .desc_wrapper:border-style',
							'attr_id' => 'border_style_os_img',
							'type' => 'select',
							'class' => 'mfn-toggled',
							'title' => __('Border style', 'mfn-opts'),
							'options' => [
								'none' => __('None', 'mfn-opts'),
								'solid' => __('Solid', 'mfn-opts'),
								'dashed' => __('Dashed', 'mfn-opts'),
								'dotted' => __('Dotted', 'mfn-opts'),
								'double' => __('Double', 'mfn-opts'),
							],
						),

						array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .team .desc_wrapper:border-color',
							'condition' => array( 'id' => 'border_style_os_img', 'opt' => 'isnt', 'val' => 'none' ),
							'type' => 'color',
							'class' => 'mfn-toggled',
							'title' => __('Border color', 'mfn-opts'),
						),

						array(
		  				'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .team .desc_wrapper:border-width',
		  				'condition' => array( 'id' => 'border_style_os_img', 'opt' => 'isnt', 'val' => 'none' ),
		  				'type' => 'dimensions',
		  				'title' => __('Border width', 'mfn-opts'),
							'responsive' => 'desktop',
							'class' => 'mfn_field_desktop mfn-toggled',
							'css_attr' => 'border-width',
		  			),

		  			array(
		  				'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .team .desc_wrapper:border-width_tablet',
		  				'condition' => array( 'id' => 'border_style_os_img', 'opt' => 'isnt', 'val' => 'none' ),
		  				'type' => 'dimensions',
		  				'title' => __('Border width', 'mfn-opts'),
							'responsive' => 'tablet',
							'class' => 'mfn_field_tablet mfn-toggled',
							'css_attr' => 'border-width',
		  			),

		  			array(
		  				'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .team .desc_wrapper:border-width_mobile',
		  				'condition' => array( 'id' => 'border_style_os_img', 'opt' => 'isnt', 'val' => 'none' ),
		  				'type' => 'dimensions',
		  				'title' => __('Border width', 'mfn-opts'),
							'responsive' => 'mobile',
							'class' => 'mfn_field_mobile mfn-toggled',
							'css_attr' => 'border-width',
		  			),

						array(
		  				'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .team .desc_wrapper:border-radius',
		  				'type' => 'dimensions',
		  				'title' => __('Border radius', 'mfn-opts'),
							'responsive' => 'desktop',
							'class' => 'mfn_field_desktop mfn-toggled',
							'css_attr' => 'border-radius',
		  			),

		  			array(
		  				'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .team .desc_wrapper:border-radius_tablet',
		  				'type' => 'dimensions',
		  				'title' => __('Border radius', 'mfn-opts'),
							'responsive' => 'tablet',
							'class' => 'mfn_field_tablet mfn-toggled',
							'css_attr' => 'border-radius',
		  			),

		  			array(
		  				'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .team .desc_wrapper:border-radius_mobile',
		  				'type' => 'dimensions',
		  				'title' => __('Border radius', 'mfn-opts'),
							'responsive' => 'mobile',
							'class' => 'mfn_field_mobile mfn-toggled',
							'css_attr' => 'border-radius',
		  			),

		  			array(
							'class' => 'toggled_header',
   						'title' => __('Title', 'mfn-opts'),
   					),

						array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .team .desc_wrapper h4:color',
							'type' => 'color',
							'class' => 'main-color mfn-toggled',
							'title' => __('Color', 'mfn-opts'),
						),

						array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .team .desc_wrapper h4:typography',
							'type' => 'typography_vb',
							'label_after' => '<a href="#" title="Edit" class="mfn-option-btn mfn-option-blank btn-medium mfn-vb-label-button"><span class="mfn-icon mfn-icon-edit"></span></a>',
							'class' => 'mfn-toggled toggle_fields',
							'title' => __('Typography', 'mfn-opts'),
						),

						array(
							'class' => 'toggled_header',
   						'title' => __('Subtitle', 'mfn-opts'),
   					),

						array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .team .desc_wrapper .subtitle:color',
							'type' => 'color',
							'class' => 'main-color mfn-toggled',
							'title' => __('Color', 'mfn-opts'),
						),

						array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .team .desc_wrapper .subtitle:typography',
							'type' => 'typography_vb',
							'label_after' => '<a href="#" title="Edit" class="mfn-option-btn mfn-option-blank btn-medium mfn-vb-label-button"><span class="mfn-icon mfn-icon-edit"></span></a>',
							'class' => 'mfn-toggled toggle_fields',
							'title' => __('Typography', 'mfn-opts'),
						),

						array(
							'class' => 'toggled_header',
   						'title' => __('Phone', 'mfn-opts'),
   					),

						array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .team .desc_wrapper .phone a:color',
							'type' => 'color',
							'class' => 'main-color mfn-toggled',
							'title' => __('Color', 'mfn-opts'),
						),

						array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .team .desc_wrapper .phone i:color',
							'type' => 'color',
							'class' => 'main-color mfn-toggled',
							'title' => __('Icon color', 'mfn-opts'),
						),

						array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .team .desc_wrapper .phone:typography',
							'type' => 'typography_vb',
							'label_after' => '<a href="#" title="Edit" class="mfn-option-btn mfn-option-blank btn-medium mfn-vb-label-button"><span class="mfn-icon mfn-icon-edit"></span></a>',
							'class' => 'mfn-toggled toggle_fields',
							'title' => __('Typography', 'mfn-opts'),
						),

						array(
							'class' => 'toggled_header',
   						'title' => __('Content', 'mfn-opts'),
   					),

						array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .team .desc_wrapper .desc:color',
							'type' => 'color',
							'class' => 'main-color mfn-toggled',
							'title' => __('Color', 'mfn-opts'),
						),

						array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .team .desc_wrapper .desc:typography',
							'type' => 'typography_vb',
							'label_after' => '<a href="#" title="Edit" class="mfn-option-btn mfn-option-blank btn-medium mfn-vb-label-button"><span class="mfn-icon mfn-icon-edit"></span></a>',
							'class' => 'mfn-toggled toggle_fields',
							'title' => __('Typography', 'mfn-opts'),
						),

						array(
							'class' => 'toggled_header',
   						'title' => __('Blockquote', 'mfn-opts'),
   					),

						array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .team .desc_wrapper blockquote:color',
							'type' => 'color',
							'class' => 'main-color mfn-toggled',
							'title' => __('Color', 'mfn-opts'),
						),

						array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .team .desc_wrapper blockquote:typography',
							'type' => 'typography_vb',
							'label_after' => '<a href="#" title="Edit" class="mfn-option-btn mfn-option-blank btn-medium mfn-vb-label-button"><span class="mfn-icon mfn-icon-edit"></span></a>',
							'class' => 'mfn-toggled toggle_fields',
							'title' => __('Typography', 'mfn-opts'),
						),

						array(
							'class' => 'toggled_header',
   						'title' => __('Blockquote icon', 'mfn-opts'),
   					),

						array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .team .desc_wrapper .mfn-blockquote-icon:color',
							'type' => 'color',
							'themeoptions' => 'style:',
							'class' => 'mfn-toggled',
							'title' => __('Color', 'mfn-opts'),
						),

						array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .team .desc_wrapper .mfn-blockquote-icon:font-size',
							'type' => 'sliderbar',
							'themeoptions' => 'style:',
							'responsive' => 'desktop',
							'class' => 'mfn_field_desktop mfn-toggled',
							'title' => __('Size', 'mfn-opts'),
							'units' => array(
								'px' 	=> array('min' => 1, 		'max' => 100, 'step' => 1),
								'em' 	=> array('min' => 0.1, 	'max' => 10, 	'step' => 0.1),
								'rem' => array('min' => 0.1, 	'max' => 10, 	'step' => 0.1),
								'vw' 	=> array('min' => 1, 		'max' => 100, 'step' => 1),
							)
						),

						array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .team .desc_wrapper .mfn-blockquote-icon:font-size_tablet',
							'type' => 'sliderbar',
							'themeoptions' => 'style:',
							'responsive' => 'tablet',
							'class' => 'mfn_field_tablet mfn-toggled',
							'title' => __('Size', 'mfn-opts'),
							'units' => array(
								'px' 	=> array('min' => 1, 		'max' => 100, 'step' => 1),
								'em' 	=> array('min' => 0.1, 	'max' => 10, 	'step' => 0.1),
								'rem' => array('min' => 0.1, 	'max' => 10, 	'step' => 0.1),
								'vw' 	=> array('min' => 1, 		'max' => 100, 'step' => 1),
							)
						),

						array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .team .desc_wrapper .mfn-blockquote-icon:font-size_mobile',
							'type' => 'sliderbar',
							'themeoptions' => 'style:',
							'responsive' => 'mobile',
							'class' => 'mfn_field_mobile mfn-toggled',
							'title' => __('Size', 'mfn-opts'),
							'units' => array(
								'px' 	=> array('min' => 1, 		'max' => 100, 'step' => 1),
								'em' 	=> array('min' => 0.1, 	'max' => 10, 	'step' => 0.1),
								'rem' => array('min' => 0.1, 	'max' => 10, 	'step' => 0.1),
								'vw' 	=> array('min' => 1, 		'max' => 100, 'step' => 1),
							)
						),

						array(
							'class' => 'toggled_header',
   						'title' => __('Blockquote lines', 'mfn-opts'),
   					),

						array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .team .desc_wrapper blockquote:text-decoration-color',
							'type' => 'color',
							'themeoptions' => 'style:',
							'class' => 'mfn-toggled',
							'title' => __('Color', 'mfn-opts'),
						),

						array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .team .desc_wrapper blockquote:text-underline-offset',
							'type' => 'text',
							'themeoptions' => 'style:',
							'class' => 'mfn-toggled',
							'default_unit' => 'px',
							'title' => __('Offset', 'mfn-opts'),
						),

						array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .team .desc_wrapper blockquote:text-decoration-thickness',
							'type' => 'text',
							'themeoptions' => 'style:',
							'class' => 'mfn-toggled',
							'default_unit' => 'px',
							'title' => __('Thickness', 'mfn-opts'),
						),

						array(
							'class' => 'toggled_header',
   						'title' => __('Icons', 'mfn-opts'),
   					),

   					array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .team .desc_wrapper .links a:border-style',
							'attr_id' => 'border_style_ot_icon',
							'type' => 'select',
							'class' => 'mfn-toggled',
							'title' => __('Border style', 'mfn-opts'),
							'options' => [
								'none' => __('None', 'mfn-opts'),
								'solid' => __('Solid', 'mfn-opts'),
								'dashed' => __('Dashed', 'mfn-opts'),
								'dotted' => __('Dotted', 'mfn-opts'),
								'double' => __('Double', 'mfn-opts'),
							],
						),

						array(
		  				'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .team .desc_wrapper .links a:border-width',
		  				'condition' => array( 'id' => 'border_style_ot_icon', 'opt' => 'isnt', 'val' => 'none' ),
		  				'type' => 'dimensions',
		  				'title' => __('Border width', 'mfn-opts'),
							'responsive' => 'desktop',
							'class' => 'mfn_field_desktop mfn-toggled',
							'css_attr' => 'border-width',
		  			),

		  			array(
		  				'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .team .desc_wrapper .links a:border-width_tablet',
		  				'condition' => array( 'id' => 'border_style_ot_icon', 'opt' => 'isnt', 'val' => 'none' ),
		  				'type' => 'dimensions',
		  				'title' => __('Border width', 'mfn-opts'),
							'responsive' => 'tablet',
							'class' => 'mfn_field_tablet mfn-toggled',
							'css_attr' => 'border-width',
		  			),

		  			array(
		  				'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .team .desc_wrapper .links a:border-width_mobile',
		  				'condition' => array( 'id' => 'border_style_ot_icon', 'opt' => 'isnt', 'val' => 'none' ),
		  				'type' => 'dimensions',
		  				'title' => __('Border width', 'mfn-opts'),
							'responsive' => 'mobile',
							'class' => 'mfn_field_mobile mfn-toggled',
							'css_attr' => 'border-width',
		  			),

						array(
		  				'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .team .desc_wrapper .links a:border-radius',
		  				'type' => 'dimensions',
		  				'title' => __('Border radius', 'mfn-opts'),
							'responsive' => 'desktop',
							'class' => 'mfn_field_desktop mfn-toggled',
							'css_attr' => 'border-radius',
		  			),

		  			array(
		  				'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .team .desc_wrapper .links a:border-radius_tablet',
		  				'type' => 'dimensions',
		  				'title' => __('Border radius', 'mfn-opts'),
							'responsive' => 'tablet',
							'class' => 'mfn_field_tablet mfn-toggled',
							'css_attr' => 'border-radius',
		  			),

		  			array(
		  				'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .team .desc_wrapper .links a:border-radius_mobile',
		  				'type' => 'dimensions',
		  				'title' => __('Border radius', 'mfn-opts'),
							'responsive' => 'mobile',
							'class' => 'mfn_field_mobile mfn-toggled',
							'css_attr' => 'border-radius',
		  			),

		  			array(
							'type' => 'html',
							'html' => '<div class="mfn-form-row mfn-sidebar-fields-tabs mfn-toggled mfn-vb-formrow mfn-vb-mfnuidhere"><ul class="mfn-sft-nav"><li class="active"><a href="#normal" data-tab="normal">Normal</a></li><li><a href="#hover" data-tab="hover">Hover</a></li></ul><div class="mfn-sft mfn-sft-normal">',
						),

						array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .team .desc_wrapper .links a span i:color',
							'type' => 'color',
							'class' => 'main-color mfn-toggled',
							'title' => __('Color', 'mfn-opts'),
						),

						array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .team .desc_wrapper .links a:background-color',
							'type' => 'color',
							'class' => 'main-color mfn-toggled',
							'title' => __('Background', 'mfn-opts'),
						),

						array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .team .desc_wrapper .links a:border-color',
							'condition' => array( 'id' => 'border_style_ot_icon', 'opt' => 'isnt', 'val' => 'none' ),
							'type' => 'color',
							'class' => 'mfn-toggled',
							'title' => __('Border color', 'mfn-opts'),
						),

						array(
							'type' => 'html',
							'html' => '</div><div class="mfn-sft mfn-sft-hover">',
						),

						array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .team .desc_wrapper .links a|hover span.b i:color',
							'type' => 'color',
							'class' => 'main-color mfn-toggled',
							'title' => __('Color', 'mfn-opts'),
						),

						array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .team .desc_wrapper .links a|hover:background-color',
							'type' => 'color',
							'class' => 'main-color mfn-toggled',
							'title' => __('Background', 'mfn-opts'),
						),

						array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .team .desc_wrapper .links a|hover:border-color',
							'condition' => array( 'id' => 'border_style_ot_icon', 'opt' => 'isnt', 'val' => 'none' ),
							'type' => 'color',
							'class' => 'mfn-toggled',
							'title' => __('Border color', 'mfn-opts'),
						),

						array(
							'type' => 'html',
							'html' => '</div></div>',
						),

						array(
							'class' => 'toggled_header',
   						'title' => __('Divider', 'mfn-opts'),
   					),

   					array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .team .desc_wrapper hr:background-color',
							'type' => 'color',
							'class' => 'mfn-toggled',
							'title' => __('Color', 'mfn-opts'),
						),

						array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .team .desc_wrapper hr:width',
							'type' => 'text',
							'default_unit' => 'px',
							'class' => 'mfn-toggled',
							'title' => __('Width', 'mfn-opts'),
						),

   					array(
		  				'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .team .desc_wrapper hr:margin',
		  				'type' => 'dimensions',
		  				'version' => 'separated-fields',
		  				'title' => __('Margin', 'mfn-opts'),
							'responsive' => 'desktop',
							'class' => 'mfn_field_desktop mfn-toggled',
							'css_attr' => 'margin',
		  			),

		  			array(
		  				'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .team .desc_wrapper hr:margin_tablet',
		  				'type' => 'dimensions',
		  				'version' => 'separated-fields',
		  				'title' => __('Margin', 'mfn-opts'),
							'responsive' => 'tablet',
							'class' => 'mfn_field_tablet mfn-toggled',
							'css_attr' => 'margin',
		  			),

		  			array(
		  				'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .team .desc_wrapper hr:margin_mobile',
		  				'type' => 'dimensions',
		  				'version' => 'separated-fields',
		  				'title' => __('Margin', 'mfn-opts'),
							'responsive' => 'mobile',
							'class' => 'mfn_field_mobile mfn-toggled',
							'css_attr' => 'margin',
		  			),

						array(
							'type' => 'html',
							'html' => '</div>',
						),

   				),
   			),

   			// Our team list --------------------------------------------------

   			'our_team_list' => array(
   				'type' => 'our_team_list',
   				'title' => __('Our Team List', 'mfn-opts'),
   				'size' => '1/1',
   				'tablet_size' => '1/1',
   				'mobile_size' => '1/1',
   				'tablet_resized' => '0',
   				'cat' => 'elements',
   				'fields' => array(

   					array(
							'type' => 'html',
							'html' => $this->itemtabs,
						),

   					array(
							'type' => 'html',
							'html' => '<div class="modalbox-card modalbox-re_render modalbox-card-content-mfnuidhere active">',
						),

   					array(
   						'id' => 'image',
   						'type' => 'upload',
   						'title' => __('Photo', 'mfn-opts'),
   						'desc' => __('Recommended minimum image width <b>768px</b>', 'mfn-opts'),
							'std' => $this->get_placeholder(),
							'preview' => 'image',
   					),

   					array(
   						'id' => 'title',
   						'type' => 'text',
   						'edit_tag' => '.desc_wrapper | h4',
   						'edit_position' => 'prepend',
   						'title' => __('Title', 'mfn-opts'),
							'std' => __('This is the title', 'mfn-opts'),
							'preview' => 'title',
   					),

   					array(
   						'id' => 'subtitle',
   						'edit_tag' => '.desc_wrapper | p.subtitle',
   						'edit_position' => 'append',
   						'type' => 'text',
   						'title' => __('Subtitle', 'mfn-opts'),
							'std' => __('This is the subtitle', 'mfn-opts'),
							'preview' => 'subtitle',
   					),

   					// description

   					array(
   						'title' => __('Description', 'mfn-opts'),
   					),

   					array(
   						'id' => 'phone',
   						'type' => 'text',
   						'title' => __('Phone', 'mfn-opts'),
   					),

   					array(
   						'id' => 'content',
   						'type' => 'textarea',
   						'edit_tag' => '.desc_wrapper | div.desc',
   						'edit_position' => 'append',
   						'title' => __('Content', 'mfn-opts'),
   						'desc' => __('Some shortcodes and HTML tags allowed', 'mfn-opts'),
							'preview' => 'content',
							'class' => 'form-content-full-width',
   					),

   					array(
   						'id' => 'blockquote',
   						'type' => 'textarea',
   						'title' => __('Blockquote', 'mfn-opts'),
							'class' => 'form-content-full-width',
   					),

   					array(
   						'id' => 'email',
   						'type' => 'text',
   						'title' => __('Email', 'mfn-opts'),
   					),

   					// social

   					array(
   						'title' => __('Social', 'mfn-opts'),
   					),

   					array(
   						'id' => 'facebook',
   						'type' => 'text',
   						'title' => __('Facebook', 'mfn-opts'),
   					),

   					array(
   						'id' => 'twitter',
   						'type' => 'text',
   						'title' => __('Twitter', 'mfn-opts'),
   					),

   					array(
   						'id' => 'linkedin',
   						'type' => 'text',
   						'title' => __('LinkedIn', 'mfn-opts'),
   					),

   					array(
   						'id' => 'vcard',
   						'type' => 'text',
   						'title' => __('vCard', 'mfn-opts'),
   					),

   					// link

   					array(
   						'title' => __('Link', 'mfn-opts'),
   					),

   					array(
   						'id' => 'link',
   						'type' => 'text',
   						'title' => __('Link', 'mfn-opts'),
   					),

   					array(
   						'id' => 'target',
   						'type' => 'select',
   						'title' => __('Target', 'mfn-opts'),
   						'options' => array(
   							0 => __('Default | _self', 'mfn-opts'),
   							1 => __('New tab or window | _blank', 'mfn-opts'),
   							'lightbox' => __('Lightbox (image or embed video)', 'mfn-opts'),
   						),
   					),

						// deprecated

						array(
							'class' => 'mfn-deprecated',
							'title' => __('Deprecated', 'mfn-opts'),
						),

						array(
							'id' => 'class',
							'type' => 'pills',
							'title' => __('Element classes', 'mfn-opts'),
							'class' => 'mfn-deprecated',
						),

   					array(
							'type' => 'html',
							'html' => '</div><div class="modalbox-card modalbox-card-style modalbox-re_render modalbox-card-style-mfnuidhere">',
						),

						array(
							'class' => 'toggled_header',
   						'title' => __('Image', 'mfn-opts'),
   					),

   					array(
		  				'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .team .image_frame:margin',
		  				'type' => 'dimensions',
		  				'version' => 'separated-fields',
		  				'title' => __('Margin', 'mfn-opts'),
							'responsive' => 'desktop',
							'class' => 'mfn_field_desktop mfn-toggled',
							'css_attr' => 'margin',
		  			),

		  			array(
		  				'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .team .image_frame:margin_tablet',
		  				'type' => 'dimensions',
		  				'version' => 'separated-fields',
		  				'title' => __('Margin', 'mfn-opts'),
							'responsive' => 'tablet',
							'class' => 'mfn_field_tablet mfn-toggled',
							'css_attr' => 'margin',
		  			),

		  			array(
		  				'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .team .image_frame:margin_mobile',
		  				'type' => 'dimensions',
		  				'version' => 'separated-fields',
		  				'title' => __('Margin', 'mfn-opts'),
							'responsive' => 'mobile',
							'class' => 'mfn_field_mobile mfn-toggled',
							'css_attr' => 'margin',
		  			),

		  			array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .team .image_frame:border-style',
							'attr_id' => 'border_style_team_list_img',
							'type' => 'select',
							'class' => 'mfn-toggled',
							'title' => __('Border style', 'mfn-opts'),
							'options' => [
								'none' => __('None', 'mfn-opts'),
								'solid' => __('Solid', 'mfn-opts'),
								'dashed' => __('Dashed', 'mfn-opts'),
								'dotted' => __('Dotted', 'mfn-opts'),
								'double' => __('Double', 'mfn-opts'),
							],
						),

						array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .team .image_frame:border-color',
							'condition' => array( 'id' => 'border_style_team_list_img', 'opt' => 'isnt', 'val' => 'none' ),
							'type' => 'color',
							'class' => 'mfn-toggled',
							'title' => __('Border color', 'mfn-opts'),
						),

						array(
		  				'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .team .image_frame:border-width',
		  				'condition' => array( 'id' => 'border_style_team_list_img', 'opt' => 'isnt', 'val' => 'none' ),
		  				'type' => 'dimensions',
		  				'title' => __('Border width', 'mfn-opts'),
							'responsive' => 'desktop',
							'class' => 'mfn_field_desktop mfn-toggled',
							'css_attr' => 'border-width',
		  			),

		  			array(
		  				'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .team .image_frame:border-width_tablet',
		  				'condition' => array( 'id' => 'border_style_team_list_img', 'opt' => 'isnt', 'val' => 'none' ),
		  				'type' => 'dimensions',
		  				'title' => __('Border width', 'mfn-opts'),
							'responsive' => 'tablet',
							'class' => 'mfn_field_tablet mfn-toggled',
							'css_attr' => 'border-width',
		  			),

		  			array(
		  				'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .team .image_frame:border-width_mobile',
		  				'condition' => array( 'id' => 'border_style_team_list_img', 'opt' => 'isnt', 'val' => 'none' ),
		  				'type' => 'dimensions',
		  				'title' => __('Border width', 'mfn-opts'),
							'responsive' => 'mobile',
							'class' => 'mfn_field_mobile mfn-toggled',
							'css_attr' => 'border-width',
		  			),

						array(
		  				'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .team .image_frame:border-radius',
		  				'type' => 'dimensions',
		  				'title' => __('Border radius', 'mfn-opts'),
							'responsive' => 'desktop',
							'class' => 'mfn_field_desktop mfn-toggled',
							'css_attr' => 'border-radius',
		  			),

		  			array(
		  				'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .team .image_frame:border-radius_tablet',
		  				'type' => 'dimensions',
		  				'title' => __('Border radius', 'mfn-opts'),
							'responsive' => 'tablet',
							'class' => 'mfn_field_tablet mfn-toggled',
							'css_attr' => 'border-radius',
		  			),

		  			array(
		  				'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .team .image_frame:border-radius_mobile',
		  				'type' => 'dimensions',
		  				'title' => __('Border radius', 'mfn-opts'),
							'responsive' => 'mobile',
							'class' => 'mfn_field_mobile mfn-toggled',
							'css_attr' => 'border-radius',
		  			),

		  			array(
							'class' => 'toggled_header',
   						'title' => __('Right content', 'mfn-opts'),
   					),

   					array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .team .bq_wrapper:background-color',
							'type' => 'color',
							'class' => 'main-color mfn-toggled',
							'title' => __('Background', 'mfn-opts'),
						),

						array(
		  				'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .team .bq_wrapper:padding',
		  				'type' => 'dimensions',
		  				'version' => 'separated-fields',
		  				'title' => __('Padding', 'mfn-opts'),
							'responsive' => 'desktop',
							'class' => 'mfn_field_desktop mfn-toggled',
							'css_attr' => 'padding',
		  			),

		  			array(
		  				'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .team .bq_wrapper:padding_tablet',
		  				'type' => 'dimensions',
		  				'version' => 'separated-fields',
		  				'title' => __('Padding', 'mfn-opts'),
							'responsive' => 'tablet',
							'class' => 'mfn_field_tablet mfn-toggled',
							'css_attr' => 'padding',
		  			),

		  			array(
		  				'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .team .bq_wrapper:padding_mobile',
		  				'type' => 'dimensions',
		  				'version' => 'separated-fields',
		  				'title' => __('Padding', 'mfn-opts'),
							'responsive' => 'mobile',
							'class' => 'mfn_field_mobile mfn-toggled',
							'css_attr' => 'padding',
		  			),

		  			array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .team .bq_wrapper:border-style',
							'attr_id' => 'border_style_team_list_desc',
							'type' => 'select',
							'class' => 'mfn-toggled',
							'title' => __('Border style', 'mfn-opts'),
							'options' => [
								'none' => __('None', 'mfn-opts'),
								'solid' => __('Solid', 'mfn-opts'),
								'dashed' => __('Dashed', 'mfn-opts'),
								'dotted' => __('Dotted', 'mfn-opts'),
								'double' => __('Double', 'mfn-opts'),
							],
						),

						array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .team .bq_wrapper:border-color',
							'condition' => array( 'id' => 'border_style_team_list_desc', 'opt' => 'isnt', 'val' => 'none' ),
							'type' => 'color',
							'class' => 'mfn-toggled',
							'title' => __('Border color', 'mfn-opts'),
						),

						array(
		  				'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .team .bq_wrapper:border-width',
		  				'condition' => array( 'id' => 'border_style_team_list_desc', 'opt' => 'isnt', 'val' => 'none' ),
		  				'type' => 'dimensions',
		  				'title' => __('Border width', 'mfn-opts'),
							'responsive' => 'desktop',
							'class' => 'mfn_field_desktop mfn-toggled',
							'css_attr' => 'border-width',
		  			),

		  			array(
		  				'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .team .bq_wrapper:border-width_tablet',
		  				'condition' => array( 'id' => 'border_style_team_list_desc', 'opt' => 'isnt', 'val' => 'none' ),
		  				'type' => 'dimensions',
		  				'title' => __('Border width', 'mfn-opts'),
							'responsive' => 'tablet',
							'class' => 'mfn_field_tablet mfn-toggled',
							'css_attr' => 'border-width',
		  			),

		  			array(
		  				'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .team .bq_wrapper:border-width_mobile',
		  				'condition' => array( 'id' => 'border_style_team_list_desc', 'opt' => 'isnt', 'val' => 'none' ),
		  				'type' => 'dimensions',
		  				'title' => __('Border width', 'mfn-opts'),
							'responsive' => 'mobile',
							'class' => 'mfn_field_mobile mfn-toggled',
							'css_attr' => 'border-width',
		  			),

						array(
		  				'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .team .bq_wrapper:border-radius',
		  				'type' => 'dimensions',
		  				'title' => __('Border radius', 'mfn-opts'),
							'responsive' => 'desktop',
							'class' => 'mfn_field_desktop mfn-toggled',
							'css_attr' => 'border-radius',
		  			),

		  			array(
		  				'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .team .bq_wrapper:border-radius_tablet',
		  				'type' => 'dimensions',
		  				'title' => __('Border radius', 'mfn-opts'),
							'responsive' => 'tablet',
							'class' => 'mfn_field_tablet mfn-toggled',
							'css_attr' => 'border-radius',
		  			),

		  			array(
		  				'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .team .bq_wrapper:border-radius_mobile',
		  				'type' => 'dimensions',
		  				'title' => __('Border radius', 'mfn-opts'),
							'responsive' => 'mobile',
							'class' => 'mfn_field_mobile mfn-toggled',
							'css_attr' => 'border-radius',
		  			),

		  			array(
							'class' => 'toggled_header',
   						'title' => __('Title', 'mfn-opts'),
   					),

						array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .team .desc_wrapper h4:color',
							'type' => 'color',
							'class' => 'main-color mfn-toggled',
							'title' => __('Color', 'mfn-opts'),
						),

						array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .team .desc_wrapper h4:typography',
							'type' => 'typography_vb',
							'label_after' => '<a href="#" title="Edit" class="mfn-option-btn mfn-option-blank btn-medium mfn-vb-label-button"><span class="mfn-icon mfn-icon-edit"></span></a>',
							'class' => 'mfn-toggled toggle_fields',
							'title' => __('Typography', 'mfn-opts'),
						),

						array(
							'class' => 'toggled_header',
   						'title' => __('Subtitle', 'mfn-opts'),
   					),

						array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .team .desc_wrapper .subtitle:color',
							'type' => 'color',
							'class' => 'main-color mfn-toggled',
							'title' => __('Color', 'mfn-opts'),
						),

						array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .team .desc_wrapper .subtitle:typography',
							'type' => 'typography_vb',
							'label_after' => '<a href="#" title="Edit" class="mfn-option-btn mfn-option-blank btn-medium mfn-vb-label-button"><span class="mfn-icon mfn-icon-edit"></span></a>',
							'class' => 'mfn-toggled toggle_fields',
							'title' => __('Typography', 'mfn-opts'),
						),

						array(
							'class' => 'toggled_header',
   						'title' => __('Phone', 'mfn-opts'),
   					),

						array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .team .desc_wrapper .phone a:color',
							'type' => 'color',
							'class' => 'main-color mfn-toggled',
							'title' => __('Color', 'mfn-opts'),
						),

						array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .team .desc_wrapper .phone i:color',
							'type' => 'color',
							'class' => 'main-color mfn-toggled',
							'title' => __('Icon color', 'mfn-opts'),
						),

						array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .team .desc_wrapper .phone:typography',
							'type' => 'typography_vb',
							'label_after' => '<a href="#" title="Edit" class="mfn-option-btn mfn-option-blank btn-medium mfn-vb-label-button"><span class="mfn-icon mfn-icon-edit"></span></a>',
							'class' => 'mfn-toggled toggle_fields',
							'title' => __('Typography', 'mfn-opts'),
						),

						array(
							'class' => 'toggled_header',
   						'title' => __('Content', 'mfn-opts'),
   					),

						array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .team .desc_wrapper .desc:color',
							'type' => 'color',
							'class' => 'main-color mfn-toggled',
							'title' => __('Color', 'mfn-opts'),
						),

						array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .team .desc_wrapper .desc:typography',
							'type' => 'typography_vb',
							'label_after' => '<a href="#" title="Edit" class="mfn-option-btn mfn-option-blank btn-medium mfn-vb-label-button"><span class="mfn-icon mfn-icon-edit"></span></a>',
							'class' => 'mfn-toggled toggle_fields',
							'title' => __('Typography', 'mfn-opts'),
						),

						array(
							'class' => 'toggled_header',
   						'title' => __('Blockquote', 'mfn-opts'),
   					),

						array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .team blockquote:color',
							'type' => 'color',
							'class' => 'main-color mfn-toggled',
							'title' => __('Color', 'mfn-opts'),
						),

						array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .team blockquote:typography',
							'type' => 'typography_vb',
							'label_after' => '<a href="#" title="Edit" class="mfn-option-btn mfn-option-blank btn-medium mfn-vb-label-button"><span class="mfn-icon mfn-icon-edit"></span></a>',
							'class' => 'mfn-toggled toggle_fields',
							'title' => __('Typography', 'mfn-opts'),
						),

						array(
							'class' => 'toggled_header',
							'themeoptions' => 'style:',
   						'title' => __('Blockquote icon', 'mfn-opts'),
   					),

						array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .team .mfn-blockquote-icon:color',
							'type' => 'color',
							'themeoptions' => 'style:',
							'class' => 'mfn-toggled',
							'title' => __('Color', 'mfn-opts'),
						),

						array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .team .mfn-blockquote-icon:font-size',
							'type' => 'sliderbar',
							'themeoptions' => 'style:',
							'responsive' => 'desktop',
							'class' => 'mfn_field_desktop mfn-toggled',
							'title' => __('Size', 'mfn-opts'),
							'units' => array(
								'px' 	=> array('min' => 1, 		'max' => 100, 'step' => 1),
								'em' 	=> array('min' => 0.1, 	'max' => 10, 	'step' => 0.1),
								'rem' => array('min' => 0.1, 	'max' => 10, 	'step' => 0.1),
								'vw' 	=> array('min' => 1, 		'max' => 100, 'step' => 1),
							)
						),

						array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .team .mfn-blockquote-icon:font-size_tablet',
							'type' => 'sliderbar',
							'themeoptions' => 'style:',
							'responsive' => 'tablet',
							'class' => 'mfn_field_tablet mfn-toggled',
							'title' => __('Size', 'mfn-opts'),
							'units' => array(
								'px' 	=> array('min' => 1, 		'max' => 100, 'step' => 1),
								'em' 	=> array('min' => 0.1, 	'max' => 10, 	'step' => 0.1),
								'rem' => array('min' => 0.1, 	'max' => 10, 	'step' => 0.1),
								'vw' 	=> array('min' => 1, 		'max' => 100, 'step' => 1),
							)
						),

						array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .team .mfn-blockquote-icon:font-size_mobile',
							'type' => 'sliderbar',
							'themeoptions' => 'style:',
							'responsive' => 'mobile',
							'class' => 'mfn_field_mobile mfn-toggled',
							'title' => __('Size', 'mfn-opts'),
							'units' => array(
								'px' 	=> array('min' => 1, 		'max' => 100, 'step' => 1),
								'em' 	=> array('min' => 0.1, 	'max' => 10, 	'step' => 0.1),
								'rem' => array('min' => 0.1, 	'max' => 10, 	'step' => 0.1),
								'vw' 	=> array('min' => 1, 		'max' => 100, 'step' => 1),
							)
						),

						array(
							'class' => 'toggled_header',
   						'title' => __('Blockquote lines', 'mfn-opts'),
   					),

						array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .team blockquote:text-decoration-color',
							'type' => 'color',
							'themeoptions' => 'style:',
							'class' => 'mfn-toggled',
							'title' => __('Color', 'mfn-opts'),
						),

						array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .team blockquote:text-underline-offset',
							'type' => 'text',
							'themeoptions' => 'style:',
							'class' => 'mfn-toggled',
							'default_unit' => 'px',
							'title' => __('Offset', 'mfn-opts'),
						),

						array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .team blockquote:text-decoration-thickness',
							'type' => 'text',
							'themeoptions' => 'style:',
							'class' => 'mfn-toggled',
							'default_unit' => 'px',
							'title' => __('Thickness', 'mfn-opts'),
						),

						array(
							'class' => 'toggled_header',
   						'title' => __('Icons', 'mfn-opts'),
   					),

   					array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .team .links a:border-style',
							'attr_id' => 'border_style_team_list_icon',
							'type' => 'select',
							'class' => 'mfn-toggled',
							'title' => __('Border style', 'mfn-opts'),
							'options' => [
								'none' => __('None', 'mfn-opts'),
								'solid' => __('Solid', 'mfn-opts'),
								'dashed' => __('Dashed', 'mfn-opts'),
								'dotted' => __('Dotted', 'mfn-opts'),
								'double' => __('Double', 'mfn-opts'),
							],
						),

						array(
		  				'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .team .links a:border-width',
		  				'condition' => array( 'id' => 'border_style_team_list_icon', 'opt' => 'isnt', 'val' => 'none' ),
		  				'type' => 'dimensions',
		  				'title' => __('Border width', 'mfn-opts'),
							'responsive' => 'desktop',
							'class' => 'mfn_field_desktop mfn-toggled',
							'css_attr' => 'border-width',
		  			),

		  			array(
		  				'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .team .links a:border-width_tablet',
		  				'condition' => array( 'id' => 'border_style_team_list_icon', 'opt' => 'isnt', 'val' => 'none' ),
		  				'type' => 'dimensions',
		  				'title' => __('Border width', 'mfn-opts'),
							'responsive' => 'tablet',
							'class' => 'mfn_field_tablet mfn-toggled',
							'css_attr' => 'border-width',
		  			),

		  			array(
		  				'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .team .links a:border-width_mobile',
		  				'condition' => array( 'id' => 'border_style_team_list_icon', 'opt' => 'isnt', 'val' => 'none' ),
		  				'type' => 'dimensions',
		  				'title' => __('Border width', 'mfn-opts'),
							'responsive' => 'mobile',
							'class' => 'mfn_field_mobile mfn-toggled',
							'css_attr' => 'border-width',
		  			),

						array(
		  				'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .team .links a:border-radius',
		  				'type' => 'dimensions',
		  				'title' => __('Border radius', 'mfn-opts'),
							'responsive' => 'desktop',
							'class' => 'mfn_field_desktop mfn-toggled',
							'css_attr' => 'border-radius',
		  			),

		  			array(
		  				'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .team .links a:border-radius_tablet',
		  				'type' => 'dimensions',
		  				'title' => __('Border radius', 'mfn-opts'),
							'responsive' => 'tablet',
							'class' => 'mfn_field_tablet mfn-toggled',
							'css_attr' => 'border-radius',
		  			),

		  			array(
		  				'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .team .links a:border-radius_mobile',
		  				'type' => 'dimensions',
		  				'title' => __('Border radius', 'mfn-opts'),
							'responsive' => 'mobile',
							'class' => 'mfn_field_mobile mfn-toggled',
							'css_attr' => 'border-radius',
		  			),

		  			array(
							'type' => 'html',
							'html' => '<div class="mfn-form-row mfn-sidebar-fields-tabs mfn-toggled mfn-vb-formrow mfn-vb-mfnuidhere"><ul class="mfn-sft-nav"><li class="active"><a href="#normal" data-tab="normal">Normal</a></li><li><a href="#hover" data-tab="hover">Hover</a></li></ul><div class="mfn-sft mfn-sft-normal">',
						),

						array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .team .links a span i:color',
							'type' => 'color',
							'class' => 'main-color mfn-toggled',
							'title' => __('Color', 'mfn-opts'),
						),

						array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .team .links a:background-color',
							'type' => 'color',
							'class' => 'main-color mfn-toggled',
							'title' => __('Background', 'mfn-opts'),
						),

						array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .team .links a:border-color',
							'condition' => array( 'id' => 'border_style_team_list_icon', 'opt' => 'isnt', 'val' => 'none' ),
							'type' => 'color',
							'class' => 'mfn-toggled',
							'title' => __('Border color', 'mfn-opts'),
						),

						array(
							'type' => 'html',
							'html' => '</div><div class="mfn-sft mfn-sft-hover">',
						),

						array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .team .links a|hover span.b i:color',
							'type' => 'color',
							'class' => 'main-color mfn-toggled',
							'title' => __('Color', 'mfn-opts'),
						),

						array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .team .links a|hover:background-color',
							'type' => 'color',
							'class' => 'main-color mfn-toggled',
							'title' => __('Background', 'mfn-opts'),
						),

						array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .team .links a|hover:border-color',
							'condition' => array( 'id' => 'border_style_team_list_icon', 'opt' => 'isnt', 'val' => 'none' ),
							'type' => 'color',
							'class' => 'mfn-toggled',
							'title' => __('Border color', 'mfn-opts'),
						),

						array(
							'type' => 'html',
							'html' => '</div></div>',
						),

						array(
							'class' => 'toggled_header',
   						'title' => __('Divider', 'mfn-opts'),
   					),

   					array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .team hr:background-color',
							'type' => 'color',
							'class' => 'mfn-toggled',
							'title' => __('Color', 'mfn-opts'),
						),

						array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .team hr:width',
							'type' => 'text',
							'default_unit' => 'px',
							'class' => 'mfn-toggled',
							'title' => __('Width', 'mfn-opts'),
						),

   					array(
		  				'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .team hr:margin',
		  				'type' => 'dimensions',
		  				'version' => 'separated-fields',
		  				'title' => __('Margin', 'mfn-opts'),
							'responsive' => 'desktop',
							'class' => 'mfn_field_desktop mfn-toggled',
							'css_attr' => 'margin',
		  			),

		  			array(
		  				'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .team hr:margin_tablet',
		  				'type' => 'dimensions',
		  				'version' => 'separated-fields',
		  				'title' => __('Margin', 'mfn-opts'),
							'responsive' => 'tablet',
							'class' => 'mfn_field_tablet mfn-toggled',
							'css_attr' => 'margin',
		  			),

		  			array(
		  				'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .team hr:margin_mobile',
		  				'type' => 'dimensions',
		  				'version' => 'separated-fields',
		  				'title' => __('Margin', 'mfn-opts'),
							'responsive' => 'mobile',
							'class' => 'mfn_field_mobile mfn-toggled',
							'css_attr' => 'margin',
		  			),

						array(
							'type' => 'html',
							'html' => '</div>',
						),

   				),
   			),

   			// Photo Box ------------------------------------------------------

   			'photo_box' => array(
   				'type' => 'photo_box',
   				'title' => __('Photo Box', 'mfn-opts'),
   				'size' => '1/4',
   				'tablet_size' => '1/4',
   				'mobile_size' => '1/4',
   				'tablet_resized' => '0',
   				'cat' => 'boxes',
   				'fields' => array(

   					array(
							'type' => 'html',
							'html' => $this->itemtabs,
						),

   					array(
							'type' => 'html',
							'html' => '<div class="modalbox-card modalbox-re_render modalbox-card-content-mfnuidhere active">',
						),

   					array(
   						'id' => 'title',
   						'type' => 'text',
   						'edit_tag' => '.photo_box | h4',
   						'edit_position' => 'prepend',
   						'title' => __('Title', 'mfn-opts'),
   						'desc' => __('Allowed HTML tags: span, strong, b, em, i, u', 'mfn-opts'),
							'std' => __('This is the title', 'mfn-opts'),
							'preview' => 'title',
   					),

   					array(
   						'id' => 'image',
   						'type' => 'upload',
   						'title' => __('Image', 'mfn-opts'),
   						'desc' => __('Recommended image width <b>768px - 1920px</b> depending on size of the item', 'mfn-opts'),
							'std' => $this->get_placeholder(),
							'preview' => 'image',
   					),

   					array(
   						'id' => 'content',
   						'type' => 'textarea',
   						'edit_tag' => '.photo_box | div.desc',
   						'edit_position' => 'append',
   						'title' => __('Content', 'mfn-opts'),
   						'desc' => __('Some shortcodes and HTML tags allowed', 'mfn-opts'),
							'std' => 'Lorem ipsum dolor sit amet, consectetur adipiscing elit. Ut elit tellus, luctus nec ullamcorper mattis, pulvinar dapibus leo.',
							'preview' => 'content',
							'class' => 'form-content-full-width',
   					),

   					// link

   					array(
   						'title' => __('Link', 'mfn-opts'),
   					),

   					array(
   						'id' => 'link',
   						'type' => 'text',
   						'title' => __('Link', 'mfn-opts'),
   					),

   					array(
   						'id' => 'target',
   						'type' => 'select',
   						'title' => __('Target', 'mfn-opts'),
   						'options' => array(
   							0 => __('Default | _self', 'mfn-opts'),
   							1 => __('New tab or window | _blank', 'mfn-opts'),
   							'lightbox' => __('Lightbox (image or embed video)', 'mfn-opts'),
   						),
   					),

   					// advanced

   					array(
   						'title' => __('Advanced', 'mfn-opts'),
   					),

   					array(
   						'id' => 'greyscale',
   						'type' => 'switch',
   						'title' => __('Grayscale', 'mfn-opts'),
   						'desc' => __('Works only for images with link', 'mfn-opts'),
   						'options' => array(
   							0 => __('Disable', 'mfn-opts'),
   							1 => __('Enable', 'mfn-opts'),
   						),
							'std' => 0,
   					),

						// deprecated

   					array(
   						'class' => 'mfn-deprecated',
   						'title' => __('Deprecated', 'mfn-opts'),
   					),

   					array(
   						'id' => 'align',
   						'class' => 'mfn-deprecated',
   						'type' => 'switch',
   						'title' => __('Text align', 'mfn-opts'),
   						'options' => array(
   							'left' => __('Left', 'mfn-opts'),
								'' => __('Center', 'mfn-opts'),
   							'right' => __('Right', 'mfn-opts'),
   						),
							'std' => '',
   					),

						array(
							'id' => 'class',
							'type' => 'pills',
							'title' => __('Element classes', 'mfn-opts'),
							'class' => 'mfn-deprecated',
						),

   					array(
							'type' => 'html',
							'html' => '</div><div class="modalbox-card modalbox-card-style modalbox-re_render modalbox-card-style-mfnuidhere">',
						),

						array(
		  				'class' => 'toggled_header',
   						'title' => __('Container', 'mfn-opts'),
   					),

						array(
   						'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .photo_box:text-align',
							'responsive' => 'desktop',
   						'type' => 'switch',
   						'class' => 'mfn_field_desktop mfn-toggled',
   						'title' => __('Text align', 'mfn-opts'),
   						'options' => array(
   							'' => __('Default', 'mfn-opts'),
   							'left' => __('Left', 'mfn-opts'),
								'center' => __('Center', 'mfn-opts'),
   							'right' => __('Right', 'mfn-opts'),
   							'justify' => __('Justify', 'mfn-opts'),
   						),
							'preview' => 'align',
   					),
   					array(
   						'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .photo_box:text-align_tablet',
							'responsive' => 'tablet',
   						'type' => 'switch',
   						'class' => 'mfn_field_tablet mfn-toggled',
   						'title' => __('Text align', 'mfn-opts'),
   						'options' => array(
   							'' => __('Default', 'mfn-opts'),
   							'left' => __('Left', 'mfn-opts'),
								'center' => __('Center', 'mfn-opts'),
   							'right' => __('Right', 'mfn-opts'),
   							'justify' => __('Justify', 'mfn-opts'),
   						),
							'preview' => 'align',
   					),
   					array(
   						'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .photo_box:text-align_mobile',
							'responsive' => 'mobile',
   						'type' => 'switch',
   						'class' => 'mfn_field_mobile mfn-toggled',
   						'title' => __('Text align', 'mfn-opts'),
   						'options' => array(
   							'' => __('Default', 'mfn-opts'),
   							'left' => __('Left', 'mfn-opts'),
								'center' => __('Center', 'mfn-opts'),
   							'right' => __('Right', 'mfn-opts'),
   							'justify' => __('Justify', 'mfn-opts'),
   						),
							'preview' => 'align',
   					),

   					array(
							'class' => 'toggled_header',
   						'title' => __('Title', 'mfn-opts'),
   					),

						array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .photo_box h4:color',
							'type' => 'color',
							'class' => 'main-color mfn-toggled',
							'title' => __('Color', 'mfn-opts'),
						),

						array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .photo_box h4:typography',
							'type' => 'typography_vb',
							'label_after' => '<a href="#" title="Edit" class="mfn-option-btn mfn-option-blank btn-medium mfn-vb-label-button"><span class="mfn-icon mfn-icon-edit"></span></a>',
							'class' => 'mfn-toggled toggle_fields',
							'title' => __('Typography', 'mfn-opts'),
						),

						array(
							'class' => 'toggled_header',
   						'title' => __('Image', 'mfn-opts'),
   					),

   					array(
		  				'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .photo_box .image_frame:margin',
		  				'type' => 'dimensions',
		  				'version' => 'separated-fields',
		  				'title' => __('Margin', 'mfn-opts'),
							'responsive' => 'desktop',
							'class' => 'mfn_field_desktop mfn-toggled',
							'css_attr' => 'margin',
		  			),

		  			array(
		  				'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .photo_box .image_frame:margin_tablet',
		  				'type' => 'dimensions',
		  				'version' => 'separated-fields',
		  				'title' => __('Margin', 'mfn-opts'),
							'responsive' => 'tablet',
							'class' => 'mfn_field_tablet mfn-toggled',
							'css_attr' => 'margin',
		  			),

		  			array(
		  				'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .photo_box .image_frame:margin_mobile',
		  				'type' => 'dimensions',
		  				'version' => 'separated-fields',
		  				'title' => __('Margin', 'mfn-opts'),
							'responsive' => 'mobile',
							'class' => 'mfn_field_mobile mfn-toggled',
							'css_attr' => 'margin',
		  			),

		  			array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .photo_box .image_frame:border-style',
							'attr_id' => 'border_style_pb_img',
							'type' => 'select',
							'class' => 'mfn-toggled',
							'title' => __('Border style', 'mfn-opts'),
							'options' => [
								'none' => __('None', 'mfn-opts'),
								'solid' => __('Solid', 'mfn-opts'),
								'dashed' => __('Dashed', 'mfn-opts'),
								'dotted' => __('Dotted', 'mfn-opts'),
								'double' => __('Double', 'mfn-opts'),
							],
						),

						array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .photo_box .image_frame:border-color',
							'condition' => array( 'id' => 'border_style_pb_img', 'opt' => 'isnt', 'val' => 'none' ),
							'type' => 'color',
							'class' => 'mfn-toggled',
							'title' => __('Border color', 'mfn-opts'),
						),

						array(
		  				'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .photo_box .image_frame:border-width',
		  				'condition' => array( 'id' => 'border_style_pb_img', 'opt' => 'isnt', 'val' => 'none' ),
		  				'type' => 'dimensions',
		  				'title' => __('Border width', 'mfn-opts'),
							'responsive' => 'desktop',
							'class' => 'mfn_field_desktop mfn-toggled',
							'css_attr' => 'border-width',
		  			),

		  			array(
		  				'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .photo_box .image_frame:border-width_tablet',
		  				'condition' => array( 'id' => 'border_style_pb_img', 'opt' => 'isnt', 'val' => 'none' ),
		  				'type' => 'dimensions',
		  				'title' => __('Border width', 'mfn-opts'),
							'responsive' => 'tablet',
							'class' => 'mfn_field_tablet mfn-toggled',
							'css_attr' => 'border-width',
		  			),

		  			array(
		  				'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .photo_box .image_frame:border-width_mobile',
		  				'condition' => array( 'id' => 'border_style_pb_img', 'opt' => 'isnt', 'val' => 'none' ),
		  				'type' => 'dimensions',
		  				'title' => __('Border width', 'mfn-opts'),
							'responsive' => 'mobile',
							'class' => 'mfn_field_mobile mfn-toggled',
							'css_attr' => 'border-width',
		  			),

						array(
		  				'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .photo_box .image_frame:border-radius',
		  				'type' => 'dimensions',
		  				'title' => __('Border radius', 'mfn-opts'),
							'responsive' => 'desktop',
							'class' => 'mfn_field_desktop mfn-toggled',
							'css_attr' => 'border-radius',
		  			),

		  			array(
		  				'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .photo_box .image_frame:border-radius_tablet',
		  				'type' => 'dimensions',
		  				'title' => __('Border radius', 'mfn-opts'),
							'responsive' => 'tablet',
							'class' => 'mfn_field_tablet mfn-toggled',
							'css_attr' => 'border-radius',
		  			),

		  			array(
		  				'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .photo_box .image_frame:border-radius_mobile',
		  				'type' => 'dimensions',
		  				'title' => __('Border radius', 'mfn-opts'),
							'responsive' => 'mobile',
							'class' => 'mfn_field_mobile mfn-toggled',
							'css_attr' => 'border-radius',
		  			),

						array(
							'class' => 'toggled_header',
   						'title' => __('Content', 'mfn-opts'),
   					),

						array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .photo_box .desc:color',
							'type' => 'color',
							'class' => 'main-color mfn-toggled',
							'title' => __('Color', 'mfn-opts'),
						),

						array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .photo_box .desc:typography',
							'type' => 'typography_vb',
							'label_after' => '<a href="#" title="Edit" class="mfn-option-btn mfn-option-blank btn-medium mfn-vb-label-button"><span class="mfn-icon mfn-icon-edit"></span></a>',
							'class' => 'mfn-toggled toggle_fields',
							'title' => __('Typography', 'mfn-opts'),
						),

						array(
							'type' => 'html',
							'html' => '</div>',
						),

   				),
   			),

   			// Portfolio ------------------------------------------------------

   			'portfolio' => array(
   				'type' => 'portfolio',
   				'title' => __('Portfolio', 'mfn-opts'),
   				'size' => '1/1',
   				'tablet_size' => '1/1',
   				'mobile_size' => '1/1',
   				'tablet_resized' => '0',
   				'cat' => 'loops',
   				'fields' => array(

   					array(
							'type' => 'html',
							'html' => $this->itemtabs,
						),

   					array(
							'type' => 'html',
							'html' => '<div class="modalbox-card modalbox-re_render modalbox-card-content-mfnuidhere active">',
						),

   					array(
   						'id' => 'count',
   						're_render' => 'standard',
   						'type' => 'text',
   						'title' => __('Projects number', 'mfn-opts'),
   						'param' => 'number',
   						'after' => 'projects',
   						'class' => 'narrow',
   						'std' => 3,
							'preview' => 'number',
   					),

   					array(
   						'id' => 'style',
   						're_render' => 'standard',
   						'type' => 'select',
   						'title' => __('Style', 'mfn-opts'),
   						'options' => array(
   							'flat' => __('Flat', 'mfn-opts'),
   							'grid' => __('Grid', 'mfn-opts'),
   							'masonry' => __('Masonry blog style', 'mfn-opts'),
   							'masonry-hover' => __('Masonry hover description', 'mfn-opts'),
   							'masonry-minimal' => __('Masonry minimal', 'mfn-opts'),
   							'masonry-flat' => __('Masonry flat', 'mfn-opts'),
   							'list' => __('List', 'mfn-opts'),
   							'exposure' => __('Exposure', 'mfn-opts'),
   						),
   						'std' => 'grid',
							'preview' => 'style',
   					),

   					array(
   						'id' => 'columns',
   						're_render' => 'standard',
   						'type' => 'switch',
   						'title' => __('Columns', 'mfn-opts'),
   						'desc' => __('for styles: Flat, Grid, Masonry blog style, Masonry hover description', 'mfn-opts'),
   						'options' => array(
   							2	=> 2,
   							3	=> 3,
   							4	=> 4,
   							5	=> 5,
   							6	=> 6,
   						),
   						'std' => 3,
   					),

   					// options

   					array(
   						'title' => __('Options', 'mfn-opts'),
   					),

   					array(
   						'id' => 'category',
   						're_render' => 'standard',
   						'type' => 'select',
   						'title' => __('Category', 'mfn-opts'),
   						'options' => mfn_get_categories('portfolio-types'),
   						'wpml' => 'portfolio-types',
							'preview' => 'category',
   					),

   					array(
   						'id' => 'category_multi',
   						're_render' => 'standard',
   						'type' => 'text',
   						'title' => __('Multiple categories', 'mfn-opts'),
   						'desc' => __('Slugs should be separated with <b>coma</b> ( , )', 'mfn-opts'),
							'preview' => 'category-all',
   					),

   					array(
   						'id' => 'orderby',
   						'type' => 'switch',
   						're_render' => 'standard',
   						'title' => __('Order by', 'mfn-opts'),
   						'desc' => __('Do <b>not</b> use random order with pagination or load more', 'mfn-opts'),
   						'options' => array(
   							'date' => __('Date', 'mfn-opts'),
   							'menu_order' => __('Menu order', 'mfn-opts'),
   							'title' => __('Title', 'mfn-opts'),
   							'rand' => __('Random', 'mfn-opts'),
   						),
   						'std' => 'date'
   					),

   					array(
   						'id' => 'order',
   						're_render' => 'standard',
   						'type' => 'switch',
   						'title' => __('Order', 'mfn-opts'),
   						'options' => array(
   							'ASC' => __('Ascending', 'mfn-opts'),
   							'DESC' => __('Descending', 'mfn-opts'),
   						),
   						'std' => 'DESC'
   					),

   					// advanced

   					array(
   						'title' => __('Advanced', 'mfn-opts'),
   					),

   					array(
   						'id' => 'exclude_id',
   						're_render' => 'standard',
   						'type' => 'text',
   						'title' => __('Exclude posts', 'mfn-opts'),
   						'desc' => __('IDs should be separated with <b>coma</b> ( , )', 'mfn-opts'),
   					),

   					array(
   						'id' => 'related',
   						're_render' => 'standard',
   						'type' => 'switch',
   						'title' => __('Use as related projects', 'mfn-opts'),
   						'desc' => __('Exclude current project on single project page. This option will overwrite exclude posts option above.', 'mfn-opts'),
   						'options' => array(
   							0 => __('Disable', 'mfn-opts'),
   							1 => __('Enable', 'mfn-opts'),
   						),
							'std' => 0,
   					),

   					array(
   						'id' => 'filters',
   						're_render' => 'standard',
   						'type' => 'switch',
   						'title' => __('Filters', 'mfn-opts'),
   						'desc' => __('for category: all or multiple categories (only selected categories show in filters)', 'mfn-opts'),
   						'options' => array(
   							0 => __('Hide', 'mfn-opts'),
   							1 => __('Show', 'mfn-opts'),
   						),
							'std' => 0,
   					),

						// pagination

						array(
   						'title' => __('Pagination', 'mfn-opts'),
   					),

   					array(
   						'id' => 'pagination',
   						're_render' => 'standard',
   						'type' => 'switch',
   						'title' => __('Pagination', 'mfn-opts'),
   						'desc' => __('Does <b>not</b> work on WMPL homepage', 'mfn-opts'),
   						'options' => array(
   							0 => __('Hide', 'mfn-opts'),
   							1 => __('Show', 'mfn-opts'),
   						),
							'std' => 0,
   					),

   					array(
   						'id' => 'load_more',
   						're_render' => 'standard',
   						'type' => 'switch',
   						'title' => __('Load More button', 'mfn-opts'),
   						'desc' => __('Sliders will be replaced with featured images. Please use with pagination enabled.', 'mfn-opts'),
   						'options' => array(
   							0 => __('No', 'mfn-opts'),
   							1 => __('Yes', 'mfn-opts'),
   						),
							'std' => 0,
   					),

						// style

						array(
   						'title' => __('Style', 'mfn-opts'),
   					),

   					array(
   						'id' => 'greyscale',
   						'type' => 'switch',
   						'title' => __('Grayscale', 'mfn-opts'),
   						'options' => array(
   							0 => __('Disable', 'mfn-opts'),
   							1 => __('Enable', 'mfn-opts'),
   						),
							'std' => 0,
   					),

						// deprecated

						array(
							'class' => 'mfn-deprecated',
							'title' => __('Deprecated', 'mfn-opts'),
						),

						array(
							'id' => 'class',
							'type' => 'pills',
							'title' => __('Element classes', 'mfn-opts'),
							'class' => 'mfn-deprecated',
						),

   					array(
							'type' => 'html',
							'html' => '</div><div class="modalbox-card modalbox-card-style modalbox-re_render modalbox-card-style-mfnuidhere">',
						),

						array(
							'class' => 'toggled_header',
   						'title' => __('Container', 'mfn-opts'),
   					),

   					array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .portfolio_group .portfolio-item:background-color',
							'type' => 'color',
							'class' => 'main-color mfn-toggled',
							'title' => __('Background', 'mfn-opts'),
						),

   					array(
		  				'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .portfolio_group .portfolio-item:padding',
		  				'type' => 'dimensions',
		  				'title' => __('Padding', 'mfn-opts'),
		  				'version' => 'separated-fields',
							'responsive' => 'desktop',
							'class' => 'mfn_field_desktop mfn-toggled',
							'css_attr' => 'padding',
		  			),

		  			array(
		  				'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .portfolio_group .portfolio-item:padding_tablet',
		  				'type' => 'dimensions',
		  				'title' => __('Padding', 'mfn-opts'),
		  				'version' => 'separated-fields',
							'responsive' => 'tablet',
							'class' => 'mfn_field_tablet mfn-toggled',
							'css_attr' => 'padding',
		  			),

		  			array(
		  				'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .portfolio_group .portfolio-item:padding_mobile',
		  				'type' => 'dimensions',
		  				'title' => __('Padding', 'mfn-opts'),
		  				'version' => 'separated-fields',
							'responsive' => 'mobile',
							'class' => 'mfn_field_mobile mfn-toggled',
							'css_attr' => 'padding',
		  			),

		  			array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .portfolio_group .portfolio-item:border-style',
							'attr_id' => 'border_style_portfolio',
							'type' => 'select',
							'class' => 'mfn-toggled',
							'title' => __('Border style', 'mfn-opts'),
							'options' => [
								'none' => __('None', 'mfn-opts'),
								'solid' => __('Solid', 'mfn-opts'),
								'dashed' => __('Dashed', 'mfn-opts'),
								'dotted' => __('Dotted', 'mfn-opts'),
								'double' => __('Double', 'mfn-opts'),
							],
						),

						array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .portfolio_group .portfolio-item:border-color',
							'condition' => array( 'id' => 'border_style_portfolio', 'opt' => 'isnt', 'val' => 'none' ),
							'type' => 'color',
							'class' => 'mfn-toggled',
							'title' => __('Border color', 'mfn-opts'),
						),

						array(
		  				'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .portfolio_group .portfolio-item:border-width',
		  				'condition' => array( 'id' => 'border_style_portfolio', 'opt' => 'isnt', 'val' => 'none' ),
		  				'type' => 'dimensions',
		  				'title' => __('Border width', 'mfn-opts'),
							'responsive' => 'desktop',
							'class' => 'mfn_field_desktop mfn-toggled',
							'css_attr' => 'border-width',
		  			),

		  			array(
		  				'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .portfolio_group .portfolio-item:border-width_tablet',
		  				'condition' => array( 'id' => 'border_style_portfolio', 'opt' => 'isnt', 'val' => 'none' ),
		  				'type' => 'dimensions',
		  				'title' => __('Border width', 'mfn-opts'),
							'responsive' => 'tablet',
							'class' => 'mfn_field_tablet mfn-toggled',
							'css_attr' => 'border-width',
		  			),

		  			array(
		  				'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .portfolio_group .portfolio-item:border-width_mobile',
		  				'condition' => array( 'id' => 'border_style_portfolio', 'opt' => 'isnt', 'val' => 'none' ),
		  				'type' => 'dimensions',
		  				'title' => __('Border width', 'mfn-opts'),
							'responsive' => 'mobile',
							'class' => 'mfn_field_mobile mfn-toggled',
							'css_attr' => 'border-width',
		  			),

						array(
		  				'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .portfolio_group .portfolio-item:border-radius',
		  				'type' => 'dimensions',
		  				'title' => __('Border radius', 'mfn-opts'),
							'responsive' => 'desktop',
							'class' => 'mfn_field_desktop mfn-toggled',
							'css_attr' => 'border-radius',
		  			),

		  			array(
		  				'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .portfolio_group .portfolio-item:border-radius_tablet',
		  				'type' => 'dimensions',
		  				'title' => __('Border radius', 'mfn-opts'),
							'responsive' => 'tablet',
							'class' => 'mfn_field_tablet mfn-toggled',
							'css_attr' => 'border-radius',
		  			),

		  			array(
		  				'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .portfolio_group .portfolio-item:border-radius_mobile',
		  				'type' => 'dimensions',
		  				'title' => __('Border radius', 'mfn-opts'),
							'responsive' => 'mobile',
							'class' => 'mfn_field_mobile mfn-toggled',
							'css_attr' => 'border-radius',
		  			),

   					array(
							'class' => 'toggled_header',
   						'title' => __('Image', 'mfn-opts'),
   					),

		  			array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .portfolio_group .portfolio-item .image_frame:border-style',
							'attr_id' => 'border_style_portfolio_img',
							'type' => 'select',
							'class' => 'mfn-toggled',
							'title' => __('Border style', 'mfn-opts'),
							'options' => [
								'none' => __('None', 'mfn-opts'),
								'solid' => __('Solid', 'mfn-opts'),
								'dashed' => __('Dashed', 'mfn-opts'),
								'dotted' => __('Dotted', 'mfn-opts'),
								'double' => __('Double', 'mfn-opts'),
							],
						),

						array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .portfolio_group .portfolio-item .image_frame:border-color',
							'condition' => array( 'id' => 'border_style_portfolio_img', 'opt' => 'isnt', 'val' => 'none' ),
							'type' => 'color',
							'class' => 'mfn-toggled',
							'title' => __('Border color', 'mfn-opts'),
						),

						array(
		  				'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .portfolio_group .portfolio-item .image_frame:border-width',
		  				'condition' => array( 'id' => 'border_style_portfolio_img', 'opt' => 'isnt', 'val' => 'none' ),
		  				'type' => 'dimensions',
		  				'title' => __('Border width', 'mfn-opts'),
							'responsive' => 'desktop',
							'class' => 'mfn_field_desktop mfn-toggled',
							'css_attr' => 'border-width',
		  			),

		  			array(
		  				'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .portfolio_group .portfolio-item .image_frame:border-width_tablet',
		  				'condition' => array( 'id' => 'border_style_portfolio_img', 'opt' => 'isnt', 'val' => 'none' ),
		  				'type' => 'dimensions',
		  				'title' => __('Border width', 'mfn-opts'),
							'responsive' => 'tablet',
							'class' => 'mfn_field_tablet mfn-toggled',
							'css_attr' => 'border-width',
		  			),

		  			array(
		  				'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .portfolio_group .portfolio-item .image_frame:border-width_mobile',
		  				'condition' => array( 'id' => 'border_style_portfolio_img', 'opt' => 'isnt', 'val' => 'none' ),
		  				'type' => 'dimensions',
		  				'title' => __('Border width', 'mfn-opts'),
							'responsive' => 'mobile',
							'class' => 'mfn_field_mobile mfn-toggled',
							'css_attr' => 'border-width',
		  			),

						array(
		  				'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .portfolio_group .portfolio-item .image_frame:border-radius',
		  				'type' => 'dimensions',
		  				'title' => __('Border radius', 'mfn-opts'),
							'responsive' => 'desktop',
							'class' => 'mfn_field_desktop mfn-toggled',
							'css_attr' => 'border-radius',
		  			),

		  			array(
		  				'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .portfolio_group .portfolio-item .image_frame:border-radius_tablet',
		  				'type' => 'dimensions',
		  				'title' => __('Border radius', 'mfn-opts'),
							'responsive' => 'tablet',
							'class' => 'mfn_field_tablet mfn-toggled',
							'css_attr' => 'border-radius',
		  			),

		  			array(
		  				'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .portfolio_group .portfolio-item .image_frame:border-radius_mobile',
		  				'type' => 'dimensions',
		  				'title' => __('Border radius', 'mfn-opts'),
							'responsive' => 'mobile',
							'class' => 'mfn_field_mobile mfn-toggled',
							'css_attr' => 'border-radius',
		  			),

		  			array(
							'class' => 'toggled_header',
   						'title' => __('Content', 'mfn-opts'),
   					),

   					array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .portfolio_group .portfolio-item .desc:background-color',
							'type' => 'color',
							'class' => 'mfn-toggled',
							'title' => __('Background', 'mfn-opts'),
						),

   					array(
		  				'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .portfolio_group .portfolio-item .desc:margin',
		  				'type' => 'dimensions',
		  				'title' => __('Margin', 'mfn-opts'),
		  				'version' => 'separated-fields',
							'responsive' => 'desktop',
							'class' => 'mfn_field_desktop mfn-toggled',
							'css_attr' => 'margin',
		  			),

		  			array(
		  				'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .portfolio_group .portfolio-item .desc:margin_tablet',
		  				'type' => 'dimensions',
		  				'title' => __('Margin', 'mfn-opts'),
		  				'version' => 'separated-fields',
							'responsive' => 'tablet',
							'class' => 'mfn_field_tablet mfn-toggled',
							'css_attr' => 'margin',
		  			),

		  			array(
		  				'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .portfolio_group .portfolio-item .desc:margin_mobile',
		  				'type' => 'dimensions',
		  				'title' => __('Margin', 'mfn-opts'),
		  				'version' => 'separated-fields',
							'responsive' => 'mobile',
							'class' => 'mfn_field_mobile mfn-toggled',
							'css_attr' => 'margin',
		  			),

   					array(
		  				'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .portfolio_group .portfolio-item .desc:padding',
		  				'type' => 'dimensions',
		  				'title' => __('Padding', 'mfn-opts'),
		  				'version' => 'separated-fields',
							'responsive' => 'desktop',
							'class' => 'mfn_field_desktop mfn-toggled',
							'css_attr' => 'padding',
		  			),

		  			array(
		  				'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .portfolio_group .portfolio-item .desc:padding_tablet',
		  				'type' => 'dimensions',
		  				'title' => __('Padding', 'mfn-opts'),
		  				'version' => 'separated-fields',
							'responsive' => 'tablet',
							'class' => 'mfn_field_tablet mfn-toggled',
							'css_attr' => 'padding',
		  			),

		  			array(
		  				'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .portfolio_group .portfolio-item .desc:padding_mobile',
		  				'type' => 'dimensions',
		  				'title' => __('Padding', 'mfn-opts'),
		  				'version' => 'separated-fields',
							'responsive' => 'mobile',
							'class' => 'mfn_field_mobile mfn-toggled',
							'css_attr' => 'padding',
		  			),

						array(
							'class' => 'toggled_header',
   						'title' => __('Title', 'mfn-opts'),
   					),

						array(
							'id' => 'style:body .mcb-section .mcb-wrap .mcb-item-mfnuidelement .portfolio_group .portfolio-item .entry-title a,.mcb-section .mcb-wrap .mcb-item-mfnuidelement .portfolio_group .portfolio-item .entry-title:color',
							'type' => 'color',
							'class' => 'main-color mfn-toggled',
							'title' => __('Color', 'mfn-opts'),
						),

						array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .portfolio_group .portfolio-item .entry-title:typography',
							'type' => 'typography_vb',
							'label_after' => '<a href="#" title="Edit" class="mfn-option-btn mfn-option-blank btn-medium mfn-vb-label-button"><span class="mfn-icon mfn-icon-edit"></span></a>',
							'class' => 'mfn-toggled toggle_fields',
							'title' => __('Typography', 'mfn-opts'),
						),

						array(
							'class' => 'toggled_header',
   						'title' => __('Excerpt', 'mfn-opts'),
   					),

						array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .portfolio_group .portfolio-item .desc-wrapper:color',
							'type' => 'color',
							'class' => 'main-color mfn-toggled',
							'title' => __('Color', 'mfn-opts'),
						),

						array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .portfolio_group .portfolio-item .desc-wrapper:typography',
							'type' => 'typography_vb',
							'label_after' => '<a href="#" title="Edit" class="mfn-option-btn mfn-option-blank btn-medium mfn-vb-label-button"><span class="mfn-icon mfn-icon-edit"></span></a>',
							'class' => 'mfn-toggled toggle_fields',
							'title' => __('Typography', 'mfn-opts'),
						),

						array(
							'class' => 'toggled_header',
   						'title' => __('Icons', 'mfn-opts'),
   					),

   					array(
							'type' => 'html',
							'html' => '<div class="mfn-form-row mfn-sidebar-fields-tabs mfn-toggled mfn-vb-formrow mfn-vb-mfnuidhere"><ul class="mfn-sft-nav"><li class="active"><a href="#normal" data-tab="normal">Normal</a></li><li><a href="#hover" data-tab="hover">Hover</a></li></ul><div class="mfn-sft mfn-sft-normal">',
						),

   					array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .portfolio_group .portfolio-item a i:color',
							'type' => 'color',
							'class' => 'main-color mfn-toggled',
							'title' => __('Color', 'mfn-opts'),
						),

						array(
							'type' => 'html',
							'html' => '</div><div class="mfn-sft mfn-sft-hover">',
						),

						array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .portfolio_group .portfolio-item a|hover i:color',
							'type' => 'color',
							'class' => 'main-color mfn-toggled',
							'title' => __('Color', 'mfn-opts'),
						),

						array(
							'type' => 'html',
							'html' => '</div></div>',
						),

						array(
							'class' => 'toggled_header',
   						'title' => __('Masonry hover', 'mfn-opts'),
   					),

   					array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .portfolio_group.masonry-hover .portfolio-item .masonry-hover-wrapper .hover-desc:background-color',
							'type' => 'color',
							'class' => 'main-color mfn-toggled',
							'title' => __('Background', 'mfn-opts'),
						),

						array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .portfolio_group.masonry-hover .portfolio-item .masonry-hover-wrapper .hover-desc h3|after:background',
							'type' => 'color',
							'class' => 'main-color mfn-toggled',
							'title' => __('Decoration', 'mfn-opts'),
						),

						array(
							'class' => 'toggled_header',
   						'title' => __('Meta', 'mfn-opts'),
   					),

   					array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .portfolio_group .portfolio-item .details-wrapper,.mcb-section .mcb-wrap .mcb-item-mfnuidelement .portfolio_group .portfolio-item .details-wrapper h5:color',
							'type' => 'color',
							'class' => 'main-color mfn-toggled',
							'title' => __('Color', 'mfn-opts'),
						),

						array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .portfolio_group .portfolio-item .details-wrapper a:color',
							'type' => 'color',
							'class' => 'main-color mfn-toggled',
							'title' => __('Link color', 'mfn-opts'),
						),

						array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .portfolio_group .portfolio-item .details-wrapper,.mcb-section .mcb-wrap .mcb-item-mfnuidelement .portfolio_group .portfolio-item .details-wrapper .column:border-color',
							'type' => 'color',
							'class' => 'main-color mfn-toggled',
							'title' => __('Border color', 'mfn-opts'),
						),

						array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .portfolio_group .portfolio-item .details-wrapper:typography',
							'type' => 'typography_vb',
							'label_after' => '<a href="#" title="Edit" class="mfn-option-btn mfn-option-blank btn-medium mfn-vb-label-button"><span class="mfn-icon mfn-icon-edit"></span></a>',
							'class' => 'mfn-toggled toggle_fields',
							'title' => __('Typography', 'mfn-opts'),
						),

						array(
							'class' => 'toggled_header',
   						'title' => __('Exposure', 'mfn-opts'),
   					),

						array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .portfolio_group .portfolio-item .desc-inner .line:background-color',
							'type' => 'color',
							'class' => 'main-color mfn-toggled',
							'title' => __('Line', 'mfn-opts'),
						),

						array(
							'class' => 'toggled_header',
   						'title' => __('Button', 'mfn-opts'),
   					),

		  			array(
		  				'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .portfolio_group .portfolio-item .list_style_header .links_wrapper .button:padding',
		  				'type' => 'dimensions',
		  				'version' => 'separated-fields',
		  				'title' => __('Padding', 'mfn-opts'),
							'responsive' => 'desktop',
							'class' => 'mfn_field_desktop mfn-toggled',
							'css_attr' => 'padding',
		  			),

		  			array(
		  				'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .portfolio_group .portfolio-item .list_style_header .links_wrapper .button:padding_tablet',
		  				'type' => 'dimensions',
		  				'version' => 'separated-fields',
		  				'title' => __('Padding', 'mfn-opts'),
							'responsive' => 'tablet',
							'class' => 'mfn_field_tablet mfn-toggled',
							'css_attr' => 'padding',
		  			),

		  			array(
		  				'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .portfolio_group .portfolio-item .list_style_header .links_wrapper .button:padding_mobile',
		  				'type' => 'dimensions',
		  				'version' => 'separated-fields',
		  				'title' => __('Padding', 'mfn-opts'),
							'responsive' => 'mobile',
							'class' => 'mfn_field_mobile mfn-toggled',
							'css_attr' => 'padding',
		  			),

		  			array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .portfolio_group .portfolio-item .list_style_header .links_wrapper .button:typography',
							'type' => 'typography_vb',
							'label_after' => '<a href="#" title="Edit" class="mfn-option-btn mfn-option-blank btn-medium mfn-vb-label-button"><span class="mfn-icon mfn-icon-edit"></span></a>',
							'class' => 'mfn-toggled toggle_fields',
							'title' => __('Typography', 'mfn-opts'),
						),

						array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .portfolio_group .portfolio-item .list_style_header .links_wrapper .button:border-style',
							'attr_id' => 'border_style',
							'type' => 'select',
							'class' => 'mfn-toggled',
							'title' => __('Border style', 'mfn-opts'),
							'options' => [
								'none' => __('None', 'mfn-opts'),
								'solid' => __('Solid', 'mfn-opts'),
								'dashed' => __('Dashed', 'mfn-opts'),
								'dotted' => __('Dotted', 'mfn-opts'),
								'double' => __('Double', 'mfn-opts'),
							],
						),

						array(
		  				'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .portfolio_group .portfolio-item .list_style_header .links_wrapper .button:border-width',
		  				'condition' => array( 'id' => 'border_style', 'opt' => 'isnt', 'val' => 'none' ),
		  				'type' => 'dimensions',
		  				'title' => __('Border width', 'mfn-opts'),
							'responsive' => 'desktop',
							'class' => 'mfn_field_desktop mfn-toggled',
							'css_attr' => 'border-width',
		  			),

		  			array(
		  				'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .portfolio_group .portfolio-item .list_style_header .links_wrapper .button:border-width_tablet',
		  				'condition' => array( 'id' => 'border_style', 'opt' => 'isnt', 'val' => 'none' ),
		  				'type' => 'dimensions',
		  				'title' => __('Border width', 'mfn-opts'),
							'responsive' => 'tablet',
							'class' => 'mfn_field_tablet mfn-toggled',
							'css_attr' => 'border-width',
		  			),

		  			array(
		  				'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .portfolio_group .portfolio-item .list_style_header .links_wrapper .button:border-width_mobile',
		  				'condition' => array( 'id' => 'border_style', 'opt' => 'isnt', 'val' => 'none' ),
		  				'type' => 'dimensions',
		  				'title' => __('Border width', 'mfn-opts'),
							'responsive' => 'mobile',
							'class' => 'mfn_field_mobile mfn-toggled',
							'css_attr' => 'border-width',
		  			),

						array(
		  				'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .portfolio_group .portfolio-item .list_style_header .links_wrapper .button:border-radius',
		  				'type' => 'dimensions',
		  				'title' => __('Border radius', 'mfn-opts'),
							'responsive' => 'desktop',
							'class' => 'mfn_field_desktop mfn-toggled',
							'css_attr' => 'border-radius',
		  			),

		  			array(
		  				'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .portfolio_group .portfolio-item .list_style_header .links_wrapper .button:border-radius_tablet',
		  				'type' => 'dimensions',
		  				'title' => __('Border radius', 'mfn-opts'),
							'responsive' => 'tablet',
							'class' => 'mfn_field_tablet mfn-toggled',
							'css_attr' => 'border-radius',
		  			),

		  			array(
		  				'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .portfolio_group .portfolio-item .list_style_header .links_wrapper .button:border-radius_mobile',
		  				'type' => 'dimensions',
		  				'title' => __('Border radius', 'mfn-opts'),
							'responsive' => 'mobile',
							'class' => 'mfn_field_mobile mfn-toggled',
							'css_attr' => 'border-radius',
		  			),

   					array(
							'type' => 'html',
							'html' => '<div class="mfn-form-row mfn-sidebar-fields-tabs mfn-toggled mfn-vb-formrow mfn-vb-mfnuidhere"><ul class="mfn-sft-nav"><li class="active"><a href="#normal" data-tab="normal">Normal</a></li><li><a href="#hover" data-tab="hover">Hover</a></li></ul><div class="mfn-sft mfn-sft-normal">',
						),

						array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .portfolio_group .portfolio-item .list_style_header .links_wrapper .button,.mcb-section .mcb-wrap .mcb-item-mfnuidelement .portfolio_group .portfolio-item .list_style_header .links_wrapper .button i:color',
							'type' => 'color',
							'class' => 'main-color mfn-toggled',
							'title' => __('Color', 'mfn-opts'),
						),

						array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .portfolio_group .portfolio-item .list_style_header .links_wrapper .button:border-color',
							'condition' => array( 'id' => 'border_style', 'opt' => 'isnt', 'val' => 'none' ),
							'type' => 'color',
							'class' => 'mfn-toggled',
							'title' => __('Border color', 'mfn-opts'),
						),

						array(
							'id' => 'background_switcher',
							'attr_id' => 'background_switcher',
							'type' => 'switch',
							'class' => 'mfn-fields-switcher',
							'title' => __('Background type', 'mfn-opts'),
							'options' => array(
		  					'default' => __('Default', 'mfn-opts'),
		  					'gradient' 	=> __('Gradient', 'mfn-opts'),
		  				),
							'visual_options' => array(
		  					'default' => '',
		  					'gradient' 	=> '',
		  				),
		  				'std' => 'default',
						),

						array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .portfolio_group .portfolio-item .list_style_header .links_wrapper .button:background-color',
							'condition' => array( 'id' => 'background_switcher', 'opt' => 'is', 'val' => 'default' ),
							'type' => 'color',
							'title' => __('Background color', 'mfn-opts'),
						),

						array(
		  				'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .portfolio_group .portfolio-item .list_style_header .links_wrapper .button:gradient',
		  				'condition' => array( 'id' => 'background_switcher', 'opt' => 'is', 'val' => 'gradient' ),
		  				'type' => 'gradient',
		  				'title' => __('Gradient', 'mfn-opts'),
		  				'class' => 'mfn-toggled',
							'css_attr' => 'gradient',
		  			),

						array(
							'type' => 'html',
							'html' => '</div><div class="mfn-sft mfn-sft-hover">',
						),

						array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .portfolio_group .portfolio-item .list_style_header .links_wrapper .button|hover,.mcb-section .mcb-wrap .mcb-item-mfnuidelement .portfolio_group .portfolio-item .list_style_header .links_wrapper .button|hover i:color',
							'type' => 'color',
							'class' => 'main-color mfn-toggled',
							'title' => __('Color', 'mfn-opts'),
						),

						array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .portfolio_group .portfolio-item .list_style_header .links_wrapper .button|hover:border-color',
							'condition' => array( 'id' => 'border_style', 'opt' => 'isnt', 'val' => 'none' ),
							'type' => 'color',
							'class' => 'mfn-toggled',
							'title' => __('Border color', 'mfn-opts'),
						),

						array(
							'id' => 'background_switcher_hover',
							'attr_id' => 'background_switcher_hover',
							'type' => 'switch',
							'class' => 'mfn-fields-switcher',
							'title' => __('Background type', 'mfn-opts'),
							'options' => array(
		  					'default' => __('Default', 'mfn-opts'),
		  					'gradient' 	=> __('Gradient', 'mfn-opts'),
		  				),
							'visual_options' => array(
		  					'default' => '',
		  					'gradient' 	=> '',
		  				),
		  				'std' => 'default',
						),

						array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .portfolio_group .portfolio-item .list_style_header .links_wrapper .button|hover:background',
							'condition' => array( 'id' => 'background_switcher_hover', 'opt' => 'is', 'val' => 'default' ),
							'type' => 'color',
							'class' => 'main-color mfn-toggled',
							'title' => __('Background color', 'mfn-opts'),
						),

						array(
		  				'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .portfolio_group .portfolio-item .list_style_header .links_wrapper .button|hover:gradient',
		  				'condition' => array( 'id' => 'background_switcher_hover', 'opt' => 'is', 'val' => 'gradient' ),
		  				'type' => 'gradient',
		  				'title' => __('Gradient', 'mfn-opts'),
		  				'class' => 'mfn-toggled',
							'css_attr' => 'gradient',
		  			),

						array(
							'type' => 'html',
							'html' => '</div></div>',
						),

						array(
							'type' => 'html',
							'html' => '</div>',
						),

   				),
   			),

   			// Portfolio Grid -------------------------------------------------

   			'portfolio_grid' => array(
   				'type' => 'portfolio_grid',
   				'title' => __('Portfolio Grid', 'mfn-opts'),
   				'size' => '1/4',
   				'tablet_size' => '1/4',
   				'mobile_size' => '1/1',
   				'tablet_resized' => '0',
   				'cat' => 'loops',
   				'fields' => array(

   					array(
							'type' => 'html',
							'html' => '<div class="modalbox-card modalbox-re_render modalbox-card-content-mfnuidhere active">',
						),

						array(
   						'id' => 'count',
   						're_render' => 'standard',
   						'type' => 'text',
   						'title' => __('Projects number', 'mfn-opts'),
   						'param' => 'number',
   						'after' => 'projects',
   						'class' => 'narrow',
   						'std' => 4,
							'preview' => 'number',
   					),

   					// options

   					array(
   						'title' => __('Options', 'mfn-opts'),
   					),

   					array(
   						'id' => 'category',
   						're_render' => 'standard',
   						'type' => 'select',
   						'title' => __('Category', 'mfn-opts'),
   						'options' => mfn_get_categories('portfolio-types'),
   						'wpml' => 'portfolio-types',
							'preview' => 'category',
   					),

   					array(
   						'id' => 'category_multi',
   						're_render' => 'standard',
   						'type' => 'text',
   						'title' => __('Multiple categories', 'mfn-opts'),
   						'desc' => __('Slugs should be separated with <b>coma</b> ( , )', 'mfn-opts'),
							'preview' => 'category-all',
   					),

   					array(
   						'id' => 'orderby',
   						're_render' => 'standard',
   						'type' => 'switch',
   						'title' => __('Order by', 'mfn-opts'),
   						'options' => array(
   							'date' => __('Date', 'mfn-opts'),
   							'menu_order' => __('Menu order', 'mfn-opts'),
   							'title' => __('Title', 'mfn-opts'),
   							'rand' => __('Random', 'mfn-opts'),
   						),
   						'std' => 'date',
   					),

   					array(
   						'id' => 'order',
   						're_render' => 'standard',
   						'type' => 'switch',
   						'title' => __('Order', 'mfn-opts'),
   						'options' => array(
   							'ASC' => __('Ascending', 'mfn-opts'),
   							'DESC' => __('Descending', 'mfn-opts'),
   						),
   						'std' => 'DESC',
   					),

   					// advanced

   					array(
   						'title' => __('Advanced', 'mfn-opts'),
   					),

   					array(
   						'id' => 'greyscale',
   						'type' => 'switch',
   						'title' => 'Grayscale',
   						'options' => array(
   							0 => __('Disable', 'mfn-opts'),
   							1 => __('Enable', 'mfn-opts'),
   						),
							'std' => 0,
   					),

						// deprecated

						array(
							'class' => 'mfn-deprecated',
							'title' => __('Deprecated', 'mfn-opts'),
						),

						array(
							'id' => 'class',
							'type' => 'pills',
							'title' => __('Element classes', 'mfn-opts'),
							'class' => 'mfn-deprecated',
						),

						array(
							'type' => 'html',
							'html' => '</div>',
						),

   				),
   			),

   			// Portfolio Photo ------------------------------------------------

   			'portfolio_photo' => array(
   				'type' => 'portfolio_photo',
   				'title' => __('Portfolio Photo', 'mfn-opts'),
   				'size' => '1/1',
   				'tablet_size' => '1/1',
   				'mobile_size' => '1/1',
   				'tablet_resized' => '0',
   				'cat' => 'loops',
   				'fields' => array(

   					array(
							'type' => 'html',
							'html' => $this->itemtabs,
						),

   					array(
							'type' => 'html',
							'html' => '<div class="modalbox-card modalbox-re_render modalbox-card-content-mfnuidhere active">',
						),

						array(
   						'id' => 'count',
   						're_render' => 'standard',
   						'type' => 'text',
   						'title' => __('Projects number', 'mfn-opts'),
   						'param' => 'number',
   						'after' => 'projects',
   						'class' => 'narrow',
   						'std' => 5,
							'preview' => 'number',
   					),

   					// options

   					array(
   						'title' => __('Options', 'mfn-opts'),
   					),

   					array(
   						'id' => 'category',
   						're_render' => 'standard',
   						'type' => 'select',
   						'title' => __('Category', 'mfn-opts'),
   						'options' => mfn_get_categories('portfolio-types'),
   						'wpml' => 'portfolio-types',
							'preview' => 'category',
   					),

   					array(
   						'id' => 'category_multi',
   						're_render' => 'standard',
   						'type' => 'text',
   						'title' => __('Multiple categories', 'mfn-opts'),
   						'desc' => __('Slugs should be separated with <b>coma</b> ( , )', 'mfn-opts'),
							'preview' => 'category-all',
   					),

   					array(
   						'id' => 'orderby',
   						're_render' => 'standard',
   						'type' => 'switch',
   						'title' => __('Order by', 'mfn-opts'),
   						'options' => array(
   							'date' => __('Date', 'mfn-opts'),
   							'menu_order' => __('Menu order', 'mfn-opts'),
   							'title' => __('Title', 'mfn-opts'),
   							'rand' => __('Random', 'mfn-opts'),
   						),
   						'std' => 'date',
   					),

   					array(
   						'id' => 'order',
   						're_render' => 'standard',
   						'type' => 'switch',
   						'title' => __('Order', 'mfn-opts'),
   						'options' => array(
   							'ASC' => __('Ascending', 'mfn-opts'),
   							'DESC' => __('Descending', 'mfn-opts'),
   						),
   						'std' => 'DESC',
   					),

   					// advanced

   					array(
   						'title' => __('Advanced', 'mfn-opts'),
   					),

   					array(
   						'id' => 'target',
   						'type' => 'switch',
   						'title' => __('Link target', 'mfn-opts'),
   						'options' => array(
   							0 => __('_self', 'mfn-opts'),
   							1 => __('_blank', 'mfn-opts'),
   						),
							'std' => 0,
   					),

   					array(
   						'id' => 'greyscale',
   						'type' => 'switch',
   						'title' => __('Grayscale', 'mfn-opts'),
   						'options' => array(
   							0 => __('Disable', 'mfn-opts'),
   							1 => __('Enable', 'mfn-opts'),
   						),
							'std' => 0,
   					),

   					array(
   						'id' => 'margin',
   						're_render' => 'standard',
   						'type' => 'switch',
   						'title' => __('Margin', 'mfn-opts'),
   						'options' => array(
   							0 => __('Hide', 'mfn-opts'),
   							1 => __('Show', 'mfn-opts'),
   						),
							'std' => 0,
   					),

						// deprecated

						array(
							'class' => 'mfn-deprecated',
							'title' => __('Deprecated', 'mfn-opts'),
						),

						array(
							'id' => 'class',
							'type' => 'pills',
							'title' => __('Element classes', 'mfn-opts'),
							'class' => 'mfn-deprecated',
						),

   					array(
							'type' => 'html',
							'html' => '</div><div class="modalbox-card modalbox-card-style modalbox-re_render modalbox-card-style-mfnuidhere">',
						),

						array(
							'class' => 'toggled_header',
   						'title' => __('Box', 'mfn-opts'),
   					),

   					array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .portfolio-photo .portfolio-item .portfolio-details .details:background-color',
							'type' => 'color',
							'class' => 'mfn-toggled',
							'title' => __('Background', 'mfn-opts'),
						),

		  			array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .portfolio-photo .portfolio-item .portfolio-details .details:border-style',
							'type' => 'select',
							'attr_id' => 'border_style_port_photo',
							'class' => 'mfn-toggled',
							'title' => __('Border style', 'mfn-opts'),
							'options' => [
								'none' => __('None', 'mfn-opts'),
								'solid' => __('Solid', 'mfn-opts'),
								'dashed' => __('Dashed', 'mfn-opts'),
								'dotted' => __('Dotted', 'mfn-opts'),
								'double' => __('Double', 'mfn-opts'),
							],
						),

						array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .portfolio-photo .portfolio-item .portfolio-details .details:border-color',
							'condition' => array( 'id' => 'border_style_port_photo', 'opt' => 'isnt', 'val' => 'none' ),
							'type' => 'color',
							'class' => 'mfn-toggled',
							'title' => __('Border color', 'mfn-opts'),
						),

						array(
		  				'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .portfolio-photo .portfolio-item .portfolio-details .details:border-width',
		  				'condition' => array( 'id' => 'border_style_port_photo', 'opt' => 'isnt', 'val' => 'none' ),
		  				'type' => 'dimensions',
		  				'title' => __('Border width', 'mfn-opts'),
							'responsive' => 'desktop',
							'class' => 'mfn_field_desktop mfn-toggled',
							'css_attr' => 'border-width',
		  			),

		  			array(
		  				'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .portfolio-photo .portfolio-item .portfolio-details .details:border-width_tablet',
		  				'condition' => array( 'id' => 'border_style_port_photo', 'opt' => 'isnt', 'val' => 'none' ),
		  				'type' => 'dimensions',
		  				'title' => __('Border width', 'mfn-opts'),
							'responsive' => 'tablet',
							'class' => 'mfn_field_tablet mfn-toggled',
							'css_attr' => 'border-width',
		  			),

		  			array(
		  				'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .portfolio-photo .portfolio-item .portfolio-details .details:border-width_mobile',
		  				'condition' => array( 'id' => 'border_style_port_photo', 'opt' => 'isnt', 'val' => 'none' ),
		  				'type' => 'dimensions',
		  				'title' => __('Border width', 'mfn-opts'),
							'responsive' => 'mobile',
							'class' => 'mfn_field_mobile mfn-toggled',
							'css_attr' => 'border-width',
		  			),

						array(
		  				'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .portfolio-photo .portfolio-item .portfolio-details .details:border-radius',
		  				'type' => 'dimensions',
		  				'title' => __('Border radius', 'mfn-opts'),
							'responsive' => 'desktop',
							'class' => 'mfn_field_desktop mfn-toggled',
							'css_attr' => 'border-radius',
		  			),

		  			array(
		  				'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .portfolio-photo .portfolio-item .portfolio-details .details:border-radius_tablet',
		  				'type' => 'dimensions',
		  				'title' => __('Border radius', 'mfn-opts'),
							'responsive' => 'tablet',
							'class' => 'mfn_field_tablet mfn-toggled',
							'css_attr' => 'border-radius',
		  			),

		  			array(
		  				'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .portfolio-photo .portfolio-item .portfolio-details .details:border-radius_mobile',
		  				'type' => 'dimensions',
		  				'title' => __('Border radius', 'mfn-opts'),
							'responsive' => 'mobile',
							'class' => 'mfn_field_mobile mfn-toggled',
							'css_attr' => 'border-radius',
		  			),

						array(
							'class' => 'toggled_header',
   						'title' => __('Title', 'mfn-opts'),
   					),

						array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .portfolio-photo .portfolio-item .portfolio-details .details .title:color',
							'type' => 'color',
							'class' => 'mfn-toggled',
							'title' => __('Color', 'mfn-opts'),
						),

						array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .portfolio-photo .portfolio-item .portfolio-details .details .title:typography',
							'type' => 'typography_vb',
							'label_after' => '<a href="#" title="Edit" class="mfn-option-btn mfn-option-blank btn-medium mfn-vb-label-button"><span class="mfn-icon mfn-icon-edit"></span></a>',
							'class' => 'mfn-toggled toggle_fields',
							'title' => __('Typography', 'mfn-opts'),
						),

						array(
							'class' => 'toggled_header',
   						'title' => __('Decoration', 'mfn-opts'),
   					),

   					array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .portfolio-photo .portfolio-item .portfolio-details .details .title:border-color',
							'type' => 'color',
							'class' => 'main-color mfn-toggled',
							'title' => __('Color', 'mfn-opts'),
						),

						array(
							'class' => 'toggled_header',
   						'title' => __('Meta', 'mfn-opts'),
   					),

						array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .portfolio-photo .portfolio-item .portfolio-details .details .categories:color',
							'type' => 'color',
							'class' => 'main-color mfn-toggled',
							'title' => __('Color', 'mfn-opts'),
						),

						array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .portfolio-photo .portfolio-item .portfolio-details .details .categories:typography',
							'type' => 'typography_vb',
							'label_after' => '<a href="#" title="Edit" class="mfn-option-btn mfn-option-blank btn-medium mfn-vb-label-button"><span class="mfn-icon mfn-icon-edit"></span></a>',
							'class' => 'mfn-toggled toggle_fields',
							'title' => __('Typography', 'mfn-opts'),
						),

						array(
							'class' => 'toggled_header',
   						'title' => __('Button', 'mfn-opts'),
   					),

   					array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .portfolio-photo .portfolio-item .portfolio-details .more:background-color',
							'type' => 'color',
							'class' => 'mfn-toggled',
							'title' => __('Background', 'mfn-opts'),
						),

						array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .portfolio-photo .portfolio-item .portfolio-details .more h4:color',
							'type' => 'color',
							'class' => 'main-color mfn-toggled',
							'title' => __('Color', 'mfn-opts'),
						),

						array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .portfolio-photo .portfolio-item .portfolio-details .more:typography',
							'type' => 'typography_vb',
							'label_after' => '<a href="#" title="Edit" class="mfn-option-btn mfn-option-blank btn-medium mfn-vb-label-button"><span class="mfn-icon mfn-icon-edit"></span></a>',
							'class' => 'mfn-toggled toggle_fields',
							'title' => __('Typography', 'mfn-opts'),
						),

						array(
		  				'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .portfolio-photo .portfolio-item .portfolio-details .more:padding',
		  				'type' => 'dimensions',
		  				'version' => 'separated-fields',
		  				'title' => __('Padding', 'mfn-opts'),
							'responsive' => 'desktop',
							'class' => 'mfn_field_desktop mfn-toggled',
							'css_attr' => 'padding',
		  			),

		  			array(
		  				'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .portfolio-photo .portfolio-item .portfolio-details .more:padding_tablet',
		  				'type' => 'dimensions',
		  				'version' => 'separated-fields',
		  				'title' => __('Padding', 'mfn-opts'),
							'responsive' => 'tablet',
							'class' => 'mfn_field_tablet mfn-toggled',
							'css_attr' => 'padding',
		  			),

		  			array(
		  				'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .portfolio-photo .portfolio-item .portfolio-details .more:padding_mobile',
		  				'type' => 'dimensions',
		  				'version' => 'separated-fields',
		  				'title' => __('Padding', 'mfn-opts'),
							'responsive' => 'mobile',
							'class' => 'mfn_field_mobile mfn-toggled',
							'css_attr' => 'padding',
		  			),

		  			array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .portfolio-photo .portfolio-item .portfolio-details .more:border-style',
							'type' => 'select',
							'attr_id' => 'border_style_port_photo',
							'class' => 'mfn-toggled',
							'title' => __('Border style', 'mfn-opts'),
							'options' => [
								'none' => __('None', 'mfn-opts'),
								'solid' => __('Solid', 'mfn-opts'),
								'dashed' => __('Dashed', 'mfn-opts'),
								'dotted' => __('Dotted', 'mfn-opts'),
								'double' => __('Double', 'mfn-opts'),
							],
						),

						array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .portfolio-photo .portfolio-item .portfolio-details .more:border-color',
							'condition' => array( 'id' => 'border_style_port_photo', 'opt' => 'isnt', 'val' => 'none' ),
							'type' => 'color',
							'class' => 'mfn-toggled',
							'title' => __('Border color', 'mfn-opts'),
						),

						array(
		  				'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .portfolio-photo .portfolio-item .portfolio-details .more:border-width',
		  				'condition' => array( 'id' => 'border_style_port_photo', 'opt' => 'isnt', 'val' => 'none' ),
		  				'type' => 'dimensions',
		  				'title' => __('Border width', 'mfn-opts'),
							'responsive' => 'desktop',
							'class' => 'mfn_field_desktop mfn-toggled',
							'css_attr' => 'border-width',
		  			),

		  			array(
		  				'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .portfolio-photo .portfolio-item .portfolio-details .more:border-width_tablet',
		  				'condition' => array( 'id' => 'border_style_port_photo', 'opt' => 'isnt', 'val' => 'none' ),
		  				'type' => 'dimensions',
		  				'title' => __('Border width', 'mfn-opts'),
							'responsive' => 'tablet',
							'class' => 'mfn_field_tablet mfn-toggled',
							'css_attr' => 'border-width',
		  			),

		  			array(
		  				'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .portfolio-photo .portfolio-item .portfolio-details .more:border-width_mobile',
		  				'condition' => array( 'id' => 'border_style_port_photo', 'opt' => 'isnt', 'val' => 'none' ),
		  				'type' => 'dimensions',
		  				'title' => __('Border width', 'mfn-opts'),
							'responsive' => 'mobile',
							'class' => 'mfn_field_mobile mfn-toggled',
							'css_attr' => 'border-width',
		  			),

						array(
		  				'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .portfolio-photo .portfolio-item .portfolio-details .more:border-radius',
		  				'type' => 'dimensions',
		  				'title' => __('Border radius', 'mfn-opts'),
							'responsive' => 'desktop',
							'class' => 'mfn_field_desktop mfn-toggled',
							'css_attr' => 'border-radius',
		  			),

		  			array(
		  				'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .portfolio-photo .portfolio-item .portfolio-details .more:border-radius_tablet',
		  				'type' => 'dimensions',
		  				'title' => __('Border radius', 'mfn-opts'),
							'responsive' => 'tablet',
							'class' => 'mfn_field_tablet mfn-toggled',
							'css_attr' => 'border-radius',
		  			),

		  			array(
		  				'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .portfolio-photo .portfolio-item .portfolio-details .more:border-radius_mobile',
		  				'type' => 'dimensions',
		  				'title' => __('Border radius', 'mfn-opts'),
							'responsive' => 'mobile',
							'class' => 'mfn_field_mobile mfn-toggled',
							'css_attr' => 'border-radius',
		  			),

						array(
							'type' => 'html',
							'html' => '</div>',
						),

   				),
   			),

   			// Portfolio Slider -----------------------------------------------

   			'portfolio_slider' => array(
   				'type' => 'portfolio_slider',
   				'title' => __('Portfolio Slider', 'mfn-opts'),
   				'size' => '1/1',
   				'tablet_size' => '1/1',
   				'mobile_size' => '1/1',
   				'tablet_resized' => '0',
   				'cat' => 'loops',
   				'fields' => array(

   					array(
							'type' => 'html',
							'html' => $this->itemtabs,
						),

   					array(
							'type' => 'html',
							'html' => '<div class="modalbox-card modalbox-re_render modalbox-card-content-mfnuidhere active">',
						),

						array(
   						'id' => 'count',
   						're_render' => 'standard',
   						'type' => 'text',
   						'title' => __('Projects number', 'mfn-opts'),
   						'param' => 'number',
   						'after' => 'projects',
   						'class' => 'narrow',
   						'std' => 6,
							'preview' => 'number',
   					),

   					// options

   					array(
   						'title' => __('Options', 'mfn-opts'),
   					),

   					array(
   						'id' => 'category',
   						're_render' => 'standard',
   						'type' => 'select',
   						'title' => __('Category', 'mfn-opts'),
   						'options' => mfn_get_categories('portfolio-types'),
   						'wpml' => 'portfolio-types',
							'preview' => 'category',
   					),

   					array(
   						'id' => 'category_multi',
   						're_render' => 'standard',
   						'type' => 'text',
   						'title' => __('Multiple categories', 'mfn-opts'),
   						'desc' => __('Slugs should be separated with <strong>coma</strong> (,).', 'mfn-opts'),
							'preview' => 'category-all',
   					),

   					array(
   						'id' => 'orderby',
   						'type' => 'switch',
   						're_render' => 'standard',
   						'title' => __('Order by', 'mfn-opts'),
   						'options' => array(
   							'date' => __('Date', 'mfn-opts'),
   							'menu_order' => __('Menu order', 'mfn-opts'),
   							'title' => __('Title', 'mfn-opts'),
   							'rand' => __('Random', 'mfn-opts'),
   						),
   						'std' => 'date',
   					),

   					array(
   						'id' => 'order',
   						'type' => 'switch',
   						're_render' => 'standard',
   						'title' => __('Order', 'mfn-opts'),
   						'options' => array(
   							'ASC' => __('Ascending', 'mfn-opts'),
   							'DESC' => __('Descending', 'mfn-opts'),
   						),
   						'std' => 'DESC',
   					),

   					// advanced

   					array(
   						'title' => __('Advanced', 'mfn-opts'),
   					),

   					array(
   						'id' => 'arrows',
   						're_render' => 'standard',
   						'type' => 'switch',
   						'title' => __('Navigation', 'mfn-opts'),
   						'options' => array(
   							'' => __('Hide', 'mfn-opts'),
   							'always' => __('Show', 'mfn-opts'),
								'hover' => __('Show on hover', 'mfn-opts'),
   						),
							'std' => '',
   					),

   					array(
   						'id' => 'size',
   						'type' => 'switch',
   						're_render' => 'standard',
   						'title' => __('Image size', 'mfn-opts'),
   						'options' => array(
   							'small' => __('Small', 'mfn-opts'),
   							'medium' => __('Medium', 'mfn-opts'),
   							'large' => __('Large', 'mfn-opts'),
   						),
							'std' => 'small',
   					),

   					array(
   						'id' => 'scroll',
   						'type' => 'switch',
   						're_render' => 'standard',
   						'title' => __('Slides to scroll', 'mfn-opts'),
   						'options' => array(
   							'page' => __('One page', 'mfn-opts'),
   							'slide' => __('Single slide', 'mfn-opts'),
   						),
							'std' => 'page',
   					),

						// deprecated

						array(
							'class' => 'mfn-deprecated',
							'title' => __('Deprecated', 'mfn-opts'),
						),

						array(
							'id' => 'class',
							'type' => 'pills',
							'title' => __('Element classes', 'mfn-opts'),
							'class' => 'mfn-deprecated',
						),

   					array(
							'type' => 'html',
							'html' => '</div><div class="modalbox-card modalbox-card-style modalbox-re_render modalbox-card-style-mfnuidhere">',
						),

						array(
							'class' => 'toggled_header',
   						'title' => __('Nav', 'mfn-opts'),
   					),

   					array(
							'type' => 'html',
							'html' => '<div class="mfn-form-row mfn-sidebar-fields-tabs mfn-toggled mfn-vb-formrow mfn-vb-mfnuidhere"><ul class="mfn-sft-nav"><li class="active"><a href="#normal" data-tab="normal">Normal</a></li><li><a href="#hover" data-tab="hover">Hover</a></li></ul><div class="mfn-sft mfn-sft-normal">',
						),

						array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .portfolio_slider .slider_nav:background-color',
							'type' => 'color',
							'title' => __('Background', 'mfn-opts'),
						),

						array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .portfolio_slider .slider_nav:color',
							'type' => 'color',
							'title' => __('Color', 'mfn-opts'),
						),

						array(
							'type' => 'html',
							'html' => '</div><div class="mfn-sft mfn-sft-hover">',
						),

						array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .portfolio_slider .slider_nav|hover:background-color',
							'type' => 'color',
							'title' => __('Background', 'mfn-opts'),
						),

						array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .portfolio_slider .slider_nav|hover:color',
							'type' => 'color',
							'title' => __('Color', 'mfn-opts'),
						),

						array(
							'type' => 'html',
							'html' => '</div></div>',
						),

						array(
							'type' => 'html',
							'html' => '</div>',
						),

   				),
   			),

   			// Pricing item ---------------------------------------------------

   			'pricing_item' => array(
   				'type' => 'pricing_item',
   				'title' => __('Pricing Item', 'mfn-opts'),
   				'size' => '1/4',
   				'tablet_size' => '1/4',
   				'mobile_size' => '1/4',
   				'tablet_resized' => '0',
   				'cat' => 'blocks',
   				'fields' => array(

   					array(
							'type' => 'html',
							'html' => $this->itemtabs,
						),

   					array(
							'type' => 'html',
							'html' => '<div class="modalbox-card modalbox-re_render modalbox-card-content-mfnuidhere active">',
						),

   					array(
   						'id' => 'image',
   						'type' => 'upload',
   						'title' => __('Image', 'mfn-opts'),
							'std' => $this->get_placeholder(),
							'preview' => 'image',
   					),

   					array(
   						'id' => 'title',
   						'type' => 'text',
   						'edit_tag' => '.plan-header | h2',
   						'title' => __('Title', 'mfn-opts'),
   						'edit_position' => 'before | .price',
							'std' => __('This is the title', 'mfn-opts'),
							'preview' => 'title',
   					),

						// price

   					array(
   						'title' => __('Price', 'mfn-opts'),
   					),

   					array(
   						'id' => 'price',
   						'type' => 'text',
   						'title' => __('Price', 'mfn-opts'),
   						'class' => 'narrow',
   						'edit_tag' => '.price | span',
   						'edit_position' => 'append',
							'std' => '99',
							'preview' => 'number',
   					),

   					array(
   						'id' => 'currency',
   						'edit_tag' => '.price | sup.currency',
   						'edit_position' => 'prepend',
   						'type' => 'text',
   						'title' => __('Currency', 'mfn-opts'),
   						'class' => 'narrow',
   					),

   					array(
   						'id' => 'currency_pos',
   						're_render' => 'tabs',
   						'type' => 'switch',
   						'title' => __('Currency position', 'mfn-opts'),
   						'options' => array(
   							'' => __('Left', 'mfn-opts'),
   							'right' => __('Right', 'mfn-opts'),
   						),
							'std' => '',
   					),

   					array(
   						'id' => 'period',
   						'type' => 'text',
   						'edit_tag' => '.price | .period',
   						'edit_position' => 'append',
   						'title' => __('Period', 'mfn-opts'),
							'class' => 'narrow',
   					),

   					// description

   					array(
   						'title' => __('Description', 'mfn-opts'),
   					),

   					array(
   						'id' => 'subtitle',
   						'edit_tag' => '.plan-header | p.subtitle',
   						'edit_position' => 'append',
   						'type' => 'text',
   						'title' => __('Subtitle', 'mfn-opts'),
   					),

						array(
   						'id' => 'content',
   						'type' => 'textarea',
   						'edit_tag' => '.plan-inside | span.pi-content',
   						'edit_position' => 'prepend',
   						'title' => __('Content', 'mfn-opts'),
   						'desc' => __('HTML tags allowed', 'mfn-opts'),
   						'preview' => 'content',
							'class' => 'form-content-full-width',
   					),

						array(
   						'id' => 'tabs',
   						'type' => 'tabs',
   						'title' => __('List', 'mfn-opts'),
							'options' => [
								'title' => [
									'input',
									__('Title', 'mfn-opts'),
									'List item',
								],
							],
							'std' => [
								0 => [
									'title' => __('This is the 1st item', 'mfn-opts'),
								],
								1 => [
									'title' => __('This is the 2nd item', 'mfn-opts'),
								],
							],
							'preview' => 'tabs',
   					),

   					// button

   					array(
   						'title' => __('Button', 'mfn-opts'),
   					),

   					array(
   						'id' => 'link_title',
   						're_render' => 'tabs',
   						'type' => 'text',
   						'title' => __('Title', 'mfn-opts'),
   					),

   					array(
   						'id' => 'icon',
   						're_render' => 'tabs',
   						'type' => 'icon',
   						'title' => __('Icon', 'mfn-opts'),
   					),

   					array(
   						'id' => 'link',
   						're_render' => 'tabs',
   						'type' => 'text',
   						'title' => __('Link', 'mfn-opts'),
   						'desc' => __('Button will appear only if this field is filled.', 'mfn-opts'),
   					),

   					array(
   						'id' => 'target',
   						'type' => 'select',
   						'title' => __('Link target', 'mfn-opts'),
   						'options' => array(
   							0 => __('Default | _self', 'mfn-opts'),
   							1 => __('New tab or window | _blank', 'mfn-opts'),
   							'lightbox' => __('Lightbox (image or embed video)', 'mfn-opts'),
   						),
   					),

   					// style

   					array(
   						'title' => __('Style', 'mfn-opts'),
   					),

   					array(
   						'id' => 'style',
   						're_render' => 'tabs',
   						'type' => 'switch',
   						'title' => __('Style', 'mfn-opts'),
   						'options' => array(
   							'box' => __('Box', 'mfn-opts'),
   							'table' => __('Table', 'mfn-opts'),
								'label' => __('Table label', 'mfn-opts'),
   						),
							'std' => 'box',
   					),

						// deprecated

   					array(
   						'class' => 'mfn-deprecated',
   						'title' => __('Deprecated', 'mfn-opts'),
   					),

   					array(
   						'id' => 'featured',
   						'class' => 'mfn-deprecated',
   						'type' => 'switch',
   						'title' => __('Featured', 'mfn-opts'),
   						'options' => array(
   							'' => __('Default', 'mfn-opts'),
   							1 => __('Featured', 'mfn-opts'),
   						),
							'std' => '',
   					),

						array(
							'id' => 'class',
							'type' => 'pills',
							'title' => __('Element classes', 'mfn-opts'),
							'class' => 'mfn-deprecated',
						),

						array(
							'type' => 'html',
							'html' => '</div><div class="modalbox-card modalbox-card-style modalbox-re_render modalbox-card-style-mfnuidhere">',
						),

						array(
							'class' => 'toggled_header',
   						'title' => __('Container', 'mfn-opts'),
   					),

						array(
   						'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .pricing-box:text-align',
							'responsive' => 'desktop',
   						'type' => 'switch',
   						'class' => 'mfn-toggled mfn_field_desktop',
   						'title' => __('Align', 'mfn-opts'),
   						'options' => array(
   							'' => __('Default', 'mfn-opts'),
   							'left' => __('Left', 'mfn-opts'),
								'center' => __('Center', 'mfn-opts'),
   							'right' => __('Right', 'mfn-opts'),
   							'justify' => __('Justify', 'mfn-opts'),
   						),
							'preview' => 'align',
   					),

   					array(
   						'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .pricing-box:text-align_tablet',
							'responsive' => 'tablet',
   						'type' => 'switch',
   						'class' => 'mfn-toggled mfn_field_tablet',
   						'title' => __('Align', 'mfn-opts'),
   						'options' => array(
   							'' => __('Default', 'mfn-opts'),
   							'left' => __('Left', 'mfn-opts'),
								'center' => __('Center', 'mfn-opts'),
   							'right' => __('Right', 'mfn-opts'),
   							'justify' => __('Justify', 'mfn-opts'),
   						),
							'preview' => 'align',
   					),

   					array(
   						'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .pricing-box:text-align_mobile',
							'responsive' => 'mobile',
   						'type' => 'switch',
   						'class' => 'mfn-toggled mfn_field_mobile',
   						'title' => __('Align', 'mfn-opts'),
   						'options' => array(
   							'' => __('Default', 'mfn-opts'),
   							'left' => __('Left', 'mfn-opts'),
								'center' => __('Center', 'mfn-opts'),
   							'right' => __('Right', 'mfn-opts'),
   							'justify' => __('Justify', 'mfn-opts'),
   						),
							'preview' => 'align',
   					),

   					array(
							'class' => 'toggled_header',
   						'title' => __('Image', 'mfn-opts'),
   					),

		  			array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .pricing-box .plan-header .image:border-style',
							'attr_id' => 'border_style_pricing_box',
							'type' => 'select',
							'class' => 'mfn-toggled',
							'title' => __('Border style', 'mfn-opts'),
							'options' => [
								'none' => __('None', 'mfn-opts'),
								'solid' => __('Solid', 'mfn-opts'),
								'dashed' => __('Dashed', 'mfn-opts'),
								'dotted' => __('Dotted', 'mfn-opts'),
								'double' => __('Double', 'mfn-opts'),
							],
						),

						array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .pricing-box .plan-header .image:border-color',
							'condition' => array( 'id' => 'border_style_pricing_box', 'opt' => 'isnt', 'val' => 'none' ),
							'type' => 'color',
							'class' => 'mfn-toggled',
							'title' => __('Border color', 'mfn-opts'),
						),

						array(
		  				'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .pricing-box .plan-header .image:border-width',
		  				'condition' => array( 'id' => 'border_style_pricing_box', 'opt' => 'isnt', 'val' => 'none' ),
		  				'type' => 'dimensions',
		  				'title' => __('Border width', 'mfn-opts'),
							'responsive' => 'desktop',
							'class' => 'mfn_field_desktop mfn-toggled',
							'css_attr' => 'border-width',
		  			),

		  			array(
		  				'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .pricing-box .plan-header .image:border-width_tablet',
		  				'condition' => array( 'id' => 'border_style_pricing_box', 'opt' => 'isnt', 'val' => 'none' ),
		  				'type' => 'dimensions',
		  				'title' => __('Border width', 'mfn-opts'),
							'responsive' => 'tablet',
							'class' => 'mfn_field_tablet mfn-toggled',
							'css_attr' => 'border-width',
		  			),

		  			array(
		  				'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .pricing-box .plan-header .image:border-width_mobile',
		  				'condition' => array( 'id' => 'border_style_pricing_box', 'opt' => 'isnt', 'val' => 'none' ),
		  				'type' => 'dimensions',
		  				'title' => __('Border width', 'mfn-opts'),
							'responsive' => 'mobile',
							'class' => 'mfn_field_mobile mfn-toggled',
							'css_attr' => 'border-width',
		  			),

						array(
		  				'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .pricing-box .plan-header .image:border-radius',
		  				'type' => 'dimensions',
		  				'title' => __('Border radius', 'mfn-opts'),
							'responsive' => 'desktop',
							'class' => 'mfn_field_desktop mfn-toggled',
							'css_attr' => 'border-radius',
		  			),

		  			array(
		  				'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .pricing-box .plan-header .image:border-radius_tablet',
		  				'type' => 'dimensions',
		  				'title' => __('Border radius', 'mfn-opts'),
							'responsive' => 'tablet',
							'class' => 'mfn_field_tablet mfn-toggled',
							'css_attr' => 'border-radius',
		  			),

		  			array(
		  				'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .pricing-box .plan-header .image:border-radius_mobile',
		  				'type' => 'dimensions',
		  				'title' => __('Border radius', 'mfn-opts'),
							'responsive' => 'mobile',
							'class' => 'mfn_field_mobile mfn-toggled',
							'css_attr' => 'border-radius',
		  			),

		  			array(
		  				'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .pricing-box .plan-header .image:margin',
		  				'type' => 'dimensions',
		  				'title' => __('Margin', 'mfn-opts'),
							'responsive' => 'desktop',
							'version' => 'separated-fields',
							'class' => 'mfn_field_desktop mfn-toggled',
							'css_attr' => 'margin',
		  			),

		  			array(
		  				'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .pricing-box .plan-header .image:margin_tablet',
		  				'type' => 'dimensions',
		  				'title' => __('Margin', 'mfn-opts'),
							'responsive' => 'tablet',
							'version' => 'separated-fields',
							'class' => 'mfn_field_tablet mfn-toggled',
							'css_attr' => 'margin',
		  			),

		  			array(
		  				'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .pricing-box .plan-header .image:margin_mobile',
		  				'type' => 'dimensions',
		  				'title' => __('Margin', 'mfn-opts'),
							'responsive' => 'mobile',
							'version' => 'separated-fields',
							'class' => 'mfn_field_mobile mfn-toggled',
							'css_attr' => 'margin',
		  			),

		  			array(
							'class' => 'toggled_header',
   						'title' => __('Title', 'mfn-opts'),
   					),

						array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .pricing-box .plan-header h2:color',
							'type' => 'color',
							'class' => 'mfn-toggled',
							'title' => __('Color', 'mfn-opts'),
						),

						array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .pricing-box .plan-header h2:typography',
							'type' => 'typography_vb',
							'label_after' => '<a href="#" title="Edit" class="mfn-option-btn mfn-option-blank btn-medium mfn-vb-label-button"><span class="mfn-icon mfn-icon-edit"></span></a>',
							'class' => 'mfn-toggled toggle_fields',
							'title' => __('Typography', 'mfn-opts'),
						),

						array(
		  				'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .pricing-box .plan-header h2:margin',
		  				'type' => 'dimensions',
		  				'title' => __('Margin', 'mfn-opts'),
							'responsive' => 'desktop',
							'version' => 'separated-fields',
							'class' => 'mfn_field_desktop mfn-toggled',
							'css_attr' => 'margin',
		  			),

		  			array(
		  				'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .pricing-box .plan-header h2:margin_tablet',
		  				'type' => 'dimensions',
		  				'title' => __('Margin', 'mfn-opts'),
							'responsive' => 'tablet',
							'version' => 'separated-fields',
							'class' => 'mfn_field_tablet mfn-toggled',
							'css_attr' => 'margin',
		  			),

		  			array(
		  				'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .pricing-box .plan-header h2:margin_mobile',
		  				'type' => 'dimensions',
		  				'title' => __('Margin', 'mfn-opts'),
							'responsive' => 'mobile',
							'version' => 'separated-fields',
							'class' => 'mfn_field_mobile mfn-toggled',
							'css_attr' => 'margin',
		  			),

		  			array(
							'class' => 'toggled_header',
   						'title' => __('Price', 'mfn-opts'),
   					),

						array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .pricing-box .plan-header .price sup.currency,.mcb-section .mcb-wrap .mcb-item-mfnuidelement  .pricing-box .plan-header .price span:color',
							'type' => 'color',
							'class' => 'mfn-toggled',
							'title' => __('Color', 'mfn-opts'),
						),

						array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .pricing-box .plan-header .price sup.currency,.mcb-section .mcb-wrap .mcb-item-mfnuidelement .pricing-box .plan-header .price span:typography',
							'type' => 'typography_vb',
							'label_after' => '<a href="#" title="Edit" class="mfn-option-btn mfn-option-blank btn-medium mfn-vb-label-button"><span class="mfn-icon mfn-icon-edit"></span></a>',
							'class' => 'mfn-toggled toggle_fields',
							'title' => __('Typography', 'mfn-opts'),
						),

						array(
		  				'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .pricing-box .plan-header .price:margin',
		  				'type' => 'dimensions',
		  				'title' => __('Margin', 'mfn-opts'),
							'responsive' => 'desktop',
							'version' => 'separated-fields',
							'class' => 'mfn_field_desktop mfn-toggled',
							'css_attr' => 'margin',
		  			),

		  			array(
		  				'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .pricing-box .plan-header .price:margin_tablet',
		  				'type' => 'dimensions',
		  				'title' => __('Margin', 'mfn-opts'),
							'responsive' => 'tablet',
							'version' => 'separated-fields',
							'class' => 'mfn_field_tablet mfn-toggled',
							'css_attr' => 'margin',
		  			),

		  			array(
		  				'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .pricing-box .plan-header .price:margin_mobile',
		  				'type' => 'dimensions',
		  				'title' => __('Margin', 'mfn-opts'),
							'responsive' => 'mobile',
							'version' => 'separated-fields',
							'class' => 'mfn_field_mobile mfn-toggled',
							'css_attr' => 'margin',
		  			),

		  			array(
							'class' => 'toggled_header',
   						'title' => __('Price currency', 'mfn-opts'),
   					),

						array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .pricing-box .plan-header .price sup.currency:color',
							'type' => 'color',
							'class' => 'mfn-toggled',
							'title' => __('Color', 'mfn-opts'),
						),

						array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .pricing-box .plan-header .price sup.currency:typography',
							'type' => 'typography_vb',
							'label_after' => '<a href="#" title="Edit" class="mfn-option-btn mfn-option-blank btn-medium mfn-vb-label-button"><span class="mfn-icon mfn-icon-edit"></span></a>',
							'class' => 'mfn-toggled toggle_fields',
							'title' => __('Typography', 'mfn-opts'),
						),

						array(
							'class' => 'toggled_header',
   						'title' => __('Price period', 'mfn-opts'),
   					),

						array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .pricing-box .plan-header .price sup.period:color',
							'type' => 'color',
							'class' => 'mfn-toggled',
							'title' => __('Color', 'mfn-opts'),
						),

						array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .pricing-box .plan-header .price sup.period:typography',
							'type' => 'typography_vb',
							'label_after' => '<a href="#" title="Edit" class="mfn-option-btn mfn-option-blank btn-medium mfn-vb-label-button"><span class="mfn-icon mfn-icon-edit"></span></a>',
							'class' => 'mfn-toggled toggle_fields',
							'title' => __('Typography', 'mfn-opts'),
						),

						array(
							'class' => 'toggled_header',
   						'title' => __('Decoration', 'mfn-opts'),
   					),

						array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .pricing-box .plan-header hr:background-color',
							'type' => 'color',
							'class' => 'mfn-toggled',
							'title' => __('Color', 'mfn-opts'),
						),

						array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .pricing-box .plan-header hr:width',
							'type' => 'text',
							'default_unit' => 'px',
							'class' => 'mfn-toggled',
							'title' => __('Width', 'mfn-opts'),
						),

						array(
							'class' => 'toggled_header',
   						'title' => __('Subtitle', 'mfn-opts'),
   					),

						array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .pricing-box .plan-header p.subtitle:color',
							'type' => 'color',
							'class' => 'mfn-toggled',
							'title' => __('Color', 'mfn-opts'),
						),

						array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .pricing-box .plan-header p.subtitle:typography',
							'type' => 'typography_vb',
							'label_after' => '<a href="#" title="Edit" class="mfn-option-btn mfn-option-blank btn-medium mfn-vb-label-button"><span class="mfn-icon mfn-icon-edit"></span></a>',
							'class' => 'mfn-toggled toggle_fields',
							'title' => __('Typography', 'mfn-opts'),
						),

						array(
							'class' => 'toggled_header',
   						'title' => __('Content', 'mfn-opts'),
   					),

						array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .pricing-box .plan-inside .pi-content:color',
							'type' => 'color',
							'class' => 'mfn-toggled',
							'title' => __('Color', 'mfn-opts'),
						),

						array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .pricing-box .plan-inside .pi-content:typography',
							'type' => 'typography_vb',
							'label_after' => '<a href="#" title="Edit" class="mfn-option-btn mfn-option-blank btn-medium mfn-vb-label-button"><span class="mfn-icon mfn-icon-edit"></span></a>',
							'class' => 'mfn-toggled toggle_fields',
							'title' => __('Typography', 'mfn-opts'),
						),

						array(
		  				'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .pricing-box .plan-inside .pi-content:margin',
		  				'type' => 'dimensions',
		  				'title' => __('Margin', 'mfn-opts'),
							'responsive' => 'desktop',
							'version' => 'separated-fields',
							'class' => 'mfn_field_desktop mfn-toggled',
							'css_attr' => 'margin',
		  			),

		  			array(
		  				'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .pricing-box .plan-inside .pi-content:margin_tablet',
		  				'type' => 'dimensions',
		  				'title' => __('Margin', 'mfn-opts'),
							'responsive' => 'tablet',
							'version' => 'separated-fields',
							'class' => 'mfn_field_tablet mfn-toggled',
							'css_attr' => 'margin',
		  			),

		  			array(
		  				'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .pricing-box .plan-inside .pi-content:margin_mobile',
		  				'type' => 'dimensions',
		  				'title' => __('Margin', 'mfn-opts'),
							'responsive' => 'mobile',
							'version' => 'separated-fields',
							'class' => 'mfn_field_mobile mfn-toggled',
							'css_attr' => 'margin',
		  			),

		  			array(
							'class' => 'toggled_header',
   						'title' => __('List', 'mfn-opts'),
   					),

   					array(
		  				'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .pricing-box .plan-inside ul:margin',
		  				'type' => 'dimensions',
		  				'title' => __('Margin', 'mfn-opts'),
							'responsive' => 'desktop',
							'version' => 'separated-fields',
							'class' => 'mfn_field_desktop mfn-toggled',
							'css_attr' => 'margin',
		  			),

		  			array(
		  				'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .pricing-box .plan-inside ul:margin_tablet',
		  				'type' => 'dimensions',
		  				'title' => __('Margin', 'mfn-opts'),
							'responsive' => 'tablet',
							'version' => 'separated-fields',
							'class' => 'mfn_field_tablet mfn-toggled',
							'css_attr' => 'margin',
		  			),

		  			array(
		  				'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .pricing-box .plan-inside ul:margin_mobile',
		  				'type' => 'dimensions',
		  				'title' => __('Margin', 'mfn-opts'),
							'responsive' => 'mobile',
							'version' => 'separated-fields',
							'class' => 'mfn_field_mobile mfn-toggled',
							'css_attr' => 'margin',
		  			),

		  			array(
							'class' => 'toggled_header',
   						'title' => __('List row', 'mfn-opts'),
   					),

   					array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .pricing-box .plan-inside ul li:color',
							'type' => 'color',
							'class' => 'mfn-toggled',
							'title' => __('Color', 'mfn-opts'),
						),

   					array(
   						'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .pricing-box .plan-inside ul li:text-align',
							'responsive' => 'desktop',
   						'type' => 'switch',
   						'class' => 'mfn-toggled mfn_field_desktop',
   						'title' => __('Align', 'mfn-opts'),
   						'options' => array(
   							'' => __('Default', 'mfn-opts'),
   							'left' => __('Left', 'mfn-opts'),
								'center' => __('Center', 'mfn-opts'),
   							'right' => __('Right', 'mfn-opts'),
   							'justify' => __('Justify', 'mfn-opts'),
   						),
							'preview' => 'align',
   					),

   					array(
   						'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .pricing-box .plan-inside ul li:text-align_tablet',
							'responsive' => 'tablet',
   						'type' => 'switch',
   						'class' => 'mfn-toggled mfn_field_tablet',
   						'title' => __('Align', 'mfn-opts'),
   						'options' => array(
   							'' => __('Default', 'mfn-opts'),
   							'left' => __('Left', 'mfn-opts'),
								'center' => __('Center', 'mfn-opts'),
   							'right' => __('Right', 'mfn-opts'),
   							'justify' => __('Justify', 'mfn-opts'),
   						),
							'preview' => 'align',
   					),

   					array(
   						'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .pricing-box .plan-inside ul li:text-align_mobile',
							'responsive' => 'mobile',
   						'type' => 'switch',
   						'class' => 'mfn-toggled mfn_field_mobile',
   						'title' => __('Align', 'mfn-opts'),
   						'options' => array(
   							'' => __('Default', 'mfn-opts'),
   							'left' => __('Left', 'mfn-opts'),
								'center' => __('Center', 'mfn-opts'),
   							'right' => __('Right', 'mfn-opts'),
   							'justify' => __('Justify', 'mfn-opts'),
   						),
							'preview' => 'align',
   					),

   					array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .pricing-box .plan-inside ul li:border-style',
							'attr_id' => 'border_style_pricing_li',
							'type' => 'select',
							'class' => 'mfn-toggled',
							'title' => __('Border style', 'mfn-opts'),
							'options' => [
								'none' => __('None', 'mfn-opts'),
								'solid' => __('Solid', 'mfn-opts'),
								'dashed' => __('Dashed', 'mfn-opts'),
								'dotted' => __('Dotted', 'mfn-opts'),
								'double' => __('Double', 'mfn-opts'),
							],
						),

						array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .pricing-box .plan-inside ul li:border-color',
							'condition' => array( 'id' => 'border_style_pricing_li', 'opt' => 'isnt', 'val' => 'none' ),
							'type' => 'color',
							'class' => 'mfn-toggled',
							'title' => __('Border color', 'mfn-opts'),
						),

						array(
		  				'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .pricing-box .plan-inside ul li:border-width',
		  				'condition' => array( 'id' => 'border_style_pricing_li', 'opt' => 'isnt', 'val' => 'none' ),
		  				'type' => 'dimensions',
		  				'title' => __('Border width', 'mfn-opts'),
							'responsive' => 'desktop',
							'class' => 'mfn_field_desktop mfn-toggled',
							'css_attr' => 'border-width',
		  			),

		  			array(
		  				'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .pricing-box .plan-inside ul li:border-width_tablet',
		  				'condition' => array( 'id' => 'border_style_pricing_li', 'opt' => 'isnt', 'val' => 'none' ),
		  				'type' => 'dimensions',
		  				'title' => __('Border width', 'mfn-opts'),
							'responsive' => 'tablet',
							'class' => 'mfn_field_tablet mfn-toggled',
							'css_attr' => 'border-width',
		  			),

		  			array(
		  				'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .pricing-box .plan-inside ul li:border-width_mobile',
		  				'condition' => array( 'id' => 'border_style_pricing_li', 'opt' => 'isnt', 'val' => 'none' ),
		  				'type' => 'dimensions',
		  				'title' => __('Border width', 'mfn-opts'),
							'responsive' => 'mobile',
							'class' => 'mfn_field_mobile mfn-toggled',
							'css_attr' => 'border-width',
		  			),

						array(
		  				'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .pricing-box .plan-inside ul li:border-radius',
		  				'type' => 'dimensions',
		  				'title' => __('Border radius', 'mfn-opts'),
							'responsive' => 'desktop',
							'class' => 'mfn_field_desktop mfn-toggled',
							'css_attr' => 'border-radius',
		  			),

		  			array(
		  				'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .pricing-box .plan-inside ul li:border-radius_tablet',
		  				'type' => 'dimensions',
		  				'title' => __('Border radius', 'mfn-opts'),
							'responsive' => 'tablet',
							'class' => 'mfn_field_tablet mfn-toggled',
							'css_attr' => 'border-radius',
		  			),

		  			array(
		  				'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .pricing-box .plan-inside ul li:border-radius_mobile',
		  				'type' => 'dimensions',
		  				'title' => __('Border radius', 'mfn-opts'),
							'responsive' => 'mobile',
							'class' => 'mfn_field_mobile mfn-toggled',
							'css_attr' => 'border-radius',
		  			),

   					array(
		  				'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .pricing-box .plan-inside ul li:margin',
		  				'type' => 'dimensions',
		  				'title' => __('Margin', 'mfn-opts'),
							'responsive' => 'desktop',
							'version' => 'separated-fields',
							'class' => 'mfn_field_desktop mfn-toggled',
							'css_attr' => 'margin',
		  			),

		  			array(
		  				'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .pricing-box .plan-inside ul li:margin_tablet',
		  				'type' => 'dimensions',
		  				'title' => __('Margin', 'mfn-opts'),
							'responsive' => 'tablet',
							'version' => 'separated-fields',
							'class' => 'mfn_field_tablet mfn-toggled',
							'css_attr' => 'margin',
		  			),

		  			array(
		  				'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .pricing-box .plan-inside ul li:margin_mobile',
		  				'type' => 'dimensions',
		  				'title' => __('Margin', 'mfn-opts'),
							'responsive' => 'mobile',
							'version' => 'separated-fields',
							'class' => 'mfn_field_mobile mfn-toggled',
							'css_attr' => 'margin',
		  			),

		  			array(
		  				'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .pricing-box .plan-inside ul li:padding',
		  				'type' => 'dimensions',
		  				'title' => __('Padding', 'mfn-opts'),
							'responsive' => 'desktop',
							'version' => 'separated-fields',
							'class' => 'mfn_field_desktop mfn-toggled',
							'css_attr' => 'padding',
		  			),

		  			array(
		  				'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .pricing-box .plan-inside ul li:padding_tablet',
		  				'type' => 'dimensions',
		  				'title' => __('Padding', 'mfn-opts'),
							'responsive' => 'tablet',
							'version' => 'separated-fields',
							'class' => 'mfn_field_tablet mfn-toggled',
							'css_attr' => 'padding',
		  			),

		  			array(
		  				'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .pricing-box .plan-inside ul li:padding_mobile',
		  				'type' => 'dimensions',
		  				'title' => __('Padding', 'mfn-opts'),
							'responsive' => 'mobile',
							'version' => 'separated-fields',
							'class' => 'mfn_field_mobile mfn-toggled',
							'css_attr' => 'padding',
		  			),

		  			array(
							'class' => 'toggled_header',
   						'title' => __('Button', 'mfn-opts'),
   					),

		  			array(
		  				'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .pricing-box .plan-footer a.button:padding',
		  				'type' => 'dimensions',
		  				'version' => 'separated-fields',
		  				'title' => __('Padding', 'mfn-opts'),
							'responsive' => 'desktop',
							'class' => 'mfn_field_desktop mfn-toggled',
							'css_attr' => 'padding',
		  			),

		  			array(
		  				'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .pricing-box .plan-footer a.button:padding_tablet',
		  				'type' => 'dimensions',
		  				'version' => 'separated-fields',
		  				'title' => __('Padding', 'mfn-opts'),
							'responsive' => 'tablet',
							'class' => 'mfn_field_tablet mfn-toggled',
							'css_attr' => 'padding',
		  			),

		  			array(
		  				'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .pricing-box .plan-footer a.button:padding_mobile',
		  				'type' => 'dimensions',
		  				'version' => 'separated-fields',
		  				'title' => __('Padding', 'mfn-opts'),
							'responsive' => 'mobile',
							'class' => 'mfn_field_mobile mfn-toggled',
							'css_attr' => 'padding',
		  			),

		  			array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .pricing-box .plan-footer a.button:typography',
							'type' => 'typography_vb',
							'label_after' => '<a href="#" title="Edit" class="mfn-option-btn mfn-option-blank btn-medium mfn-vb-label-button"><span class="mfn-icon mfn-icon-edit"></span></a>',
							'class' => 'mfn-toggled toggle_fields',
							'title' => __('Typography', 'mfn-opts'),
						),

						array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .pricing-box .plan-footer a.button:border-style',
							'attr_id' => 'border_style_pricing_button',
							'type' => 'select',
							'class' => 'mfn-toggled',
							'title' => __('Border style', 'mfn-opts'),
							'options' => [
								'none' => __('None', 'mfn-opts'),
								'solid' => __('Solid', 'mfn-opts'),
								'dashed' => __('Dashed', 'mfn-opts'),
								'dotted' => __('Dotted', 'mfn-opts'),
								'double' => __('Double', 'mfn-opts'),
							],
						),

						array(
		  				'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .pricing-box .plan-footer a.button:border-width',
		  				'condition' => array( 'id' => 'border_style_pricing_button', 'opt' => 'isnt', 'val' => 'none' ),
		  				'type' => 'dimensions',
		  				'title' => __('Border width', 'mfn-opts'),
							'responsive' => 'desktop',
							'class' => 'mfn_field_desktop mfn-toggled',
							'css_attr' => 'border-width',
		  			),

		  			array(
		  				'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .pricing-box .plan-footer a.button:border-width_tablet',
		  				'condition' => array( 'id' => 'border_style_pricing_button', 'opt' => 'isnt', 'val' => 'none' ),
		  				'type' => 'dimensions',
		  				'title' => __('Border width', 'mfn-opts'),
							'responsive' => 'tablet',
							'class' => 'mfn_field_tablet mfn-toggled',
							'css_attr' => 'border-width',
		  			),

		  			array(
		  				'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .pricing-box .plan-footer a.button:border-width_mobile',
		  				'condition' => array( 'id' => 'border_style_pricing_button', 'opt' => 'isnt', 'val' => 'none' ),
		  				'type' => 'dimensions',
		  				'title' => __('Border width', 'mfn-opts'),
							'responsive' => 'mobile',
							'class' => 'mfn_field_mobile mfn-toggled',
							'css_attr' => 'border-width',
		  			),

						array(
		  				'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .pricing-box .plan-footer a.button:border-radius',
		  				'type' => 'dimensions',
		  				'title' => __('Border radius', 'mfn-opts'),
							'responsive' => 'desktop',
							'class' => 'mfn_field_desktop mfn-toggled',
							'css_attr' => 'border-radius',
		  			),

		  			array(
		  				'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .pricing-box .plan-footer a.button:border-radius_tablet',
		  				'type' => 'dimensions',
		  				'title' => __('Border radius', 'mfn-opts'),
							'responsive' => 'tablet',
							'class' => 'mfn_field_tablet mfn-toggled',
							'css_attr' => 'border-radius',
		  			),

		  			array(
		  				'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .pricing-box .plan-footer a.button:border-radius_mobile',
		  				'type' => 'dimensions',
		  				'title' => __('Border radius', 'mfn-opts'),
							'responsive' => 'mobile',
							'class' => 'mfn_field_mobile mfn-toggled',
							'css_attr' => 'border-radius',
		  			),

   					array(
							'type' => 'html',
							'html' => '<div class="mfn-form-row mfn-sidebar-fields-tabs mfn-toggled mfn-vb-formrow mfn-vb-mfnuidhere"><ul class="mfn-sft-nav"><li class="active"><a href="#normal" data-tab="normal">Normal</a></li><li><a href="#hover" data-tab="hover">Hover</a></li></ul><div class="mfn-sft mfn-sft-normal">',
						),

						array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .pricing-box .plan-footer a.button:color',
							'type' => 'color',
							'class' => 'main-color mfn-toggled',
							'title' => __('Color', 'mfn-opts'),
						),

						array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .pricing-box .plan-footer a.button:border-color',
							'condition' => array( 'id' => 'border_style_pricing_button', 'opt' => 'isnt', 'val' => 'none' ),
							'type' => 'color',
							'class' => 'mfn-toggled',
							'title' => __('Border color', 'mfn-opts'),
						),

						array(
							'id' => 'background_switcher',
							'attr_id' => 'background_switcher_pricing_bg',
							'type' => 'switch',
							'class' => 'mfn-fields-switcher',
							'title' => __('Background type', 'mfn-opts'),
							'options' => array(
		  					'default' => __('Default', 'mfn-opts'),
		  					'gradient' 	=> __('Gradient', 'mfn-opts'),
		  				),
							'visual_options' => array(
		  					'default' => '',
		  					'gradient' 	=> '',
		  				),
		  				'std' => 'default',
						),

						array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .pricing-box .plan-footer a.button:background-color',
							'condition' => array( 'id' => 'background_switcher_pricing_bg', 'opt' => 'is', 'val' => 'default' ),
							'type' => 'color',
							'title' => __('Background color', 'mfn-opts'),
						),

						array(
		  				'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .pricing-box .plan-footer a.button:gradient',
		  				'condition' => array( 'id' => 'background_switcher_pricing_bg', 'opt' => 'is', 'val' => 'gradient' ),
		  				'type' => 'gradient',
		  				'title' => __('Gradient', 'mfn-opts'),
		  				'class' => 'mfn-toggled',
							'css_attr' => 'gradient',
		  			),

						array(
							'type' => 'html',
							'html' => '</div><div class="mfn-sft mfn-sft-hover">',
						),

						array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .pricing-box .plan-footer a.button|hover:color',
							'type' => 'color',
							'class' => 'main-color mfn-toggled',
							'title' => __('Color', 'mfn-opts'),
						),

						array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .pricing-box .plan-footer a.button|hover:border-color',
							'condition' => array( 'id' => 'background_switcher_pricing_bg', 'opt' => 'isnt', 'val' => 'none' ),
							'type' => 'color',
							'class' => 'mfn-toggled',
							'title' => __('Border color', 'mfn-opts'),
						),

						array(
							'id' => 'background_switcher_hover',
							'attr_id' => 'background_switcher_hover_pricing_bg',
							'type' => 'switch',
							'class' => 'mfn-fields-switcher',
							'title' => __('Background type', 'mfn-opts'),
							'options' => array(
		  					'default' => __('Default', 'mfn-opts'),
		  					'gradient' 	=> __('Gradient', 'mfn-opts'),
		  				),
							'visual_options' => array(
		  					'default' => '',
		  					'gradient' 	=> '',
		  				),
		  				'std' => 'default',
						),

						array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .pricing-box .plan-footer a.button|hover:background',
							'condition' => array( 'id' => 'background_switcher_hover_pricing_bg', 'opt' => 'is', 'val' => 'default' ),
							'type' => 'color',
							'class' => 'main-color mfn-toggled',
							'title' => __('Background color', 'mfn-opts'),
						),

						array(
		  				'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .pricing-box .plan-footer a.button|hover:gradient',
		  				'condition' => array( 'id' => 'background_switcher_hover_pricing_bg', 'opt' => 'is', 'val' => 'gradient' ),
		  				'type' => 'gradient',
		  				'title' => __('Gradient', 'mfn-opts'),
		  				'class' => 'mfn-toggled',
							'css_attr' => 'gradient',
		  			),

						array(
							'type' => 'html',
							'html' => '</div></div>',
						),

						array(
							'type' => 'html',
							'html' => '</div>',
						),

   				),
   			),

   			// Progress Bars  -------------------------------------------------

   			'progress_bars' => array(
   				'type' => 'progress_bars',
   				'title' => __('Progress Bars', 'mfn-opts'),
   				'size' => '1/4',
   				'tablet_size' => '1/4',
   				'mobile_size' => '1/1',
   				'tablet_resized' => '0',
   				'cat' => 'boxes',
   				'fields' => array(

   					array(
							'type' => 'html',
							'html' => $this->itemtabs,
						),

   					array(
							'type' => 'html',
							'html' => '<div class="modalbox-card modalbox-re_render modalbox-card-content-mfnuidhere active">',
						),

   					array(
   						'id' => 'title',
   						'type' => 'text',
   						'edit_tag' => '.progress_bars | h4.title',
   						'edit_position' => 'prepend',
   						'title' => __('Title', 'mfn-opts'),
							'std' => __('This is the title', 'mfn-opts'),
							'preview' => 'title',
   					),

						array(
   						'id' => 'tabs',
   						'type' => 'tabs',
   						'title' => __('Bars', 'mfn-opts'),
							'options' => [
								'title' => [
									'input',
									__('Title', 'mfn-opts'),
									__('Bar item', 'mfn-opts'),
								],
								'value' => [
									'input',
									__('Value', 'mfn-opts'),
									'50',
								],
								'size' => [
									'input',
									__('Size', 'mfn-opts'),
									'20',
								],
								'color' => [
									'input',
									__('Color (optional)', 'mfn-opts'),
									'',
								],
							],
							'std' => [
								0 => [
									'title' => 'This is the 1st bar',
									'value' => '50',
									'size' => '10',
									'color' => '#72a5d8',
								],
								1 => [
									'title' => 'This is the 2nd bar',
									'value' => '30',
									'size' => '15',
									'color' => 'grey',
								],
							],
							'preview' => 'tabs',
   					),

   					array(
   						'id' => 'content',
   						'edit_tag' => '.bars_list | ul.pb-desc',
   						'edit_position' => 'append',
   						'type' => 'textarea',
   						'title' => __('Content', 'mfn-opts'),
							'class' => 'form-content-full-width',
   					),

						// deprecated

						array(
							'class' => 'mfn-deprecated',
							'title' => __('Deprecated', 'mfn-opts'),
						),

						array(
							'id' => 'class',
							'type' => 'pills',
							'title' => __('Element classes', 'mfn-opts'),
							'class' => 'mfn-deprecated',
						),

						array(
							'type' => 'html',
							'html' => '</div><div class="modalbox-card modalbox-card-style modalbox-re_render modalbox-card-style-mfnuidhere">',
						),

						array(
							'class' => 'toggled_header',
   						'title' => __('Title', 'mfn-opts'),
   					),

						array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .progress_bars h4.title:color',
							'type' => 'color',
							'class' => 'mfn-toggled',
							'title' => __('Color', 'mfn-opts'),
						),

						array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .progress_bars h4.title:typography',
							'type' => 'typography_vb',
							'label_after' => '<a href="#" title="Edit" class="mfn-option-btn mfn-option-blank btn-medium mfn-vb-label-button"><span class="mfn-icon mfn-icon-edit"></span></a>',
							'class' => 'mfn-toggled toggle_fields',
							'title' => __('Typography', 'mfn-opts'),
						),

						array(
		  				'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .progress_bars h4.title:margin',
		  				'type' => 'dimensions',
		  				'title' => __('Margin', 'mfn-opts'),
							'responsive' => 'desktop',
							'version' => 'separated-fields',
							'class' => 'mfn_field_desktop mfn-toggled',
							'css_attr' => 'margin',
		  			),

		  			array(
		  				'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .progress_bars h4.title:margin_tablet',
		  				'type' => 'dimensions',
		  				'title' => __('Margin', 'mfn-opts'),
							'responsive' => 'tablet',
							'version' => 'separated-fields',
							'class' => 'mfn_field_tablet mfn-toggled',
							'css_attr' => 'margin',
		  			),

		  			array(
		  				'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .progress_bars h4.title:margin_mobile',
		  				'type' => 'dimensions',
		  				'title' => __('Margin', 'mfn-opts'),
							'responsive' => 'mobile',
							'version' => 'separated-fields',
							'class' => 'mfn_field_mobile mfn-toggled',
							'css_attr' => 'margin',
		  			),

		  			array(
							'class' => 'toggled_header',
   						'title' => __('Content', 'mfn-opts'),
   					),

						array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .progress_bars .bars_list .pb-desc:color',
							'type' => 'color',
							'class' => 'mfn-toggled',
							'title' => __('Color', 'mfn-opts'),
						),

						array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .progress_bars .bars_list .pb-desc:typography',
							'type' => 'typography_vb',
							'label_after' => '<a href="#" title="Edit" class="mfn-option-btn mfn-option-blank btn-medium mfn-vb-label-button"><span class="mfn-icon mfn-icon-edit"></span></a>',
							'class' => 'mfn-toggled toggle_fields',
							'title' => __('Typography', 'mfn-opts'),
						),

						array(
		  				'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .progress_bars .bars_list .pb-desc:margin',
		  				'type' => 'dimensions',
		  				'title' => __('Margin', 'mfn-opts'),
							'responsive' => 'desktop',
							'version' => 'separated-fields',
							'class' => 'mfn_field_desktop mfn-toggled',
							'css_attr' => 'margin',
		  			),

		  			array(
		  				'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .progress_bars .bars_list .pb-desc:margin_tablet',
		  				'type' => 'dimensions',
		  				'title' => __('Margin', 'mfn-opts'),
							'responsive' => 'tablet',
							'version' => 'separated-fields',
							'class' => 'mfn_field_tablet mfn-toggled',
							'css_attr' => 'margin',
		  			),

		  			array(
		  				'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .progress_bars .bars_list .pb-desc:margin_mobile',
		  				'type' => 'dimensions',
		  				'title' => __('Margin', 'mfn-opts'),
							'responsive' => 'mobile',
							'version' => 'separated-fields',
							'class' => 'mfn_field_mobile mfn-toggled',
							'css_attr' => 'margin',
		  			),

		  			array(
							'class' => 'toggled_header',
   						'title' => __('Bar title', 'mfn-opts'),
   					),

						array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .progress_bars .bars_list li h6:color',
							'type' => 'color',
							'class' => 'mfn-toggled',
							'title' => __('Color', 'mfn-opts'),
						),

						array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .progress_bars .bars_list li h6:typography',
							'type' => 'typography_vb',
							'label_after' => '<a href="#" title="Edit" class="mfn-option-btn mfn-option-blank btn-medium mfn-vb-label-button"><span class="mfn-icon mfn-icon-edit"></span></a>',
							'class' => 'mfn-toggled toggle_fields',
							'title' => __('Typography', 'mfn-opts'),
						),

						array(
							'class' => 'toggled_header',
   						'title' => __('Bar value', 'mfn-opts'),
   					),

						array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .progress_bars .bars_list li h6 .label:color',
							'type' => 'color',
							'class' => 'mfn-toggled',
							'title' => __('Color', 'mfn-opts'),
						),

						array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .progress_bars .bars_list li h6 .label:background-color',
							'type' => 'color',
							'class' => 'mfn-toggled',
							'title' => __('Background color', 'mfn-opts'),
						),

						array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .progress_bars .bars_list li h6 .label:typography',
							'type' => 'typography_vb',
							'label_after' => '<a href="#" title="Edit" class="mfn-option-btn mfn-option-blank btn-medium mfn-vb-label-button"><span class="mfn-icon mfn-icon-edit"></span></a>',
							'class' => 'mfn-toggled toggle_fields',
							'title' => __('Typography', 'mfn-opts'),
						),

						array(
							'class' => 'toggled_header',
   						'title' => __('Bar', 'mfn-opts'),
   					),

   					array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .progress_bars .bars_list li .bar:background-color',
							'type' => 'color',
							'class' => 'mfn-toggled',
							'title' => __('Background color', 'mfn-opts'),
						),

						array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .progress_bars .bars_list li .bar .progress:background-color',
							'type' => 'color',
							'class' => 'mfn-toggled',
							'title' => __('Background active', 'mfn-opts'),
						),

						array(
		  				'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .progress_bars .bars_list li .bar:box-shadow',
		  				'type' => 'box_shadow',
		  				'title' => __('Box shadow', 'mfn-opts'),
							'responsive' => 'desktop',
							'class' => 'mfn_field_desktop mfn-toggled',
							'css_attr' => 'box-shadow'
		  			),

		  			array(
		  				'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .progress_bars .bars_list li .bar:box-shadow_tablet',
		  				'type' => 'box_shadow',
		  				'title' => __('Box shadow', 'mfn-opts'),
							'responsive' => 'tablet',
							'class' => 'mfn_field_tablet mfn-toggled',
							'css_attr' => 'box-shadow',
		  			),

		  			array(
		  				'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .progress_bars .bars_list li .bar:box-shadow_mobile',
		  				'type' => 'box_shadow',
		  				'title' => __('Box shadow', 'mfn-opts'),
							'responsive' => 'mobile',
							'class' => 'mfn_field_mobile mfn-toggled',
							'css_attr' => 'box-shadow',
		  			),

						array(
							'type' => 'html',
							'html' => '</div>',
						),

   				),
   			),

   			// Promo Box ------------------------------------------------------

   			'promo_box' => array(
   				'type' => 'promo_box',
   				'title' => __('Promo Box', 'mfn-opts'),
   				'size' => '1/2',
   				'tablet_size' => '1/2',
   				'mobile_size' => '1/1',
   				'tablet_resized' => '0',
   				'cat' => 'boxes',
   				'fields' => array(

   					array(
							'type' => 'html',
							'html' => $this->itemtabs,
						),

   					array(
							'type' => 'html',
							'html' => '<div class="modalbox-card modalbox-re_render modalbox-card-content-mfnuidhere active">',
						),

   					array(
   						'id' => 'image',
   						'type' => 'upload',
   						'title' => __('Image', 'mfn-opts'),
   						'desc' => __('Recommended minimum image width <b>768px</b>', 'mfn-opts'),
							'std' => $this->get_placeholder(),
							'preview' => 'image',
   					),

   					array(
   						'id' => 'title',
   						'type' => 'text',
   						'edit_tag' => '.desc_wrapper | h2',
   						'edit_position' => 'prepend',
   						'title' => __('Title', 'mfn-opts'),
							'std' => __('This is the title', 'mfn-opts'),
							'preview' => 'title',
   					),

   					array(
   						'id' => 'content',
   						'type' => 'textarea',
   						'edit_tag' => '.desc_wrapper | div.desc',
   						'edit_position' => 'prepend',
   						'title' => __('Content', 'mfn-opts'),
							'std' => 'Lorem ipsum dolor sit amet, consectetur adipiscing elit. Ut elit tellus, luctus nec ullamcorper mattis, pulvinar dapibus leo.',
							'preview' => 'content',
							'class' => 'form-content-full-width',
   					),

   					// button

   					array(
   						'title' => __('Button', 'mfn-opts'),
   					),

   					array(
   						'id' => 'btn_text',
   						'type' => 'text',
   						're_render' => 'standard',
   						'title' => __('Text', 'mfn-opts'),
   					),
   					array(
   						'id' => 'btn_link',
   						'type' => 'text',
   						're_render' => 'standard',
   						'title' => __('Link', 'mfn-opts'),
   					),

   					array(
   						'id' => 'target',
   						'type' => 'select',
   						'title' => __('Link target', 'mfn-opts'),
   						'options' => array(
   							0 => __('Default | _self', 'mfn-opts'),
   							1 => __('New tab or window | _blank', 'mfn-opts'),
   							'lightbox' => __('Lightbox (image or embed video)', 'mfn-opts'),
   						),
   					),

   					// options

   					array(
   						'title' => __('Options', 'mfn-opts'),
   					),

   					array(
   						'id' => 'position',
   						'type' => 'switch',
   						're_render' => 'standard',
   						'title' => __('Image position', 'mfn-opts'),
   						'options' => array(
   							'left' => __('Left', 'mfn-opts'),
   							'right' => __('Right', 'mfn-opts'),
   						),
   						'std' => 'left',
   					),

   					array(
   						'id' => 'border',
   						'type' => 'switch',
   						're_render' => 'standard',
   						'title' => __('Border right', 'mfn-opts'),
   						'options' => array(
   							0 => __('Hide', 'mfn-opts'),
   							1 => __('Show', 'mfn-opts'),
   						),
							'std' => 0,
   					),

						// deprecated

						array(
							'class' => 'mfn-deprecated',
							'title' => __('Deprecated', 'mfn-opts'),
						),

						array(
							'id' => 'class',
							'type' => 'pills',
							'title' => __('Element classes', 'mfn-opts'),
							'class' => 'mfn-deprecated',
						),

						array(
							'type' => 'html',
							'html' => '</div><div class="modalbox-card modalbox-card-style modalbox-re_render modalbox-card-style-mfnuidhere">',
						),

						array(
							'class' => 'toggled_header',
   						'title' => __('Image', 'mfn-opts'),
   					),

		  			array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .promo_box_wrapper .photo_wrapper:border-style',
							'attr_id' => 'border_style_pricing_box',
							'type' => 'select',
							'class' => 'mfn-toggled',
							'title' => __('Border style', 'mfn-opts'),
							'options' => [
								'none' => __('None', 'mfn-opts'),
								'solid' => __('Solid', 'mfn-opts'),
								'dashed' => __('Dashed', 'mfn-opts'),
								'dotted' => __('Dotted', 'mfn-opts'),
								'double' => __('Double', 'mfn-opts'),
							],
						),

						array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .promo_box_wrapper .photo_wrapper:border-color',
							'condition' => array( 'id' => 'border_style_pricing_box', 'opt' => 'isnt', 'val' => 'none' ),
							'type' => 'color',
							'class' => 'mfn-toggled',
							'title' => __('Border color', 'mfn-opts'),
						),

						array(
		  				'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .promo_box_wrapper .photo_wrapper:border-width',
		  				'condition' => array( 'id' => 'border_style_pricing_box', 'opt' => 'isnt', 'val' => 'none' ),
		  				'type' => 'dimensions',
		  				'title' => __('Border width', 'mfn-opts'),
							'responsive' => 'desktop',
							'class' => 'mfn_field_desktop mfn-toggled',
							'css_attr' => 'border-width',
		  			),

		  			array(
		  				'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .promo_box_wrapper .photo_wrapper:border-width_tablet',
		  				'condition' => array( 'id' => 'border_style_pricing_box', 'opt' => 'isnt', 'val' => 'none' ),
		  				'type' => 'dimensions',
		  				'title' => __('Border width', 'mfn-opts'),
							'responsive' => 'tablet',
							'class' => 'mfn_field_tablet mfn-toggled',
							'css_attr' => 'border-width',
		  			),

		  			array(
		  				'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .promo_box_wrapper .photo_wrapper:border-width_mobile',
		  				'condition' => array( 'id' => 'border_style_pricing_box', 'opt' => 'isnt', 'val' => 'none' ),
		  				'type' => 'dimensions',
		  				'title' => __('Border width', 'mfn-opts'),
							'responsive' => 'mobile',
							'class' => 'mfn_field_mobile mfn-toggled',
							'css_attr' => 'border-width',
		  			),

						array(
		  				'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .promo_box_wrapper .photo_wrapper:border-radius',
		  				'type' => 'dimensions',
		  				'title' => __('Border radius', 'mfn-opts'),
							'responsive' => 'desktop',
							'class' => 'mfn_field_desktop mfn-toggled',
							'css_attr' => 'border-radius',
		  			),

		  			array(
		  				'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .promo_box_wrapper .photo_wrapper:border-radius_tablet',
		  				'type' => 'dimensions',
		  				'title' => __('Border radius', 'mfn-opts'),
							'responsive' => 'tablet',
							'class' => 'mfn_field_tablet mfn-toggled',
							'css_attr' => 'border-radius',
		  			),

		  			array(
		  				'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .promo_box_wrapper .photo_wrapper:border-radius_mobile',
		  				'type' => 'dimensions',
		  				'title' => __('Border radius', 'mfn-opts'),
							'responsive' => 'mobile',
							'class' => 'mfn_field_mobile mfn-toggled',
							'css_attr' => 'border-radius',
		  			),

						array(
							'class' => 'toggled_header',
   						'title' => __('Desc', 'mfn-opts'),
   					),

   					array(
   						'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .promo_box_wrapper .desc_wrapper:text-align',
							'responsive' => 'desktop',
   						'type' => 'switch',
   						'class' => 'mfn-toggled mfn_field_desktop',
   						'title' => __('Align', 'mfn-opts'),
   						'options' => array(
   							'' => __('Default', 'mfn-opts'),
   							'left' => __('Left', 'mfn-opts'),
								'center' => __('Center', 'mfn-opts'),
   							'right' => __('Right', 'mfn-opts'),
   							'justify' => __('Justify', 'mfn-opts'),
   						),
							'preview' => 'align',
   					),

   					array(
   						'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .promo_box_wrapper .desc_wrapper:text-align_tablet',
							'responsive' => 'tablet',
   						'type' => 'switch',
   						'class' => 'mfn-toggled mfn_field_tablet',
   						'title' => __('Align', 'mfn-opts'),
   						'options' => array(
   							'' => __('Default', 'mfn-opts'),
   							'left' => __('Left', 'mfn-opts'),
								'center' => __('Center', 'mfn-opts'),
   							'right' => __('Right', 'mfn-opts'),
   							'justify' => __('Justify', 'mfn-opts'),
   						),
							'preview' => 'align',
   					),

   					array(
   						'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .promo_box_wrapper .desc_wrapper:text-align_mobile',
							'responsive' => 'mobile',
   						'type' => 'switch',
   						'class' => 'mfn-toggled mfn_field_mobile',
   						'title' => __('Align', 'mfn-opts'),
   						'options' => array(
   							'' => __('Default', 'mfn-opts'),
   							'left' => __('Left', 'mfn-opts'),
								'center' => __('Center', 'mfn-opts'),
   							'right' => __('Right', 'mfn-opts'),
   							'justify' => __('Justify', 'mfn-opts'),
   						),
							'preview' => 'align',
   					),

						array(
							'class' => 'toggled_header',
   						'title' => __('Title', 'mfn-opts'),
   					),

						array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .promo_box_wrapper .desc_wrapper h2:color',
							'type' => 'color',
							'class' => 'mfn-toggled',
							'title' => __('Color', 'mfn-opts'),
						),

						array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .promo_box_wrapper .desc_wrapper h2:typography',
							'type' => 'typography_vb',
							'label_after' => '<a href="#" title="Edit" class="mfn-option-btn mfn-option-blank btn-medium mfn-vb-label-button"><span class="mfn-icon mfn-icon-edit"></span></a>',
							'class' => 'mfn-toggled toggle_fields',
							'title' => __('Typography', 'mfn-opts'),
						),

						array(
		  				'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .promo_box_wrapper .desc_wrapper h2:margin',
		  				'type' => 'dimensions',
		  				'title' => __('Margin', 'mfn-opts'),
							'responsive' => 'desktop',
							'version' => 'separated-fields',
							'class' => 'mfn_field_desktop mfn-toggled',
							'css_attr' => 'margin',
		  			),

		  			array(
		  				'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .promo_box_wrapper .desc_wrapper h2:margin_tablet',
		  				'type' => 'dimensions',
		  				'title' => __('Margin', 'mfn-opts'),
							'responsive' => 'tablet',
							'version' => 'separated-fields',
							'class' => 'mfn_field_tablet mfn-toggled',
							'css_attr' => 'margin',
		  			),

		  			array(
		  				'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .promo_box_wrapper .desc_wrapper h2:margin_mobile',
		  				'type' => 'dimensions',
		  				'title' => __('Margin', 'mfn-opts'),
							'responsive' => 'mobile',
							'version' => 'separated-fields',
							'class' => 'mfn_field_mobile mfn-toggled',
							'css_attr' => 'margin',
		  			),

		  			array(
							'class' => 'toggled_header',
   						'title' => __('Content', 'mfn-opts'),
   					),

						array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .promo_box_wrapper .desc_wrapper .desc:color',
							'type' => 'color',
							'class' => 'mfn-toggled',
							'title' => __('Color', 'mfn-opts'),
						),

						array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .promo_box_wrapper .desc_wrapper .desc:typography',
							'type' => 'typography_vb',
							'label_after' => '<a href="#" title="Edit" class="mfn-option-btn mfn-option-blank btn-medium mfn-vb-label-button"><span class="mfn-icon mfn-icon-edit"></span></a>',
							'class' => 'mfn-toggled toggle_fields',
							'title' => __('Typography', 'mfn-opts'),
						),

						array(
		  				'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .promo_box_wrapper .desc_wrapper .desc:margin',
		  				'type' => 'dimensions',
		  				'title' => __('Margin', 'mfn-opts'),
							'responsive' => 'desktop',
							'version' => 'separated-fields',
							'class' => 'mfn_field_desktop mfn-toggled',
							'css_attr' => 'margin',
		  			),

		  			array(
		  				'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .promo_box_wrapper .desc_wrapper .desc:margin_tablet',
		  				'type' => 'dimensions',
		  				'title' => __('Margin', 'mfn-opts'),
							'responsive' => 'tablet',
							'version' => 'separated-fields',
							'class' => 'mfn_field_tablet mfn-toggled',
							'css_attr' => 'margin',
		  			),

		  			array(
		  				'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .promo_box_wrapper .desc_wrapper .desc:margin_mobile',
		  				'type' => 'dimensions',
		  				'title' => __('Margin', 'mfn-opts'),
							'responsive' => 'mobile',
							'version' => 'separated-fields',
							'class' => 'mfn_field_mobile mfn-toggled',
							'css_attr' => 'margin',
		  			),

		  			array(
							'class' => 'toggled_header',
   						'title' => __('Button', 'mfn-opts'),
   					),

		  			array(
		  				'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .promo_box_wrapper .desc_wrapper .button:padding',
		  				'type' => 'dimensions',
		  				'version' => 'separated-fields',
		  				'title' => __('Padding', 'mfn-opts'),
							'responsive' => 'desktop',
							'class' => 'mfn_field_desktop mfn-toggled',
							'css_attr' => 'padding',
		  			),

		  			array(
		  				'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .promo_box_wrapper .desc_wrapper .button:padding_tablet',
		  				'type' => 'dimensions',
		  				'version' => 'separated-fields',
		  				'title' => __('Padding', 'mfn-opts'),
							'responsive' => 'tablet',
							'class' => 'mfn_field_tablet mfn-toggled',
							'css_attr' => 'padding',
		  			),

		  			array(
		  				'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .promo_box_wrapper .desc_wrapper .button:padding_mobile',
		  				'type' => 'dimensions',
		  				'version' => 'separated-fields',
		  				'title' => __('Padding', 'mfn-opts'),
							'responsive' => 'mobile',
							'class' => 'mfn_field_mobile mfn-toggled',
							'css_attr' => 'padding',
		  			),

		  			array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .promo_box_wrapper .desc_wrapper .button:typography',
							'type' => 'typography_vb',
							'label_after' => '<a href="#" title="Edit" class="mfn-option-btn mfn-option-blank btn-medium mfn-vb-label-button"><span class="mfn-icon mfn-icon-edit"></span></a>',
							'class' => 'mfn-toggled toggle_fields',
							'title' => __('Typography', 'mfn-opts'),
						),

						array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .promo_box_wrapper .desc_wrapper .button:border-style',
							'attr_id' => 'border_style_promo',
							'type' => 'select',
							'class' => 'mfn-toggled',
							'title' => __('Border style', 'mfn-opts'),
							'options' => [
								'none' => __('None', 'mfn-opts'),
								'solid' => __('Solid', 'mfn-opts'),
								'dashed' => __('Dashed', 'mfn-opts'),
								'dotted' => __('Dotted', 'mfn-opts'),
								'double' => __('Double', 'mfn-opts'),
							],
						),

						array(
		  				'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .promo_box_wrapper .desc_wrapper .button:border-width',
		  				'condition' => array( 'id' => 'border_style_promo', 'opt' => 'isnt', 'val' => 'none' ),
		  				'type' => 'dimensions',
		  				'title' => __('Border width', 'mfn-opts'),
							'responsive' => 'desktop',
							'class' => 'mfn_field_desktop mfn-toggled',
							'css_attr' => 'border-width',
		  			),

		  			array(
		  				'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .promo_box_wrapper .desc_wrapper .button:border-width_tablet',
		  				'condition' => array( 'id' => 'border_style_promo', 'opt' => 'isnt', 'val' => 'none' ),
		  				'type' => 'dimensions',
		  				'title' => __('Border width', 'mfn-opts'),
							'responsive' => 'tablet',
							'class' => 'mfn_field_tablet mfn-toggled',
							'css_attr' => 'border-width',
		  			),

		  			array(
		  				'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .promo_box_wrapper .desc_wrapper .button:border-width_mobile',
		  				'condition' => array( 'id' => 'border_style_promo', 'opt' => 'isnt', 'val' => 'none' ),
		  				'type' => 'dimensions',
		  				'title' => __('Border width', 'mfn-opts'),
							'responsive' => 'mobile',
							'class' => 'mfn_field_mobile mfn-toggled',
							'css_attr' => 'border-width',
		  			),

						array(
		  				'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .promo_box_wrapper .desc_wrapper .button:border-radius',
		  				'type' => 'dimensions',
		  				'title' => __('Border radius', 'mfn-opts'),
							'responsive' => 'desktop',
							'class' => 'mfn_field_desktop mfn-toggled',
							'css_attr' => 'border-radius',
		  			),

		  			array(
		  				'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .promo_box_wrapper .desc_wrapper .button:border-radius_tablet',
		  				'type' => 'dimensions',
		  				'title' => __('Border radius', 'mfn-opts'),
							'responsive' => 'tablet',
							'class' => 'mfn_field_tablet mfn-toggled',
							'css_attr' => 'border-radius',
		  			),

		  			array(
		  				'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .promo_box_wrapper .desc_wrapper .button:border-radius_mobile',
		  				'type' => 'dimensions',
		  				'title' => __('Border radius', 'mfn-opts'),
							'responsive' => 'mobile',
							'class' => 'mfn_field_mobile mfn-toggled',
							'css_attr' => 'border-radius',
		  			),

   					array(
							'type' => 'html',
							'html' => '<div class="mfn-form-row mfn-sidebar-fields-tabs mfn-toggled mfn-vb-formrow mfn-vb-mfnuidhere"><ul class="mfn-sft-nav"><li class="active"><a href="#normal" data-tab="normal">Normal</a></li><li><a href="#hover" data-tab="hover">Hover</a></li></ul><div class="mfn-sft mfn-sft-normal">',
						),

						array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .promo_box_wrapper .desc_wrapper .button:color',
							'type' => 'color',
							'class' => 'main-color mfn-toggled',
							'title' => __('Color', 'mfn-opts'),
						),

						array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .promo_box_wrapper .desc_wrapper .button:border-color',
							'condition' => array( 'id' => 'border_style_promo', 'opt' => 'isnt', 'val' => 'none' ),
							'type' => 'color',
							'class' => 'mfn-toggled',
							'title' => __('Border color', 'mfn-opts'),
						),

						array(
							'id' => 'background_switcher',
							'attr_id' => 'background_switcher_promo',
							'type' => 'switch',
							'class' => 'mfn-fields-switcher',
							'title' => __('Background type', 'mfn-opts'),
							'options' => array(
		  					'default' => __('Default', 'mfn-opts'),
		  					'gradient' 	=> __('Gradient', 'mfn-opts'),
		  				),
							'visual_options' => array(
		  					'default' => '',
		  					'gradient' 	=> '',
		  				),
		  				'std' => 'default',
						),

						array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .promo_box_wrapper .desc_wrapper .button:background-color',
							'condition' => array( 'id' => 'background_switcher_promo', 'opt' => 'is', 'val' => 'default' ),
							'type' => 'color',
							'title' => __('Background color', 'mfn-opts'),
						),

						array(
		  				'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .promo_box_wrapper .desc_wrapper .button:gradient',
		  				'condition' => array( 'id' => 'background_switcher_promo', 'opt' => 'is', 'val' => 'gradient' ),
		  				'type' => 'gradient',
		  				'title' => __('Gradient', 'mfn-opts'),
		  				'class' => 'mfn-toggled',
							'css_attr' => 'gradient',
		  			),

						array(
							'type' => 'html',
							'html' => '</div><div class="mfn-sft mfn-sft-hover">',
						),

						array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .promo_box_wrapper .desc_wrapper .button|hover:color',
							'type' => 'color',
							'class' => 'main-color mfn-toggled',
							'title' => __('Color', 'mfn-opts'),
						),

						array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .promo_box_wrapper .desc_wrapper .button|hover:border-color',
							'condition' => array( 'id' => 'border_style_promo', 'opt' => 'isnt', 'val' => 'none' ),
							'type' => 'color',
							'class' => 'mfn-toggled',
							'title' => __('Border color', 'mfn-opts'),
						),

						array(
							'id' => 'background_switcher_hover',
							'attr_id' => 'background_switcher_hover_promo',
							'type' => 'switch',
							'class' => 'mfn-fields-switcher',
							'title' => __('Background type', 'mfn-opts'),
							'options' => array(
		  					'default' => __('Default', 'mfn-opts'),
		  					'gradient' 	=> __('Gradient', 'mfn-opts'),
		  				),
							'visual_options' => array(
		  					'default' => '',
		  					'gradient' 	=> '',
		  				),
		  				'std' => 'default',
						),

						array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .promo_box_wrapper .desc_wrapper .button|hover:background',
							'condition' => array( 'id' => 'background_switcher_hover_promo', 'opt' => 'is', 'val' => 'default' ),
							'type' => 'color',
							'class' => 'main-color mfn-toggled',
							'title' => __('Background color', 'mfn-opts'),
						),

						array(
		  				'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .promo_box_wrapper .desc_wrapper .button|hover:gradient',
		  				'condition' => array( 'id' => 'background_switcher_hover_promo', 'opt' => 'is', 'val' => 'gradient' ),
		  				'type' => 'gradient',
		  				'title' => __('Gradient', 'mfn-opts'),
		  				'class' => 'mfn-toggled',
							'css_attr' => 'gradient',
		  			),

						array(
							'type' => 'html',
							'html' => '</div></div>',
						),

		  			array(
							'class' => 'toggled_header',
   						'title' => __('Line', 'mfn-opts'),
   					),

   					array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .promo_box.has_border|after:border-color',
							'type' => 'color',
							'class' => 'mfn-toggled',
							'title' => __('Color', 'mfn-opts'),
						),

						array(
							'type' => 'html',
							'html' => '</div>',
						),

   				),
   			),

   			// Quick Fact -----------------------------------------------------

   			'quick_fact' => array(
   				'type' => 'quick_fact',
   				'title' => __('Quick Fact', 'mfn-opts'),
   				'size' => '1/4',
   				'tablet_size' => '1/4',
   				'mobile_size' => '1/1',
   				'tablet_resized' => '0',
   				'cat' => 'boxes',
   				'fields' => array(

   					array(
							'type' => 'html',
							'html' => $this->itemtabs,
						),

   					array(
							'type' => 'html',
							'html' => '<div class="modalbox-card modalbox-re_render modalbox-card-content-mfnuidhere active">',
						),

   					array(
   						'id' => 'heading',
   						'type' => 'text',
   						'title' => __('Heading', 'mfn-opts'),
   						'edit_tag' => '.quick_fact | h4.heading_tag',
   						'edit_position' => 'prepend',
   						'edit_tag_var' => 'preview-heading_taginput',
							'std' => __('This is the heading', 'mfn-opts'),
							'preview' => 'title',
   					),

						array(
							'id' => 'heading_tag',
							'type' 	=> 'switch',
							're_render' => 'standard',
							'title' => __('Heading tag', 'mfn-opts'),
							'options' => array(
								'h1' => 'H1',
								'h2' => 'H2',
								'h3' => 'H3',
								'h4' => 'H4',
								'h5' => 'H5',
								'h6' => 'H6',
							),
							'std' => 'h4'
						),

   					array(
   						'id' => 'title',
   						'type' => 'text',
   						'title' => __('Title', 'mfn-opts'),
							'std' => __('This is the title', 'mfn-opts'),
							'edit_tag' => '.quick_fact | h3.title_tag',
							'edit_tag_var' => 'preview-title_taginput',
							'edit_position' => 'before | .hr_narrow',
							'preview' => 'subtitle',
	   				),

						array(
							'id' => 'title_tag',
							'type' 	=> 'switch',
							're_render' => 'standard',
							'title' => __('Title tag', 'mfn-opts'),
							'options' => array(
								'h1' => 'H1',
								'h2' => 'H2',
								'h3' => 'H3',
								'h4' => 'H4',
								'h5' => 'H5',
								'h6' => 'H6',
							),
							'std' => 'h3'
						),

   					array(
   						'id' => 'content',
   						'type' => 'textarea',
   						'title' => __('Content', 'mfn-opts'),
							'std' => 'Lorem ipsum dolor sit amet, consectetur adipiscing elit. Ut elit tellus, luctus nec ullamcorper mattis, pulvinar dapibus leo.',
							'preview' => 'content',
							'edit_tag' => '.quick_fact | div.desc',
							'class' => 'form-content-full-width',
   					),

   					// quick fact

   					array(
   						'title' => __('Quick fact', 'mfn-opts'),
   					),

   					array(
   						'id' => 'number',
   						'type' => 'text',
   						'title' => __('Number', 'mfn-opts'),
   						'param' => 'number',
   						'class' => 'narrow',
   						'std' => '99',
   						'preview' => 'number',
   					),

   					array(
   						'id' => 'prefix',
   						'type' => 'text',
   						'title' => __('Prefix', 'mfn-opts'),
   						'class' => 'narrow',
   					),

   					array(
   						'id' => 'label',
   						'type' => 'text',
   						'title' => __('Postfix', 'mfn-opts'),
   						'class' => 'narrow',
   					),

   					array(
   						'class' => 'mfn-deprecated',
   						'title' => __('Deprecated', 'mfn-opts'),
   					),

   					array(
   						'id' => 'align',
   						'class' => 'mfn-deprecated',
   						'type' => 'switch',
   						'title' => __('Align', 'mfn-opts'),
   						'options' => array(
								'left' => __('Left', 'mfn-opts'),
   							'' => __('Center', 'mfn-opts'),
   							'right' => __('Right', 'mfn-opts'),
   						),
							'std' => '',
   					),

						array(
							'id' => 'class',
							'type' => 'pills',
							'title' => __('Element classes', 'mfn-opts'),
							'class' => 'mfn-deprecated',
						),

		  			array(
							'type' => 'html',
							'html' => '</div><div class="modalbox-card modalbox-card-style modalbox-re_render modalbox-card-style-mfnuidhere">',
						),

						array(
		  				'class' => 'toggled_header',
   						'title' => __('Container', 'mfn-opts'),
   					),

						array(
   						'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .quick_fact:text-align',
							'responsive' => 'desktop',
   						'type' => 'switch',
   						'class' => 'mfn_field_desktop mfn-toggled',
   						'title' => __('Text align', 'mfn-opts'),
   						'options' => array(
   							'' => __('Default', 'mfn-opts'),
   							'left' => __('Left', 'mfn-opts'),
								'center' => __('Center', 'mfn-opts'),
   							'right' => __('Right', 'mfn-opts'),
   							'justify' => __('Justify', 'mfn-opts'),
   						),
							'preview' => 'align',
   					),
   					array(
   						'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .quick_fact:text-align_tablet',
							'responsive' => 'tablet',
   						'type' => 'switch',
   						'class' => 'mfn_field_tablet mfn-toggled',
   						'title' => __('Text align', 'mfn-opts'),
   						'options' => array(
   							'' => __('Default', 'mfn-opts'),
   							'left' => __('Left', 'mfn-opts'),
								'center' => __('Center', 'mfn-opts'),
   							'right' => __('Right', 'mfn-opts'),
   							'justify' => __('Justify', 'mfn-opts'),
   						),
							'preview' => 'align',
   					),
   					array(
   						'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .quick_fact:text-align_mobile',
							'responsive' => 'mobile',
   						'type' => 'switch',
   						'class' => 'mfn_field_mobile mfn-toggled',
   						'title' => __('Text align', 'mfn-opts'),
   						'options' => array(
   							'' => __('Default', 'mfn-opts'),
   							'left' => __('Left', 'mfn-opts'),
								'center' => __('Center', 'mfn-opts'),
   							'right' => __('Right', 'mfn-opts'),
   							'justify' => __('Justify', 'mfn-opts'),
   						),
							'preview' => 'align',
   					),

		  			array(
		  				'class' => 'toggled_header',
   						'title' => __('Heading', 'mfn-opts'),
   					),

   					array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .quick_fact .heading_tag:color',
							'type' => 'color',
							'class' => 'main-color mfn-toggled',
							'title' => __('Color', 'mfn-opts'),
						),

						array(
		  				'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .quick_fact .heading_tag:margin',
		  				'type' => 'dimensions',
		  				'version' => 'separated-fields',
		  				'title' => __('Margin', 'mfn-opts'),
							'responsive' => 'desktop',
							'class' => 'mfn_field_desktop mfn-toggled',
							'css_attr' => 'margin',
		  			),

		  			array(
		  				'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .quick_fact .heading_tag:margin_tablet',
		  				'type' => 'dimensions',
		  				'version' => 'separated-fields',
		  				'title' => __('Margin', 'mfn-opts'),
							'responsive' => 'tablet',
							'class' => 'mfn_field_tablet mfn-toggled',
							'css_attr' => 'margin',
		  			),

		  			array(
		  				'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .quick_fact .heading_tag:margin_mobile',
		  				'type' => 'dimensions',
		  				'version' => 'separated-fields',
		  				'title' => __('Margin', 'mfn-opts'),
							'responsive' => 'mobile',
							'class' => 'mfn_field_mobile mfn-toggled',
							'css_attr' => 'margin',
		  			),

		  			array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .quick_fact .heading_tag:typography',
							'type' => 'typography_vb',
							'label_after' => '<a href="#" title="Edit" class="mfn-option-btn mfn-option-blank btn-medium mfn-vb-label-button"><span class="mfn-icon mfn-icon-edit"></span></a>',
							'class' => 'mfn-toggled toggle_fields',
							'title' => __('Typography', 'mfn-opts'),
						),

						array(
		  				'class' => 'toggled_header',
   						'title' => __('Pre', 'mfn-opts'),
   					),

   					array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .quick_fact .number-wrapper .prefix:color',
							'type' => 'color',
							'class' => 'main-color mfn-toggled',
							'title' => __('Color', 'mfn-opts'),
						),

						array(
		  				'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .quick_fact .number-wrapper .prefix:margin',
		  				'type' => 'dimensions',
		  				'version' => 'separated-fields',
		  				'title' => __('Margin', 'mfn-opts'),
							'responsive' => 'desktop',
							'class' => 'mfn_field_desktop mfn-toggled',
							'css_attr' => 'margin',
		  			),

		  			array(
		  				'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .quick_fact .number-wrapper .prefix:margin_tablet',
		  				'type' => 'dimensions',
		  				'version' => 'separated-fields',
		  				'title' => __('Margin', 'mfn-opts'),
							'responsive' => 'tablet',
							'class' => 'mfn_field_tablet mfn-toggled',
							'css_attr' => 'margin',
		  			),

		  			array(
		  				'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .quick_fact .number-wrapper .prefix:margin_mobile',
		  				'type' => 'dimensions',
		  				'version' => 'separated-fields',
		  				'title' => __('Margin', 'mfn-opts'),
							'responsive' => 'mobile',
							'class' => 'mfn_field_mobile mfn-toggled',
							'css_attr' => 'margin',
		  			),

		  			array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .quick_fact .number-wrapper .prefix:typography',
							'type' => 'typography_vb',
							'typography' => 'simple',
							'label_after' => '<a href="#" title="Edit" class="mfn-option-btn mfn-option-blank btn-medium mfn-vb-label-button"><span class="mfn-icon mfn-icon-edit"></span></a>',
							'class' => 'mfn-toggled toggle_fields',
							'title' => __('Typography', 'mfn-opts'),
						),

						array(
		  				'class' => 'toggled_header',
   						'title' => __('Number', 'mfn-opts'),
   					),

   					array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .quick_fact .number-wrapper .number:color',
							'type' => 'color',
							'class' => 'main-color mfn-toggled',
							'title' => __('Color', 'mfn-opts'),
						),

						array(
		  				'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .quick_fact .number-wrapper:margin',
		  				'type' => 'dimensions',
		  				'version' => 'separated-fields',
		  				'title' => __('Margin', 'mfn-opts'),
							'responsive' => 'desktop',
							'class' => 'mfn_field_desktop mfn-toggled',
							'css_attr' => 'margin',
		  			),

		  			array(
		  				'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .quick_fact .number-wrapper:margin_tablet',
		  				'type' => 'dimensions',
		  				'version' => 'separated-fields',
		  				'title' => __('Margin', 'mfn-opts'),
							'responsive' => 'tablet',
							'class' => 'mfn_field_tablet mfn-toggled',
							'css_attr' => 'margin',
		  			),

		  			array(
		  				'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .quick_fact .number-wrapper:margin_mobile',
		  				'type' => 'dimensions',
		  				'version' => 'separated-fields',
		  				'title' => __('Margin', 'mfn-opts'),
							'responsive' => 'mobile',
							'class' => 'mfn_field_mobile mfn-toggled',
							'css_attr' => 'margin',
		  			),

		  			array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .quick_fact .number-wrapper .number:typography',
							'type' => 'typography_vb',
							'label_after' => '<a href="#" title="Edit" class="mfn-option-btn mfn-option-blank btn-medium mfn-vb-label-button"><span class="mfn-icon mfn-icon-edit"></span></a>',
							'class' => 'mfn-toggled toggle_fields',
							'title' => __('Typography', 'mfn-opts'),
						),


						array(
		  				'class' => 'toggled_header',
   						'title' => __('Post', 'mfn-opts'),
   					),

   					array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .quick_fact .number-wrapper .postfix:color',
							'type' => 'color',
							'class' => 'main-color mfn-toggled',
							'title' => __('Color', 'mfn-opts'),
						),

						array(
		  				'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .quick_fact .number-wrapper .postfix:margin',
		  				'type' => 'dimensions',
		  				'version' => 'separated-fields',
		  				'title' => __('Margin', 'mfn-opts'),
							'responsive' => 'desktop',
							'class' => 'mfn_field_desktop mfn-toggled',
							'css_attr' => 'margin',
		  			),

		  			array(
		  				'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .quick_fact .number-wrapper .postfix:margin_tablet',
		  				'type' => 'dimensions',
		  				'version' => 'separated-fields',
		  				'title' => __('Margin', 'mfn-opts'),
							'responsive' => 'tablet',
							'class' => 'mfn_field_tablet mfn-toggled',
							'css_attr' => 'margin',
		  			),

		  			array(
		  				'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .quick_fact .number-wrapper .postfix:margin_mobile',
		  				'type' => 'dimensions',
		  				'version' => 'separated-fields',
		  				'title' => __('Margin', 'mfn-opts'),
							'responsive' => 'mobile',
							'class' => 'mfn_field_mobile mfn-toggled',
							'css_attr' => 'margin',
		  			),

		  			array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .quick_fact .number-wrapper .postfix:typography',
							'type' => 'typography_vb',
							'typography' => 'simple',
							'label_after' => '<a href="#" title="Edit" class="mfn-option-btn mfn-option-blank btn-medium mfn-vb-label-button"><span class="mfn-icon mfn-icon-edit"></span></a>',
							'class' => 'mfn-toggled toggle_fields',
							'title' => __('Typography', 'mfn-opts'),
						),

						array(
		  				'class' => 'toggled_header',
   						'title' => __('Title', 'mfn-opts'),
   					),

   					array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .quick_fact .title_tag:color',
							'type' => 'color',
							'class' => 'main-color mfn-toggled',
							'title' => __('Color', 'mfn-opts'),
						),

						array(
		  				'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .quick_fact .title_tag:margin',
		  				'type' => 'dimensions',
		  				'version' => 'separated-fields',
		  				'title' => __('Margin', 'mfn-opts'),
							'responsive' => 'desktop',
							'class' => 'mfn_field_desktop mfn-toggled',
							'css_attr' => 'margin',
		  			),

		  			array(
		  				'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .quick_fact .title_tag:margin_tablet',
		  				'type' => 'dimensions',
		  				'version' => 'separated-fields',
		  				'title' => __('Margin', 'mfn-opts'),
							'responsive' => 'tablet',
							'class' => 'mfn_field_tablet mfn-toggled',
							'css_attr' => 'margin',
		  			),

		  			array(
		  				'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .quick_fact .title_tag:margin_mobile',
		  				'type' => 'dimensions',
		  				'version' => 'separated-fields',
		  				'title' => __('Margin', 'mfn-opts'),
							'responsive' => 'mobile',
							'class' => 'mfn_field_mobile mfn-toggled',
							'css_attr' => 'margin',
		  			),

		  			array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .quick_fact .title_tag:typography',
							'type' => 'typography_vb',
							'label_after' => '<a href="#" title="Edit" class="mfn-option-btn mfn-option-blank btn-medium mfn-vb-label-button"><span class="mfn-icon mfn-icon-edit"></span></a>',
							'class' => 'mfn-toggled toggle_fields',
							'title' => __('Typography', 'mfn-opts'),
						),

						array(
		  				'class' => 'toggled_header',
   						'title' => __('Desc', 'mfn-opts'),
   					),

   					array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .quick_fact .desc:color',
							'type' => 'color',
							'class' => 'main-color mfn-toggled',
							'title' => __('Color', 'mfn-opts'),
						),

						array(
		  				'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .quick_fact .desc:margin',
		  				'type' => 'dimensions',
		  				'version' => 'separated-fields',
		  				'title' => __('Margin', 'mfn-opts'),
							'responsive' => 'desktop',
							'class' => 'mfn_field_desktop mfn-toggled',
							'css_attr' => 'margin',
		  			),

		  			array(
		  				'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .quick_fact .desc:margin_tablet',
		  				'type' => 'dimensions',
		  				'version' => 'separated-fields',
		  				'title' => __('Margin', 'mfn-opts'),
							'responsive' => 'tablet',
							'class' => 'mfn_field_tablet mfn-toggled',
							'css_attr' => 'margin',
		  			),

		  			array(
		  				'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .quick_fact .desc:margin_mobile',
		  				'type' => 'dimensions',
		  				'version' => 'separated-fields',
		  				'title' => __('Margin', 'mfn-opts'),
							'responsive' => 'mobile',
							'class' => 'mfn_field_mobile mfn-toggled',
							'css_attr' => 'margin',
		  			),

		  			array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .quick_fact .desc:typography',
							'type' => 'typography_vb',
							'label_after' => '<a href="#" title="Edit" class="mfn-option-btn mfn-option-blank btn-medium mfn-vb-label-button"><span class="mfn-icon mfn-icon-edit"></span></a>',
							'class' => 'mfn-toggled toggle_fields',
							'title' => __('Typography', 'mfn-opts'),
						),

						array(
		  				'class' => 'toggled_header',
		  				'themeoptions' => 'style:',
   						'title' => __('Divider', 'mfn-opts'),
   					),

   					array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .quick_fact .hr_narrow:background-color',
							'themeoptions' => 'style:',
							'type' => 'color',
							'class' => 'main-color mfn-toggled',
							'title' => __('Color', 'mfn-opts'),
						),

						array(
		  				'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .quick_fact .hr_narrow:margin',
		  				'themeoptions' => 'style:',
		  				'type' => 'dimensions',
		  				'version' => 'separated-fields',
		  				'title' => __('Margin', 'mfn-opts'),
							'responsive' => 'desktop',
							'class' => 'mfn_field_desktop mfn-toggled',
							'css_attr' => 'margin',
		  			),

		  			array(
		  				'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .quick_fact .hr_narrow:margin_tablet',
		  				'themeoptions' => 'style:',
		  				'type' => 'dimensions',
		  				'version' => 'separated-fields',
		  				'title' => __('Margin', 'mfn-opts'),
							'responsive' => 'tablet',
							'class' => 'mfn_field_tablet mfn-toggled',
							'css_attr' => 'margin',
		  			),

		  			array(
		  				'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .quick_fact .hr_narrow:margin_mobile',
		  				'themeoptions' => 'style:',
		  				'type' => 'dimensions',
		  				'version' => 'separated-fields',
		  				'title' => __('Margin', 'mfn-opts'),
							'responsive' => 'mobile',
							'class' => 'mfn_field_mobile mfn-toggled',
							'css_attr' => 'margin',
		  			),

		  			array(
		  				'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .quick_fact .hr_narrow:width',
		  				'themeoptions' => 'style:',
		  				'type' => 'text',
		  				'default_unit' => '%',
		  				'title' => __('Width', 'mfn-opts'),
							'class' => 'mfn-toggled',
							'css_attr' => 'width',
		  			),


						array(
							'type' => 'html',
							'html' => '</div>',
						),

   				),
   			),

   			// Shop Categories ----------------------------------------------------

				'shop_categories' => array(
					'type' => 'shop_categories',
					'title' => __('Shop categories', 'mfn-opts'),
					'size' => '1/1',
					'tablet_size' => '1/1',
					'mobile_size' => '1/1',
					'tablet_resized' => '0',
					'cat' => 'loops',
					'fields' => array(

						array(
							'type' => 'html',
							'html' => $this->itemtabs,
						),

   					array(
							'type' => 'html',
							'html' => '<div class="modalbox-card modalbox-re_render modalbox-card-content-mfnuidhere active">',
						),

						// options

						array(
							'title' => __('Options', 'mfn-opts'),
						),

						array(
   						'id' => 'columns',
   						'type' => 'switch',
   						're_render' => 'standard',
   						'title' => __('Columns', 'mfn-opts'),
							'options' => array(
								2 => 2,
								3 => 3,
								4 => 4,
							),
   						'std' => '3',
   					),

						array(
							'id' => 'category',
							'type' => 'select',
							're_render' => 'standard',
							'title' => __('Parent category', 'mfn-opts'),
							'options' => mfn_get_categories('product_cat'),
						),

						array(
   						'id' => 'empty',
   						'type' => 'switch',
   						're_render' => 'standard',
   						'title' => __('Empty categories', 'mfn-opts'),
   						'desc' => __('Show categories without products', 'mfn-opts'),
							'options' => array(
								1 => __('Hide', 'mfn-opts'),
								0 => __('Show', 'mfn-opts'),
							),
   						'std' => 1,
   					),

						// advanced

						array(
							'title' => __('Advanced', 'mfn-opts'),
						),

						array(
   						'id' => 'image',
   						'type' => 'switch',
   						're_render' => 'standard',
   						'title' => __('Image', 'mfn-opts'),
							'options' => array(
								0 => __('Hide', 'mfn-opts'),
								1 => __('Show', 'mfn-opts'),
							),
   						'std' => 1,
   					),

						array(
   						'id' => 'title',
   						'type' => 'switch',
   						're_render' => 'standard',
   						'title' => __('Title', 'mfn-opts'),
							'options' => array(
								0 => __('Hide', 'mfn-opts'),
								1 => __('Show', 'mfn-opts'),
							),
   						'std' => 1,
   					),

						array(
   						'id' => 'count',
   						'type' => 'switch',
   						're_render' => 'standard',
   						'title' => __('Count', 'mfn-opts'),
							'desc' => __('Number of products in category', 'mfn-opts'),
							'options' => array(
								0 => __('Hide', 'mfn-opts'),
								1 => __('Show', 'mfn-opts'),
							),
   						'std' => 0,
   					),

   					array(
							'id' => 'title_tag',
							'type' => 'switch',
							're_render' => 'standard',
							'title' => __('Title tag', 'mfn-opts'),
							'options' => [
								'h1' => 'H1',
								'h2' => 'H2',
								'h3' => 'H3',
								'h4' => 'H4',
								'h5' => 'H5',
								'h6' => 'H6',
								'p' => 'p',
								'span' => 'span',
							],
							'std' => 'h2',
						),

   					// order

						array(
							'title' => __('Order', 'mfn-opts'),
						),

						array(
							'id' => 'order',
							'type' => 'order',
							're_render' => 'standard',
							'title' => __('Order', 'mfn-opts'),
							'std' => 'image,title',
						),

						// deprecated

						array(
							'class' => 'mfn-deprecated',
							'title' => __('Deprecated', 'mfn-opts'),
						),

						array(
							'id' => 'class',
							'type' => 'pills',
							'title' => __('Element classes', 'mfn-opts'),
							'class' => 'mfn-deprecated',
						),

						array(
							'type' => 'html',
							'html' => '</div><div class="modalbox-card modalbox-card-style modalbox-re_render modalbox-card-style-mfnuidhere">',
						),

						array(
							'class' => 'toggled_header',
   						'title' => __('Container', 'mfn-opts'),
   					),

						array(
   						'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .woocommerce ul.products li.product:text-align',
   						'oldid' => 'style:.woocommerce-loop-category__title:text-align',
							'responsive' => 'desktop',
   						'type' => 'switch',
   						'class' => 'mfn-toggled mfn_field_desktop',
   						'title' => __('Align', 'mfn-opts'),
   						'options' => array(
   							'' => __('Default', 'mfn-opts'),
   							'left' => __('Left', 'mfn-opts'),
								'center' => __('Center', 'mfn-opts'),
   							'right' => __('Right', 'mfn-opts'),
   							'justify' => __('Justify', 'mfn-opts'),
   						),
							'preview' => 'align',
   					),

   					array(
   						'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .woocommerce ul.products li.product:text-align_tablet',
							'responsive' => 'tablet',
   						'type' => 'switch',
   						'class' => 'mfn-toggled mfn_field_tablet',
   						'title' => __('Align', 'mfn-opts'),
   						'options' => array(
   							'' => __('Default', 'mfn-opts'),
   							'left' => __('Left', 'mfn-opts'),
								'center' => __('Center', 'mfn-opts'),
   							'right' => __('Right', 'mfn-opts'),
   							'justify' => __('Justify', 'mfn-opts'),
   						),
							'preview' => 'align',
   					),

   					array(
   						'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .woocommerce ul.products li.product:text-align_mobile',
							'responsive' => 'mobile',
   						'type' => 'switch',
   						'class' => 'mfn-toggled mfn_field_mobile',
   						'title' => __('Align', 'mfn-opts'),
   						'options' => array(
   							'' => __('Default', 'mfn-opts'),
   							'left' => __('Left', 'mfn-opts'),
								'center' => __('Center', 'mfn-opts'),
   							'right' => __('Right', 'mfn-opts'),
   							'justify' => __('Justify', 'mfn-opts'),
   						),
							'preview' => 'align',
   					),

   					array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .woocommerce ul.products li.product:background-color',
							'type' => 'color',
							'class' => 'main-color mfn-toggled',
							'title' => __('Background', 'mfn-opts'),
						),

						array(
		  				'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .woocommerce ul.products li.product:padding',
		  				'type' => 'dimensions',
		  				'version' => 'separated-fields',
		  				'title' => __('Padding', 'mfn-opts'),
							'responsive' => 'desktop',
							'class' => 'mfn_field_desktop mfn-toggled',
							'css_attr' => 'padding',
		  			),

		  			array(
		  				'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .woocommerce ul.products li.product:padding_tablet',
		  				'type' => 'dimensions',
		  				'version' => 'separated-fields',
		  				'title' => __('Padding', 'mfn-opts'),
							'responsive' => 'tablet',
							'class' => 'mfn_field_tablet mfn-toggled',
							'css_attr' => 'padding',
		  			),

		  			array(
		  				'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .woocommerce ul.products li.product:padding_mobile',
		  				'type' => 'dimensions',
		  				'version' => 'separated-fields',
		  				'title' => __('Padding', 'mfn-opts'),
							'responsive' => 'mobile',
							'class' => 'mfn_field_mobile mfn-toggled',
							'css_attr' => 'padding',
		  			),

		  			array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .woocommerce ul.products li.product:border-style',
							'attr_id' => 'border_style_sc-li',
							'type' => 'select',
							'class' => 'mfn-toggled',
							'title' => __('Border style', 'mfn-opts'),
							'options' => [
								'none' => __('None', 'mfn-opts'),
								'solid' => __('Solid', 'mfn-opts'),
								'dashed' => __('Dashed', 'mfn-opts'),
								'dotted' => __('Dotted', 'mfn-opts'),
								'double' => __('Double', 'mfn-opts'),
							],
						),

						array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .woocommerce ul.products li.product:border-color',
							'condition' => array( 'id' => 'border_style_sc-li', 'opt' => 'isnt', 'val' => 'none' ),
							'type' => 'color',
							'class' => 'mfn-toggled',
							'title' => __('Border color', 'mfn-opts'),
						),

						array(
		  				'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .woocommerce ul.products li.product:border-width',
		  				'condition' => array( 'id' => 'border_style_sc-li', 'opt' => 'isnt', 'val' => 'none' ),
		  				'type' => 'dimensions',
		  				'title' => __('Border width', 'mfn-opts'),
							'responsive' => 'desktop',
							'class' => 'mfn_field_desktop mfn-toggled',
							'css_attr' => 'border-width',
		  			),

		  			array(
		  				'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .woocommerce ul.products li.product:border-width_tablet',
		  				'condition' => array( 'id' => 'border_style_sc-li', 'opt' => 'isnt', 'val' => 'none' ),
		  				'type' => 'dimensions',
		  				'title' => __('Border width', 'mfn-opts'),
							'responsive' => 'tablet',
							'class' => 'mfn_field_tablet mfn-toggled',
							'css_attr' => 'border-width',
		  			),

		  			array(
		  				'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .woocommerce ul.products li.product:border-width_mobile',
		  				'condition' => array( 'id' => 'border_style_sc-li', 'opt' => 'isnt', 'val' => 'none' ),
		  				'type' => 'dimensions',
		  				'title' => __('Border width', 'mfn-opts'),
							'responsive' => 'mobile',
							'class' => 'mfn_field_mobile mfn-toggled',
							'css_attr' => 'border-width',
		  			),

						array(
		  				'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .woocommerce ul.products li.product:border-radius',
		  				'type' => 'dimensions',
		  				'title' => __('Border radius', 'mfn-opts'),
							'responsive' => 'desktop',
							'class' => 'mfn_field_desktop mfn-toggled',
							'css_attr' => 'border-radius',
		  			),

		  			array(
		  				'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .woocommerce ul.products li.product:border-radius_tablet',
		  				'type' => 'dimensions',
		  				'title' => __('Border radius', 'mfn-opts'),
							'responsive' => 'tablet',
							'class' => 'mfn_field_tablet mfn-toggled',
							'css_attr' => 'border-radius',
		  			),

		  			array(
		  				'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .woocommerce ul.products li.product:border-radius_mobile',
		  				'type' => 'dimensions',
		  				'title' => __('Border radius', 'mfn-opts'),
							'responsive' => 'mobile',
							'class' => 'mfn_field_mobile mfn-toggled',
							'css_attr' => 'border-radius',
		  			),

		  			array(
							'class' => 'toggled_header',
							'title' => __('Image', 'mfn-opts'),
						),

						array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .woocommerce ul.products li.product img:border-style',
							'attr_id' => 'border_style_sc-img',
							'type' => 'select',
							'class' => 'mfn-toggled',
							'title' => __('Border style', 'mfn-opts'),
							'options' => [
								'none' => __('None', 'mfn-opts'),
								'solid' => __('Solid', 'mfn-opts'),
								'dashed' => __('Dashed', 'mfn-opts'),
								'dotted' => __('Dotted', 'mfn-opts'),
								'double' => __('Double', 'mfn-opts'),
							],
						),

						array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .woocommerce ul.products li.product img:border-color',
							'condition' => array( 'id' => 'border_style_sc-img', 'opt' => 'isnt', 'val' => 'none' ),
							'type' => 'color',
							'class' => 'mfn-toggled',
							'title' => __('Border color', 'mfn-opts'),
						),

						array(
		  				'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .woocommerce ul.products li.product img:border-width',
		  				'condition' => array( 'id' => 'border_style_sc-img', 'opt' => 'isnt', 'val' => 'none' ),
		  				'type' => 'dimensions',
		  				'title' => __('Border width', 'mfn-opts'),
							'responsive' => 'desktop',
							'class' => 'mfn_field_desktop mfn-toggled',
							'css_attr' => 'border-width',
		  			),

		  			array(
		  				'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .woocommerce ul.products li.product img:border-width_tablet',
		  				'condition' => array( 'id' => 'border_style_sc-img', 'opt' => 'isnt', 'val' => 'none' ),
		  				'type' => 'dimensions',
		  				'title' => __('Border width', 'mfn-opts'),
							'responsive' => 'tablet',
							'class' => 'mfn_field_tablet mfn-toggled',
							'css_attr' => 'border-width',
		  			),

		  			array(
		  				'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .woocommerce ul.products li.product img:border-width_mobile',
		  				'condition' => array( 'id' => 'border_style_sc-img', 'opt' => 'isnt', 'val' => 'none' ),
		  				'type' => 'dimensions',
		  				'title' => __('Border width', 'mfn-opts'),
							'responsive' => 'mobile',
							'class' => 'mfn_field_mobile mfn-toggled',
							'css_attr' => 'border-width',
		  			),

						array(
		  				'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .woocommerce ul.products li.product img:border-radius',
		  				'type' => 'dimensions',
		  				'title' => __('Border radius', 'mfn-opts'),
							'responsive' => 'desktop',
							'class' => 'mfn_field_desktop mfn-toggled',
							'css_attr' => 'border-radius',
		  			),

		  			array(
		  				'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .woocommerce ul.products li.product img:border-radius_tablet',
		  				'type' => 'dimensions',
		  				'title' => __('Border radius', 'mfn-opts'),
							'responsive' => 'tablet',
							'class' => 'mfn_field_tablet mfn-toggled',
							'css_attr' => 'border-radius',
		  			),

		  			array(
		  				'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .woocommerce ul.products li.product img:border-radius_mobile',
		  				'type' => 'dimensions',
		  				'title' => __('Border radius', 'mfn-opts'),
							'responsive' => 'mobile',
							'class' => 'mfn_field_mobile mfn-toggled',
							'css_attr' => 'border-radius',
		  			),

		  			array(
							'class' => 'toggled_header',
   						'title' => __('Title', 'mfn-opts'),
   					),

						array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .woocommerce ul.products li.product .woocommerce-loop-category__title:color',
							'type' => 'color',
							'class' => 'mfn-toggled',
							'title' => __('Color', 'mfn-opts'),
						),

						array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .woocommerce ul.products li.product .woocommerce-loop-category__title:typography',
							'type' => 'typography_vb',
							'label_after' => '<a href="#" title="Edit" class="mfn-option-btn mfn-option-blank btn-medium mfn-vb-label-button"><span class="mfn-icon mfn-icon-edit"></span></a>',
							'class' => 'mfn-toggled toggle_fields',
							'title' => __('Typography', 'mfn-opts'),
						),

						array(
		  				'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .woocommerce ul.products li.product .woocommerce-loop-category__title:margin',
		  				'type' => 'dimensions',
		  				'title' => __('Margin', 'mfn-opts'),
							'responsive' => 'desktop',
							'version' => 'separated-fields',
							'class' => 'mfn_field_desktop mfn-toggled',
							'css_attr' => 'margin',
		  			),

		  			array(
		  				'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .woocommerce ul.products li.product .woocommerce-loop-category__title:margin_tablet',
		  				'type' => 'dimensions',
		  				'title' => __('Margin', 'mfn-opts'),
							'responsive' => 'tablet',
							'version' => 'separated-fields',
							'class' => 'mfn_field_tablet mfn-toggled',
							'css_attr' => 'margin',
		  			),

		  			array(
		  				'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .woocommerce ul.products li.product .woocommerce-loop-category__title:margin_mobile',
		  				'type' => 'dimensions',
		  				'title' => __('Margin', 'mfn-opts'),
							'responsive' => 'mobile',
							'version' => 'separated-fields',
							'class' => 'mfn_field_mobile mfn-toggled',
							'css_attr' => 'margin',
		  			),

		  			array(
							'class' => 'toggled_header',
   						'title' => __('Count', 'mfn-opts'),
   					),

						array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .woocommerce ul.products li.product .woocommerce-loop-category__title .count:color',
							'type' => 'color',
							'class' => 'mfn-toggled',
							'title' => __('Color', 'mfn-opts'),
						),

						array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .woocommerce ul.products li.product .woocommerce-loop-category__title .count:typography',
							'type' => 'typography_vb',
							'label_after' => '<a href="#" title="Edit" class="mfn-option-btn mfn-option-blank btn-medium mfn-vb-label-button"><span class="mfn-icon mfn-icon-edit"></span></a>',
							'class' => 'mfn-toggled toggle_fields',
							'title' => __('Typography', 'mfn-opts'),
						),

						array(
   						'type' => 'html',
   						'html' => '</div>',
   					),

					),
				),

   			// Shop ----------------------------------------------------

   			'shop' => array(
   				'type' => 'shop',
   				'title' => __('Shop', 'mfn-opts'),
   				'size' => '1/1',
   				'tablet_size' => '1/1',
   				'mobile_size' => '1/1',
   				'tablet_resized' => '0',
   				'cat' => 'loops',
   				'fields' => array(

   					array(
							'type' => 'html',
							'html' => $this->itemtabs,
						),

   					array(
							'type' => 'html',
							'html' => '<div class="modalbox-card modalbox-re_render modalbox-card-content-mfnuidhere active">',
						),

   					array(
   						'id' => 'limit',
   						're_render' => 'standard',
   						'type' => 'text',
   						'title' => __('Products number', 'mfn-opts'),
   						'std' => '6',
   						'after' => 'products',
   						'param' => 'number',
   						'class' => 'narrow',
							'preview' => 'number',
   					),

   					array(
   						'id' => 'columns',
   						're_render' => 'standard',
   						'type' => 'switch',
   						'title' => __('Columns', 'mfn-opts'),
							'options' => array(
								2 => 2,
								3 => 3,
								4 => 4,
							),
   						'std' => '3',
   					),

						array(
   						'id' => 'type',
   						're_render' => 'standard',
   						'type' => 'select',
   						'title' => __('Display', 'mfn-opts'),
   						'options' => array(
   							'products' => __('- Default -', 'mfn-opts'),
   							'sale_products' => __('On sale', 'mfn-opts'),
   							'best_selling_products' => __('Best selling (order by: Sales)', 'mfn-opts'),
   							'top_rated_products' => __('Top-rated (order by: Rating)', 'mfn-opts'),
   						),
   					),

						// options

   					array(
   						'title' => __('Options', 'mfn-opts'),
   					),

   					array(
   						'id' => 'category',
   						're_render' => 'standard',
   						'type' => 'select',
   						'title' => __('Category', 'mfn-opts'),
   						'options' => mfn_get_categories('product_cat'),
							'preview' => 'category',
   					),

   					array(
   						'id' => 'orderby',
   						're_render' => 'standard',
   						'type' => 'select',
   						'title' => __('Order by', 'mfn-opts'),
   						'options' => array(
   							'date' => __('Date the product was published', 'mfn-opts'),
   							'id' => __('ID of the product', 'mfn-opts'),
   							'menu_order' => __('Menu order (if set)', 'mfn-opts'),
   							'popularity' => __('Popularity (number of purchases)', 'mfn-opts'),
   							'rating' => __('Rating', 'mfn-opts'),
   							'title' => __('Title', 'mfn-opts'),
								'rand' => __('Random (do not use with pagination)', 'mfn-opts'),
   						),
   						'std' => 'title'
   					),

   					array(
   						'id' => 'order',
   						're_render' => 'standard',
   						'type' => 'switch',
   						'title' => __('Order', 'mfn-opts'),
   						'options' => array(
   							'ASC' => __('Ascending', 'mfn-opts'),
   							'DESC' => __('Descending', 'mfn-opts'),
   						),
   						'std' => 'ASC'
   					),

						// advanced

						array(
							'title' => __('Advanced', 'mfn-opts'),
						),

						array(
   						'id' => 'paginate',
   						're_render' => 'standard',
   						'type' => 'switch',
   						'title' => __('Pagination', 'mfn-opts'),
   						'options' => array(
   							0 => __('Hide', 'mfn-opts'),
   							1 => __('Show', 'mfn-opts'),
   						),
   						'std' => 0,
   					),

						// deprecated

						array(
							'class' => 'mfn-deprecated',
							'title' => __('Deprecated', 'mfn-opts'),
						),

						array(
							'id' => 'class',
							'type' => 'pills',
							'title' => __('Element classes', 'mfn-opts'),
							'class' => 'mfn-deprecated',
						),

						array(
							'type' => 'html',
							'html' => '</div><div class="modalbox-card modalbox-card-style modalbox-re_render modalbox-card-style-mfnuidhere">',
						),

						array(
							'class' => 'toggled_header',
   						'title' => __('Container', 'mfn-opts'),
   					),

   					array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .woocommerce ul.products li.product:background-color',
							'type' => 'color',
							'class' => 'main-color mfn-toggled',
							'title' => __('Background', 'mfn-opts'),
						),

						array(
		  				'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .woocommerce ul.products li.product:padding',
		  				'type' => 'dimensions',
		  				'version' => 'separated-fields',
		  				'title' => __('Padding', 'mfn-opts'),
							'responsive' => 'desktop',
							'class' => 'mfn_field_desktop mfn-toggled',
							'css_attr' => 'padding',
		  			),

		  			array(
		  				'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .woocommerce ul.products li.product:padding_tablet',
		  				'type' => 'dimensions',
		  				'version' => 'separated-fields',
		  				'title' => __('Padding', 'mfn-opts'),
							'responsive' => 'tablet',
							'class' => 'mfn_field_tablet mfn-toggled',
							'css_attr' => 'padding',
		  			),

		  			array(
		  				'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .woocommerce ul.products li.product:padding_mobile',
		  				'type' => 'dimensions',
		  				'version' => 'separated-fields',
		  				'title' => __('Padding', 'mfn-opts'),
							'responsive' => 'mobile',
							'class' => 'mfn_field_mobile mfn-toggled',
							'css_attr' => 'padding',
		  			),

		  			array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .woocommerce ul.products li.product:border-style',
							'attr_id' => 'border_style_sc-li',
							'type' => 'select',
							'class' => 'mfn-toggled',
							'title' => __('Border style', 'mfn-opts'),
							'options' => [
								'none' => __('None', 'mfn-opts'),
								'solid' => __('Solid', 'mfn-opts'),
								'dashed' => __('Dashed', 'mfn-opts'),
								'dotted' => __('Dotted', 'mfn-opts'),
								'double' => __('Double', 'mfn-opts'),
							],
						),

						array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .woocommerce ul.products li.product:border-color',
							'condition' => array( 'id' => 'border_style_sc-li', 'opt' => 'isnt', 'val' => 'none' ),
							'type' => 'color',
							'class' => 'mfn-toggled',
							'title' => __('Border color', 'mfn-opts'),
						),

						array(
		  				'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .woocommerce ul.products li.product:border-width',
		  				'condition' => array( 'id' => 'border_style_sc-li', 'opt' => 'isnt', 'val' => 'none' ),
		  				'type' => 'dimensions',
		  				'title' => __('Border width', 'mfn-opts'),
							'responsive' => 'desktop',
							'class' => 'mfn_field_desktop mfn-toggled',
							'css_attr' => 'border-width',
		  			),

		  			array(
		  				'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .woocommerce ul.products li.product:border-width_tablet',
		  				'condition' => array( 'id' => 'border_style_sc-li', 'opt' => 'isnt', 'val' => 'none' ),
		  				'type' => 'dimensions',
		  				'title' => __('Border width', 'mfn-opts'),
							'responsive' => 'tablet',
							'class' => 'mfn_field_tablet mfn-toggled',
							'css_attr' => 'border-width',
		  			),

		  			array(
		  				'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .woocommerce ul.products li.product:border-width_mobile',
		  				'condition' => array( 'id' => 'border_style_sc-li', 'opt' => 'isnt', 'val' => 'none' ),
		  				'type' => 'dimensions',
		  				'title' => __('Border width', 'mfn-opts'),
							'responsive' => 'mobile',
							'class' => 'mfn_field_mobile mfn-toggled',
							'css_attr' => 'border-width',
		  			),

						array(
		  				'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .woocommerce ul.products li.product:border-radius',
		  				'type' => 'dimensions',
		  				'title' => __('Border radius', 'mfn-opts'),
							'responsive' => 'desktop',
							'class' => 'mfn_field_desktop mfn-toggled',
							'css_attr' => 'border-radius',
		  			),

		  			array(
		  				'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .woocommerce ul.products li.product:border-radius_tablet',
		  				'type' => 'dimensions',
		  				'title' => __('Border radius', 'mfn-opts'),
							'responsive' => 'tablet',
							'class' => 'mfn_field_tablet mfn-toggled',
							'css_attr' => 'border-radius',
		  			),

		  			array(
		  				'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .woocommerce ul.products li.product:border-radius_mobile',
		  				'type' => 'dimensions',
		  				'title' => __('Border radius', 'mfn-opts'),
							'responsive' => 'mobile',
							'class' => 'mfn_field_mobile mfn-toggled',
							'css_attr' => 'border-radius',
		  			),

		  			array(
							'class' => 'toggled_header',
							'title' => __('Image', 'mfn-opts'),
						),

						array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .woocommerce ul.products li.product .image_frame:border-style',
							'attr_id' => 'border_style_sc-img',
							'type' => 'select',
							'class' => 'mfn-toggled',
							'title' => __('Border style', 'mfn-opts'),
							'options' => [
								'none' => __('None', 'mfn-opts'),
								'solid' => __('Solid', 'mfn-opts'),
								'dashed' => __('Dashed', 'mfn-opts'),
								'dotted' => __('Dotted', 'mfn-opts'),
								'double' => __('Double', 'mfn-opts'),
							],
						),

						array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .woocommerce ul.products li.product .image_frame:border-color',
							'condition' => array( 'id' => 'border_style_sc-img', 'opt' => 'isnt', 'val' => 'none' ),
							'type' => 'color',
							'class' => 'mfn-toggled',
							'title' => __('Border color', 'mfn-opts'),
						),

						array(
		  				'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .woocommerce ul.products li.product .image_frame:border-width',
		  				'condition' => array( 'id' => 'border_style_sc-img', 'opt' => 'isnt', 'val' => 'none' ),
		  				'type' => 'dimensions',
		  				'title' => __('Border width', 'mfn-opts'),
							'responsive' => 'desktop',
							'class' => 'mfn_field_desktop mfn-toggled',
							'css_attr' => 'border-width',
		  			),

		  			array(
		  				'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .woocommerce ul.products li.product .image_frame:border-width_tablet',
		  				'condition' => array( 'id' => 'border_style_sc-img', 'opt' => 'isnt', 'val' => 'none' ),
		  				'type' => 'dimensions',
		  				'title' => __('Border width', 'mfn-opts'),
							'responsive' => 'tablet',
							'class' => 'mfn_field_tablet mfn-toggled',
							'css_attr' => 'border-width',
		  			),

		  			array(
		  				'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .woocommerce ul.products li.product .image_frame:border-width_mobile',
		  				'condition' => array( 'id' => 'border_style_sc-img', 'opt' => 'isnt', 'val' => 'none' ),
		  				'type' => 'dimensions',
		  				'title' => __('Border width', 'mfn-opts'),
							'responsive' => 'mobile',
							'class' => 'mfn_field_mobile mfn-toggled',
							'css_attr' => 'border-width',
		  			),

						array(
		  				'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .woocommerce ul.products li.product .image_frame:border-radius',
		  				'type' => 'dimensions',
		  				'title' => __('Border radius', 'mfn-opts'),
							'responsive' => 'desktop',
							'class' => 'mfn_field_desktop mfn-toggled',
							'css_attr' => 'border-radius',
		  			),

		  			array(
		  				'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .woocommerce ul.products li.product .image_frame:border-radius_tablet',
		  				'type' => 'dimensions',
		  				'title' => __('Border radius', 'mfn-opts'),
							'responsive' => 'tablet',
							'class' => 'mfn_field_tablet mfn-toggled',
							'css_attr' => 'border-radius',
		  			),

		  			array(
		  				'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .woocommerce ul.products li.product .image_frame:border-radius_mobile',
		  				'type' => 'dimensions',
		  				'title' => __('Border radius', 'mfn-opts'),
							'responsive' => 'mobile',
							'class' => 'mfn_field_mobile mfn-toggled',
							'css_attr' => 'border-radius',
		  			),

		  			array(
							'class' => 'toggled_header',
   						'title' => __('Content', 'mfn-opts'),
   					),

   					array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .woocommerce ul.products li.product .desc:background-color',
							'type' => 'color',
							'class' => 'main-color mfn-toggled',
							'title' => __('Background', 'mfn-opts'),
						),

		  			array(
   						'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .woocommerce ul.products li.product .desc:text-align',
							'responsive' => 'desktop',
   						'type' => 'switch',
   						'class' => 'mfn-toggled mfn_field_desktop',
   						'title' => __('Align', 'mfn-opts'),
   						'options' => array(
   							'' => __('Default', 'mfn-opts'),
   							'left' => __('Left', 'mfn-opts'),
								'center' => __('Center', 'mfn-opts'),
   							'right' => __('Right', 'mfn-opts'),
   							'justify' => __('Justify', 'mfn-opts'),
   						),
							'preview' => 'align',
   					),

   					array(
   						'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .woocommerce ul.products li.product .desc:text-align_tablet',
							'responsive' => 'tablet',
   						'type' => 'switch',
   						'class' => 'mfn-toggled mfn_field_tablet',
   						'title' => __('Align', 'mfn-opts'),
   						'options' => array(
   							'' => __('Default', 'mfn-opts'),
   							'left' => __('Left', 'mfn-opts'),
								'center' => __('Center', 'mfn-opts'),
   							'right' => __('Right', 'mfn-opts'),
   							'justify' => __('Justify', 'mfn-opts'),
   						),
							'preview' => 'align',
   					),

   					array(
   						'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .woocommerce ul.products li.product .desc:text-align_mobile',
							'responsive' => 'mobile',
   						'type' => 'switch',
   						'class' => 'mfn-toggled mfn_field_mobile',
   						'title' => __('Align', 'mfn-opts'),
   						'options' => array(
   							'' => __('Default', 'mfn-opts'),
   							'left' => __('Left', 'mfn-opts'),
								'center' => __('Center', 'mfn-opts'),
   							'right' => __('Right', 'mfn-opts'),
   							'justify' => __('Justify', 'mfn-opts'),
   						),
							'preview' => 'align',
   					),

   					array(
		  				'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .woocommerce ul.products li.product .desc:margin',
		  				'type' => 'dimensions',
		  				'title' => __('Margin', 'mfn-opts'),
							'responsive' => 'desktop',
							'version' => 'separated-fields',
							'class' => 'mfn_field_desktop mfn-toggled',
							'css_attr' => 'margin',
		  			),

		  			array(
		  				'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .woocommerce ul.products li.product .desc:margin_tablet',
		  				'type' => 'dimensions',
		  				'title' => __('Margin', 'mfn-opts'),
							'responsive' => 'tablet',
							'version' => 'separated-fields',
							'class' => 'mfn_field_tablet mfn-toggled',
							'css_attr' => 'margin',
		  			),

		  			array(
		  				'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .woocommerce ul.products li.product .desc:margin_mobile',
		  				'type' => 'dimensions',
		  				'title' => __('Margin', 'mfn-opts'),
							'responsive' => 'mobile',
							'version' => 'separated-fields',
							'class' => 'mfn_field_mobile mfn-toggled',
							'css_attr' => 'margin',
		  			),

		  			array(
		  				'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .woocommerce ul.products li.product .desc:padding',
		  				'type' => 'dimensions',
		  				'title' => __('Padding', 'mfn-opts'),
							'responsive' => 'desktop',
							'version' => 'separated-fields',
							'class' => 'mfn_field_desktop mfn-toggled',
							'css_attr' => 'padding',
		  			),

		  			array(
		  				'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .woocommerce ul.products li.product .desc:padding_tablet',
		  				'type' => 'dimensions',
		  				'title' => __('Padding', 'mfn-opts'),
							'responsive' => 'tablet',
							'version' => 'separated-fields',
							'class' => 'mfn_field_tablet mfn-toggled',
							'css_attr' => 'padding',
		  			),

		  			array(
		  				'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .woocommerce ul.products li.product .desc:padding_mobile',
		  				'type' => 'dimensions',
		  				'title' => __('Padding', 'mfn-opts'),
							'responsive' => 'mobile',
							'version' => 'separated-fields',
							'class' => 'mfn_field_mobile mfn-toggled',
							'css_attr' => 'padding',
		  			),

		  			array(
							'class' => 'toggled_header',
   						'title' => __('Title', 'mfn-opts'),
   					),

						array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .woocommerce ul.products li.product h4 a:color',
							'type' => 'color',
							'class' => 'mfn-toggled',
							'title' => __('Color', 'mfn-opts'),
						),

						array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .woocommerce ul.products li.product h4:typography',
							'type' => 'typography_vb',
							'label_after' => '<a href="#" title="Edit" class="mfn-option-btn mfn-option-blank btn-medium mfn-vb-label-button"><span class="mfn-icon mfn-icon-edit"></span></a>',
							'class' => 'mfn-toggled toggle_fields',
							'title' => __('Typography', 'mfn-opts'),
						),

						array(
		  				'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .woocommerce ul.products li.product h4:margin',
		  				'type' => 'dimensions',
		  				'title' => __('Margin', 'mfn-opts'),
							'responsive' => 'desktop',
							'version' => 'separated-fields',
							'class' => 'mfn_field_desktop mfn-toggled',
							'css_attr' => 'margin',
		  			),

		  			array(
		  				'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .woocommerce ul.products li.product h4:margin_tablet',
		  				'type' => 'dimensions',
		  				'title' => __('Margin', 'mfn-opts'),
							'responsive' => 'tablet',
							'version' => 'separated-fields',
							'class' => 'mfn_field_tablet mfn-toggled',
							'css_attr' => 'margin',
		  			),

		  			array(
		  				'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .woocommerce ul.products li.product h4:margin_mobile',
		  				'type' => 'dimensions',
		  				'title' => __('Margin', 'mfn-opts'),
							'responsive' => 'mobile',
							'version' => 'separated-fields',
							'class' => 'mfn_field_mobile mfn-toggled',
							'css_attr' => 'margin',
		  			),

		  			array(
							'class' => 'toggled_header',
   						'title' => __('Price', 'mfn-opts'),
   					),

						array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .woocommerce ul.products li.product .price:color',
							'type' => 'color',
							'class' => 'mfn-toggled',
							'title' => __('Color', 'mfn-opts'),
						),

						array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .woocommerce ul.products li.product .price:typography',
							'type' => 'typography_vb',
							'label_after' => '<a href="#" title="Edit" class="mfn-option-btn mfn-option-blank btn-medium mfn-vb-label-button"><span class="mfn-icon mfn-icon-edit"></span></a>',
							'class' => 'mfn-toggled toggle_fields',
							'title' => __('Typography', 'mfn-opts'),
						),

						array(
		  				'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .woocommerce ul.products li.product .price:margin',
		  				'type' => 'dimensions',
		  				'title' => __('Margin', 'mfn-opts'),
							'responsive' => 'desktop',
							'version' => 'separated-fields',
							'class' => 'mfn_field_desktop mfn-toggled',
							'css_attr' => 'margin',
		  			),

		  			array(
		  				'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .woocommerce ul.products li.product .price:margin_tablet',
		  				'type' => 'dimensions',
		  				'title' => __('Margin', 'mfn-opts'),
							'responsive' => 'tablet',
							'version' => 'separated-fields',
							'class' => 'mfn_field_tablet mfn-toggled',
							'css_attr' => 'margin',
		  			),

		  			array(
		  				'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .woocommerce ul.products li.product .price:margin_mobile',
		  				'type' => 'dimensions',
		  				'title' => __('Margin', 'mfn-opts'),
							'responsive' => 'mobile',
							'version' => 'separated-fields',
							'class' => 'mfn_field_mobile mfn-toggled',
							'css_attr' => 'margin',
		  			),

		  			array(
							'class' => 'toggled_header',
   						'title' => __('Regular price', 'mfn-opts'),
   					),

						array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .woocommerce ul.products li.product .price del:color',
							'type' => 'color',
							'class' => 'mfn-toggled',
							'title' => __('Color', 'mfn-opts'),
						),

						array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .woocommerce ul.products li.product .price del:typography',
							'type' => 'typography_vb',
							'label_after' => '<a href="#" title="Edit" class="mfn-option-btn mfn-option-blank btn-medium mfn-vb-label-button"><span class="mfn-icon mfn-icon-edit"></span></a>',
							'class' => 'mfn-toggled toggle_fields',
							'title' => __('Typography', 'mfn-opts'),
						),

						array(
							'class' => 'toggled_header',
   						'title' => __('Excerpt', 'mfn-opts'),
   					),

						array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .woocommerce ul.products li.product .excerpt:color',
							'type' => 'color',
							'class' => 'mfn-toggled',
							'title' => __('Color', 'mfn-opts'),
						),

						array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .woocommerce ul.products li.product .excerpt:typography',
							'type' => 'typography_vb',
							'label_after' => '<a href="#" title="Edit" class="mfn-option-btn mfn-option-blank btn-medium mfn-vb-label-button"><span class="mfn-icon mfn-icon-edit"></span></a>',
							'class' => 'mfn-toggled toggle_fields',
							'title' => __('Typography', 'mfn-opts'),
						),

						array(
		  				'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .woocommerce ul.products li.product .excerpt:margin',
		  				'type' => 'dimensions',
		  				'title' => __('Margin', 'mfn-opts'),
							'responsive' => 'desktop',
							'version' => 'separated-fields',
							'class' => 'mfn_field_desktop mfn-toggled',
							'css_attr' => 'margin',
		  			),

		  			array(
		  				'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .woocommerce ul.products li.product .excerpt:margin_tablet',
		  				'type' => 'dimensions',
		  				'title' => __('Margin', 'mfn-opts'),
							'responsive' => 'tablet',
							'version' => 'separated-fields',
							'class' => 'mfn_field_tablet mfn-toggled',
							'css_attr' => 'margin',
		  			),

		  			array(
		  				'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .woocommerce ul.products li.product .excerpt:margin_mobile',
		  				'type' => 'dimensions',
		  				'title' => __('Margin', 'mfn-opts'),
							'responsive' => 'mobile',
							'version' => 'separated-fields',
							'class' => 'mfn_field_mobile mfn-toggled',
							'css_attr' => 'margin',
		  			),

		  			array(
							'class' => 'toggled_header',
   						'title' => __('Button', 'mfn-opts'),
   					),

		  			array(
		  				'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .woocommerce ul.products li.product .button:padding',
		  				'type' => 'dimensions',
		  				'version' => 'separated-fields',
		  				'title' => __('Padding', 'mfn-opts'),
							'responsive' => 'desktop',
							'class' => 'mfn_field_desktop mfn-toggled',
							'css_attr' => 'padding',
		  			),

		  			array(
		  				'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .woocommerce ul.products li.product .button:padding_tablet',
		  				'type' => 'dimensions',
		  				'version' => 'separated-fields',
		  				'title' => __('Padding', 'mfn-opts'),
							'responsive' => 'tablet',
							'class' => 'mfn_field_tablet mfn-toggled',
							'css_attr' => 'padding',
		  			),

		  			array(
		  				'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .woocommerce ul.products li.product .button:padding_mobile',
		  				'type' => 'dimensions',
		  				'version' => 'separated-fields',
		  				'title' => __('Padding', 'mfn-opts'),
							'responsive' => 'mobile',
							'class' => 'mfn_field_mobile mfn-toggled',
							'css_attr' => 'padding',
		  			),

		  			array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .woocommerce ul.products li.product .button:typography',
							'type' => 'typography_vb',
							'label_after' => '<a href="#" title="Edit" class="mfn-option-btn mfn-option-blank btn-medium mfn-vb-label-button"><span class="mfn-icon mfn-icon-edit"></span></a>',
							'class' => 'mfn-toggled toggle_fields',
							'title' => __('Typography', 'mfn-opts'),
						),

						array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .woocommerce ul.products li.product .button:border-style',
							'attr_id' => 'border_style_shop',
							'type' => 'select',
							'class' => 'mfn-toggled',
							'title' => __('Border style', 'mfn-opts'),
							'options' => [
								'none' => __('None', 'mfn-opts'),
								'solid' => __('Solid', 'mfn-opts'),
								'dashed' => __('Dashed', 'mfn-opts'),
								'dotted' => __('Dotted', 'mfn-opts'),
								'double' => __('Double', 'mfn-opts'),
							],
						),

						array(
		  				'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .woocommerce ul.products li.product .button:border-width',
		  				'condition' => array( 'id' => 'border_style_shop', 'opt' => 'isnt', 'val' => 'none' ),
		  				'type' => 'dimensions',
		  				'title' => __('Border width', 'mfn-opts'),
							'responsive' => 'desktop',
							'class' => 'mfn_field_desktop mfn-toggled',
							'css_attr' => 'border-width',
		  			),

		  			array(
		  				'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .woocommerce ul.products li.product .button:border-width_tablet',
		  				'condition' => array( 'id' => 'border_style_shop', 'opt' => 'isnt', 'val' => 'none' ),
		  				'type' => 'dimensions',
		  				'title' => __('Border width', 'mfn-opts'),
							'responsive' => 'tablet',
							'class' => 'mfn_field_tablet mfn-toggled',
							'css_attr' => 'border-width',
		  			),

		  			array(
		  				'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .woocommerce ul.products li.product .button:border-width_mobile',
		  				'condition' => array( 'id' => 'border_style_shop', 'opt' => 'isnt', 'val' => 'none' ),
		  				'type' => 'dimensions',
		  				'title' => __('Border width', 'mfn-opts'),
							'responsive' => 'mobile',
							'class' => 'mfn_field_mobile mfn-toggled',
							'css_attr' => 'border-width',
		  			),

						array(
		  				'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .woocommerce ul.products li.product .button:border-radius',
		  				'type' => 'dimensions',
		  				'title' => __('Border radius', 'mfn-opts'),
							'responsive' => 'desktop',
							'class' => 'mfn_field_desktop mfn-toggled',
							'css_attr' => 'border-radius',
		  			),

		  			array(
		  				'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .woocommerce ul.products li.product .button:border-radius_tablet',
		  				'type' => 'dimensions',
		  				'title' => __('Border radius', 'mfn-opts'),
							'responsive' => 'tablet',
							'class' => 'mfn_field_tablet mfn-toggled',
							'css_attr' => 'border-radius',
		  			),

		  			array(
		  				'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .woocommerce ul.products li.product .button:border-radius_mobile',
		  				'type' => 'dimensions',
		  				'title' => __('Border radius', 'mfn-opts'),
							'responsive' => 'mobile',
							'class' => 'mfn_field_mobile mfn-toggled',
							'css_attr' => 'border-radius',
		  			),

   					array(
							'type' => 'html',
							'html' => '<div class="mfn-form-row mfn-sidebar-fields-tabs mfn-toggled mfn-vb-formrow mfn-vb-mfnuidhere"><ul class="mfn-sft-nav"><li class="active"><a href="#normal" data-tab="normal">Normal</a></li><li><a href="#hover" data-tab="hover">Hover</a></li></ul><div class="mfn-sft mfn-sft-normal">',
						),

						array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .woocommerce ul.products li.product .button:color',
							'type' => 'color',
							'class' => 'main-color mfn-toggled',
							'title' => __('Color', 'mfn-opts'),
						),

						array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .woocommerce ul.products li.product .button:border-color',
							'condition' => array( 'id' => 'border_style_shop', 'opt' => 'isnt', 'val' => 'none' ),
							'type' => 'color',
							'class' => 'mfn-toggled',
							'title' => __('Border color', 'mfn-opts'),
						),

						array(
							'id' => 'background_switcher',
							'attr_id' => 'background_switcher_shop',
							'type' => 'switch',
							'class' => 'mfn-fields-switcher',
							'title' => __('Background type', 'mfn-opts'),
							'options' => array(
		  					'default' => __('Default', 'mfn-opts'),
		  					'gradient' 	=> __('Gradient', 'mfn-opts'),
		  				),
							'visual_options' => array(
		  					'default' => '',
		  					'gradient' 	=> '',
		  				),
		  				'std' => 'default',
						),

						array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .woocommerce ul.products li.product .button:background-color',
							'condition' => array( 'id' => 'background_switcher_shop', 'opt' => 'is', 'val' => 'default' ),
							'type' => 'color',
							'title' => __('Background color', 'mfn-opts'),
						),

						array(
		  				'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .woocommerce ul.products li.product .button:gradient',
		  				'condition' => array( 'id' => 'background_switcher_shop', 'opt' => 'is', 'val' => 'gradient' ),
		  				'type' => 'gradient',
		  				'title' => __('Gradient', 'mfn-opts'),
		  				'class' => 'mfn-toggled',
							'css_attr' => 'gradient',
		  			),

						array(
							'type' => 'html',
							'html' => '</div><div class="mfn-sft mfn-sft-hover">',
						),

						array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .woocommerce ul.products li.product .button|hover:color',
							'type' => 'color',
							'class' => 'main-color mfn-toggled',
							'title' => __('Color', 'mfn-opts'),
						),

						array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .woocommerce ul.products li.product .button|hover:border-color',
							'condition' => array( 'id' => 'border_style_shop', 'opt' => 'isnt', 'val' => 'none' ),
							'type' => 'color',
							'class' => 'mfn-toggled',
							'title' => __('Border color', 'mfn-opts'),
						),

						array(
							'id' => 'background_switcher_hover',
							'attr_id' => 'background_switcher_hover_shop',
							'type' => 'switch',
							'class' => 'mfn-fields-switcher',
							'title' => __('Background type', 'mfn-opts'),
							'options' => array(
		  					'default' => __('Default', 'mfn-opts'),
		  					'gradient' 	=> __('Gradient', 'mfn-opts'),
		  				),
							'visual_options' => array(
		  					'default' => '',
		  					'gradient' 	=> '',
		  				),
		  				'std' => 'default',
						),

						array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .woocommerce ul.products li.product .button|hover:background',
							'condition' => array( 'id' => 'background_switcher_hover_shop', 'opt' => 'is', 'val' => 'default' ),
							'type' => 'color',
							'class' => 'main-color mfn-toggled',
							'title' => __('Background color', 'mfn-opts'),
						),

						array(
		  				'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .woocommerce ul.products li.product .button|hover:gradient',
		  				'condition' => array( 'id' => 'background_switcher_hover_shop', 'opt' => 'is', 'val' => 'gradient' ),
		  				'type' => 'gradient',
		  				'title' => __('Gradient', 'mfn-opts'),
		  				'class' => 'mfn-toggled',
							'css_attr' => 'gradient',
		  			),

						array(
							'type' => 'html',
							'html' => '</div></div>',
						),

						array(
							'type' => 'html',
							'html' => '</div>',
						),

   				),
   			),

   			// Shop Slider ----------------------------------------------------

   			'shop_slider' => array(
   				'type' => 'shop_slider',
   				'title' => __('Shop Slider', 'mfn-opts'),
   				'size' => '1/1',
   				'tablet_size' => '1/1',
   				'mobile_size' => '1/1',
   				'tablet_resized' => '0',
   				'cat' => 'loops',
   				'fields' => array(

   					array(
							'type' => 'html',
							'html' => $this->itemtabs,
						),

   					array(
							'type' => 'html',
							'html' => '<div class="modalbox-card modalbox-re_render modalbox-card-content-mfnuidhere active">',
						),

   					array(
   						'id' => 'title',
   						'type' => 'text',
   						'edit_tag' => '.blog_slider_header | h4.title',
   						'edit_position' => 'prepend',
   						'title' => __('Title', 'mfn-opts'),
							'std' => __('This is the title', 'mfn-opts'),
							'preview' => 'title',
   					),

   					array(
   						'id' => 'count',
   						're_render' => 'standard',
   						'type' => 'text',
   						'title' => __('Products number', 'mfn-opts'),
   						'std' => '5',
							'after' => 'products',
   						'param' => 'number',
   						'class' => 'narrow',
							'preview' => 'number',
   					),

   					array(
   						'id' => 'show',
   						're_render' => 'standard',
   						'type' => 'select',
   						'title' => __('Display', 'mfn-opts'),
   						'options' => array(
   							'' => __('All (or category selected below)', 'mfn-opts'),
   							'featured' => __('Featured', 'mfn-opts'),
   							'onsale' => __('Onsale', 'mfn-opts'),
   							'best-selling' => __('Best Selling (order by: Sales)', 'mfn-opts'),
   						),
   					),

						// options

   					array(
   						'title' => __('Options', 'mfn-opts'),
   					),

   					array(
   						'id' => 'category',
   						're_render' => 'standard',
   						'type' => 'select',
   						'title' => __('Category', 'mfn-opts'),
   						'options' => mfn_get_categories('product_cat'),
							'preview' => 'category',
   					),

   					array(
   						'id' => 'orderby',
   						're_render' => 'standard',
   						'type' => 'switch',
   						'title' => __('Order by', 'mfn-opts'),
   						'options' => array(
   							'date' => __('Date', 'mfn-opts'),
   							'title' => __('Title', 'mfn-opts'),
   						),
   						'std' => 'date'
   					),

   					array(
   						'id' => 'order',
   						're_render' => 'standard',
   						'type' => 'switch',
   						'title' => __('Order', 'mfn-opts'),
   						'options' => array(
   							'ASC' => __('Ascending', 'mfn-opts'),
   							'DESC' => __('Descending', 'mfn-opts'),
   						),
   						'std' => 'DESC'
   					),

						// deprecated

						array(
							'class' => 'mfn-deprecated',
							'title' => __('Deprecated', 'mfn-opts'),
						),

						array(
							'id' => 'class',
							'type' => 'pills',
							'title' => __('Element classes', 'mfn-opts'),
							'class' => 'mfn-deprecated',
						),

						array(
							'type' => 'html',
							'html' => '</div><div class="modalbox-card modalbox-card-style modalbox-re_render modalbox-card-style-mfnuidhere">',
						),

						array(
							'class' => 'toggled_header',
   						'title' => __('Item title', 'mfn-opts'),
   					),

						array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .blog_slider_header .title:color',
							'type' => 'color',
							'class' => 'mfn-toggled',
							'title' => __('Color', 'mfn-opts'),
						),

						array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .blog_slider_header .title:typography',
							'type' => 'typography_vb',
							'label_after' => '<a href="#" title="Edit" class="mfn-option-btn mfn-option-blank btn-medium mfn-vb-label-button"><span class="mfn-icon mfn-icon-edit"></span></a>',
							'class' => 'mfn-toggled toggle_fields',
							'title' => __('Typography', 'mfn-opts'),
						),

						array(
		  				'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .blog_slider_header .title:margin',
		  				'type' => 'dimensions',
		  				'title' => __('Margin', 'mfn-opts'),
							'responsive' => 'desktop',
							'version' => 'separated-fields',
							'class' => 'mfn_field_desktop mfn-toggled',
							'css_attr' => 'margin',
		  			),

		  			array(
		  				'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .blog_slider_header .title:margin_tablet',
		  				'type' => 'dimensions',
		  				'title' => __('Margin', 'mfn-opts'),
							'responsive' => 'tablet',
							'version' => 'separated-fields',
							'class' => 'mfn_field_tablet mfn-toggled',
							'css_attr' => 'margin',
		  			),

		  			array(
		  				'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .blog_slider_header .title:margin_mobile',
		  				'type' => 'dimensions',
		  				'title' => __('Margin', 'mfn-opts'),
							'responsive' => 'mobile',
							'version' => 'separated-fields',
							'class' => 'mfn_field_mobile mfn-toggled',
							'css_attr' => 'margin',
		  			),

		  			array(
							'class' => 'toggled_header',
							'title' => __('Image', 'mfn-opts'),
						),

						array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .shop_slider .shop_slider_ul li .image_frame:border-style',
							'attr_id' => 'border_style_sc-img',
							'type' => 'select',
							'class' => 'mfn-toggled',
							'title' => __('Border style', 'mfn-opts'),
							'options' => [
								'none' => __('None', 'mfn-opts'),
								'solid' => __('Solid', 'mfn-opts'),
								'dashed' => __('Dashed', 'mfn-opts'),
								'dotted' => __('Dotted', 'mfn-opts'),
								'double' => __('Double', 'mfn-opts'),
							],
						),

						array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .shop_slider .shop_slider_ul li .image_frame:border-color',
							'condition' => array( 'id' => 'border_style_sc-img', 'opt' => 'isnt', 'val' => 'none' ),
							'type' => 'color',
							'class' => 'mfn-toggled',
							'title' => __('Border color', 'mfn-opts'),
						),

						array(
		  				'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .shop_slider .shop_slider_ul li .image_frame:border-width',
		  				'condition' => array( 'id' => 'border_style_sc-img', 'opt' => 'isnt', 'val' => 'none' ),
		  				'type' => 'dimensions',
		  				'title' => __('Border width', 'mfn-opts'),
							'responsive' => 'desktop',
							'class' => 'mfn_field_desktop mfn-toggled',
							'css_attr' => 'border-width',
		  			),

		  			array(
		  				'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .shop_slider .shop_slider_ul li .image_frame:border-width_tablet',
		  				'condition' => array( 'id' => 'border_style_sc-img', 'opt' => 'isnt', 'val' => 'none' ),
		  				'type' => 'dimensions',
		  				'title' => __('Border width', 'mfn-opts'),
							'responsive' => 'tablet',
							'class' => 'mfn_field_tablet mfn-toggled',
							'css_attr' => 'border-width',
		  			),

		  			array(
		  				'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .shop_slider .shop_slider_ul li .image_frame:border-width_mobile',
		  				'condition' => array( 'id' => 'border_style_sc-img', 'opt' => 'isnt', 'val' => 'none' ),
		  				'type' => 'dimensions',
		  				'title' => __('Border width', 'mfn-opts'),
							'responsive' => 'mobile',
							'class' => 'mfn_field_mobile mfn-toggled',
							'css_attr' => 'border-width',
		  			),

						array(
		  				'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .shop_slider .shop_slider_ul li .image_frame:border-radius',
		  				'type' => 'dimensions',
		  				'title' => __('Border radius', 'mfn-opts'),
							'responsive' => 'desktop',
							'class' => 'mfn_field_desktop mfn-toggled',
							'css_attr' => 'border-radius',
		  			),

		  			array(
		  				'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .shop_slider .shop_slider_ul li .image_frame:border-radius_tablet',
		  				'type' => 'dimensions',
		  				'title' => __('Border radius', 'mfn-opts'),
							'responsive' => 'tablet',
							'class' => 'mfn_field_tablet mfn-toggled',
							'css_attr' => 'border-radius',
		  			),

		  			array(
		  				'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .shop_slider .shop_slider_ul li .image_frame:border-radius_mobile',
		  				'type' => 'dimensions',
		  				'title' => __('Border radius', 'mfn-opts'),
							'responsive' => 'mobile',
							'class' => 'mfn_field_mobile mfn-toggled',
							'css_attr' => 'border-radius',
		  			),

		  			array(
							'class' => 'toggled_header',
   						'title' => __('Content', 'mfn-opts'),
   					),

   					array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .shop_slider .shop_slider_ul li .desc:background-color',
							'type' => 'color',
							'class' => 'main-color mfn-toggled',
							'title' => __('Background', 'mfn-opts'),
						),

		  			array(
   						'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .shop_slider .shop_slider_ul li .desc:text-align',
							'responsive' => 'desktop',
   						'type' => 'switch',
   						'class' => 'mfn-toggled mfn_field_desktop',
   						'title' => __('Align', 'mfn-opts'),
   						'options' => array(
   							'' => __('Default', 'mfn-opts'),
   							'left' => __('Left', 'mfn-opts'),
								'center' => __('Center', 'mfn-opts'),
   							'right' => __('Right', 'mfn-opts'),
   							'justify' => __('Justify', 'mfn-opts'),
   						),
							'preview' => 'align',
   					),

   					array(
   						'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .shop_slider .shop_slider_ul li .desc:text-align_tablet',
							'responsive' => 'tablet',
   						'type' => 'switch',
   						'class' => 'mfn-toggled mfn_field_tablet',
   						'title' => __('Align', 'mfn-opts'),
   						'options' => array(
   							'' => __('Default', 'mfn-opts'),
   							'left' => __('Left', 'mfn-opts'),
								'center' => __('Center', 'mfn-opts'),
   							'right' => __('Right', 'mfn-opts'),
   							'justify' => __('Justify', 'mfn-opts'),
   						),
							'preview' => 'align',
   					),

   					array(
   						'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .shop_slider .shop_slider_ul li .desc:text-align_mobile',
							'responsive' => 'mobile',
   						'type' => 'switch',
   						'class' => 'mfn-toggled mfn_field_mobile',
   						'title' => __('Align', 'mfn-opts'),
   						'options' => array(
   							'' => __('Default', 'mfn-opts'),
   							'left' => __('Left', 'mfn-opts'),
								'center' => __('Center', 'mfn-opts'),
   							'right' => __('Right', 'mfn-opts'),
   							'justify' => __('Justify', 'mfn-opts'),
   						),
							'preview' => 'align',
   					),

   					array(
		  				'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .shop_slider .shop_slider_ul li .desc:margin',
		  				'type' => 'dimensions',
		  				'title' => __('Margin', 'mfn-opts'),
							'responsive' => 'desktop',
							'version' => 'separated-fields',
							'class' => 'mfn_field_desktop mfn-toggled',
							'css_attr' => 'margin',
		  			),

		  			array(
		  				'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .shop_slider .shop_slider_ul li .desc:margin_tablet',
		  				'type' => 'dimensions',
		  				'title' => __('Margin', 'mfn-opts'),
							'responsive' => 'tablet',
							'version' => 'separated-fields',
							'class' => 'mfn_field_tablet mfn-toggled',
							'css_attr' => 'margin',
		  			),

		  			array(
		  				'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .shop_slider .shop_slider_ul li .desc:margin_mobile',
		  				'type' => 'dimensions',
		  				'title' => __('Margin', 'mfn-opts'),
							'responsive' => 'mobile',
							'version' => 'separated-fields',
							'class' => 'mfn_field_mobile mfn-toggled',
							'css_attr' => 'margin',
		  			),

		  			array(
		  				'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .shop_slider .shop_slider_ul li .desc:padding',
		  				'type' => 'dimensions',
		  				'title' => __('Padding', 'mfn-opts'),
							'responsive' => 'desktop',
							'version' => 'separated-fields',
							'class' => 'mfn_field_desktop mfn-toggled',
							'css_attr' => 'padding',
		  			),

		  			array(
		  				'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .shop_slider .shop_slider_ul li .desc:padding_tablet',
		  				'type' => 'dimensions',
		  				'title' => __('Padding', 'mfn-opts'),
							'responsive' => 'tablet',
							'version' => 'separated-fields',
							'class' => 'mfn_field_tablet mfn-toggled',
							'css_attr' => 'padding',
		  			),

		  			array(
		  				'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .shop_slider .shop_slider_ul li .desc:padding_mobile',
		  				'type' => 'dimensions',
		  				'title' => __('Padding', 'mfn-opts'),
							'responsive' => 'mobile',
							'version' => 'separated-fields',
							'class' => 'mfn_field_mobile mfn-toggled',
							'css_attr' => 'padding',
		  			),

		  			array(
							'class' => 'toggled_header',
   						'title' => __('Title', 'mfn-opts'),
   					),

						array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .shop_slider .shop_slider_ul li h4 a:color',
							'type' => 'color',
							'class' => 'mfn-toggled',
							'title' => __('Color', 'mfn-opts'),
						),

						array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .shop_slider .shop_slider_ul li h4:typography',
							'type' => 'typography_vb',
							'label_after' => '<a href="#" title="Edit" class="mfn-option-btn mfn-option-blank btn-medium mfn-vb-label-button"><span class="mfn-icon mfn-icon-edit"></span></a>',
							'class' => 'mfn-toggled toggle_fields',
							'title' => __('Typography', 'mfn-opts'),
						),

						array(
		  				'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .shop_slider .shop_slider_ul li h4:margin',
		  				'type' => 'dimensions',
		  				'title' => __('Margin', 'mfn-opts'),
							'responsive' => 'desktop',
							'version' => 'separated-fields',
							'class' => 'mfn_field_desktop mfn-toggled',
							'css_attr' => 'margin',
		  			),

		  			array(
		  				'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .shop_slider .shop_slider_ul li h4:margin_tablet',
		  				'type' => 'dimensions',
		  				'title' => __('Margin', 'mfn-opts'),
							'responsive' => 'tablet',
							'version' => 'separated-fields',
							'class' => 'mfn_field_tablet mfn-toggled',
							'css_attr' => 'margin',
		  			),

		  			array(
		  				'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .shop_slider .shop_slider_ul li h4:margin_mobile',
		  				'type' => 'dimensions',
		  				'title' => __('Margin', 'mfn-opts'),
							'responsive' => 'mobile',
							'version' => 'separated-fields',
							'class' => 'mfn_field_mobile mfn-toggled',
							'css_attr' => 'margin',
		  			),

		  			array(
							'class' => 'toggled_header',
   						'title' => __('Price', 'mfn-opts'),
   					),

						array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .shop_slider .shop_slider_ul li .price:color',
							'type' => 'color',
							'class' => 'mfn-toggled',
							'title' => __('Color', 'mfn-opts'),
						),

						array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .shop_slider .shop_slider_ul li .price:typography',
							'type' => 'typography_vb',
							'label_after' => '<a href="#" title="Edit" class="mfn-option-btn mfn-option-blank btn-medium mfn-vb-label-button"><span class="mfn-icon mfn-icon-edit"></span></a>',
							'class' => 'mfn-toggled toggle_fields',
							'title' => __('Typography', 'mfn-opts'),
						),

						array(
		  				'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .shop_slider .shop_slider_ul li .price:margin',
		  				'type' => 'dimensions',
		  				'title' => __('Margin', 'mfn-opts'),
							'responsive' => 'desktop',
							'version' => 'separated-fields',
							'class' => 'mfn_field_desktop mfn-toggled',
							'css_attr' => 'margin',
		  			),

		  			array(
		  				'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .shop_slider .shop_slider_ul li .price:margin_tablet',
		  				'type' => 'dimensions',
		  				'title' => __('Margin', 'mfn-opts'),
							'responsive' => 'tablet',
							'version' => 'separated-fields',
							'class' => 'mfn_field_tablet mfn-toggled',
							'css_attr' => 'margin',
		  			),

		  			array(
		  				'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .shop_slider .shop_slider_ul li .price:margin_mobile',
		  				'type' => 'dimensions',
		  				'title' => __('Margin', 'mfn-opts'),
							'responsive' => 'mobile',
							'version' => 'separated-fields',
							'class' => 'mfn_field_mobile mfn-toggled',
							'css_attr' => 'margin',
		  			),

		  			array(
							'class' => 'toggled_header',
   						'title' => __('Regular price', 'mfn-opts'),
   					),

						array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .shop_slider .shop_slider_ul li .price del:color',
							'type' => 'color',
							'class' => 'mfn-toggled',
							'title' => __('Color', 'mfn-opts'),
						),

						array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .shop_slider .shop_slider_ul li .price del:typography',
							'type' => 'typography_vb',
							'label_after' => '<a href="#" title="Edit" class="mfn-option-btn mfn-option-blank btn-medium mfn-vb-label-button"><span class="mfn-icon mfn-icon-edit"></span></a>',
							'class' => 'mfn-toggled toggle_fields',
							'title' => __('Typography', 'mfn-opts'),
						),

						array(
							'class' => 'toggled_header',
   						'title' => __('Arrows', 'mfn-opts'),
   					),

		  			array(
		  				'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .shop_slider .button:padding',
		  				'type' => 'dimensions',
		  				'version' => 'separated-fields',
		  				'title' => __('Padding', 'mfn-opts'),
							'responsive' => 'desktop',
							'class' => 'mfn_field_desktop mfn-toggled',
							'css_attr' => 'padding',
		  			),

		  			array(
		  				'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .shop_slider .button:padding_tablet',
		  				'type' => 'dimensions',
		  				'version' => 'separated-fields',
		  				'title' => __('Padding', 'mfn-opts'),
							'responsive' => 'tablet',
							'class' => 'mfn_field_tablet mfn-toggled',
							'css_attr' => 'padding',
		  			),

		  			array(
		  				'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .shop_slider .button:padding_mobile',
		  				'type' => 'dimensions',
		  				'version' => 'separated-fields',
		  				'title' => __('Padding', 'mfn-opts'),
							'responsive' => 'mobile',
							'class' => 'mfn_field_mobile mfn-toggled',
							'css_attr' => 'padding',
		  			),

		  			array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .shop_slider .button:typography',
							'type' => 'typography_vb',
							'label_after' => '<a href="#" title="Edit" class="mfn-option-btn mfn-option-blank btn-medium mfn-vb-label-button"><span class="mfn-icon mfn-icon-edit"></span></a>',
							'class' => 'mfn-toggled toggle_fields',
							'title' => __('Typography', 'mfn-opts'),
						),

						array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .shop_slider .button:border-style',
							'attr_id' => 'border_style_shopslider',
							'type' => 'select',
							'class' => 'mfn-toggled',
							'title' => __('Border style', 'mfn-opts'),
							'options' => [
								'none' => __('None', 'mfn-opts'),
								'solid' => __('Solid', 'mfn-opts'),
								'dashed' => __('Dashed', 'mfn-opts'),
								'dotted' => __('Dotted', 'mfn-opts'),
								'double' => __('Double', 'mfn-opts'),
							],
						),

						array(
		  				'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .shop_slider .button:border-width',
		  				'condition' => array( 'id' => 'border_style_shopslider', 'opt' => 'isnt', 'val' => 'none' ),
		  				'type' => 'dimensions',
		  				'title' => __('Border width', 'mfn-opts'),
							'responsive' => 'desktop',
							'class' => 'mfn_field_desktop mfn-toggled',
							'css_attr' => 'border-width',
		  			),

		  			array(
		  				'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .shop_slider .button:border-width_tablet',
		  				'condition' => array( 'id' => 'border_style_shopslider', 'opt' => 'isnt', 'val' => 'none' ),
		  				'type' => 'dimensions',
		  				'title' => __('Border width', 'mfn-opts'),
							'responsive' => 'tablet',
							'class' => 'mfn_field_tablet mfn-toggled',
							'css_attr' => 'border-width',
		  			),

		  			array(
		  				'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .shop_slider .button:border-width_mobile',
		  				'condition' => array( 'id' => 'border_style_shopslider', 'opt' => 'isnt', 'val' => 'none' ),
		  				'type' => 'dimensions',
		  				'title' => __('Border width', 'mfn-opts'),
							'responsive' => 'mobile',
							'class' => 'mfn_field_mobile mfn-toggled',
							'css_attr' => 'border-width',
		  			),

						array(
		  				'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .shop_slider .button:border-radius',
		  				'type' => 'dimensions',
		  				'title' => __('Border radius', 'mfn-opts'),
							'responsive' => 'desktop',
							'class' => 'mfn_field_desktop mfn-toggled',
							'css_attr' => 'border-radius',
		  			),

		  			array(
		  				'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .shop_slider .button:border-radius_tablet',
		  				'type' => 'dimensions',
		  				'title' => __('Border radius', 'mfn-opts'),
							'responsive' => 'tablet',
							'class' => 'mfn_field_tablet mfn-toggled',
							'css_attr' => 'border-radius',
		  			),

		  			array(
		  				'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .shop_slider .button:border-radius_mobile',
		  				'type' => 'dimensions',
		  				'title' => __('Border radius', 'mfn-opts'),
							'responsive' => 'mobile',
							'class' => 'mfn_field_mobile mfn-toggled',
							'css_attr' => 'border-radius',
		  			),

   					array(
							'type' => 'html',
							'html' => '<div class="mfn-form-row mfn-sidebar-fields-tabs mfn-toggled mfn-vb-formrow mfn-vb-mfnuidhere"><ul class="mfn-sft-nav"><li class="active"><a href="#normal" data-tab="normal">Normal</a></li><li><a href="#hover" data-tab="hover">Hover</a></li></ul><div class="mfn-sft mfn-sft-normal">',
						),

						array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .shop_slider .button:color',
							'type' => 'color',
							'class' => 'main-color mfn-toggled',
							'title' => __('Color', 'mfn-opts'),
						),

						array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .shop_slider .button:border-color',
							'condition' => array( 'id' => 'border_style_shopslider', 'opt' => 'isnt', 'val' => 'none' ),
							'type' => 'color',
							'class' => 'mfn-toggled',
							'title' => __('Border color', 'mfn-opts'),
						),

						array(
							'id' => 'background_switcher',
							'attr_id' => 'background_switcher_shopslider',
							'type' => 'switch',
							'class' => 'mfn-fields-switcher',
							'title' => __('Background type', 'mfn-opts'),
							'options' => array(
		  					'default' => __('Default', 'mfn-opts'),
		  					'gradient' 	=> __('Gradient', 'mfn-opts'),
		  				),
							'visual_options' => array(
		  					'default' => '',
		  					'gradient' 	=> '',
		  				),
		  				'std' => 'default',
						),

						array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .shop_slider .button:background-color',
							'condition' => array( 'id' => 'background_switcher_shopslider', 'opt' => 'is', 'val' => 'default' ),
							'type' => 'color',
							'title' => __('Background color', 'mfn-opts'),
						),

						array(
		  				'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .shop_slider .button:gradient',
		  				'condition' => array( 'id' => 'background_switcher_shopslider', 'opt' => 'is', 'val' => 'gradient' ),
		  				'type' => 'gradient',
		  				'title' => __('Gradient', 'mfn-opts'),
		  				'class' => 'mfn-toggled',
							'css_attr' => 'gradient',
		  			),

						array(
							'type' => 'html',
							'html' => '</div><div class="mfn-sft mfn-sft-hover">',
						),

						array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .shop_slider .button|hover:color',
							'type' => 'color',
							'class' => 'main-color mfn-toggled',
							'title' => __('Color', 'mfn-opts'),
						),

						array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .shop_slider .button|hover:border-color',
							'condition' => array( 'id' => 'border_style_shopslider', 'opt' => 'isnt', 'val' => 'none' ),
							'type' => 'color',
							'class' => 'mfn-toggled',
							'title' => __('Border color', 'mfn-opts'),
						),

						array(
							'id' => 'background_switcher_hover_shopslider',
							'attr_id' => 'background_switcher_hover_shopslider',
							'type' => 'switch',
							'class' => 'mfn-fields-switcher',
							'title' => __('Background type', 'mfn-opts'),
							'options' => array(
		  					'default' => __('Default', 'mfn-opts'),
		  					'gradient' 	=> __('Gradient', 'mfn-opts'),
		  				),
							'visual_options' => array(
		  					'default' => '',
		  					'gradient' 	=> '',
		  				),
		  				'std' => 'default',
						),

						array(
							'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .shop_slider .button|hover:background',
							'condition' => array( 'id' => 'background_switcher_hover_shopslider', 'opt' => 'is', 'val' => 'default' ),
							'type' => 'color',
							'class' => 'main-color mfn-toggled',
							'title' => __('Background color', 'mfn-opts'),
						),

						array(
		  				'id' => 'style:.mcb-section .mcb-wrap .mcb-item-mfnuidelement .shop_slider .button|hover:gradient',
		  				'condition' => array( 'id' => 'background_switcher_hover_shopslider', 'opt' => 'is', 'val' => 'gradient' ),
		  				'type' => 'gradient',
		  				'title' => __('Gradient', 'mfn-opts'),
		  				'class' => 'mfn-toggled',
							'css_attr' => 'gradient',
		  			),

						array(
							'type' => 'html',
							'html' => '</div></div>',
						),

						array(
							'type' => 'html',
							'html' => '</div>',
						),

   				),
   			),

   			// Sidebar Widget -------------------------------------------------

   			'sidebar_widget' => array(
   				'type' => 'sidebar_widget',
   				'title' => __('Sidebar Widget', 'mfn-opts'),
   				'size' => '1/4',
   				'tablet_size' => '1/4',
   				'mobile_size' => '1/4',
   				'tablet_resized' => '0',
   				'cat' => 'other',
   				'fields' => array(

   					array(
							'type' => 'html',
							'html' => '<div class="modalbox-card modalbox-re_render modalbox-card-content-mfnuidhere active">',
						),

   					array(
   						'id' => 'sidebar',
   						'type' => 'select',
   						'title' => __('Select Sidebar', 'mfn-opts'),
   						'desc' => __('1. Create Sidebar in <a target="_blank" href="admin.php?page=be-options#sidebars">Theme Options > Sidebars</a><br />2. Add Widgets<br />3. Select your sidebar.', 'mfn-opts'),
   						'options' => mfn_opts_get('sidebars'),
   					),

						// deprecated

						array(
							'class' => 'mfn-deprecated',
							'title' => __('Deprecated', 'mfn-opts'),
						),

						array(
							'id' => 'class',
							'type' => 'pills',
							'title' => __('Element classes', 'mfn-opts'),
							'class' => 'mfn-deprecated',
						),

						array(
							'type' => 'html',
							'html' => '</div>',
						),

   				),
   			),

   			// Slider ---------------------------------------------------------

   			'slider' => array(
   				'type' => 'slider',
   				'title' => __('Slider', 'mfn-opts'),
   				'size' => '1/1',
   				'tablet_size' => '1/1',
   				'mobile_size' => '1/1',
   				'tablet_resized' => '0',
   				'cat' => 'blocks',
   				'fields' => array(

   					array(
							'type' => 'html',
							'html' => $this->itemtabs,
						),

   					array(
							'type' => 'html',
							'html' => '<div class="modalbox-card modalbox-re_render modalbox-card-content-mfnuidhere active">',
						),

   					array(
   						'id' => 'category',
   						're_render' => 'standard',
   						'type' => 'select',
   						'title' => __('Category', 'mfn-opts'),
   						'options' => mfn_get_categories('slide-types'),
							'preview' => 'category',
   					),

   					array(
   						'id' => 'orderby',
   						'type' => 'switch',
   						're_render' => 'standard',
   						'title' => __('Order by', 'mfn-opts'),
   						'options' => array(
   							'date' => __('Date', 'mfn-opts'),
   							'menu_order' => __('Menu order', 'mfn-opts'),
   							'title' => __('Title', 'mfn-opts'),
   						),
   						'std' => 'date'
   					),

   					array(
   						'id' => 'order',
   						'type' => 'switch',
   						're_render' => 'standard',
   						'title' => __('Order', 'mfn-opts'),
   						'options' => array(
   							'ASC' => __('Ascending', 'mfn-opts'),
   							'DESC' => __('Descending', 'mfn-opts'),
   						),
   						'std' => 'DESC'
   					),

   					// advanced

   					array(
   						'title' => __('Advanced', 'mfn-opts'),
   					),

   					array(
   						'id' => 'style',
   						're_render' => 'standard',
   						'type' => 'select',
							'title' => __('Style', 'mfn-opts'),
   						'options' => array(
   							'' => __('Default', 'mfn-opts'),
   							'flat' => __('Flat', 'mfn-opts'),
   							'description' => __('Flat with title and description', 'mfn-opts'),
   							'carousel' => __('Flat carousel with titles', 'mfn-opts'),
   							'center' => __('Center mode', 'mfn-opts'),
   						),
							'preview' => 'style',
   					),

   					array(
   						'id' => 'navigation',
   						're_render' => 'standard