<?php
class MFN_Options_sliderbar extends Mfn_Options_field
{

	/**
	 * Render
	 */

	public function render( $meta = false, $vb = false )
	{
		$class = array( 'form-group', 'range-slider' );
		$placeholder = '';

		// class

		if( ! empty( $this->field['after'] ) ) {
			$class['has-addons'] = 'has-addons';
			$class[] = 'has-addons-append';
		}

		if( $meta ){
			$class[] = 'pseudo';
		}

		$class = implode( ' ', $class );

		// placeholder

		if( !empty( $this->field['std'] ) ){
			$placeholder = $this->field['std'];
		}

		// parameters

		$min = isset( $this->field['param']['min'] ) ? $this->field['param']['min'] : 1;
		$max = isset( $this->field['param']['max'] ) ? $this->field['param']['max'] : 100;
		$step = isset( $this->field['param']['step'] ) ? $this->field['param']['step'] : 1;
		$unit = isset( $this->field['param']['unit'] ) ? $this->field['param']['unit'] : 'px';

		$clean_value = '';

		if( isset( $this->field['units'] ) ){

			if( ! empty( $this->value ) ){

				$clean_value = str_replace(array('px', 'rem', 'em', '%', 'vw', 'vh'), '', $this->value);

				if( strpos($this->value, 'rem') !== false ){
					$unit = 'rem';
				}else if( strpos($this->value, 'em') !== false ){
					$unit = 'em';
				}else if( strpos($this->value, 'vw') !== false ){
					$unit = 'vw';
				}else if( strpos($this->value, 'vh') !== false ){
					$unit = 'vh';
				}else if( strpos($this->value, '%') !== false ){
					$unit = '%';
				}
			}

		} elseif( isset( $this->value ) ){

			$clean_value = str_replace( $unit, '', $this->value );
			
		}

		// output -----

		echo '<div class="'. esc_attr( $class ) .'">';

			// units

			if( isset( $this->field['units'] ) ){
				echo '<ul class="mfn-slider-unit">';
					foreach ($this->field['units'] as $u => $nit) {
						echo '<li '.( isset($this->field['units']) && $unit == $u ? 'class="active"' : null ).' data-min="'.$nit['min'].'" data-max="'.$nit['max'].'" data-step="'.$nit['step'].'"><a href="#">'.$u.'</a></li>';
					}
				echo '</ul>';
			}

			// except theme options

			if( $meta ){
				echo '<input type="hidden" class="mfn-field-value" '. $this->get_name( $meta ) .' value="'. esc_attr( $this->value ) .'">';
			}

			echo '<div class="form-control">';
				echo '<input class="mfn-form-control mfn-form-input mfn-sliderbar-value" type="number" data-step="'. esc_attr( $step ) .'" data-unit="'. esc_attr( $unit ) .'" min="'. esc_attr( $min ) .'" max="'. esc_attr( $max ) .'" '. ( ! $meta ? $this->get_name( $meta ) : null ) .' value="'. esc_attr( $clean_value ) .'" placeholder="'. esc_attr( $placeholder ) .'" />';
			echo '</div>';

			if( ! empty( $this->field['after'] ) ){
				echo '<div class="form-addon-append">';
					echo '<span class="label">'. esc_attr( $this->field['after'] ) .'</span>';
				echo '</div>';
			}

			echo '<div class="sliderbar"></div>';

			if( ! $meta ){
				echo '<div class="range">'. esc_attr( $min ) .' - '. esc_attr( $max ) .'</div>';
			}

		echo '</div>';

		// theme options

		if( ! $meta ){
			echo $this->get_description();
		}
	}

	/**
	 * Enqueue
	 */

	public function enqueue()
	{
		wp_enqueue_style( 'mfn-opts-jquery-ui-css' );
		wp_enqueue_script( 'mfn-opts-field-sliderbar', MFN_OPTIONS_URI .'fields/sliderbar/field_sliderbar.js', array( 'jquery', 'jquery-ui-core', 'jquery-ui-slider' ), MFN_THEME_VERSION, true );
	}
}
